/* dhparam.c: initial DH parameters for stunnel */
#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
DH *get_dh2048(void)
{
    static unsigned char dhp_2048[] = {
        0xFF, 0x50, 0x81, 0xF5, 0x24, 0x04, 0xBE, 0x68, 0x3D, 0x8B,
        0xB0, 0xCA, 0x4F, 0x7D, 0x71, 0x49, 0xD7, 0x69, 0x5F, 0x3B,
        0x21, 0xB8, 0x99, 0xB1, 0xEB, 0x30, 0x96, 0x15, 0x05, 0xEA,
        0x7C, 0xE2, 0xD7, 0xB7, 0xB7, 0x07, 0x97, 0x0E, 0x0D, 0x36,
        0x28, 0x59, 0x83, 0xDF, 0x6F, 0x57, 0x29, 0x81, 0xE8, 0xB2,
        0xD7, 0x74, 0x16, 0x42, 0x04, 0x05, 0x3D, 0x71, 0x86, 0x25,
        0xF5, 0x81, 0x8A, 0x21, 0x78, 0x02, 0xA0, 0x08, 0x24, 0xD6,
        0xAE, 0xC2, 0x9E, 0x6C, 0x1D, 0x81, 0x3A, 0x45, 0x02, 0xF0,
        0x32, 0xAD, 0x52, 0x92, 0xF5, 0x0E, 0xAC, 0xFB, 0x47, 0x02,
        0x85, 0xDB, 0x02, 0x56, 0x5D, 0x01, 0x72, 0xDE, 0x72, 0x07,
        0xED, 0x83, 0x80, 0x2F, 0x15, 0x02, 0x71, 0xA2, 0xDA, 0xDE,
        0x09, 0x48, 0xE3, 0x87, 0x08, 0x2E, 0x56, 0x4C, 0x5C, 0xC5,
        0x6D, 0x8E, 0xC4, 0xE9, 0x26, 0x9E, 0xA7, 0xA8, 0xE9, 0x24,
        0xF4, 0xC3, 0xF3, 0x11, 0xC4, 0xA0, 0x64, 0xCB, 0xD0, 0x0B,
        0x6B, 0x49, 0xA8, 0x14, 0x77, 0xB8, 0x4E, 0x7F, 0x77, 0x3E,
        0x45, 0x5C, 0x4B, 0x3D, 0x43, 0x30, 0xB1, 0x8C, 0x24, 0x47,
        0x26, 0xCF, 0xFD, 0x7A, 0x9A, 0x38, 0x05, 0xB1, 0xCA, 0x43,
        0x84, 0x39, 0xEE, 0x7A, 0x45, 0x5F, 0x7D, 0x38, 0x8E, 0xD0,
        0x03, 0x08, 0x94, 0x84, 0xD4, 0xFC, 0x22, 0x5C, 0x27, 0x3F,
        0x1E, 0xDC, 0x06, 0x38, 0x72, 0x02, 0xDE, 0xE3, 0x50, 0xB0,
        0x23, 0x19, 0x54, 0xF2, 0xA2, 0x20, 0xDC, 0xC6, 0x2C, 0xA0,
        0xA8, 0x68, 0x87, 0xB3, 0x48, 0xCD, 0x27, 0x26, 0x21, 0x88,
        0xC5, 0x09, 0x39, 0x8F, 0xF3, 0xCE, 0x49, 0x1E, 0xF5, 0x07,
        0xB6, 0xF6, 0x28, 0xC6, 0xD7, 0xCB, 0xC4, 0x9C, 0x40, 0x48,
        0xA4, 0x9F, 0x77, 0xB4, 0x90, 0x0F, 0xC3, 0xA3, 0x9D, 0xEC,
        0xF9, 0xC0, 0xBF, 0x36, 0x5C, 0x2B
    };
    static unsigned char dhg_2048[] = {
        0x02
    };
    DH *dh = DH_new();
    BIGNUM *p, *g;

    if (dh == NULL)
        return NULL;
    p = BN_bin2bn(dhp_2048, sizeof(dhp_2048), NULL);
    g = BN_bin2bn(dhg_2048, sizeof(dhg_2048), NULL);
    if (p == NULL || g == NULL
            || !DH_set0_pqg(dh, p, NULL, g)) {
        DH_free(dh);
        BN_free(p);
        BN_free(g);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
/* built for stunnel 5.53 */
