/*
Copyright (C) 1997-1998 Erwin Waterlander, Ondrej Popp
This code is generated with Ondrej Popp's C3PO.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "std_macro.h"
#include "structures.h"
#include "error.h"
#include "text.h"
#include "WcdStack.h"

libfun(char *malloc();)
libfun(char *realloc();)
libmacro( operator  sizeof())

expfun WcdStack WcdStackNew(int maxsize)
{
   WcdStack w = (WcdStack) malloc (sizeof(WcdStack_struct));
   if (w != NULL)
   {
      w->maxsize = maxsize;
      w->lastadded = -1;
      w->current = -1;

      w->dir = NULL;
      w->size = 0;
   }
   else
      malloc_error("WcdStackNew()");

   return w;
}
expfun WcdStack copyWcdStack(WcdStack src, bool Deep)
{
   WcdStack w;

   if (src == NULL)
      return NULL;
   else
   {
      w = (WcdStack) malloc (sizeof(WcdStack_struct));
      if (w != NULL)
      {
         if (Deep == true)
         {
            w->maxsize = src->maxsize;
            w->lastadded = src->lastadded;
            w->current = src->current;
         }
         else
         {
            w->maxsize = src->maxsize;
            w->lastadded = src->lastadded;
            w->current = src->current;
         }

         w->dir = NULL;
         w->size = 0;

         if (Deep == true)
            deepExtendTextWcdStack(src, w);
         else
            extendTextWcdStack(src, w);
      }
      else
         malloc_error("copyWcdStack()");

      return w;
   }
}
expfun void addTexttoWcdStack(text t, WcdStack set)
{
   if (set->dir eq NULL)
      set->dir = (text*) malloc(sizeof(text));
   else
      set->dir = (text*) realloc((void *) set->dir, sizeof(text) * (set->size + 1));

   if (set->dir != NULL)
   {
      set->dir[set->size] = t;
      set->size = set->size + 1;
   }
   else
      malloc_error("addTexttoWcdStack()");
}
expfun void removeTextelementAtWcdStack(int position, WcdStack set, bool FreeAtPos)
{
   int index;
   if ((position >= 0) and (position < set->size))
   {
      if (FreeAtPos eq true)
      {
         if (set->dir[position] ne NULL)
            free((void *) set->dir[position]);
      }

      index = position + 1;
      while(index < set->size)
      {
         putTextelementAtWcdStack(set->dir[index], index - 1, set);
         index = index + 1;
      }
      set->size = set->size - 1;
      if (set->size > 0)
         set->dir = (text*) realloc((void *) set->dir, sizeof(text) * (set->size));
      else
      {
         free((void *) set->dir);
         set->dir = NULL;
      }
   }
}
expfun void putTextelementAtWcdStack(text t, int position, WcdStack set)
{
   int index;
   if (position >= set->size)
   {
      if ((set->dir eq NULL) or (set->size eq 0))
         set->dir = (text*) malloc(sizeof(text) * (position + 1));
      else
         set->dir = (text*) realloc((void *) set->dir, sizeof(text) * (position + 1));

      if (set->dir != NULL)
      {
         index = set->size;
         while(index < position)
         {
            set->dir[index] = NULL;
            index = index + 1;
         }
         set->size = position + 1;
      }
      else
         malloc_error("putTextelementAtWcdStack()");
   }
   set->dir[position] = t;
}
expfun void insertTextelementAtWcdStack(text t, int position, WcdStack set)
{
   int index = set->size;
   while(index > position)
   {
      putTextelementAtWcdStack(set->dir[index-1], index, set);
      index = index - 1;
   }
   putTextelementAtWcdStack(t, position, set);
}
expfun void extendTextWcdStack(WcdStack src, WcdStack dest)
{
   int index = 0;
   while(index < src->size)
   {
      addTexttoWcdStack(src->dir[index], dest);
      index = index + 1;
   }
}
expfun void deepExtendTextWcdStack(WcdStack src, WcdStack dest)
{
   int index = 0;
   while(index < src->size)
   {
      addTexttoWcdStack(textNew(src->dir[index]), dest);
      index = index + 1;
   }
}
expfun void printWcdStack(text Offset, WcdStack w, FILE* fp)
{
   int index;

   text increment = "   ";
   text new_Offset = (text) malloc(sizeof(char) * (strlen(Offset) + strlen(increment) + 1));
   sprintf(new_Offset, "%s%s", Offset, increment);

   fprintf(fp, "%s{\n", Offset);

   if (w == NULL)
   {
      fprintf(fp, "%sNULL\n", new_Offset);
      fprintf(fp, "%s}\n", Offset);
   }
   else
   {

      fprintf(fp, "%sint maxsize : %d\n", new_Offset, w->maxsize);

      fprintf(fp, "%sint lastadded : %d\n", new_Offset, w->lastadded);

      fprintf(fp, "%sint current : %d\n", new_Offset, w->current);

      if (w->dir == NULL)
         fprintf(fp, "%stext dir : NULL\n", new_Offset);
      else
      {

         fprintf(fp, "%sint size : %d\n", new_Offset, w->size);

         index = 0;
         while(index < w->size)
         {
            if (w->dir[index] ne NULL)
               fprintf(fp, "%stext dir[%d] : %s\n", new_Offset, index, w->dir[index]);
            else
               fprintf(fp, "%stext dir[%d] : NULL\n", new_Offset, index);
            index = index + 1;
         }
      }

      fprintf(fp, "%s} <- end WcdStack\n", Offset);
   }
}
expfun void FreeWcdStack(WcdStack w, bool Deep)
{
   int index;

   if (w ne NULL)
   {
      if (Deep eq true)
      {

         index = 0;
         while(index < w->size)
         {
            if (w->dir[index] ne NULL)
               free((void *) w->dir[index]);

            index = index + 1;
         }
      }

      if (w->dir ne NULL)
      {
         free((void *) w->dir);
         w->dir = NULL;
         w->size = 0;
      }

      free((void *) w);
   }
}
