#include <stdio.h>
#include <stdlib.h>			/* for exit() */

#include <dos.h>			/* for clock() */
#include <time.h>			/* for clock() */
#include <process.h>			/* for exec() */


void help (void);


int
main (int argc, char **argv)
{
  int i;
  clock_t begin, end;

  /* Check command line */

  if (argc == 1)
    {
      help();
      exit (1);
    }

  if (argv[1][0] == '/')
    {
      help();
      exit (1);
    }

  /* Shift argv, and terminate with NULL */

  for (i = 1; i < argc;  i++)
    {
      argv[i-1] = argv[i];
    }

  argc--;
  argv[argc] = NULL;

  /* Start the timer, run it, then stop the timer */

  begin = clock();
  spawnvp (P_WAIT, argv[0], argv);
  end = clock();

  /* Print results and quit */

  printf ("Run time was %f seconds\n", (end - begin) / CLK_TCK);
  exit (0);
}

void
help (void)
{
  /* print the help message, and return */

  fprintf (stderr, "RUNTIME - Determine the run time for a program.\n");
  fprintf (stderr, "usage: RUNTIME {program} [program opts]\n");
}
