;=============================================================================
; dos_prt.inc:	ASCIIZ-string printing procedures (via INT 21h)
;
; Copyright (c) 2006, 2007 Oleg O. Chukaev.
; This code is free software distributed under the terms of the GNU GPL.
; See the file COPYING or http://www.gnu.org/licenses/licenses.html.
;
;-----------------------------------------------------------------------------
; Procedures:
;	dos_print	dos_err_print
;
; Macros:
;	define_dos_print		define_dos_err_print
;
; Used global variables:
;	---
;
; Used global constants:
;	CR		LF		STDERR		DOS_WRITE_FILE
;=============================================================================


;=============================================================================
; dos_print
;-----------------------------------------------------------------------------
; Prints ASCIIZ-string via INT 21h, assuming DF == 0. All LFs in string
; replaced by CR, LF.
; In:	DS:SI -> ASCIIZ-string
; Out:	---
; Modf:	SI
; Call:	---
; Use:	---
;
%macro		define_dos_print	0
dos_print:
		push	ax
		push	dx
		mov	ah,2
@@next_byte:
		lodsb
		or	al,al
		jz	@@quit
		cmp	al,LF
		jne	@@print
		mov	dl,CR
		int	21h
		mov	al,LF
@@print:
		mov	dl,al
		int	21h
		jmp	@@next_byte
@@quit:
		pop	dx
		pop	ax
		ret
%endmacro
;
;=============================================================================
; dos_err_print
;-----------------------------------------------------------------------------
; Prints ASCIIZ-string via INT 21h to STDERR, assuming DF == 0.
; In:	DS:SI -> ASCIIZ-string
; Out:	---
; Modf:	---
; Call:	---
; Use:	---
;
%macro		define_dos_err_print	0
dos_err_print:
		push	ax
		push	bx
		push	cx
		push	dx
		push	si
@@loop:
		lodsb
		or	al,al
		jz	@@quit
		mov	ah,DOS_WRITE_FILE
		mov	bx,STDERR	;stderr's handle
		mov	cx,1		;Number of bytes to write
		mov	dx,si		;Pointer to data
		dec	dx
		int	21h
		jmp	@@loop
@@quit:
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	ax
		ret
%endmacro
;
;=============================================================================
; E0F
;=============================================================================


