puts("wc - print the number of bytes, words, and lines in files");
puts("");
puts("The wc program counts the number of bytes, whitespace-separated words,");
puts("and newlines in a given file, or the standard input if none are given or");
puts("when a file named \'-\' is given.  It prints one line of counts for each");
puts("file, and if the file was given as an argument, it prints the filename");
puts("following the counts. If more than one filename is given, wc prints a");
puts("final line containing the cumulative counts, with the filename \'total\'.");
puts("The counts are printed in the order: lines, words, characters (if");
puts("specified), bytes, the maximum number of characters in a line.");
puts("");
puts("By default, wc prints all three counts. Options can specify that only");
puts("certain counts be printed.  Options do not undo others previously given,");
puts("so wc --bytes --words prints both the byte counts and word counts.");
puts("");
puts("OPTIONS:");
puts("");
puts("-c, --bytes                  Print only the byte counts.");
puts("");
puts("-l, --lines                  Print only the newline counts.");
puts("");
puts("-m, --chars                  Print only the character counts.");
puts("");
puts("-w, --words                  Print only the word counts.");
puts("");
puts("-L, --max-line-length        Print only the maximum line width of a file.");
puts("                             Tabs are considered to be moving the column");
puts("                             to a multiple of 8; nonprintable characters");
puts("                             have a width of zero.");
puts("                             ");
puts("--files0-from=FILE           Get the filenames from a file instead of the");
puts("                             command line.  Within the file, the names are");
puts("                             delimited with null characters.  This option");
puts("                             is useful with the output of the find command");
puts("                             with the -print0 option.");
puts("");
puts("--help                       Print a usage message and exit with a non-zero");
puts("                             status.");
puts("                             ");
puts("--version                    Print version information on standard output");
puts("                             then exit.");
puts("");
