;--------------------------------------------------------------------------------------------------------------------------------------------------------------
.8086
.model tiny
.stack 64
.code
org 100h


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
.startup

;Parse command-line options
mov ax, word ptr ds:[82h]
.switch ax
	.case 'h-', 'H-', '?-', 'h/', 'H/', '?/'
		call ShowHelp
	.endc
	.case 'r-', 'R-', 'r/', 'R/'
		mov dx, offset acReset
		call PrintText
		call DoReset
	.endc
	.default
		call DoIt
.endsw
.exit



;--------------------------------------------------------------------------------------------------------------------------------------------------------------
DoIt proc 
	;Print current time
	call GetCurrentTime
	call GetAlarmTime

	;If last time is zero, force automatic reset
	mov ax, word ptr [lSecondsA]
	mov dx, word ptr [lSecondsA+2]
	.if (dx == 0)
		.if (ax == 0)
			call DoReset
		.endif
	.endif

	xor ah, ah
	mov al, iHour
	mov si, 2
	call PrintNumber0
	mov al, ':'
	call PrintChar

	xor ah, ah
	mov al, iMinute
	mov si, 2
	call PrintNumber0
	mov al, ':'
	call PrintChar

	xor ah, ah
	mov al, iSecond
	mov si, 2
	call PrintNumber0

	mov dx, offset acStart
	call PrintText
	
	;Substract seconds from startup seconds
	mov ax, word ptr [lSeconds]
	mov dx, word ptr [lSeconds+2]
	mov bx, word ptr [lSecondsA]
	mov cx, word ptr [lSecondsA+2]
	sub ax, bx
	sbb dx, cx
	;mov word ptr [lSecondsE], ax
	;mov word ptr [lSecondsE+2], dx

	;mov ax, word ptr [lSecondsE]
	;mov dx, word ptr [lSecondsE+2]

	;Print hours elapsed
	mov bx, 3600
	div bx
	call PrintNumber
	mov ax, dx
	mov dx, offset acHour
	call PrintText

	;Print minutes elapsed
	xor dx, dx
	mov bx, 60
	div bx
	call PrintNumber
	mov ax, dx
	mov dx, offset acMinute
	call PrintText

	;Print seconds elapsed
	call PrintNumber
	mov dx, offset acSecond
	call PrintText
	
	;Return
	xor al, al
	ret
DoIt endp

;--------------------------------------------------------------------------------------------------------------------------------------------------------------
DoReset proc uses ax
	;push ax

	xor al, al
	out 70h, al
	in al, 71h
	xchg ah, al
	mov al, 1
	out 70h, al
	xchg ah, al
	out 71h, al
	
	;Check CMOS is present
	xchg ah, al
	mov al, 1
	out 70h, al
	in al, 71h
	.if (al != ah)
		mov dx, offset acNoCMOS
		call PrintText
		.exit
	.endif
		
	mov al, 2
	out 70h, al
	in al, 71h
	xchg ah, al
	mov al, 3
	out 70h, al
	xchg ah, al
	out 71h, al

	mov al, 4
	out 70h, al
	in al, 71h
	xchg ah, al
	mov al, 5
	out 70h, al
	xchg ah, al
	out 71h, al
	
	call GetAlarmTime
	
	;pop ax
	ret
DoReset endp



;--------------------------------------------------------------------------------------------------------------------------------------------------------------
ShowHelp proc
	mov dx, offset acCopyright
	call PrintText
	
	call ReadChar
	
	mov dx, offset acCrLf
	call PrintText
	
	;Return
	mov al, -1
	ret
ShowHelp endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
GetCurrentTime proc uses ax bx dx
	;push ax
	;push bx
	;push dx
	
	xor al, al
	out 70h, al
	in al, 71h
	call BCD2Bin
	mov iSecond, al

	mov al, 2
	out 70h, al
	in al, 71h
	call BCD2Bin
	mov iMinute, al

	mov al, 4
	out 70h, al
	in al, 71h
	call BCD2Bin
	.if (al > 81h)
		sub al, 75h
	.endif	
	mov iHour, al
	
	;Fill lSeconds with total number of seconds
	xor ah, ah
	mov al, iSecond
	mov word ptr [lSeconds], ax
	
	xor ah, ah
	mov al, iMinute
	mov bx, 60
	mul bx
	add word ptr [lSeconds], ax
	
	xor ah, ah
	mov al, iHour
	mov bx, 3600
	mul bx
	add word ptr [lSeconds], ax
	adc word ptr [lSeconds+2], dx
	
	;pop dx
	;pop bx
	;pop ax
	ret
GetCurrentTime endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
GetAlarmTime proc uses ax bx dx
	;push ax
	;push bx
	;push dx
	
	mov al, 1
	out 70h, al
	in al, 71h
	call BCD2Bin
	mov iSecondA, al

	mov al, 3
	out 70h, al
	in al, 71h
	call BCD2Bin
	mov iMinuteA, al

	mov al, 5
	out 70h, al
	in al, 71h
	call BCD2Bin
	.if (al > 81h)
		sub al, 75h
	.endif	
	mov iHourA, al
	
	;Fill lSeconds with total number of seconds
	xor ah, ah
	mov al, iSecondA
	mov word ptr [lSecondsA], ax
	
	xor ah, ah
	mov al, iMinuteA
	mov bx, 60
	mul bx
	add word ptr [lSecondsA], ax
	
	xor ah, ah
	mov al, iHourA
	mov bx, 3600
	mul bx
	add word ptr [lSecondsA], ax
	adc word ptr [lSecondsA+2], dx
	
	;pop dx
	;pop bx
	;pop ax
	ret
GetAlarmTime endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Number in AL
BCD2Bin proc uses bx
	;  ( (bcd & 0xF0) >> 1) + ( (bcd & 0xF0) >> 3) + (bcd & 0xf)].
	; (bcd / 16) * 10) + (bcd & 0xf)
	
	;push bx

	mov ah, al
	
	and al, 0f0h
	shr al, 1
	mov bl, al
	
	mov al, ah
	and al, 0f0h
	
	;186 or later
	if @cpu and 10b
		shr al, 3
	else
		rept 3
			shr al, 1
		endm
	endif

	add bl, al
	
	mov al, ah
	and al, 0fh
	add bl, al
	
	mov al, bl	
	
	;pop bx
	ret
BCD2Bin endp
	
	
;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Text in DX
PrintText proc uses ax
	;push ax
	mov ah, 9
	int 21h
	;pop ax
	ret
PrintText endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Returns char in AL
ReadChar proc
	mov ah, 8
	int 21h
	ret
ReadChar endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Char in AL
PrintChar proc uses dx
	;push dx
	mov ah, 2
	mov dl, al
	int 21h
	;pop dx
	ret
PrintChar endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Number in AX
PrintNumber proc uses ax bx cx dx
	;push ax
	;push bx
	;push cx
	;push dx
	
	xor cx, cx
	mov bx, 10

	.repeat
		xor dx, dx
		div bx	;divide by ten

		push ax
		add dl, '0'		;convert dl to ascii
		pop ax			;restore ax

		push dx			;digits are in reversed order, must use stack
		inc cx			;remember how many digits we pushed to stack
		test ax, ax		;if ax is zero, we can quit
	.until zero?		;jnz

	;cx is already set
	mov ah, 2			;2 is the function number of output char in the DOS Services.
	PrintNumberLoop:
		pop dx			;restore digits from last to first
		int 21h		;calls DOS Services
	loop PrintNumberLoop

	;pop dx
	;pop cx
	;pop bx
	;pop ax

	ret
PrintNumber endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
;Number in AX, Digits in SI
PrintNumber0 proc uses ax bx cx dx
	;push ax
	;push bx
	;push cx
	;push dx
	
	xor cx, cx
	mov bx, 10

	.repeat
		xor dx, dx
		div bx	;divide by ten

		push ax
		add dl, '0'		;convert dl to ascii
		pop ax			;restore ax

		push dx			;digits are in reversed order, must use stack
		inc cx			;remember how many digits we pushed to stack
		test ax, ax		;if ax is zero, we can quit
	.until zero?		;jnz

	;cx is already set
	;mov ah, 2			;2 is the function number of output char in the DOS Services.
	push cx
	sub si, cx
	.if (si > 0)
		mov cx, si
		mov dl, '0'
		mov ah, 2
		PrintNumber0Loop0:
			int 21h			;fast DOS output
		loop PrintNumber0Loop0
	.endif
	pop cx
	mov ah, 2
			
	PrintNumber0Loop:
		pop dx			;restore digits from last to first
		int 21h		;calls DOS Services
	loop PrintNumber0Loop

	;pop dx
	;pop cx
	;pop bx
	;pop ax

	ret
PrintNumber0 endp


;--------------------------------------------------------------------------------------------------------------------------------------------------------------
.data
lSeconds		dd ?
lSecondsA		dd ?
;lSecondsE		dd ?
;iYear			dw ?
;iMonth			db ?
;iDay			db ?
iHour			db ?
iMinute			db ?
iSecond			db ?
iYearA			dw ?
iMonthA			db ?
iDayA			db ?
iHourA			db ?
iMinuteA		db ?
iSecondA		db ?
acStart			db " up " , '$'
acHour			db " hour, " , '$'
acMinute		db " minute, " , '$'
acSecond		db " second, "
acEnd			db "1 user, load average: 0.00, 0.00, 0.00", 13, 10, '$'
acCrLf			db 13, 10, '$'
acReset			db "Uptime counter reseted to zero.", 13, 10, '$'
acNoCMOS		db "No CMOS available to write.", 13, 10, '$'
acCopyright 	db 13, 10
				db "UPTIME R2.30                       (c) 2017 by Javier Gutierrez Chamorro (Guti)", 13, 10
				db "Display system uptime under DOS", 13, 10, 10
acHelp			db "UPTIME displays DOS uptime, by automatically detecting when it was firstly", 13, 10
				db "booted, mimicing its UNIX counterparts.", 13, 10, 10
				db "Syntax is: UPTIME [-h|-r]", 13, 10, 10
				db "Examples:", 13, 10, 10
				db "	UPTIME -h", 13, 10
				db "	Shows this help screen.", 13, 10, 10
				db "	UPTIME -r", 13, 10
				db "	Forces reseting the counter. Useful if it is not automatically detected", 13, 10
				db "	properly during startup.", 13, 10, 10
				db "More information at:", 13, 10
				db "	http://nikkhokkho.sourceforge.net/static.php?page=UPTIME", 13, 10
				db "Press ENTER to continue..."
				db '$'
end