;#errors off
;#short


function bcd_to_bin(piByte)
{
	piByte = ((piByte and 0f0h) / 16) * 10 + (piByte and 0fh)
	return(piByte)
}

unsigned iSecond, iMinute, iHour
unsigned iSecondA, iMinuteA, iHourA
unsigned iElapsed

print dos ""
print dos "UPTIME R1.00	            Copyright (c) 2017 by Javier Gutierrez Chamorro (Guti)"
print dos "Show DOS system uptime"
print dos ""

;Get RTC seconds
reg ax = 0
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iSecond = low reg ax

;Get RTC minutes
reg ax = 2
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iMinute = low reg ax

;Get RTC hours
reg ax = 4
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iHour = low reg ax

;Correct to 24 hour mode if in 12 hour mode
if iHour > 81 then
{
	iHour -= 69
}

;Get alarm seconds
reg ax = 1
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iSecondA = low reg ax

;Get alarm minutes
reg ax = 3
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iMinuteA = low reg ax

;Get alarm hours
reg ax = 5
inline 0e6h, 70h 	;out 70h, al
inline 0e4h, 71h	;in al, 71h   
iHourA = low reg ax


;If invalid alarm, then it is first execution
if (iHourA = 0) and (iMinuteA = 0) and (iSecondA = 0) or ((iHourA > 92h) and (iMinuteA > 59h) and (iSecondA > 59h)) then
{
	iHourA = iHour
	iMinuteA = iMinute
	iSecondA = iSecond

	;Set alarm seconds
	reg ax = 1
	inline 0e6h, 70h 	;out 70h, al
	reg ax = iSecondA
	inline 0e6h, 71h	;out 71h, al
	
	;Set alarm minutes
	reg ax = 3
	inline 0e6h, 70h 	;out 70h, al
	reg ax = iMinuteA
	inline 0e6h, 71h	;out 71h, al

	;Set alarm hours
	reg ax = 5
	inline 0e6h, 70h 	;out 70h, al
	reg ax = iHourA
	inline 0e6h, 71h	;out 71h, al
}

iSecond = bcd_to_bin(iSecond) + (bcd_to_bin(iMinute) * 60) + (bcd_to_bin(iHour) * 3600)
iSecondA = bcd_to_bin(iSecondA) + (bcd_to_bin(iMinuteA) * 60) + (bcd_to_bin(iHourA) * 3600)
iElapsed = iSecond - iSecondA

iHour = iElapsed / 3600;
lElapsed = iElapsed mod 3600;
iMinute = iElapsed / 60;
lElapsed = iElapsed mod 60;
iSecond = iElapsed;

print dos "System uptime is ";
if iHour > 0 then
{
	print dos iHour; "h:";
}
if (iHour > 0) or (iMinute > 0) then
{
	print dos iMinute; "m:";
}
print dos iSecond; "s"

