/* true.c - do nothing, successfully

   AUTHOR: Gregory Pietsch
   
*/

#include <ctype.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include "getopt.h"
#include "config.h"

/* globals */
int show_help = 0, show_version = 0;
static struct option longopts[] = {
  {"help", 0, &show_help, 1},
  {"version", 0, &show_version, 1},
  {0, 0, 0, 0}
};

/* functions */

/* help: show the help message */
void
help (void)
{
  puts ("true - do nothing and exit successfully");
  puts ("");
  puts ("OPTIONS:");
  puts ("");
  puts ("--help                           Print the help message.");
  puts ("--version                        Print the version number.");
  puts ("");
  puts
    ("This program exits with 0 normally and a non-zero value if --help or");
  puts ("--version are on the command line.");
}

/* version: show the version message */
void
version (void)
{
  puts (PACKAGE_STRING);
}

/* parse_args: parse the command-line arguments */
void
parse_args (int c, char *v[])
{
  int o;
  while ((o = getopt_long (c, v, 0, longopts, 0)) != EOF)
    {
      switch (o)
	{
	case 0:		/* --help and --version */
	  if (show_help)
	    help ();
	  if (show_version)
	    version ();
	  exit (EXIT_FAILURE);
	default:
	  break;
	}
    }
}

int
main (int c, char *v[])
{
  parse_args (c, v);
  return 0;
}

/* END OF FILE */
