/*
 *  head - print the top of a file
 *  Copyright (C) 2016-2017 David McMackins II
 *
 *  Copying and distribution of this file, with or without modification,
 *  are permitted in any medium without royalty provided the copyright
 *  notice and this notice are preserved. This file is offered as-is,
 *  without any warranty.
 */

#include <stdio.h>

#include "switch.h"

enum jobtype
{
	LINES = 'N',
	CHARS = 'C'
};

int
main(int argc, char *argv[])
{
	char *optarg;
	enum jobtype jobtype = LINES;
	FILE *f = stdin;
	int rc, c, optind = 1, left = 10;

	reorder_argv(argc, argv);
	while ((c = getswitch(argc, argv, "CNVH?", &optind, &optarg))
		!= SWITCH_END)
	{
		switch (c)
		{
		case 'C':
		case 'N':
			if (!optarg)
			{
				fprintf(stderr,
					"HEAD: switch /%c requires an argument\r\n",
					c);
				return 1;
			}

			jobtype = c;

			rc = sscanf(optarg, "%d", &left);
			if (rc != 1 || left < 0)
			{
				fprintf(stderr,
					"HEAD: %s is an invalid number\r\n",
					optarg);
				return 1;
			}
			break;

		case 'V':
			printf("HEAD for DOS v0.1.1\r\nCopyright (C) 2016-2017 David McMackins II\r\n");
			return 0;

		case 'H':
		case '?':
			printf("Usage: HEAD [/C:BYTES] [/N:LINES] [/H | /?] [FILE]\r\n");
			return 0;

		case SWITCH_UNKNOWN:
			fprintf(stderr,
				"HEAD: unknown switch '/%c'. See 'HEAD /?' for usage.\r\n",
				c);
			return 1;
		}
	}

	if (argc > optind)
	{
		if (argc - optind > 1)
		{
			fprintf(stderr, "HEAD: multiple input files\r\n");
			return 1;
		}

		f = fopen(argv[optind], "rb");
		if (!f)
		{
			fprintf(stderr, "HEAD: failed to open %s\r\n",
				argv[optind]);
			return 1;
		}
	}

	rc = 0;

	while (left && ((c = fgetc(f)) != EOF))
	{
		if (putchar(c) == EOF)
		{
			fprintf(stderr, "HEAD: error writing\r\n");
			rc = 1;
			goto end;
		}

		if ('\n' == c || CHARS == jobtype)
			--left;
	}

end:
	if (f != stdin)
		fclose(f);

	return !!rc;
}
