/*
 *  cat - concatenate files
 *  Copyright (C) 2016-2017 David McMackins II
 *
 *  Copying and distribution of this file, with or without modification,
 *  are permitted in any medium without royalty provided the copyright
 *  notice and this notice are preserved. This file is offered as-is,
 *  without any warranty.
 */

#include <stdio.h>

#include "switch.h"

int
main(int argc, char *argv[])
{
	char *optarg;
	int c, optind = 1;

	reorder_argv(argc, argv);
	while ((c = getswitch(argc, argv, "VH?", &optind, &optarg))
		!= SWITCH_END)
	{
		switch (c)
		{
		case 'V':
			printf("CAT for DOS v0.1.1\r\nCopyright (C) 2016-2017 David McMackins II\r\n");
			return 0;

		case 'H':
		case '?':
			printf("Usage: CAT [/V] [/H | /?] [FILE]...\r\n");
			return 0;

		case SWITCH_UNKNOWN:
			fprintf(stderr,
				"CAT: unknown switch '/%c'. See 'CAT /?' for usage.\r\n",
				c);
			return 1;
		}
	}

	if (optind == argc)
	{
		while ((c = getchar()) != EOF)
			if (putchar(c) == EOF)
			{
				fprintf(stderr, "CAT: error writing\r\n");
				return 1;
			}

		return 0;
	}

	for (; optind < argc; ++optind)
	{
		int rc = 0;
		FILE *f = fopen(argv[optind], "rb");
		if (!f)
		{
			fprintf(stderr, "CAT: error opening %s\r\n",
				argv[optind]);
			return 1;
		}

		while ((c = fgetc(f)) != EOF)
			if (putchar(c) == EOF)
			{
				fprintf(stderr, "CAT: error writing\r\n");
				rc = 1;
				break;
			}

		fclose(f);
		if (rc)
			return rc;
	}

	return 0;
}
