#define	CURSES_LIBRARY	1
#include <curses.h>

#ifdef PDCDEBUG
char *rcsid__gcurrow = "$Header: C:\CURSES\private\RCS\_gcurrow.c 2.1 1993/06/18 20:23:21 MH Rel MH $";
#endif




/*man-start*********************************************************************

  PDC_get_cur_row()	- get current row position of cursor

  PDCurses Description:
 	This is a private PDCurses function

 	This routine returns the current row position of the cursor on
 	screen.

  PDCurses Return Value:
 	This routine returns the current row position of the cursor. No
 	error is returned.

  PDCurses Errors:
 	There are no defined errors for this routine.

  Portability:
 	PDCurses	int	PDC_get_cur_row( void );

**man-end**********************************************************************/

int	PDC_get_cur_row(void)
{
#ifdef	OS2
	USHORT curCol, curRow;
#endif

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("PDC_get_cur_row() - called\n");
#endif

#ifdef	FLEXOS
	retcode = s_get(T_VIRCON, 1L, (char *) &vir, (long) sizeof(vir));
	return( (retcode < 0L) ? ERR : vir.vc_cursor.pos_col );
#endif

#ifdef	DOS
	regs.x.ax = 0x0003;
	regs.h.bh = _cursvar.video_page;
	int86(0x10, &regs, &regs);
	return ((int) regs.h.dh);
#endif

#ifdef	OS2
	/* find the current cursor position */
	VioGetCurPos ((PUSHORT) &curRow, (PUSHORT) &curCol, 0);
	return (curRow);
#endif

#ifdef UNIX
/* INCOMPLETE */
#endif
}
