#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	werase

#ifdef PDCDEBUG
char *rcsid_werase = "$Header: C:\CURSES\portable\RCS\werase.c 2.1 1993/06/18 20:19:29 MH Rel MH $";
#endif




/*man-start*********************************************************************

  werase()	- copy blanks into window

  X/Open Description:
 	These functions copy blanks to every position in the window.

 	NOTE: erase() is a macro.

  PDCurses Description:
 	There is no additional PDCurses functionality.

  X/Open Return Value:
 	These functions return OK on success and ERR on error.

  PDCurses Errors:
 	It is an error to call this function with a NULL window pointer.

  Portability:
 	PDCurses	int werase( WINDOW* win );
 	X/Open Dec '88	int werase( WINDOW* win );
 	BSD Curses	int werase( WINDOW* win );
 	SYS V Curses	int werase( WINDOW* win );

**man-end**********************************************************************/

int	werase(WINDOW *win)
{
	chtype*	end;
	chtype*	start;
	int	y;
	chtype	blank;

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("werase() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	blank = win->_blank | win->_attrs;

	for (y = win->_tmarg; y <= win->_bmarg; y++)
	{
		start = win->_y[y];
		end = &start[win->_maxx - 1];
/* changed JGB 6/92 < to <= */
		while (start <= end)
		{
			*start++ = blank;
		}
		win->_firstch[y] = 0;
		win->_lastch[y] = win->_maxx - 1;
	}
	win->_cury = win->_tmarg;
	win->_curx = 0;
	return( OK );
}

