#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	ungetch

#ifdef PDCDEBUG
char *rcsid_ungetch = "$Header: C:\CURSES\portable\RCS\ungetch.c 2.1 1993/06/18 20:21:24 MH Rel MH $";
#endif




/*man-start*********************************************************************

  ungetch()	- pushes a character back onto the input stream

  PDCurses Description:
 	There is only one input stream to ungetch characters onto.  It
 	is of size NUNGETCH.

  PDCurses Return Value:
 	The ungetch() routine returns OK upon success otherwise ERR is
 	returned.

  PDCurses Errors:
 	ERR will be returned when the push back stack is full.

  Portability:
 	PDCurses	ungetch( chtype ch );
 	SysV Curses	
 	BSD Curses	

**man-end**********************************************************************/

int	ungetch(chtype ch)
{
extern	int	c_pindex;		/* putter index */
extern	int	c_gindex;		/* getter index */
extern	int	c_ungind;		/* wungetch() push index */
extern	chtype	c_ungch[NUNGETCH];	/* array of ungotten chars */

#ifdef PDCDEBUG
	if (trace_on) PDC_debug("ungetch() - called\n");
#endif

	if (c_ungind >= NUNGETCH)	/* pushback stack full */
		return( ERR );

	c_ungch[c_ungind++] = ch;
	return( OK );
}
