#define	CURSES_LIBRARY	1
/*#define NEEDS_OS2       1*/
#include <curses.h>
#undef	delay_output

#if defined(DOS) && defined(MSC)
#include <time.h>
#endif

#ifdef PDCDEBUG
char *rcsid_delay_ou = "$Header: C:\CURSES\portable\RCS\delay_ou.c 2.1 1993/06/18 20:19:09 MH Rel MH $";
#endif

#ifdef OS2
	APIRET APIENTRY DosSleep(ULONG ulTime);
#endif


/*man-start*********************************************************************

  delay_output()	- cause short delay

  X/Open Description:
 	Insert ms millisecond pause in output.  On some systems, this
 	has no effect.

  PDCurses Description:
 	This routine relies on the compiler's delay() routine and
 	provides this x millisecond granularity to the application.

  X/Open Return Value:
 	The delay_output() function returns OK on success and ERR on error.

  PDCurses Errors:
 	If this function is a nop, then an ERR is returned.

  Portability:
 	PDCurses	int delay_output( int ms );
 	X/Open Dec '88	int delay_output( int ms );
 	BSD Curses	
 	SYS V Curses	

**man-end**********************************************************************/

int	delay_output( int ms )
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("delay_output() - called: ms %d\n",ms);
#endif

#if defined(TC) && defined(DOS)
	delay( ms );
	return( OK );
#endif

#if	defined(OS2)
	DosSleep(ms);
	return( OK );
#endif

#if	defined(DOS) && defined(MSC)
	PDC_usleep((clock_t)ms);
	return( OK );
#endif

#if defined(UNIX) || defined(EMX) || defined(GO32)
	usleep(1000*ms);
	return( OK );
#endif
}
