#define	CURSES_LIBRARY	1
#include <curses.h>
#undef	wborder

#ifdef PDCDEBUG
char *rcsid_wborder = "$Header: C:\CURSES\nonport\RCS\wborder.c 2.1 1993/06/18 20:22:21 MH Rel MH $";
#endif




/*man-start*********************************************************************

  wborder()	- sets the border characters in the passed window.

  PDCurses Description:
 	This routine sets the border characters for the passed window.

  PDCurses Return Value:
 	This function returns OK upon success otherwise ERR is returned.

  PDCurses Errors:
 	It is an error for stdscr to be a NULL pointer.

  Portability:
 	PDCurses	int wborder( chtype l,  chtype r,  chtype t,  chtype b,
 				    chtype tl, chtype tr  chtype bl, chtype br );

**man-end**********************************************************************/

int	wborder(WINDOW *win,chtype l,chtype r,chtype t,chtype b,chtype tl,chtype tr,chtype bl,chtype br)
{
#ifdef PDCDEBUG
	if (trace_on) PDC_debug("wborder() - called\n");
#endif

	if (win == (WINDOW *)NULL)
		return( ERR );

	win->_borderchars[0] = l;
	win->_borderchars[1] = r;
	win->_borderchars[2] = t;
	win->_borderchars[3] = b;
	win->_borderchars[4] = tl;
	win->_borderchars[5] = tr;
	win->_borderchars[6] = bl;
	win->_borderchars[7] = br;
	return( OK );
}
