/*
* $Header: C:\CURSES\RCS\curspriv.h 2.1 1993/06/18 20:18:46 MH Rel MH $
*
*                          CURSPRIV.H
*
* Header file for definitions and declarations for the
* PDCurses package. These definitions should not be generally
* accessible to programmers, but are provided if the applications
* programmer decides to make the decision in favor of speed on a
* PC over portability.
*
* Revision History:
* Frotz 1.5Beta 900714  Added many levels of compiler support.
*                       Added mixed prototypes for all "internal" routines.
*                       Removed all assembly language.  Added EGA/VGA
*                       support.  Converted all #ifdef to #if in all
*                       modules except CURSES.H and CURSPRIV.H.
*                       Always include ASSERT.H.  Added support for an
*                       external malloc(), calloc() and free().
*                       Added support for FAST_VIDEO (direct-memory writes).
*                       Added various memory model support (for FAST_VIDEO).
*                       Added much of the December 1988 X/Open Curses
*                       specification.
* bl    1.3     881005  All modules lint-checked with MSC '-W3' and turbo'C'
*                       '-w -w-pro' switches.
* bl    1.2     881002  Support (by #ifdef UCMASM) for uppercase-only
*                       assembly routine names. If UCMASM if defined,
*                       all assembler names are #defined as upper case.
*                       Not needed if you do "MASM /MX. Also missing
*                       declaration of cursesscroll(). Fixes thanks to
*                       N.D. Pentcheff
* bl    1.1     880306  Add _chadd() for raw output routines.
* bl    1.0     870515  Release.
*
*/

#ifndef __CURSES_INTERNALS__
#define __CURSES_INTERNALS__

/* Always include... */
#include <assert.h>



/*----------------------------------------------------------------------
*       MEMORY MODEL SUPPORT:
*
*       MODELS
*               TINY            cs,ds,ss all in 1 segment (not enough memory!)
*               SMALL           cs:1 segment,           ds:1 segment
*               MEDIUM          cs:many segments        ds:1 segment
*               COMPACT         cs:1 segment,           ds:many segments
*               LARGE           cs:many segments        ds:many segments
*               HUGE            cs:many segments        ds:segments > 64K
*/
#ifdef  __TINY__
#  define SMALL 1
#endif
#ifdef  __SMALL__
#  define SMALL 1
#endif
#ifdef  __MEDIUM__
#  define MEDIUM 1
#endif
#ifdef  __COMPACT__
#  define COMPACT 1
#endif
#ifdef  __LARGE__
#  define LARGE 1
#endif
#ifdef  __HUGE__
#  define HUGE 1
#endif


/*----------------------------------------------------------------------
*       OPERATING SYSTEM SUPPORT:
*
*               DOS             The one we all know and love:-}
*               OS/2            The new kid on the block.
*               FLEXOS          A Real-time, protected-mode OS from
*                               Digital Research, Inc.
*				(AKA, the 4680 from IBM...)
*/

/*----------------------------------------*/
#ifdef  DOS
#  define FAST_VIDEO 1          /* We can write directly to the screen. */
   typedef union REGS Regs;
   extern Regs regs;
#  ifdef GO32
#    define _FAR_POINTER(s,o)	(0xe0000000 + s*16 + o)
#    define _FP_SEGMENT(p)		(unsigned short)((((long)fp) >> 4) & 0xffff)
#    define _FP_OFFSET(p)		((unsigned short)fp & 0x000f)
#  else
#    ifdef __TURBOC__
/*#      define _FAR_POINTER(s,o)	((unsigned long)s * 16 + (unsigned long)o)*/
#      define _FAR_POINTER(s,o)	MK_FP(s,o)
#    else
#      define _FAR_POINTER(s,o)	(((long)s << 16) | (long)o)
#    endif
#    define _FP_SEGMENT(p)		(unsigned short)(((long)fp) >> 4)
#    define _FP_OFFSET(p)		((unsigned short)fp & 0x000f)
#  endif

#  ifdef GO32
     unsigned char getdosmembyte (int offs);    /* see: private\_dosmem.c */
     unsigned short getdosmemword (int offs);
     void setdosmembyte (int offs, unsigned char b);
     void setdosmemword (int offs, unsigned short w);
#  else
#    if SMALL || MEDIUM || MSC
#      define getdosmembyte(offs)    (*((unsigned char far *) _FAR_POINTER(0,offs)))
#      define getdosmemword(offs)    (*((unsigned short far *) _FAR_POINTER(0,offs)))
#      define setdosmembyte(offs,x)  (*((unsigned char far *) _FAR_POINTER(0,offs)) = (x))
#      define setdosmemword(offs,x)  (*((unsigned short far *) _FAR_POINTER(0,offs)) = (x))
#    else
#      define getdosmembyte(offs)    (*((unsigned char *) _FAR_POINTER(0,offs)))
#      define getdosmemword(offs)    (*((unsigned short *) _FAR_POINTER(0,offs)))
#      define setdosmembyte(offs,x)  (*((unsigned char *) _FAR_POINTER(0,offs)) = (x))
#      define setdosmemword(offs,x)  (*((unsigned short *) _FAR_POINTER(0,offs)) = (x))
#    endif
#  endif
#endif

/*----------------------------------------*/
#ifdef  FLEXOS
#  define FAST_VIDEO 1          /* We can use scopy()   */
#  define GMODE  0 /* KLUDGE ALERT!
                   * GMODE == 0 defines character mode structures in FLEXTAB.H.
                   * GMODE == 1 defines graphics  mode structures in FLEXTAB.H.
                   */
#include <flextab.h>
extern VIRCON vir;
#endif




/*----------------------------------------------------------------------
*       MALLOC DEBUGGING SUPPORT:
*
*       Set EMALLOC and EMALLOC_MAGIC in order to use your private
*       versions of malloc(), calloc(), and free().  This can help,
*       but not solve, your malloc problems when debugging...
*
*/
#ifndef	INTERNAL
#  define EMALLOC 0             /* Disable External Malloc	        */
#else
#  define EMALLOC 0             /* Enable/Disable External Malloc       */
#  define EMALLOC_MAGIC  0x0C0C /* Our magic indicator that we should   */
                                /* use our external malloc rather than  */
                                /* the runtime's malloc.                */
#endif


/*----------------------------------------------------------------------*/
/* window properties */
#define _SUBWIN         0x01    /* window is a subwindow            */
#define _ENDLINE        0x02    /* last winline is last screen line */
#define _FULLWIN        0x04    /* window fills screen              */
#define _SCROLLWIN      0x08    /* window lwr rgt is screen lwr rgt */
#define _PAD            0x10    /* X/Open Pad.                      */




/*----------------------------------------------------------------------*/
/* Miscellaneous */
#define _INBUFSIZ       512     /* size of terminal input buffer */
#define _NO_CHANGE      -1      /* flags line edge unchanged     */




/* @@@ THESE SHOULD BE INDIVIDUAL FUNCTIONS, NOT MACROS! */
#define _BCHAR          0x03    /* Break char	    (^C)         */
#define _ECHAR          0x08    /* Erase char	    (^H)         */
#define _DWCHAR         0x17    /* Delete Word char (^W)         */
#define _DLCHAR         0x15    /* Delete Line char (^U)         */
#define _GOCHAR         0x11    /* ^Q character                  */
#define _PRINTCHAR      0x10    /* ^P character                  */
#define _STOPCHAR       0x13    /* ^S character                  */
#define  NUNGETCH       20      /* max # chars to ungetch()      */




/* Setmode stuff */
struct cttyset
{
	bool	been_set;
	SCREEN	saved;
};

extern struct cttyset c_sh_tty;         /* tty modes for shell_mode */
extern struct cttyset c_pr_tty;         /* tty modes for prog_mode  */
extern struct cttyset c_save_tty;
extern struct cttyset c_save_trm;

/* Printscan stuff */
extern char c_printscanbuf[];           /* buffer used during I/O */

/* tracing flag */
extern bool trace_on;

/* Strget stuff */
extern char*    c_strbeg;

/* doupdate stuff */
extern WINDOW*  twin;                   /* used by many routines */

/* Monitor (terminal) type information */
#define _NONE           0x00
#define _MDA            0x01
#define _CGA            0x02
#define _EGACOLOR       0x04
#define _EGAMONO        0x05
#define _VGACOLOR       0x07
#define _VGAMONO        0x08
#define _MCGACOLOR      0x0a
#define _MCGAMONO       0x0b
#define _FLEXOS         0x20            /* A Flexos console */
#define _MDS_GENIUS     0x30
#define _UNIX_COLOR     0x40
#define _UNIX_MONO      0x41

/* Text-mode font size information */
#define _FONT8  8
#define _FONT14 14
#define _FONT15 15              /* GENIUS */
#define _FONT16 16


/*----------------------------------------------------------------------
*       ANSI C prototypes.  Be sure that your compiler conditional
*       compilation definitions above define ANSI to be non-zero
*       if you compiler supports prototypes.
*/
#ifdef     ANSI
#  ifdef  CPLUSPLUS
     extern "C" {
#  endif
bool	PDC_check_bios_key( void );
bool	PDC_get_ctrl_break( void );
bool	PDC_transformline( int );
chtype	PDC_validchar( chtype );
int	PDC_backchar( WINDOW*, char*, int* );
int	PDC_scr_open( SCREEN*, bool );
int	PDC_scr_close( void );
int	PDC_get_cursor_pos( int*, int* );
int	PDC_get_cur_row( void );
int	PDC_get_cur_col( void );
int	PDC_get_columns( void );
int	PDC_scroll( int, int, int, int, int, chtype );
int	PDC_set_ctrl_break( bool );
int	PDC_clr_update( WINDOW* );
int	PDC_chadd( WINDOW*, chtype, bool, bool );
int	PDC_chins( WINDOW*, chtype, bool );
#ifdef     OS2
VIOCONFIGINFO	PDC_query_adapter_type( void );
VIOMODEINFO	PDC_get_scrn_mode( void );
int	PDC_set_scrn_mode( VIOMODEINFO );
bool	PDC_scrn_modes_equal (VIOMODEINFO, VIOMODEINFO);
#else
int	PDC_query_adapter_type( void );
int	PDC_get_scrn_mode( void );
int	PDC_set_scrn_mode( int );
bool	PDC_scrn_modes_equal (int, int);
#endif
int	PDC_get_font( void );
int	PDC_set_font( int );
int	PDC_set_80x25( void );
int	PDC_fix_cursor( int );
int	PDC_get_rows( void );
int	PDC_set_rows( int );
int	PDC_putchar( chtype );
int	PDC_clr_scrn( WINDOW* );
int	PDC_gattr( void );
int	PDC_gotoxy( int, int );
int	PDC_print( int, int, int );
int	PDC_chg_attr( WINDOW*, chtype, int, int, int, int );
int	PDC_split_plane( WINDOW*, char*, char*, int, int, int, int );
int	PDC_sanity_check( int );
int	PDC_get_cursor_mode( void );
int	PDC_set_cursor_mode( int, int );
int	PDC_get_bios_key( void );
int	PDC_putc( chtype, chtype );
int	PDC_putctty( chtype, chtype );
int	PDC_rawgetch( void );
int	PDC_sysgetch( void );
int	PDC_copy_win( WINDOW *,WINDOW *,int,int,int,int,int,int,int,int,bool );
void	PDC_usleep( long );
WINDOW*	PDC_makenew( int, int, int, int );
int	PDC_newline( WINDOW*, int );

#ifdef	FLEXOS
int	PDC_flexos_8bitmode( void );
int	PDC_flexos_16bitmode( void );
char*	PDC_flexos_gname( void );
#endif

#ifdef UNIX
int	PDC_kbhit(void);
int	PDC_setup_keys(void);
#endif

#ifdef PDCDEBUG
void	PDC_debug( char*,... );
#endif

#ifdef	REGISTERWINDOWS
bool	PDC_inswin( WINDOW*, WINDOW* );
int	PDC_addtail( WINDOW* );
int	PDC_addwin( WINDOW*, WINDOW* );
int	PDC_rmwin( WINDOW* );
WINDS*	PDC_findwin( WINDOW* );
#endif
#  ifdef  CPLUSPLUS
     }
#  endif
#endif

#define MAX_ATRTAB    272

/* internal macros for attributes */
#define chtype_attr(ch)  ((atrtab[((ch >> 8) & 0xFF)] << 8) & A_ATTRIBUTES)
#define phys_attr(ch)    (atrtab[((ch >> 8) & 0xFF)])

#endif /* __CURSES_INTERNALS__*/
