#include <string.h>

void usage(name, version)
char *name, *version;
{
  printf("\n%s scanner generator, version %s\n", strupr(name), version);

  printf("\nUsage: %s [-bcdfinpstvFILT8] [-C[efmF]] [-Sskeleton] [filename]\n", name);

  printf("\n  -b   generate backtracking information to 'lex.bck'"
         "\n  -c   ignored, accepted only for POSIX compliance"
         "\n  -d   makes the generated scanner run in debug mode"
         "\n  -f   do not compress the scanner tables (equivalent to -Cf)"
         "\n  -i   instructs flex to generate a case-insensitive scanner");

  printf("\n  -n   ignored, accepted only for POSIX compliance"
         "\n  -p   generate a performance report to stderr"
         "\n  -s   suppress the default rule"
         "\n  -t   write generated scanner to stdout"
         "\n  -v   print to stderr a summary of statistics of the generated scanner");

  printf("\n  -F   fast scanner table representation should be used (equivalent to -CF)."
         "\n  -I   instructs flex to generate an interactive scanner."
         "\n       cannot be used in conjunction with the -f, -F, -Cf, or -CF flags."
         "\n  -L   instructs flex to not generate #line directives."
         "\n  -T   makes flex run in trace mode."
         "\n  -8   generate 8-bit scanner (default)\n");

  printf("\n  -C[efmF]   controls the degree of table compression (default = -Cem)."
         "\n       -Ce   directs flex to construct equivalence classes."
         "\n       -Cf   the full scanner tables should be generated."
         "\n       -CF   the alternate fast scanner representation should be used."
         "\n       -Cm   directs flex to construct meta-equivalence classes."
         "\n       -C    the scanner tables should be compressed.\n");

  printf("\n  -S   next argument overrides the default skeleton file.\n");
}
