LS(1L)                                                     LS(1L)


NAME
       ls, dir, vdir - list contents of directories

SYNOPSIS
       ls  [-abcdfgiklmnpqrstuxABCFGLNQRSUX1] [-w cols] [-T cols]
       [-I pattern] [--all]  [--escape]  [--directory]  [--inode]
       [--kilobytes]  [--numeric-uid-gid]  [--no-group]  [--hide-
       control-chars] [--reverse] [--size] [--width=cols] [--tab-
       size=cols]  [--almost-all] [--ignore-backups] [--classify]
       [--file-type] [--full-time] [--ignore=pattern] [--derefer-
       ence]     [--literal]     [--quote-name]     [--recursive]
       [--sort={none,time,size,extension}]                [--for-
       mat={long,verbose,commas,across,vertical,single-column}]
       [--time={atime,access,use,ctime,status}] [--help]  [--ver-
       sion] [name...]

DESCRIPTION
       This manual page documents the GNU version of ls.  dir and
       vdir are versions of ls with different default output for-
       mats.   These  programs  list each given file or directory
       name.  Directory contents are sorted alphabetically.   For
       ls,  files are by default listed in columns, sorted verti-
       cally, if the standard output  is  a  terminal;  otherwise
       they  are  listed  one  per  line.   For dir, files are by
       default listed in columns, sorted vertically.   For  vdir,
       files are by default listed in long format.

   OPTIONS
       -a, --all
              List  all files in directories, including all files
              that start with `.'.

       -b, --escape
              Quote nongraphic characters  in  file  names  using
              alphabetic and octal backslash sequences like those
              used in C.

       -c, --time=ctime, --time=status
              Sort directory contents  according  to  the  files'
              status  change  time  instead  of  the modification
              time.  If the long listing format  is  being  used,
              print the status change time instead of the modifi-
              cation time.

       -d, --directory
              List directories  like  other  files,  rather  than
              listing their contents.

       -f     Do  not sort directory contents; list them in what-
              ever order they are stored on the disk.   The  same
              as enabling -a and -U and disabling -l, -s, and -t.

       --full-time
              List times in full, rather than using the  standard


FSF                     GNU File Utilities                      1
LS(1L)                                                     LS(1L)


              abbreviation heuristics.

       -g     Ignored; for Unix compatibility.

       -i, --inode
              Print  the index number of each file to the left of
              the file name.

       -k, --kilobytes
              If file sizes are being listed, print them in kilo-
              bytes.   This  overrides  the  environment variable
              POSIXLY_CORRECT.

       -l, --format=long, --format=verbose
              In addition to the name of  each  file,  print  the
              file type, permissions, number of hard links, owner
              name, group name, size in bytes, and timestamp (the
              modification time unless other times are selected).
              For files with a time that is more  than  6  months
              old or more than 1 hour into the future, the times-
              tamp contains the year instead of the time of  day.

       -m, --format=commas
              List  files  horizontally, with as many as will fit
              on each line, separated by commas.

       -n, --numeric-uid-gid
              List the numeric UID and GID instead of the  names.

       -p     Append a character to each file name indicating the
              file type.

       -q, --hide-control-chars
              Print question marks instead of nongraphic  charac-
              ters in file names.

       -r, --reverse
              Sort directory contents in reverse order.

       -s, --size
              Print  the  size  of  each file in 1K blocks to the
              left of the file name.  If the environment variable
              POSIXLY_CORRECT  is  set,  512-byte blocks are used
              instead.

       -t, --sort=time
              Sort directory contents  by  timestamp  instead  of
              alphabetically, with the newest files listed first.

       -u, --time=atime, --time=access, --time=use
              Sort directory contents  according  to  the  files'
              last  access time instead of the modification time.
              If the long listing format is being used, print the
              last  access time instead of the modification time.


FSF                     GNU File Utilities                      2
LS(1L)                                                     LS(1L)


       -x, --format=across, --format=horizontal
              List the files in columns, sorted horizontally.

       -A, --almost-all
              List all files in directories, except for  `.'  and
              `..'.

       -B, --ignore-backups
              Do  not  list  files that end with `~', unless they
              are given on the command line.

       -C, --format=vertical
              List files in columns, sorted vertically.

       -F, --classify
              Append a character to each file name indicating the
              file  type.  For regular files that are executable,
              append a `*'.  The file type indicators are `/' for
              directories, `@' for symbolic links, `|' for FIFOs,
              `=' for sockets, and nothing for regular files.

       -G, --no-group
              Inhibit display of group information in a long for-
              mat directory listing.

       -L, --dereference
              List  the files linked to by symbolic links instead
              of listing the contents of the links.

       -N, --literal
              Do not quote file names.

       -Q, --quote-name
              Enclose file names in double quotes and quote  non-
              graphic characters as in C.

       -R, --recursive
              List the contents of all directories recursively.

       -S, --sort=size
              Sort  directory  contents  by  file size instead of
              alphabetically,  with  the  largest  files   listed
              first.

       -U, --sort=none
              Do  not sort directory contents; list them in what-
              ever order they  are  stored  on  the  disk.   This
              option  is  not  called  -f  because the Unix ls -f
              option also enables -a and disables -l, -s, and -t.
              It  seems useless and ugly to group those unrelated
              things together in one option.  Since  this  option
              doesn't do that, it has a different name.




FSF                     GNU File Utilities                      3
LS(1L)                                                     LS(1L)


       -X, --sort=extension
              Sort  directory  contents  alphabetically  by  file
              extension (characters after the  last  `.');  files
              with no extension are sorted first.

       -1, --format=single-column
              List one file per line.

       -w, --width cols
              Assume  the  screen  is  cols  columns  wide.   The
              default is taken from the terminal driver if possi-
              ble;  otherwise the environment variable COLUMNS is
              used if it is set; otherwise the default is 80.

       -T, --tabsize cols
              Assume that each tabstop is cols columns wide.  The
              default is 8.

       -I, --ignore pattern
              Do  not list files whose names match the shell pat-
              tern pattern unless they are given on  the  command
              line.   As  in the shell, an initial `.' in a file-
              name does not match a wildcard at the start of pat-
              tern.

       --help Print  a  usage message on standard output and exit
              successfully.

       --version
              Print version information on standard  output  then
              exit successfully.

BUGS
       On  BSD systems, the -s option reports sizes that are half
       the correct values for files that are NFS-mounted from HP-
       UX  systems.   On HP-UX systems, it reports sizes that are
       twice the correct values for files  that  are  NFS-mounted
       from BSD systems.  This is due to a flaw in HP-UX; it also
       affects the HP-UX ls program.

















FSF                     GNU File Utilities                      4
