puts("ar - create and maintain library archives");
puts("");
puts("SYNOPSIS");
puts("");
puts(" ar -d [-v] archive file...");
puts(" ar -m [-v] archive file...");
puts(" ar -m -a [-v] posname archive file...");
puts(" ar -m -b [-v] posname archive file...");
puts(" ar -m -i [-v] posname archive file...");
puts(" ar -p [-v] [-s] archive [file...]");
puts(" ar -q [-cv] archive file...");
puts(" ar -r [-cuv] archive file...");
puts(" ar -r -a [-cuv] posname archive file...");
puts(" ar -r -b [-cuv] posname archive file...");
puts(" ar -r -i [-cuv] posname archive file...");
puts(" ar -t [-v] [-s] archive [file...]");
puts(" ar -x [-v] [-sCT] archive [file...]");
puts("");
puts("DESCRIPTION");
puts("");
puts("The ar utility is part of the Software Development Utilities option.");
puts("");
puts("The ar utility can be used to create and maintain groups of files combined");
puts("into an archive. Once an archive has been created, new files can be added,");
puts("and existing files in an archive can be extracted, deleted, or replaced.");
puts("When an archive consists entirely of valid object files, the implementation");
puts("shall format the archive so that it is usable as a library for link editing");
puts("(see c99 and fort77). When some of the archived files are not valid object");
puts("files, the suitability of the archive for library use is undefined.");
puts("");
puts("If an archive consists entirely of printable files, the entire archive shall");
puts("be printable.");
puts("");
puts("When ar creates an archive, it creates administrative information indicating");
puts("whether a symbol table is present in the archive. When there is at least one");
puts("object file that ar recognizes as such in the archive, an archive symbol");
puts("table shall be created in the archive and maintained by ar; it is used by");
puts("the link editor to search the archive. Whenever the ar utility is used to");
puts("create or update the contents of such an archive, the symbol table shall be");
puts("rebuilt. The -s option shall force the symbol table to be rebuilt.");
puts("");
puts("All file operands can be pathnames. However, files within archives shall be");
puts("named by a filename, which is the last component of the pathname used when");
puts("the file was entered into the archive. The comparison of file operands to");
puts("the names of files in archives shall be performed by comparing the last");
puts("component of the operand to the name of the file in the archive.");
puts("");
puts("It is unspecified whether multiple files in the archive may be identically");
puts("named. In the case of such files, however, each file and posname operand");
puts("shall match only the first file in the archive having a name that is the");
puts("same as the last component of the operand.");
puts("");
puts("OPTIONS");
puts("");
puts("The ar utility shall conform to XBD Utility Syntax Guidelines, except for");
puts("Guideline 9.");
puts("");
puts("The following options shall be supported:");
puts("");
puts("-a      Position new files in the archive after the file named by the posname");
puts("        operand.");
puts("");
puts("-b      Position new files in the archive before the file named by the posname");
puts("        operand.");
puts("");
puts("-c      Suppress the diagnostic message that is written to standard error by");
puts("        default when the archive archive is created.");
puts("");
puts("-C      Prevent extracted files from replacing like-named files in the file");
puts("        system. This option is useful when -T is also used, to prevent");
puts("        truncated filenames from replacing files with the same prefix.");
puts("");
puts("-d      Delete one or more files from archive.");
puts("");
puts("-i      Position new files in the archive before the file in the archive");
puts("        named by the posname operand (equivalent to -b).");
puts("");
puts("-m      Move the named files in the archive. The -a, -b, or -i options with");
puts("        the posname operand indicate the position; otherwise, move the names");
puts("        files in the archive to the end of the archive.");
puts("");
puts("-p      Write the contents of the files in the archive named by file operands");
puts("        from archive to the standard output. If no file operands are specified,");
puts("        the contents of all files in the archive shall be written in the order");
puts("        of the archive.");
puts("");
puts("-q      Append the named files to the end of the archive. In this case ar does");
puts("        not check whether the added files are already in the archive. This is");
puts("        useful to bypass the searching otherwise done when creating a large");
puts("        archive piece by piece.");
puts("");
puts("-r      Replace or add files to archive. If the archive named by archive does");
puts("        not exist, a new archive shall be created and a diagnostic message");
puts("        shall be written to standard error (unless the -c option is specified).");
puts("        If no files are specified and the archive exists, the results are");
puts("        undefined. Files that replace existing files in the archive shall not");
puts("        change the order of the archive. Files that do not replace existing");
puts("        files in the archive shall be appended to the archive unless a -a, -b,");
puts("        or -i option specifies another position.");
puts("");
puts("-s      Force the regeneration of the archive symbol table even if ar is not");
puts("        invoked with an option that modifies the archive contents. This option");
puts("        is useful to restore the archive symbol table after it has been");
puts("        stripped; see strip.");
puts("");
puts("-t      Write a table of contents of archive to the standard output. Only the");
puts("        files specified by the file operands shall be included in the written");
puts("        list. If no file operands are specified, all files in archive shall");
puts("        be included in the order of the archive.");
puts("");
puts("-T      Allow filename truncation of extracted files whose archive names are");
puts("        longer than the file system can support. By default, extracting a file");
puts("        with a name that is too long shall be an error; a diagnostic message");
puts("        shall be written and the file shall not be extracted.");
puts("");
puts("-u      Update older files in the archive. When used with the -r option, files");
puts("        in the archive shall be replaced only if the corresponding file has a");
puts("        modification time that is at least as new as the modification time of");
puts("        the file in the archive.");
puts("");
puts("-v      Give verbose output. When used with the option characters -d, -r, or");
puts("        -x, write a detailed file-by-file description of the archive creation");
puts("        and maintenance activity. When used with -p, write the name of the");
puts("        file in the archive to the standard output before writing the file in");
puts("        the archive itself to the standard output. When used with -t, include");
puts("        a long listing of information about the files in the archive.");
puts("");
puts("-x      Extract the files in the archive named by the file operands from");
puts("        archive. The contents of the archive shall not be changed. If no file");
puts("        operands are given, all files in the archive shall be extracted. The");
puts("        modification time of each file extracted shall be set to the time the");
puts("        file is extracted from the archive.");
puts("");
puts("OPERANDS");
puts("");
puts("The following operands shall be supported:");
puts("");
puts("archive A pathname of the archive.");
puts("");
puts("file    A pathname. Only the last component shall be used when comparing");
puts("        against the names of files in the archive. If two or more file");
puts("        operands have the same last pathname component (basename), the");
puts("        results are unspecified. The implementation's archive format shall");
puts("        not truncate valid filenames of files added to or replaced in the");
puts("        archive.");
puts("");
puts("posname The name of a file in the archive, used for relative positioning;");
puts("        see options -m and -r.");
