head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.12.23.10.02;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.22.34;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.00.55.44;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Basic V86 emulation
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				TASKMAN.ASM
;				-----------
;
;	Task (DOS boxes management) module.
;
;	(!) HddSema4 is handled appropriate only for single CPU machine.
;
;=============================================================================
.486p
	INCLUDE	TASKMAN.INC
	INCLUDE	x86.INC
	INCLUDE	DEF.INC
	INCLUDE	PHLIB32.MCR
	INCLUDE	DPMI.INC


DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
	PUBVAR		TempPdb, DD, ?

	PUBVAR	NumOfTasks, DD, 0	; Number of active tasks.
	PUBVAR	FirstTask, DD, 0	; Ptr to page of tasks.
	PUBVAR	CurrentTask, DD, 0 	; Currently running task.
	PUBVAR	CurrTaskPtr, DD, 0	; Pointer to current task.
	PUBVAR	ForegroundTask, DD, 0	; Task owning I/O focus.
	PUBVAR	GpCount, DD, 0		; Counts how much times VM #GP occured.

	PUBVAR	VirtualIf, DD, 0 	; Virtual interrupt flag.
	PUBVAR	FakeIopl, DD, 3000h	; IOPL value as set by app.

	PUBVAR	Int13RetOp, DB, ?	; HDD semaphore: 8 bytes of client opcode to be
		DB	7 DUP (?)	; replaced with entry invalid opcode.
		DB	8 DUP (?)	; the same for FDD.

	PUBVAR	NextToRun, DD, -1	; Next task to run.

	PUBVAR	HddSema4, DB, 0		; HDD is a shared
				 	; resource.
	PUBVAR	HddSema4Own, DD, ?	; Task owning HDD semaphore.
	PUBVAR	FddSema4, DB, 0		; FDD is a shared
				 	; resource.
	PUBVAR	FddSema4Own, DD, ?	; Task owning FDD semaphore.

	DosFunc	DW	?		; Save called DOS function for trap.
	ErrCode	DB	0		; Extended error handled if non-0.

	TestFName	DB	100 DUP (?) ; Keeps full file name during
					; comparison.

IFDEF	DOUBLE_SHELL
	ComSpecStr	DB	"COMSPEC=", 0
	PspSeg		DW	?
	Dta		DB	512 DUP (?)

	ExecPrmBlock	DW	0
			DW	CmdTail, DATA
			DW	5Ch, ?
			DW	6Ch, ?
			DW	?, ?, ?, ?
	CmdTail		DB	0, 0Dh, 0Ah
ENDIF	; DOUBLE_SHELL
; Keep DPMI traps. Will be copied to DPMI service page.

DpmiTraps	LABEL	BYTE

	DpmiTrap	2, 0		; Init mode switch
	DpmiTrap	2, 1		; Raw PM to VM mode switch
	DpmiTrap	2, 2		; Raw VM to PM mode switch
	DpmiTrap	3		; Return from int redirected to VM
	DpmiTrap	4		; Return from PM exception handler

; Default exception handlers.
EXC_HANDLER = 0
WHILE	EXC_HANDLER LT 32
	DpmiTrap	5, EXC_HANDLER
EXC_HANDLER = EXC_HANDLER + 1
ENDM

; Default interrupt handler
INT_HANDLER = 0
WHILE	INT_HANDLER LT 256
DpmiTrap	6, INT_HANDLER
INT_HANDLER = INT_HANDLER + 1
ENDM

	DpmiTrap	7		; Return from PM interrupt handler
	DpmiTrap	8		; Return from translation services
	DpmiTrap	0Ah		; Return from RM callback handler
	DpmiTrap	0Dh		; VM save state proc (saves PM state)
	DpmiTrap	0Eh		; PM save state proc (saves VM state)

; Placeholder for memory info structure.
REPEAT	3
	DpmiTrap	0
ENDM

;IFDEF	FAKE_WINDOWS
	DpmiTrap	0Bh		; Windows "vendor API entry point".
;ENDIF
;IFDEF	PROVIDE_HIMEM
	DpmiTrap	0Ch		; XMS server entry point.
;ENDIF

DPMI_TRAPS_SIZE	=	$ - DpmiTraps	; Multiple of Qwords.


	ReflectPM2PMStr DB	"ReflectPM2PM: "
	ReflectPM2VMStr DB	"ReflectPM2VM: "
	ReflectVM2PMStr DB	"ReflectVM2PM: "
	ReflectVM2VMStr DB	"ReflectVM2VM: "

DATA	ENDS


	EXTRN	PointerToLinear: near32
	EXTRN	HeapAllocPage: near32
	EXTRN	HeapAllocZPage: near32
	EXTRN	HeapAllocMem: near32
	EXTRN	HeapFreePage: near32
	EXTRN	HeapFreeMem: near32
	EXTRN	LinearToPhysical: near32
	EXTRN	LeftFreePages: near32
	EXTRN	AddExcTrap: near32
	EXTRN	SaveClientRegs: near32
	EXTRN	RestoreClientRegs: near32
	EXTRN	SetClientRegs: near32
	EXTRN	PmHex32ToA: near32
	EXTRN	PmWriteStr32: near32
	EXTRN	PmStrCmp: near32
	EXTRN	PmToUpper: near32
	EXTRN	SaveVideoContext: near32
	EXTRN	RestoreVideoContext: near32
	EXTRN	SaveVideoMemory: near32
	EXTRN	RestoreVideoMemory: near32
	EXTRN	TrapVideoPorts: near32
	EXTRN	TrapGenDevPorts: near32
	EXTRN	RelGenDevSema4s: near32
	EXTRN	SkipPrefixes: near32
	EXTRN	Int31Handler: near32
	EXTRN	DpmiWashUp: near32
	EXTRN	WriteLog: near32

	EXTRN	PmSaveState: near32
	EXTRN	RmSaveState: near32
	EXTRN	PmRestoreState: near32
	EXTRN	RmRestoreState: near32


	EXTRN	SysPdb: dword
	EXTRN	Pdb: dword
	EXTRN	SysPdbLin: dword
	EXTRN	PdbLin: dword
	EXTRN	SysPagesCtl: dword
	EXTRN	PagesCtl: dword
	EXTRN	OsHeapEnd: dword

	EXTRN	SystemTask: dword

	EXTRN	ExcCode: dword
	EXTRN	ExcOffs: dword
	EXTRN	ExcSeg: word
	EXTRN	ExcEflags: dword
	EXTRN	ExcEax: dword
	EXTRN	ExcEbx: dword
	EXTRN	ExcEcx: dword
	EXTRN	ExcEdx: dword
	EXTRN	ExcEsp: dword
	EXTRN	ExcEbp: dword
	EXTRN	ExcEsi: dword
	EXTRN	ExcEdi: dword
	EXTRN	ExcDs: word
	EXTRN	ExcEs: word
	EXTRN	ExcFs: word
	EXTRN	ExcGs: word
	EXTRN	ExcSs: word

	EXTRN	VirtualIp: dword
	EXTRN	VirtualIsr: dword
	EXTRN	VirtualImr: dword

	EXTRN	OperandSize: byte
	EXTRN	AddressSize: byte
	EXTRN	SegPrefix: byte
	EXTRN	RepPrefix: byte

	EXTRN	CurrDrive: byte
	EXTRN	ListOfListsLin: dword
	EXTRN	Field: byte

	EXTRN	KbdQHead: dword
	EXTRN	KbdQTail: dword
	EXTRN	KeyboardQ: byte

	EXTRN	Cpu: word

	EXTRN	PmCallbackCs: word
	EXTRN	PmCallbackSs: word
	EXTRN	CurrLdtBase: dword

	EXTRN	TicksReport: dword

	EXTRN	DpmiSrvAddr: dword
	EXTRN	DpmiSrvSeg: word

	EXTRN	DmaIoRange: DWORD

IFDEF	MONITOR_DPMI
	EXTRN	LogX: byte
	EXTRN	LogY: byte
	EXTRN	LogClr: byte
ENDIF

CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT

;-----------------------------------------------------------------------------
;
;	Creates new DOS task. Allocates pages and copies original DOS to it.
;
;	I:
;	O:	CF = 0	created
;		   = 1	error (not enough memory).
;
;	(!) Process creator must execute in system context to be able to fork
; a copy of original DOS. 
;	(!) For DOS structures array one page is allocated so meanwhile only
; up to MAX_TASKS.
;
;-----------------------------------------------------------------------------
CreateDosTask	PROC	USES es eax ebx ecx edx esi edi ebp
	cmp	NumOfTasks, MAX_TASKS
	jb	create_task
	stc
	ret

create_task:
	call	LeftFreePages		; Check if enough free pages left.
	cmp	eax, TASK_MEMORY_SIZE SHR 12
	jnb	enough_free

; Return error.
	ret				; CF = 1 already.

enough_free:
	mov	ax, FLAT_DS
	mov	es, ax

	mov	eax, SysPdbLin
	mov	PdbLin, eax
	mov	eax, SysPagesCtl
	mov	PagesCtl, eax
	mov	eax, SysPdb
	mov	cr3, eax		; Set system context.

; ES:ESI -> new task's structure.
	TASK_PTR	NumOfTasks, esi	; es:ESI -> task being created.

; Set borrowed ticks to 0.
IFDEF	BORROWED_TICKS
	mov	(DosTask PTR es:[esi]).BorrowedTicks, 0
ENDIF

; Set current drive.
	mov	al, CurrDrive
	mov	(DosTask PTR es:[esi]).TaskCurrDrive, al

; Set error code to 0.
	mov	(DosTask PTR es:[esi]).TaskErrCode, 0

; Set task's LDT to 0. It may be further used to verify whether the task
; already made initial switch (will be non-0). One task can have only one LDT.
	mov	(DosTask PTR es:[esi]).TaskLdt, 0

; Set DOS flags to 0.
	mov	(DosTask PTR es:[esi]).TaskFlags, 0

; Set HMA available flag to 0 (available)
	mov	(DosTask PTR es:[esi]).XmsHmaFlag, 0

; Set task's PIT 0 counter to basic TicksReport (65536).
	mov	eax, TicksReport
	mov	(DosTask PTR es:[esi]).TaskTicksReport, eax

; Reset task tick count.
	mov	(DosTask PTR es:[esi]).TaskTickCount, 0

; Reset task virtual PIT channel 0 select.
	mov	(DosTask PTR es:[esi]).TaskPITCh0Sel, 0

; Allocate page for task's open files table.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	mov	(DosTask PTR es:[esi]).TaskOFTable, eax
	mov	(DosTask PTR es:[esi]).TaskOpenFiles, 0

; Allocate page for task's PDB.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocZPage
	mov	(DosTask PTR es:[esi]).TaskPdbLin, eax	; PDB lin. addr.
; ES:EBX -> new task's PDB.
	mov	ebx, eax

	call	LinearToPhysical			; Get physical address
	mov	(DosTask PTR es:[esi]).TaskPdb, eax	; PDB ctl. phys. addr.

; Allocate page for task's ctl. array.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	mov	(DosTask PTR es:[esi]).TaskPageCtl, eax	; Page ctl. lin. addr.
; ES:EDX -> new task's pages control array.
	mov	edx, eax

; Allocate page table for 1st Mb.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocZPage
	mov	es:[edx], eax			; Lin. addr. of page table

	call	LinearToPhysical
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[ebx], eax			; Phys. addr. of page table

; ES:EDX = linear address of first page table.
	mov	edx, es:[edx]

; Allocate 1st Mb alias mapping table.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	mov	(DosTask PTR es:[esi]).TaskMapping, eax
; ES:EDI -> new task's alias mapped 1st MB.
	mov	edi, eax

; Allocate save/restore video space.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	mov	(DosTask PTR es:[esi]).TaskVideoState, eax

;
; Allocate pages for base and video memory. All those pages will be double-
; mapped.
;
	sub	ecx, ecx			; Pages count
alloc_pages:
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage			; Alloc page in 1st Mb.
	mov	es:[edi+ecx*4], eax		; Store linear address

	call	LinearToPhysical
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[edx+ecx*4], eax		; Store page w/ attributes.

	inc	ecx
	cmp	ecx, (0A0000h + 40000h) SHR 12		; Number of pages to
							; allocate.
	jb	alloc_pages

IFDEF	PROVIDE_HIMEM
;
; Allocate pages for HMA.
;
	mov	ecx, 100000h SHR 12
alloc_hma_pages:
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage			; Alloc page in 1st Mb.
	mov	es:[edi+ecx*4], eax		; Store linear address

	call	LinearToPhysical
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[edx+ecx*4], eax		; Store page w/ attributes.

	inc	ecx
	cmp	ecx, 110000h SHR 12		; Number of pages to allocate.
	jb	alloc_hma_pages
ENDIF	; PROVIDE_HIMEM

;
; Map all shared memory areas equally.
;
	mov	edx, (DosTask PTR es:[esi]).TaskPageCtl
	mov	ecx, PdbLin

; Map OS pages in new task.
	mov	eax, es:[ecx + (OS_BASE SHR 20)]
	mov	es:[ebx + (OS_BASE SHR 20)], eax

; Map OS video buffer in new task.
	mov	eax, es:[ecx + (OS_VIDEO_BUF SHR 20)]
	mov	es:[ebx + (OS_VIDEO_BUF SHR 20)], eax

; Map OS global 1st Mb mapping in new task.
	mov	eax, es:[ecx + (OS_1ST_MB SHR 20)]
	mov	es:[ebx + (OS_1ST_MB SHR 20)], eax

; Map OS heap pages in app.
	mov	edi, OS_HEAP
map_os_heap:
	mov	ebp, edi
	shr	ebp, 20
	mov	eax, es:[ecx + ebp]			
	mov	es:[ebx + ebp], eax
	add	edi, 400000h
	cmp	edi, OsHeapEnd
	jb	map_os_heap

	mov	ecx, PagesCtl

	mov	eax, es:[ecx + (OS_BASE SHR 20)]	; Mark OS pages in new
	mov	es:[edx + (OS_BASE SHR 20)], eax	; task's pages ctl.

	mov	edi, OS_HEAP
mark_os_heap:
	mov	ebp, edi
	shr	ebp, 20
	mov	eax, es:[ecx + ebp]			; Mark OS heap pages
	mov	es:[edx + ebp], eax			; in app's pages ctl.
	add	edi, 400000h
	cmp	edi, OsHeapEnd
	jb	mark_os_heap

;
; Map heap page tables in new task. Scan all the physically allocated entries,
; copy them and the correspondent PagesCtl entries.
;
	mov	ecx, PdbLin
	mov	ebp, PagesCtl
	mov	edi, OS_DYN_PAGETBLS SHR 22
map_dyn_pagetbls:
	mov	eax, es:[ecx + edi*4]
	test	eax, PAGE_PRESENT
	jz	dyn_pagetbls_mapped
	mov	es:[ebx + edi*4], eax
	mov	eax, es:[ebp + edi*4]
	mov	es:[edx + edi*4], eax
	inc	edi
	jmp	map_dyn_pagetbls
dyn_pagetbls_mapped:

;
; Map A0000 - FFFFF 1-to-1 (for active task). For background task video 
; memory will be virtualized.
;
	mov	edx, (DosTask PTR es:[esi]).TaskPageCtl
	mov	edx, es:[edx]
	mov	ecx, 0A0000h SHR 12
map_rom:
	mov	eax, ecx
	shl	eax, 12
	or	eax, PAGE_PRESENT OR PAGE_USER OR PAGE_WRITABLE	; Read-only pages.
	mov	es:[edx+ecx*4], eax		; Store page w/ attributes.
	inc	ecx
	cmp	ecx, 100000h SHR 12
	jb	map_rom
IFNDEF	PROVIDE_HIMEM
;
; Map HMA to low memory (00000h) to emulate A20 off.
;
	mov	ecx, 100000h SHR 12
map_hma:
	mov	eax, ecx
	and	eax, NOT 100000h		; Clear A20.
	shl	eax, 12
	or	eax, PAGE_PRESENT OR PAGE_USER OR PAGE_WRITABLE	; Read-only pages.
	mov	es:[edx+ecx*4], eax		; Store page w/ attributes.
	inc	ecx
	cmp	ecx, 110000h SHR 12
	jb	map_hma
ENDIF	; PROVIDE_HIMEM

;
; Allocate memory for DPMI server needs: mode switch, RM temp stack.
;
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	ecx, DPMI_MEM_SIZE
	call	HeapAllocMem

	mov	ebx, (DosTask PTR es:[esi]).TaskMapping
	sub	ebp, ebp

map_dpmi_page:
;	mov	es:[ebx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4], eax	; Store linear address
	push	ebx
	mov	ecx, DpmiSrvAddr
	shr	ecx, 10
	add	ebx, ecx
	mov	es:[ebx][ebp*4], eax	; Store linear address
	pop	ebx

; Clear page.
	mov	edi, eax
	mov	ecx, 400h			; Number of dwords in 1 page.
	push	eax
	sub	eax, eax
		rep	stosd
	pop	eax

	call	LinearToPhysical

; Map page for DPMI server needs.
	or	eax, PAGE_PRESENT OR PAGE_USER OR PAGE_WRITABLE

;	mov	es:[edx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4], eax	; Store physical address
	push	edx
	mov	ecx, DpmiSrvAddr
	shr	ecx, 10
	add	edx, ecx
	mov	es:[edx][ebp*4], eax	; Store linear address
	pop	edx

;	mov	eax, es:[ebx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4]
	push	ebx
	mov	ecx, DpmiSrvAddr
	shr	ecx, 10
	add	ebx, ecx
	mov	eax, es:[ebx][ebp*4]	; Get linear address
	pop	ebx

	add	eax, 1000h
	inc	ebp
	cmp	ebp, DPMI_MEM_PAGES
	jb	map_dpmi_page

; Copy DPMI traps to service page.
	push	esi
	push	edi
	push	ecx
	mov	esi, offset DpmiTraps

;	mov	edi, es:[ebx+(DPMI_SERVICE_PAGE SHR 10)]	; Read linear address
	mov	ecx, DpmiSrvAddr
	shr	ecx, 10
	mov	edi, es:[ebx][ecx]			; Read linear address

	mov	ecx, DPMI_TRAPS_SIZE / 4
	cld
		rep	movsd
	pop	ecx
	pop	edi
	pop	esi

IF 0
	mov	dword ptr fs:[eax], 0000FFFEh		; Invalid opcode
	mov	dword ptr fs:[eax][4], 02000000h	; DPMI, init mode switch
	mov	dword ptr fs:[eax+10h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+10h][4], 02010000h	; Raw pm to vm mode switch
	mov	dword ptr fs:[eax+20h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+20h][4], 02020000h	; Raw vm to pm mode switch
	mov	dword ptr fs:[eax+30h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+30h][4], 03000000h	; Trap return from VM callback
	mov	dword ptr fs:[eax+40h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+40h][4], 04000000h	; Trap return from PM "exception handler".
	mov	dword ptr fs:[eax+50h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+50h][4], 05000000h	; Trap "default exception handler".
	mov	dword ptr fs:[eax+60h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+60h][4], 06000000h	; Trap "default interrupt handler".
	mov	dword ptr fs:[eax+70h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+70h][4], 07000000h	; Trap return from PM "interrupt handler".
	mov	dword ptr fs:[eax+80h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+80h][4], 08000000h	; Trap return from translation services.
	mov	dword ptr fs:[eax+90h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+90h][4], 0A000000h	; Trap return from PM "callback" (breakpoint handler).
	mov	dword ptr fs:[eax+0A0h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+0A0h][4], 0D000000h	; RM save state proc.
	mov	dword ptr fs:[eax+0B0h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+0B0h][4], 0E000000h	; PM save state proc.

IFDEF	FAKE_WINDOWS
	mov	dword ptr fs:[eax+0F0h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+0F0h][4], 0B000000h	; Windows "vendor API entry point".
ENDIF
	mov	dword ptr fs:[eax+100h], 0000FFFEh	; Invalid opcode
	mov	dword ptr fs:[eax+100h][4], 0C000000h	; XMS server entry point.
ENDIF

; Allocate and zero memory descriptors.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	ecx, DPMI_MEM_DESCRIPTORS * SIZEOF DpmiMemDescr

	call	HeapAllocMem
	mov	(DosTask PTR es:[esi]).DpmiMemDescrArr, eax
	mov	edi, eax

	shr	ecx, 2
	sub	eax, eax
		rep	stosd

;
; Copy original DOS base memory and video pages.
;
	mov	ebx, (DosTask PTR es:[esi]).TaskMapping
	sub	edx, edx
	sub	esi, esi
	cld
dup_dos:
	mov	edi, es:[ebx+edx*4]		; es:EDI -> dest page
	mov	ecx, 400h			; Number of dwords in 1 page.
		rep	movs dword ptr es:[edi], es:[esi]

	inc	edx
	cmp	edx, 0A0000h SHR 12		; EDX = pages count
if 0
	cmp	edx, (0A0000h + 40000h) SHR 12		; EDX = pages count
endif
	jb	dup_dos

IFDEF	PROVIDE_HIMEM
;
; Copy original HMA.
;
	mov	edx, 100000h SHR 12
	mov	esi, 100000h
dup_hma:
	mov	edi, es:[ebx+edx*4]		; es:EDI -> dest page
	mov	ecx, 400h			; Number of dwords in 1 page.
		rep	movs dword ptr es:[edi], es:[esi]

	inc	edx
	cmp	edx, 110000h SHR 12		; EDX = pages count
	jb	dup_hma
ENDIF	; PROVIDE_HIMEM

; Increment number of tasks.
	inc	NumOfTasks
	clc
	ret
CreateDosTask	ENDP


;-----------------------------------------------------------------------------
;
;	Destroys DOS task (frees its memory) and transfers control to a
; system core.
;
;	I: EAX = number of task to destroy.
;	O:
;
;	(!) Must be called outside task's address space.
;
;-----------------------------------------------------------------------------
DismemberDosTask	PROC	USES eax ecx edx edi
PUSHCONTEXT	ASSUMES
ASSUME	edx: PTR DosTask
	cmp	eax, NumOfTasks
	jb	destroy_task
	ret

destroy_task:
; FS:EDX -> DOS task being dismembered.
	TASK_PTR	, edx

; If it's DPMI task, clean up.
	cmp	fs:[edx].TaskLdt, 0
	je	free_video_state
	call	DpmiWashUp

free_video_state:
; Free task's video state save space.
	mov	eax, fs:[edx].TaskVideoState
	call	HeapFreePage

	mov	edi, fs:[edx].TaskMapping
; Free page allocated for DPMI needs.
;	mov	eax, fs:[edi+(DPMI_SERVICE_PAGE SHR 10)]
	push	edi
	mov	ecx, DpmiSrvAddr
	shr	ecx, 12
	mov	eax, fs:[edi][ecx*4]
	pop	edi

	mov	ecx, DPMI_MEM_SIZE
	call	HeapFreeMem

; Free memory that could have been allocated with DPMI descriptors.
	mov	esi, DPMI_MEM_DESCRIPTORS * SIZEOF DpmiMemDescr
	mov	ebx, fs:[edx].DpmiMemDescrArr

free_next_descr:
	mov	ecx, (DpmiMemDescr PTR fs:[ebx]).BlockLength
	mov	eax, (DpmiMemDescr PTR fs:[ebx]).BlockAddress

	test	eax, eax
	jz	next_block

; Free memory.
	call HeapFreeMem

next_block:
	sub	esi, SIZEOF DpmiMemDescr
	jnz	free_next_descr

; Free memory allocated for DPMI memory descriptors themselves.
	mov	ecx, DPMI_MEM_DESCRIPTORS * SIZEOF DpmiMemDescr
	mov	eax, fs:[edx].DpmiMemDescrArr
	call	HeapFreeMem

; Free memory allocated for task's base and video memory.
	mov	eax, fs:[edi]			; Get linear address
	mov	ecx, 0A0000h + 40000h
	call	HeapFreeMem

IFDEF	PROVIDE_HIMEM
; Free pages allocated for HMA memory.
	mov	ecx, (10000h SHR 12) - 1	; Number of pages.
free_himem:
	mov	eax, fs:[edi+ecx*4+(100000h SHR 12)*4]	; Get linear address
	call	HeapFreePage

	dec	ecx
	jnl	free_himem
ENDIF	; PROVIDE_HIMEM

; Free page allocated for task alias mapping.
	mov	eax, edi
	call	HeapFreePage

; Free page allocated for task's 1Mb page table.
	mov	edi, fs:[edx].TaskPageCtl
	mov	eax, fs:[edi]
	call	HeapFreePage

; Free page allocated for task's page control array.
	mov	eax, edi
	call	HeapFreePage

; Free page allocated for task's PDB.
	mov	eax, fs:[edx].TaskPdbLin
	call	HeapFreePage

; Free page allocated for task's open files table.
	mov	eax, fs:[edx].TaskOFTable
	call	HeapFreePage

	ret
POPCONTEXT	ASSUMES
DismemberDosTask	ENDP


;-----------------------------------------------------------------------------
;
;	Deletes a DOS task from an array of tasks.
;
;	I: EAX = number of task to delete
;	O:
;
;-----------------------------------------------------------------------------
DeleteTask	PROC	USES es eax ecx edx esi edi
	cmp	eax, NumOfTasks
	jb	delete_task
	ret

delete_task:
; If foreground task is above task being deleted, decrement it.
	cmp	eax, ForegroundTask
	ja	@@F
	dec	ForegroundTask
@@@@:

; If current task is above task being deleted, decrement it.
	cmp	eax, CurrentTask
	ja	@@F
	dec	CurrentTask
	sub	CurrTaskPtr, SIZEOF DosTask

; If next to run task is above task being deleted, decrement it.
	cmp	eax, NextToRun
	ja	@@F
	dec	NextToRun
@@@@:

; If INT 13h semaphore owner is above task being deleted, decrement it.
	cmp	HddSema4, 0
	je	@@F
	cmp	eax, HddSema4Own
	ja	@@F
	dec	HddSema4Own
@@@@:

	cmp	FddSema4, 0
	je	@@F
	cmp	eax, FddSema4Own
	ja	@@F
	dec	FddSema4Own
@@@@:
; If there are tasks above the one being deleted waiting for DMA retirement,
; move them down.
	lea	ecx, [eax+1]
@@@@:
	cmp	ecx, NumOfTasks
	jnb	@@F
	cmp	DmaIoRange[ ecx * 8 ][ 4 ], 0
	je	next_io_range
	mov	edx, DmaIoRange[ ecx * 8 ]
	mov	DmaIoRange[ ecx * 8 ][ -8 ], edx
	mov	edx, DmaIoRange[ ecx * 8 ][ 4 ]
	mov	DmaIoRange[ ecx * 8 ][ -8 ][ 4 ], edx
	mov	DmaIoRange[ ecx * 8 ][ 4 ], 0
next_io_range:
	inc	ecx
	jmp	@@B
@@@@:
	mov	cx, FLAT_DS
	mov	es, cx

	mov	ecx, NumOfTasks
	sub	ecx, eax
	dec	ecx			; ECX = tasks count to move

	TASK_PTR			; eax = offset of the task being
					; deleted.
	mov	edi, eax		; Task to be deleted
	lea	esi, [eax + SIZEOF DosTask]	; Next task

	mov	eax, SIZEOF DosTask
	mul	ecx			; eax = number of bytes to move
	mov	ecx, eax

	cld
		rep	movs byte ptr es:[edi], es:[esi]

	dec	NumOfTasks
	ret
DeleteTask	ENDP


;-----------------------------------------------------------------------------
;
;	Starts a new DOS task.
;
;	I:
;	O: CF = 1 - task can't be created.
;
;	(!) Sets I/O focus to the new task.
;
;-----------------------------------------------------------------------------
PUBLIC	StartTask
StartTask	PROC	USES eax ecx edx
	call	CreateDosTask
	jnc	task_created
	ret

task_created:
; Remove deleted flag set (if any).
	mov	eax, NumOfTasks
	dec	eax

; If first task, only fork it.
	test	eax, eax
	jz	fork_first_task
; Otherwise, switch focus and task context.
	push	eax

	mov	eax, ForegroundTask
	call	SaveOldFocus
	mov	eax, CurrentTask
	call	SaveOldContext

; Mark old current task as ready.
	mov	eax, CurrTaskPtr
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_RUNNING

	pop	eax

fork_first_task:
	mov	CurrentTask, eax
	mov	ForegroundTask, eax

	mov	ecx, eax
	sub	eax, eax
	call	TrapVideoPorts		; Free all video ports.
	call	TrapGenDevPorts		; Trap general devices ports.

	TASK_PTR	ecx		; eax = offset of the task to run
	mov	CurrTaskPtr, eax

; Set task's status to running.
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
	mov	(DosTask PTR fs:[eax]).TaskBlock, 0

; Load task's PDBR.
	mov	edx, (DosTask PTR fs:[eax]).TaskPdbLin
	mov	PdbLin, edx
	mov	edx, (DosTask PTR fs:[eax]).TaskPageCtl
	mov	PagesCtl, edx
	mov	edx, (DosTask PTR fs:[eax]).TaskPdb
	mov	Pdb, edx
	mov	cr3, edx

; System task to 0.
	mov	SystemTask, 0

; Switch to virtual mode.
	sub	eax, eax
	mov	ExcGs, ax
	mov	ExcFs, ax
	mov	ax, DATA
	mov	ExcDs, ax
	mov	ExcEs, ax
	mov	ax, STK
	mov	ExcSs, ax
	mov	ExcEsp, VM_STK

; Set VirtualIF to 1.
	mov	VirtualIf, FL_IF
; No pending interrupts.
	mov	VirtualIp, 0
; No in-service interrupts.
	mov	VirtualIsr, 0
; All interrupts enabled.
	mov	VirtualImr, 0
; Clear keyboard queue.
	mov	eax, KbdQHead
	mov	KbdQTail, eax

; Eflags reg., IOPL=0, IF = 1
	mov	ExcEflags, FL_VM OR FL_IF
	mov	ax, CODE
	mov	ExcSeg, ax
	mov	eax, offset TaskV86Entry
	mov	ExcOffs, eax

	clc
	ret
StartTask	ENDP


;-----------------------------------------------------------------------------
;
;	Stops DOS task, dismembers it and deletes it.
;
;	I: EAX = number of task to stop.
;	O:
;
;	(!) If task to stop is the only DOS task in system, must be called in
; system context.
;
;-----------------------------------------------------------------------------
PUBLIC	StopTask
StopTask	PROC	USES ecx edx
	cmp	eax, NumOfTasks
	jb	stop_task
	ret

stop_task:
; Release general devices semaphores that a task could have held.
	xchg	eax, CurrentTask
	push	eax
	call	RelGenDevSema4s
	pop	eax
	xchg	eax, CurrentTask

; If INT 13h semaphore is owned by task being deleted, force it free. 
; Else just switch to next task.
	cmp	FddSema4, 0
	je	hdd?
	cmp	eax, FddSema4Own
	jne	hdd?

;
; That's an ugly hack. Int13Sema4s() expects CurrentTask to be holding some
; of the semaphores. Should be replaced in the future by the normal
; semaphores.
;
	xchg	eax, CurrentTask
	push	eax
	sub	eax, eax
	call	Int13Sema4s
	pop	eax
	xchg	eax, CurrentTask

	jmp	single?

hdd?:
	cmp	HddSema4, 0
	je	single?
	cmp	eax, HddSema4Own
	jne	single?

; The second part of an ugly hack.
	xchg	eax, CurrentTask
	push	eax
	sub	eax, eax
	call	Int13Sema4s
	pop	eax
	xchg	eax, CurrentTask


single?:
	cmp	NumOfTasks, 1
	jne	not_single

	mov	ecx, SysPdbLin
	mov	PdbLin, ecx
	mov	ecx, SysPagesCtl
	mov	PagesCtl, ecx
	mov	ecx, SysPdb
	mov	Pdb, ecx
	mov	cr3, ecx
	jmp	dismember_task

not_single:
; If task to delete is foreground task, switch focus and clear keyboard queue.
	cmp	eax, ForegroundTask
	jne	is_current?

	mov	ecx, KbdQHead
	mov	KbdQTail, ecx
	call	FocusToNextTask

is_current?:
; If task being stopped is current, force next task.
	cmp	eax, CurrentTask
	jne	dismember_task

; Force task switch.
	push	eax
	mov	eax, CurrentTask
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	call	SwitchTaskTo		; Force task switch
	pop	eax

dismember_task:
; Dismember task.
	call	DismemberDosTask
; Delete task from task list.
	call	DeleteTask

	ret
StopTask	ENDP


;-----------------------------------------------------------------------------
;
;	Saves context of the task being switched from.
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
SaveOldContext	PROC	USES es eax ebx ecx edx
PUSHCONTEXT	ASSUMES
ASSUME	edx: PTR DosTask
	mov	edx, CurrTaskPtr

; Set ES to flat segment.
	mov	ax, FLAT_DS
	mov	es, ax

; Save regsiters.
	lea	ebx, es:[edx].TaskRegs
	lea	ecx, es:[edx].TaskSregs
	call	SaveClientRegs

; Save interrupts state.
	mov	eax, VirtualIf
	mov	es:[edx].TaskVirtualIf, eax
	mov	eax, VirtualIp
	mov	es:[edx].TaskVirtualIp, eax
	mov	eax, VirtualIsr
	mov	es:[edx].TaskVirtualIsr, eax
	mov	eax, VirtualImr
	mov	es:[edx].TaskVirtualImr, eax

	ret
POPCONTEXT	ASSUMES
SaveOldContext	ENDP


;-----------------------------------------------------------------------------
;
;	Switches task using regular basis.
;
;	I: EAX = task to switch to.
;	O: CF = 0 OK
;	      = 1 fail: task # > than number of tasks or blocked. Not switched.
;
;-----------------------------------------------------------------------------
PUBLIC	SwitchTask
SwitchTask	PROC	USES eax edx
; Check if task # is correct
	cmp	eax, NumOfTasks
	jb	task_num_ok
	stc
	ret

task_num_ok:
	cmp	eax, CurrentTask
	jne	@@F
	clc
	ret

@@@@:
; If destination task is blocked, return with CF = 1.
	push	eax
	TASK_PTR
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	pop	eax
	jz	do_switch

	stc
	ret

do_switch:
	call	SwitchTaskTo
	clc
	ret
SwitchTask	ENDP


;-----------------------------------------------------------------------------
;
;	Switches current (running) tasks: address space & context (not I/O
; focus).
;
;	I: EAX = task to switch to.
;	O: CF = 0 OK
;	      = 1 fail (task # > than number of tasks). Not switched.
;
;	(!) Since tasks table is mapped in every address space may run in
; task's space.
;	(!) Interrupts must be disabled.
;	(!) Forces task switch even if target task is blocked.
;
;-----------------------------------------------------------------------------
PUBLIC	SwitchTaskTo
SwitchTaskTo	PROC	USES es eax ebx ecx edx
PUSHCONTEXT	ASSUMES
ASSUME	edx: PTR DosTask
; Check if task # is correct
	cmp	eax, NumOfTasks
	jb	task_num_ok
	stc
	ret

task_num_ok:
; Save registers context of current task.
	call	SaveOldContext

; Update current task.
	xchg	eax, CurrentTask
	mov	edx, CurrTaskPtr
; Mark retired task as not running.
	and	fs:[edx].TaskState, NOT TASK_RUNNING

; Load running task ptr.
	TASK_PTR	CurrentTask, edx
	mov	CurrTaskPtr, edx
	or	fs:[edx].TaskState, TASK_RUNNING
; If the new task is a foreground task, allow video ports. Else trap them.
	mov	eax, CurrentTask
	cmp	eax, ForegroundTask
	mov	eax, 0
	je	@@F
	mov	eax, -1
@@@@:
	call	TrapVideoPorts

; Trap general devices ports in the new task.
	call	TrapGenDevPorts

; Restore registers of task to switch to.
	mov	ax, FLAT_DS
	mov	es, ax
	lea	ebx, es:[edx].TaskRegs
	lea	ecx, es:[edx].TaskSregs
	call	RestoreClientRegs

; Restore interrupts state.
	mov	eax, es:[edx].TaskVirtualIf
	mov	VirtualIf, eax
	mov	eax, es:[edx].TaskVirtualIp
	mov	VirtualIp, eax
	mov	eax, es:[edx].TaskVirtualIsr
	mov	VirtualIsr, eax
	mov	eax, es:[edx].TaskVirtualImr
	mov	VirtualImr, eax

; Switch to task's address space.
	mov	eax, es:[edx].TaskPdbLin
	mov	PdbLin, eax
	mov	eax, es:[edx].TaskPageCtl
	mov	PagesCtl, eax
	mov	eax, es:[edx].TaskPdb
	mov	Pdb, eax
	mov	cr3, eax		; Load PDBR

; Restore DPMI related state.
	cmp	es:[edx].TaskLdt, 0
	je	@@F
	lldt	es:[edx].TaskLdt
	mov	eax, es:[edx].TaskLdtBase
	mov	CurrLdtBase, eax
@@@@:

	clc
	ret
POPCONTEXT	ASSUMES
SwitchTaskTo	ENDP


;-----------------------------------------------------------------------------
;
;	Saves focus context of a task.
;
;	I:
;	O:
;
; (!) Changes context.
;
;-----------------------------------------------------------------------------
SaveOldFocus	PROC	USES es eax ebx ecx edx esi edi
PUSHCONTEXT	ASSUMES
ASSUME	edx: PTR DosTask
	TASK_PTR	ForegroundTask, edx ; ES:EDX -> old foreground's task
					; structure.
; Set ES to flat segment.
	mov	ax, FLAT_DS
	mov	es, ax

; Switch to last foreground's task space.
	mov	eax, es:[edx].TaskPdbLin
	mov	PdbLin, eax
	mov	eax, es:[edx].TaskPageCtl
	mov	PagesCtl, eax
	mov	eax, es:[edx].TaskPdb
	mov	Pdb, eax
	mov	cr3, eax

; Save task's video context.
	mov	edi, es:[edx].TaskVideoState
	call	SaveVideoContext
	call	SaveVideoMemory
; Map old foreground's memory A0000h - BFFFFh to virtual (take from task's
; alias mapping).
	mov	edi, es:[edx].TaskPageCtl
	mov	edi, es:[edi]
	mov	esi, es:[edx].TaskMapping
	mov	ecx, 0A0000h SHR 12

map_virtual_screen:
	mov	eax, es:[esi+ecx*4]
	call	LinearToPhysical
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[edi+ecx*4], eax
	inc	ecx
	cmp	ecx, (0A0000h + 20000h) SHR 12
	jb	map_virtual_screen

	ret
POPCONTEXT	ASSUMES
SaveOldFocus	ENDP


;-----------------------------------------------------------------------------
;
;	Switches current foreground tasks: I/O focus (not address space & 
; context).
;
;	I: EAX = task to switch focus to.
;	O: CF = 0 - OK.
;	        1 - error (not switched).
;
;	(!) This also immediately switches to a task brought to the
; foreground.
;
;-----------------------------------------------------------------------------
PUBLIC	SwitchFocusTo
SwitchFocusTo	PROC	USES es eax ebx ecx edx esi edi

; Check if task # is correct
	cmp	eax, NumOfTasks
	jb	task_num_ok
	stc
	ret

task_num_ok:
; Save video context of foreground task. 
	call	SaveOldFocus

; If old foreground task  was running, trap video ports.
	push	eax
	mov	eax, ForegroundTask
	cmp	eax, CurrentTask
	jne	@@F

	mov	eax, -1
	call	TrapVideoPorts
@@@@:
	pop	eax

; Update foreground task.
	mov	ForegroundTask, eax

; If new foreground task is running, allow video ports.
	push	eax
	mov	eax, ForegroundTask
	cmp	eax, CurrentTask
	jne	@@F

	sub	eax, eax
	call	TrapVideoPorts
@@@@:
	pop	eax
	TASK_PTR	, edx		; ES:EDX -> new foreground's task
					; structure.
	mov	ax, FLAT_DS
	mov	es, ax

; Map new foreground's memory A0000h - BFFFFh to physical 1-to-1. Doing it in
; alien address space saves reload of PDB.
	mov	edi, (DosTask PTR es:[edx]).TaskPageCtl
	mov	edi, es:[edi]
	mov	ecx, 0A0000h SHR 12

map_physical_screen:
	mov	eax, ecx
	shl	eax, 12
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[edi+ecx*4], eax
	inc	ecx
	cmp	ecx, (0A0000h + 20000h) SHR 12
	jb	map_physical_screen

; Switch to new foreground's task space.
	mov	eax, (DosTask PTR es:[edx]).TaskPdbLin
	mov	PdbLin, eax
	mov	eax, (DosTask PTR es:[edx]).TaskPageCtl
	mov	PagesCtl, eax
	mov	eax, (DosTask PTR es:[edx]).TaskPdb
	mov	Pdb, eax
	mov	cr3, eax

; Restore task's video context.
	mov	esi, (DosTask PTR es:[edx]).TaskVideoState
	call	RestoreVideoContext
; Restore task's video memory.
	call	RestoreVideoMemory

	mov	eax, CurrTaskPtr
	mov	edx, (DosTask PTR es:[eax]).TaskPdbLin
	mov	PdbLin, edx
	mov	edx, (DosTask PTR es:[eax]).TaskPageCtl
	mov	PagesCtl, edx
	mov	edx, (DosTask PTR es:[eax]).TaskPdb
	mov	Pdb, edx
	mov	edx, (DosTask PTR fs:[eax]).TaskPdb
	mov	cr3, edx

	clc
	ret
SwitchFocusTo	ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O: EAX = number of not blocked tasks.
;
;	Returns number of not blocked (runnable) tasks.
;
;-----------------------------------------------------------------------------
NonBlockedTasks	PROC	USES ecx edx
	mov	ecx, FirstTask
	sub	edx, edx
	sub	eax, eax

check_task:
	test	(DosTask PTR fs:[ecx]).TaskState, TASK_BLOCKED
	jnz	next_task
	inc	eax
next_task:
	add	ecx, SIZEOF DosTask
	inc	edx
	cmp	edx, NumOfTasks
	jb	check_task

	ret
NonBlockedTasks	ENDP


;-----------------------------------------------------------------------------
;
;	Switches to next task in tasks list.
;
;	I:
;	O:
;
; (!) Doesn't switch if Int 13 semaphore is not free. Increments borrowed
; ticks counter instead.
;
;-----------------------------------------------------------------------------
IFDEF	BORROWED_TICKS
; Borrowed ticks strategy.
PUBLIC	NextTask
NextTask	PROC	USES	eax ebx ecx edx esi edi
; If only one task exists, return.
	cmp	NumOfTasks, 1
	ja	@@F
	ret
@@@@:
; If current task is locked, return.
;	mov	eax, CurrTaskPtr
;	test	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
;	jz	@@F
;	ret
;@@@@:
; If all tasks are blocked, return.
	call	NonBlockedTasks
	test	eax, eax
	jnz	@@F
	ret
@@@@:
	cmp	NextToRun, -1
	jne	switch?

; If (NextToRun == -1), update it with valid value.
	mov	eax, CurrentTask
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	mov	NextToRun, eax
switch?:
	mov	eax, NextToRun
; If next task (in EAX) doesn't have borrowed ticks, switch to it.
	mov	ecx, eax
	TASK_PTR
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jz	init_borrowed 
	mov	esi, 0FFFFFFFFh			; Impossible value for borrowed ticks.
	jmp	find_less_borrowed

; The task has borrowed ticks. Verify what task has the least number of
; borrowed ticks and switch to it. Decrement borrowed ticks of former next.
; EBX is a tested task pointer, EDI holds next task on exit. ESI holds tick
; counter of the former candidate. ECX is a task that was supposed to be
; next.
init_borrowed:
	mov	esi, (DosTask PTR fs:[eax]).BorrowedTicks
find_less_borrowed:
	mov	ebx, ecx
	mov	edi, ecx

find_next_task:
	test	esi, esi		; If 0 borrowed ticks found, switch.
	jz	next_task_found

	inc	ebx
	cmp	ebx, NumOfTasks
	jb	@@F
	sub	ebx, ebx
@@@@:
	cmp	ebx, ecx
	je	next_task_found

; If task is not blocked and borrowed ticks are less, set values.
	TASK_PTR	ebx
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jnz	find_next_task
	cmp	esi, (DosTask PTR fs:[eax]).BorrowedTicks
	jna	find_next_task

	mov	edi, ebx
	jmp	find_next_task
next_task_found:
	mov	eax, edi
	call	SwitchTask

; If next task to switch to is NextToRun anyway, update next to run.
	cmp	eax, NextToRun
	je	update_next_to_run

	TASK_PTR	NextToRun
	dec	(DosTask PTR fs:[eax]).BorrowedTicks
	ret

; Update NextToRun task.
update_next_to_run:
	mov	eax, NextToRun
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	mov	NextToRun, eax
	ret
NextTask	ENDP

ELSE
; No borrowed ticks strategy.

PUBLIC	NextTask
NextTask	PROC	USES	eax ebx ecx edx esi edi
; If only one task exists, return.
	cmp	NumOfTasks, 1
	ja	@@F
	ret
@@@@:
; If current task is locked, return.
;	mov	eax, CurrTaskPtr
;	test	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
;	jz	@@F
;	ret
;@@@@:
; If all tasks are blocked, return.
	call	NonBlockedTasks
	test	eax, eax
	jnz	first_run?
	ret

first_run?:
	cmp	NextToRun, -1
	jne	switch?

; If (NextToRun == -1), update it with valid value.
	mov	eax, CurrentTask
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	mov	NextToRun, eax
switch?:
	mov	eax, NextToRun
find_non_blocked:
	call	SwitchTask
	jnc	update_next_to_run

	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	jmp	find_non_blocked	; Should not dead lock here.

; Update NextToRun task.
update_next_to_run:
	mov	eax, NextToRun
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	mov	NextToRun, eax
	ret
NextTask	ENDP

ENDIF

;-----------------------------------------------------------------------------
;
;	Switches focus to next task in tasks list.
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	FocusToNextTask
FocusToNextTask	PROC	USES eax
	mov	eax, ForegroundTask
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	call	SwitchFocusTo
	ret
FocusToNextTask	ENDP


;-----------------------------------------------------------------------------
;
;	Callback for excetions traps. Traps GPF.
;
;-----------------------------------------------------------------------------
PUBLIC	ExcRedirect
ExcRedirect	PROC	USES eax ebx ecx edx esi edi ebp

; Check if the exception was in VM.
	test	ExcEflags, FL_VM
	jnz	check_opcode
; Check if exception was in CPL 3 code.
	test	ExcSeg, 3
	jnz	check_opcode
	stc
	ret

; Check if was due to sensitive instructions.
check_opcode:

	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear

	mov	ebx, eax
	call	SkipPrefixes	; Skip & set prefixes.

; ECX keeps pointer to faulting opcode. Required for HddSema4s.
	mov	ecx, eax

	neg	ebx
	lea	ebp, [ebx+eax]	; EBP keeps number of bytes to skip.
	mov	eax, fs:[eax]	; Get 2 bytes of opcode.

	cmp	al, OP_CLI
	jne	sti?

; Do CLI for a client.
	mov	VirtualIf, 0
	inc	ebp
	add	ExcOffs, ebp

	clc
	ret

sti?:
	cmp	al, OP_STI
	jne	int?

; Do STI for a client.
	mov	VirtualIf, FL_IF
	inc	ebp
	add	ExcOffs, ebp

	clc
	ret

int?:
	cmp	al, OP_INT
	jne	iret?

; If system task is running, go ahead.
	cmp	SystemTask, 0
	jne	default_int

; Check if specific handling is applied.
	cmp	ah, 13h
	je	handle_int_13
	cmp	ah, 15h
	je	handle_int_15
	cmp	ah, 16h
	je	handle_int_16
	cmp	ah, 28h
	je	handle_int_28
	cmp	ah, 21h
	je	handle_int_21
	cmp	ah, 2Fh
	je	handle_int_2f
	cmp	ah, 31h
	je	handle_int_31
	jmp	default_int

; INT 13h specific handling.
handle_int_13:
	test	byte ptr ExcEdx, 80h
	jnz	hdd

; Floppy access.
	cmp	FddSema4, 0
	je	acquire_int13_sema4
	mov	edx, CurrentTask
	cmp	edx, FddSema4Own
	je	default_int
; If INT 13h is called by not INT 13h owner, block the caller.
	mov	eax, CurrTaskPtr
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, FDD_SEMA4
	clc
	ret

hdd:
	cmp	HddSema4, 0
	je	acquire_int13_sema4
	mov	edx, CurrentTask
	cmp	edx, HddSema4Own
	je	default_int
; If INT 13h is called by not INT 13h owner, block the caller.
	mov	eax, CurrTaskPtr
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, HDD_SEMA4
	clc
	ret

acquire_int13_sema4:
; Acquire INT 13h semaphore.
	push	eax
	mov	eax, 1
	call	Int13Sema4s
	pop	eax
	jmp	default_int

; INT 15h specific handling.
handle_int_15:
	jmp	default_int

; INT 16h specific handling.
handle_int_16:
	cmp	byte ptr ExcEax[1], 0		; AH = 0?
	je	@@F
	cmp	byte ptr ExcEax[1], 10h		; AH = 10h?
	jne	default_int

@@@@:
; If keyboard buffer is not empty, go on.
	mov	cx, fs:[41Ah]
	cmp	cx, fs:[41Ch]
	jne	default_int
; If empty but keyboard interrupt is pending, go on (don't lock).
	test	VirtualIp, 2
	jnz	default_int

; Lock task on INT 16h.
	mov	eax, CurrTaskPtr
; If all tasks are blocked, don't lock, just let caller loop on GPF.
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	call	NextTask
	clc
	ret

; INT 28h specific handling.
handle_int_28:
; If INT 28h handler is not IRET, go on.
	movzx	edx, word ptr fs:[28h*4+2]
	movzx	ecx, word ptr fs:[28h*4]
	shl	edx, 4
	add	edx, ecx
	cmp	byte ptr fs:[edx], OP_IRET
	jne	default_int

check_kbd_buf:
; If keyboard buffer is not empty, go on.
	mov	cx, fs:[41Ah]
	cmp	cx, fs:[41Ch]
	jne	default_int

; If empty but keyboard interrupt is pending, go on.
	test	VirtualIp, 2
	jnz	default_int

; Release processor to another task - DOS is idle.
	add	ebp, 2
	add	ExcOffs, ebp
	call	NextTask
	clc
	ret

; INT 21h specific handling.
handle_int_21:
	mov	ecx, ExcEax
	cmp	ch, 0Eh
	jne	@@F

; Set default drive. Keep track of default drives for every task.
	push	eax
	mov	eax, CurrTaskPtr
	mov	dl, byte ptr ExcEdx
	mov	(DosTask PTR fs:[eax]).TaskCurrDrive, dl
	pop	eax
	jmp	default_int

@@@@:
	cmp	ch, 4Ch
	jne	@@F

; If INT 21h/4Ch is executed in protected mode, call DPMI clean up.
	mov	edx, CurrTaskPtr
	cmp	(DosTask PTR fs:[edx]).TaskLdt, 0
	je	default_int

	test	ExcEflags, FL_VM
	jnz	default_int

	call	DpmiWashUp
; Set V86 mode.
	or	ExcEflags, FL_VM
; Set locked RM stack.
	mov	ExcSs, VM_LOCKED_SS
	mov	eax, CurrTaskPtr
	mov	eax, (DosTask PTR fs:[eax]).DpmiRmEsp
	mov	ExcEsp, eax

	mov	ah, 21h			; Get interrupt number in AH.
	jmp	default_int

@@@@:
	cmp	ch, 50h
	jne	@@F

	mov	ecx, CurrTaskPtr
	cmp	(DosTask PTR fs:[ecx]).TaskLdt, 0
	mov	ah, 21h			; Get interrupt number in AH.
	je	default_int

	mov	eax, ExcEbx
	mov	(DosTask PTR fs:[ecx]).TaskCurrentId, ax
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

@@@@:
	cmp	ch, 51h
	je	get_curr_pid
	cmp	ch, 62h
	jne	@@F

get_curr_pid:
	mov	ecx, CurrTaskPtr
	cmp	(DosTask PTR fs:[ecx]).TaskLdt, 0
	mov	ah, 21h			; Get interrupt number in AH.
	je	default_int

	mov	ax, (DosTask PTR fs:[ecx]).TaskCurrentId
	mov	word ptr ExcEbx, ax
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

@@@@:
mov	ah, 21h
jmp	default_int
; For any function that opens file a file is written to open file structure.
; No suppositions are made if the file was already opened by this task.
	cmp	ch, 3Ch
	je	test_open
	cmp	ch, 3Dh
	jne	@@F
	test	cl, 3
	jz	default_int
	jmp	test_open
@@@@:
	je	test_open
	cmp	ch, 41h
	je	test_open
	cmp	cx, 4301h
	je	test_open
	cmp	cx, 6C00h
	je	test_open
	cmp	ch, 3Eh
	je	set_int21_trap
	jmp	default_int
test_open:

; Check if sharing violation is not occuring.
	call	IsFileOpen
	jnc	set_int21_trap

; Deny access. Return sharing violation error.
	or	ExcEflags, FL_CF
	mov	ExcEax, 5
	mov	eax, CurrTaskPtr
	mov	(DosTask PTR fs:[eax]).TaskErrCode, 5
	add	ebp, 2
	add	ExcOffs, ebp
	ret

set_int21_trap:
; Set return trap for INT 21h.
	push	eax

	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	edx, eax

	mov	eax, CurrTaskPtr
	mov	(DosTask PTR fs:[eax]).DosFunc, cx

; Trap return instruction.
	mov	ecx, fs:[edx+2]
	mov	(DosTask PTR fs:[eax]).Int21TrapOp, ecx
	mov	ecx, fs:[edx+2][4]
	mov	(DosTask PTR fs:[eax]).Int21TrapOp[4], ecx
; Write invalid opcode instead.
	mov	dword ptr fs:[edx+2], 0000FFFEh
	mov	dword ptr fs:[edx+2][4], 00210000h

;	or	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED

	pop	eax
	jmp	default_int

handle_int_2f:
;	test	ExcEflags, FL_VM
;	jnz	@@F
;	mov	ecx, ExcEax
;int 3
;@@@@:

IFDEF	FAKE_WINDOWS
IF 0
; Fake report Windows 3.0. This code disables Watcom's W32RUN from running.
	cmp	word ptr ExcEax, 1600h
	jne	@@F
	mov	word ptr ExcEax, 0003h
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

@@@@:
ENDIF
; Fake Windows vendor specific entry point.
	cmp	word ptr ExcEax, 168Ah
	jne	normal_func

	mov	si, ExcDs
	mov	edi, ExcEsi
	mov	ebx, ExcEflags
	mov	ecx, CurrTaskPtr
	test	(DosTask PTR fs:[ecx]).TaskFlags, TASK_32BIT
	jnz	@@F
	and	edi, 0FFFFh
@@@@:
	call	PointerToLinear

; Is vendor name "MS-DOS"?
	cmp	dword ptr fs:[eax], 'M' + ('S' SHL 8) + ('-' SHL 16) + ('D' SHL 24 )
	jne	wrong_vendor_name
	cmp	word ptr fs:[eax][4], 'O' + ('S' SHL 8)
	jne	wrong_vendor_name

; Return LDT alias entry point.
	mov	ax, PmCallbackCs
	mov	ExcEs, ax
	mov	eax, WIN_VENDOR_API_ENTRY
	test	(DosTask PTR fs:[ecx]).TaskFlags, TASK_32BIT
	jnz	@@F
	mov	ExcEdi, eax
	jmp	ret_vendor_api
@@@@:
	mov	word ptr ExcEdi, ax

ret_vendor_api:
	and	ExcEflags, NOT FL_CF
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

wrong_vendor_name:
	or	ExcEflags, FL_CF
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

normal_func:
ENDIF

;
;	For the preliminary release the DPMI support is eliminated
; pending further development and testing.
;
; (!) v0.48 - XMS is enabled.
;

	cmp	word ptr ExcEax, 4300h		; XMS installation check.
	je	xms_install_check
	cmp	word ptr ExcEax, 4310h		; XMS get entry
	je	xms_get_entry
;jmp	default_int
	cmp	word ptr ExcEax, 1687h		; DPMI get info and entry.
	je	get_entry
	cmp	word ptr ExcEax, 1686h		; DPMI get current mode.
	je	get_current_mode
	jmp	default_int

xms_get_entry:
;	mov	ExcEs, XMS_ENTRY_SEG		; XMS server entry point
	mov	cx, DpmiSrvSeg
	mov	ExcEs, cx
	mov	word ptr ExcEbx, XMS_ENTRY_OFFS
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

xms_install_check:
	mov	byte ptr ExcEax, 80h		; XMS is present.
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

get_current_mode:
; Get current mode.
	mov	word ptr ExcEax, 0		; Protected mode
	test	ExcEflags, FL_VM
	jz	@@F
	inc	word ptr ExcEax			; V86 mode
@@@@:
	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret
	
get_entry:
	mov	word ptr ExcEax, 0		; DPMI support
	mov	word ptr ExcEbx, 1		; 32-bit support
	mov	al, byte ptr Cpu
	mov	byte ptr ExcEcx, al		; CPU type
	mov	word ptr ExcEdx, 90		; DPMI version
	mov	word ptr ExcEsi, 0		; No paragraphs to allocate
	mov	ExcEs, INIT_SWITCH_SEG
	mov	word ptr ExcEdi, INIT_SWITCH_OFFS ; Switch address.

	add	ebp, 2
	add	ExcOffs, ebp
	clc
	ret

handle_int_31:
; If INT 31h in V86 mode, resirect.
	test	ExcEflags, FL_VM
	jnz	default_int

	add	ebp, 2
	add	ExcOffs, ebp
	call	Int31Handler
	clc
	ret

default_int:
; Do INT xx for VM client.
	add	ebp, 2
	add	ExcOffs, ebp

	movzx	eax, ah
	call	SimulateInt
	clc
	ret				; Done

iret?:
	cmp	al, OP_IRET
	jne	pushf?

; If in protected mode unhandled exception.
;	test	ExcEflags, FL_VM
;	jz	violate

; Emulate IRET for VM client.
	mov	al, OperandSize
	call	EmulateIret

	clc
	ret

pushf?:
	cmp	al, OP_PUSHF
	jne	popf?

	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear		; FS:EAX points to VM client's stack.

	cmp	OperandSize, 0
	je	@@F

; Emulate PUSHFD.
	sub	word ptr ExcEsp, 4	; Adjust client SP

	and	ebx, NOT (FL_IF OR FL_VM)
	or	ebx, VirtualIf		; Merge with VirtualIf.
	or	ebx, FakeIopl		; Merge with fake IOPL.
	mov	fs:[eax-4], bx		; "Push" client flags.
	inc	ebp
	add	ExcOffs, ebp
	clc
	ret

@@@@:
; Emulate PUSHF.
	sub	word ptr ExcEsp, 2	; Adjust client SP

	and	ebx, NOT FL_IF		; Clear IF.
	or	ebx, VirtualIf		; Merge with VirtualIf.
	or	ebx, FakeIopl		; Merge with fake IOPL.

	mov	fs:[eax-2], bx		; "Push" client flags
	inc	ebp
	add	ExcOffs, ebp
	clc
 	ret

popf?:
	cmp	al, OP_POPF
	jne	violate

	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear		; FS:EAX points to VM client's stack.

	mov	edx, fs:[eax]		; Get (E)flags in (E)DX.
	mov	FakeIopl, edx		; Save fake IOPL value.
	and	FakeIopl, 3000h

	and	edx, NOT 3000h		; IOPL = 0.
; Set VirtualIf appropriately.
	mov	VirtualIf, 0
	test	edx, FL_IF
	jz	@@F
	mov	VirtualIf, FL_IF
@@@@:
	or	edx, FL_IF
	cmp	OperandSize, 0
	je	@@F

; Emulate POPFD.
	and	edx, NOT FL_VM
	and	ExcEflags, FL_VM
	or	ExcEflags, edx		; "Pop" client flags, merge with VM.
	add	word ptr ExcEsp, 4	; Adjust client SP
	inc	ebp
	add	ExcOffs, ebp
	clc
 	ret

@@@@:
; Emulate POPF.
	mov	word ptr ExcEflags, dx	; "Pop" client flags
	add	word ptr ExcEsp, 2	; Adjust client SP
	inc	ebp
	add	ExcOffs, ebp
	clc
 	ret

violate:
	stc
	ret

ExcRedirect	ENDP


;-----------------------------------------------------------------------------
;
;	Emulates IRET(d) instruction.
;
;	I:	AL = 0 - 16-bit IRET
;		    = 1 - 32-bit IRET.
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	EmulateIret
EmulateIret	PROC	USES eax ebx ecx edx esi edi
	mov	cl, al		; Keep operand size.

; Do IRET for the VM client.
	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear		; FS:EAX points to VM client's stack.

	test	cl, cl
	jz	emul_iret

; Emulate IRETD.
	mov	edx, fs:[eax]		; "POP" client EIP
	mov	ExcOffs, edx
	mov	edx, fs:[eax+4]		; "POP" client CS
	mov	ExcSeg, dx

	mov	edx, fs:[eax+8]		; "POP" client flags
	mov	FakeIopl, edx		; Alter fake IOPL.
	and	FakeIopl, 3000h
	and	edx, NOT 3000h		; IOPL = 0

; Set VirtualIf appropriately.
	mov	VirtualIf, edx
	and	VirtualIf, FL_IF

	or	edx, FL_IF		; Real IF will always be 1.
	and	ExcEflags, FL_VM
	and	edx, NOT FL_VM
	or	ExcEflags, edx		; Merge with previous VM value
	add	ExcEsp, 12		; Adjust client SP
	jmp	done

emul_iret:
; Emulate IRET.
	mov	edx, fs:[eax]		; "POP" client IP
	mov	word ptr ExcOffs, dx
	mov	edx, fs:[eax+2]		; "POP" client CS
	mov	ExcSeg, dx

	mov	edx, fs:[eax+4]		; "POP" client flags
	mov	FakeIopl, edx		; Alter fake IOPL.
	and	FakeIopl, 3000h
	and	edx, NOT 3000h		; IOPL = 0
; Set VirtualIf appropriately.
	mov	VirtualIf, edx
	and	VirtualIf, FL_IF

	or	edx, FL_IF		; Real IF will always be 1.
	mov	word ptr ExcEflags, dx
	add	ExcEsp, 6		; Adjust client SP

done:
	ret				; Done

EmulateIret	ENDP


;-----------------------------------------------------------------------------
;
;	Simulates client interrupt.
;
;	I: EAX = int. number.
;	O:
;
;	(!) Can reflect VM to VM, VM to PM, PM to VM or PM to PM.
;
;-----------------------------------------------------------------------------
PUBLIC	SimulateInt
SimulateInt	PROC	near32	USES eax ebx ecx edx esi edi ebp
	mov	ecx, eax

; If system task, reflect to VM.
	cmp	SystemTask, 0
	jne	reflect_to_vm

; If DPMI not initialized, reflect to VM.
	mov	eax, CurrTaskPtr
	cmp	(DosTask PTR fs:[eax]).TaskLdt, 0
	je	reflect_to_vm

; If DPMI handler is not installed, reflect DPMI to VM (check from what later).
	mov	ebp, (DosTask PTR fs:[eax]).DpmiPmInts
	cmp	dword ptr fs:[ebp+ecx*8][4], 0
	je	reflect_dpmi2vm

; Interrupt hook is installed. If arrived from PM, go to PM handler.
	test	ExcEflags, FL_VM
	jz	reflect_pm2pm

; If occured in VM, only interrupt 1Ch, 23h and 24h and h/w ints go to PM handler.
	cmp	ecx, 1Ch
	je	reflect_vm2pm
	cmp	ecx, 23h
	je	reflect_vm2pm
	cmp	ecx, 24h
	je	reflect_vm2pm
	cmp	ecx, 8
	jb	reflect_to_vm
	cmp	ecx, 0Fh
	jna	reflect_vm2pm
	cmp	ecx, 70h
	jb	reflect_to_vm
	cmp	ecx, 77h
	jna	reflect_vm2pm
	jmp	reflect_to_vm

reflect_dpmi2vm:
	test	ExcEflags, FL_VM
	jz	reflect_pm2vm

IFDEF	LOG_DPMI
	pushad
	mov	eax, ecx
	PRINT_LOG	ReflectVM2VMStr
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEax
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
	LOG_STATE	1
ENDIF
	jmp	reflect_to_vm

PUBLIC	SimulatePmInt
SimulatePmInt::
; Set stack frame.
	push	eax
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	push	ebp

; If interrupt handler is not installed, jump to unhandled exception.
	mov	ebx, CurrTaskPtr
	mov	ebp, (DosTask PTR fs:[ebx]).DpmiPmInts
	cmp	dword ptr fs:[ebp+eax*8][4], 0

EXTRN	unhandled_exc: near32
	je	unhandled_exc

; Keep interrupt number in ECX.
	mov	ecx, eax

; Reflect PM to PM.
reflect_pm2pm:

IFDEF	LOG_DPMI
	pushad
	mov	eax, ecx
	PRINT_LOG	ReflectPM2PMStr
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEax
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
	LOG_STATE
ENDIF

IFDEF MONITOR_DPMI
extrn	LogX: byte
extrn	LogY: byte
extrn	LogClr: byte

pushad
	PM_PRINT_HEX16	0A001h, LogX, LogY, LogClr
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
ENDIF

; Interrupts 0..7 are called with virtual interrupts disabled
	cmp	ecx, 7
	jna	@@F
	mov	VirtualIf, 0
@@@@:
	test	(DosTask PTR fs:[eax]).TaskFlags, TASK_32BIT
	jz	pm_int_16bit

; 32 bit task.
	sub	ExcEsp, 12
	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear

	mov	ebx, ExcOffs
	mov	fs:[eax], ebx		; Return EIP
	mov	bx, ExcSeg
	mov	fs:[eax][4], bx		; Return CS

; Merge eflags with VirtualIf.
	mov	ebx, ExcEflags
	and	ebx, NOT FL_IF
	or	ebx, VirtualIf

	mov	fs:[eax][8], ebx	; Return Eflags
	jmp	reflect_to_pm

; 16 bit task.
pm_int_16bit:
	sub	ExcEsp, 6
	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear

	mov	ebx, ExcOffs
	mov	fs:[eax], bx		; Return IP
	mov	bx, ExcSeg
	mov	fs:[eax][2], bx		; Return CS

; Merge eflags with VirtualIf.
	mov	ebx, ExcEflags
	and	ebx, NOT FL_IF
	or	ebx, VirtualIf

	mov	fs:[eax][4], bx		; Return flags
	jmp	reflect_to_pm

; Reflect interrupt that occured in VM to PM.
reflect_vm2pm:

IFDEF	LOG_DPMI
	pushad
	mov	eax, ecx
	PRINT_LOG	ReflectVM2PMStr
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEax
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
	LOG_STATE
ENDIF

IFDEF MONITOR_DPMI
extrn	LogX: byte
extrn	LogY: byte
extrn	LogClr: byte

pushad
	PM_PRINT_HEX16	0A002h, LogX, LogY, LogClr
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
ENDIF

	pushad
	sub	al, al
	call	RmSaveState
	popad

	mov	esi, CurrTaskPtr

; Load protected mode stack.
	mov	eax, (DosTask PTR fs:[esi]).DpmiPmStack

	test	(DosTask PTR fs:[esi]).TaskFlags, TASK_32BIT
	jz	@@F

;
; VM to 32 bit task.
;

; Put return address on stack.
	mov	dword ptr fs:[eax-12], PM_RET_INT_OFFS
	mov	bx, PmCallbackCs
	mov	fs:[eax-12][4], bx
	mov	ebx, ExcEflags
	and	ebx, NOT FL_VM
	mov	fs:[eax-12][8], ebx
	mov	eax, 12			; Number of bytes to subtract.
	jmp	zero_seg_regs

;
; VM to 16-bit task.
;
@@@@:
	mov	word ptr fs:[eax-6], PM_RET_INT_OFFS
	mov	bx, PmCallbackCs
	mov	fs:[eax-6][2], bx
	mov	ebx, ExcEflags
	mov	fs:[eax-6][4], bx
	mov	eax, 6			; Number of bytes to subtract.

; Set data segment regs to 0, set SS:ESP and Eflags to protected mode.
zero_seg_regs:
	mov	ExcDs, 0
	mov	ExcEs, 0
	mov	ExcFs, 0
	mov	ExcGs, 0

	mov	bx, PmCallbackSs
	or	bx, 3
	mov	ExcSs, bx
	mov	ebx, (DosTask PTR fs:[esi]).DpmiPmEsp

	sub	ebx, eax
	mov	ExcEsp, ebx
	and	ExcEflags, NOT FL_VM

reflect_to_pm:
	mov	eax, fs:[ebp+ecx*8]
	mov	ExcOffs, eax
	mov	ebx, fs:[ebp+ecx*8][4]
	or	ebx, 3
	mov	ExcSeg, bx

; For interrupts 0-5, 7 clear TF and IF.
	cmp	ecx, 6
	jb	goto_handler
	cmp	ecx, 7
	je	goto_handler

; For others don't change state of TF and virtual IF.
	ret

;
;	Entry point for default DPMI interrupt handler.
;
PUBLIC	SimulateV86Int
SimulateV86Int::
; Set stack frame.
	push	eax
	push	ebx
	push	ecx
	push	edx
	push	esi
	push	edi
	push	ebp

reflect_pm2vm:
; ECX = interrupt #.

IFDEF	LOG_DPMI
	pushad
	mov	eax, ecx
	PRINT_LOG	ReflectPM2VMStr
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEax
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
	LOG_STATE
ENDIF

IFDEF MONITOR_DPMI
extrn	LogX: byte
extrn	LogY: byte
extrn	LogClr: byte

pushad

	PM_PRINT_HEX16	0A000h, LogX, LogY, LogClr
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad

pushad
	mov	bl, LogClr
	or	bl, 70h
	PM_PRINT_HEX16	, LogX, LogY, bl
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad

pushad
	mov	bl, LogClr
	or	bl, 70h
	PM_PRINT_HEX16	word ptr ExcEax, LogX, LogY, bl
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad

pushad
	mov	bl, LogClr
	or	bl, 70h
	PM_PRINT_HEX16	word ptr ExcEbx, LogX, LogY, bl
	add	LogX, 5
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad

endif

IFDEF	MONITOR_LOCKED_PM_STACK
pushad
	PM_PRINT_HEX32	ExcEsp, LogX, LogY, LogClr
	add	LogX, 9
	cmp	LogX, 72
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
ENDIF

IFDEF	FAKE_WINDOWS
; Try to translate selectors to segments.
EXTRN	XlatSegments: near32
;	call	XlatSegments
ENDIF

	pushad
	sub	al, al
	call	PmSaveState
	popad

; Change stack to locked RM stack.
	mov	eax, CurrTaskPtr		; EAX -> current task.
	mov	ebx, (DosTask PTR fs:[eax]).DpmiRmEsp
	mov	ExcEsp, ebx
	mov	ExcSs, VM_LOCKED_SS

; Set segment registers to some distinct values.
	mov	ExcDs, VM_LOCKED_SS
	mov	ExcEs, VM_LOCKED_SS
	mov	ExcFs, VM_LOCKED_SS
	mov	ExcGs, VM_LOCKED_SS

; Set up return trap index.
	cmp	ecx, 21h
	jne	set_gen_ret_trap
	cmp	byte ptr ExcEax[1], 48h
	jne	@@F

; Set index of return trap - return from DOS alloc.
	mov	byte ptr fs:[RET_TRAP_ADDR + 6], 0
	jmp	set_ret_trap_addr

@@@@:
	cmp	byte ptr ExcEax[1], 49h
	jne	@@F

; Set index of return trap - return from DOS free.
	mov	byte ptr fs:[RET_TRAP_ADDR + 6], 1
	jmp	set_ret_trap_addr

@@@@:
	cmp	byte ptr ExcEax[1], 4Ah
	jne	set_gen_ret_trap

; Set index of return trap - return from DOS resize.
	mov	byte ptr fs:[RET_TRAP_ADDR + 6], 2
	jmp	set_ret_trap_addr

; Set up return trap for generic interrupt.
set_gen_ret_trap:
	mov	byte ptr fs:[RET_TRAP_ADDR + 6], 3

set_ret_trap_addr:
; Set up return trap address.
	mov	ExcSeg, RET_TRAP_SEG
	mov	ExcOffs, RET_TRAP_OFFS
; Change state to virtual mode.
	or	ExcEflags, FL_VM

reflect_to_vm:
	mov	eax, fs:[ecx*4]		; Get interrupt vector address.
	sub	word ptr ExcEsp, 6	; Adjust client SP
	movzx	ebx, ExcSs
	shl	ebx, 4
	movzx	edx, word ptr ExcEsp
	add	ebx, edx		; FS:EBX points to VM client's stack.
	mov	edx, ExcEflags
; Merge with VirtualIf.
	and	edx, NOT FL_IF
	or	edx, VirtualIf
	mov	fs:[ebx+4], dx		; "Push" client flags
	mov	dx, ExcSeg
	mov	fs:[ebx+2], dx		; "Push" client CS
	mov	edx, ExcOffs
	mov	fs:[ebx], dx		; "Push" client return IP

	ror	eax, 16
	mov	ExcSeg, ax		; Store segment part of return
					; address to go to int handler.
	shr	eax, 16
	mov	ExcOffs, eax

goto_handler:
	and	ExcEflags, NOT FL_TF	; clear TF on handler entry
	mov	VirtualIf, 0		; Virtual CLI.
	ret
SimulateInt	ENDP


;-----------------------------------------------------------------------------
;
;	INT 13h return callback. Restores trapped instruction and releases
; INT 13h semaphore.
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	Int13RetTrap
Int13RetTrap	PROC	USES eax ebx ecx edx esi edi

; Copy saved opcode back.
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ecx, eax

	mov	eax, CurrentTask
	cmp	eax, HddSema4Own
	jne	@@F

; Opcode was trapped with HDD semaphore.
	mov	eax, dword ptr Int13RetOp
	mov	fs:[ecx], eax
	mov	eax, dword ptr Int13RetOp[4]
	mov	fs:[ecx][4], eax
	jmp	rel_int13_sema4

@@@@:
; Opcode was trapped with FDD semaphore.
	mov	eax, dword ptr Int13RetOp[8]
	mov	fs:[ecx], eax
	mov	eax, dword ptr Int13RetOp[8][4]
	mov	fs:[ecx][4], eax

rel_int13_sema4:
	sub	eax, eax
	call	Int13Sema4s

; If current task (that owned a semaphore) has borrowed ticks, NextTask().
IFDEF	BORROWED_TICKS
	mov	eax, CurrTaskPtr
	cmp	(DosTask PTR fs:[eax]).BorrowedTicks, 0
	je	ok_ret
ENDIF
	call	NextTask

	ret
Int13RetTrap	ENDP


;-----------------------------------------------------------------------------
;
;	Deals with INT 13h semaphores (gets/releases).
;
;	I: EAX = 1	-	acquire semaphore
;	         0	-	release semaphore
;
;	On input FS:ECX -> faulting instruction.
;
;-----------------------------------------------------------------------------
PUBLIC	Int13Sema4s
Int13Sema4s	PROC	USES eax ebx ecx edx
	test	eax, eax
	jz	rel_sema4
	
; Acquire semaphore.
	mov	edx, ExcEdx
	test	edx, 80h		; Try to access HDD?
	jnz	@@F

	xchg	al, FddSema4
	test	al, al
	jnz	fail_ret

	mov	eax, fs:[ecx+2]
	mov	dword ptr Int13RetOp[8], eax
	mov	eax, fs:[ecx+2][4]
	mov	dword ptr Int13RetOp[8][4], eax
	jmp	trap_ret_instr

@@@@:
	xchg	al, HddSema4
	test	al, al
	jnz	fail_ret

	mov	eax, fs:[ecx+2]
	mov	dword ptr Int13RetOp, eax
	mov	eax, fs:[ecx+2][4]
	mov	dword ptr Int13RetOp[4], eax

; Trap return instruction.
trap_ret_instr:
; Write invalid opcode instead.
	mov	dword ptr fs:[ecx+2], 0000FFFEh
	mov	dword ptr fs:[ecx+2][4], 00130000h

; Set semaphore owner.
	test	edx, 80h		; Try to access HDD?
	jnz	@@F

	mov	eax, CurrentTask
	mov	FddSema4Own, eax
	jmp	ok_ret

@@@@:
	mov	eax, CurrentTask
	mov	HddSema4Own, eax
	jmp	ok_ret

rel_sema4:
;
;	Release semaphore. The following assumes that one task can't hold
; both HddSema4 and FddSema4, i.e. that INT 13h cannot be called recursively.
;
	cmp	HddSema4, 0
	je	release_fdd

	mov	ebx, HddSema4Own
	cmp	ebx, CurrentTask
	jne	release_fdd

	xchg	al, HddSema4
	mov	ebx, HDD_SEMA4
	jmp	release_sema4

release_fdd:
	mov	ebx, FddSema4Own
	cmp	ebx, CurrentTask
	jne	ok_ret

	xchg	al, FddSema4
	mov	ebx, FDD_SEMA4

release_sema4:
	mov	edx, ebx
	not	edx
; Release all blocked on HDD semaphore tasks from block.
	mov	eax, FirstTask
	mov	ecx, NumOfTasks
rel_blocked_tasks:
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jz	@@F
	test	(DosTask PTR fs:[eax]).TaskBlock, bl
	jz	@@F
	and	(DosTask PTR fs:[eax]).TaskBlock, dl
	jnz	@@F
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
@@@@:
	add	eax, SIZEOF DosTask
	dec	ecx
	jnz	rel_blocked_tasks

ok_ret:
	clc
	ret
fail_ret:
; Should not occur(!)
	stc
	ret
Int13Sema4s	ENDP


;-----------------------------------------------------------------------------
;
;	Checks if file requested to be open is opened by another task.
;
;	I:
;	O:	CF = 0 - not used, allow open
;		   = 1 - fail with access denied error.
;
;-----------------------------------------------------------------------------
IsFileOpen	PROC	USES eax ebx ecx edx esi edi ebp
; Set GS:ESI -> file name.
	mov	si, ExcDs
	movzx	edi, word ptr ExcEdx
	mov	ebx, ExcEflags
	call	PointerToLinear

	mov	esi, eax
; Copy it to test buffer. Now ES:EDI -> file name.
	mov	edi, offset TestFName
	mov	ecx, MAX_FNAME_LEN
	call	FullFileName
; ECX opened files tested.

	mov	edx, FirstTask		; FS:EDX -> task structure being tested.
	mov	ebx, NumOfTasks		; EBX - tasks count.
tasks_loop:
	mov	ecx, (DosTask PTR fs:[edx]).TaskOpenFiles
	test	ecx, ecx
	jz	next_task_i

; FS:EBP -> table to be tested.
	mov	ebp, (DosTask PTR fs:[edx]).TaskOFTable
	mov	eax, CurrentTask
	cmp	eax, (OpenFileRecord PTR fs:[ebp]).Owner
	je	next_task_i		; Owner task is allowed open.

	cld

files_loop:
; GS:ESI -> file name to check with.
	lea	esi, (OpenFileRecord PTR fs:[ebp]).FileName
	push	ecx
	push	edi

	push	es
	push	edi
	push	gs
	pop	es
	mov	edi, esi
	sub	al, al
	mov	ecx, MAX_FNAME_LEN
		repne	scasb
	pop	edi
	pop	es

	not	ecx
	add	ecx, MAX_FNAME_LEN

		repe	cmps	byte ptr gs:[esi], es:[edi]
	pop	edi
	pop	ecx
	je	deny_open

	add	ebp, SIZEOF OpenFileRecord
	dec	ecx
	jnz	files_loop

next_task_i:
	add	edx, SIZEOF DosTask
	dec	ebx
	jnz	tasks_loop

	clc
	ret

deny_open:
	stc
	ret
IsFileOpen	ENDP


;-----------------------------------------------------------------------------
;
;	Callback for open/create file calls (called back by exc. 6 handler).
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	Int21RetTrap
Int21RetTrap	PROC	USES es eax ebx ecx edx esi edi ebp
; Copy saved opcode back.
	mov	eax, CurrTaskPtr
	movzx	edx, ExcSeg
	shl	edx, 4
	add	edx, ExcOffs
	mov	ecx, (DosTask PTR fs:[eax]).Int21TrapOp
	mov	fs:[edx], ecx
	mov	ecx, (DosTask PTR fs:[eax]).Int21TrapOp[4]
	mov	fs:[edx][4], ecx

;	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_LOCKED

; If call failed, don't do further checks.
	test	ExcEflags, FL_CF
	jz	@@F
; Return without any action.
	ret

@@@@:
; Set ES = FLAT_DS.
	push	fs
	pop	es
; Check called DOS function.

	mov	ax, (DosTask PTR fs:[eax]).DosFunc
	cmp	ah, 3Ch			; Create file.
	je	add_open
	cmp	ah, 3Dh			; Open file.
	je	add_open
	cmp	ax, 6C00h		; Ext. open/create.
	je	add_open

	cmp	ah, 3Eh			; Close file.
	je	@@F
	ret

@@@@:
; Set FS:EBX -> current task's open file table.
	mov	edx, CurrTaskPtr
	mov	ebx, (DosTask PTR fs:[edx]).TaskOFTable
; Find handle being closed.
	mov	eax, ExcEbx
	mov	ecx, (DosTask PTR fs:[edx]).TaskOpenFiles	; ECX = count.
	test	ecx, ecx
	jnz	find_record
	ret

find_record:
	cmp	ax, (OpenFileRecord PTR fs:[ebx]).Handle
	jne	@@F

; Delete record pointed by EBX.
	mov	edi, ebx
	lea	esi, [edi+SIZEOF OpenFileRecord]
	neg	ecx
	add	ecx, (DosTask PTR fs:[edx]).TaskOpenFiles
	dec	(DosTask PTR fs:[edx]).TaskOpenFiles	; Dec. open files.

	mov	eax, SIZEOF OpenFileRecord
	mul	ecx
	mov	ecx, eax
	cld
		rep	movs	byte ptr es:[edi], es:[esi]
	ret

@@@@:
	add	ebx, SIZEOF OpenFileRecord
	dec	ecx
	jnz	find_record

; Return if record is not found.
	ret

add_open:
; Copy file to current task's OF table.
	movzx	esi, ExcDs
	shl	esi, 4
	movzx	eax, word ptr ExcEdx
	add	esi, eax		; ES:ESI -> source name.

; Set FS:EBX -> current task's open file table.
	mov	ebp, CurrTaskPtr
	mov	ebx, (DosTask PTR fs:[ebp]).TaskOFTable

; FS:EBX+EAX -> relevant entry.
	mov	eax, SIZEOF OpenFileRecord
	mul	(DosTask PTR fs:[ebp]).TaskOpenFiles

; If page size is reached, don't protect file.
	cmp	eax, 1000h
	jnb	@@F

; Copy file name.
	lea	edi, (OpenFileRecord PTR [ebx+eax]).FileName
	call	FullFileName

; Copy file handle.
	mov	cx, word ptr ExcEax
	mov	(OpenFileRecord PTR fs:[ebx+eax]).Handle, cx
; Copy owner task.
	mov	ecx, CurrentTask
	mov	(OpenFileRecord PTR fs:[ebx+eax]).Owner, ecx
; Increment recorder files counter.
	inc	(DosTask PTR fs:[ebp]).TaskOpenFiles

@@@@:
	ret

Int21RetTrap	ENDP


;-----------------------------------------------------------------------------
;
;	Copies ASCIIZ string with max. length limited (including 0).
;
;	I:	GS:ESI -> source
;		ES:EDI -> dest
;		ECX = maximum length (not including 0).
;	O:
;
; (!) It's a helper routine, allowed to destroy regs.
;
;-----------------------------------------------------------------------------
CopyAsciiz	PROC
	lea	ebx, [ecx-1]

	push	es
	push	edi
	push	gs
	pop	es
	mov	edi, esi
	sub	al, al
	mov	ecx, ebx
		repne	scasb
	not	ecx
	add	ecx, ebx
	pop	edi
	pop	es

; If ECX = 0, skip copy.
	jz	store_0

@@@@:
	lods	byte ptr gs:[esi]
	call	PmToUpper
	stosb
	dec	ecx
	jnz	@@B

store_0:
	sub	al, al
	stosb

	ret
CopyAsciiz	ENDP


;-----------------------------------------------------------------------------
;
;	Returns full path name of given file name, based on current drive,
; current directory and file name gotten.
;
;	I:	GS:ESI -> source file name.
;		ES:EDI -> destination to contain name.
;	O:
;
;-----------------------------------------------------------------------------
FullFileName	PROC	USES eax ebx ecx edx esi edi
;If full path name, just copy it.
	cld
	cmp	word ptr gs:[esi+1], ('\' SHL 8 ) + ':'
	je	copy_src

; Get drive (specified or current).
	cmp	byte ptr gs:[esi+1], ':'
	je	@@F

	mov	al, CurrDrive
	add	al, 'A'
	jmp	drive_gotten
@@@@:
	mov	al, gs:[esi]
	add	esi, 2
	call	PmToUpper

drive_gotten:
	stosb					; Store drive letter.
	mov	word ptr es:[edi], ('\' SHL 8 ) + ':'
	add	edi, 2
	cmp	byte ptr gs:[esi], '\'
	jne	@@F
	inc	esi
	jmp	copy_src

@@@@:
;
; Get current dir.
;	(!) The following code relies on the fact that CDS resides at offset 
; 16h of list of lists. This causes backward compatibility only till DOS 3.1.
; Also assumed is that CDS structure size is 58h; that limits compatibility
; to DOS 4.0
;
	and	eax, 0FFh
	sub	eax, 'A'			; EAX = drive.

	mov	ebx, ListOfListsLin		; FS:EAX -> list of lists.
	movzx	ecx, word ptr fs:[ebx+16h][2]
	shl	ecx, 4
	movzx	edx, word ptr fs:[ebx+16h]
	add	ecx, edx
	mov	edx, CDS_ENTRY_SIZE
	mul	edx				; FS:EAX+ECX -> curr. dir. struct.

	push	esi
	lea	esi, [eax+ecx+3]
	mov	ecx, MAX_FNAME_LEN
	call	CopyAsciiz
	mov	byte ptr es:[edi], '\'
	inc	edi
	pop	esi				; Restore ptr to file name.

; Copy from GS:ESI (source) to ES:EDI.
copy_src:

	mov	ecx, MAX_FNAME_LEN
	call	CopyAsciiz
	ret
FullFileName	ENDP


;-----------------------------------------------------------------------------
;
;	Release a semaphore. If a semaphore was acquired by that task, it is
; released. The next task (the first that was sleeping on it) is getting the
; semaphore. Else, nothing is done.
;
;	I:	EAX - task that tries to release the semaphore.
;		GS:ECX -> semaphore structure.
;	O:	AL = result value of the sempahore. 1 means it's released, 0
; means nothing is done.
;
; (!) Tripple-DOS can't run on SMP, so no need to keep semaphore handling
; strictly atomic.
;
;-----------------------------------------------------------------------------
PUBLIC	Sema4Up
Sema4Up		PROC	USES ebx edx esi
	mov	bl, (Sema4 PTR gs:[ecx]).State
	test	bl, bl
	je	ret_state

	cmp	(Sema4 PTR gs:[ecx]).Owner, eax
	je	change_state

;
; If a task isn't device's owner, look it up in the queue. If it's there,
; remove it. Else, just return state.
;
	sub	ebx, ebx
	mov	edx, (Sema4 PTR gs:[ecx]).TasksSleep
@@@@:
	cmp	ebx, (Sema4 PTR gs:[ecx]).SleepN
	jnb	ret_state
	cmp	eax, (Sema4 PTR gs:[ecx]).TasksSleep[ebx*4]
	je	@@F
	inc	ebx
	jmp	@@B

@@@@:
; Unblock task.
	TASK_PTR
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT SOME_SEMA4
	jnz	@@F
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
@@@@:
; Remove it from wait queue.
	inc	ebx
	cmp	ebx, (Sema4 PTR gs:[ecx]).SleepN
	jnb	@@F
	mov	eax, (Sema4 PTR gs:[ecx]).TasksSleep[ebx*4]
	mov	eax, (Sema4 PTR gs:[ecx]).TasksSleep[ebx*4][-4]
	jmp	@@B
@@@@:
	dec	(Sema4 PTR gs:[ecx]).SleepN
	dec	(Sema4 PTR gs:[ecx]).State
	mov	bl, (Sema4 PTR gs:[ecx]).State
	jmp	ret_state

change_state:
; Change state.
;	mov	(Sema4 PTR gs:[ecx]).State, bl
;	cmp	(Sema4 PTR gs:[ecx]).SleepN, 0

; Wake up the first task that waits, make it the semaphore owner.
	mov	eax, (Sema4 PTR gs:[ecx]).TasksSleep
	mov	(Sema4 PTR gs:[ecx]).Owner, eax

	TASK_PTR
;
; Check how the task can be blocked on more than one event?! If it is
; possible, then only the ready-to-run task can acquire the semaphore!
;
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT SOME_SEMA4
	jnz	@@F
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
@@@@:
	sub	ebx, ebx
	dec	(Sema4 PTR gs:[ecx]).State
	dec	(Sema4 PTR gs:[ecx]).SleepN
	jz	ret_state

; The Q of sleeping tasks must be handled.

	mov	edx, (Sema4 PTR gs:[ecx]).SleepN
	lea	esi, (Sema4 PTR gs:[ecx]).TasksSleep
@@@@:
	mov	eax, gs:[esi][4]
	mov	gs:[esi], eax
	add	esi, 4
	dec	edx
	jnz	@@B

ret_state:
	mov	al, bl
	ret
Sema4Up		ENDP


;-----------------------------------------------------------------------------
;
;	Try to get a semaphore. If a semaphore's state is 0 (avail), it is
; acquired. Else, a task is blocked. If a task already owns this semaphore,
; the task will be terminated.
;
;	I:	EAX - task that tries to get the semaphore.
;		GS:ECX -> semaphore structure.
;	O:	AL = previous value of the sempahore. 0 means it's acquired, 1
; means the task went to sleep.
;
; (!) Tripple-DOS can't run on SMP, so no need to keep semaphore handling
; strictly atomic.
;
;-----------------------------------------------------------------------------
PUBLIC	Sema4Down
Sema4Down	PROC	USES ebx edx
	mov	bl, (Sema4 PTR gs:[ecx]).State
	test	bl, bl
	jnz	sleep

; Semaphore was available, get it.
	mov	(Sema4 PTR gs:[ecx]).Owner, eax
	jmp	ret_state

sleep:
;
; Semaphore was N/A, go to sleep and put the task in semaphore's sleep list.
; Meanwhile a check for double acquiring of the semaphore is omitted.
;

	mov	edx, (Sema4 PTR gs:[ecx]).SleepN
	mov	(Sema4 PTR gs:[ecx]).TasksSleep[edx*4], eax
	inc 	(Sema4 PTR gs:[ecx]).SleepN
	TASK_PTR
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	mov	(DosTask PTR fs:[eax]).TaskBlock, SOME_SEMA4
	call	NextTask

ret_state:
	mov	al, bl
	inc	bl
	mov	(Sema4 PTR gs:[ecx]).State, bl
	ret
Sema4Down	ENDP


CODE32	ENDS


CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA, SS:STK

TaskV86Entry::
; Set video mode 3.
	mov	ax, 3
	int	10h

IFDEF	DOUBLE_SHELL
; Get PSP.
	mov	ah, 62h
	int	21h
	mov	PspSeg, bx

	mov	ds, bx
; Find COMSPEC.
	mov	es, ds:[2Ch]
	sub	di, di
	sub	al, al

	mov	dx, DATA
	mov	ds, dx

find_comspec_loop:
	mov	si, offset ComSpecStr
	cld
	mov	cx, 8
		repe	cmpsb
	je	comspec_found

		repne	scasb	; scan for terminated 0.
	jmp	find_comspec_loop
comspec_found:
	mov	ax, es
	mov	ds, ax
	mov	dx, di

	mov	ax, DATA
	mov	es, ax
	mov	bx, offset ExecPrmBlock
	mov	ax, es:PspSeg
	mov	es:[bx+4], ax
	mov	es:[bx+8], ax

	mov	ax, 4b00h
	int	21h		; Start command.com
ENDIF	; DOUBLE_SHELL

; End current task so that the parent task will remain.
	mov	ah, 4Ch
	int	21h

CODE	ENDS


STK	SEGMENT	PARA	STACK	USE16 'STACK'
STK	ENDS


END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
a801 1

d3337 2
a3338 2
	sub	ebx, ebx
	mov	(Sema4 PTR gs:[ecx]).State, bl
d3340 3
a3342 2
	cmp	(Sema4 PTR gs:[ecx]).SleepN, 0
	jz	ret_state
a3343 2
; Wake up the first task that waits.
	mov	eax, (Sema4 PTR gs:[ecx]).TasksSleep
a3344 1

d3353 2
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@d1846 2
a1847 2
;mov	ah, 21h
;jmp	default_int
d1979 1
a1979 1
;	For the preliminary release the DPMI and XMS support is eliminated
d1989 1
a1989 1
jmp	default_int
@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d156 2
d889 1
d963 7
d1049 1
d1180 3
d3276 145
@


0.49
log
@Fixes version includes:
1) variable mapping of DPMI service pages at C0000, D0000, E0000 instead of a hardcoded address.
2) added 2 32-bit XMS functions and XMS service table is fixed.
3) detection and diagnostic is improved.
@
text
@d51 1
a51 1
	PUBVAR	Int13RetOp, DB, ?	; 8 bytes of client opcode to be
d53 1
d223 2
d682 2
a683 3
	shr	ecx, 10
	add	edi, ecx
	mov	fs:[edi][ebp*4], eax	; Store linear address
d801 17
d966 8
d976 3
d987 3
d992 3
d2797 5
d2806 1
d2808 8
d2854 5
d2860 1
a2865 2
; Trap return instruction.
trap_ret_instr:
d2871 2
d2898 4
d2907 4
@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@d219 3
d494 7
a500 1
	mov	es:[ebx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4], eax	; Store linear address
a513 1
	mov	es:[edx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4], eax	; Store physical address
d515 16
a530 1
	mov	eax, es:[ebx+(DPMI_SERVICE_PAGE SHR 10)][ebp*4]
d541 6
a546 1
	mov	edi, es:[ebx+(DPMI_SERVICE_PAGE SHR 10)]	; Read linear address
d676 8
a683 1
	mov	eax, fs:[edi+(DPMI_SERVICE_PAGE SHR 10)]
d1947 3
a1949 1
	mov	ExcEs, XMS_ENTRY_SEG		; XMS server entry point
@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@d27 1
a27 1
;	(!) Int13Sema4 is handled appropriate only for single CPU machine.
d56 1
a56 1
	PUBVAR	Int13Sema4, DB, 0	; INT 13h is a shared
d58 4
a61 1
	PUBVAR	Int13Sema4Own, DD, ?	; Task owning INT 13h semaphore.
d750 8
a757 1
	cmp	Int13Sema4, 0
d759 1
a759 1
	cmp	eax, Int13Sema4Own
d761 1
a761 1
	dec	Int13Sema4Own
d908 10
a917 1
	cmp	Int13Sema4, 0
d919 1
a919 2

	cmp	eax, Int13Sema4Own
a921 3
	cmp	Int13Sema4, 0
	je	single?

d1537 1
a1537 1
; ECX keeps pointer to faulting opcode. Required for Int13Sema4s.
d1594 5
a1598 1
	cmp	Int13Sema4, 0
d1601 1
a1601 1
	cmp	edx, Int13Sema4Own
d1603 1
a1603 1
; If INT 13h is called by not INT 13h owner, lock the caller on GPF.
a1604 1
; Don't lock the last (current) task, just let caller loop on GPF.
d1606 14
a1619 1
	or	(DosTask PTR fs:[eax]).TaskBlock, INT13_SEMA4
d1897 2
a1899 1
jmp	default_int
d1904 1
d2755 1
a2755 1
Int13Sema4s	PROC	USES eax ecx edx
d2760 10
a2769 1
	xchg	al, Int13Sema4
d2774 1
d2783 1
d2785 3
d2789 6
a2794 1
	mov	Int13Sema4Own, eax
d2798 6
a2803 2
; Release semaphore.
	xchg	al, Int13Sema4
d2805 12
a2816 1
; Release all blocked on INT 13h semaphore tasks from block.
d2822 1
a2822 1
	test	(DosTask PTR fs:[eax]).TaskBlock, INT13_SEMA4
d2824 1
a2824 1
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT INT13_SEMA4
@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d66 12
d331 1
a331 1
; Linear address of first page table.
d398 4
a460 1

d575 1
d583 3
d1563 2
a1574 2
	cmp	ah, 15h
	je	handle_int_15
d1600 4
a1929 3

handle_int_15:
	jmp	default_int
@


0.45
log
@The shareware beta release
@
text
@d101 1
a101 1
IFDEF	FAKE_WINDOWS
d103 2
a104 2
ENDIF
IFDEF	PROVIDE_HIMEM
d106 1
a106 1
ENDIF
a429 3

	

a461 1

d574 1
a574 1
	sub	esi, esi
d1843 1
d1845 4
a1848 1

a1852 4
	cmp	word ptr ExcEax, 4300h		; XMS installation check.
	je	xms_install_check
	cmp	word ptr ExcEax, 4310h		; XMS get entry
	je	xms_get_entry
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
a26 1
;	(?) Will every task have its own TSS.
d104 1
d106 1
d180 2
a233 10
	mov	eax, SysPdbLin
	mov	PdbLin, eax
	mov	eax, SysPagesCtl
	mov	PagesCtl, eax
	mov	eax, SysPdb
	mov	cr3, eax		; Set system context.

	mov	ax, FLAT_DS
	mov	es, ax

d242 10
d413 21
d825 3
d843 4
d969 4
d1080 4
d1711 2
a1712 2
mov	ah, 21h
jmp	default_int
d1783 1
a1783 1
IF 1
d1843 6
d2173 1
a2173 1
	LOG_STATE
d2186 1
d2434 1
d2437 1
d2581 1
d2583 38
a2620 1
; Change state to virtual mode.
d2623 1
a2623 1
	mov	ExcSs, VM_LOCKED_SS
a2636 1

@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d48 43
d125 6
a177 1
	EXTRN	TempExcNum: dword
d180 3
d186 1
d249 3
d255 10
d456 14
a469 2
; Prepare invalid opcodes for DPMI needs.
	mov	eax, es:[ebx+(DPMI_SERVICE_PAGE SHR 10)]	; Read linear address
d490 4
a493 2
	mov	byte ptr fs:[eax+0A0h], 0CBh		; RM save state "proc": RETF.
	mov	byte ptr fs:[eax+0B0h], 0CBh		; PM save state "proc": RETF.
d501 1
d1459 1
a1459 1
; Do CLI for a VM client.
d1471 1
a1471 1
; Do STI for a VM client.
d1614 6
a1619 2
;	sub	(DosTask PTR fs:[eax]).DpmiRmEsp, LOCKED_STACK_SIZE
;	sub	(DosTask PTR fs:[eax]).DpmiRmStack, LOCKED_STACK_SIZE
d1621 2
d1624 27
a1650 1
	jmp	default_int
d1653 2
a1654 2
;mov	ah, 21h
;jmp	default_int
d1725 2
a1726 1
; Fake report Windows 3.0
d1735 2
a1737 1
@@@@:
d1855 1
a1857 1

d1865 5
d1996 1
d1998 3
a2000 5
	mov	VirtualIf, 0
	test	edx, FL_IF
	jz	@@F
	mov	VirtualIf, FL_IF
@@@@:
d2047 1
d2051 1
d2056 1
d2059 22
a2080 1
	jne	reflect_dpmi2pm
d2082 1
d2109 1
d2111 1
d2113 17
a2129 1
	jmp	reflect_to_vm
d2131 2
a2132 4
reflect_dpmi2pm:
; Reflect to protected mode handler.
	test	ExcEflags, FL_VM
	jnz	reflect_vm2pm
d2135 1
d2160 1
d2171 1
a2171 1
	cmp	LogX, 80
d2186 5
d2192 1
a2192 1
	jz	@@F
d2205 2
d2208 3
d2215 1
a2215 1
@@@@:
d2226 2
d2229 3
d2261 1
d2272 1
a2272 1
	cmp	LogX, 80
d2287 11
a2297 1
	test	(DosTask PTR fs:[eax]).TaskFlags, TASK_32BIT
a2303 6
	mov	esi, CurrTaskPtr
; Save state registers on protected mode stack.
	mov	eax, (DosTask PTR fs:[esi]).DpmiPmStack
	sub	eax, SIZEOF DpmiState
	SAVE_STATE_REGS

a2317 6
	mov	esi, CurrTaskPtr
; Save state registers on protected mode stack.
	mov	eax, (DosTask PTR fs:[esi]).DpmiPmStack
	sub	eax, SIZEOF DpmiState
	SAVE_STATE_REGS

d2331 1
d2333 1
d2336 1
a2336 1
	sub	ebx, SIZEOF DpmiState
a2340 10
; Adjust PM locked stack.
	sub	(DosTask PTR fs:[esi]).DpmiPmEsp, LOCKED_STACK_SIZE
	sub	(DosTask PTR fs:[esi]).DpmiPmStack, LOCKED_STACK_SIZE

cmp	(DosTask PTR fs:[esi]).DpmiPmEsp, PM_LOCKED_STACK_BOTTOM
jnb	@@F
mov	eax, (DosTask PTR fs:[esi]).DpmiPmEsp
int 2
@@@@:

a2341 2
	mov	TempExcNum, ecx		; Keep interrupt number.

d2345 1
a2346 1
	jmp	goto_handler
d2348 12
a2368 2
	mov	ecx, CurrTaskPtr
	mov	ecx, (DosTask PTR fs:[ecx]).DpmiTempExcNum
d2395 1
d2404 1
d2407 58
a2464 1
	cmp	LogX, 80
d2477 1
d2484 1
a2484 1
	cmp	LogX, 80
d2499 5
a2503 2
; Set V86 mode and stack. Segment registers are undefined.
	mov	eax, CurrTaskPtr		; EAX -> current task.
d2505 4
a2508 4
; Save state registers on real mode stack.
	mov	eax, (DosTask PTR fs:[eax]).DpmiRmStack
	sub	eax, SIZEOF DpmiState
	SAVE_STATE_REGS
a2512 1
	sub	ebx, SIZEOF DpmiState + LOCKED_STACK_BARRIER
a2514 4
; Adjust locked stack pointers.
	sub	(DosTask PTR fs:[eax]).DpmiRmEsp, LOCKED_STACK_SIZE
	sub	(DosTask PTR fs:[eax]).DpmiRmStack, LOCKED_STACK_SIZE

a2538 1
	mov	word ptr ExcOffs, ax
d2542 2
d2667 1
a2667 1
	mov	edi, ExcEdx
d2670 1
a2671 1

@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@d2192 2
a2193 1
	mov	ecx, TempExcNum
d2271 1
d2275 1
a2275 1
	sub	ebx, SIZEOF DpmiState
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@d13 6
a18 5
			INCLUDE	TASKMAN.INC
			INCLUDE	x86.INC
			INCLUDE	DEF.INC
			INCLUDE	PHLIB32.MCR
			INCLUDE	DPMI.INC
d47 6
d61 1
a76 1
	EXTRN	EmulateVideoIo: near32
d80 1
d171 1
a171 1
	cmp	eax, ((0A0000h + 20000h) SHR 12) + 5
d174 1
a177 22
	cmp	FirstTask, 0		; If 1st time, allocate memory for 
	jne	tasks_exist		; tasks structure.

	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	ecx, MAX_TASKS * SIZEOF DosTask
	call	HeapAllocMem
	cmp	eax, -1
	je	@@F
	cmp	eax, -2
	jne	tasks_alloc_ok
@@@@:
	stc
	ret

tasks_alloc_ok:
	mov	FirstTask, eax
; First task and open file array created. Add GPF trap.
	mov	eax, 0Dh
	mov	ecx, offset EmulateVideoIo
	call	AddExcTrap

tasks_exist:
d197 3
a222 5
; Allocate page for task's TSS.
;	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
;	call	HeapAllocPage
;	mov	(DosTask PTR es:[esi]).TaskTss, eax	; TSS lin. addr.

d281 1
a281 2
	cmp	ecx, 110000h SHR 12		; Number of pages to
						; allocate.
d359 1
a359 1
; Allocate page for DPMI server needs: mode switch, RM temp stack.
d362 3
a364 1
	call	HeapAllocPage
d366 4
a369 1
	mov	es:[ebx+(DPMI_SERVICE_PAGE SHR 10)], eax	; Store linear address
d380 2
a381 1
; Map last page as read only (for DPMI server needs).
d383 7
a389 1
	mov	es:[edx+(DPMI_SERVICE_PAGE SHR 10)], eax	; Store physical address
d393 1
a393 1
	mov	dword ptr fs:[eax], 0000FFFEh	; Invalid opcode
d412 1
a412 1
	mov	dword ptr fs:[eax+90h][4], 0A000000h	; Trap return from translation services.
d416 19
d508 13
a520 1
	call	HeapFreePage
d522 2
a523 5
; Free task's pages allocated for base and video memory.
	sub	ecx, ecx			; Pages count
free_pages:
	mov	eax, fs:[edi+ecx*4]		; Get linear address
	call	HeapFreePage
d525 13
a537 4
	inc	ecx
	cmp	ecx, (0A0000h + 40000h) SHR 12		; Number of pages to
							; free.
	jb	free_pages
d541 3
a543 3
	mov	ecx, 100000h SHR 12			; Pages count
free_hma_pages:
	mov	eax, fs:[edi+ecx*4]			; Get linear address
d546 2
a547 4
	inc	ecx
	cmp	ecx, 110000h SHR 12			; Number of pages to
							; free.
	jb	free_hma_pages
d1528 1
d1530 6
a1536 4
; Adjust locked RM stack.
	mov	eax, CurrTaskPtr
	sub	(DosTask PTR fs:[eax]).DpmiRmEsp, 6
	sub	(DosTask PTR fs:[eax]).DpmiRmStack, 6
d1564 1
d1606 66
a1671 1
	cmp	word ptr ExcEax, 1687h
d1673 22
a1694 2
	cmp	word ptr ExcEax, 1686h
	jne	default_int
d1696 1
d1716 1
a1716 1
	mov	word ptr ExcEdi, INIT_SWITCH_OFFS ; Switch address: FFFF:FFFE.
d1922 2
d1938 1
a1938 1
	jne	reflect_pm2pm
d1942 26
d1969 2
a1970 1
reflect_pm2pm:
d1976 49
d2061 49
a2116 1
; Adjust PM locked stack.
a2117 3
	sub	(DosTask PTR fs:[esi]).DpmiPmEsp, SIZEOF DpmiState + 12
	sub	(DosTask PTR fs:[esi]).DpmiPmStack, SIZEOF DpmiState + 12

d2120 1
a2120 1
	add	eax, 12
d2123 2
a2124 2
	mov	eax, (DosTask PTR fs:[esi]).DpmiPmStack
	mov	dword ptr fs:[eax], PM_RET_INT_OFFS
d2126 1
a2126 1
	mov	fs:[eax][4], bx
d2129 2
a2130 1
	mov	fs:[eax][8], ebx
a2136 1
; Adjust PM locked stack.
a2137 3
	sub	(DosTask PTR fs:[esi]).DpmiPmEsp, SIZEOF DpmiState + 6
	sub	(DosTask PTR fs:[esi]).DpmiPmStack, SIZEOF DpmiState + 6

d2140 1
a2140 1
	add	eax, 6
d2143 1
a2143 2
	mov	eax, (DosTask PTR fs:[esi]).DpmiPmStack
	mov	word ptr fs:[eax], PM_RET_INT_OFFS
d2145 1
a2145 1
	mov	fs:[eax][2], bx
d2147 2
a2148 1
	mov	fs:[eax][4], bx
d2150 1
d2159 2
d2164 10
d2195 68
a2264 3
; Adjust locked stack pointers.
	sub	(DosTask PTR fs:[eax]).DpmiRmEsp, SIZEOF DpmiState + 6
	sub	(DosTask PTR fs:[eax]).DpmiRmStack, SIZEOF DpmiState + 6
d2266 6
d2273 1
a2273 1
	add	ebx, 6
d2276 3
a2278 4
; Save state registers on real mode stack.
	mov	eax, (DosTask PTR fs:[eax]).DpmiRmStack
	add	eax, 6
	SAVE_STATE_REGS
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@d28 1
d1329 1
d1389 2
d1507 2
d1613 3
d1720 1
d1815 1
a1815 1
	jne	@@F
d1820 1
a1820 1
@@@@:
a1825 22
pushad
	PM_PRINT_HEX	91h, LogX, LogY, LogClr
popad
pushad
     	mov	eax, ecx
	mov	dl, LogX
	add	dl, 2
	PM_PRINT_HEX	, , LogY, LogClr
	add	LogX, 5
	cmp	LogX, 80
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
a1861 22
pushad
	PM_PRINT_HEX	90h, LogX, LogY, LogClr
popad
pushad
     	mov	eax, ecx
	mov	dl, LogX
	add	dl, 2
	PM_PRINT_HEX	, , LogY, LogClr
	add	LogX, 5
	cmp	LogX, 80
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
d2003 1
d2020 1
a2021 1
IFDEF	BORROWED_TICKS
d2042 1
a2042 1
Int13Sema4s	PROC	USES eax edx
d2106 5
a2110 4
	movzx	esi, ExcDs
	shl	esi, 4
	movzx	edx, word ptr ExcEdx
	add	esi, edx
d2324 4
d2335 1
@


0.39
log
@Bug fixed: raw mode switches.
@
text
@d29 1
d123 4
d246 1
d280 20
d356 2
d359 1
d368 1
a368 1
	cmp	ecx, 10F000h SHR 12
d370 2
d374 1
a374 1
;	Allocate page for DPMI server needs: mode switch, RM temp stack.
d379 1
a379 1
	mov	es:[ebx+(10F000h SHR 10)], eax	; Store linear address
d392 1
a392 1
	mov	es:[edx+(10F000h SHR 10)], eax	; Store physical address
d395 1
a395 1
	mov	eax, es:[ebx+(10F000h SHR 10)]	; Read linear address
d434 16
d491 1
a491 1
	mov	eax, fs:[edi+(10F000h SHR 10)]
d505 13
d1494 6
a1499 1
	mov	ExcEsp, VM_LOCKED_ESP
d1569 1
d1597 4
a1630 1
; Emulate PUSHFD.
d1639 1
d1641 4
a1644 4
; Clear IF, VM, RF.
	and	ebx, NOT (FL_IF OR FL_VM OR FL_RF)
; Merge with VirtualIf.
	or	ebx, VirtualIf
d1654 5
a1658 4
; Clear IF.
	and	ebx, NOT FL_IF
; Merge with VirtualIf.
	or	ebx, VirtualIf
d1674 4
a1677 1
	mov	edx, fs:[eax]
d1743 2
d1767 3
a1769 1
	and	edx, NOT 3000h
d1771 3
a1773 5
	mov	VirtualIf, 0
	test	edx, FL_IF
	jz	@@F
	mov	VirtualIf, FL_IF
@@@@:
d1792 2
a1793 1
SimulateInt	PROC	near32	USES eax ebx ecx edx esi edi
d1803 2
a1804 2
	mov	edx, (DosTask PTR fs:[eax]).DpmiPmInts
	cmp	dword ptr fs:[edx+ecx*8][4], 0
d1816 22
d1874 22
d1899 1
d1901 10
a1910 1
	push	edx
d1912 2
a1913 2
	pop	edx
	mov	eax, DPMI_LOCKED_STACK - 12
d1919 1
a1919 1
	mov	fs:[eax][8], bx
d1922 1
d1924 1
d1926 8
a1933 1
	push	edx
d1935 2
a1936 2
	pop	edx
	mov	eax, DPMI_LOCKED_STACK - 6
d1950 2
a1951 1
	mov	ExcEsp, eax
d1957 1
a1957 1
	mov	eax, fs:[edx+ecx*8]
d1959 3
a1961 3
	mov	eax, fs:[edx+ecx*8][4]
	mov	ExcSeg, ax
	ret
d1976 12
d1989 2
a1993 1
	mov	ExcEsp, VM_LOCKED_ESP
a1994 1
	mov	byte ptr fs:[RET_TRAP_ADDR + 6], 3
d2019 1
a2022 1

@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@a404 1

a658 1

d1431 4
d1551 2
a1552 36
; Do IRET for the VM client.
	mov	si, ExcSs
	mov	edi, ExcEsp
	mov	ebx, ExcEflags
	call	PointerToLinear		; FS:EAX points to VM client's stack.

	cmp	OperandSize, 0
	je	emul_iret

; Emulate IRETD.
	mov	edx, fs:[eax]		; "POP" client EIP
	mov	ExcOffs, edx
	mov	edx, fs:[eax+4]		; "POP" client CS
	mov	ExcSeg, dx

	mov	edx, fs:[eax+8]		; "POP" client flags
	and	edx, NOT 3000h		; IOPL = 0
; Set VirtualIf appropriately.
	mov	VirtualIf, 0
	test	edx, FL_IF
	jz	@@F
	mov	VirtualIf, FL_IF
@@@@:
	or	edx, FL_IF		; Real IF will always be 1.
	and	ExcEflags, FL_VM
	or	ExcEflags, edx		; Merge with previous VM value
	add	ExcEsp, 12		; Adjust client SP
	clc
	ret				; Done

emul_iret:
; Emulate IRET.
	mov	edx, fs:[eax]		; "POP" client IP
	mov	word ptr ExcOffs, dx
	mov	edx, fs:[eax+2]		; "POP" client CS
	mov	ExcSeg, dx
a1553 11
	mov	edx, fs:[eax+4]		; "POP" client flags
	and	edx, NOT 3000h
; Set VirtualIf appropriately.
	mov	VirtualIf, 0
	test	edx, FL_IF
	jz	@@F
	mov	VirtualIf, FL_IF
@@@@:
	or	edx, FL_IF		; Real IF will always be 1.
	mov	word ptr ExcEflags, dx
	add	ExcEsp, 6		; Adjust client SP
d1555 1
a1555 1
	ret				; Done
d1616 3
a1618 2
	or	edx, FL_VM
	mov	ExcEflags, edx		; "Pop" client flags
d1642 69
a1710 1
;	Simulates V86 mode INT due to IRQ.
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@a1690 5
	test	ExcEflags, FL_VM
	jnz	@@F
	ret
@@@@:

d1809 1
a1809 1
	mov	eax, DPMI_LOCKED_STACK - 6
d1815 1
@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d49 1
d185 1
d212 1
a212 1
	call	HeapAllocPage
d214 1
d224 1
d234 1
a234 1
	call	HeapAllocPage
d247 1
a393 1
	cld
d1258 1
a1258 1
	inc	GpCount
d1572 3
a1574 2
	or	edx, (FL_IF OR FL_VM)	; Real IF will always be 1.
	mov	ExcEflags, edx
d1691 5
d1861 1
a1861 1
Int13RetTrap	PROC	USES eax ecx edx
d1863 6
a1868 3
	movzx	ecx, ExcSeg
	shl	ecx, 4
	add	ecx, ExcOffs
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@d1694 1
@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@d119 1
d866 2
d1426 1
a1426 1
	jz	default_int
d1688 3
d1833 1
a1833 2
;	and	ExcEflags, NOT (FL_IF OR FL_TF)	; clear IF and TF on handler entry
	and	ExcEflags, NOT FL_TF
@


0.32
log
@Translation services work.
@
text
@d343 9
a352 1

d377 4
@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@d47 72
a118 71
		EXTRN	PointerToLinear: near32
		EXTRN	HeapAllocPage: near32
		EXTRN	HeapAllocMem: near32
		EXTRN	HeapFreePage: near32
		EXTRN	LinearToPhysical: near32
		EXTRN	LeftFreePages: near32
		EXTRN	AddExcTrap: near32
		EXTRN	SaveClientRegs: near32
		EXTRN	RestoreClientRegs: near32
		EXTRN	SetClientRegs: near32
		EXTRN	PmHex32ToA: near32
		EXTRN	PmWriteStr32: near32
		EXTRN	PmStrCmp: near32
		EXTRN	PmToUpper: near32
		EXTRN	SaveVideoContext: near32
		EXTRN	RestoreVideoContext: near32
		EXTRN	SaveVideoMemory: near32
		EXTRN	RestoreVideoMemory: near32
		EXTRN	TrapVideoPorts: near32
		EXTRN	EmulateVideoIo: near32
		EXTRN	SkipPrefixes: near32
		EXTRN	Int31Handler: near32

		EXTRN	SysPdb: dword
		EXTRN	Pdb: dword
		EXTRN	SysPdbLin: dword
		EXTRN	PdbLin: dword
		EXTRN	SysPagesCtl: dword
		EXTRN	PagesCtl: dword
		EXTRN	OsHeapEnd: dword

		EXTRN	SystemTask: dword

		EXTRN	ExcCode: dword
		EXTRN	ExcOffs: dword
		EXTRN	ExcSeg: word
		EXTRN	ExcEflags: dword
		EXTRN	ExcEax: dword
		EXTRN	ExcEbx: dword
		EXTRN	ExcEcx: dword
		EXTRN	ExcEdx: dword
		EXTRN	ExcEsp: dword
		EXTRN	ExcEbp: dword
		EXTRN	ExcEsi: dword
		EXTRN	ExcEdi: dword
		EXTRN	ExcDs: word
		EXTRN	ExcEs: word
		EXTRN	ExcFs: word
		EXTRN	ExcGs: word
		EXTRN	ExcSs: word

		EXTRN	VirtualIp: dword

		EXTRN	OperandSize: byte
		EXTRN	AddressSize: byte
		EXTRN	SegPrefix: byte
		EXTRN	RepPrefix: byte

		EXTRN	CurrDrive: byte
		EXTRN	ListOfListsLin: dword
		EXTRN	Field: byte

		EXTRN	KbdQHead: dword
		EXTRN	KbdQTail: dword
		EXTRN	KeyboardQ: byte

		EXTRN	Cpu: word

		EXTRN	PmCallbackCs: word
		EXTRN	PmCallbackSs: word
		EXTRN	TempExcNum: dword
d367 2
d406 2
d416 6
d423 1
a423 1
	mov	eax, (DosTask PTR fs:[edx]).TaskVideoState
d426 1
a426 1
	mov	edi, (DosTask PTR fs:[edx]).TaskMapping
d447 1
a447 1
	mov	edi, (DosTask PTR fs:[edx]).TaskPageCtl
d456 1
a456 1
	mov	eax, (DosTask PTR fs:[edx]).TaskPdbLin
d460 1
a460 1
	mov	eax, (DosTask PTR fs:[edx]).TaskOFTable
d464 1
d492 1
a492 4
	push	eax
	TASK_PTR	CurrentTask
	mov	CurrTaskPtr, eax
	pop	eax
d714 2
d723 2
a724 2
	lea	ebx, (DosTask PTR es:[edx]).TaskRegs
	lea	ecx, (DosTask PTR es:[edx]).TaskSregs
d729 1
a729 1
	mov	(DosTask PTR es:[edx]).TaskVirtualIf, eax
d731 1
a731 1
	mov	(DosTask PTR es:[edx]).TaskVirtualIp, eax
d734 1
d796 2
d812 1
a812 1
	and	(DosTask PTR fs:[edx]).TaskState, NOT TASK_RUNNING
d817 1
a817 1
	or	(DosTask PTR fs:[edx]).TaskState, TASK_RUNNING
d830 2
a831 2
	lea	ebx, (DosTask PTR es:[edx]).TaskRegs
	lea	ecx, (DosTask PTR es:[edx]).TaskSregs
d835 1
a835 1
	mov	eax, (DosTask PTR es:[edx]).TaskVirtualIf
d837 1
a837 1
	mov	eax, (DosTask PTR es:[edx]).TaskVirtualIp
d841 1
a841 1
	mov	eax, (DosTask PTR es:[edx]).TaskPdbLin
d843 1
a843 1
	mov	eax, (DosTask PTR es:[edx]).TaskPageCtl
d845 1
a845 1
	mov	eax, (DosTask PTR es:[edx]).TaskPdb
d849 6
d857 1
d872 2
d881 1
a881 1
	mov	eax, (DosTask PTR es:[edx]).TaskPdbLin
d883 1
a883 1
	mov	eax, (DosTask PTR es:[edx]).TaskPageCtl
d885 1
a885 1
	mov	eax, (DosTask PTR es:[edx]).TaskPdb
d890 1
a890 1
	mov	edi, (DosTask PTR es:[edx]).TaskVideoState
d895 1
a895 1
	mov	edi, (DosTask PTR es:[edx]).TaskPageCtl
d897 1
a897 1
	mov	esi, (DosTask PTR es:[edx]).TaskMapping
d910 1
d1400 16
d1445 2
a1446 1
	mov	(DosTask PTR fs:[edx]).TaskErrCode, 5
d1454 7
a1463 3
	movzx	edx, ExcSeg
	shl	edx, 4
	add	edx, ExcOffs
d1513 1
d1673 1
a1673 1
	TASK_PTR	CurrentTask
@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d98 1
a98 1
		EXTRN	VirtualIp	: dword
d115 4
d348 1
a348 1
; Prepare invalid opcodes for raw mode switch addresses.
d357 9
a365 1
	mov	dword ptr fs:[eax+30h][4], 03000000h	; Trap return from VM callback.
d1214 1
a1214 1
ExcRedirect	PROC	USES eax ebx ecx edx
d1239 1
a1239 1
	add	ebx, eax	; EBX keeps number of bytes to skip.
d1247 2
a1248 2
	inc	ebx
	add	ExcOffs, ebx
d1259 2
a1260 2
	inc	ebx
	add	ExcOffs, ebx
d1357 2
a1358 2
	add	ExcOffs, ebx
	add	ExcOffs, 2
d1406 2
a1407 2
	add	ebx, 2
	add	ExcOffs, ebx
d1444 2
a1445 2
	add	ebx, 2
	add	ExcOffs, ebx
d1459 2
a1460 2
	add	ebx, 2
	add	ExcOffs, ebx
d1465 2
a1466 2
	add	ebx, 2
	add	ExcOffs, ebx
d1472 2
a1473 2
	add	ebx, 2
	add	ExcOffs, ebx
d1485 5
d1494 1
a1494 4
	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, fs:[ecx]		; "POP" client EIP
d1496 1
a1496 1
	mov	edx, fs:[ecx+4]		; "POP" client CS
d1498 2
a1499 1
	mov	edx, fs:[ecx+8]		; "POP" client flags
d1515 1
a1515 4
	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, fs:[ecx]		; "POP" client IP
d1517 1
a1517 1
	mov	edx, fs:[ecx+2]		; "POP" client CS
d1519 2
a1520 1
	mov	edx, fs:[ecx+4]		; "POP" client flags
d1538 6
a1546 1
; Emulate PUSHFD.
a1547 4
	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, ExcEflags
d1549 1
a1549 1
	and	edx, NOT (FL_IF OR FL_VM OR FL_RF)
d1551 4
a1554 4
	or	edx, VirtualIf
	mov	fs:[ecx], dx		; "Push" client flags.
	inc	ebx
	add	ExcOffs, ebx
d1561 2
a1562 4
	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, ExcEflags
d1564 4
a1567 7
	and	edx, NOT FL_IF
	or	edx, VirtualIf

	mov	fs:[ecx], dx		; "Push" client flags

	inc	ebx
	add	ExcOffs, ebx
d1575 4
a1578 4
	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, fs:[ecx]
d1580 1
a1588 1

d1596 2
a1597 2
	inc	ebx
	add	ExcOffs, ebx
d1605 2
a1606 2
	inc	ebx
	add	ExcOffs, ebx
d1624 92
a1715 2
SimulateInt	PROC	near32	USES eax ecx edx
	mov	eax, fs:[eax*4]		; Get interrupt vector address.
d1717 34
a1750 2
	movzx	ecx, ExcSs
	shl	ecx, 4
d1752 1
a1752 1
	add	ecx, edx		; FS:ECX points to VM client's stack.
d1758 1
a1758 1
	mov	fs:[ecx-2], dx		; "Push" client flags
d1760 1
a1760 1
	mov	fs:[ecx-4], dx		; "Push" client CS
d1762 1
a1762 2
	mov	fs:[ecx-6], dx		; "Push" client return IP
	sub	ExcEsp, 6		; Adjust client SP
d1768 1
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@d332 1
a332 1
;	Allocate page for DPMI server needs (mode switch).
d341 1
a341 1
	or	eax, PAGE_PRESENT OR PAGE_USER
d352 2
a1452 1
	call	Int31Handler
d1455 1
@


0.28
log
@Initial DPMI switch works.
@
text
@d1213 5
a1217 3
	movzx	eax, ExcSeg
	shl	eax, 4
	add	eax, ExcOffs
d1452 2
a1453 1
	clc
@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@d17 1
d25 1
d68 1
d113 2
d192 4
d328 1
a328 1
	cmp	ecx, 110000h SHR 12
d332 22
a400 1
; Free task's pages allocated for base and video memory.
d402 3
d406 1
d466 4
d542 1
a542 1
	TASK_PTR
d556 1
d691 1
a691 1
	TASK_PTR	CurrentTask, edx
d782 1
a782 1
	TASK_PTR	, edx
d788 1
d961 1
a961 1
	TASK_PTR	CurrentTask
d1024 1
a1024 1
;	TASK_PTR	CurrentTask
d1123 1
a1123 1
;	TASK_PTR	CurrentTask
d1205 3
d1266 4
d1280 1
a1280 1
	TASK_PTR	edx
d1312 1
a1312 5
	mov	edx, CurrentTask
	mov	eax, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	TASK_PTR	CurrentTask
a1342 1
	TASK_PTR	CurrentTask
d1355 1
a1355 1
	TASK_PTR	CurrentTask
d1397 1
a1397 1
	TASK_PTR	CurrentTask
d1415 32
d1448 5
d1665 1
a1665 1
	TASK_PTR	CurrentTask
d1831 1
a1831 1
	TASK_PTR	CurrentTask
d1868 1
a1868 1
	TASK_PTR	CurrentTask, edx
d1911 1
a1911 1
	TASK_PTR	CurrentTask, ebp
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@d742 4
a745 1
	mov	CurrentTask, eax
d747 3
d751 1
a751 1
	push	eax
a757 1
	pop	eax
d759 1
a759 2
	TASK_PTR	, edx

a761 4

	and	(DosTask PTR es:[edx]).TaskState, NOT TASK_RUNNING

; Restore registers of task to switch to.
d1083 5
a1087 5
	TASK_PTR	CurrentTask
	test	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
	jz	@@F
	ret
@@@@:
d1091 1
a1091 1
	jnz	@@F
d1093 2
a1094 1
@@@@:
d1217 4
a1220 4
;	cmp	ah, 16h
;	je	handle_int_16
;	cmp	ah, 28h
;	je	handle_int_28
d1285 1
a1285 11
	je	check_kbd_buf

; If INT 28h handler doesn't point to IRET, clear INT 28h block.
	push	eax
	TASK_PTR	CurrentTask
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT INT28_WAIT
	jnz	@@F
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
@@@@:
	pop	eax
	jmp	default_int
d1293 1
a1293 1
; If empty but keyboard interrupt is pending, go on (don't lock).
d1297 1
a1297 1
; Lock task on INT 28h.
a1300 2
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
d1761 1
a1761 1
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_LOCKED
@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@a18 1
	JustFlag	DB	0
d28 1
a28 1
	PUBVAR	ClientOpcode, DB, ?	; 8 bytes of client opcode to be
d47 1
d151 1
a151 1
	cmp	FirstTask, 0		; If 1st time, allocate page for 
d155 5
a159 2
	call	HeapAllocPage
	cmp	eax, 0FFFFFFFFh
d161 1
a161 1

d400 4
d439 8
d581 16
d612 1
a612 1
	jne	int13_owner?
a617 28
int13_owner?:
; If INT 13h semaphore is owned by task being deleted, force it free. 
; Else just switch to next task.
	cmp	Int13Sema4, 0
	je	is_current?

	cmp	eax, Int13Sema4Own
	jne	is_current?

	mov	Int13Sema4, 0		; Free INT 13h semaphore.
; Free all tasks blocked on INT 13h semaphore.
	sub	edx, edx
	mov	ecx, FirstTask
check_blocked:
	test	(DosTask PTR fs:[ecx]).TaskState, TASK_BLOCKED
	jz	@@F
	test	(DosTask PTR fs:[ecx]).TaskBlock, INT13_SEMA4
	jz	@@F
	and	(DosTask PTR fs:[ecx]).TaskBlock, NOT INT13_SEMA4
	jnz	@@F
	and	(DosTask PTR fs:[ecx]).TaskState, NOT TASK_BLOCKED

@@@@:
	inc	edx
	add	ecx, SIZEOF DosTask
	cmp	edx, NumOfTasks
	jb	check_blocked

d1083 5
a1087 5
;	TASK_PTR	CurrentTask
;	test	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
;	jz	@@F
;	ret
;@@@@:
d1218 2
a1219 2
	cmp	ah, 28h
	je	handle_int_28
d1318 2
a1319 2
	mov	edx, ExcEax
	cmp	dh, 0Eh
d1332 1
a1332 1
	cmp	dh, 3Ch
d1334 1
a1334 1
	cmp	dh, 3Dh
d1336 1
a1336 1
	test	dl, 3
d1341 1
a1341 1
	cmp	dh, 41h
d1343 1
a1343 1
	cmp	dx, 4301h
d1345 1
a1345 1
	cmp	dx, 6C00h
d1347 1
a1347 1
	cmp	dh, 3Eh
d1365 4
a1368 1
	mov	DosFunc, dx
d1374 1
a1374 1
	mov	dword ptr ClientOpcode, ecx
d1376 1
a1376 1
	mov	dword ptr ClientOpcode[4], ecx
d1380 3
a1382 2
	push	eax
	TASK_PTR	CurrentTask
d1575 35
d1630 1
a1630 1
	mov	dword ptr ClientOpcode, eax
d1632 2
a1633 1
	mov	dword ptr ClientOpcode[4], eax
a1644 5
; Copy saved opcode back.
	mov	eax, dword ptr ClientOpcode
	mov	fs:[ecx], eax
	mov	eax, dword ptr ClientOpcode[4]
	mov	fs:[ecx][4], eax
a1661 8
; If current task (that owned a semaphore) has borrowed ticks, NextTask().
	TASK_PTR	CurrentTask
IFDEF	BORROWED_TICKS
	cmp	(DosTask PTR fs:[eax]).BorrowedTicks, 0
	je	ok_ret
ENDIF

	call	NextTask
a1687 3
	movzx	eax, ExcDs
	mov	ebx, ExcEdx

a1690 4
cmp	JustFlag, 0
je	@@F
;int 3
@@@@:
d1695 1
a1695 1
	sub	ebx, ebx		; EBX = task count (and number).
d1703 2
a1704 1
	cmp	ebx, (OpenFileRecord PTR fs:[ebp]).Owner
d1740 2
a1741 3
	inc	ebx
	cmp	ebx, NumOfTasks
	jb	tasks_loop
d1762 2
d1767 6
a1772 5
; Copy saved opcode back.
	mov	eax, dword ptr ClientOpcode
	mov	fs:[edx], eax
	mov	eax, dword ptr ClientOpcode[4]
	mov	fs:[edx][4], eax
d1785 2
a1786 1
	mov	ax, DosFunc
a1798 1
inc	JustFlag
@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@d19 1
d106 4
a506 1
	mov	(DosTask PTR fs:[eax]).TaskWait, 0
d530 1
d532 4
d537 1
a537 1
	mov	ExcEflags, FL_VM OR FL_IF	; IOPL = 0
d566 16
a581 3
; If task being stopped is current, force next task.
	cmp	eax, CurrentTask
	jne	dismember_task
d583 7
a589 2
; If INT 13h semaphore is owned by current task, force it free. Else just
; switch to next task.
d591 1
a591 1
	je	switch_task
d594 1
a594 1
	je	switch_task
d615 5
a619 3
switch_task:
	cmp	NumOfTasks, 1
	je	dismember_task
d688 6
d985 1
a985 1
@@@@:
d1079 6
d1267 2
a1268 2
	or	(DosTask PTR fs:[eax]).TaskState, TASK_WAITING
	or	(DosTask PTR fs:[eax]).TaskWait, KBD_INPUT
d1286 1
a1286 1
	and	(DosTask PTR fs:[eax]).TaskWait, NOT INT28_WAIT
d1288 1
a1288 1
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_WAITING
d1304 2
d1307 2
a1308 2
	or	(DosTask PTR fs:[eax]).TaskState, TASK_WAITING
	or	(DosTask PTR fs:[eax]).TaskWait, INT28_WAIT
d1337 1
d1347 1
a1347 1
test_open:	
d1658 3
d1664 4
a1746 1
	TASK_PTR	CurrentTask
d1772 1
d1940 3
a1942 2
	add	ecx, edx			
	mul	ecx				; FS:ECX -> curr. dir. struct.
d1944 2
a1945 1
	lea	esi, [eax+3]
d1950 1
d1954 1
@


0.23
log
@1) File sharing handled.
@
text
@d946 4
a949 4
	TASK_PTR	CurrentTask
	test	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
	jz	@@F
	ret
a1331 1
	or	(DosTask PTR fs:[eax]).TaskState, TASK_LOCKED
a1622 3
	cmp	ebx, CurrentTask
	je	next_task_i		; Current task is allowed open.

d1629 3
a1696 1
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_LOCKED
d1784 3
@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@d39 3
d57 1
d102 2
a178 3
; Set task status to ready.
	and	(DosTask PTR es:[esi]).TaskState, NOT TASK_RUNNING

d945 6
d1176 2
a1177 2
;	cmp	ah, 21h
;	je	handle_int_21
d1275 1
d1287 1
a1287 1
	je	@@F
d1289 5
a1293 1
	je	@@F
d1295 1
a1295 1
	je	@@F
d1297 1
a1297 1
	je	@@F
d1299 1
a1299 1
	je	@@F
d1303 1
a1303 1
@@@@:	
d1330 4
d1608 4
a1611 6
IsFileOpen	PROC	USES es eax ebx ecx edx esi edi
; Set ES:EDI -> file name.
	mov	edi, FLAT_DS
	mov	es, di
	movzx	edi, ExcDs
	shl	edi, 4
d1613 7
a1619 1
	add	edi, edx
d1624 2
a1625 2
	cmp	ebx, CurrentTask	; Current task is allowed open.
	je	next_task_i
d1627 8
a1634 4
; ECX opened files tested.
	sub	ecx, ecx
; FS:EAX -> table to be tested.
	mov	eax, (DosTask PTR fs:[edx]).TaskOFTable
d1636 22
a1657 7
; DS:ESI -> file name to check with.
	lea	esi, (OpenFileRecord PTR fs:[eax]).FileName
	push	ds
	push	fs
	pop	ds
	call	PmStrCmp
	pop	ds
d1660 3
a1662 4
	add	eax, SIZEOF OpenFileRecord
	inc	ecx
	cmp	ecx, (DosTask PTR fs:[edx]).TaskOpenFiles
	jb	files_loop
d1688 1
a1688 1
Int21RetTrap	PROC	USES es eax ebx ecx edx esi edi
d1697 2
d1707 3
d1725 2
a1726 2
	TASK_PTR	CurrentTask
	mov	ebx, (DosTask PTR fs:[eax]).TaskOFTable
d1728 5
a1732 2
	mov	eax, ExcEax
	sub	ecx, ecx		; ECX = count.
d1737 1
a1737 1
	
d1742 3
a1744 1
	add	ecx, (DosTask PTR fs:[eax]).TaskOpenFiles
d1753 3
a1755 4
	add	ebx, SIZEOF (OpenFileRecord)
	inc	ecx
	cmp	ecx, (DosTask PTR fs:[eax]).TaskOpenFiles
	jb	find_record
d1764 2
a1765 1
	add	esi, ExcEdx		; ES:ESI -> source name.
d1768 2
a1769 2
	TASK_PTR	CurrentTask
	mov	ebx, (DosTask PTR fs:[eax]).TaskOFTable
d1772 2
a1773 3
	mov	eax, (DosTask PTR fs:[ebx]).TaskOpenFiles
	mov	edx, SIZEOF OpenFileRecord
	mul	edx
d1781 2
a1782 3
	mov	ecx, 62
	cld
		rep	movs	byte ptr es:[edi], es:[esi]
d1787 2
a1788 1
	inc	(DosTask PTR fs:[eax]).TaskOpenFiles
d1793 110
@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@a430 3
	mov	edx, SIZEOF DosTask
	mul	edx			
	add	eax, FirstTask		
d497 3
a499 2
	mov	(DosTask PTR fs:[eax]).TaskState, 0
	or	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
d575 3
a577 1
	and	(DosTask PTR fs:[ecx]).TaskState, NOT TASK_RUNNING
d910 1
a910 1
	jnz	@@F
d912 1
a912 1
@@@@:
d965 1
a965 1
	jz	@@F 
d974 1
a974 1
@@@@:
d997 1
a997 1
	jna	@@F
a999 1
@@@@:
d1165 2
a1166 2
;	cmp	ah, 28h
;	je	handle_int_28
d1210 1
a1210 1
; Lock task on GPF.
d1217 3
a1219 2
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
d1231 11
a1241 1
	jne	default_int
d1243 1
d1249 5
a1253 1
; Lock task on GPF.
d1255 3
a1257 2
	or	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	or	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
d1299 1
a1299 1
	mov	ExcOffs, ebx
@


0.20
log
@Task locks on wait for events are added.
@
text
@d36 3
a38 1
	OFArray		DD	?	; Array of opened files.
d53 1
d97 2
a152 10
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	cmp	eax, 0FFFFFFFFh
	jne	of_array_ok

	stc
	ret

of_array_ok:
	mov	OFArray, eax
d159 1
a159 7
	mov	eax, NumOfTasks		; eax = index of the task being
					; created.
	mov	ecx, SIZEOF DosTask
	mul	ecx			; eax = ofeset of the task being
					; created.
	add	eax, FirstTask
	mov	esi, eax		; es:ESI -> task being created.
d162 1
d164 1
d166 7
d174 7
a180 1
	mov	(DosTask PTR es:[esi]).TaskState, TASK_READY
d353 1
a353 4
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax
d433 2
a434 1
	add	eax, FirstTask		; eax = offset of the task being
d484 2
a485 4
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_READY
a495 1
	mov	eax, ecx
d497 1
a497 3
	mov	edx, SIZEOF DosTask
	mul	edx			
	add	eax, FirstTask		; eax = offset of the task to run
d500 2
a501 1
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
d573 5
a577 5
	cmp	(DosTask PTR fs:[ecx]).TaskState, TASK_BLOCKED
	jne	@@F
	cmp	(DosTask PTR fs:[ecx]).TaskBlock, INT13_SEMA4
	jne	@@F
	mov	(DosTask PTR fs:[ecx]).TaskState, TASK_READY
d596 1
a596 1
	call	SwitchTaskTo
d617 1
a617 5
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax
d640 35
d685 1
a696 28
; If all tasks are blocked, do switch.
	push	eax
	call	NonBlockedTasks
	test	eax, eax
	pop	eax
	jz	do_switch
; If destination task is blocked, return with CF = 1.
	push	eax
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	pop	eax
	jne	do_switch

	stc
	ret

do_switch:
	push	eax
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
	je	@@F
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
@@@@:
	pop	eax
d713 1
a713 4
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax
d718 1
a718 1
	mov	(DosTask PTR es:[edx]).TaskState, TASK_READY
d756 1
a756 5
	mov	eax, ForegroundTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax		; ES:EDX -> old foreground's task
d845 1
a845 5

	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax		; ES:EDX -> new foreground's task
d880 9
a888 9
; If commented, doesn't work!
;	mov	eax, ForegroundTask
;	call	SwitchTaskTo

	mov	eax, SIZEOF DosTask
	mul	CurrentTask
	add	eax, FirstTask
	mov	eax, (DosTask PTR fs:[eax]).TaskPdb
	mov	cr3, eax
d909 2
a910 2
	cmp	(DosTask PTR fs:[ecx]).TaskState, TASK_BLOCKED
	je	@@F
d963 5
a967 19
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).BorrowedTicks, 0
	jne	find_less_borrowed

	mov	eax, ecx
	call	SwitchTaskTo
	jnc	update_next_to_run

; Deadlock error - all tasks are blocked! Should never occur.
find_non_blocked:
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	cmp	eax, NextToRun
	jne	try_to_switch
a968 20
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	ret				; If all the task blocked, roll
					; next task.
try_to_switch:
	call	SwitchTaskTo
	jc	find_non_blocked	; Should not dead lock here.

; Task got execution not in its time share - borrowed a tick.
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	inc	(DosTask PTR fs:[eax]).BorrowedTicks

	ret

find_less_borrowed:
d974 3
a977 1
	mov	esi, (DosTask PTR fs:[eax]).BorrowedTicks
d979 1
a979 1
	dec	(DosTask PTR fs:[eax]).BorrowedTicks
d981 3
d992 4
a995 4
	mov	eax, ebx
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
d1004 1
a1004 3
	call	SwitchTaskTo
; If task was blocked, find first non blocked task.
	jc	find_non_blocked
d1010 2
d1055 2
a1056 1
	call	SwitchTaskTo
a1058 1
find_non_blocked:
d1064 1
a1064 6
	cmp	eax, NextToRun		; If all tasks are blocked, roll
	jne	@@F			; current task.
	ret
@@@@:
	call	SwitchTaskTo
	jc	find_non_blocked	; Should not dead lock here.
d1164 6
a1169 4
	cmp	ah, 16h
	je	handle_int_16
	cmp	ah, 28h
	je	handle_int_28
d1180 1
a1180 3
	mov	eax, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
d1182 2
a1183 2
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	mov	(DosTask PTR fs:[eax]).TaskBlock, INT13_SEMA4
d1216 1
d1218 2
a1219 2
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	mov	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
d1239 3
a1241 6
	mov	edx, CurrentTask
	mov	eax, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	mov	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
d1245 56
d1535 7
a1541 5
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jne	@@F
	cmp	(DosTask PTR fs:[eax]).TaskBlock, INT13_SEMA4
	jne	@@F
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_READY
d1548 2
a1549 4
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
d1551 2
a1552 1
	je	@@F
a1554 1
@@@@:
d1567 58
d1627 3
d1631 94
a1724 2
PUBLIC	FileCallBack
FileCallBack	PROC
d1726 2
a1727 1
FileCallBack	ENDP
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@d36 1
d57 1
d89 5
d148 11
a158 1
; First task created. Add GPF trap.
a214 5
	pushad
	mov	eax, edi
	PM_PRINT_HEX32	, 0, 23, 14
	popad

a415 1
@@@@:
d590 10
a599 1
	call	NextTask
d667 6
d906 27
d942 2
a943 1
IF 0
d946 11
a956 12
;	cmp	Int13Sema4, 0
;	je	@@F
;
;	mov	eax, CurrentTask
;	mov	edx, SIZEOF DosTask
;	mul	edx
;	add	eax, FirstTask
;	inc	(DosTask PTR fs:[eax]).BorrowedTicks
;	ret
;
;@@@@:

d980 11
a991 3
; Update NextToRun task.
update_next_to_run:
	mov	eax, NextToRun
d997 12
a1008 1
	mov	NextToRun, eax
d1043 2
d1051 11
a1063 1

d1065 1
a1065 1

d1069 10
a1078 10
;	cmp	Int13Sema4, 0
;	je	@@F
;
;	mov	eax, CurrentTask
;	mov	edx, SIZEOF DosTask
;	mul	edx
;	add	eax, FirstTask
;	inc	(DosTask PTR fs:[eax]).BorrowedTicks
;	ret

a1092 9
; If next task (in EAX) doesn't have borrowed ticks, switch to it.
	mov	ecx, eax
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).BorrowedTicks, 0
	jne	find_less_borrowed

	mov	eax, ecx
a1095 1
; If task wasn't switched (blocked), search until non blocked task is found.
d1102 2
a1103 9
	call	SwitchTaskTo
	jc	find_non_blocked		; Should not dead lock here.

; Task got execution not in its time share - borrowed a tick.
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	inc	(DosTask PTR fs:[eax]).BorrowedTicks

a1104 28

find_less_borrowed:
; The task has borrowed ticks. Verify what task has the least number of
; borrowed ticks and switch to it. Decrement borrowed ticks of former next.
; EBX is a tested task pointer, EDI holds next task on exit. ESI holds tick
; counter of the former candidate. ECX is a task that was supposed to be
; next.
	mov	ebx, ecx
	mov	esi, (DosTask PTR fs:[eax]).BorrowedTicks
	mov	edi, ecx
	dec	(DosTask PTR fs:[eax]).BorrowedTicks
find_next_task:
	inc	ebx
	cmp	ebx, NumOfTasks
	jb	@@F
	sub	ebx, ebx
@@@@:
	cmp	ebx, ecx
	je	next_task_found

	mov	eax, ebx
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	esi, (DosTask PTR fs:[eax]).BorrowedTicks
	jna	@@F

	mov	edi, ebx
a1105 3
	jmp	find_next_task
next_task_found:
	mov	eax, edi
d1107 1
a1107 8
; If task was blocked, find first non blocked task.
	jc	find_non_blocked

; If next task to switch to is NextToRun anyway, update next to run.
	cmp	eax, NextToRun
	je	update_next_to_run

	ret
d1150 1
a1150 1
ExcRedirect	PROC	USES eax ecx edx
d1160 12
a1171 4
	movzx	ecx, ExcSeg
	shl	ecx, 4
	add	ecx, ExcOffs
	mov	eax, fs:[ecx]	; Get 2 bytes of opcode.
a1176 1
;	and	ExcEflags, NOT FL_IF
d1178 2
a1179 1
	inc	ExcOffs
a1188 1
;	or	ExcEflags, FL_IF
d1190 2
a1191 1
	inc	ExcOffs
d1209 2
d1216 4
a1219 5
	je	@@F
	mov	ecx, CurrentTask
	cmp	ecx, Int13Sema4Own
	je	@@F

d1222 1
a1222 1
	mul	ecx
d1224 1
d1230 2
a1231 1
@@@@:
d1250 3
d1259 1
d1265 25
d1292 2
a1293 1
	add	ExcOffs, 2
d1305 27
d1335 1
a1335 1
	mov	dx, fs:[ecx]		; "POP" client IP
d1337 1
a1337 1
	mov	dx, fs:[ecx+2]		; "POP" client CS
d1339 2
a1340 2
	mov	dx, fs:[ecx+4]		; "POP" client flags
	and	dx, NOT 3000h
d1343 1
a1343 1
	test	dx, FL_IF
d1347 1
a1347 1
	or	dx, FL_IF		; Real IF will always be 1.
d1357 21
d1389 2
a1390 1
	inc	ExcOffs
d1403 1
a1403 1
	and	edx, NOT 3000h
d1406 1
a1406 1
	test	dx, FL_IF
d1410 16
a1425 1
	or	dx, FL_IF
a1426 1

d1428 2
a1429 1
	inc	ExcOffs
d1552 11
@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@d198 5
a335 1

d348 1
d664 2
d667 1
d1163 1
d1167 1
d1169 4
a1172 1
	jne	default_int
d1174 2
d1182 1
a1182 1
; If INT 13h is called by not INT 13h owner, lock the caller on GP.
a1187 1

d1196 24
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d9 1
d65 2
d401 6
d531 3
d536 1
a536 1
StopTask	PROC	USES ecx
d542 35
a576 7
; Switch to system task's address space.
;	mov	ecx, SysPdbLin
;	mov	PdbLin, ecx
;	mov	ecx, SysPagesCtl
;	mov	PagesCtl, ecx
;	mov	ecx, SysPdb
;	mov	cr3, ecx
a580 1

d971 1
a1122 1

d1154 3
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@d32 3
a34 2
	Int13Sema4	DB	0		; INT 13h is a shared
						; resource.
d155 3
a430 1
;	(!) Doesn't save register because IRETs to VM task.
d450 1
d455 7
d477 4
d487 1
a487 1
	mov	cr3, edx		; Load PDBR
d510 1
d603 19
d646 2
d742 1
d753 11
d766 11
a776 1
; Remove deleted flag set (if any).
d816 9
a824 2
	mov	eax, ForegroundTask
	call	SwitchTaskTo
d842 1
d845 14
a858 2
	cmp	Int13Sema4, 0
	je	@@F
d860 1
d862 50
d915 14
a928 1
	inc	(DosTask PTR fs:[eax]).BorrowedTicks
d930 16
d971 1
d973 2
a974 3
; Update NextToRun task.
update_next_to_run:
	mov	eax, NextToRun
d980 9
a988 1
	mov	NextToRun, eax
d1023 2
d1031 11
d1044 1
d1073 1
a1073 1
ExcRedirect	PROC
d1117 19
a1135 1
	jne	@@F
d1140 2
a1141 1
@@@@:
d1268 1
a1268 1
;	I: EAX = 1	-	get semaphore
d1279 1
a1279 1
; Get semaphore.
d1292 3
d1305 14
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d30 2
a31 1
	NextToRun	DD	-1	; Next task to run.
d596 3
a598 3
	mov	eax, 0FFFFFFFFh
	jne	@@F
	sub	eax, eax
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@d20 6
a25 24
	PUBVAR		NumOfTasks, DD, 0	; Number of active tasks.
	PUBVAR		FirstTask, DD, 0	; Ptr to page of tasks.
	PUBVAR		CurrentTask, DD, 0 	; Currently running task.
	PUBVAR		ForegroundTask, DD, 0	; Task owning I/O focus.
	PUBVAR		GpCount, DD, 0	; Counts how much times VM #GP occured.
	PUBVAR		VirtualIf, DD, 0 ; Virtual interrupt flag.

	Fn		DB	"Test.fil", 0
	Fh		DW	?

	TempDt		DF	?

	ComSpecStr	DB	"COMSPEC="
	PspSeg		DW	?

	Dta		DB	512 DUP (?)
	CommandCom	DB	"C:\COMMAND.COM", 0

	ExecPrmBlock	DW	0
			DW	CmdTail, DATA
			DW	5Ch, ?
			DW	6Ch, ?
			DW	?, ?, ?, ?
	CmdTail		DB	0, 0Dh, 0Ah
d27 2
a28 2
	PUBVAR	ClientOpcode, DB, ?
		DB	7 DUP (?)
d30 1
a32 2
	TempEsp		DD	?

d431 1
a431 1
StartTask	PROC
d458 1
a458 1
;	call	TrapVideoPorts		; Free all video ports.
d475 2
a476 2
	push	eax		; GS
	push	eax		; FS
d478 2
a479 2
	push	eax		; DS
	push	eax		; ES
d481 2
a482 2
	push	eax		; SS
	push	VM_STK		; ESP
d488 1
a488 1
	push	FL_VM OR FL_IF	; IOPL = 0
d490 1
a490 1
	push	eax		; CS
d492 1
a492 1
	push	eax		; IP
d494 1
a494 3
switch_addr:
	iretd			; Switch to VM

d599 1
a599 1
;	call	TrapVideoPorts
d788 4
a795 1

d798 3
d807 1
a807 1
	jne	@@F
d811 10
d823 1
a823 1
@@@@:
d855 4
@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@a180 21
	mov	ecx, PdbLin

; Map OS pages in new task.
	mov	eax, es:[ecx + (OS_BASE SHR 20)]
	mov	es:[ebx + (OS_BASE SHR 20)], eax

; Map OS video buffer in new task.
	mov	eax, es:[ecx + (OS_VIDEO_BUF SHR 20)]
	mov	es:[ebx + (OS_VIDEO_BUF SHR 20)], eax

; Map OS heap pages in app.
	mov	edi, OS_HEAP
map_os_heap:
	mov	ebp, edi
	shr	ebp, 20
	mov	eax, es:[ecx + ebp]			
	mov	es:[ebx + ebp], eax			
	add	edi, 400000h
	cmp	edi, OsHeapEnd
	jb	map_os_heap

a186 15
	mov	ecx, PagesCtl

	mov	eax, es:[ecx + (OS_BASE SHR 20)]	; Mark OS pages in new
	mov	es:[edx + (OS_BASE SHR 20)], eax	; task's pages ctl.

	mov	edi, OS_HEAP
mark_os_heap:
	mov	ebp, edi
	shr	ebp, 20
	mov	eax, es:[ecx + ebp]			; Mark OS heap pages
	mov	es:[edx + ebp], eax			; in app's pages ctl.
	add	edi, 400000h
	cmp	edi, OsHeapEnd
	jb	mark_os_heap

d234 40
d277 2
d477 1
a477 1
	call	TrapVideoPorts		; Free all video ports.
d620 1
a620 1
	call	TrapVideoPorts
d660 1
a660 1
;	I: EAX - task number to save context to.
a689 1

a1122 1

a1127 2

			INCLUDE	PHLIB.INC
@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d73 1
d75 1
d77 2
a79 1
		EXTRN	PagesCtl: dword
d113 1
a113 2
; a copy of original DOS. Also memory allocation routines work only within
; system context.
d125 5
a129 1
	mov	eax, Pdb
d183 7
a189 2
	mov	eax, es:[ecx + (OS_BASE SHR 20)]	; Map OS pages in new
	mov	es:[ebx + (OS_BASE SHR 20)], eax	; task.
d265 1
a265 1
	cmp	ecx, (0A0000h + 30000h) SHR 12		; Number of pages to
d355 1
a355 1
	cmp	ecx, (0A0000h + 30000h) SHR 12		; Number of pages to
d394 12
a427 7
	mov	eax, NumOfTasks
	test	eax, eax
	jz	@@F
	dec	eax
@@@@:
	mov	CurrentTask, eax

d478 7
a484 2
	mov	eax, (DosTask PTR fs:[eax]).TaskPdb
	mov	cr3, eax		; Load PDBR
d529 6
a534 2
	mov	ecx, Pdb
	mov	cr3, ecx
d637 4
d642 1
d672 4
d677 1
d727 1
a727 2
; Save video context of foreground task. Meanwhile bitplane modes won't work
; correctly.
a738 1

d758 4
d763 1
d827 2
a828 1
; counter of the former candidate.
@


0.9
log
@VGA state save/restore
@
text
@d70 2
a76 1
		EXTRN	TssBase: dword
d149 4
d254 1
a254 1
	cmp	ecx, (0A0000h + 20000h) SHR 12		; Number of pages to
d344 1
a344 1
	cmp	ecx, (0A0000h + 20000h) SHR 12		; Number of pages to
d452 5
a456 2
	mov	cx, FLAT_DS
	mov	es, cx
d462 1
a462 1
	mov	eax, (DosTask PTR es:[eax]).TaskPdb
d581 10
a590 1
; Remove deleted flag set (if any).
a727 1
	call	RestoreVideoMemory
d731 2
a848 1

@


0.8
log
@Synchronization of system services; bug fixes
@
text
@a23 3
	PUBVAR		DeletedTask, DD, 0FFFFFFFFh ; Set to deleted task
						; unless new one is switched
						; to.
d50 1
d66 4
a69 2
		EXTRN	PmSaveVideoState: near32
		EXTRN	PmRestoreVideoState: near32
d75 1
a76 4
		EXTRN	VSaveHw: byte
		EXTRN	VSaveBIOSMem: byte
		EXTRN	VSaveClr: byte

a377 2
	mov	DeletedTask, eax	; Mark task being deleted.

a429 1
	mov	DeletedTask, 0FFFFFFFFh
a520 4
	cmp	eax, DeletedTask
	jne	@@F
	ret
@@@@:
a573 1
	mov	DeletedTask, 0FFFFFFFFh
d613 1
a613 1
SaveOldFocus	PROC	USES es eax ecx edx esi edi
a614 4
	cmp	eax, DeletedTask
	jne	@@F
	ret
@@@@:
d628 4
a631 10
; Copy task's memory at A0000h - BFFFFh to virtual (take from task's
; alias mapping).
	mov	eax, 0A0000h SHR 12
	mov	esi, 0A0000h
	cld
save_page:
	mov	ecx, 400h			; Number of dwords in 1 page.
	mov	edi, (DosTask PTR es:[edx]).TaskMapping
	mov	edi, es:[edi+eax*4]		; ES:EDI-> dest page
		rep	movs dword ptr es:[edi], es:[esi]
a632 4
	inc	eax				; Next page
	cmp	eax, (0A0000h + 20000h) SHR 12
	jb	save_page

a648 18
; Switch to system's address space.
	mov	eax, Pdb
	mov	cr3, eax

; Save task's video state.
;	call	PmSaveVideoState

	mov	esi, offset VSaveHw
	mov	edi, (DosTask PTR es:[edx]).TaskVideoState
	mov	ecx, 100h
	cld
		rep	movsb

	mov	esi, offset VSaveClr
	mov	ecx, 400h
	cld
		rep	movsb

a681 1
	mov	DeletedTask, 0FFFFFFFFh
a706 20
; Restore video state. Here yet in the system context (!)
	push	es

	mov	esi, (DosTask PTR es:[edx]).TaskVideoState
	mov	edi, offset VSaveHw
	mov	ecx, 100h

	push	ds
	pop	es

	cld
		rep	movs byte ptr es:[edi], fs:[esi]

	mov	edi, offset VSaveClr
	mov	ecx, 400h
	cld
		rep	movs byte ptr es:[edi], fs:[esi]
;	call	PmRestoreVideoState

	pop	es
d711 4
a714 10
; Copy task's memory at A0000h - BFFFFh from virtual (take from task's
; alias mapping).
	mov	eax, 0A0000h SHR 12
	mov	edi, 0A0000h
	cld
restore_page:
	mov	ecx, 400h			; Number of dwords in 1 page.
	mov	esi, (DosTask PTR es:[edx]).TaskMapping
	mov	esi, es:[esi+eax*4]		; ES:ESI-> source page
		rep	movs dword ptr es:[edi], es:[esi]
a715 4
	inc	eax				; Next page
	cmp	eax, (0A0000h + 20000h) SHR 12
	jb	restore_page

d972 1
a972 1
SimulateInt	PROC	near32
d1076 1
d1114 2
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@d48 2
d51 3
d68 2
d76 21
a96 17
		EXTRN	ExcCode		: dword
		EXTRN	ExcOffs		: dword
		EXTRN	ExcSeg		: word
		EXTRN	ExcEflags	: dword
		EXTRN	ExcEax		: dword
		EXTRN	ExcEbx		: dword
		EXTRN	ExcEcx		: dword
		EXTRN	ExcEdx		: dword
		EXTRN	ExcEsp		: dword
		EXTRN	ExcEbp		: dword
		EXTRN	ExcEsi		: dword
		EXTRN	ExcEdi		: dword
		EXTRN	ExcDs		: word
		EXTRN	ExcEs		: word
		EXTRN	ExcFs		: word
		EXTRN	ExcGs		: word
		EXTRN	ExcSs		: word
a99 1

d161 3
d226 1
a226 1
; Allocate 1st Mb alias mapping table
d232 5
d330 4
d499 1
a499 1
StopTask	PROC
d621 2
d674 18
d751 20
d805 3
d810 2
a811 6
NextTask	PROC
	cmp	VirtualIf, 0
	jne	@@F
	ret
@@@@:
	cmp	VirtualIp, 0
d813 6
d820 1
d825 2
a826 1
	jb	SwitchTaskTo
d828 46
a873 1
	jmp	SwitchTaskTo
d886 1
a886 1
FocusToNextTask	PROC
d890 1
a890 1
	jb	SwitchFocusTo
d892 3
a894 1
	jmp	SwitchFocusTo
d919 1
a919 1
	mov	ax, fs:[ecx]	; Get 2 bytes of opcode.
d948 7
d1075 61
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@a47 9
PUBLIC	FDDSema4
PUBLIC	HDDSema4
	FDDSema4	IntSema4 < 0, 13h, 6, 0 >
	HDDSema4	IntSema4 < 0, 13h, 0Eh, 0 >

	FDDSema4Count	DD	0
	FDDSema4Keep	DD	0FFFFFFFFh
	HDDSema4Count	DD	0
	HDDSema4Keep	DD	0FFFFFFFFh
a48 4
	PUBVAR	ClientOpcode, DB, ?
		DB	7 DUP (?)


a150 3
; Set borrowed ticks to 0.
	mov	(DosTask PTR es:[esi]).BorrowedTicks, 0
	
d477 1
a477 1
StopTask	PROC	USES ecx
d490 1
a490 9
; Revoke task's ownership on semaphores (release them).
	cmp	eax, FDDSema4.TaskNo
	jne	@@F
	mov	FDDSema4.Busy, 0
@@@@:
	cmp	eax, HDDSema4.TaskNo
	jne	@@F
	mov	HDDSema4.Busy, 0
@@@@:
d745 9
a753 31
NextTask	PROC	USES	eax ebx ecx edx esi edi
; Increment INT 13 sempahores counters.
	cmp	FDDSema4.Busy, 0
	je	hdd_busy?
	mov	eax, FDDSema4Keep
	cmp	eax, FDDSema4.TaskNo
	jne	hdd_busy?
	inc	FDDSema4Count

hdd_busy?:
	cmp	HDDSema4.Busy, 0
	je	virtual_ip0?
	mov	eax, HDDSema4Keep
	cmp	eax, HDDSema4.TaskNo
	jne	virtual_ip0?
	inc	HDDSema4Count

virtual_ip0?:
; Don't switch from task with pending interrupts.
;	cmp	VirtualIp, 0
;	je	switch

; Increment number of borrowed ticks.
;	mov	edx, SIZEOF DosTask
;	mul	edx
;	add	eax, FirstTask
;	inc	(DosTask PTR fs:[eax]).BorrowedTicks
;	ret

switch:
; Get number of next task in EAX.
d757 1
a757 1
	jb	@@F
d759 1
a759 43
@@@@:
; If next task (in EAX) doesn't have borrowed ticks, switch to it.
	mov	ecx, eax
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).BorrowedTicks, 0
	jne	@@F
	mov	eax, ecx
	call	SwitchTaskTo
	ret

@@@@:
; The task has borrowed ticks. Verify what task has the least number of
; borrowed ticks and switch to it. Decrement borrowed ticks of former next.
; EBX is a tested task pointer, EDI holds next task on exit.
	mov	ebx, ecx
	mov	esi, (DosTask PTR fs:[eax]).BorrowedTicks
	mov	edi, ecx
	dec	(DosTask PTR fs:[eax]).BorrowedTicks
find_next_task:
	inc	ebx
	cmp	ebx, NumOfTasks
	jb	@@F
	sub	ebx, ebx
@@@@:
	cmp	ebx, ecx
	je	next_task_found

	mov	eax, ebx
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	esi, (DosTask PTR fs:[eax]).BorrowedTicks
	jna	@@F
	mov	edi, ebx
@@@@:
	jmp	find_next_task
next_task_found:
	mov	eax, edi
	call	SwitchTaskTo

	ret
a831 9
; Check for INT 13h semaphores.
	cmp	ah, 13h
	jne	@@F
	push	eax
	mov	eax, 1
	call	Int13Sema4s
	pop	eax

@@@@:
a912 111


;-----------------------------------------------------------------------------
;
;	Deals with INT 13h semaphores (gets/releases).
;
;	I: EAX = 1	-	get semaphore
;	         0	-	release semaphore
;	O: CF = 0	-	success
;	        1	-	fail (relevant only to get semaphore).
;
;	On input FS:ECX -> faulting instruction.
;
;-----------------------------------------------------------------------------
PUBLIC	Int13Sema4s
Int13Sema4s	PROC	USES eax
; If failing (DL & 0x80) == 0x80 then deal with hard disk semaphore.
	test	ExcEdx, 80h
	jnz	hdd_sema4
; FDD semaphore.
	test	eax, eax
	jz	rel_fdd_sema4
; Get FDD semaphore.
	xchg	al, FDDSema4.Busy
	test	al, al
	jnz	fail_ret

; Set current task as semaphore owner.
	mov	eax, CurrentTask
	mov	FDDSema4.TaskNo, eax
; Record semaphore keeper and load counter
	cmp	eax, FDDSema4Keep
	je	@@F
	mov	FDDSema4Keep, eax
	mov	FDDSema4Count, 0
@@@@:
; Trap return instruction.
	mov	eax, fs:[ecx+2]
	mov	dword ptr ClientOpcode, eax
	mov	eax, fs:[ecx+2][4]
	mov	dword ptr ClientOpcode[4], eax
; Write invalid opcode instead.
	mov	dword ptr fs:[ecx+2], 0000FFFEh
	mov	dword ptr fs:[ecx+2][4], 00130000h
	jmp	ok_ret

rel_fdd_sema4:
; Release FDD semaphore
	xchg	al, FDDSema4.Busy
; Copy saved opcode back.
	mov	eax, dword ptr ClientOpcode
	mov	fs:[ecx], eax
	mov	eax, dword ptr ClientOpcode[4]
	mov	fs:[ecx][4], eax
; If FDD semaphore counter expired, NextTask().
	cmp	FDDSema4Count, INT13_SEMA4_SLICES
	jb	@@F
	call	NextTask
@@@@:
	jmp	ok_ret

hdd_sema4:
; HDD semaphore.
	test	eax, eax
	jz	rel_hdd_sema4
	
; Get HDD semaphore.
	xchg	al, HDDSema4.Busy
	test	al, al
	jnz	fail_ret

; Set current task as semaphore owner.
	mov	eax, CurrentTask
	mov	HDDSema4.TaskNo, eax
; Record semaphore keeper and load counter
	cmp	eax, HDDSema4Keep
	je	@@F
	mov	HDDSema4Keep, eax
	mov	HDDSema4Count, 0
@@@@:
; Trap return instruction.
	mov	eax, fs:[ecx+2]
	mov	dword ptr ClientOpcode, eax
	mov	eax, fs:[ecx+2][4]
	mov	dword ptr ClientOpcode[4], eax
; Write invalid opcode instead.
	mov	dword ptr fs:[ecx+2], 0000FFFEh
	mov	dword ptr fs:[ecx+2][4], 00130000h
	jmp	ok_ret

rel_hdd_sema4:
; Release HDD semaphore
	xchg	al, HDDSema4.Busy
; Copy saved opcode back.
	mov	eax, dword ptr ClientOpcode
	mov	fs:[ecx], eax
	mov	eax, dword ptr ClientOpcode[4]
	mov	fs:[ecx][4], eax

; If HDD semaphore counter expired, NextTask().
	cmp	HDDSema4Count, INT13_SEMA4_SLICES
	jb	@@F
	call	NextTask
@@@@:
ok_ret:
	clc
	ret
fail_ret:
	stc
	ret
Int13Sema4s	ENDP
@


0.6
log
@Working non-preemptive multitasking
@
text
@d24 3
d87 1
d89 1
d359 2
d412 2
d452 3
d505 4
d518 1
d523 6
d561 2
a571 1

d577 6
d602 4
a605 1

d682 2
d746 8
@


0.5
log
@Working V86 emulation version!
@
text
@d15 1
d18 1
a18 2
	EmulRetAddr	DD	?	; Holds return address for
					; SimulateInt
d20 2
a21 2
	NumOfTasks	DD	0	; Number of active tasks.
	PUBVAR		FirstTask, DD, ?	; Ptr to page of tasks.
d23 1
a23 2
	PUBVAR		Emulated, DB, 0	; Emulation flag (0 - no, 1 - yes).

d25 1
a30 11
public Chk1
public Chk2
public Chk3
public Chk4
public Chk5

	Chk1		DB	"Chk 1$", 0
	Chk2		DB	"Chk 2$", 0
	Chk3		DB	"Chk 3", 0
	Chk4		DB	"Chk 4", 0
	Chk5		DB	"Chk 5", 0
d51 1
d55 3
a57 1

a59 1
		EXTRN	Field: byte
d61 1
a85 1
;ASSUME	CS:CODE32, DS:DATA
d97 2
a98 1
; a copy of original DOS.
d100 1
a100 1
; up to MAX_TASKS (170).
d110 3
d119 1
d123 1
a123 1
	cmp	NumOfTasks, 0		; If 1st task, allocate page for 
d127 5
a131 2
	call	HeapAllocPage		
	jnc	tasks_alloc_ok
d145 1
a159 11
IF 0
; Copy Page directory to new one.
	pushad
	mov	edi, (DosTask PTR es:[esi]).TaskPdbLin
	mov	esi, PdbLin
	mov	ecx, 400h
	cld
		rep	movs dword ptr es:[edi], es:[esi]
	popad
ENDIF

d193 3
a195 3
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	mov	(DosTask PTR es:[esi]).TaskTss, eax	; TSS lin. addr.
a205 11
if 0
;Copy original mapping for all pages under 1Mb.
	pushad
	mov	edi, es:[edx]
	mov	esi, PagesCtl
	mov	esi, es:[esi]
	mov	ecx, 400h
	cld
		rep	movs dword ptr es:[edi], es:[esi]
	popad
endif
d229 1
a229 1
;	cmp	ecx, (0A0000h + 20000h) SHR 12		; Number of pages to
a230 1
	cmp	ecx, 0A0000h SHR 12
d265 1
a268 2

	cld
d272 1
a272 2
;	cmp	edx, (0A0000h + 20000h) SHR 12	; EDX = number of pages?
	cmp	edx, 0A0000h SHR 12
d277 1
d285 57
d348 1
a348 1
DeleteTask	PROC
d362 2
a363 1
	mul	edx			; eax = offset of the task being
d370 1
d375 7
a381 1
	mov	Emulated, 0		; End emulation.
d394 3
a399 3

; In debug purposes don't create new DOS task, use 1-to-1 mapped old DOS.
IF 1
d405 10
d416 6
a428 1
	mov	edx, eax
a429 1

a431 11
	jmp	@@F
@@@@:
ENDIF

; Set ExcRedirect callback.
	mov	eax, 0Dh	; Trap #GP.
	mov	ecx, offset ExcRedirect
	call	AddExcTrap

	mov	Emulated, 1

d443 2
a444 2
; Eflags reg., IOPL=3, IF = 1
	push	FL_VM OR FL_IF OR 3000h	; IOPL = 3
d458 283
d744 2
a745 1
ExcRedirect	PROC	near32
d766 2
a767 1
	and	ExcEflags, NOT FL_IF
d778 2
a779 1
	or	ExcEflags, FL_IF
d811 7
d832 3
d852 7
d880 1
a880 1
SimulateInt	PROC
d885 2
a886 1
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
d888 4
d903 3
a905 1
	and	ExcEflags, NOT (FL_IF OR FL_TF)	; clear IF and TF on handler entry
d923 2
a924 17
	mov	dx, offset Chk1
	mov	ah, 9
	int	21h

	mov	dx, offset Chk2
	mov	ah, 9
	int	21h

if 1
	mov	ax, 3D00h
	mov	dx, offset CommandCom
	int	21h

	mov	bx, ax
	mov	ah, 3Fh
	mov	dx, offset Dta
	mov	cx, 512
a925 37

	mov	ah, 3Eh
	int	21h
else
	mov	ax, 0201h
	mov	bx, ds
	mov	es, bx
	mov	bx, offset Dta
	mov	cx, 1
	mov	dx, 80h
	int	13h
endif

	mov	ax, 0B800h
	mov	fs, ax
if 1
	mov	cx, 200h
	mov	bx, offset Dta
@@@@:
	mov	di, offset Field
	mov	al, [bx]
	call	HexToA

	mov	ah, 7
	mov	al, Field
	mov	fs:[bp], ax
	mov	al, Field[1]
	mov	fs:[bp+2], ax

	add	bp, 6
	inc	bx
	dec	cx
	jne	@@B
endif

	mov	ah, 62h
	int	21h		; Get PSP
a950 5
	mov	ah, 40h
	mov	bx, 2
	mov	cx, 32
	int	21h		; Print command.com path name.

a959 1
int 3
@


0.4
log
@Basic V86 emulation
@
text
@d17 3
d21 3
a23 2
	FirstTask	DD	?	; Ptr to page of tasks.
	CurrentTask	DD	0	; Currently running task.
d43 3
d47 10
d94 2
a95 1
ASSUME	CS:CODE32, DS:DATA
d111 1
a111 1
CreateDosTask	PROC	USES es eax ebx ecx edx esi edi
d121 6
a138 6
	call	LeftFreePages		; Check if enough free pages left.
	cmp	eax, ((0A0000h + 20000h) SHR 12) + 5
	jnb	enough_free
	ret				; CF = 1 already.

enough_free:
d144 1
a159 1
	mov	edi, OS_HEAP
d170 3
d174 4
a177 2
	mov	eax, es:[ecx + (OS_HEAP SHR 20)]	; Map OS heap pages
	mov	es:[ebx + (OS_HEAP SHR 20)], eax	; in app.
d195 4
a198 2
	mov	eax, es:[ecx + (OS_HEAP SHR 20)]	; Mark OS heap pages
	mov	es:[edx + (OS_HEAP SHR 20)], eax	; in app's pages ctl.
a207 7
;
; Allocate 640k base memory + 128k display memory in loop.
; Map them immediately.
;
	sub	ecx, ecx			; Pages count


d217 2
d227 1
a227 1

d240 1
d256 5
a260 2
	mov	ecx, 0C0000h SHR 12
; Map C0000 - FFFFF 1-to-1 and read only.
d264 1
a264 1
	or	eax, PAGE_PRESENT OR PAGE_USER	; Read-only pages.
d270 12
a284 1
	sub	esi, esi
d287 1
d340 2
d356 3
d369 2
a370 1
	mul	edx			; eax = offset of the task to run
d379 2
d386 1
a386 11
; Set data breakpoint to ExcEflags.
	mov	si, ds
	mov	edi, offset ExcEflags
	pushfd
	pop	ebx
	call	PointerToLinear

;	mov	dr0, eax
;	mov	eax, 000D0202h	; Enable bkpt 0: dword, data writes.
;	mov	eax, 00010202h	; Enable bkpt 0: byte, data writes.
;	mov	dr7, eax
d399 2
a400 3
; Eflags reg., IOPL=3
;	push	FL_VM OR FL_IF	; IOPL = 0
	push	FL_VM 		; IOPL = 0
d417 1
a417 1
ExcRedirect	PROC	USES fs eax ecx edx
d428 1
a431 2
	mov	ax, FLAT_DS
	mov	fs, ax
a433 48
	pushad
	push	es

	push	ds
	pop	es

	mov	edi, offset Field
EXTRN	PmHex16ToA:near32
	call	PmHex16ToA
	mov	esi, offset Field
	mov	dh, 0
	mov	dl, 40
	mov	bl, 14
	call	PmWriteStr32

	mov	edi, offset Field
	mov	ax, word ptr ExcSeg
	call	PmHex16ToA

	mov	esi, offset Field
	mov	dh, 0
	mov	dl, 50
	mov	bl, 14
	call	PmWriteStr32

	mov	edi, offset Field
	mov	ax, word ptr ExcOffs
	call	PmHex16ToA

	mov	esi, offset Field
	mov	dh, 0
	mov	dl, 60
	mov	bl, 14
	call	PmWriteStr32

	mov	edi, offset Field
	mov	eax, esp
	call	PmHex32ToA

	mov	esi, offset Field
	mov	dh, 0
	mov	dl, 70
	mov	bl, 14
	call	PmWriteStr32

	pop	es
	popad

d438 1
a438 1
;	and	ExcEflags, NOT FL_IF
d440 1
d449 1
a449 1
;	or	ExcEflags, FL_IF
d460 1
d462 1
a462 19
	mov	eax, fs:[eax*4]		; Get interrupt vector address.

	movzx	ecx, ExcSs
	shl	ecx, 4
	add	ecx, ExcEsp		; FS:ECX points to VM client's stack.
	mov	edx, ExcEflags
	mov	fs:[ecx-2], dx		; "Push" client flags
	mov	dx, ExcSeg
	mov	fs:[ecx-4], dx		; "Push" client CS
	mov	edx, ExcOffs
	add	edx, 2
	mov	fs:[ecx-6], dx		; "Push" client return IP
	sub	ExcEsp, 6		; Adjust client SP

	mov	word ptr ExcOffs, ax
	ror	eax, 16
	mov	ExcSeg, ax		; Store segment part of return
					; address to go to int handler.
	and	ExcEflags, NOT FL_IF	; clear IF on handler entry
d475 1
a475 1
	mov	edx, fs:[ecx]		; "POP" client IP
d477 1
a477 1
	mov	edx, fs:[ecx+2]		; "POP" client CS
d479 2
a480 1
	mov	edx, fs:[ecx+4]		; "POP" client flags
a508 31

	pushad
	push	es
	push	ds
	pop	es
	movzx	eax, ExcSs
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	mov	dh, 2
	mov	dl, 1
	mov	bl, 14
	call	PmWriteStr32
	pop	es
	popad

	pushad
	push	es
	push	ds
	pop	es
	mov	eax, ExcEsp
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	mov	dh, 2
	mov	dl, 10
	mov	bl, 14
	call	PmWriteStr32
	pop	es
	popad

d511 1
a511 15
	pushad
	push	es
	push	ds
	pop	es
	mov	eax, edx
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	mov	dh, 2
	mov	dl, 19
	mov	bl, 14
	call	PmWriteStr32
	pop	es
	popad

d525 31
d566 2
a567 2
;	mov	ax, 3
;	int	10h
d577 4
a580 2
	mov	ax, 3
	int	10h
d582 5
a586 1
	lgdt	fword ptr Dta
d588 7
a594 1
	mov	ax, 201h
a596 1
	mov	bx, offset Dta
d598 1
d600 3
a602 11
	mov	ah, 2
	sub	bx, bx
	sub	dx, dx
	int	10h

;	mov	ah, 9
;	mov	al, 'V'
;	mov	bx, 71h
;	mov	cx, 1000
;	int	10h

a604 3
	mov	ax, 0B800h
	mov	fs, ax
	mov	bp, 0
a614 1
	add	bp, 5
d616 1
d620 33
d654 10
@
