head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@# @;


0.53
date	2002.05.12.23.10.02;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.25.00;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.37.22;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.52.23;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.58.28;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.21.35;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.08.43;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.02.34;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.44.39;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.01.06.26;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.05.12.53.32;	author BlackPhantom;	state Exp;
branches;
next	0.1;

0.1
date	98.05.16.12.45.39;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.59;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Include file for devices control
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				DEVICES.INC
;				-----------
;	Basic devices programming include file for Tripple-DOS.
;
;	For MASM v6.1x.
;
;=============================================================================

IFNDEF	DEVICES_INC
 DEVICES_INC	EQU	1

	INCLUDE	TASKMAN.INC

;
;	General macros.
;
IODelay		MACRO
; Delay after in/out instructions.
	push	ecx
	mov	ecx, 8000h
	loop	$
	pop	ecx
ENDM


;-----------------------------------------------------------------------------
; BIOS data area.
;-----------------------------------------------------------------------------
BIOS_CRT_BASE	EQU	463h		; Base port for CRT addr. (3B0/3D0).
BIOS_BOOT_ADDR	EQU	467h		; Far ptr to BOOT address.

;-----------------------------------------------------------------------------
; Video.
;-----------------------------------------------------------------------------
MONO_BUF	EQU	0B0000h
CLR_TXT_BUF	EQU	0B8000h
CLR_GFX_BUF	EQU	0A0000h

; CRT controller ports and registers.
V_CLR_CRT_ADDR	EQU	3D4h
V_CLR_CRT_DATA	EQU	3D5h
V_MONO_CRT_ADDR	EQU	3B4h
V_MONO_CRT_DATA	EQU	3B5h

	V_Crt_HOR_TOTAL		EQU	0
	V_Crt_HOR_DISP		EQU	1
	V_Crt_HOR_BLANK_ST	EQU	2
	V_Crt_HOR_BLANK_END	EQU	3
	V_Crt_HOR_RETRACE_ST	EQU	4
	V_Crt_HOR_RETRACE_END	EQU	5
	V_Crt_VERT_TOTAL	EQU	6
	V_Crt_OVERFLOW		EQU	7
	V_Crt_PRESET_ROW_SCAN	EQU	8
	V_Crt_MAX_SCAN_LINE	EQU	9
	V_Crt_CURSOR_ST		EQU	0Ah
	V_Crt_CURSOR_END	EQU	0Bh	V_Crt_ST_ADDR_MSB	EQU	0Ch
	V_Crt_ST_ADDR_LSB	EQU	0Dh
	V_Crt_CURSOR_ADDR_MSB	EQU	0Eh
	V_Crt_CURSOR_ADDR_LSB	EQU	0Fh
	V_Crt_VERT_RETRACE_ST	EQU	10h
	V_Crt_VERT_RETRACE_END	EQU	11h
	V_Crt_VERT_END		EQU	12h
	V_Crt_OFFSET		EQU	13h
	V_Crt_UNDERLINE		EQU	14h
	V_Crt_VERT_BLANK_ST	EQU	15h
	V_Crt_VERT_BLANK_END	EQU	16h
	V_Crt_MODE_CTL		EQU	17h
	V_Crt_LINE_CMP		EQU	18h

V_CRT_REGS	=	19h

; Sequencer ports and registers.
V_SEQ_ADDR	EQU	3C4h
V_SEQ_DATA	EQU	3C5h

	V_Seq_RESET		EQU	0
	V_Seq_CLOCK_MODE	EQU	1
	V_Seq_BIT_PLANE_WRITE	EQU	2
	V_Seq_CHAR_GEN_SELECT	EQU	3
	V_Seq_MEM_MODE		EQU	4

V_SEQ_REGS	=	5

; Graphics controller ports and registers.
V_GFX_ADDR	EQU	3CEh
V_GFX_DATA	EQU	3CFh

	V_Gfx_SET_RESET		EQU	0
	V_Gfx_SET_RESET_ENABLE	EQU	1
	V_Gfx_COLOR_CMP		EQU	2
	V_Gfx_DATA_ROTATE	EQU	3
	V_Gfx_BIT_PLANE_READ	EQU	4
	V_Gfx_MODE		EQU	5
	V_Gfx_MISC		EQU	6
	V_Gfx_COLOR_DONT_CARE	EQU	7
	V_Gfx_BIT_MASK		EQU	8

V_GFX_REGS	=	9

; Attribute controller ports and registers.
; Accesses must be separated by >= 250 ns.
V_ATTR_ADDR	EQU	3C0h
V_ATTR_OUT	EQU	3C0h
V_ATTR_IN	EQU	3C1h

V_ATTR_PALETTE_REGS	=	10h

	V_Attr_MODE_CTL		EQU	10h
	V_Attr_BORDER_COLOR	EQU	11h
	V_Attr_CLR_PLANE_ENABLE	EQU	12h
	V_Attr_HOR_PANNING	EQU	13h
	V_Attr_CLR_SELECT	EQU	14h

	V_Attr_SCR_ENABLE	EQU	20h

V_ATTR_REGS	=	V_ATTR_PALETTE_REGS + 5

; DAC ports and registers.
V_DAC_PEL_MASK		EQU	3C6h
V_DAC_STATE_IN		EQU	3C7h
V_DAC_READ_ADDR		EQU	3C7h
V_DAC_WRITE_ADDR	EQU	3C8h
V_DAC_DATA		EQU	3C9h

V_DAC_REGS	=	100h * 3 + 1


V_CLR_FEAT_CTL	EQU	3DAh
V_CLR_STS1	EQU	3DAh
V_MONO_FEAT_CTL	EQU	3BAh
V_MONO_STS1	EQU	3BAh

V_MISC_OUT	EQU	3C2h
V_MISC_IN	EQU	3CCh
V_FEAT_CTL_IN	EQU	3CAh

V_STS0		EQU	3C2h

V_VGA_ENABLE	EQU	3C3h

FIRST_VIDEO_PORT	EQU	3B0h
LAST_VIDEO_PORT		EQU	3DFh


VIDEO_CONTEXT	STRUC
	Crt_Regs	=	$
ORG	$ + V_CRT_REGS
	Seq_Regs	=	$
ORG	$ + V_SEQ_REGS
	Gfx_Regs	=	$
ORG	$ + V_GFX_REGS
	Attr_Regs	=	$
ORG	$ + V_ATTR_REGS
	PelMask		DB	?
	Pel_Data	=	$
ORG	$ + V_DAC_REGS - 1

	MiscOutput	DB	?
	CrtIndex	DB	?
	SeqIndex	DB	?
	GfxIndex	DB	?
	AttrIndex	DB	?
	AttrFlipFlop	DB	?
	PelReadIndex	DW	?
	PelWriteIndex	DW	?
	FeatureCtl	DB	?
VIDEO_CONTEXT	ENDS

; Save video "bunch" registers (address = [base], data = [base+1]).
SAVE_BUNCH_REGS	MACRO	BaseAddr:REQ, EndReg:REQ
LOCAL	save_loop

	mov	edx, BaseAddr
	sub	ah, ah
save_loop:
	mov	al, ah
	out	dx, al
	inc	edx
	in	al, dx
	stosb
	inc	ah
	dec	edx
	cmp	ah, EndReg
	jb	save_loop
ENDM


; Restore video "bunch" registers (address = [base], data = [base+1]).
REST_BUNCH_REGS	MACRO	BaseAddr:REQ, EndReg:REQ
LOCAL	rest_loop
	mov	ch, EndReg
	mov	edx, BaseAddr
	sub	al, al
rest_loop:
	mov	ah, es:[esi]
	inc	esi
	out	dx, ax

	inc	eax
	cmp	al, EndReg
	jb	rest_loop
ENDM


VIDEO_MONO	EQU	1
VIDEO_CGA	EQU	2
VIDEO_EGA	EQU	3
VIDEO_MCGA	EQU	4
VIDEO_VGA	EQU	5

;-----------------------------------------------------------------------------
; CMOS.
;-----------------------------------------------------------------------------
; CMOS ports.
CMOS_ADDR	EQU	70h
CMOS_DATA	EQU	71h

; CMOS addresses
	Cmos_BOOT_STATE	EQU	0Fh	; CMOS boot state reg.
	Cmos_MASK_NMI	EQU	80h	; Value to mask NMI with port 70h
	Cmos_RTC_HOURS	EQU	04h	; CMOS hours
	Cmos_RTC_MIN	EQU	02h	; CMOS minutes
	Cmos_RTC_SEC	EQU	0	; CMOS seconds
	Cmos_XMEM_SIZE0	EQU	30h	; Extended memory size LSB
	Cmos_XMEM_SIZE1	EQU	31h	; Extended memory size MSB

; CMOS CPU reset options
	CMD_AltCtrlDel	EQU	00h
	CMD_ChkMemSize	EQU	01h
	CMD_TestMem	EQU	02h
	CMD_CrcMem	EQU	03h
	CMD_Reboot	EQU	04h
	CMD_PicAndJmp	EQU	05h
	CMD_CpuPmTest	EQU	06h
	CMD_LowToXmsMov	EQU	09h
	CMD_ImmedJmp	EQU	0Ah


;-----------------------------------------------------------------------------
; Keyboard.
;-----------------------------------------------------------------------------
; Keyboard ports.
KBD_DATA	EQU	60h
KBD_PORT_B	EQU	61h
KBD_STATUS	EQU	64h
KBD_COMMAND	EQU	64h

; Keyboard status keys
	Kbd_LShift	EQU	0001h
	Kbd_RShift	EQU	0002h
	Kbd_LCtrl	EQU	0004h
	Kbd_RCtrl	EQU	0008h
	Kbd_LAlt	EQU	0010h
	Kbd_RAlt	EQU	0020h
	Kbd_CapsLock	EQU	0040h
	Kbd_NumLock	EQU	0080h

	Key_LShift	EQU	002Ah
	Key_RShift	EQU	0036h
	Key_LCtrl	EQU	001Dh
	Key_RCtrl	EQU	0E01Dh
	Key_LAlt	EQU	38h
	Key_RAlt	EQU	0E038h
	Key_CapsLock	EQU	003Ah
	Key_NumLock	EQU	0045h

	KEY_Released	EQU	0F0h	; Break code prefix.

; Keyboard status byte (status port, 64h - rd)
	STS_Data_Ready	EQU	01h	; 8042 wants to send data.
	STS_Input_Data	EQU	02h	; Data waits for 8042 in input reg.
	STS_Sys		EQU	04h	; System flag
	STS_Input_Cmd	EQU	08h	; Data in input reg. is a command.
	STS_Kbd_Enabled	EQU	10h	; Keyboard enabled.
	STS_Tx_TimeOut	EQU	20h	; Transmit timeout
	STS_Rx_TimeOut	EQU	40h	; Receive timeout
	STS_Even_Parity	EQU	80h	; Should be 0

; Keyboard controller commands (command port, 64h - wr)
	CMD_ShutDown	EQU	0FEh	; (~Pulse) output port. Bit 0 of
					; output port conn. to CPU reset line
	CMD_A20_Access	EQU	0D1h	; Write output port command.

; Keyboard controller commands (output port)
	CMD_Kbd_Data	EQU	80h
	CMD_Kbd_Clock	EQU	40h
	CMD_Empty_Input	EQU	20h
	CMD_Output_Full	EQU	10h
	CMD_A20		EQU	02h
	CMD_Rst_Off	EQU	01h
	CMD_Undef	EQU	0Ch
	CMD_A20_On	EQU	CMD_Undef OR CMD_Rst_Off OR CMD_A20 OR CMD_Output_Full OR CMD_Kbd_Clock OR CMD_Kbd_Data
	CMD_A20_Off	EQU	CMD_A20_On AND (NOT CMD_A20)

	KEYBOARD_Q_SIZE	EQU	30

;-----------------------------------------------------------------------------
; PIC.
;-----------------------------------------------------------------------------
; PIC ports.
PIC_MASTER	EQU	20h
PIC_MASTER_MASK	EQU	21h
PIC_SLAVE	EQU	0A0h
PIC_SLAVE_MASK	EQU	0A1h

; PIC init commands (Initialization Command Words).
	CMD_ICW1	EQU	11h	; ICW4 needed, cascading 8259h,
					; 8-byte vectors, edge-triggered mode
	CMD_ICW2	EQU	0	; bits 3-7 = A3-A7 int vector.
	CMD_ICW3	EQU	04h	; IRQ 2 has slave, rest - no slave.
	CMD_SLAVE_ICW3	EQU	02h	; Bits 0-2 = master's cascade vector.
	CMD_ICW4	EQU	01h	; Normal EOI, no buffering,
					; sequential mode.
; PIC Operation control words. (reg. select for next read)
	CMD_EOI		EQU	20h	; OCW 2: non-specific EOI, upon IRQ 0
	CMD_Read_IRR	EQU	09h	; Read IRR on next read.
	CMD_Read_ISR	EQU	08h	; Read ISR on next read.

;-----------------------------------------------------------------------------
; PIT.
;-----------------------------------------------------------------------------
PIT_CH0_COUNT	EQU	40h
PIT_CH1_COUNT	EQU	41h
PIT_CH2_COUNT	EQU	42h
PIT_CONTROL	EQU	43h


PIT_FREQUENCY	EQU	1193180		; PIT count rate
PIT_TICK_TO_SEC	EQU	1000		; Ticks per second (must not be >18).

;-----------------------------------------------------------------------------
; DMA
;-----------------------------------------------------------------------------
DMA_CH0_BASE	EQU	0
DMA_CH0_CURR	EQU	0
DMA_CH0_COUNT	EQU	1
DMA_CH1_BASE	EQU	2
DMA_CH1_CURR	EQU	2
DMA_CH1_COUNT	EQU	3
DMA_CH2_BASE	EQU	4
DMA_CH2_CURR	EQU	4
DMA_CH2_COUNT	EQU	5
DMA_CH3_BASE	EQU	6
DMA_CH3_CURR	EQU	6
DMA_CH3_COUNT	EQU	7
DMA_CH4_BASE	EQU	0C0h
DMA_CH4_COUNT	EQU	0C2h
DMA_CH5_BASE	EQU	0C4h
DMA_CH5_COUNT	EQU	0C6h
DMA_CH6_BASE	EQU	0C8h
DMA_CH6_COUNT	EQU	0CAh
DMA_CH7_BASE	EQU	0CCh
DMA_CH7_COUNT	EQU	0CEh

DMA_CH0_PAGE	EQU	87h
DMA_CH1_PAGE	EQU	83h
DMA_CH2_PAGE	EQU	81h
DMA_CH3_PAGE	EQU	82h
DMA_CH5_PAGE	EQU	8Bh
DMA_CH6_PAGE	EQU	89h
DMA_CH7_PAGE	EQU	8Ah

DMA1_CMD	EQU	8
DMA2_CMD	EQU	0D0h
DMA1_STATUS	EQU	8
DMA2_STATUS	EQU	0D0h
DMA1_WRITE_REQ	EQU	9
DMA2_WRITE_REQ	EQU	0D2h
DMA1_MASK	EQU	0Ah
DMA2_MASK	EQU	0D4h
DMA1_MODE	EQU	0Bh
DMA2_MODE	EQU	0D6h
DMA1_ADDR_CLEAR	EQU	0Ch
DMA2_ADDR_CLEAR	EQU	0D8h
DMA1_MASTER_CLEAR	EQU	0Dh
DMA2_MASTER_CLEAR	EQU	0DAh
DMA1_MASK_CLEAR	EQU	0Eh
DMA2_MASK_CLEAR	EQU	0DCh
DMA1_MASK_WRITE	EQU	0Fh
DMA2_MASK_WRITE	EQU	0DEh

MAX_PORTS	EQU	32

GenDevice	STRUCT
	NPorts		DB	?
	Ports		DW	?
REPEAT	MAX_PORTS - 1
			DW	?
ENDM
	Irq		DB	?
	DevSema4	Sema4	<>
GenDevice	ENDS

ENDIF	; DEVICES_INC
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d30 5
d402 14
@


0.49
log
@Fixes version (log for INIT.ASM)
@
text
@@


0.48
log
@Enabled XMS 3.0 interface
@
text
@@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d72 1
a72 2
	V_Crt_CURSOR_END	EQU	0Bh
	V_Crt_ST_ADDR_MSB	EQU	0Ch
d346 51
@


0.45
log
@The shareware beta release
@
text
@@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d24 1
a24 1
;	Basic devices programming include file for MULTIX32.
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Improved task state handling (nesting allowed due to bit mask).
2) Bugs fixed.
TASK_PTR macro is used.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d139 2
d142 1
d292 2
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@d141 2
a151 2
	Crt_Regs	=	$
ORG	$ + V_CRT_REGS
@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@a140 2
	Crt_Regs	=	$
ORG	$ + V_CRT_REGS
d150 3
d186 1
d193 1
@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d164 1
a164 1
SAVE_BUNCH_REGS	MACRO	BaseAddr, EndReg:REQ
a166 1
IFNB	<BaseAddr>
a167 2
ENDIF

d241 17
a257 8
	LShift	EQU	0001h
	RShift	EQU	0002h
	LCtrl	EQU	0004h
	RCtrl	EQU	0008h
	LAlt	EQU	0010h
	RAlt	EQU	0020h
	CapsLock	EQU	0040h
	NumLock	EQU	0080h
@


0.9
log
@VGA state save/resore
@
text
@d17 1
a17 1
	mov	ecx, 100h
d133 1
d149 1
a149 1
	Pel_Mask	DB	?
d152 9
a160 1
	Misc_Output	DB	?
d164 1
a164 1
SAVE_BUNCH_REGS	MACRO	BaseAddr:REQ, EndReg:REQ
d166 2
d169 2
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@d16 2
a17 1
	mov	cx, 100h
d19 1
d36 5
a40 2
CLR_ADDR	EQU	3D4h
CLR_DATA	EQU	3D5h
d42 144
a185 2
MONO_ADDR	EQU	3B4h
MONO_DATA	EQU	3B5h
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@d153 1
a153 1
PIT_TICK_TO_SEC	EQU	1000		; Ticks per second.
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@d153 1
a153 1
PIT_TICK_TO_SEC	EQU	1000		; Ticks per second (must not be >18).
@


0.6
log
@Working non-preemptive multitasking
@
text
@d146 6
@


0.5
log
@Working V86 emulation version!
@
text
@@


0.4
log
@Basic V86 emulation
@
text
@d93 2
@


0.3
log
@Port of previous version to 32 bits
@
text
@d49 1
d77 1
d122 1
d141 5
@


0.1
log
@16/05/98	Initial check-in
@
text
@@
