head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.22.34;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.23.00.57.39;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.05.12.44.00;	author BlackPhantom;	state Exp;
branches
	0.3.0.1;
next	0.2;

0.2
date	98.05.28.02.56.43;	author BlackPhantom;	state Exp;
branches;
next	0.1;

0.1
date	98.05.16.12.47.22;	author BlackPhantom;	state Exp;
branches;
next	;

0.3.0.1
date	98.06.05.20.51.21;	author BlackPhantom;	state Exp;
branches;
next	0.3.0.2;

0.3.0.2
date	98.06.06.00.08.49;	author BlackPhantom;	state Exp;
branches;
next	0.3.0.3;

0.3.0.3
date	98.10.06.03.33.11;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Main initialization and mode switching code
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				INIT.ASM
;				--------
;	Initialization routines and data for Tripple-DOS. 
;	Error handling during initialization.
;
;	For MASM v6.1x.
;
;=============================================================================

	EXTRN	SetupVideo: near
	EXTRN	InitPIC: near
	EXTRN	EnableA20: near
	EXTRN	PmWriteStr: near
	EXTRN	SetupIdt: near
	EXTRN	InitPagesMap: near
	EXTRN	SetupExcTraps: near
	EXTRN	InitDpmiServer: near

	EXTRN	OsStartPage: dword
	EXTRN	OsEndPage: dword
	EXTRN	PagesMap: dword
	EXTRN	PagesMapSeg: word
	EXTRN	PagesCtl: dword
	EXTRN	PagesCtlSeg: word
	EXTRN	PdbLin: dword
	EXTRN	OsHeapBitmap: dword
	EXTRN	OsHeapBitmapSeg: word
	EXTRN	ExcTrapsList: dword
	EXTRN	DynPagesTbl2: dword
	EXTRN	DynPagesTbl2Seg: word
	EXTRN	DmaBufSeg: word
	EXTRN	DmaBufAddr: dword

	EXTRN	TickToSec: dword
	EXTRN	SliceTicks: dword

	EXTRN	CrtId: byte

	INCLUDE	INIT.INC
	INCLUDE	X86.INC
	INCLUDE PHLIB.INC
	INCLUDE	DEVICES.INC
	INCLUDE	DEF.INC

	EXTRN	DoubleFaultEntry: Gate386

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
	CfgFile		DB	"TRIDOS.CFG", 0
	Buf		DB	MAX_CFG_LINE + 1 DUP (?)
	TickToSecStr	DB	"TickToSec", 0
	TickToSliceStr	DB	"SliceTicks", 0

	PUBVAR		GdtBase, DD, ?	; Base linear GDT address.
	TempGdt		DTR	<>	; Gdt DTR.
	TempIdt		DTR	<>	; Temporary IDT for reloading.
	GdtSeg		DW	?	; Base segment of GDT
	PUBVAR		GdtPtr, DW, 8	; Pointer for dynamically creating GDT.

	PUBVAR		SysPdb, DD, ?	; Base address of system PD.
	PUBVAR		SysPagesCtl, DD, ?	; Linear address of system
						; pages control array.
	PUBVAR		SysPdbLin, DD, ?	; System PDB linear address.
	PUBVAR		Pdb, DD, ?	; Base address of current PD.
	PUBVAR		PdbSeg, DW, ?	; Base segment addr. of PD

	PUBVAR		TssBase	, DD, ?	; Base address of TSS
	PUBVAR		OrigTssBase, DD, ?
	TssSeg		DW	?	; Base segment addr. of TSS

	ErrLvl		DW	?	; Current error level during init.
	PUBVAR		Cpu, DW, ?	; CPU type.
	Video		DB	?	; Video adapter type.
	PUBVAR		MemSize, DD, ?	; Extended memory size (starting at
					; 100000h)
	PUBVAR		Start32Esp, DD, ?

	CrLf		DB	0Dh, 0Ah, 0
	MemStr		DB	"Found extended memory (in K): ", 0
	FreeMemStr	DB	"Left free low memory (in bytes): ", 0

	ErrStr		DB	"Error ", 0

PUBLIC	Field
	Field		DB	100 DUP (0)

	PUBVAR		QuitPm, DB, 0		; When 1, system task exits.
	PUBVAR		ListOfLists, DW, ?	; DOS List of lists.
			DW	?
	PUBVAR		ListOfListsLin, DD, ?	; DOS List of lists lin. addr.
	PUBVAR		CurrDrive, DB, ?	; Keeps current drive from
						; start.

; Selectors.
	InitCodeSel	DW	?
	InitDataSel	DW	?
	PUBVAR		InitStkSel, DW, 0
	FlatDataSel	DW	?
	TssSel		DW	?
	Code32Sel	DW	?
	DblFaultTssSel	DW	?

; Real mode IDT.
	RmIdt		DTR	< 3FFh, 0 >
; Error messages.
	GdtErrMsg	DB	": Cannot dynamically allocate GDT", 0
	CpuErrMsg	DB	": CPU 386 or better required", 0
	CpuModeErrMsg	DB	": CPU is already in protected mode", 0
	TssErrMsg	DB	": Cannot dynamically allocate TSS", 0
	ExcTrapsErrMsg	DB	": Cannot dynamically allocate exception traps list", 0
	VideoErrMsg	DB	": A VGA compatible display adapter is required!", 0
	PdErrMsg	DB	": Cannot dynamically allocate memory tables", 0
	NoXmemErrMsg	DB	": Not detected enough physical memory. At least 4M is required", 0
InitErrors	LABEL	INIT_ERROR
	CpuErr		INIT_ERROR	< 1, CpuErrMsg >
	CpuModeErr	INIT_ERROR	< 2, CpuModeErrMsg >
	GdtErr		INIT_ERROR	< 3, GdtErrMsg >
	TssErr		INIT_ERROR	< 4, TssErrMsg >
	ExcTrapsErr	INIT_ERROR	< 5, ExcTrapsErrMsg >
	VideoErr	INIT_ERROR	< 6, VideoErrMsg >
	PdErr		INIT_ERROR	< 7, PdErrMsg >
	NoXmemErr	INIT_ERROR	< 8, NoXmemErrMsg >

	LogStartMsg	DB	"Log initialized", 13, 10, 0
LOG_START_MSG_L	=	$ - offset LogStartMsg

	BiosMemBuf	DB	200 DUP (?)
	BiosMemBufLen	DW	?

; DPMI service page
	PUBVAR		DpmiSrvSeg, DW, ?
	PUBVAR		DpmiSrvAddr, DD, ?
DATA	ENDS


STK	SEGMENT	PARA	STACK	USE16	'STACK'
	DB	STK_SIZE	DUP (?)
STK	ENDS


GDT_SEG	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	DB	10000h DUP (?)
GDT_SEG	ENDS


TSS	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	GeneralTss	Tss386	<>
	IntPermTable	DB	INT_PERM_SIZE DUP (?)
	IoPermTable	DB	IO_PERM_SIZE DUP (?)

ALIGN	8
	DoubleFaultTss	Tss386	<>
TSS	ENDS


INIT_PAGES	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	DB	0E400h + 1000h DUP (?)		; Extra page for alignment.
;	DB	10000h DUP (?)
INIT_PAGES	ENDS


CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME CS:CODE, DS:DATA, SS:STK

IF	@@Version	LT	611
.486p
ELSE
.586p
ENDIF

;-----------------------------------------------------------------------------
;
;	Entry point.
;
;-----------------------------------------------------------------------------
Init		PROC	near
PUBLIC	_main
_main	label far
; Initialize real-mode segment registers.
	mov	ax, DATA
	mov	ds, ax
	mov	es, ax

	call	ParseCfg

; Set init level 1.
	mov	ErrLvl, 1
; Check CPU.
	call	CpuType
	mov	Cpu, ax
	cmp	al, 3
	jnb	cpu_ok
	call	InitErrHandler
cpu_ok:
; Check CPU mode.
	inc	ErrLvl			; Init level 2.
	smsw	ax
	test	ax, 1
	jz	cpu_mode_ok
	call	InitErrHandler
cpu_mode_ok:
; Get default drive.
	mov	ah, 19h
	int	21h
	mov	CurrDrive, al
; Get list of lists.
	sub	eax, eax
	sub	ebx, ebx
	mov	ah, 52h
	int	21h
	mov	ListOfLists, bx
	mov	ListOfLists[2], es
	mov	ax, es
	shl	eax, 4
	add	eax, ebx
	mov	ListOfListsLin, eax
; Init DMA buffer.
	mov	ah, 48h
	mov	bx, 2000h
	int	21h
	and	ax, 0F000h
	add	ax, 1000h
	mov	DmaBufSeg, ax
	movzx	eax, ax
	shl	eax, 4
	mov	DmaBufAddr, eax
; Setup GDT.
	inc	ErrLvl			; Init level 3.
	call	GetGdtBase
	call	SetupGdt
; Initialize DPMI server.
	call	InitDpmiServer
; Setup necessary TSS fields.
	inc	ErrLvl			; Init level 4.
	call	SetupTss
; Init exceptions trap list.
	inc	ErrLvl			; Init level 5.
	call	SetupExcTraps
; Setup video adapter & video memory for protmode.
	inc	ErrLvl			; Init level 6.
	call	SetupVideo
	cmp	CrtId, 5
; Enable A20 line.
	call	EnableA20
; Check extended memory size.
;	cli
;	call	PmGetMemSize
	call	BiosGetMemSize
	mov	MemSize, eax
	call	FindDpmiSrvPage
	mov	DpmiSrvSeg, ax
	movzx	eax, ax
	shl	eax, 4
	mov	DpmiSrvAddr, eax
IFDEF	DEBUG_BUILD
;	sti
; Report found physical memory.
	push	ds
	pop	es
	mov	eax, MemSize
        shl     eax, 2                  ; EAX = # of Kbytes
	mov	edx, eax
	ror	edx, 16
	mov	di, offset Field
	call	LongUIToA
	mov	si, offset MemStr
	call	PrintString
	mov	si, di
	call	PrintString

	mov	si, offset CrLf
	call	PrintString

sub	ah, ah
int	16h
ENDIF	; DEBUG_BUILD

; Set MemSize to actual memory size (add 1Mb).
	add	MemSize, 100h
; Setup page tables.
	inc	ErrLvl			; Init level 7.
	call	SetupPageTables
; Setup memory pages map.
	call	InitPagesMap

IFDEF	DEBUG_BUILD
; Report left free low memory.
	push	ds
	pop	es
	mov	di, offset Field
	mov	dx, 0Ah
	sub	ax, ax
	sub	ax, word ptr OsEndPage
	sbb	dx, word ptr OsEndPage[2]
	call	LongUIToA
	mov	si, offset FreeMemStr
	call	PrintString
	mov	si, di
	call	PrintString
ENDIF	; DEBUG_BUILD

	inc	ErrLvl			; Init level 8.
	cmp	MemSize, 400000h SHR 12	; At least 4M is required!
	jnb	@@F
	call	InitErrHandler
@@@@:

; Enter protmode.
	cli
	call	SetPm

	JmpFar_16_32	CODE_32, offset Start32
Start16::
	cli
	call	SetRm
	sti

; Clear screen - set mode 3.
	mov	ax, 3
	int	10h

	mov	ax, 4C00h	; Normal return to DOS
	int	21h

Init		ENDP


SKIP_WH_SPACES	MACRO	p:REQ
LOCAL	l1, l2, l3
l1:
	cmp	byte ptr [p], ' '
	je	l2
	cmp	byte ptr [p], 9
	je	l2
	cmp	byte ptr [p], 10
	je	l2
	jmp	l3
l2:
	inc	p
	jmp	l1
l3:
ENDM


GET_INT		MACRO	fmt, src, dest:REQ
LOCAL	to_end
 IFNB	<fmt>
 	mov	si, fmt
 ENDIF
 IFNB	<src>
 	mov	di, src
 ENDIF

	call	StrLen
	mov	cx, ax
		repe	cmpsb
	jne	to_end
	SKIP_WH_SPACES	di
	cmp	byte ptr [ di ], '='
	jne	to_end
	inc	di
	SKIP_WH_SPACES	di
	mov	si, di
	call	AToLongUI
	mov	word ptr dest, ax
	mov	word ptr dest[2], dx
to_end:
ENDM


;-----------------------------------------------------------------------------
;
;	Parses the config file TRIDOS.CFG
;
;-----------------------------------------------------------------------------
ParseCfg	PROC
LOCAL	stop: byte
	mov	dx, offset CfgFile
	mov	ax, 3D00h
	int	21h
	jnc	@@F
	ret		; If .CFG file not found - defaults are ready.
@@@@:
	mov	bx, ax
	mov	stop, 0

next_line:
	mov	ax, 4201h
	sub	cx, cx
	sub	dx, dx
	int	21h

	push	dx
	push	ax

	mov	ah, 3Fh
	mov	dx, offset Buf
	mov	cx, MAX_CFG_LINE
	int	21h

	cmp	ax, cx
	je	@@F
	mov	stop, 1
@@@@:
	mov	di, offset Buf
	mov	cx, MAX_CFG_LINE
	mov	al, 13
	cld
		repne	scasb
	jne	@@F
	dec	di
@@@@:
	mov	byte ptr es:[ di ], 0
	sub	cx, MAX_CFG_LINE
	neg	cx
	inc	cx

	pop	ax
	pop	dx
	add	ax, cx
	adc	dx, 0

	mov	cx, dx
	mov	dx, ax
	mov	ax, 4200h
	int	21h
	
; Compare Buf against setup param
	GET_INT	(offset TickToSecStr), (offset Buf), TickToSec
	GET_INT	(offset TickToSliceStr), (offset Buf), SliceTicks
next1:
	cmp	stop, 0
	je	next_line

	ret
ParseCfg	ENDP


;-----------------------------------------------------------------------------
;
;	Determines the base of dynamic GDT
;
;-----------------------------------------------------------------------------
GetGdtBase	PROC	USES es
; Maximum GDT size - 64k.
	mov	eax, GDT_SEG
	mov	GdtSeg, ax

; Set 0 descriptor in GDT GDTR value.
	mov	es, ax
	shl	eax, 4
	mov	GdtBase, eax
	mov	(DTR PTR es:[0]). Limit, 0FFFFh
	mov	(DTR PTR es:[0]). Base, eax

; Fill GDT with 0s.
	mov	di, 8
	mov	cx, 0FFF8h SHR 2
	sub	eax, eax
	cld
		rep	stosd

	ret
GetGdtBase	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = base address.
;	   ECX = limit
;	   DL = access rights,  DH = extended attributes.
;
;	O: AX = selector value (RPL = DPL).
;
;	Dynamically adds GDT segment. 
;	For 32-bit segments caller must supply attributes as well as limit;
;	this function will not apply D/B and G attributes if limit > 1Mb.
;
;-----------------------------------------------------------------------------
AddGdtSegment	PROC	near
	push	es
	mov	es, GdtSeg
	mov	si, GdtPtr
; Create segment.
	mov	(Descriptor386 PTR es:[si]).BaseLow, ax		; Base addr.
	ror	eax, 16
	mov	(Descriptor386 PTR es:[si]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[si]).BaseHigh32, ah
	mov	(Descriptor386 PTR es:[si]).LimitLow, cx	; Limit
	ror	ecx, 16
	and	cl, 0Fh
	mov	(Descriptor386 PTR es:[si]).LimitHigh20, cl
	mov	(Descriptor386 PTR es:[si]).Access, dl		; Access rights.
	or	(Descriptor386 PTR es:[si]).LimitHigh20, dh	; Attr.
; Set AX = selector.
	mov	ax, dx
	shr	ax, 5
	and	ax, 3
	add	ax, GdtPtr
; Advance GDR ptr.
	add	GdtPtr, 8
; Advance GDT limit.
	pop	es
	ret
AddGdtSegment	ENDP


;-----------------------------------------------------------------------------
;
;	Setup the required GDT segments.
;
;-----------------------------------------------------------------------------
SetupGdt	PROC	near
; Setup code segment.
	sub	eax, eax
	mov	ax, cs
	shl	eax, 4		; Base addr.
	ADD_GDT_SEGMENT	, 0FFFFh, CODE_ACCESS
	mov	InitCodeSel, ax

; Setup data segment
	sub	eax, eax
	mov	ax, ds
	shl	eax, 4		; Base addr.
	ADD_GDT_SEGMENT	, 0FFFFh, DATA_ACCESS
	mov	InitDataSel, ax

;
; Setup stack segment. Stack segment must have ATTR_DEF = 1 for 32-bit DPMI
; clients.
;
	sub	eax, eax
	mov	ax, ss
	shl	eax, 4		; Base addr.
	ADD_GDT_SEGMENT	, 0FFFFh, DATA_ACCESS, FLAT_ATTR
	mov	InitStkSel, ax

; Setup FLAT data segment.
	sub	eax, eax	; Base = 00000000h
	ADD_GDT_SEGMENT	, 0FFFFFFFFh, DATA_ACCESS, FLAT_ATTR
	mov	FlatDataSel, ax

; Setup 32-bit code segment.
	mov	eax, CODE32
	shl	eax, 4
	ADD_GDT_SEGMENT	, 0FFFFFFFFh, CODE_ACCESS, FLAT_ATTR
	mov	Code32Sel, ax

	ret
SetupGdt	ENDP


;-----------------------------------------------------------------------------
;
;	Setup page tables:
;	1) Map 1st megabyte 1-to-1 for switch to protmode and back.
;	2) Map OS module (code and data) to 2nd Gb (OS_BASE)
;	3) Adjust OS segments by OS_BASE.
;
; (!)	All allocations must be done prior to setting up page tables.
;
;-----------------------------------------------------------------------------
SetupPageTables	PROC	near
LOCAL	pInitPages: WORD			; Segment address.
LOCAL	OsBasePageTbl: DWORD

	mov	ax, INIT_PAGES

	and	eax, 0000FF00h
	shl	eax, 4
	add	eax, 1000h	; Align to 4 K.
	mov	SysPdb, eax	; Pdb -> page dir.
	shr	eax, 4
	mov	PdbSeg, ax

	mov	pInitPages, ax
	add	pInitPages, 100h

	;
	; Set all page dir entries to 0s (non-present).
	;
	mov	es, PdbSeg
	sub	di, di
	mov	cx, 400h
	sub	eax, eax
	cld
		rep	stosd

	;
	; Allocate first page table for OS heap (OS_HEAP).
	;
	movzx	eax, pInitPages
	add	pInitPages, 100h
	shl	eax, 4

	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[OS_HEAP SHR 20], eax	; Set OS heap base.

	;
	; Allocate page table for OS video buffer.
	;
	movzx	eax, pInitPages
	add	pInitPages, 100h

	mov	cx, ax
	shl	eax, 4
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	es:[OS_VIDEO_BUF SHR 20], eax	; Set OS video buffer base.

	;
	; Allocate page table for global 1st Mb mapping.
	;
	movzx	eax, pInitPages
	add	pInitPages, 100h

	mov	bx, ax
	shl	eax, 4
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	es:[OS_1ST_MB SHR 20], eax	; Set 1st Mb mapping PT base.

	;
	; Allocate a page table for dynamic page tables.
	;
	movzx	eax, pInitPages
	add	pInitPages, 100h

	mov	DynPagesTbl2Seg, ax
	shl	eax, 4
	mov	edi, eax
	or	edi, PAGE_PRESENT OR PAGE_WRITABLE
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	DynPagesTbl2, eax
	mov	es:[OS_DYN_PAGETBLS SHR 20], edi

	;
	; Map video buffer to OS_VIDEO_BUF.
	;
	mov	es, cx
	sub	di, di
	mov	eax, 0A0000h OR PAGE_PRESENT OR PAGE_WRITABLE	; U/S = 0.
map_vbuf:
	mov	es:[di], eax
	add	eax, 1000h
	add	di, 4
	cmp	eax, 0A0000h + 20000h
	jb	map_vbuf

	;
	; Map 1st Mb to OS_1ST_MB.
	;
	mov	es, bx
	sub	di, di
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE	; U/S = 0.
map_1st_mb:
	mov	es:[di], eax
	add	eax, 1000h
	add	di, 4
	cmp	eax, 110000h
	jb	map_1st_mb

	;
	; Allocate pages map.
	;
	mov	ah, 48h
	mov	ebx, MemSize
	shr	ebx, 3 + 4
	inc	bx
	int	21h

	jnc	alloc_ok
	call	InitErrHandler
alloc_ok:
	mov	PagesMapSeg, ax

;
; Get program's start and end pages. All dynamically allocated memory must be
; included (system tables). Use INT 21h/AH=52H to get first MCB and walk
; through all MCBs until the last free block which will be appended to
; free pages.
;
; (!) All dynamic system tables must be allocated BEFORE this point.
;

; Get program's PSP.
	mov	ah, 62h
	int	21h			; Get current process ID.
	mov	cx, bx

	mov	ah, 52h
	int	21h
	mov	dx, es:[bx-2]		; ES = 1st MCB.
	sub	ax, ax			; AX will contain first MCB belonging
					; to multitasker.

walk_mcb_loop:
	mov	es, dx
	cmp	byte ptr es:[0], 'Z'
	je	end_walk_mcb

	test	ax, ax
	jnz	@@F

	cmp	cx, es:[1]
	jne	@@F

	mov	ax, es
	inc	ax

@@@@:
	add	dx, es:[3]
	inc	dx
	jmp	walk_mcb_loop

end_walk_mcb:
; DX = MCB of last (free) block.
	cmp	word ptr es:[1], 0	; Is the last block free?
	je	@@F
	add	dx, es:[3]
@@@@:
	inc	dx
	and	edx, 0000FF00h	
	shl	edx, 4
	add	edx, 1000h	; Align to 4 K. Keep in EDX high page bound.
	add	edx, 1000h	; Reserve.

set_os_end_page:
	mov	edx, 0A0000h
	mov	OsEndPage, edx	; Store end page

	and	eax, 0000FF00h
	shl	eax, 4
	mov	OsStartPage, eax	; Store first page.

; Store linear addresses of pages map.
	movzx	eax, PagesMapSeg
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	PagesMap, eax

	;
	; Allocate page table control array.
	;
	movzx	eax, pInitPages
	add	pInitPages, 100h

	mov	PagesCtlSeg, ax
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	SysPagesCtl, eax

	;
	; Allocate OS heap allocation bitmap.
	;
	movzx	eax, pInitPages
	add	pInitPages, 800h

	mov	OsHeapBitmapSeg, ax
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	OsHeapBitmap, eax

;
; 1) Map 1st Mb 1-to-1. 
; There is only 1 page table required. It will have 256 entries.
;
	movzx	eax, pInitPages
	add	pInitPages, 40h
	shl	eax, 4

; Fill page directory entry.
	push	es
	mov	es, PdbSeg		; ES:0 -> page dir.
	mov	es:[0], eax	; Store page table address.
; Set page table attributes.
	or	byte ptr es:[0], PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER

; Set page table entries.
	shr	eax, 4
	mov	es, ax		; ES:0 -> page table #0.
IFNDEF	PROVIDE_HIMEM
	mov	cx, 100000h SHR 12	; Number of pages to map.
ELSE
	mov	cx, 110000h SHR 12	; Number of pages to map.
ENDIF	;PROVIDE_HIMEM
	sub	si, si		; SI -> page table entry.
map_pages_loop:
	movzx	eax, si
	shl	eax, 10
	mov	es:[si], eax
; Set page attributes.
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	add	si, 4
	dec	cx
	jnz	map_pages_loop
	
;
; 2) Map the entire module to start of 2nd GB.
;

	;
	; Fill page table
	;
; Set ES:[SI] -> page dir entry.
	mov	es, PdbSeg
	mov	si, OS_BASE SHR 20
; Allocate page table entries. ECX = start page, EDX = end page.
	mov	ebx, OsEndPage
	sub	ebx, OsStartPage
	shr	ebx, 10 + 4
	add	ebx, 101h		; +4k for page table must be page-
					; aligned (!)
	mov	ah, 48h
	int	21h
	jnc	set_os_base_page_table
	call	InitErrHandler
set_os_base_page_table:
	and	eax, 0000FF00h	
	shl	eax, 4
	add	eax, 1000h	; Align to 4 K.
; Set page dir. entry.
	mov	es:[si], eax
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
; Set page table entries.
	shr	eax, 4
	mov	es, ax			; ES:0 -> page table entries.
	sub	si, si			; ES:SI -> page table entry to map.

; Adjust OsEndPage.
;	add	OsEndPage, 2000h	; Add 2 pages for page table itself.
;	add	edx, 2000h
	mov	ecx, OsStartPage

map_os_base_pages:
	mov	es:[si], ecx
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
	add	si, 4
	add	ecx, 1000h
	cmp	ecx, edx
	jb	map_os_base_pages

;
; 3) Adjust init. segments and system tables base addresses.
;
	mov	es, GdtSeg
	mov	ecx, OsStartPage
; Adjust code segment.
	mov	ax, cs
	movzx	eax, ax
	shl	eax, 4
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[INIT_CS]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[INIT_CS]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[INIT_CS]).BaseHigh32, ah
; Adjust data segment.
	mov	ax, ds
	movzx	eax, ax
	shl	eax, 4
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[INIT_DS]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[INIT_DS]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[INIT_DS]).BaseHigh32, ah
; Adjust stack segment.
	mov	ax, ss
	movzx	eax, ax
	shl	eax, 4
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[INIT_SS]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[INIT_SS]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[INIT_SS]).BaseHigh32, ah
; Adjust 32-bit code segment.
	mov	ax, CODE32
	movzx	eax, ax
	shl	eax, 4
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[CODE_32]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[CODE_32]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[CODE_32]).BaseHigh32, ah

; Adjust TSSes.
	;
	; General TSS.
	;
	mov	si, TssSel
	mov	es, GdtSeg
	mov	eax, TssBase
	sub	eax, ecx
	or	eax, OS_BASE
	mov	TssBase, eax
	mov	(Descriptor386 PTR es:[si]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[si]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[si]).BaseHigh32, ah

	;
	; Double fault TSS.
	;
	mov	si, DblFaultTssSel
	mov	es, GdtSeg
	mov	eax, TssBase			; Already adjusted!
	add	eax, offset DoubleFaultTss

	mov	(Descriptor386 PTR es:[si]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[si]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[si]).BaseHigh32, ah

; Set SysPdb in CR3 field in double fault TSS.
	mov	ax, TSS
	mov	es, ax
	mov	eax, SysPdb
	mov	es:DoubleFaultTss.rCr3, eax

; Adjust exception traps.
	mov	eax, ExcTrapsList
	sub	eax, ecx
	or	eax, OS_BASE
	mov	ExcTrapsList, eax
to_ret:
	pop	es
	ret
SetupPageTables	ENDP


;-----------------------------------------------------------------------------
;
;	Sets up TSS in GDT.
;
;	There are two TSSes. Task switches will be done in software. One TSS
; is kept to do cross-privilege level control tranfers and the second - to
; do double fault handling.
;
;-----------------------------------------------------------------------------
SetupTss	PROC	USES es
	mov	eax, TSS
PUSHCONTEXT	ASSUMES
ASSUME	ES:TSS

	mov	TssSeg, ax
	mov	es, ax
	shl	eax, 4
	mov	TssBase, eax
	mov	OrigTssBase, eax

; Set TSS entry in GDT.
	mov	ecx, FULL_TSS_SIZE - 1
	mov	dx, TSS386_ACCESS
	call	AddGdtSegment
	mov	TssSel, ax

; Zero defined part of general TSS.
	sub	di, di
	sub	eax, eax
	mov	cx, TSS386_SIZE / 4
		rep	stos dword ptr es:[di]

; Set level 0 stack.
	mov	GeneralTss.Esp0, EXC_STK
	mov	GeneralTss.Ss0, INIT_SS
; Set I/O permition bitmap base.
	mov	GeneralTss.IoTableBase, IO_PERM_START
; Enable access to ports.
	mov	di, offset IoPermTable
	sub	eax, eax
	mov	cx, IO_PERM_SIZE / 4
	cld
		rep	stos dword ptr es:[di]

; Zero defined part of double fault TSS.
	mov	di, offset DoubleFaultTss
	sub	eax, eax
	mov	cx, TSS386_SIZE / 4
		rep	stos dword ptr es:[di]

; Set double fault TSS entry in GDT.
	mov	eax, TssBase
	add	eax, offset DoubleFaultTss

	mov	ecx, TSS386_SIZE
	mov	dx, TSS386_ACCESS
	call	AddGdtSegment
	mov	DblFaultTssSel, ax

	mov	ds:DoubleFaultEntry.DestSel, ax

; Set double fault SS:ESP.
	mov	DoubleFaultTss.rEsp, EXC_STK
	mov	DoubleFaultTss.rSs, INIT_SS

; Set double fault CS:EIP.
	mov	DoubleFaultTss.rCs, CODE_32

	mov	DoubleFaultTss.rEip, offset DoubleFault

; Set DS, ES
	mov	DoubleFaultTss.rDs, INIT_DS
	mov	DoubleFaultTss.rEs, INIT_DS

; Set ES, FS, GS.
	mov	DoubleFaultTss.rFs, FLAT_DS
	mov	DoubleFaultTss.rGs, FLAT_DS

; Set eflags.
	mov	DoubleFaultTss.rEflags, 0

; Set I/O permition bitmap base.
	mov	DoubleFaultTss.IoTableBase, IO_PERM_START

POPCONTEXT	ASSUMES
	ret
SetupTss	ENDP


;-----------------------------------------------------------------------------
;
;	Initializes CPU in protected mode.
;
;-----------------------------------------------------------------------------
SetPm		PROC
; Init PIC for protmode.
	mov	ah, PM_IRQ0
	mov	dx, PIC_MASTER
	call	InitPIC
	mov	ah, PM_IRQ8
	mov	dx, PIC_SLAVE
	call	InitPIC
; Clear nested task flag (!)
	pushf
	pop	ax
	and	ax, NOT FL_NT
	push	ax
	popf
; Load GDTR
	push	es
	mov	es, GdtSeg
	lgdt	fword ptr es:[0]
	pop	es
; Setup IDT
	call	SetupIdt
; Load CR3 (PDBR).
	mov	eax, SysPdbLin
	mov	PdbLin, eax
	mov	eax, SysPagesCtl
	mov	PagesCtl, eax
	mov	eax, SysPdb
	mov	Pdb, eax
	mov	cr3, eax
; Set protected mode with paging.
	mov	eax, cr0
	or	eax, CR0_PE OR CR0_PG
	mov	cr0, eax
; Clear prefetch queue (?)
	JmpFar	INIT_CS, offset pm_entry
pm_entry::
; Setup segment registers.
	mov	ax, INIT_DS
	mov	ds, ax
	mov	es, ax
	mov	ss, InitStkSel
	mov	ax, FLAT_DS
	mov	fs, ax
	mov	gs, ax
; Load task register.
	mov	ax, TssSel
	ltr	ax
; Reload GDT.
	sgdt	fword ptr TempGdt
	mov	eax, OsStartPage
	sub	TempGdt.Base, eax
	or	TempGdt.Base, OS_BASE

	mov	eax, TempGdt.Base
	mov	GdtBase, eax		; Save new GDT base address.

		DB	66h
	lgdt	fword ptr TempGdt	; Use 48-bit, not 40-bit form.
; Reload IDT
	sidt	fword ptr TempIdt
	mov	eax, OsStartPage
	sub	TempIdt.Base, eax
	or	TempIdt.Base, OS_BASE
	
		DB	66h
	lidt	fword ptr TempIdt      ; Use 48-bit, not 40-bit form.
	ret
SetPm		ENDP


;-----------------------------------------------------------------------------
;
;	Returns to real mode.
;
;-----------------------------------------------------------------------------
SetRm		PROC

; Reset SS to have ATTR_DEF = 0.
	mov	eax, GdtBase
	sub	ecx, ecx
	mov	cx, ss
	and	ecx, NOT 7
	and	(Descriptor386 PTR fs:[eax][ecx]).LimitHigh20, NOT FLAT_ATTR
	mov	ax, ss
	mov	ss, ax

IF 1
; Set code segment in area mapped 1-to-1.
	mov	ax, FLAT_DS
	mov	es, ax
	mov	eax, GdtBase
	add	eax, INIT_CS
	mov	cl, (Descriptor386 PTR es:[eax]).BaseHigh24
	mov	ch, (Descriptor386 PTR es:[eax]).BaseHigh32
	shl	ecx, 16
	mov	cx, (Descriptor386 PTR es:[eax]).BaseLow
	and	ecx, NOT OS_BASE
	add	ecx, OsStartPage
	mov	(Descriptor386 PTR es:[eax]).BaseLow, cx
	shr	ecx, 16
	mov	(Descriptor386 PTR es:[eax]).BaseHigh24, cl
	mov	(Descriptor386 PTR es:[eax]).BaseHigh32, ch

	push	cs
	push	offset start_in1to1
	retf

start_in1to1:
ENDIF

; Set segment registers to 16-bit segments.
	mov	ax, INIT_DS
	mov	ds, ax
	mov	es, ax
	sub	ax, ax
	mov	fs, ax
	mov	gs, ax

; Init PIC for real mode.
	mov	ah, 8h
	mov	dx, PIC_MASTER
	call	InitPIC
	mov	ah, 70h
	mov	dx, PIC_SLAVE
	call	InitPIC

	sub	al, al
	out	21h, al			; Enable interrupts
	out	0A1h, al

; Set RM GDT.
;	sub	eax, eax
;	mov	TempGdt.Base, eax
;	mov	TempGdt.Limit, ax
;		DB	66h
;	lgdt	fword ptr TempGdt
; Set IDT to real mode IDT

		DB	66h
	lidt	fword ptr RmIdt		; Use 48-bit, not 40-bit form.

; Set real mode.
	mov	eax, cr0
	and	eax, NOT (CR0_PE OR CR0_PG)
	mov	cr0, eax
; Clear prefetch queue (?)

	JmpFar	CODE, rm_entry
rm_entry::

; Set DS, ES and SS to initial values. FS = GS = 0.
	mov	ax, DATA
	mov	ds, ax
	mov	es, ax
	mov	ax, STK
	mov	ss, ax
	sub	ax, ax
;	mov	fs, ax
	mov	gs, ax

	ret
SetRm		ENDP


;-----------------------------------------------------------------------------
;
;	I:  ErrLvl value (global var.)
;	O:  Displays message with error no. and exits
;
;	Generic init. error handler.
;
;-----------------------------------------------------------------------------
PUBLIC	InitErrHandler
InitErrHandler	PROC	near
	push	ds
	pop	es
; Print "Error ".
	mov	si, offset ErrStr
	call	PrintString
; Print error level.
	mov	bx, ErrLvl
	dec	bx
	imul	bx, bx, SIZEOF (INIT_ERROR)
	mov	ax, InitErrors[bx].Level
	mov	di, offset Field
	call	Hex16ToA
	mov	si, di
	call	PrintString
; Print error message.
	mov	si, InitErrors[bx].Msg
	call	PrintString
; Exit wih errorlevel = init (err) level MOD 256.
	mov	ah, 4Ch
	mov	al, byte ptr ErrLvl
	int	21h
InitErrHandler	ENDP


;-----------------------------------------------------------------------------
;
;  I:	nothing
;  O:	AX = CPU type
;	AL = 0	-	8086/88 (compat.)
;	AL = 1	-	80186/88 (compat.)
;	AL = 2	-	80286
;	AL = 3	-	80386
;	AL = 4	-	80486
;	AL = 5	-	Pentium
;	AL = 6	-	P6
;	AL > 6	-	CPUID capable CPUs.
;
;	Retrevies the CPU type.
;	AH may contain the sub-model (for CPUID supporting processors).
;    
;-----------------------------------------------------------------------------
CpuType		PROC	near
	push	bp
	mov	bp, sp
	sub	sp, 4		; For variables.

	push	sp		; CPU before 286 should first decrease SP
	pop	ax		; and then put the value on stack (BUG).
	cmp	ax, sp
	je	hi186
	;
	; CPU is below 286. Now determine whether it's 86 or 186.
	;
	mov	ax, 1		; Assume CPU is 186.
	push	cx
	mov	cl, 80h		; 8086/88 uses all 8 bits of CL for shift
	shr	ax, cl		; while higher CPUs use only 5 bits.
	pop	cx		; So if CPU is 8086/88, AL becomes 0.
	jmp	to_ret
hi186:
	pushf
	pop	ax
	mov	cx, ax
	xor	ch, 70h		; 80286 doesn't allow to set FLAGS bits
	push	cx		; 12 - 14 via POPF.
	popf
	pushf
	pop	cx
	cmp	ax, cx
	mov	ax, 2
	jz	to_ret
	;
	; CPU is 80386+. Here it's safe to use 386 instructions.
	;
	push	eax		; Save 32-bit registers.
	push	ecx
	pushfd
	pop	eax
	xor	eax, 40000h	; Try to toggle AC bit of EFLAGS (object-alignment
	push	eax		; cause exception). This flag is defined on
	popfd			; 80486+, so it won't be set on 386.
	pushfd
	pop	ecx
	xor	eax, ecx	; If EAX != ECX, AC bit hasn't been toggled
	pop	ecx		; and processor is 386.
	pop	eax
	mov	ax, 3
	jnz	to_ret
	;
	; Processor is 80486+.
	;
	push	eax
	push	ecx
	pushfd
	pop	eax
	xor	eax, 200000h	; Try to toggle ID bit of EFLAGS (CPUID instr.
	push	eax		; support). If it can be toggled, then
	popfd			; processor supports CPUID instruction
	pushfd
	pop	ecx
	xor	eax, ecx	; If EAX != ECX, ID bit hasn't been toggled
	pop	ecx		; and processor is 486.
	pop	eax
	mov	ax, 4
	jnz	to_ret
	;
	; Processor supports CPUID. 'Cause some latest models of 80486 do
	; support the CPUID instruction and future processors would probably
	; also do that, issue this instruction will determine the processor
	; correctly at last.
	;
	and	eax, 0FFFF0000h
	mov	[bp-4], eax
	push	ebx
	push	ecx
	push	edx
	sub	eax, eax

	CPUID			; with EAX = 0, CPUID returns the higher
				; function number in EAX that is supported.
	mov	eax, 1
	CPUID			; Issue this function.
				; AH has the exact value of CPU identification.
	xchg	al, ah
	mov	[bp-4], ax	; Store the correct value of AX.
	pop	edx		
	pop	ecx
	pop	ebx
	mov	eax, [bp-4]	; AL contains the CPU id.
to_ret:
	mov	sp, bp
	pop	bp
	ret
CpuType		ENDP


;-----------------------------------------------------------------------------
;
;	O: EAX = number of pages of memory above 1 M.
;
;	Determines size of extended memory. Uses BIOSes INT 15h services to
; return extended memory size.
;
;-----------------------------------------------------------------------------
BiosGetMemSize	PROC	USES es ebx ecx edx di

; Try INT 15h, AX = E820.
	mov	eax, 0E820h
	sub	ebx, ebx
	mov	ecx, 20
	mov	edx, 'SMAP'
	mov	di, DATA
	mov	es, di
	mov	di, offset BiosMemBuf
	int	15h
	cmp	eax, 'SMAP'
	jne	no_e820

loop_e820:
	add	di, cx
	test	ebx, ebx
	jz	get_e820
	mov	cx, 20
	mov	eax, 0E820h
	int	15h
	jmp	loop_e820

get_e820:
	sub	di, offset BiosMemBuf
	mov	BiosMemBufLen, di

; Calculate memory from info returned by INT 15 / AX = E820.
	sub	eax, eax
	sub	di, di

calc_e820:
	cmp	dword ptr BiosMemBuf[ di ], 100000h
	jb	@@F
	cmp	dword ptr BiosMemBuf[ di ][ 16 ], 1
	jne	@@F
	add	eax, dword ptr BiosMemBuf[ di ][ 8 ]
@@@@:
	add	di, 20
	cmp	di, BiosMemBufLen
	jb	calc_e820

ret_e820:
	shr	eax, 12
	ret

no_e820:

; Try INT 15h / AX = E801
	mov	ax, 0E801h
	int	15h
	jc	no_e801

; Calculate extended memory size.
	test	ax, ax
	jnz	use_ax_bx
	test	bx, bx
	jnz	use_ax_bx
	mov	ax, cx
	mov	bx, dx

use_ax_bx:
	and	eax, 0FFFFh
	and	ebx, 0FFFFh
	shr	eax, 2
	shl	ebx, 4
	add	eax, ebx
	ret

no_e801:

; An old system, try INT 15h / AH = 88h. If >64M memory installed, will not
; report correctly. Also some systems were ovserved not to return CF
; correctly.
	clc				; Some systems preserve carry flag.
	mov	ah, 88h
	int	15h
	jc	no_88
	and	eax, 0FFFFh
	shr	eax, 2
	ret
no_88:
	sub	eax, eax
	ret

BiosGetMemSize	ENDP


;-----------------------------------------------------------------------------
;
;	O: EAX = number of pages of memory above 1 M.
;
;	Determines size of extended memory.
;
;	(!) Interrupts must be off on entry.
;	(!) A20 line must be enabled.
;
;-----------------------------------------------------------------------------
PmGetMemSize	PROC	near USES fs ecx edx esi
	;
	; Switch to protected mode with no paging.
	;
; Load GDTR
	mov	fs, GdtSeg
	lgdt	fword ptr fs:[0]
; Switch to protmode
	mov	eax, cr0
	or	eax, CR0_PE OR CR0_CD	; Disable caching.
	mov	cr0, eax
	wbinvd
	jmp	@@F
@@@@:
	;
	; Test first byte of each 4 Kb page: read, not byte, write, then 
	; read again If two read bytes are equal then this 4 Kb of memory is 
	; not present, finish.
	;
	mov	fs, FlatDataSel

	mov	esi, 100000h
	sub	eax, eax
test_mem_loop:
; Dummy read from address 0 for not fully terminated buses.
	mov	ch, fs:[0]

	mov	cl, fs:[esi]
	mov	ch, cl
	not	ch
	mov	fs:[esi], ch

; Dummy read from address 0 for not fully terminated buses.
	mov	ch, fs:[0]

	mov	ch, fs:[esi]
	cmp	cl, ch
	mov	fs:[esi], cl
	je	end_test_mem

	inc	eax

cmp	eax, 1000000h SHR 12
jnb	end_test_mem

	;
	; This check is applied for boards that disable some address lines.
	; Each time the new address line is used, the memory found "present" 
	; is checked VS memory at address 00000000.
	;
	lea	edx, [esi-1000h]

; If new Addr. line is not used, go on
	test	edx, esi
	jnz	mem_rotate_checked

	mov	cl, fs:[esi]
	mov	ch, fs:[0]
	cmp	cl, ch
	jne	mem_rotate_checked

	mov	ch, cl
	not	cl
	mov	fs:[esi], cl
	cmp	cl, fs:[0]
	mov	fs:[esi], ch
	je	end_test_mem

mem_rotate_checked:
	add	esi, 1000h
	jnc	test_mem_loop
end_test_mem:
	;
	; Switch back to real mode.
	;
	mov	ecx, cr0
        and     ecx, NOT (CR0_PE OR CR0_CD)     ; Enable caching
	mov	cr0, ecx
	jmp	@@F
@@@@:

	ret
PmGetMemSize	ENDP


;-----------------------------------------------------------------------------
;
;	O: AX = segment address for DPMI service page (unused 8K).
;
;-----------------------------------------------------------------------------
FindDpmiSrvPage	PROC	USES es si
	mov	si, 0C000h

skip_bioses:
	mov	es, si
	sub	si, si
	cmp	word ptr es:[si], 0AA55h
	je	skip
	cmp	word ptr es:[si+800h], 0AA55h
	je	skip
	cmp	word ptr es:[si+1000], 0AA55h
	je	skip
	cmp	word ptr es:[si+1800h], 0AA55h
	je	skip

	mov	ax, es
	clc
	ret
	
skip:
	mov	si, es
	add	si, 1000h
	cmp	si, 0F000h
	jb	skip_bioses

	stc
	ret
FindDpmiSrvPage	ENDP


CODE	ENDS


	EXTRN	AllocPage: near32
	EXTRN	MapPage: near32
	EXTRN	PmWriteStr32: near32

IFDEF	DEBUG_BUILD
	EXTRN	InitDbg: near32
ENDIF	; DEBUG_BUILD

	EXTRN	InitCore: near32
	EXTRN	AddExcTrap: near32
	EXTRN	ExcRedirect: near32
	EXTRN	InitPIT: near32
	EXTRN	InitCom1: near32
	EXTRN	WriteLog: near32

	EXTRN	DoubleFault: near32

	EXTRN	KeyReady: byte
	EXTRN	KeyPressed: byte

	EXTRN	VBufTextSel: WORD

CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT
Start32::

	mov	Start32Esp, esp

IFDEF	DEBUG_BUILD
	call	InitDbg
ENDIF	; DEBUG_BUILD

; Initialize V86 mode GP emulation. Set ExcRedirect callback.
	mov	eax, 0Dh	; Trap #GP.
	mov	ecx, offset ExcRedirect
	call	AddExcTrap

; Initialize system core.
	call	InitCore

; Initialize PIT.
	push	edx
	mov	eax, PIT_FREQUENCY
	sub	edx, edx
	div	TickToSec
	pop	edx
	sub	bl, bl
	call	InitPIT

IFDEF	DEBUG_BUILD
; Initialize COM1.
	call	InitCom1
	mov	esi, offset LogStartMsg
	mov	ecx, LOG_START_MSG_L
	call	WriteLog
ENDIF

EXTRN	core_start: near32
	jmp	core_start
PUBLIC	end_pmode
end_pmode:
; Reinitialize PIT for real-mode values (counter 0).
	sub	eax, eax
	sub	bl, bl
	call	InitPIT

	JmpFar_32_16	INIT_CS, offset Start16

CODE32	ENDS


END	Init
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
d55 3
d69 4
d197 2
d204 2
d348 111
d1630 5
a1634 1
	mov	eax, (PIT_FREQUENCY / PIT_TICK_TO_SEC)
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@d426 4
a429 1
; Setup stack segment
d433 1
a433 1
	ADD_GDT_SEGMENT	, 0FFFFh, DATA_ACCESS
d1005 9
d1045 1
@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d1499 1
d1505 1
@


0.49
log
@Fixes version includes:
1) variable mapping of DPMI service pages at C0000, D0000, E0000 instead of a hardcoded address.
2) added 2 32-bit XMS functions and XMS service table is fixed.
3) detection and diagnostic is improved.
@
text
@@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@d55 1
d124 1
d126 1
d133 3
a135 1
	PdErr		INIT_ERROR	< 6, PdErrMsg >
d143 3
d249 1
d251 1
d259 6
d269 1
d283 4
d290 1
a290 1
	inc	ErrLvl			; Init level 6.
d294 2
d309 8
d1305 3
a1307 1
; report correctly.
d1331 1
a1331 1
PmGetMemSize	PROC	near USES es ecx edx esi
d1336 2
a1337 2
	mov	es, GdtSeg
	lgdt	fword ptr es:[0]
a1344 1

d1350 2
a1351 1
	mov	es, FlatDataSel
d1355 4
a1358 1
	mov	cl, es:[esi]
d1361 1
a1361 1
	mov	es:[esi], ch
d1364 1
a1364 1
	mov	ch, es:[0]
d1366 1
a1366 1
	mov	ch, es:[esi]
d1368 1
a1368 1
	mov	es:[esi], cl
d1373 3
d1387 3
a1389 2
	mov	cl, es:[esi]
	cmp	cl, es:[0]
d1394 3
a1396 3
	mov	es:[esi], cl
	cmp	cl, es:[0]
	mov	es:[esi], ch
d1414 36
@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d52 3
d162 2
a163 1
	DB	0D400h + 1000h DUP (?)		; Extra page for alignment.
d218 10
a285 1

d429 1
d475 11
d514 13
d591 2
d675 2
a676 2
	mov	ebx, edx
	sub	ebx, ecx
d697 2
a698 2
	add	OsEndPage, 2000h	; Add 2 pages for page table itself.
	add	edx, 2000h
d1415 1
@


0.45
log
@The shareware beta release
@
text
@d132 3
d231 3
a233 2
	cli
	call	PmGetMemSize
d235 1
a235 1
	sti
d608 5
a612 1
	mov	cx, 100h	; Number of pages to map.
d1152 94
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d24 1
a24 1
;	Initialization routines and data for MULTIX32. 
d50 2
d156 1
a156 1
	DB	0C400h + 1000h DUP (?)		; Extra page for alignment.
d457 15
d661 3
a663 3
	;
	; 3) Adjust init. segments and system tables base addresses.
	;
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d38 2
d89 1
d108 3
d128 3
a281 1
;	mov	(DTR PTR es:[0]). Limit, 7
a331 1
;	add	(DTR PTR es:[0]). Limit, 8
d670 5
a674 1
; Adjust TSS.
d685 20
d720 3
a722 1
;	There is one TSS. Task switches will be done in software.
d729 1
d735 1
d741 7
d758 41
a798 1
		rep	stosd
d892 1
a908 2
	mov	eax, cr3
	mov	cr3, eax
d1213 3
d1225 1
d1246 3
@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@d1067 4
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@d805 1
a805 1
IF 0
d826 2
d859 1
a860 1

d876 1
a876 1
	mov	fs, ax
a1115 1
	EXTRN	HeapAllocPage: near32
a1117 1
	EXTRN	PmHex32ToA: near32
d1127 1
d1154 3
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d408 1
a408 1
	; Allocate page table for OS heap (OS_HEAP).
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@a440 8
; Get program's PSP base page (ECX)
	mov	ah, 62h
	int	21h			; Get current process ID.
	mov	cx, bx
	and	ecx, 0000FF00h
	shl	ecx, 4
	mov	OsStartPage, ecx

a452 1
; Store segment and linear addresses of pages map.
d454 60
a513 1
	movzx	eax, ax
d543 4
a546 4
	;
	; 1) Map 1st Mb 1-to-1. 
	; There is only 1 page table required. It will have 256 entries.
	;
a572 8
	;
	; 2) Map the entire module to start of 2nd GB.
	;
;
; Get program's end page (EDX). All dynamically allocated memory must be
; included (system tables). Use INT 21h/AH=52H to get first MCB and walk
; through all MCBs until the last free block which will be appended to
; free pages.
d574 1
a574 1
; (!) All dynamic system tables must be allocated BEFORE this point.
a576 24
	mov	ah, 52h
	int	21h
	mov	dx, es:[bx-2]		; ES = 1st MCB.
walk_mcb_loop:
	mov	es, dx
	cmp	byte ptr es:[0], 'Z'
	je	end_walk_mcb
	add	dx, es:[3]
	inc	dx
	jmp	walk_mcb_loop
end_walk_mcb:
; DX = MCB of last (free) block.
	cmp	word ptr es:[1], 0	; Is the last block free?
	je	@@F
	add	dx, es:[3]
@@@@:
	inc	dx
	and	edx, 0000FF00h	
	shl	edx, 4
	add	edx, 1000h	; Align to 4 K. Keep in EDX high page bound.
	add	edx, 1000h	; Reserve.

	mov	OsEndPage, edx

d1118 2
d1121 2
d1137 2
d1140 1
@


0.32
log
@Translation services work.
@
text
@d712 1
a712 1
	mov	ah, 20h
d715 1
a715 1
	mov	ah, 28h
@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d19 1
d185 2
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@d12 7
a18 8
INIT_ERROR	STRUC
	Level	DW	?
	Msg	DW	?
INIT_ERROR	ENDS

	EXTRN	SetupIdt: NEAR
	EXTRN	InitPagesMap: NEAR
	EXTRN	SetupExcTraps: NEAR
d20 2
a21 2
	EXTRN	OsStartPage: DWORD
	EXTRN	OsEndPage: DWORD
d31 5
a35 5
			INCLUDE	INIT.INC
			INCLUDE	X86.INC
			INCLUDE PHLIB.INC
			INCLUDE	DEVICES.INC
			INCLUDE	DEF.INC
d43 1
a43 1
	GdtPtr		DW	8	; Pointer for dynamically creating GDT.
d57 1
a57 1
	Cpu		DW	?	; CPU type.
d270 2
a271 1
	mov	(DTR PTR es:[0]). Limit, 7
d274 7
d300 1
a300 3
	mov	esi, GdtBase
	shr	esi, 4
	mov	es, si
d321 1
a321 1
	add	(DTR PTR es:[0]).Limit, 8
a657 1

d754 1
a754 1
; Reload GDT
d759 3
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@a37 5
INIT_PAGES	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	DB	0C400h + 1000h DUP (?)		; Extra page for alignment.
INIT_PAGES	ENDS


d123 5
@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@@


0.23
log
@1) File sharing handled.
@
text
@d38 3
a40 5
TSS	SEGMENT	AT GENERAL_TSS
	GeneralTss	Tss386	<>
	IntPermTable	DB	INT_PERM_SIZE DUP (?)
	IoPermTable	DB	IO_PERM_SIZE DUP (?)
TSS	ENDS
d113 1
a113 1
STK	SEGMENT	PARA STACK	USE16	'STACK'
d118 12
d262 3
a264 9
GetGdtBase	PROC	near
; Allocate maximum GDT size - 64k.
	mov	ah, 48h
	mov	bx, 1000h
	int	21h
	jnc	set_gdt_base
	call	InitErrHandler
set_gdt_base:
	movzx	eax, ax
a267 1
	push	es
a273 1
	pop	es
d375 4
a378 7
	mov	ah, 48h
	mov	bx, 200h
	int	21h		; Allocate 8k for page directory (must be
				; 4K aligned).
	jnc	setup_page_dir
	call	InitErrHandler
setup_page_dir:
d386 3
d402 2
a403 7
	mov	ah, 48h
	mov	bx, 200h
	int	21h
	jnc	mark_os_heap_table
	call	InitErrHandler
mark_os_heap_table:
	and	eax, 0000FF00h
d405 1
a405 1
	add	eax, 1000h	; Align to 4 K.
d412 3
a414 8
	mov	ah, 48h
	mov	bx, 200h
	int	21h
	jnc	mark_os_vbuf_table
	call	InitErrHandler
mark_os_vbuf_table:
	and	eax, 0000FF00h
	add	eax, 100h	; Align to 4K.
d464 2
a465 3
	mov	ah, 48h
	mov	bx, 4096 SHR 4
	int	21h
a466 3
	jnc	alloc_pages_ctl_ok
	call	InitErrHandler
alloc_pages_ctl_ok:
a467 1
	movzx	eax, ax
d476 3
a478 6
	mov	ah, 48h
	mov	bx, 800h		; 32k bitmap for 1Gb of heap.
	int	21h
	jnc	alloc_heap_bmp_ok
	call	InitErrHandler
alloc_heap_bmp_ok:
a479 1
	movzx	eax, ax
d489 2
a490 8
	mov	ah, 48h
	mov	bx, 140h	; 1K needed to be allocated to map 1M,
				; 4K for page table must be aligned.
	int	21h
	jnc	set_page_table
	call	InitErrHandler
set_page_table:
	and	eax, 0000FF00h
a491 1
	add	eax, 1000h	; Align to 4 K.
d667 2
a668 8
SetupTss	PROC	near
; Allocate TSS dynamically.
	mov	ah, 48h
	mov	bx, FULL_TSS_SIZE / 16 + 1
	int	21h
	jnc	setup_tss
	call	InitErrHandler
setup_tss:
a670 1
	push	es
a672 1
	movzx	eax, ax
a692 1
	pop	es
@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@d83 1
d161 2
d167 4
d513 1
a513 1
	and	eax, 0000FF00h	
@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@a34 1
			INCLUDE	X86.MCR
d81 1
a81 1
	PUBVAR		ListOfLists, DW, ?	; DOS list of lists.
d83 2
a102 1

d155 6
a160 1
	mov	ah, 52h			; Get list of lists.
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@d81 3
a83 1
	PUBVAR		QuitPm, DB, 0
d155 4
@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@a24 1
	EXTRN	SysPagesCtl: dword
a26 1
	EXTRN	SysPdbLin: dword
d55 3
a1099 1
	EXTRN	PmSetVideoMode: near32
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@a210 1
	sti
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@d61 1
d689 1
@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d23 9
a31 6
	EXTRN	PagesMap: DWORD
	EXTRN	PagesMapSeg: WORD
	EXTRN	PagesCtl: DWORD
	EXTRN	PagesCtlSeg: WORD
	EXTRN	OsHeapBitmap:DWORD
	EXTRN	OsHeapBitmapSeg:WORD
d56 2
a57 1
	PUBVAR		Pdb, DD, ?	; Base address of PD.
a70 1
	HelloMsg	DB	"Hello, world!", 0	; Test message.
a209 10
	mov	si, offset HelloMsg
	mov	dl, 2
	mov	dh, 10
	mov	bl, 3
	call	PmWriteStr
	mov	si, offset HelloMsg
	mov	dl, 2
	mov	dh, 11
	mov	bl, 5
	call	PmWriteStr
d364 1
a364 1
	mov	Pdb, eax	; Pdb -> page dir.
d391 1
a391 1
	mov	es:[800h], eax	; Set OS heap base 
d393 29
d465 1
a465 1
	mov	PagesCtl, eax
d737 7
a743 2
; Load CR3 (PDBR)
	mov	eax, Pdb
d1133 2
a1134 2
EXTRN	pmode_loop: near32
	jmp	pmode_loop
@


0.9
log
@VGA state save/restore
@
text
@d29 1
d631 5
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@d55 1
a55 1
	TssBase		DD	?	; Base address of TSS
d625 1
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@d1098 4
a1101 6
PUBLIC	pmode_loop
pmode_loop::
; If Mode0 is non-0 (1), set mode 0 via InvokeV86Int
	sub	al, al
	cmp	QuitPm, 0
	je	pmode_loop
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@d1098 6
a1103 4

EXTRN	pmode_loop: near32
	jmp	pmode_loop
PUBLIC	end_pmode
@


0.6
log
@Working non-preemptive multitasking
@
text
@d1074 1
d1094 4
d1105 5
@


0.5
log
@Working V86 emulation version!
@
text
@d63 1
d71 2
a75 1
	PUBVAR		Mode0, DB, 0
d224 4
d529 1
d1071 3
d1078 2
a1080 1
;ASSUME	CS:CODE32, DS:DATA
d1083 1
d1085 10
a1094 1
pmode_loop:
a1096 5
	cmp	Mode0, 0
	je	mode_set
	call	PmSetVideoMode
	mov	Mode0, 0
mode_set:
a1097 2
	jne	end_pmode
	cmp	KeyReady, 0
a1098 50

	cmp	KeyPressed, 3Bh		; F1?
	jne	@@F
EXTRN	StartTask: near32
	call	StartTask
	mov	KeyReady, 0
	jmp	pmode_loop

@@@@:
	cmp	KeyPressed, 3Ch		; F2?
	jne	@@F
EXTRN	HeapAllocPage: near32
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage

	push	eax

; Print allocated page lin. address
	mov	edi, offset Field
EXTRN	PmHex32ToA: near32
	call	PmHex32ToA
	mov	bl, 13h
	mov	dh, 16
	mov	dl, 40
	mov	esi, offset Field
EXTRN	PmWriteStr32: near32
	call	PmWriteStr32

EXTRN	LinearToPhysical: near32
	call	LinearToPhysical

; Print allocated page lin. address
	mov	edi, offset Field
	call	PmHex32ToA
	mov	bl, 13h
	mov	dh, 16
	mov	dl, 50
	mov	esi, offset Field
	call	PmWriteStr32

	pop	eax
	mov	ecx, fs:[eax]			; Test read
	mov	fs:[eax], ecx			; test write

	mov	KeyReady, 0
	jmp	pmode_loop

@@@@:
	mov	KeyReady, 0
	jmp	pmode_loop
@


0.4
log
@Basic V86 emulation
@
text
@d19 1
d45 1
d89 2
a91 1
	TssErrMsg	DB	": Cannot dynamically allocate TSS", 0
d98 2
a99 1
	PdErr		INIT_ERROR	< 5, PdErrMsg >
a100 1

d128 1
d152 3
d179 1
d183 1
a183 1
	inc	ErrLvl			; Init level 5.
d200 1
d218 1
d220 1
d789 1
d792 3
a794 3
	sub	eax, eax
	mov	TempGdt.Base, eax
	mov	TempGdt.Limit, ax
d804 1
a804 1
	and	eax, (NOT CR0_PE) AND (NOT CR0_PG)
a820 2
	sti

d981 1
a981 1
PmGetMemSize	PROC	near USES es esi cx edx
d986 1
a986 3
	mov	eax, GdtBase
	shr	eax, 4
	mov	es, ax
d1011 1
a1013 1
	mov	es:[esi], cl
d1023 1
a1023 1
; If not new Addr. line is used, go on
d1030 2
d1033 1
a1033 1
	mov	byte ptr es:[esi], cl
d1035 3
a1037 5
	jne	@@F
	not	byte ptr es:[esi]
	jmp	end_test_mem
@@@@:
	not	byte ptr es:[esi]
d1063 1
d1069 2
a1070 1
ASSUME	CS:CODE32, DS:DATA
d1072 1
d1097 1
d1100 2
d1109 1
a1109 1
	mov	si, offset Field
d1112 16
@


0.3
log
@Port of previous version to 32 bits.
@
text
@d17 2
a18 1
	EXTRN	SetupIdt: near
d20 9
d44 3
a46 1
	GdtBase		DD	?	; Base linear GDT address.
d50 2
a51 2
	Pdb		DD	?	; Base address of PD.
	PdbSeg		DW	?	; Base segment addr. of PD
d59 1
a59 1
	MemSize		DD	?	; Extended memory size (starting at
d62 1
d65 1
d68 1
a68 1
	Field		DB	10 DUP (0)
d87 1
a87 1
	PdErrMsg	DB	": Cannot dynamically allocate PD", 0
d94 2
a95 2
	PdErr		INIT_ERROR	< 4, PdErrMsg >
	TssErr		INIT_ERROR	< 5, TssErrMsg >
d145 1
a145 1
; Setup page tables.
a146 3
	call	SetupPageTables
; Setup necessary TSS fields.
	inc	ErrLvl			; Init level 5.
d152 1
a153 1
; Check extended memory size.
d157 1
d160 1
d164 1
a164 1
	call	Hex32ToA
d167 24
a190 1
	mov	si, offset Field
d334 4
a337 12
;	I: EAX = physical address
;	   ECX = linear address
;	   EDX = PDB address
;
;	Maps given physical page to linear address.
;
;-----------------------------------------------------------------------------
MapPage		PROC	near
MapPage		ENDP


;-----------------------------------------------------------------------------
d339 1
a339 1
;	Setup page tables.
d350 87
d439 3
a441 3
	and	eax, 0FFFFF000h
	add	eax, 1000h	; Align to 4 K. 
	mov	Pdb, eax	; Pdb -> page dir.
d444 2
a445 2
	; For test purpose, map 1st Mb 1-to-1. There is only 1 page table
	; required. It will have 256 entries.
d450 1
d454 1
a454 1
	movzx	eax, ax
a455 1
	and	eax, 0FFFFF000h	
d460 1
a460 3
	mov	ecx, Pdb
	shr	ecx, 4
	mov	es, cx		; ES:0 -> page dir.
d467 1
a467 1
	mov	es, ax		; ES:0 -> page table #0 (the only).
d481 1
a481 1
	; Map the entire module to start of 2nd GB.
d483 24
a506 17
; Get program's PSP base page (ECX)
	mov	ah, 62h
	int	21h			; Get current process ID.
	movzx	ecx, bx
	shl	ecx, 4
	and	ecx, 0FFFFF000h
; Get program's end page (EDX).
	lea	ax, [bx-1]
	mov	es, ax
	movzx	eax, word ptr es:[3]	; Memory block (module) size.
	add	ax, bx
	shl	eax, 4
	test	eax, 0FFFh
	jz	@@F
	and	eax, 0FFFFF000h
	add	eax, 1000h
	mov	edx, eax
d508 7
a514 1
	jmp	skip
d516 1
a516 1
	; Adjust init. segments base addresses.
d518 21
a538 1
	mov	eax, GdtBase
d540 21
a560 1
	mov	es, ax
d591 2
a592 20

skip:
	;
	; Fill page table
	;
; Set ES:[SI] -> page dir entry.
	mov	eax, Pdb
	shr	eax, 4
	mov	es, ax
	mov	si, OS_BASE SHR 20
; Allocate page table entries. ECX = start page, EDX = end page.
	mov	ebx, edx
	sub	ebx, ecx
	shr	ebx, 10 + 4
	inc	ebx
	mov	ah, 48h
	int	21h
	jnc	set_os_base_page_table
	call	InitErrHandler
set_os_base_page_table:
d595 17
a611 14
; Set page dir. entry.
	mov	es:[si], eax
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
; Set page table entries.
	shr	eax, 4
	mov	es, ax			; ES:0 -> page table entries.
	sub	si, si			; ES:SI -> page table entry to map.
map_os_base_pages:
	mov	es:[si], ecx
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
	add	si, 4
	add	ecx, 1000h
	cmp	ecx, edx
	jb	map_os_base_pages
d685 1
a685 3
	mov	eax, GdtBase
	shr	eax, 4
	mov	es, ax
d705 3
d711 16
d737 31
d775 10
d786 5
a790 2
	lidt	fword ptr RmIdt
; Set DS, ES and SS to initial values.
d795 1
d798 2
d805 6
d823 1
d825 2
d963 1
a963 1
;	O: EAX = number of Kbytes of memory above 1 M.
d984 1
d1006 1
a1006 1
	add	eax, 4
d1038 1
a1038 1
	and	ecx, NOT CR0_PE
d1050 8
d1062 1
a1062 1
@@@@:
d1068 1
a1069 1
	mov	Mode0, 0
d1071 35
a1105 1
	je	@@B
@


0.3.0.1
log
@Page mapping bug fixed.
Page tables were not aligned.
@
text
@a17 1
	EXTRN	InitPagesMap: near
d38 1
a38 1
	PUBVAR		Pdb, DD, ?	; Base address of PD.
d47 1
a47 1
	PUBVAR		MemSize, DD, ?	; Extended memory size (starting at
a74 1
	PagesMapErrMsg	DB	": Cannot synamically allocate memory map", 0
a81 1
	PagesMapErr	INIT_ERROR	< 6, PagesMapErrMsg >
a136 3
; Setup memory pages map.
	inc	ErrLvl			; Init level 6.
	call	InitPagesMap
a326 2
	shr	eax, 4
	mov	PdbSeg, ax
d345 3
a347 1
	mov	es, PdbSeg		; ES:0 -> page dir.
d386 1
a386 1
	mov	edx, eax	; Keep in EDX high page bound.
d388 1
a388 1
;	jmp	skip
d392 3
a394 1
	mov	es, GdtSeg
a424 10
; Adjust 32-bit code segment.
	mov	ax, CODE32
	movzx	eax, ax
	shl	eax, 4
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[CODE_32]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[CODE_32]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[CODE_32]).BaseHigh32, ah
d431 3
a433 1
	mov	es, PdbSeg
d439 1
a439 2
	add	ebx, 101h		; +4k for page table must be page-
					; aligned (!)
a446 1
	and	eax, 0FFFFF000h
a601 1
PUBLIC	InitErrHandler
d835 1
a836 1
mode_set:
@


0.3.0.2
log
@Tuned odds and ends.
@
text
@d17 2
a18 2
	EXTRN	SetupIdt: NEAR
	EXTRN	InitPagesMap: NEAR
a19 3
	EXTRN	OsStartPage: DWORD
	EXTRN	OsEndPage: DWORD

d35 1
a35 1
	PUBVAR		GdtBase, DD, ?	; Base linear GDT address.
a50 1
	CrLf		DB	0Dh, 0Ah, 0
a52 1
	FreeMemStr	DB	"Left free low memory (in bytes): ", 0
d55 1
a55 1
	Field		DB	100 DUP (0)
d82 3
a84 3
	TssErr		INIT_ERROR	< 4, TssErrMsg >
	PagesMapErr	INIT_ERROR	< 5, PagesMapErrMsg >
	PdErr		INIT_ERROR	< 6, PdErrMsg >
d134 3
d138 1
a138 1
	inc	ErrLvl			; Init level 4.
d141 1
a141 1
	inc	ErrLvl			; Init level 5.
a142 3
; Setup page tables.
	inc	ErrLvl			; Init level 6.
	call	SetupPageTables
a151 1
; Report found physical memory.
d157 1
a157 1
	call	LongUIToA
d160 1
a160 13
	mov	si, di
	call	PrintString

	mov	si, offset CrLf
	call	PrintString
; Report left free low memory.
	mov	di, offset Field
	mov	dx, 0Ah
	sub	ax, ax
	sub	dx, word ptr OsEndPage[2]
	sbb	ax, word ptr OsEndPage
	call	LongUIToA
	mov	si, offset FreeMemStr
a161 2
	mov	si, di
	call	PrintString
d317 1
a317 4
;	Setup page tables:
;	1) Map 1st megabyte 1-to-1 for switch to protmode and back.
;	2) Map OS module (code and data) to 2nd Gb (OS_BASE)
;	3) Adjust OS segments by OS_BASE.
d337 2
a338 2
	; 1) Map 1st Mb 1-to-1. 
	; There is only 1 page table required. It will have 256 entries.
d374 1
a374 1
	; 2) Map the entire module to start of 2nd GB.
d382 5
a386 47

; Get program's end page (EDX). All dynamically allocated memory must be
; included (system tables). Use INT 21h/AH=52H to get first MCB and walk
; through all MCBs until the last free block which will be appended to
; free pages.

	mov	ah, 52h
	int	21h
	mov	dx, es:[bx-2]		; ES = 1st MCB.
walk_mcb_loop:
	mov	es, dx
	cmp	byte ptr es:[0], 'Z'
	je	end_walk_mcb
	add	dx, es:[3]
	inc	dx
	jmp	walk_mcb_loop
end_walk_mcb:
; DX = MCB of last (free) block.
	cmp	word ptr es:[1], 0	; Is the last block free?
	je	@@F
	add	dx, es:[3]
@@@@:
	inc	dx
	movzx	edx, dx
	shl	edx, 4		; Keep in EDX high page bound.

	mov	OsStartPage, ecx
	mov	OsEndPage, edx

	;
	; Fill page table
	;
; Set ES:[SI] -> page dir entry.
	mov	es, PdbSeg
	mov	si, OS_BASE SHR 20
; Allocate page table entries. ECX = start page, EDX = end page.
	mov	ebx, edx
	sub	ebx, ecx
	shr	ebx, 10 + 4
	add	ebx, 101h		; +4k for page table must be page-
					; aligned (!)
	mov	ah, 48h
	int	21h
	jnc	set_os_base_page_table
	call	InitErrHandler
set_os_base_page_table:
	movzx	eax, ax
d388 2
d391 4
a394 15
; Set page dir. entry.
	mov	es:[si], eax
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
; Set page table entries.
	shr	eax, 4
	mov	es, ax			; ES:0 -> page table entries.
	sub	si, si			; ES:SI -> page table entry to map.
map_os_base_pages:
	mov	es:[si], ecx
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
	add	si, 4
	add	ecx, 1000h
	cmp	ecx, edx
	jb	map_os_base_pages

d396 1
a396 1
	; 3) Adjust init. segments base addresses.
a398 1
	mov	ecx, OsStartPage
d440 35
@


0.3.0.3
log
@Memory management added and corrected; bug fixes.
@
text
@a21 6
	EXTRN	PagesMap: DWORD
	EXTRN	PagesMapSeg: WORD
	EXTRN	PagesCtl: DWORD
	EXTRN	PagesCtlSeg: WORD
	EXTRN	OsHeapBitmap:DWORD
	EXTRN	OsHeapBitmapSeg:WORD
a38 2
	TempGdt		DTR	<>	; Gdt DTR.
	TempIdt		DTR	<>	; Temporary IDT for reloading.
d43 1
a43 1
	PUBVAR		PdbSeg, DW, ?	; Base segment addr. of PD
d79 1
a79 1
	PdErrMsg	DB	": Cannot dynamically allocate memory tables", 0
d81 1
d88 2
a89 1
	PdErr		INIT_ERROR	< 5, PdErrMsg >
d142 6
d152 1
a153 1
	cli
a159 1
        shl     eax, 2                  ; EAX = # of Kbytes
a170 7
; Set MemSize to actual memory size (add 1Mb).
	add	MemSize, 100h
; Setup page tables.
	inc	ErrLvl			; Init level 5.
	call	SetupPageTables
; Setup memory pages map.
	call	InitPagesMap
a171 2
	push	ds
	pop	es
d175 2
a176 2
	sub	ax, word ptr OsEndPage
	sbb	dx, word ptr OsEndPage[2]
d324 13
a341 2
; (!)	All allocations must be done prior to setting up page tables.
;
d351 1
a351 1
	and	eax, 0000FF00h
d353 2
a354 1
	add	eax, 1000h	; Align to 4 K.
a359 86
	; Set all page dir entries to 0s (non-present).
	;
	mov	es, PdbSeg
	sub	di, di
	mov	cx, 400h
	sub	eax, eax
	cld
		rep	stosd

	;
	; Allocate page table for OS heap (OS_HEAP).
	;
	mov	ah, 48h
	mov	bx, 200h
	int	21h
	jnc	mark_os_heap_table
	call	InitErrHandler
mark_os_heap_table:
	and	eax, 0000FF00h
	shl	eax, 4
	add	eax, 1000h	; Align to 4 K.
	or	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	mov	es:[800h], eax	; Set OS heap base 

; Get program's PSP base page (ECX)
	mov	ah, 62h
	int	21h			; Get current process ID.
	mov	cx, bx
	and	ecx, 0000FF00h
	shl	ecx, 4
	mov	OsStartPage, ecx

	;
	; Allocate pages map.
	;
	mov	ah, 48h
	mov	ebx, MemSize
	shr	ebx, 3 + 4
	inc	bx
	int	21h

	jnc	alloc_ok
	call	InitErrHandler
alloc_ok:
; Store segment and linear addresses of pages map.
	mov	PagesMapSeg, ax
	movzx	eax, ax
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	PagesMap, eax

	;
	; Allocate page table control array.
	;
	mov	ah, 48h
	mov	bx, 4096 SHR 4
	int	21h

	jnc	alloc_pages_ctl_ok
	call	InitErrHandler
alloc_pages_ctl_ok:
	mov	PagesCtlSeg, ax
	movzx	eax, ax
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	PagesCtl, eax

	;
	; Allocate OS heap allocation bitmap.
	;
	mov	ah, 48h
	mov	bx, 800h		; 32k bitmap for 1Gb of heap.
	int	21h
	jnc	alloc_heap_bmp_ok
	call	InitErrHandler
alloc_heap_bmp_ok:
	mov	OsHeapBitmapSeg, ax
	movzx	eax, ax
	shl	eax, 4
	sub	eax, OsStartPage
	or	eax, OS_BASE
	mov	OsHeapBitmap, eax

	;
a365 1
	int	21h
d369 1
a369 1
	and	eax, 0000FF00h	
d371 1
d383 1
a383 1
	mov	es, ax		; ES:0 -> page table #0.
d399 7
a405 1
;
a409 3
;
; (!) All dynamic system tables must be allocated BEFORE this point.
;
d428 2
a429 3
	and	edx, 0000FF00h	
	shl	edx, 4
	add	edx, 1000h	; Align to 4 K. Keep in EDX high page bound.
d431 1
d451 1
a451 1
	and	eax, 0000FF00h	
d453 1
a453 1
	add	eax, 1000h	; Align to 4 K.
d456 1
a456 1
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
a460 6

; Adjust OsEndPage.
	add	OsEndPage, 2000h	; Add 2 pages for page table itself.
	add	edx, 2000h
	mov	ecx, OsStartPage

d470 1
a470 1
	; 3) Adjust init. segments and system tables base addresses.
a513 10
; Adjust TSS.
	mov	si, TssSel
	mov	es, GdtSeg
	mov	eax, TssBase
	sub	eax, ecx
	or	eax, OS_BASE
	mov	(Descriptor386 PTR es:[si]).BaseLow, ax
	ror	eax, 16
	mov	(Descriptor386 PTR es:[si]).BaseHigh24, al
	mov	(Descriptor386 PTR es:[si]).BaseHigh32, ah
d588 3
a590 1
	mov	es, GdtSeg
a612 16
; Reload GDT
	sgdt	fword ptr TempGdt
	mov	eax, OsStartPage
	sub	TempGdt.Base, eax
	or	TempGdt.Base, OS_BASE

		DB	66h
	lgdt	fword ptr TempGdt	; Use 48-bit, not 40-bit form.
; Reload IDT
	sidt	fword ptr TempIdt
	mov	eax, OsStartPage
	sub	TempIdt.Base, eax
	or	TempIdt.Base, OS_BASE
	
		DB	66h
	lidt	fword ptr TempIdt      ; Use 48-bit, not 40-bit form.
a622 31

IF 0
; Set code segment in area mapped 1-to-1.
	mov	ax, FLAT_DS
	mov	es, ax
	mov	eax, GdtBase
	mov	cl, (Descriptor386 PTR es:[eax]).BaseHigh24
	mov	ch, (Descriptor386 PTR es:[eax]).BaseHigh32
	shl	ecx, 16
	mov	cx, (Descriptor386 PTR es:[eax]).BaseLow
	and	ecx, NOT OS_BASE
	add	ecx, OsStartPage
	mov	(Descriptor386 PTR es:[eax]).BaseLow, cx
	shr	ecx, 16
	mov	(Descriptor386 PTR es:[eax]).BaseHigh24, cl
	mov	(Descriptor386 PTR es:[eax]).BaseHigh32, ch

	push	cs
	push	offset start_in1to1
	retf

start_in1to1:
ENDIF

; Set segment registers to 16-bit segments.
	mov	ax, INIT_DS
	mov	ds, ax
	mov	es, ax
	sub	ax, ax
	mov	fs, ax
	mov	gs, ax
a629 10

	sub	al, al
	out	21h, al			; Enable interrupts

; Set RM GDT.
	sub	eax, eax
	mov	TempGdt.Base, eax
	mov	TempGdt.Limit, ax
;		DB	66h
;	lgdt	fword ptr TempGdt
d631 2
a632 5

		DB	66h
	lidt	fword ptr RmIdt		; Use 48-bit, not 40-bit form.
; Set real mode.

a636 1

a638 2

; Set DS, ES and SS to initial values. FS = GS = 0.
a643 6
	sub	ax, ax
	mov	fs, ax
	mov	gs, ax

	sti

a657 2
	push	ds
	pop	es
d794 1
a794 1
;	O: EAX = number of pages of memory above 1 M.
a814 1
	wbinvd
d836 1
a836 1
	inc	eax
d868 1
a868 1
        and     ecx, NOT (CR0_PE OR CR0_CD)     ; Enable caching
a879 5
	EXTRN	AllocPage: near32
	EXTRN	HeapAllocPage: near32
	EXTRN	MapPage: near32
	EXTRN	PmWriteStr32: near32
	EXTRN	PmHex32ToA: near32
d889 1
a889 20
;	call    PmSetVideoMode
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call    HeapAllocPage
; Test allocated page.
	push	FLAT_DS
	pop	gs
	mov	gs:[eax], cl

; Print address of allocated page.

	push	ds
	pop	es
	mov	edi, offset Field
	call	PmHex32ToA
	mov	dh, 15
	mov	dl, 30
	mov	esi, offset Field
	mov	bl, 0Fh
	call	PmWriteStr32

a893 1

@


0.2
log
@Support for BIOS calls in V86 mode
@
text
@a17 1
	EXTRN	PmSetVideoMode: near
d24 1
d56 2
a57 4
PUBLIC	QuitPm
	QuitPm		DB	0
PUBLIC	Mode0
	Mode0		DB	0
d62 1
a62 2
PUBLIC	InitStkSel
	InitStkSel	DW	?
a169 4
@@@@:
; If Mode0 is non-0 (1), set mode 0 via InvokeV86Int
	cmp	Mode0, 0
	je	mode_set
d171 2
a172 6
	sub	al, al
	call	PmSetVideoMode
	mov	Mode0, 0
mode_set:
	cmp	QuitPm, 0
	je	@@B
d824 2
d827 14
@


0.1
log
@16/05/98	Initial check-in
@
text
@d18 1
d26 7
d35 1
d37 1
d39 5
d47 2
d51 1
d56 1
a56 1
	PUBLIC	QuitPm
d58 2
d64 1
d67 2
d77 1
d84 3
d91 1
a91 1
	DW	1024 DUP (?)
d137 3
d144 15
d174 8
d206 1
d297 6
a325 1
	inc	ErrLvl
d361 1
a361 1
	or	byte ptr es:[0], PAGE_PRESENT OR PAGE_WRITABLE
d373 1
a373 1
	or	byte ptr es:[si], PAGE_PRESENT OR PAGE_WRITABLE
d480 46
a558 4
;
; Meanwhile segment registers are not reloaded, so they retain real-mode
; values.
;
d563 1
a563 1
	mov	ax, InitDataSel
d567 3
d748 84
d835 3
a837 3
Zseg	SEGMENT
	DW	16384 DUP (?)
Zseg	ENDS
@
