head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.22.34;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.17.48.52;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.22.07;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.07.41;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.22.03.04.23;	author BlackPhantom;	state Exp;
branches
	0.4.0.1;
next	0.3;

0.3
date	98.06.05.12.46.26;	author BlackPhantom;	state Exp;
branches;
next	0.2;

0.2
date	98.05.28.02.54.44;	author BlackPhantom;	state Exp;
branches;
next	0.1;

0.1
date	98.05.16.12.46.38;	author BlackPhantom;	state Exp;
branches;
next	;

0.4.0.1
date	98.12.23.01.12.41;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@Source code for exceptions handling
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				EXCEPT.ASM
;				----------
;	Exception and interrupts handling routines and data for Tripple-DOS.
;
;	For MASM v6.1x.
;
;=============================================================================

CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA
.486p
;-----------------------------------------------------------------------------
;
;	Setup IDT (load IDTR).
;
;-----------------------------------------------------------------------------
PUBLIC	SetupIdt
SetupIdt	PROC	near
	sub	eax, eax
	mov	ax, ds
	shl	eax, 4
	add	eax, IDT_START
	mov	Idt.Base, eax
	lidt	fword ptr Idt
	ret
SetupIdt	ENDP


;-----------------------------------------------------------------------------
;
;	Setup traps list. Traps are a queue of exception "trappers" -
; callbacks for the same CPU exceptions that will be called one-by-on (FIFO:
; first registrated - first called.
;	At the beginning all tail pointers are 0s (all FIFOs empty)
;
;-----------------------------------------------------------------------------
PUBLIC	SetupExcTraps
SetupExcTraps	PROC	near	USES es
	mov	eax, EXC_TRAPS
	mov	ExcTrapsListSeg, ax
	mov	es, ax
	shl	eax, 4
	mov	ExcTrapsList, eax

; Clear exception trap list.
	sub	di, di
	sub	eax, eax
	mov	ecx, HANDLED_INTS * MAX_TRAPS / 4
	cld
		rep	stosd

	ret
SetupExcTraps	ENDP


CODE	ENDS

	INCLUDE	EXCEPT.INC
	INCLUDE	X86.INC
	INCLUDE	DEVICES.INC
	INCLUDE	DEF.INC
	INCLUDE	CORE.INC
	INCLUDE	TASKMAN.INC
	INCLUDE	PHLIB32.MCR
	INCLUDE	DPMI.INC

	EXTRN	PointerToLinear: near32
	EXTRN	LinearToPhysical: near32
	EXTRN	SimulateInt: near32
	EXTRN	GetScanCode: near32
	EXTRN	core_start: near32
	EXTRN	NextTask: near32
	EXTRN	FocusToNextTask: near32
	EXTRN	StopTask: near32
	EXTRN	SwitchTask: near32

	EXTRN	DebugCallback: near32
	EXTRN	WriteLog: near32

	EXTRN	TickCount: dword
	EXTRN	TicksReport: dword

	EXTRN	KeyReady: byte
	EXTRN	KeyPressed: byte
	EXTRN	KeyExtCode: byte
	EXTRN	ShiftKeys: byte
	EXTRN	ShiftScanTbl: dword
	EXTRN	ShiftBitCode: byte
	EXTRN	KeyboardQ: byte
	EXTRN	KbdQHead: dword
	EXTRN	KbdQTail: dword
	EXTRN	TempScanCode: byte

	EXTRN	OsStartPage: dword

IFDEF	DEBUG_BUILD
	EXTRN	TraceFlag: byte
	EXTRN	DebugFlag: byte
ENDIF	; DEBUG_BUILD

	EXTRN	CurrentTask: dword
	EXTRN	CurrTaskPtr: dword
	EXTRN	ForegroundTask: dword
	EXTRN	FirstTask: dword
	EXTRN	NumOfTasks: dword
	EXTRN	VirtualIf: dword
	EXTRN	HddSema4Own: dword
	EXTRN	HddSema4: byte
	EXTRN	FddSema4Own: dword
	EXTRN	FddSema4: byte
	EXTRN	Com1: GenDevice
	EXTRN	Com2: GenDevice
	EXTRN	SystemTask: dword

	EXTRN	Start32Esp: dword

	EXTRN	SysPdb: dword
	EXTRN	Pdb: dword
	EXTRN	SysPdbLin: dword
	EXTRN	PdbLin: dword
	EXTRN	SysPagesCtl: dword
	EXTRN	PagesCtl: dword

	EXTRN	PmCallbackCs: word
	EXTRN	PmCallbackSs: word

	EXTRN	DpmiSrvAddr: dword

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
	RetAddr		DD	?
	HaltFlag	DB	0	; non-0 when exception is going to
					; halt.

	PUBVAR	VirtualIp, DD, ?	; VM Interrupts pending.
	PUBVAR	VirtualIsr, DD, ?	; Virtual PIC's ISR register.
	PUBVAR	VirtualImr, DD, ?	; Virtual PIC's IMR register.
	PUBVAR	IrqReported, DD, 0	; Bit mask of what IRQ are reported.
					; 1 means reported.
	PUBVAR	ExcTrapsListSeg, DW, ?	; Segment address for exceptions
					; traps list (array of FIFOs)
	PUBVAR	ExcTrapsList, DD, ?	; Linear address -"-
	PUBVAR	ExcTrapsTail, DD, 0
		DD	HANDLED_INTS - 1 DUP (0)	
				; 32 pointers to FIFOs tails (count of 
				; exception traps)

	TimeStr		DB	"xx:xx:xx", 0
	TimeClr		DB	0
	ExcStr		DB	"Exception:", 0
	AddrStr		DB	"Fault at:", 0
	HaltStr		DB	"The machine will halt", 0
	OpcodeStr	DB	"Opcode caused exception:", 0
	CrStr		DB	"CR0=xxxxxxxx CR2=xxxxxxxx CR3=xxxxxxxx", 0
	LdtStr		DB	"LDTR=xxxx", 0
	GdtStr		DB	"GDTR base=xxxxxxxx limit=xxxx", 0
	GpRegsStr	DB	"EAX=xxxxxxxx EBX=xxxxxxxx ECX=xxxxxxxx "
			DB	"EDX=xxxxxxxx ESI=xxxxxxxx EDI=xxxxxxxx", 0
	SRegsStr	DB	"DS=xxxx ES=xxxx FS=xxxx GS=xxxx", 0
	StkStr		DB	"SS:ESP=xxxx:xxxxxxxx EBP=xxxxxxxx", 0
	TaskFaultStr	DB	"Task # xxxxxxxx caused an exception. "
			DB	"Press any key to terminate it", 0

	InvPageStr	DB	"Linear address is invalid", 0
	DoubleHaltMsg	DB	"Double halt", 0
	DoubleFaultMsg	DB	"Double fault", 0

	ReportExcStr	DB	"Reporting an exception: "
	ReportIrqStr	DB	"Reporting an IRQ: "

	PUBVAR	Cpl0EspAdjust, DD, CPL0_STK_SIZE	; Adjustment for overlapped ints/exc.
	PUBVAR	ExcNumber, DD, ?	; Exception number
	ErrCodePresent	DD	?	; Error code present.

	PUBVAR	ExcCode		,DD,	?
	PUBVAR	ExcOffs		,DD,	?
	PUBVAR	ExcSeg		,DW,	?
				DW	0
	PUBVAR	ExcEflags	,DD,	?
	PUBVAR	ExcEax		,DD,	?
	PUBVAR	ExcEcx		,DD,	?
	PUBVAR	ExcEdx		,DD,	?
	PUBVAR	ExcEbx		,DD,	?
	PUBVAR	ExcEsp		,DD,	?
	PUBVAR	ExcEbp		,DD,	?
	PUBVAR	ExcEsi		,DD,	?
	PUBVAR	ExcEdi		,DD,	?
	PUBVAR	ExcDs		,DD,	?
	PUBVAR	ExcEs		,DD,	?
	PUBVAR	ExcFs		,DD,	?
	PUBVAR	ExcGs		,DD,	?
	PUBVAR	ExcSs		,DD,	?

IFDEF	DEBUG_BUILD
	DbgClientRegs	REG_PACK	<>
	DbgClientSregs	SREG_PACK	<>
ENDIF	; DEBUG_BUILD

	Idt		DTR	< IDT_SIZE, ? >

IDT_START	EQU	$
; Exceptions
	Gate386	< LOWWORD (offset DivisionBy0), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset DebugExc), CODE_32, 0, INT_386_ACCESS or 60h, 0 >
	Gate386	< LOWWORD (offset Nmi), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Int3Exc), CODE_32, 0, INT_386_ACCESS or 60h, 0 >
	Gate386	< LOWWORD (offset Overflow), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset BoundExc), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset InvOpcode), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset X87NotAvl), CODE_32, 0, INT_386_ACCESS , 0 >

PUBLIC	DoubleFaultEntry
DoubleFaultEntry	LABEL	Gate386
	Gate386	< 0, 0, 0, TASK_GATE_ACCESS , 0 >
;	Gate386	< LOWWORD (offset DoubleFault), CODE_32, 0, TASK_GATE_ACCESS , 0 >

	Gate386	< LOWWORD (offset Exception09), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset InvTSS), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset SegNotPresent), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset StackFault), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset GPExc), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset PageFault), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception0F), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset FPError), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset AlignCheckExc), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception12), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception13), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception14), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception15), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception16), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception17), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception18), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception19), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1A), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1B), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1C), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1D), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1E), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Exception1F), CODE_32, 0, INT_386_ACCESS , 0 >
; Hardware interrupts -- 20h - 27h ( IRQ 0 - 7 )
	Gate386	< LOWWORD (offset TimerInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset KbdInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq2Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq3Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq4Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq5Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq6Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq7Int), CODE_32, 0, INT_386_ACCESS , 0 >
; Hardware interrupts -- 28h - 2Fh ( IRQ 8 - F )
	Gate386	< LOWWORD (offset Irq8Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset Irq9Int), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqAInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqBInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqCInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqDInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqEInt), CODE_32, 0, INT_386_ACCESS , 0 >
	Gate386	< LOWWORD (offset IrqFInt), CODE_32, 0, INT_386_ACCESS , 0 >
IDT_SIZE	EQU	$ - IDT_START

DATA	ENDS


EXC_TRAPS	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	DB	HANDLED_INTS * MAX_TRAPS * 4 DUP (?)
EXC_TRAPS	ENDS


CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT


;-----------------------------------------------------------------------------
;
;	Adds an exception trap to a list.
;
;	I: EAX = exception number.
;	   ECX = offset (segment is CODE32)
;	O: CF = 0 ok
;	      = 1 FIFO is full (can't add)
;
;-----------------------------------------------------------------------------
PUBLIC	AddExcTrap
AddExcTrap	PROC	USES edx
	cmp	eax, HANDLED_INTS
	jb	chk_traps
	stc
	ret

chk_traps:
	cmp	ExcTrapsTail[eax * 4], MAX_TRAPS
	jb	add_trap
	stc
	ret

add_trap:
	mov	edx, eax
	shl	edx, 5
	add	edx, ExcTrapsTail[eax * 4]
	shl	edx, 2
	add	edx, ExcTrapsList
	mov	fs:[edx], ecx

	inc	ExcTrapsTail[eax * 4]

	clc
	ret
AddExcTrap	ENDP


;-----------------------------------------------------------------------------
;
;	Dumps all exception registers contents.
;
;-----------------------------------------------------------------------------
PUBLIC	DumpRegs
DumpRegs	PROC
	pop	RetAddr		; Get return address.

; Output exception string.
	PM_PRINT_STR	(offset ExcStr), 2, 5, 13h

; Print exception number.
	PM_PRINT_HEX32	ExcNumber, (3 + SIZEOF ExcStr)

; Print exception error code.
	cmp	ErrCodePresent, 0
	jz	code_printed

	PM_PRINT_HEX32	ExcCode, (16 + SIZEOF ExcStr)

code_printed:
; Print address message.
	PM_PRINT_STR	(offset AddrStr), 2, 6

; Print address of the fault instruction.
	mov	edi, offset Field
	mov	ax, ExcSeg
	call	PmHex16ToA
	add	edi, 4

	mov	byte ptr [edi], ':'
	inc	edi
	mov	eax, ExcOffs
	call	PmHex32ToA

	PM_PRINT_STR	(offset Field), (2 + SIZEOF AddrStr)

; Print Eflags.
	PM_PRINT_HEX32	ExcEflags, (17 + SIZEOF ExcStr)

; Print virtual IF.
	PM_PRINT_HEX32	VirtualIf, (32 + SIZEOF ExcStr)

IFDEF	DUMP_STACK
; Dump 10 words from stack.
	mov	ecx, 8
	mov	dh, 8
	mov	dl, 2

stack_dump_loop:
	pop	eax
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	call	PmWriteStr32
	add	dl, 9
	dec	ecx
	jnz	stack_dump_loop
ENDIF	; DUMP_STACK

; Dump control registers.
	PM_PRINT_STR	(offset CrStr), 2, 9

; Print CR0.
	PM_PRINT_HEX32	cr0, 6
; Print CR2.
	PM_PRINT_HEX32	cr2, 19
; Print CR3.
	PM_PRINT_HEX32	cr3, 32

; Dump LDT.
	PM_PRINT_STR	(offset LdtStr), 2, 10
	sldt	ax
	PM_PRINT_HEX16	, 7
; Dump GDT.
	PM_PRINT_STR	(offset GdtStr), 20
	sub	esp, 8
	sgdt	[esp]
	mov	eax, [esp][2]
	PM_PRINT_HEX32	, 30
	mov	ax, [esp]
	PM_PRINT_HEX16	, 45
	add	esp, 8

; Dump general purpose registers.
	PM_PRINT_STR	(offset GpRegsStr), 2, 11

; Print EAX.
	PM_PRINT_HEX32	ExcEax, 6
; Print EBX.
	PM_PRINT_HEX32	ExcEbx, 19
; Print ECX.
	PM_PRINT_HEX32	ExcEcx, 32
; Print EDX.
	PM_PRINT_HEX32	ExcEdx, 45
; Print ESI.
	PM_PRINT_HEX32	ExcEsi, 58
; Print EDI.
	PM_PRINT_HEX32	ExcEdi, 71

; Dump segment registers.
	PM_PRINT_STR	(offset SRegsStr), 2, 12
; Print DS.
	PM_PRINT_HEX16	(word ptr ExcDs), 5
; Print ES.
	PM_PRINT_HEX16	(word ptr ExcEs), 13
; Print FS.
	PM_PRINT_HEX16	(word ptr ExcFs), 21
; Print GS.
	PM_PRINT_HEX16	(word ptr ExcGs), 29

; Dump stack (SS:ESP, EBP)
	PM_PRINT_STR	(offset StkStr), 2, 13
; Print GS.
	PM_PRINT_HEX16	(word ptr ExcSs), 9
; Print ESP.
	PM_PRINT_HEX32	ExcEsp, 14
; Print EBP.
	PM_PRINT_HEX32	ExcEbp, 27
	
; Dump faulting opcode (16 bytes)
	inc	dh
	mov	dl, 2
	mov	esi, offset OpcodeStr
	call	PmWriteStr32
	inc	dh
	mov	cx, FLAT_DS
	mov	fs, cx
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	bl, 13h
	mov	ebp, eax		; fs: EBP+ECX point to fault. opcode
	sub	ecx, ecx

; Check if linear address of opcode is valid.
	mov	eax, ebp
	call	LinearToPhysical
	jnc	dump_opcode
	PM_PRINT_STR	(offset InvPageStr)
	jmp	end_dump_regs

dump_opcode:
	push	ecx
	mov	edi, offset Field
	mov	eax, fs:[ebp+ecx]
	call	PmHexToA
	mov	esi, offset Field
	call	PmWriteStr32
	add	dl, 3
	pop	ecx

	inc	ecx
	cmp	ecx, 16			; Dump 16 bytes.
	jb	dump_opcode

end_dump_regs:
	jmp	RetAddr
DumpRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Calls exception or interrupt callbacks.
;
;	I:  EAX = exception number
;	O:  CF set/clear (clear = processed).
;
;-----------------------------------------------------------------------------
CallCallbacks	PROC	USES eax ecx edx
	cmp	ExcTrapsTail[eax*4], 0	; If no callbacks, STC and RET
	je	not_handled

call_callbacks:
	sub	ecx, ecx
	mov	edx, eax
	shl	edx, 5 + 2
	add	edx, ExcTrapsList

next_callback:
	cmp	ecx, ExcTrapsTail[eax*4]
	jnb	not_handled

	push	es
	pushad
	call	dword ptr fs:[edx][ecx*4]	; Callback prepares all registers
					; for returning to caller or returns
					; CF = 1
	popad
	pop	es
	jnc	handled

	inc	ecx
	jmp	next_callback

not_handled:
	stc
handled:
	ret
CallCallbacks	ENDP


;-----------------------------------------------------------------------------
;
;	Contains all exceptions handlers entry points.
;
;	Convention: entry point sets AX = exception number and ECX to number
;	of bytes of error code on stack.
;
;-----------------------------------------------------------------------------
ExcHandler	PROC
DivisionBy0::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 0
	jmp	HandleExc

DebugExc::

IFDEF	DEBUG_BUILD
	test	(INT386_STACK PTR [esp]). dwEflags, FL_VM
	jnz	@@F
	test	(INT386_STACK PTR [esp]). wCs, 3
	jnz	@@F

	call	SaveDbgClientRegs
@@@@:
ENDIF	; DEBUG_BUILD

	push	0
	call	GetClientRegs
	mov	ExcNumber, 1
	jmp	HandleExc

Nmi::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 2
	jmp	HandleExc

Int3Exc::

IFDEF	DEBUG_BUILD
	test	(INT386_STACK PTR [esp]). dwEflags, FL_VM
	jnz	@@F
	test	(INT386_STACK PTR [esp]). wCs, 3
	jnz	@@F

	call	SaveDbgClientRegs
@@@@:
ENDIF	; DEBUG_BUILD

	push	0
	call	GetClientRegs
	mov	ExcNumber, 3
	jmp	HandleExc

Overflow::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 4
	jmp	HandleExc

BoundExc::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 5
	jmp	HandleExc

InvOpcode::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 6
	jmp	HandleExc

X87NotAvl::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 7
	jmp	HandleExc

PUBLIC	DoubleFault
DoubleFault::
nop
nop
nop
nop
nop

	PM_PRINT_MSG (offset DoubleFaultMsg)
	cli
	hlt

	push	4
	call	GetClientRegs
	mov	ExcNumber, 8
	jmp	HandleExc

Exception09::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 9
	jmp	HandleExc

InvTSS::
	push	4
	call	GetClientRegs
	mov	ExcNumber, 0Ah
	jmp	HandleExc

SegNotPresent::
	push	4
	call	GetClientRegs
	mov	ExcNumber, 0Bh
	jmp	HandleExc

StackFault::
	push	4
	call	GetClientRegs
	mov	ExcNumber, 0Ch
	jmp	HandleExc

;-----------------------------------------------------------------------------
;
;	GP exception. Used for emulation.
;
;-----------------------------------------------------------------------------
GPExc::
	push	4
	call	GetClientRegs
	mov	ExcNumber, 0Dh
	jmp	HandleExc

PageFault::
	push	4
	call	GetClientRegs
	mov	ExcNumber, 0Eh
	jmp	HandleExc

Exception0F::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 0Fh
	jmp	HandleExc

FPError::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 10h
	jmp	HandleExc

AlignCheckExc::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 11h
	jmp	HandleExc

Exception12::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 12h
	jmp	HandleExc

Exception13::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 13h
	jmp	HandleExc

Exception14::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 14h
	jmp	HandleExc

Exception15::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 15h
	jmp	HandleExc

Exception16::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 16h
	jmp	HandleExc

Exception17::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 17h
	jmp	HandleExc

Exception18::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 18h
	jmp	HandleExc

Exception19::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 19h
	jmp	HandleExc

Exception1A::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Ah
	jmp	HandleExc

Exception1B::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Bh
	jmp	HandleExc

Exception1C::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Ch
	jmp	HandleExc

Exception1D::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Dh
	jmp	HandleExc

Exception1E::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Eh
	jmp	HandleExc

Exception1F::
	push	0
	call	GetClientRegs
	mov	ExcNumber, 1Fh
	jmp	HandleExc

;
; HandleExc CPU upon the exception
;
HandleExc:

;IFDEF	LOG_DPMI
IF 0
	pushad

	cmp	NumOfTasks, 0
	je	@@F

	cmp	SystemTask, 1
	je	@@F

	mov	eax, CurrTaskPtr
	cmp	(DosTask PTR fs:[eax]).TaskLdt, 0
	je	@@F

; Log exception event.
	mov	esi, offset ExcStr
	mov	ecx, SIZEOF ExcStr
	call	WriteLog

	mov	eax, ExcNumber
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcCode
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	esi, offset AddrStr
	mov	ecx, SIZEOF AddrStr
	call	WriteLog

	mov	ax, ExcSeg
	mov	edi, offset Field
	call	PmHex16ToA
	mov	Field[4], ':'
	mov	eax, offset Field
	mov	ecx, 5
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcOffs
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEflags
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog
@@@@:
	popad
ENDIF	; LOG_DPMI

	mov	eax, ExcNumber
	call	CallCallbacks
	jnc	SetClientRegs		; Exception handled

; Exception is not handled by system. Call DPMI handlers. Call only for
; PM CPL 3 exceptions.
	test	ExcEflags, FL_VM
	jz	pm_exc

; An exception occurred in VM. For exceptions 0, 1, 3, 4 call an interrupt.
	mov	eax, ExcNumber
	test	eax, eax
	je	call_vm_int
	cmp	eax, 1
	je	call_vm_int
	cmp	eax, 3
	je	call_vm_int
	cmp	eax, 4
	jne	unhandled_dump

call_vm_int:
IFNDEF	DEBUG_BUILD
	call	SimulateInt
	jmp	SetClientRegs
ENDIF

pm_exc:
	test	ExcSeg, 3
	jz	dump_and_halt
; If DPMI not initialized, go to unhandled dump.
	mov	eax, CurrTaskPtr
	cmp	(DosTask PTR fs:[eax]).TaskLdt, 0
	je	unhandled_dump

; If exception handler was installed, jump to it.
	mov	ebx, (DosTask PTR fs:[eax]).DpmiPmExcs
	mov	ecx, ExcNumber
	cmp	dword ptr fs:[ebx+ecx*8][4], 0
	jne	redir_exc

; Exceptions 0..5 and 7 are redirected as interrupts.
	mov	ecx, ExcNumber
redir_as_int:
	mov	ebx, (DosTask PTR fs:[eax]).DpmiPmInts
	cmp	ecx, 7
	ja	unhandled_dump
	cmp	ecx, 6
	je	unhandled_dump
	cmp	dword ptr fs:[ebx+ecx*8][4], 0
	je	unhandled_dump		; Interrupt handler not installed.

	mov	eax, ecx
EXTRN	SimulatePmInt: near32
	call	SimulatePmInt
	jmp	SetClientRegs

redir_exc:

IFDEF	LOG_DPMI
	pushad
	mov	eax, ecx
	PRINT_LOG	ReportExcStr

	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcCode
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
	LOG_STATE
ENDIF

; Push exception stack frame on locked DPMI stack.
	test	(DosTask PTR fs:[eax]).TaskFlags, TASK_32BIT
	jz	task_16bit

; 32-bit task.
; Push far return address.
	mov	edx, (DosTask PTR fs:[eax]).DpmiPmStack
	sub	edx, 20h
	mov	dword ptr fs:[edx],  PM_RET_TRAP_OFFS
	mov	si, PmCallbackCs
	mov	fs:[edx][4],  si

; Push error code.
	mov	esi, ExcCode
	mov	fs:[edx][8], esi

; Push excetion location, flags and SS:ESP.
	mov	esi, ExcOffs
	mov	fs:[edx][0Ch], esi
	mov	si, ExcSeg
	mov	fs:[edx][10h], si

	mov	esi, ExcEflags
	and	esi, NOT FL_IF
	or	esi, VirtualIf
	mov	fs:[edx][14h], esi

	mov	esi, ExcEsp
	mov	fs:[edx][18h], esi
	mov	esi, ExcSs
	mov	fs:[edx][1Ch], si

	mov	edx, (DosTask PTR fs:[eax]).DpmiPmEsp
	sub	edx, 20

	jmp	set_callback_addr

; 16-bit task. Adjust PM locked stack.
task_16bit:
; Push far return address.
	mov	edx, (DosTask PTR fs:[eax]).DpmiPmStack
	sub	edx, 10h
	mov	word ptr fs:[edx],  PM_RET_TRAP_OFFS
	mov	si, PmCallbackCs
	mov	fs:[edx][2],  si

; Push error code.
	mov	esi, ExcCode
	mov	fs:[edx][4], si
; Push exception location, flags and SS:ESP.
	mov	esi, ExcOffs
	mov	fs:[edx][6], si
	mov	si, ExcSeg
	mov	fs:[edx][8], si

	mov	esi, ExcEflags
	and	esi, NOT FL_IF
	or	esi, VirtualIf
	mov	fs:[edx][0Ah], si

	mov	esi, ExcEsp
	mov	fs:[edx][0Ch], si
	mov	esi, ExcSs
	mov	fs:[edx][0Eh], si

	mov	edx, (DosTask PTR fs:[eax]).DpmiPmEsp
	sub	edx, 10

set_callback_addr:
; Set callback address.
	mov	esi, fs:[ebx+ecx*8]
	mov	ExcOffs, esi
	mov	esi, fs:[ebx+ecx*8][4]
	mov	ExcSeg, si
	and	VirtualIf, NOT FL_IF		; Interrupts disabled.

; Set new SS:ESP.
	mov	si, PmCallbackSs
	mov	word ptr ExcSs, si
	mov	ExcEsp, edx

LOG_STATE	1

	jmp	SetClientRegs

PUBLIC	handled_exc
handled_exc::
; Restore return address and stack.
	mov	eax, CurrTaskPtr
	test	(DosTask PTR fs:[eax]).TaskFlags, TASK_32BIT
	jz	@@F

; Restore 32-bit task.
	RESTORE_32BIT_EXC_STACK
	jmp	SetClientRegs

; Restore 16-bit task.
@@@@:
	RESTORE_16BIT_EXC_STACK
	jmp	SetClientRegs

PUBLIC	unhandled_exc
unhandled_exc::

; Get exception number from DPMI trap.
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	movzx	esi, byte ptr fs:[eax][6]
int 3
	mov	ExcNumber, esi

;
;	Restore original exception parameters from locked stack.
; Assumed that a program jumped to default exception handler (i.e. program
; termination) without changing locked stack. Otherwise diagnostic won't
; be good.
;
	mov	eax, CurrTaskPtr
	test	(DosTask PTR fs:[eax]).TaskFlags, TASK_32BIT
	jnz	@@F

; 16 bit locked stack.
	RESTORE_16BIT_EXC_STACK
	mov	ecx, ExcNumber
	jmp	redir_as_int
@@@@:
	RESTORE_32BIT_EXC_STACK
	mov	ecx, ExcNumber
	jmp	redir_as_int

unhandled_dump:
IFDEF	DEBUG_BUILD
	call	DebugCallback		; DEBUG.
ENDIF	; DEBUG_BUILD

;	call	DumpRegs

	cmp	NumOfTasks, 0
	je	dump_and_halt

; Task caused an exception. Press any key and terminate it.
	PM_PRINT_MSG	(offset TaskFaultStr)
	PM_PRINT_HEX32	CurrentTask, 7, REPORT_ROW, REPORT_ATTR

IFDEF	DEBUG_BUILD
	mov	DebugFlag, 1
ENDIF	; DEBUG_BUILD

	call	GetScanCode		; Wait for key pressed.

IFDEF	DEBUG_BUILD
	mov	DebugFlag, 0
ENDIF	; DEBUG_BUILD

	sub	al, al			; Enable all interrupts but kbd.
	out	PIC_MASTER_MASK, al
	out	PIC_SLAVE_MASK, al

	mov	eax, CurrentTask
	call	StopTask
	cmp	NumOfTasks, 0
	je	@@F
	jmp	SetClientRegs

@@@@:
; Jump to system task.
	mov	esp, Start32Esp
	jmp	core_start

dump_and_halt:
IFDEF	DEBUG_BUILD
	call	DebugCallback		; DEBUG.
ENDIF	; DEBUG_BUILD

	cmp	HaltFlag, 0
	je	dump_on
	PM_PRINT_MSG	(offset DoubleHaltMsg)
	cli
	hlt

dump_on:
	mov	HaltFlag, 1
	call	DumpRegs

; Print halt message.
	PM_PRINT_STR	(offset HaltStr), 2, 7

; Halt CPU.
	cli
	hlt

ExcHandler	ENDP


;-----------------------------------------------------------------------------
;
;	Saves debuggee's client registers.
;
;	Called from inconsistent context.
;
;-----------------------------------------------------------------------------
SaveDbgClientRegs	PROC	USES ds es eax ebx ecx
IFDEF	DEBUG_BUILD
; Set DS -> data segment.
	push	INIT_DS
	pop	ds

; Set ES -> data segment
	push	INIT_DS
	pop	es

; Save debuggee's client regs.
	mov	ebx, offset DbgClientRegs
	mov	ecx, offset DbgClientSregs
	call	SaveClientRegs

	ret
ENDIF	;DEBUG_BUILD
SaveDbgClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Saves debuggee's client registers.
;
;	Called from inconsistent context.
;
;-----------------------------------------------------------------------------
RestoreDbgClientRegs	PROC	USES ds es eax ebx ecx

IFDEF	DEBUG_BUILD
; Set DS -> data segment.
	push	INIT_DS
	pop	ds

; Set ES -> data segment
	push	INIT_DS
	pop	es

; Save debuggee's client regs.
	mov	ebx, offset DbgClientRegs
	mov	ecx, offset DbgClientSregs
	call	RestoreClientRegs

	ret
ENDIF	;DEBUG_BUILD

RestoreDbgClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Saves client registers in REG_PACK and SREG_PACK structure.
;
;	I:	ES:EBX -> REG_PACK
;		ES:ECX -> SREG_PACK
;
;-----------------------------------------------------------------------------
PUBLIC	SaveClientRegs
SaveClientRegs	PROC
PUSHCONTEXT	ASSUMES
ASSUME	ebx: PTR REG_PACK
ASSUME	ecx: PTR SREG_PACK

; Save general purpose registers, EIP and Eflags.
	mov	eax, ExcOffs
	mov	es:[ebx].dwEip, eax
	mov	eax, ExcEflags
	mov	es:[ebx].dwEflags, eax
	mov	eax, ExcEax
	mov	es:[ebx].dwEax, eax
	mov	eax, ExcEbx
	mov	es:[ebx].dwEbx, eax
	mov	eax, ExcEcx
	mov	es:[ebx].dwEcx, eax
	mov	eax, ExcEdx
	mov	es:[ebx].dwEdx, eax
	mov	eax, ExcEsi
	mov	es:[ebx].dwEsi, eax
	mov	eax, ExcEdi
	mov	es:[ebx].dwEdi, eax
	mov	eax, ExcEsp
	mov	es:[ebx].dwEsp, eax
	mov	eax, ExcEbp
	mov	es:[ebx].dwEbp, eax

; Save segment regsters.
	movzx	eax, ExcSeg
	mov	es:[ecx].wCs, ax
	mov	eax, ExcDs
	mov	es:[ecx].wDs, ax
	mov	eax, ExcEs
	mov	es:[ecx].wEs, ax
	mov	eax, ExcFs
	mov	es:[ecx].wFs, ax
	mov	eax, ExcGs
	mov	es:[ecx].wGs, ax
	mov	eax, ExcSs
	mov	es:[ecx].wSs, ax

	ret
POPCONTEXT	ASSUMES
SaveClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Restore client registers from REG_PACK and SREG_PACK structure.
;
;	I:	ES:EBX -> REG_PACK
;		ES:ECX -> SREG_PACK
;
;-----------------------------------------------------------------------------
PUBLIC	RestoreClientRegs
RestoreClientRegs	PROC
PUSHCONTEXT	ASSUMES
ASSUME	ebx: PTR REG_PACK
ASSUME	ecx: PTR SREG_PACK

; Restore general purpose registers, EIP and Eflags.
	mov	eax, es:[ebx].dwEip
	mov	ExcOffs, eax
	mov	eax, es:[ebx].dwEflags
	mov	ExcEflags, eax
	mov	eax, es:[ebx].dwEax
	mov	ExcEax, eax
	mov	eax, es:[ebx].dwEbx
	mov	ExcEbx, eax
	mov	eax, es:[ebx].dwEcx
	mov	ExcEcx, eax
	mov	eax, es:[ebx].dwEdx
	mov	ExcEdx, eax
	mov	eax, es:[ebx].dwEsi
	mov	ExcEsi, eax
	mov	eax, es:[ebx].dwEdi
	mov	ExcEdi, eax
	mov	eax, es:[ebx].dwEsp
	mov	ExcEsp, eax
	mov	eax, es:[ebx].dwEbp
	mov	ExcEbp, eax

; Restore segment regsters.
	movzx	eax, es:[ecx].wCs
	mov	ExcSeg, ax
	movzx	eax, es:[ecx].wDs
	mov	ExcDs, eax
	movzx	eax, es:[ecx].wEs
	mov	ExcEs, eax
	movzx	eax, es:[ecx].wFs
	mov	ExcFs, eax
	movzx	eax, es:[ecx].wGs
	mov	ExcGs, eax
	movzx	eax, es:[ecx].wSs
	mov	ExcSs, eax

	ret
POPCONTEXT	ASSUMES
RestoreClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Gets client's registers.
;
;	I:	ESP+4 - error code flag.
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	GetClientRegs
GetClientRegs	PROC

; Recover possible DS corruption.
	push	ds
	push	INIT_DS
	pop	ds
	pop	ExcDs			; Will be further altered if fault CS
					; PL > 0.

	pop	RetAddr			; Get return address from stack.

	cmp	dword ptr [esp], 0	; Error code present?
	pop	ErrCodePresent		; Get error code indicator from stack.
	je	save_regs
	pop	ExcCode			; Get error code.

save_regs:
; Save CPU regs as were at the exception time.
	mov	ExcEax, eax
	mov	ExcEbx, ebx
	mov	ExcEcx, ecx
	mov	ExcEdx, edx
	mov	ExcEbp, ebp
	mov	ExcEsi, esi
	mov	ExcEdi, edi

get_exc_offs:
; Pop Eflags and return address.
	pop	ExcOffs
	pop	esi
	mov	ExcSeg, si
	pop	ExcEflags

; Recover segment registers.
	test	ExcEflags, FL_VM
	jz	get_pmode_sregs

	pop	ExcEsp
	pop	ExcSs
	pop	ExcEs
	pop	ExcDs
	pop	ExcFs
	pop	ExcGs
	jmp	done

get_pmode_sregs:
	mov	ExcEs, es
	mov	ExcFs, fs
	mov	ExcGs, gs
	test	ExcSeg, 3	; Check if faulting CS was at PL > 0
	jnz	pop_stk_regs

	mov	ExcEsp, esp	; No stack switch.
	mov	ExcSs, ss

;	mov	esp, EXC_STK
	jmp	done

pop_stk_regs:
	pop	ExcEsp
	pop	ExcSs

done:
; Adjust ESP.
;	sub	esp, Cpl0EspAdjust
;	add	Cpl0EspAdjust, CPL0_STK_SIZE

; Set segment registers context.
	mov	ecx, INIT_DS
	mov	es, cx
	mov	ecx, FLAT_DS
	mov	fs, cx
	mov	gs, cx

	jmp	RetAddr		; Return to gotten return address.
GetClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Report highest privilege pending IRQ to client.
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
ReportIrq	PROC
; If no interrupts are pending, return
	cmp	VirtualIp, 0
	jne	@@F
	ret

@@@@:
; If interrupted address is at DPMI service page, return
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	ecx, eax
	and	ecx, NOT 0FFFh
;	cmp	ecx, DPMI_SERVICE_PAGE
	cmp	ecx, DpmiSrvAddr
	jne	@@F

;int 3
;	mov	byte ptr fs:[eax][6], 3
;extrn	DpmiCallbackRet: near32
;	call	DpmiCallbackRet
;	test	ExcEflags, FL_VM
;	jz	ret000
;ret000:
	ret

@@@@:
; Isolate IRQ that's going to be serviced in EAX.
	mov	eax, VirtualIp
	lea	edx, [eax-1]
	and	edx, eax
	xor	eax, edx

; If the requested interrupt is masked, don't report.
	test	eax, VirtualImr
	jz	@@F
   	ret
@@@@:

; Check if IRQ of the same or more privilege is being serviced.
	mov	ecx, VirtualIsr
	lea	edx, [ecx-1]
	and	edx, ecx
	xor	ecx, edx

	test	ecx, ecx
	jz	@@F

IF 0
; If the set bit in in-service register is of a lower lever, exit
	cmp	ecx, eax
	jnb	@@F
	mov	ebx, VirtualIp
	mov	edx, VirtualIsr
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebp, VirtualImr
int 3
	ret
ENDIF

@@@@:
; If it's not IRQ 2, service it. Else, service cascaded IRQ.
	cmp	eax, 4
	jne	sim_master_irq

; Service cascaded instead. Isolate the requested bit.
	mov	eax, VirtualIp
	shr	eax, 8
	lea	edx, [eax-1]
	and	edx, eax
	xor	eax, edx

; If the requested interrupt is masked, don't report.
	mov	edx, VirtualImr
	shr	edx, 8
	test	eax, edx
	jz	@@F
   	ret
@@@@:
; If the ISR bit > 2, don't check anything - go to repoting.
	test	ecx, 4
	jz	@@F

	mov	ecx, VirtualIsr
	shr	ecx, 8
	lea	edx, [ecx-1]
	and	edx, ecx
	xor	ecx, edx

; If no bit was set, go to reporting.
	test	ecx, ecx
	jz	@@F

; Service only if a lesser bit than in in-service register.
	cmp	ecx, eax
	ja	@@F
	ret

@@@@:
; If it was last cascaded IRQ, clear IRQ 2 pending.
	test	edx, edx
	jnz	sim_cascaded_irq
	and	VirtualIp, NOT 4
; Set is-service bit for IRQ #2.
	or	VirtualIsr, 4

sim_cascaded_irq:
; Clear pending IRQ and set is-service bit.
	mov	edx, eax
	shl	eax, 8
	or	VirtualIsr, eax
	not	eax
	and	VirtualIp, eax

; Simulate interrupt.
	mov	eax, 70h
@@@@:
	shr	edx, 1
	jc	@@F
	inc	eax
	jmp	@@B

@@@@:
	call	SimulateInt
	ret
	
sim_master_irq:
; If no bit was set, go to reporting.
	test	ecx, ecx
	jz	@@F

; Service only if a lesser bit than in in-service register.
	cmp	ecx, eax
	ja	@@F
	ret
@@@@:
	mov	edx, eax
; Clear pending IRQ and set in-service bit.
	or	VirtualIsr, eax
	not	eax
	and	VirtualIp, eax

; Simulate interrupt.
	mov	eax, 8
@@@@:
	shr	edx, 1
	jc	@@F
	inc	eax
	jmp	@@B
@@@@:
	call	SimulateInt
	ret
ReportIrq	ENDP


;-----------------------------------------------------------------------------
;
;	Sets client regs and returns to the client (caller)
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	SetClientRegs
SetClientRegs	PROC

IFDEF	DEBUG_BUILD
; If TraceFlag, set TF = 1.
	movzx	eax, TraceFlag
	shl	eax, 8
	and	ExcEflags, NOT FL_TF
	or	ExcEflags, eax
ENDIF	; DEBUG_BUILD

;IFDEF	LOG_DPMI
IF	0
	pushad

	cmp	NumOfTasks, 0
	je	@@F

	cmp	SystemTask, 1
	je	@@F

	mov	eax, CurrTaskPtr
	cmp	(DosTask PTR fs:[eax]).TaskLdt, 0
	je	@@F

	mov	ax, ExcSeg
	mov	edi, offset Field
	call	PmHex16ToA
	mov	Field[4], ' '
	mov	eax, offset Field
	mov	ecx, 5
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcOffs
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], ' '
	mov	eax, offset Field
	mov	ecx, 9
	mov	esi, offset Field
	call	WriteLog

	mov	eax, ExcEflags
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog
@@@@:
	popad
ENDIF	; LOG_DPMI

; Report IRQs only for ring 3 or VM code.
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	restore_pm_regs
@@@@:
; Service VM pending interrupts if possible.
	cmp	VirtualIf, 0
	jz	@@F

	call	ReportIrq
@@@@:
; Clear NT flag.
	and	ExcEflags, NOT FL_NT

; Set return frame according to target mode.
	test	ExcEflags, FL_VM
	jz	restore_pm_regs

restore_vm_regs:

IFDEF	MONITOR_LOCKED_STACK
EXTRN	LogX: byte, LogY: byte, LogClr: byte
pushad
	cmp	SystemTask, 0
	jne	@@F
	mov	edx, CurrTaskPtr
	cmp	(DosTask PTR fs:[edx]).TaskLdt, 0
	je	@@F
	mov	eax, (DosTask PTR fs:[edx]).DpmiRmStack
	PM_PRINT_HEX32	, LogX, LogY, LogClr
	add	LogX, 9
	cmp	LogX, 80
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
ENDIF

IFDEF	TASK_MON
	cmp	SystemTask, 0
	jne	@@F

	pushad
	mov	eax, 0
	TASK_PTR	, ecx
	PM_PRINT_HEX	(DosTask PTR fs:[ecx]).TaskState, 30, 23, 13
	PM_PRINT_HEX	(DosTask PTR fs:[ecx]).TaskBlock, 40, 23, 14
	mov	eax, 1
	TASK_PTR	, ecx
	PM_PRINT_HEX	(DosTask PTR fs:[ecx]).TaskState, 50, 23, 11
	PM_PRINT_HEX	(DosTask PTR fs:[ecx]).TaskBlock, 60, 23, 12
	PM_PRINT_HEX32	CurrentTask, 70, 23, 10
	popad

@@@@:
ENDIF

; Restore general purpose registers.
	mov	eax, ExcEax
	mov	ebx, ExcEbx
	mov	ecx, ExcEcx
	mov	edx, ExcEdx
	mov	esi, ExcEsi
	mov	edi, ExcEdi
	mov	ebp, ExcEbp

	push	ExcGs
	push	ExcFs
	push	ExcDs
	push	ExcEs
	push	ExcSs
	push	ExcEsp
	push	ExcEflags
	push	dword ptr ExcSeg
	push	ExcOffs

; Adjust CPL0 ESP back.
;	sub	Cpl0EspAdjust, CPL0_STK_SIZE
	iretd

; Restore general purpose registers.
restore_pm_regs:

IFDEF	MONITOR_LOCKED_STACK
EXTRN	LogX: byte, LogY: byte, LogClr: byte
pushad
	test	ExcSeg, 3
	jz	@@F
	mov	edx, CurrTaskPtr
	mov	bl, LogClr
	or	bl, 70h
	mov	eax, (DosTask PTR fs:[edx]).DpmiPmStack
	PM_PRINT_HEX32	, LogX, LogY
	add	LogX, 9
	cmp	LogX, 80
	jb	@@F
	mov	LogX, 0
	inc	LogY
	cmp	LogY, 25
	jb	@@F
	mov	LogY, 0
	inc	LogClr
	cmp	LogClr, 16
	jb	@@F
	mov	LogClr, 1
@@@@:
popad
ENDIF

	mov	eax, ExcEax
	mov	ebx, ExcEbx
	mov	ecx, ExcEcx
	mov	edx, ExcEdx
	mov	esi, ExcEsi
	mov	edi, ExcEdi
	mov	ebp, ExcEbp

	test	ExcSeg, 3
	jz	ring0_caller

	mov	es, ExcEs
	mov	fs, ExcFs
	mov	gs, ExcGs

; Adjust CPL0 ESP back.
;	sub	Cpl0EspAdjust, CPL0_STK_SIZE

	push	ExcSs
	push	ExcEsp
	push	ExcEflags
	push	dword ptr ExcSeg
	push	ExcOffs
	mov	ds, ExcDs
	iretd

ring0_caller:

; Adjust CPL0 ESP back.
;	sub	Cpl0EspAdjust, CPL0_STK_SIZE

if 1
cmp	ExcSeg, CODE_32
je	@@F

mov	ax, ExcSeg
mov	ebx, ExcOffs
mov	ecx, ExcEflags
mov	edx, ExcSs
mov	esi, ExcEsp
mov	edi, ExcNumber
mov	NumOfTasks, 0
int 13h
@@@@:
endif
	mov	ss, ExcSs
	mov	esp, ExcEsp
	push	ExcEflags
	push	dword ptr ExcSeg
	push	ExcOffs

IFDEF	DEBUG_BUILD
	push	ExcDs

	cmp	ExcNumber, 1
	je	@@F
	cmp	ExcNumber, 3
	jne	pop_ds
@@@@:
	call	RestoreDbgClientRegs
pop_ds:
	pop	ds
ELSE
	mov	ds, ExcDs
ENDIF	; DEBUG_BUILD

	mov	es, ExcEs
	mov	fs, ExcFs
	mov	gs, ExcGs

	iretd

SetClientRegs	ENDP


;-----------------------------------------------------------------------------
;
;	Timer interrupt handler (IRQ 0).
;
;-----------------------------------------------------------------------------
TimerInt	PROC
	push	0			; no error code
	call	GetClientRegs

IFDEF	PRINT_TIME
;
; Print current time.
;
	push	ds
	pop	es
; Get CMOS hours.
	mov	al, Cmos_RTC_HOURS
	out	CMOS_ADDR, al
	in	al, CMOS_DATA
	mov	edi, offset TimeStr
	call	PmHexToA
	mov	byte ptr es:[di+2], ':'
; Get CMOS hours minutes.
	mov	al, Cmos_RTC_MIN
	out	CMOS_ADDR, al
	in	al, CMOS_DATA
	add	edi, 3
	call	PmHexToA
	mov	byte ptr es:[di+2], ':'
; Get CMOS seconds.
	mov	al, Cmos_RTC_SEC
	out	CMOS_ADDR, al
	in	al, CMOS_DATA
	add	edi, 3
	call	PmHexToA

; Print current time in the middle of the screen.
	mov	esi, offset TimeStr
	mov	dh, 12
	mov	dl, 36
	mov	bl, TimeClr
	call	PmWriteStr32
ENDIF

	mov	al, CMD_EOI
	out	PIC_MASTER, al		; EOI

	mov	eax, 20h		; Timer IRQ #.
	call	CallCallbacks		; Call callbacks, CF doesn't matter.

; If no active tasks, sense global ticks count.
	cmp	NumOfTasks, 0
	jne	report_local_timer

	inc	TickCount
	mov	eax, TickCount
	cmp	eax, TicksReport
	jb	end_timer_int

	mov	TickCount, 0
	jmp	report_timer

; Increment number of ticks.
report_local_timer:
	mov	ecx, CurrTaskPtr
	inc	(DosTask PTR fs:[ecx]).TaskTickCount

	mov	ecx, CurrTaskPtr
	mov	eax, (DosTask PTR fs:[ecx]).TaskTickCount
	cmp	eax, (DosTask PTR fs:[ecx]).TaskTicksReport
	jb	end_timer_int		; If not reached counter value, end interrupt.

; Reset ticks counter.
	mov	(DosTask PTR fs:[ecx]).TaskTickCount, 0

IFDEF	PRINT_TIME
	inc	TimeClr
ENDIF

report_timer:
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	end_timer_int

; Timer interrupt is reported to an active task. If tasks are switched,
; report to a new task.
@@@@:
	or	VirtualIp, 1		; Virtual IRQ0 pending.

end_timer_int:
;
; If a keyboard buffer is not empty, set IRQ 1 pending for foreground task.
;
	mov	eax, KbdQHead
	cmp	eax, KbdQTail
	je	@@F
	TASK_PTR	ForegroundTask
	or	(DosTask PTR fs:[eax]).TaskVirtualIp, 2

@@@@:
	jmp	SetClientRegs		; Return to client's call.
TimerInt	ENDP


;-----------------------------------------------------------------------------
;
;	Keyboard interrupt handler.
;
;-----------------------------------------------------------------------------
KbdInt		PROC	near
	push	0				; no error code
	call	GetClientRegs

	in	al, KBD_STATUS
	test	al, STS_Data_Ready
	jz	kbd_eoi

	cmp	KeyExtCode, 0
	je	read_key

; Extended scan code.
	cmp	KeyExtCode, 0E1h
	je	pause_key?

	in	al, KBD_DATA
	mov	TempScanCode, al		; Save keyboard data.

	cmp	al, 2Ah
	je	kbd_eoi
	cmp	al, 0AAh
	je	kbd_eoi

	mov	KeyPressed, al
	jmp	kbd_eoi

pause_key?:
	in	al, KBD_DATA
	cmp	al, 1Dh
	jne	kbd_eoi
	mov	TempScanCode, al		; Save keyboard data.
	in	al, KBD_DATA
;	cmp	al, 0C5h
;	je	pause_key
	cmp	al, 45h
	jne	kbd_eoi

pause_key:
	mov	KeyReady, 1
	mov	KeyPressed, al
	jmp	kbd_eoi

read_key:
	in	al, KBD_DATA
	mov	TempScanCode, al		; Save keyboard data.
	cmp	al, 0FEh
	je	kbd_eoi

	cmp	al, 0E0h
	jb	test_break_code
	cmp	al, 0E1h
	jne	test_break_code

	mov	KeyExtCode, al
	jmp	kbd_eoi

test_break_code:
	test	al, 80h			; Break (release) code.
	jz	key_pressed

; Test if shift keys are released.
	sub	esi, esi
	and	eax, 7Fh		; Clear released bit.
	mov	ah, KeyExtCode
@@@@::
	cmp	eax, ShiftScanTbl[ esi * 4 ]
	je	@@F
	inc	esi
	cmp	esi, 8
	jb	@@B
	jmp	kbd_eoi

@@@@:
	mov	al, ShiftBitCode[ esi ]
	not	al
	and	ShiftKeys, al
	jmp	kbd_eoi

key_pressed:
	mov	KeyReady, 1
	mov	KeyPressed, al

; Test shift codes.
	sub	esi, esi
	sub	eax, eax
	mov	al, KeyPressed
	mov	ah, KeyExtCode
@@@@:
	cmp	eax, ShiftScanTbl[ esi * 4 ]
	je	@@F
	inc	esi
	cmp	esi, 8
	jb	@@B
	jmp	kbd_eoi

@@@@:
	mov	al, ShiftBitCode[ esi ]
	or	ShiftKeys, al

kbd_eoi:
	mov	al, CMD_EOI
	out	PIC_MASTER, al

IFDEF	DEBUG_BUILD
	cmp	DebugFlag, 0
	jnz	end_kbd_int
ENDIF	; DEBUG_BUILD

	or	IrqReported, 2		; By default, report IRQ 1.
	mov	eax, 21h		; Keyboard interrupt #
	call	CallCallbacks		; Call callbacks, CF doesn't matter.

; If happened not in CPL 3, exit.
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	end_kbd_int
; If happened while debugging in CPL 3, exit.
@@@@:

IFDEF	DEBUG_BUILD
	cmp	TraceFlag, 0
	jnz	end_kbd_int
ENDIF	; DEBUG_BUILD

; If key was designated for system, don't report.
	test	IrqReported, 2
	jz	end_kbd_int

; If happened in system task, no report.
	cmp	SystemTask, 0
	jne	end_kbd_int

; Insert key to a virtual keyboard cyclic queue.
	mov	eax, KbdQTail		; Set EAX -> next code to insert.
	inc	eax
	cmp	eax, KEYBOARD_Q_SIZE
	jb	@@F
	sub	eax, eax
@@@@:
	cmp	eax, KbdQHead		; If queue is full, don't insert.
	je	@@F

	mov	cl, TempScanCode
	mov	edx, KbdQTail
	mov	KeyboardQ[ edx ], cl	; Save keyboard code.
	mov	KbdQTail, eax		; Update keyboard queue tail.
@@@@:

; Keyboard interrupt is reported only to a foreground task.
	mov	eax, ForegroundTask
	cmp	eax, CurrentTask
	je	report_int

; Boost foreground task.

; Clear block on keyboard event state.
	TASK_PTR
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT KBD_INPUT
	jnz	end_kbd_int
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
@@@@:
	mov	eax, ForegroundTask
	call	SwitchTask

report_int:
	or	VirtualIp, 2		; Virtual IRQ1 pending.
end_kbd_int:
	jmp	SetClientRegs
KbdInt		ENDP


;-----------------------------------------------------------------------------
;
;	IRQ 2 - 7 handler
;
;-----------------------------------------------------------------------------
IrqHandler0	PROC
Irq2Int::
	push	0
	call	GetClientRegs
	mov	edx, 00000100b
	jmp	gluke0_int
Irq3Int::
	push	0
	call	GetClientRegs
	mov	edx, 00001000b

; If some task is owning a Com1 semaphore, report IRQ4 only to it.
	cmp	Com1.DevSema4.State, 0
	jne	gluke0_int			; Else, report to all.

	mov	eax, Com2.DevSema4.Owner
	cmp	eax, CurrentTask
;	jne	@@F
	je	@@F
	call	SwitchTask
	jc	report_irq3_pending
@@@@:
; Report to the current task
	or	VirtualIp, 00001000b
	jmp	end_gluke0_int
report_irq3_pending:
	TASK_PTR
	or	(DosTask PTR fs:[eax]).TaskVirtualIp, 00001000b
	jmp	end_gluke0_int
Irq4Int::
	push	0
	call	GetClientRegs
	mov	edx, 00010000b

; If some task is owning a Com1 semaphore, report IRQ4 only to it.
	cmp	Com1.DevSema4.State, 0
	jne	gluke0_int			; Else, report to all.

	mov	eax, Com1.DevSema4.Owner
	cmp	eax, CurrentTask
	jne	@@F
; Report to the current task
	or	VirtualIp, 00010000b
	jmp	end_gluke0_int
@@@@:
	TASK_PTR
	or	(DosTask PTR fs:[eax]).TaskVirtualIp, 00010000b
	jmp	end_gluke0_int
Irq5Int::
	push	0
	call	GetClientRegs
	mov	edx, 00100000b
	jmp	gluke0_int
Irq6Int::
	push	0
	call	GetClientRegs

; IRQ 6 - FDD completion interrupt.
	cmp	FddSema4, 0
	je	normal_irq6

	mov	eax, FddSema4Own
	cmp	eax, CurrentTask
	je	retire_dma

; Boost FDD semaphore owner.
	call	SwitchTask

EXTRN	RetireDma: near32
retire_dma:
	push	eax
	mov	al, 2
	call	RetireDma
	pop	eax

normal_irq6:
	mov	edx, 01000000b
	jmp	gluke0_int

Irq7Int::
	push	0
	call	GetClientRegs
	mov	edx, 10000000b

;
; Generic handling of IRQ 2 - 7.
;
gluke0_int:
; EOI.
	mov	al, CMD_EOI
	out	PIC_MASTER, al

	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	end_gluke0_int
@@@@:
; Set virtual interrupt pending for all tasks - both active and suspended.
	or	VirtualIp, edx
	mov	ecx, FirstTask
	mov	ebx, NumOfTasks
set_int_pending:
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, edx
	add	ecx, SIZEOF DosTask
	dec	ebx
	jnz	set_int_pending

end_gluke0_int:
	jmp	SetClientRegs		; return

IrqHandler0	ENDP


;-----------------------------------------------------------------------------
;
;	IRQ 8 - F handler
;
;-----------------------------------------------------------------------------
IrqHandler1	PROC
Irq8Int::
	push	0
	call	GetClientRegs
	mov	edx, 0000000100000100b
	jmp	gluke1_int
Irq9Int::
	push	0
	call	GetClientRegs
	mov	edx, 0000001000000100b
	jmp	gluke1_int
IrqAInt::
	push	0
	call	GetClientRegs
	mov	edx, 0000010000000100b
	jmp	gluke1_int
IrqBInt::
	push	0
	call	GetClientRegs
	mov	edx, 0000100000000100b
sub	edx, edx
	jmp	gluke1_int
IrqCInt::
	push	0
	call	GetClientRegs
	mov	edx, 0001000000000100b
	jmp	gluke1_int
IrqDInt::
	push	0
	call	GetClientRegs
	mov	edx, 0010000000000100b
	jmp	gluke1_int
IrqEInt::
	push	0
	call	GetClientRegs

; IRQ E - IDE completion interrupt.
	cmp	HddSema4, 0
	je	normal_irqE

	mov	eax, HddSema4Own
	cmp	eax, CurrentTask
	je	normal_irqE

; Boost HDD semaphore owner.
	call	SwitchTask

; Test for the rare case that task is blocked on both events.
;	jnc	normal_irqE
;
;	mov	esi, eax
;	TASK_PTR
;	mov	bl, (DosTask PTR fs:[eax]).TaskState
;	mov	cl, (DosTask PTR fs:[eax]).TaskBlock
;int 3

normal_irqE:
	or	VirtualIp, 0100000000000100b

; EOI.
	mov	al, CMD_EOI
	out	PIC_SLAVE, al
	out	PIC_MASTER, al

	jmp	end_gluke1_int

IrqFInt::
	push	0
	call	GetClientRegs
	mov	edx, 1000000000000100b
	jmp	gluke1_int

gluke1_int:
; EOI.
	mov	al, CMD_EOI
	out	PIC_SLAVE, al
	out	PIC_MASTER, al

	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	end_gluke1_int

; Set virtual interrupt pending for all tasks - running and suspended.
@@@@:
	or	VirtualIp, edx
	mov	ecx, FirstTask
	mov	ebx, NumOfTasks
set_int_pending:
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, edx
	add	ecx, SIZEOF DosTask
	dec	ebx
	jnz	set_int_pending

end_gluke1_int:
	jmp	SetClientRegs		; return

IrqHandler1	ENDP


CODE32	ENDS
END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
d797 2
a798 1
IFDEF	LOG_DPMI
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@d797 1
a797 2
;IFDEF	LOG_DPMI
IF	0
a2045 17
IF	1
	pushad

	mov	eax, 12345678h
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
ENDIF


a2101 15
IF	1
	pushad

	mov	eax, 12345679h
	mov	edi, offset Field
	call	PmHex32ToA
	mov	Field[8], 13
	mov	Field[9], 10
	mov	eax, offset Field
	mov	ecx, 10
	mov	esi, offset Field
	call	WriteLog

	popad
ENDIF
@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d151 2
d2047 17
d2120 15
d2154 19
a2172 1
	jmp	gluke0_int
d2177 15
a2191 1
	jmp	gluke0_int
@


0.49
log
@Fixes version includes:
1) variable mapping of DPMI service pages at C0000, D0000, E0000 instead of a hardcoded address.
2) added 2 32-bit XMS functions and XMS service table is fixed.
3) detection and diagnostic is improved.
@
text
@d1914 10
@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@a106 2
	EXTRN	InitErrHandler: near16

d165 1
d1423 2
a1424 1
	cmp	ecx, DPMI_SERVICE_PAGE
@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@d149 4
a152 2
	EXTRN	Int13Sema4Own: dword
	EXTRN	Int13Sema4: byte
d2125 11
d2137 1
d2143 1
d2146 1
d2223 1
a2223 1
	cmp	Int13Sema4, 0
d2226 1
a2226 1
	mov	eax, Int13Sema4Own
d2230 1
a2230 1
; Boost INT 13h semaphore owner.
@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d1949 2
d1952 3
a1954 2
	cmp	al, 0C5h
	je	pause_key
d2050 1
a2050 1
; If happened in system task, report.
d2122 7
@


0.45
log
@The shareware beta release
@
text
@d887 1
d890 1
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 38
d43 1
a43 1
;	Exception and interrupts handling routines and data for MULTIX32.
a111 1
	EXTRN	SimulateV86Int: near32
d172 2
d205 1
d873 18
a890 1
	jnz	unhandled_dump
a892 1

d1153 1
d1168 1
d1181 1
d1196 2
d1439 29
d1472 1
a1472 1
; Service cascaded instead.
d1479 27
d1510 2
d1514 1
a1514 1
; Clear pending IRQ.
d1517 1
d1534 9
d1544 2
a1545 1
; Clear pending IRQ.
d1548 1
d1626 1
a1626 4
; Clear NT flag.
	and	ExcEflags, NOT FL_NT

; Set return stack frame according to mode of exception caller.
d1628 4
a1631 2
	jz	pm_caller

d1634 1
a1634 1
	je	restore_vm_regs
d1637 7
a1714 10
pm_caller:

	test	ExcSeg, 3
	jz	restore_pm_regs

	cmp	VirtualIf, 0
	je	restore_pm_regs

	call	ReportIrq

d1752 3
a1758 3
	test	ExcSeg, 3
	jz	ring0_caller

d1810 4
d2041 4
a2048 4
; If key was designated for system, don't report.
	test	IrqReported, 2
	jz	end_kbd_int

d2178 1
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d83 4
d99 1
a99 1
	EXTRN	OsStartPage: DWORD
a115 3
	EXTRN	TickCount: dword
	EXTRN	TicksReport: dword

d163 3
a176 1
	PUBVAR	ExcEbx		,DD,	?
d179 1
d207 6
a212 1
	Gate386	< LOWWORD (offset DoubleFault), CODE_32, 0, INT_386_ACCESS , 0 >
d589 1
d591 10
d753 73
d837 1
a837 1
; For test purposes don't redirect exceptions.
d840 1
a840 1
	je	unhandled_dump		; DPMI not initialized?
d842 1
d848 1
a848 1
; Exceptions 0..7 and 9 are redirected as interrupts.
d852 1
a852 1
	cmp	ecx, 9
d854 1
a854 1
	cmp	ecx, 8
d857 1
a857 1
	je	unhandled_dump		; Handler not installed.
d860 2
a861 1
	call	SimulateInt
d865 28
d925 2
a926 3
; Adjust PM locked stack.
	sub	(DosTask PTR fs:[eax]).DpmiPmEsp, LOCKED_STACK_SIZE
	sub	(DosTask PTR fs:[eax]).DpmiPmStack, LOCKED_STACK_SIZE
a940 1
int 3
d942 1
a942 1
; Push excetion location, flags and SS:ESP.
d958 2
a959 3
; Adjust PM locked stack.
	sub	(DosTask PTR fs:[eax]).DpmiPmEsp, LOCKED_STACK_SIZE
	sub	(DosTask PTR fs:[eax]).DpmiPmStack, LOCKED_STACK_SIZE
a961 4
; Save exception number.
	mov	esi, ExcNumber
	mov	(DosTask PTR fs:[eax]).DpmiTempExcNum, esi

d974 2
a979 1
int 3
d996 8
a1003 3
int 5
	mov	esi, CurrTaskPtr
	mov	esi, (DosTask PTR fs:[esi]).DpmiTempExcNum
d1018 1
a1018 2
	mov	ecx, CurrTaskPtr
	mov	ecx, (DosTask PTR fs:[ecx]).DpmiTempExcNum
d1022 1
a1022 2
	mov	ecx, CurrTaskPtr
	mov	ecx, (DosTask PTR fs:[ecx]).DpmiTempExcNum
d1030 1
a1030 1
	call	DumpRegs
a1085 4
	mov	Idt.Limit, 0
	lidt	fword ptr Idt
	int 3		; Reboot

d1450 45
a1579 14
IF 1
test	ExcSeg, 3
jz	pm_locked_stack_ok
mov	ebx, CurrTaskPtr
mov	eax, (DosTask PTR fs:[ebx]).DpmiPmEsp
cmp	eax, PM_LOCKED_ESP
ja	@@F
cmp	eax, PM_LOCKED_STACK_BOTTOM
jnb	pm_locked_stack_ok
@@@@:
int 2
pm_locked_stack_ok:
ENDIF

a1582 10
cmp	word ptr ExcEs, 28Fh
jne	@@F
cmp	word ptr ExcEdi, 28Fh
jne	@@F
mov	ax, ExcSeg
mov	ebx, ExcOffs
mov	ecx, ExcEax
int 3
@@@@:

d1648 1
a1648 1
if 0
a1650 4
cmp	ExcOffs, 0FFFFh
jb	@@F
cmp	word ptr ExcSs, INIT_SS
je	@@F
d1659 1
a1659 1
int 3
a1734 1
	inc	TickCount		; Increment number of ticks.
d1738 5
d1744 15
a1758 2
	cmp	eax, TicksReport	; If not reached counter value,
	jb	end_timer_int		; end interrupt.
d1760 2
a1761 1
	mov	TickCount, 0		; Reset ticks counter.
d1767 1
@


0.42
log
@1) Added XMS server
2) Memory allocation / deallocation is moved to task creation / deletion
@
text
@d145 1
a185 2
	PUBVAR	TempExcNum, DD, ?	; Temporary exception number holder.

d745 1
a745 1
	TASK_PTR	CurrentTask
a769 1
int 3
d819 1
d844 1
a844 1
	mov	TempExcNum, esi
d864 1
a864 1
	TASK_PTR	CurrentTask
d879 3
a881 2
int 3
	mov	esi, TempExcNum
d896 2
a897 1
	mov	ecx, TempExcNum
d901 2
a902 1
	mov	ecx, TempExcNum
d1419 1
a1419 1
IF 0
d1429 1
a1429 1
int 3
d1595 1
a1595 1
	mov	bl, 3
d1611 4
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@a10 1

d74 1
d187 5
d518 11
d541 11
d745 1
d756 2
a758 1
	mov	ecx, ExcNumber
d771 1
d776 1
a776 4
; 32-bit task. Adjust PM locked stack.
	sub	(DosTask PTR fs:[eax]).DpmiPmEsp, 20
	sub	(DosTask PTR fs:[eax]).DpmiPmStack, 20

d779 1
d787 1
d803 5
a811 3
	sub	(DosTask PTR fs:[eax]).DpmiPmEsp, 10
	sub	(DosTask PTR fs:[eax]).DpmiPmStack, 10

d814 1
d838 4
d846 1
d853 6
d863 1
d880 1
a894 3
	mov	eax, CurrTaskPtr
	add	(DosTask PTR fs:[eax]).DpmiPmEsp, 6
	add	(DosTask PTR fs:[eax]).DpmiPmStack, 6
d896 2
a897 1
	jmp	unhandled_dump
a898 3
	mov	eax, CurrTaskPtr
	add	(DosTask PTR fs:[eax]).DpmiPmEsp, 12
	add	(DosTask PTR fs:[eax]).DpmiPmStack, 12
d900 2
d973 51
d1243 8
a1250 7
int 3
	mov	byte ptr fs:[eax][6], 3
extrn	DpmiCallbackRet: near32
	call	DpmiCallbackRet
	test	ExcEflags, FL_VM
	jz	ret000
ret000:
d1290 1
a1308 1

d1347 2
a1348 5
if 0
extrn	LogX: byte
extrn	LogY: byte
extrn	LogClr: byte

d1350 8
a1357 2
	PM_PRINT_HEX16	0A000h, LogX, LogY, LogClr
	add	LogX, 5
d1371 1
a1371 1
endif
d1417 14
d1433 11
d1452 3
a1454 12
	mov	eax, ExcEax
	mov	ebx, ExcEbx
	mov	ecx, ExcEcx
	mov	edx, ExcEdx
	mov	esi, ExcEsi
	mov	edi, ExcEdi
	mov	ebp, ExcEbp

	mov	es, ExcEs
	mov	fs, ExcFs
	mov	gs, ExcGs

d1456 7
a1462 10
	jz	ring0_caller

if 1
extrn	LogX: byte
extrn	LogY: byte
extrn	LogClr: byte

pushad
	PM_PRINT_HEX16	0A001h, LogX, LogY, LogClr
	add	LogX, 5
d1476 1
d1478 7
a1484 1
EXTRN	CheckPt: byte
d1486 3
a1488 4
cmp	CheckPt, 0
je	@@F
inc	CheckPt
@@@@:
d1490 2
a1491 1
endif
d1509 1
a1509 1
if 1
d1514 2
d1523 1
d1532 13
d1546 2
d1562 1
a1562 1
IF 0
d1595 1
a1596 1
ENDIF
a1902 7

mov	ecx, CurrTaskPtr
cmp	(DosTask PTR fs:[ecx]).TaskLdt, 0
je	@@F
EXTRN	CheckPt: byte
inc	CheckPt
@@@@:
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@d1049 1
d1058 1
d1128 1
a1128 1
;	Report highest privilege pending IRQ to client unconditionally.
d1141 19
d1253 23
d1329 1
d1345 31
d1388 1
d1395 3
d1768 8
@


0.39
log
@Bug fixed: raw mode switches.
@
text
@d103 1
a712 4
IFDEF	DEBUG_BUILD
	call	DebugCallback		; DEBUG.
ENDIF	; DEBUG_BUILD

d746 6
a751 2
; 32-bit task. Push far return address.
	mov	edx, DPMI_LOCKED_STACK - 20h
d776 1
a776 1
; 16-bit task.
d778 5
a782 1
	mov	edx, DPMI_LOCKED_STACK - 10h
d839 7
a845 2
; Restore original exception parameters from locked stack.
	TASK_PTR	CurrentTask
d850 3
d856 3
d862 4
d901 4
d1101 1
a1101 1
	mov	esp, EXC_STK
d1119 1
d1275 1
d1315 12
@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@d168 1
a1077 1

@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d73 1
a83 2
	EXTRN	GpCount: dword

d158 1
d428 7
d449 1
a589 1
	inc	GpCount
d1344 1
a1344 1
	mov	al, CMD_Eoi
d1474 1
a1474 1
	mov	al, CMD_Eoi
a1542 1

d1587 1
a1587 1
	mov	al, CMD_Eoi
d1674 1
a1674 1
	mov	al, CMD_Eoi
d1688 1
a1688 1
	mov	al, CMD_Eoi
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d81 1
a81 1
	EXTRN	GpCount: byte
d83 2
d582 1
d704 4
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@d1178 3
@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@a81 1
	EXTRN	DebugFlag: byte
d95 2
d98 3
d840 1
d842 1
d846 1
d848 1
d1170 1
d1176 1
a1256 1
and	ExcEflags, NOT (FL_NT OR FL_RF)
d1460 1
d1463 1
d1476 2
d1480 2
@


0.32
log
@Translation services work.
@
text
@@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@d5 1
a5 1
;	Exception handling routines and data for MULTIX32.
d61 56
a116 56
		INCLUDE	EXCEPT.INC
		INCLUDE	X86.INC
		INCLUDE	DEVICES.INC
		INCLUDE	DEF.INC
		INCLUDE	CORE.INC
		INCLUDE	TASKMAN.INC
		INCLUDE	PHLIB32.MCR
		INCLUDE	DPMI.INC

		EXTRN	InitErrHandler: near16

		EXTRN	PointerToLinear: near32
		EXTRN	SimulateInt: near32
		EXTRN	GetScanCode: near32
		EXTRN	core_start: near32
		EXTRN	NextTask: near32
		EXTRN	FocusToNextTask: near32
		EXTRN	StopTask: near32
		EXTRN	SwitchTask: near32

		EXTRN	GpCount: byte
		EXTRN	DebugFlag: byte

		EXTRN	KeyReady: byte
		EXTRN	KeyPressed: byte
		EXTRN	KeyExtCode: byte
		EXTRN	ShiftKeys: byte
		EXTRN	ShiftScanTbl: dword
		EXTRN	ShiftBitCode: byte
		EXTRN	KeyboardQ: byte
		EXTRN	KbdQHead: dword
		EXTRN	KbdQTail: dword
		EXTRN	TempScanCode: byte

		EXTRN	OsStartPage: DWORD
		EXTRN	TraceFlag: byte
		EXTRN	CurrentTask: dword
		EXTRN	ForegroundTask: dword
		EXTRN	FirstTask: dword
		EXTRN	NumOfTasks: dword
		EXTRN	VirtualIf: dword
		EXTRN	Int13Sema4Own: dword
		EXTRN	Int13Sema4: byte
		EXTRN	SystemTask: dword

		EXTRN	TickCount: dword
		EXTRN	TicksReport: dword

		EXTRN	Start32Esp: dword

		EXTRN	SysPdb: dword
		EXTRN	Pdb: dword
		EXTRN	SysPdbLin: dword
		EXTRN	PdbLin: dword
		EXTRN	SysPagesCtl: dword
		EXTRN	PagesCtl: dword
d118 2
a119 2
		EXTRN	PmCallbackCs: word
		EXTRN	PmCallbackSs: word
d709 10
d721 5
d892 3
d898 1
a898 1
	mov	(REG_PACK PTR es:[ebx]).dwEip, eax
d900 1
a900 1
	mov	(REG_PACK PTR es:[ebx]).dwEflags, eax
d902 1
a902 1
	mov	(REG_PACK PTR es:[ebx]).dwEax, eax
d904 1
a904 1
	mov	(REG_PACK PTR es:[ebx]).dwEbx, eax
d906 1
a906 1
	mov	(REG_PACK PTR es:[ebx]).dwEcx, eax
d908 1
a908 1
	mov	(REG_PACK PTR es:[ebx]).dwEdx, eax
d910 1
a910 1
	mov	(REG_PACK PTR es:[ebx]).dwEsi, eax
d912 1
a912 1
	mov	(REG_PACK PTR es:[ebx]).dwEdi, eax
d914 1
a914 1
	mov	(REG_PACK PTR es:[ebx]).dwEsp, eax
d916 1
a916 1
	mov	(REG_PACK PTR es:[ebx]).dwEbp, eax
d920 1
a920 1
	mov	(SREG_PACK PTR es:[ecx]).wCs, ax
d922 1
a922 1
	mov	(SREG_PACK PTR es:[ecx]).wDs, ax
d924 1
a924 1
	mov	(SREG_PACK PTR es:[ecx]).wEs, ax
d926 1
a926 1
	mov	(SREG_PACK PTR es:[ecx]).wFs, ax
d928 1
a928 1
	mov	(SREG_PACK PTR es:[ecx]).wGs, ax
d930 1
a930 1
	mov	(SREG_PACK PTR es:[ecx]).wSs, ax
d933 1
d947 4
d952 1
a952 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEip
d954 1
a954 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEflags
d956 1
a956 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEax
d958 1
a958 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEbx
d960 1
a960 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEcx
d962 1
a962 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEdx
d964 1
a964 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEsi
d966 1
a966 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEdi
d968 1
a968 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEsp
d970 1
a970 1
	mov	eax, (REG_PACK PTR es:[ebx]).dwEbp
d974 1
a974 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wCs
d976 1
a976 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wDs
d978 1
a978 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wEs
d980 1
a980 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wFs
d982 1
a982 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wGs
d984 1
a984 1
	movzx	eax, (SREG_PACK PTR es:[ecx]).wSs
d988 1
d1161 1
@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d68 1
d118 2
d121 1
d145 1
d177 2
d329 1
d344 1
d360 9
d695 2
d698 1
a698 1
	jnz	@@F
d701 107
d809 3
a1146 1
check_vif:
a1150 1
get_irq:
d1198 7
d1206 1
d1222 1
d1307 2
d1313 1
d1433 1
a1433 1
; If happened not in VM, exit.
d1435 2
d1438 2
a1439 1
; If happened while debugging in VM, exit.
d1535 2
d1538 1
a1538 1

d1637 2
d1642 1
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@@


0.28
log
@Initial DPMI switch works.
@
text
@d140 1
d347 5
d353 1
a353 1
	PM_PRINT_STR	(offset GpRegsStr), 2, 10
d369 1
a369 1
	PM_PRINT_STR	(offset SRegsStr), 2, 11
d380 1
a380 1
	PM_PRINT_STR	(offset StkStr), 2, 12
@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@a117 5
EXC_TRAPS	SEGMENT	PARA	PUBLIC	USE16	'BSS'
	DB	HANDLED_INTS * MAX_TRAPS * 4 DUP (?)
EXC_TRAPS	ENDS


d230 5
a469 1
	mov	ErrCodePresent, 0
a475 1
	mov	ErrCodePresent, 0
a481 1
	mov	ErrCodePresent, 0
a487 1
	mov	ErrCodePresent, 0
a493 1
	mov	ErrCodePresent, 0
a499 1
	mov	ErrCodePresent, 0
a505 1
	mov	ErrCodePresent, 0
a511 1
	mov	ErrCodePresent, 0
a517 1
	mov	ErrCodePresent, 4
a523 1
	mov	ErrCodePresent, 0
a529 1
	mov	ErrCodePresent, 4
a535 1
	mov	ErrCodePresent, 4
a541 1
	mov	ErrCodePresent, 4
a552 1
	mov	ErrCodePresent, 4
a558 1
	mov	ErrCodePresent, 4
a564 1
	mov	ErrCodePresent, 0
a570 1
	mov	ErrCodePresent, 0
a576 1
	mov	ErrCodePresent, 0
a582 1
	mov	ErrCodePresent, 0
a588 1
	mov	ErrCodePresent, 0
a594 1
	mov	ErrCodePresent, 0
a600 1
	mov	ErrCodePresent, 0
a606 1
	mov	ErrCodePresent, 0
a612 1
	mov	ErrCodePresent, 0
a618 1
	mov	ErrCodePresent, 0
a624 1
	mov	ErrCodePresent, 0
a630 1
	mov	ErrCodePresent, 0
a636 1
	mov	ErrCodePresent, 0
a642 1
	mov	ErrCodePresent, 0
a648 1
	mov	ErrCodePresent, 0
a654 1
	mov	ErrCodePresent, 0
a660 1
	mov	ErrCodePresent, 0
d672 2
d675 1
a675 1

d848 8
a864 11
;get return address from stack.
	pop	eax
	
; Get error code indicator from stack.
	pop	ecx
	test	ecx, ecx
	jz	get_exc_offs

; Get error code.
	pop	ExcCode

d904 2
a905 2
	sub	esp, Cpl0EspAdjust
	add	Cpl0EspAdjust, CPL0_STK_SIZE
d913 1
a913 1
	jmp	eax		; Return to gotten return address.
d1060 1
a1060 1
	sub	Cpl0EspAdjust, CPL0_STK_SIZE
d1081 1
a1081 1
	sub	Cpl0EspAdjust, CPL0_STK_SIZE
d1093 1
a1093 1
	sub	Cpl0EspAdjust, CPL0_STK_SIZE
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@d1054 1
d1061 2
a1062 1
	PM_PRINT_HEX32	(DosTask PTR fs:[ecx]).TaskOpenFiles, 30, 23, 13
d1065 3
a1067 4
	PM_PRINT_HEX32	(DosTask PTR fs:[ecx]).TaskOpenFiles, 40, 23, 14
	PM_PRINT_HEX32	CurrentTask, 50, 23, 4
	PM_PRINT_HEX32	Int13Sema4Own, 60, 23, 4
	PM_PRINT_HEX	Int13Sema4, 70, 23, 4
d1069 1
d1071 1
d1359 1
a1359 1
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT (KBD_INPUT OR INT28_WAIT)
@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@d1053 17
a1179 4
	PM_PRINT_HEX32	CurrentTask, 50, 23, 4
	PM_PRINT_HEX32	Int13Sema4Own, 60, 23, 4
	PM_PRINT_HEX	Int13Sema4, 70, 23, 4

@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@d69 1
a69 1
		EXTRN	InitErrHandler: near
d78 1
a78 1
		EXTRN	SwitchTaskTo: near32
a153 5
	IrqClientRegs	REG_PACK	16 DUP (<>)
	IrqClientSregs	SREG_PACK	16 DUP (<>)

	IrqRegsFlag	DB	16 DUP (0)

a725 17
	cmp	NumOfTasks, 1
	je	stop_last_task

	push	eax
	cmp	eax, ForegroundTask
	jne	@@F
	call	FocusToNextTask
	jmp	stop_task
@@@@:
	inc	eax
	cmp	eax, NumOfTasks
	jb	@@F
	sub	eax, eax
@@@@:
	call	SwitchTaskTo		; Force task switch.
stop_task:
	pop	eax
d727 2
d731 1
a731 10
stop_last_task:
	mov	ecx, SysPdbLin
	mov	PdbLin, ecx
	mov	ecx, SysPagesCtl
	mov	PagesCtl, ecx
	mov	ecx, SysPdb
	mov	Pdb, ecx
	mov	cr3, ecx
	call	StopTask

a1019 11
; If IRQ 1 (keyboard is being reported)...
	cmp	eax, 9
	jne	@@F
; If current task is locked on KBD_INPUT or INT28_WAIT, release lock.
	TASK_PTR
	test	(DosTask PTR fs:[eax]).TaskState, TASK_WAITING
	jz	@@F
	and	(DosTask PTR fs:[eax]).TaskWait, NOT (KBD_INPUT OR INT28_WAIT)
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_WAITING

@@@@:
a1043 9
; If SystemTask flag is set, don't check wait states.
	cmp	SystemTask, 0
	jne	check_vif

; If task is waiting, don't check VirtualIf.
	TASK_PTR	CurrentTask
	test	(DosTask PTR fs:[eax]).TaskState, TASK_WAITING
	jnz	get_irq

a1161 3
;	PM_PRINT_HEX32	CurrentTask, 0, 24, 4
;	PM_PRINT_HEX32	Int13Sema4Own, 10, 24, 4
;	PM_PRINT_HEX	Int13Sema4, 20, 24, 4
d1163 3
d1339 3
a1341 3
; Keyboard interrupt is reported only to a task owning a focus.
; If current task is not foreground, set keyboard interrupt pending in
; foreground task's structure.
d1343 6
a1348 7
	or	(DosTask PTR fs:[eax]).TaskVirtualIp, 2
; Resume foreground task if it was waiting.
	test	(DosTask PTR fs:[eax]).TaskState, TASK_WAITING
	jz	end_kbd_int
	and	(DosTask PTR fs:[eax]).TaskWait, NOT (KBD_INPUT OR INT28_WAIT)
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_WAITING
	jmp	end_kbd_int
a1351 1

d1468 14
a1481 4
; Set pending IRQ E for int 13h semaphore owner.
	TASK_PTR
	mov	ecx, eax
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, 0100000000000100b
d1483 1
a1483 1
; Send EOI.
a1486 1
	jmp	end_gluke1_int
a1487 2
normal_irqE:
	or	VirtualIp, 0100000000000100b
@


0.23
log
@1) File sharing handled.
@
text
@d11 1
d42 1
a42 8
; Allocate memory for exceptions callbacks list.
	mov	ah, 48h
	mov	bx, (HANDLED_INTS * MAX_TRAPS * 4) SHR 4
	int	21h
	jnc	traps_alloc_ok
	call	InitErrHandler

traps_alloc_ok:
d61 7
a67 7
			INCLUDE	EXCEPT.INC
			INCLUDE	X86.INC
			INCLUDE	DEVICES.INC
			INCLUDE	DEF.INC
			INCLUDE	CORE.INC
			INCLUDE	TASKMAN.INC
			INCLUDE	PHLIB32.MCR
d116 6
@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@d445 1
a445 1
	call	dword ptr fs:[edx][ecx*4]	; Callback or prepares all registers
@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@d981 1
a981 1
;	Sets client regs and returns to the client (caller)
d987 5
a991 11
PUBLIC	SetClientRegs
SetClientRegs	PROC
; If TraceFlag, set TF = 1.
	movzx	eax, TraceFlag
	shl	eax, 8
	and	ExcEflags, NOT FL_TF
	or	ExcEflags, eax

; Set return stack frame according to mode of exception caller.
	test	ExcEflags, FL_VM
	jz	pm_caller
a992 11
	cmp	SystemTask, 0
	jne	check_vif

; If task is locked on KBD_INPUT or INT28_WAIT, don't check VirtualIf.
	TASK_PTR	CurrentTask
	test	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
	jz	check_vif
	test	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	jnz	@@F
	test	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
	jz	check_vif
a993 15
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_UNBLOCKED
	and	(DosTask PTR fs:[eax]).TaskBlock, NOT (KBD_INPUT OR INT28_WAIT)
	jnz	get_irq
	and	(DosTask PTR fs:[eax]).TaskState, NOT TASK_BLOCKED
	jmp	get_irq

check_vif:
; Service VM pending interrupts if possible.
	cmp	VirtualIf, 0
	je	restore_vm_regs

get_irq:
	cmp	VirtualIp, 0
	je	restore_vm_regs

d1002 1
a1002 1
	jne	sim_pending_irq
d1032 1
a1032 1
	jmp	restore_vm_regs
d1034 1
a1034 1
sim_pending_irq:
d1049 52
a1231 3
	cmp	SystemTask, 0
	jne	report_irq

a1234 7
	cmp	VirtualIf, 0		; Test virtual IF.
	je	end_timer_int

	and	VirtualIp, NOT 1	; Virtual IRQ0 is serviced.
report_irq:
	mov	eax, 8			; Simulate int #8.
	call	SimulateInt
d1361 1
a1361 1
	jne	report_irq
d1386 1
a1386 1
	je	report_int?
d1393 2
a1394 6
; Unblock foreground task if it was blocked.
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jz	end_kbd_int
	test	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	jnz	@@F
	test	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
d1396 2
a1397 2
@@@@:
	or	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
d1400 1
a1400 1
report_int?:
a1402 24
; If current task is locked on KBD_INPUT, report regardless VirtualIf and
; unblock task.
	TASK_PTR
	test	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jz	check_vif
	test	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	jnz	@@F
	test	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
	jz	check_vif
@@@@:
	or	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
	jmp	report_to_task

check_vif:
; Apply VirtualIf checking.
	cmp	VirtualIf, 0		; Test virtual IF.
	je	end_kbd_int

report_to_task:
	and	VirtualIp, NOT 2	; Virtual IRQ1 is serviced.
report_irq:
	mov	eax, 9			; Simulate int #9.
	call	SimulateInt

d1418 1
a1418 1
	mov	al, 0Ah
d1423 1
a1423 1
	mov	al, 0Bh
d1428 1
a1428 1
	mov	al, 0Ch
d1433 1
a1433 1
	mov	al, 0Dh
d1438 1
a1438 1
	mov	al, 0Eh
d1443 1
a1443 2
	mov	al, 0Fh
	jmp	gluke0_int
d1445 3
a1449 1
	mov	edx, eax
d1456 2
a1457 10
	cmp	SystemTask, 0
	jne	report_irq

	lea	ecx, [edx-8]		; ECX = IRQ#
	mov	eax, 1
	shl	eax, cl
	or	VirtualIp, eax		; Virtual IRQ pending.

; Set virtual interrupt pending for all suspended tasks. Setting appropriate
; field in current task's entry doesn't harm.
d1459 1
a1459 1
	sub	ebx, ebx
d1461 1
a1461 1
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, eax
d1463 2
a1464 3
	inc	ebx
	cmp	ebx, NumOfTasks
	jb	set_int_pending
a1465 9
	cmp	VirtualIf, 0		; Test virtual IF.
	je	end_gluke0_int

	not	eax
	and	VirtualIp, eax		; Virtual IRQ is serviced

report_irq:
	movzx	eax, dl
	call	SimulateInt		; Simulate int #al
d1481 1
a1481 1
	mov	al, 70h
d1486 1
a1486 1
	mov	al, 71h
d1491 1
a1491 1
	mov	al, 72h
d1496 1
a1496 1
	mov	al, 73h
d1501 1
a1501 1
	mov	al, 74h
d1506 1
a1506 1
	mov	al, 75h
d1522 1
a1522 2
	mov	eax, 0100000000000100b
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, eax
d1531 3
a1533 2
	mov	al, 76h
	jmp	gluke1_int
d1537 1
a1537 1
	mov	al, 77h
a1541 1
	mov	edx, eax
d1549 2
a1550 16
	cmp	SystemTask, 0
	jne	report_irq

	lea	ecx, [edx-70h+8]	; ECX = IRQ#
	mov	eax, 1
	shl	eax, cl
	or	eax, 4			; IRQ2 pending.
	or	VirtualIp, eax		; Virtual IRQ pending.

	cmp	edx, 76h
	je	check_vif

;
; Set virtual interrupt pending for all suspended tasks. Setting appropriate
; field in current task's entry doesn't harm.
;
d1552 1
a1552 1
	sub	ebx, ebx
d1554 1
a1554 1
	or	(DosTask PTR fs:[ecx]).TaskVirtualIp, eax
d1556 2
a1557 14
	inc	ebx
	cmp	ebx, NumOfTasks
	jb	set_int_pending

check_vif:
	cmp	VirtualIf, 0
	je	end_gluke1_int

	not	eax
	and	VirtualIp, eax		; Virtual IRQ is serviced

report_irq:
	movzx	eax, dl
	call	SimulateInt		; Simulate int #al
@


0.20
log
@Task locks on wait for events are added.
@
text
@d740 6
a745 1
	call	NextTask
d1003 7
a1009 10
	mov	eax, CurrentTask
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
	jne	check_vif
	cmp	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	je	@@F
	cmp	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
	jne	check_vif
d1011 5
a1015 1
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
d1381 1
a1381 3
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
d1384 6
a1389 6
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jne	end_kbd_int
	cmp	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	je	@@F
	cmp	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
	jne	end_kbd_int
d1391 1
a1391 1
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
d1399 7
a1405 9
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	cmp	(DosTask PTR fs:[eax]).TaskState, TASK_BLOCKED
	jne	check_vif
	cmp	(DosTask PTR fs:[eax]).TaskBlock, KBD_INPUT
	je	@@F
	cmp	(DosTask PTR fs:[eax]).TaskBlock, INT28_WAIT
	jne	check_vif
d1407 1
a1407 1
	mov	(DosTask PTR fs:[eax]).TaskState, TASK_UNBLOCKED
d1555 1
a1555 3
	mov	ecx, SIZEOF DosTask
	mul	ecx
	add	eax, FirstTask
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@d997 1
a997 1
; If task is locked on KBD_INPUT, don't check VirtualIf.
d1005 2
d1008 1
a1009 1
	jmp	get_irq
d1383 2
d1386 1
d1399 1
a1399 1
	jne	@@F
d1401 5
a1405 3
	jne	@@F

	mov	(DosTask PTR fs:[eax]).TaskState, TASK_RUNNING
d1408 1
a1409 1
@@@@:
@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@d978 3
d994 16
d1014 1
d1335 1
d1338 1
d1341 1
a1341 1

d1377 6
a1382 1
;	cmp	(DosTask PTR fs:[eax]).TaskVirtualIf, 0
a1383 3
; If current task is not foreground and foreground task has IF = 1, then 
; foreground task gets a one-time boost to get kbd. interrupt processed.
;	call	SwitchTaskTo
d1387 16
d1406 1
@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d95 4
d109 1
d159 1
a159 1
	PUBVAR	Cpl0EspAdjust, DD, 0	; Adjustment for overlapped ints/exc.
a575 2
	mov	esi, cr2
	mov	dx, fs:[esi-2]
d1039 1
a1040 1
	mov	edx, eax
a1042 1

d1163 3
a1165 3
	PM_PRINT_HEX32	CurrentTask, 0, 24, 4
	PM_PRINT_HEX32	Int13Sema4Own, 10, 24, 4
	PM_PRINT_HEX	Int13Sema4, 20, 24, 4
d1184 3
d1194 1
d1224 2
d1236 1
d1249 1
a1282 1

d1317 1
a1317 1
	test	ExcEflags, FL_TF
d1320 3
d1327 16
d1367 1
d1423 3
d1448 1
d1537 3
d1569 1
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@d103 2
d1160 4
d1463 23
d1513 1
d1516 1
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d376 1
d1321 2
a1322 2
	cmp	(DosTask PTR fs:[eax]).TaskVirtualIf, 0
	je	end_kbd_int
d1325 1
a1325 1
	call	SwitchTaskTo
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@d84 1
d152 2
a153 1
	PUBVAR		ExcNumber, DD, ?	; Exception number
d954 3
a1047 1

d1068 2
d1089 3
d1101 3
d1320 5
a1324 1
	jmp	end_kbd_int
@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d75 1
a75 1
	EXTRN	InitErrHandler: near
d77 37
a113 22
	EXTRN	PointerToLinear: near32
	EXTRN	SimulateInt: near32
	EXTRN	GetAsciiCode: near32
	EXTRN	pmode_loop: near32
	EXTRN	NextTask: near32
	EXTRN	FocusToNextTask: near32
	EXTRN	StopTask: near32

	EXTRN	GpCount: byte
	EXTRN	DebugFlag: byte

	EXTRN	KeyReady:byte
	EXTRN	KeyPressed:byte
	EXTRN	KeyExtCode:byte

	EXTRN	OsStartPage: DWORD
	EXTRN	TraceFlag: byte
	EXTRN	CurrentTask: dword
	EXTRN	ForegroundTask: dword
	EXTRN	FirstTask: dword
	EXTRN	NumOfTasks: dword
	EXTRN	VirtualIf: dword
a114 6
	EXTRN	TickCount: dword
	EXTRN	TicksReport: dword

	EXTRN	Start32Esp: dword
	EXTRN	Pdb:dword

d398 1
a398 1
	mov	si, offset Field
d566 2
d703 2
d712 3
a714 3
	mov	al, 0FFh		; Disable all interrupts but kbd.
	out	PIC_MASTER_MASK, al
	out	PIC_SLAVE_MASK, al
d716 1
a716 1
	call	GetAsciiCode		; Wait for key pressed.
a734 1
	mov	ecx, cr3
a735 1
	mov	cr3, ecx
d739 7
a748 2
	mov	eax, Pdb
	mov	cr3, eax
d750 1
a750 1
	jmp	pmode_loop
a760 2
	mov	al, 3

d1234 20
a1253 1
	jnz	kbd_eoi
d1255 1
d1259 17
a1315 1

@


0.9
log
@VGA state save/restore
@
text
@a51 2
	sub	eax, OsStartPage
	or	eax, OS_BASE
d79 5
d103 2
d132 2
d236 2
a237 1
AddExcTrap	PROC
a249 3
	push	fs
	mov	dx, FLAT_DS
	mov	fs, dx
d252 2
d255 1
a255 1
	mov	fs:[edx + eax * 4], ecx
a258 2
	pop	fs

a364 1
	PM_PRINT_HEX32	ExcEsp, 14
d417 1
a417 1
	shl	edx, 5
d426 1
a426 1
	call	dword ptr fs:[edx][eax*4]	; Callback or prepares all registers
d689 48
a736 1
DumpAndHalt:
d1149 2
a1150 1
; Timer interrupt is reported to an active task.
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@a211 1

d420 2
a421 2
	push	eax
	push	ecx
d425 2
a426 2
	pop	ecx
	pop	eax
d694 2
d877 3
a1120 2
	mov	KeyReady, 0			; Clear previously gotten
						; key.
d1125 7
d1133 9
a1141 2
	cmp	al, 0F0h
	jb	read_key
d1143 8
d1154 4
a1157 1
	mov	KeyExtCode, 0
d1160 2
a1161 2
	cmp	al, 0EFh
	ja	test_break_code
d1164 1
a1164 1
	in	al, KBD_DATA
a1169 1
ext_code_read:
d1189 4
a1212 3

	test	IrqReported, 2		; If key was designated for system,
	jz	end_kbd_int		; don't report.
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device.
@
text
@a155 3
	TempEcx		DD	?
	TempEdx		DD	?

a491 39
;
; Invalid opcode FE FF 00 00 00 00  is an entry point from V86 INT callback.
;
	test	(INT386_STACK PTR [esp]).dwEflags, FL_VM
	jz	invalid

	push	ds
	push	eax

	mov	ax, FLAT_DS
	mov	ds, ax

	movzx	eax, (INT386_VM_STACK PTR [esp+8]).wCs
	shl	eax, 4
	add	eax, (INT386_VM_STACK PTR [esp+8]).dwEip
	cmp	word ptr ds:[eax], 0FFFEh
	jne	invalid_v86

	cmp	dword ptr ds:[eax+2], 0
	jne	invalid_v86

; It's an entry point from V86 interrupt.
;	mov	ecx, ds:[eax+6]
;	mov	edx, ds:[eax+10]

	pop	eax
	pop	ds

;	push	edx
;	push	ecx
;	retf
EXTRN	FromV86Entry: NEAR32
	jmp	FromV86Entry

invalid_v86:
	pop	eax
	pop	ds

invalid:
d1043 1
d1076 1
d1335 3
d1349 1
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@a99 2
	EXTRN	FDDSema4: IntSema4
	EXTRN	HDDSema4: IntSema4
a100 1

d495 39
a1084 1
IF 0
d1117 1
a1117 1
ENDIF
a1230 1
	and	IrqReported, NOT 2
a1264 9
;
; IRQ E cannot be used by several tasks, so it must comply to HDDSema4 semaphore.
; 

; If semaphore is not busy, go to normal handling.
	mov	al, HDDSema4.Busy
	test	al, al
	jnz	@@F

a1266 31

@@@@:
	mov	al, CMD_Eoi
	out	PIC_MASTER, al

; If current task is the same as semaphore owner, simulate interrupt. Otherwise, set pending
; and exit.
	mov	eax, FDDSema4.TaskNo
	cmp	eax, CurrentTask
	jne	@@F

	or	VirtualIp, 01000000b
	cmp	VirtualIf, 0
	je	end_gluke0_int

	and	VirtualIp, NOT 01000000b
	mov	eax, 0Eh
	call	SimulateInt
	jmp	end_gluke0_int

@@@@:
; Set FS:EDX -> task that owns semaphore.
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax

; Set IRQ pending for owner task.
	or	(DosTask PTR fs:[edx]).TaskVirtualIp, 01000000b
	jmp	end_gluke0_int

a1348 3
;
; IRQ E cannot be used by several tasks, so it must comply to HDDSema4 semaphore.
; 
a1350 6

; If semaphore is not busy, go to normal handling.
	mov	al, HDDSema4.Busy
	test	al, al
	jnz	@@F

a1352 34

@@@@:
; Handle IRQ E especially.

	mov	al, CMD_Eoi
	out	PIC_SLAVE, al
	out	PIC_MASTER, al

; If current task is the same as semaphore owner, simulate interrupt. Otherwise, set pending
; and exit.
	mov	eax, HDDSema4.TaskNo
	cmp	eax, CurrentTask
	jne	@@F

	or	VirtualIp, 0100000000000100b
	cmp	VirtualIf, 0
	je	end_gluke1_int

	and	VirtualIp, NOT 0100000000000100b
	mov	eax, 76h
	call	SimulateInt
	jmp	end_gluke1_int

@@@@:
; Set FS:EDX -> task that owns semaphore.
	mov	edx, SIZEOF DosTask
	mul	edx
	add	eax, FirstTask
	mov	edx, eax

; Set IRQ pending for owner task.
	or	(DosTask PTR fs:[edx]).TaskVirtualIp, 0100000000000100b
	jmp	end_gluke1_int

@


0.6
log
@Working non-preemptive multitasking
@
text
@d92 1
d94 1
d97 2
d100 1
d1121 10
d1134 1
a1158 1

d1203 15
d1287 11
d1374 11
@


0.5
log
@Working V86 emulation version!
@
text
@a47 2
;	mov	ax, EXC_TRAPS

d75 1
a78 4
	EXTRN	PmWriteStr32: near32
	EXTRN	PmHexToA: near32
	EXTRN	PmHex16ToA: near32
	EXTRN	PmHex32ToA: near32
a81 4
	EXTRN	FromV86Entry: near
	EXTRN	QuitPm: byte
	EXTRN	Mode0: byte

a82 1
	EXTRN	Emulated: byte
a88 6
	extrn	Chk1:byte
	extrn	Chk2:byte
	extrn	Chk3:byte
	extrn	Chk4:byte
	extrn	Chk5:byte

d93 1
a93 1

a94 3
;EXC_TRAPS	SEGMENT
;	DD	HANDLED_INTS * MAX_TRAPS DUP (0)
;EXC_TRAPS	ENDS
d98 2
d101 3
d123 1
a123 1
EXTRN	Field: byte
d130 1
a130 1
	ExcNumber	DD	?	; Exception number
a214 1
;ASSUME	CS:CODE32, DS:DATA
d217 1
d268 1
a268 17

	mov	esi, offset ExcStr
	mov	dh, 5
	mov	dl, 2
	mov	bl, 13h			; Atributes.

IFDEF	OLD_EXC_METHOD
	push	ecx
	push	eax
ENDIF	;OLD_EXC_METHOD
	call	PmWriteStr32

IFDEF	OLD_EXC_METHOD
	pop	eax
ELSE
	mov	eax, ExcNumber
ENDIF	;OLD_EXC_METHOD
d271 1
a271 11
	mov	di, ds
	mov	es, di
	mov	edi, offset Field
	call	PmHex16ToA
	add	dl, SIZEOF ExcStr + 1
	mov	esi, offset Field
	call	PmWriteStr32

IFDEF	OLD_EXC_METHOD
	pop	ecx
ENDIF
a273 3
IFDEF	OLD_EXC_METHOD
	test	ecx, ecx
ELSE
a274 1
ENDIF	;OLD_EXC_METHOD
d277 1
a277 7
	mov	eax, ExcCode
	mov	edi, offset Field
	call	PmHex32ToA

	add	dl, 5
	mov	esi, offset Field
	call	PmWriteStr32
d281 1
a281 4
	mov	esi, offset AddrStr
	mov	dh, 6
	mov	dl, 2
	call	PmWriteStr32
d294 1
a294 3
	add	dl, SIZEOF AddrStr + 1
	mov	esi, offset Field
	call	PmWriteStr32
d296 2
a297 3
	mov	edi, offset Field
	mov	eax, ExcEflags
	call	PmHex32ToA
d299 2
a300 3
	add	dl, 15
	mov	esi, offset Field
	call	PmWriteStr32
d318 1
a318 18
	mov	esi, offset CrStr
	mov	dh, 9
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, cr0			; Print CR0
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 4
	call	PmWriteStr32

	mov	eax, cr2			; Print CR2
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32
d320 6
a325 6
	mov	eax, cr3			; Print CR3
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32
d328 1
a328 39
	mov	esi, offset GpRegsStr
	mov	dh, 10
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, ExcEax			; Print EAX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 4
	call	PmWriteStr32

	mov	eax, ExcEbx			; Print EBX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEcx			; Print ECX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEdx			; Print EDX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEsi			; Print ESI
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32
d330 12
a341 6
	mov	eax, ExcEdi			; Print EDI
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32
d344 9
a352 32
	mov	esi, offset SRegsStr
	mov	dh, 11
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, ExcDs			; Print DS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 3
	call	PmWriteStr32

	mov	eax, ExcEs			; Print ES
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32

	mov	eax, ExcFs			; Print FS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32

	mov	eax, ExcGs			; Print GS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32
d355 7
a361 4
	mov	esi, offset StkStr
	mov	dh, 12
	mov	dl, 2
	call	PmWriteStr32
a362 21
	mov	eax, ExcSs			; Print SS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 7
	call	PmWriteStr32

	mov	eax, ExcEsp			; Print ESP
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 5
	call	PmWriteStr32

	mov	eax, ExcEbp			; Print EBP
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

d399 41
a447 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0
	sub	ecx, ecx
ELSE
a451 1
ENDIF
a454 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1
	sub	ecx, ecx
ELSE
a458 1
ENDIF
a461 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 2
	sub	ecx, ecx
ELSE
a465 1
ENDIF
a468 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 3
	sub	ecx, ecx
ELSE
a472 1
ENDIF
a475 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 4
	sub	ecx, ecx
ELSE
a479 1
ENDIF
a482 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 5
	sub	ecx, ecx
ELSE
a486 1
ENDIF
d501 1
a510 4

	mov	ecx, ds:[eax+6]
	mov	dx, ds:[eax+10]

d512 2
a513 7
	push	INIT_DS
	pop	es
	mov	es:TempEdx, edx
	mov	es:TempEcx, ecx

	mov	ecx, ds:[eax+6]
	mov	dx, ds:[eax+10]
d518 5
a522 8
	push	edx
	push	ecx

	push	INIT_DS
	pop	ds
	mov	ecx, TempEcx
	mov	edx, TempEdx
	retf
a528 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 6
	sub	ecx, ecx
ELSE
a532 1
ENDIF
a535 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 7
	sub	ecx, ecx
ELSE
a539 1
ENDIF
a542 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 8
	mov	ecx, 4
ELSE
a546 1
ENDIF
a549 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 9
	sub	ecx, ecx
ELSE
a553 1
ENDIF
a556 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Ah
	mov	ecx, 4
ELSE
a560 1
ENDIF
a563 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Bh
	mov	ecx, 4
ELSE
a567 1
ENDIF
a570 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Ch
	mov	ecx, 4
ELSE
a574 1
ENDIF
a582 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Dh
	mov	ecx, 4
ELSE
a586 1
ENDIF
a589 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Eh
	mov	ecx, 4
ELSE
a593 1
ENDIF
a596 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 0Fh
	sub	ecx, ecx
ELSE
a600 1
ENDIF
a603 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 10h
	sub	ecx, ecx
ELSE
a607 1
ENDIF
a610 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 11h
	sub	ecx, ecx
ELSE
a614 1
ENDIF
a617 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 12h
	sub	ecx, ecx
ELSE
a621 1
ENDIF
a624 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 13h
	sub	ecx, ecx
ELSE
a628 1
ENDIF
a631 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 14h
	sub	ecx, ecx
ELSE
a635 1
ENDIF
a638 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 15h
	sub	ecx, ecx
ELSE
a642 1
ENDIF
a645 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 16h
	sub	ecx, ecx
ELSE
a649 1
ENDIF
a652 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 17h
	sub	ecx, ecx
ELSE
a656 1
ENDIF
a659 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 18h
	sub	ecx, ecx
ELSE
a663 1
ENDIF
a666 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 19
	sub	ecx, ecx
ELSE
a670 1
ENDIF
a673 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Ah
	sub	ecx, ecx
ELSE
a677 1
ENDIF
a680 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Bh
	sub	ecx, ecx
ELSE
a684 1
ENDIF
a687 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Ch
	sub	ecx, ecx
ELSE
a691 1
ENDIF
a694 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Dh
	sub	ecx, ecx
ELSE
a698 1
ENDIF
a701 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Eh
	sub	ecx, ecx
ELSE
a705 1
ENDIF
a708 6
IFDEF	OLD_EXC_METHOD
	push	eax
	push	ecx
	mov	eax, 1Fh
	sub	ecx, ecx
ELSE
a712 1
ENDIF
a718 57

IFDEF	OLD_EXC_METHOD
; Recover possible DS corruption.
	push	ds
	push	INIT_DS
	pop	ds
; Save CPU regs as were at the exception time.
	pop	ExcDs			; Will be further altered if fault CS
					; PL > 0.
	pop	ExcEcx
	pop	ExcEax
	mov	ExcEbx, ebx
	mov	ExcEdx, edx
	mov	ExcEbp, ebp
	mov	ExcEsi, esi
	mov	ExcEdi, edi

; Save exception address and error code (if any).
	jcxz	error_code_got
	pop	ExcCode
	and	ExcCode, 0FFFFh
error_code_got:
	pop	ExcOffs
	pop	esi
	mov	ExcSeg, si
	pop	ExcEflags
allowed_eflags::

; Save exception SS:ESP if there was a PL change
	test	ExcEflags, FL_VM
	jz	get_pmode_sregs
	pop	ExcEsp
	pop	ExcSs
	pop	ExcEs
	pop	ExcDs
	pop	ExcFs
	pop	ExcGs
	jmp	call_callbacks

get_pmode_sregs:
	mov	ExcEs, es
	mov	ExcFs, fs
	mov	ExcGs, gs
	test	ExcSeg, 3	; Check if faulting CS was at PL > 0
	jnz	pop_stk_regs

	mov	ExcEsp, esp	; No stack switch.
	mov	ExcSs, ss
	jmp	call_callbacks

pop_stk_regs:
	pop	ExcEsp
	pop	ExcSs

ENDIF	; OLD_EXC_METHOD

call_callbacks:
d720 2
a721 3
	cmp	ExcTrapsTail[eax*4], 0	; If no callbacks, dump to screen and
					; halt.
	je	DumpAndHalt
d723 6
a728 7
	sub	ecx, ecx
	mov	edx, eax
	shl	edx, 5
	add	edx, ExcTrapsList
next_callback:
	cmp	ecx, ExcTrapsTail[eax*4]
	jnb	DumpAndHalt
d730 2
a731 12
	call	dword ptr fs:[edx][eax*4]	; Callback or prepares all registers
					; for returning to caller or returns
					; CF = 1
	jnc	exc_handled

	inc	ecx
	jmp	next_callback

exc_handled:
	jmp	SetClientRegs

DumpAndHalt:
d735 1
a735 4
	mov	esi, offset HaltStr
	mov	dh, 7
	mov	dl, 2
	call	PmWriteStr32
d752 2
a753 2
;	I:	EBX -> REG_PACK
;		ECX -> SREG_PACK
d761 1
a761 1
	mov	(REG_PACK PTR [ebx]).dwEip, eax
d763 1
a763 1
	mov	(REG_PACK PTR [ebx]).dwEflags, eax
d765 1
a765 1
	mov	(REG_PACK PTR [ebx]).dwEax, eax
d767 1
a767 1
	mov	(REG_PACK PTR [ebx]).dwEbx, eax
d769 1
a769 1
	mov	(REG_PACK PTR [ebx]).dwEcx, eax
d771 1
a771 1
	mov	(REG_PACK PTR [ebx]).dwEdx, eax
d773 1
a773 1
	mov	(REG_PACK PTR [ebx]).dwEsi, eax
d775 1
a775 1
	mov	(REG_PACK PTR [ebx]).dwEdi, eax
d777 1
a777 1
	mov	(REG_PACK PTR [ebx]).dwEsp, eax
d779 1
a779 1
	mov	(REG_PACK PTR [ebx]).dwEbp, eax
d783 1
a783 1
	mov	(SREG_PACK PTR [ecx]).wCs, ax
d785 1
a785 1
	mov	(SREG_PACK PTR [ecx]).wDs, ax
d787 1
a787 1
	mov	(SREG_PACK PTR [ecx]).wEs, ax
d789 1
a789 1
	mov	(SREG_PACK PTR [ecx]).wFs, ax
d791 1
a791 1
	mov	(SREG_PACK PTR [ecx]).wGs, ax
d793 1
a793 1
	mov	(SREG_PACK PTR [ecx]).wSs, ax
d803 2
a804 2
;	I:	EBX -> REG_PACK
;		ECX -> SREG_PACK
d810 1
a810 1
	mov	eax, (REG_PACK PTR [ebx]).dwEip
d812 1
a812 1
	mov	eax, (REG_PACK PTR [ebx]).dwEflags
d814 1
a814 1
	mov	eax, (REG_PACK PTR [ebx]).dwEax
d816 1
a816 1
	mov	eax, (REG_PACK PTR [ebx]).dwEbx
d818 1
a818 1
	mov	eax, (REG_PACK PTR [ebx]).dwEcx
d820 1
a820 1
	mov	eax, (REG_PACK PTR [ebx]).dwEdx
d822 1
a822 1
	mov	eax, (REG_PACK PTR [ebx]).dwEsi
d824 1
a824 1
	mov	eax, (REG_PACK PTR [ebx]).dwEdi
d826 1
a826 1
	mov	eax, (REG_PACK PTR [ebx]).dwEsp
d828 1
a828 1
	mov	eax, (REG_PACK PTR [ebx]).dwEbp
d832 1
a832 1
	movzx	eax, (SREG_PACK PTR [ecx]).wCs
d834 1
a834 1
	movzx	eax, (SREG_PACK PTR [ecx]).wDs
d836 1
a836 1
	movzx	eax, (SREG_PACK PTR [ecx]).wEs
d838 1
a838 1
	movzx	eax, (SREG_PACK PTR [ecx]).wFs
d840 1
a840 1
	movzx	eax, (SREG_PACK PTR [ecx]).wGs
d842 1
a842 1
	movzx	eax, (SREG_PACK PTR [ecx]).wSs
d944 69
a1021 4
; Set return stack frame according to mode of exception caller.
	test	ExcEflags, FL_VM
	jz	pm_caller

d1035 9
a1115 25
; Print address message.
	mov	esi, offset AddrStr
	mov	dh, 20
	mov	dl, 2
	call	PmWriteStr32

; Print address of the fault instruction.
	mov	edi, offset Field
	mov	ax, ExcSeg
	call	PmHex16ToA
	add	edi, 4

	mov	byte ptr [edi], ':'
	inc	edi
	mov	eax, ExcOffs
	call	PmHex32ToA

	add	dl, SIZEOF AddrStr + 1
	mov	esi, offset Field
	call	PmWriteStr32

	mov	edi, offset Field
	mov	eax, ExcEflags
	call	PmHex32ToA

d1118 4
a1121 2
	test	ExcEflags, FL_TF
	jnz	end_timer_int
d1123 1
d1141 2
a1142 2
	test	ExcEflags, FL_VM
	jnz	reflect_kbd_int
a1162 1
	jmp	ext_code_read
d1171 1
a1171 8
	cmp	al, 1
	jne	space?
	mov	QuitPm, 1
	jmp	kbd_eoi
space?:
	cmp	al, 57
	jne	kbd_eoi
	mov	Mode0, 1
d1176 7
d1188 8
a1195 2
	cmp	DebugFlag, 0
	jnz	end_kbd_int
a1196 1
reflect_kbd_int:
d1244 5
d1250 12
a1261 3
	jz	gluke0_eoi
	test	ExcEflags, FL_TF
	jnz	gluke0_eoi
d1263 1
a1263 1
	movzx	eax, al
d1265 1
a1265 4
gluke0_eoi:
; EOI.
	mov	al, CMD_Eoi
	out	PIC_MASTER, al
a1318 9
	test	ExcEflags, FL_VM
	jz	gluke1_eoi
	test	ExcEflags, FL_TF
	jnz	gluke1_eoi

	movzx	eax, al
	call	SimulateInt		; Simulate int #al

gluke1_eoi:
d1320 1
d1325 19
@


0.4
log
@First V86 emulation version
@
text
@a10 2
EXTRN	GpCount: byte

d40 1
a40 1
SetupExcTraps	PROC	near
d43 1
a43 1
	mov	bx, (HANDLED_INTS * MAX_TRAPS) SHR 4
d48 2
d58 7
d75 2
d85 1
d91 8
d106 4
d111 3
d116 1
a116 1
	PUBVAR	KeyPressed, DB, ?	; Key pressed.
d122 1
a122 1
		DD	(HANDLED_INTS * MAX_TRAPS) - 1 DUP (0)	
d138 9
d164 4
d172 32
a203 32
	Gate386	< LOWWORD (offset DivisionBy0), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset DebugExc), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Nmi), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Int3Exc), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Overflow), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset BoundExc), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset InvOpcode), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset X87NotAvl), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset DoubleFault), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception09), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset InvTSS), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset SegNotPresent), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset StackFault), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset GPExc), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset PageFault), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception0F), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset FPError), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset AlignCheckExc), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception12), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception13), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception14), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception15), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception16), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception17), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception18), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception19), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1A), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1B), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1C), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1D), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1E), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset Exception1F), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
d205 8
a212 3
	Gate386	< LOWWORD (offset TimerInt), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< LOWWORD (offset KbdInt), CODE_32, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	6 DUP ( < LOWWORD (offset GlookeInt0), CODE_32, 0, INT_386_ACCESS or 60h, 0 > )
d214 8
a221 7
	Gate386	8 DUP ( < LOWWORD (offset GlookeInt1), CODE_32, 0, INT_386_ACCESS or 60h , 0 > )
; Software interrupts -- 30h
;			Gate386	< Int30Entry, CODE_32, 0, INT_386_ACCESS or 60h , 0 >
;		      -- 31h:  interrupt gate
;			Gate386 < Int31Entry, CODE_32, 0, INT_386_ACCESS or 60h, 0 >
;		      -- 31h:  task gate
;			Gate386 < 0, MONITOR_DESCRIPTOR, 0, TASK_GATE_ACCESS or 60h, 0 >
d229 2
a230 1
ASSUME	CS:CODE32, DS:DATA
d274 272
d554 1
d559 6
d566 1
d568 1
a570 16

	push	ds
	mov	ax, INIT_DS
	mov	ds, ax
	test	ExcEflags, FL_TF	; Who sets TF=1?
	pop	ds
	jnz	debug_exc

	pop	ecx
	pop	eax
	iretd		; If debug exception is trap, this will go on.

debug_exc:
	sub	eax, eax
	mov	dr7, eax	; Disable h/w breakpoints.

d573 6
d580 1
d582 1
d587 6
d594 1
d596 1
d601 6
d608 1
d610 1
d615 6
d622 1
d624 1
d629 6
d636 1
d646 1
d657 5
d663 8
d673 9
a681 1
	jmp	FromV86Entry
d686 1
d688 1
d693 6
d700 1
d702 1
d707 6
d714 1
d716 1
d721 6
d728 1
d730 1
d735 6
d742 1
d744 1
d749 6
d756 1
d758 1
d763 6
d770 1
d772 1
d777 6
d784 1
d791 1
a791 1

d796 6
d803 1
d805 1
d810 6
d817 1
d819 1
d824 6
d831 1
d833 1
d838 6
d845 1
d847 1
d852 6
d859 1
d861 1
d866 6
d873 1
d875 1
d880 6
d887 1
d889 1
d894 6
d901 1
d903 1
d908 6
d915 1
d917 1
d922 6
d929 1
d931 1
d936 6
d943 1
d945 1
d950 6
d957 1
d959 1
d962 1
a962 1
	mov	eax, 19h
d964 6
d971 1
d973 1
d978 6
d985 1
d987 1
d992 6
d999 1
d1001 1
d1006 6
d1013 1
d1015 1
d1020 6
d1027 1
d1029 1
d1034 6
d1041 1
d1043 1
d1048 6
d1060 2
d1114 2
d1117 1
a1121 2
	mov	cx, FLAT_DS
	mov	fs, cx
d1139 218
d1399 2
d1404 1
d1407 1
a1407 261
DumpAndHalt:
; Output exception string.

	mov	esi, offset ExcStr
	mov	dh, 5
	mov	dl, 2
	mov	bl, 13h			; Atributes.

	push	ecx
	push	eax
	call	PmWriteStr32
	pop	eax

; Print exception number.
	mov	di, ds
	mov	es, di
	mov	edi, offset Field
	call	PmHex16ToA
	add	dl, SIZEOF ExcStr + 1
	mov	esi, offset Field
	call	PmWriteStr32
	pop	ecx

; Print exception error code.
	test	ecx, ecx
	jz	code_printed

	mov	eax, ExcCode
	mov	edi, offset Field
	call	PmHex32ToA

	add	dl, 5
	mov	esi, offset Field
	call	PmWriteStr32

code_printed:
; Print address message.
	mov	esi, offset AddrStr
	mov	dh, 6
	mov	dl, 2
	call	PmWriteStr32

; Print address of the fault instruction.
	mov	edi, offset Field
	mov	ax, ExcSeg
	call	PmHex16ToA
	add	edi, 4

	mov	byte ptr [edi], ':'
	inc	edi
	mov	eax, ExcOffs
	call	PmHex32ToA

	add	dl, SIZEOF AddrStr + 1
	mov	esi, offset Field
	call	PmWriteStr32

	mov	edi, offset Field
	mov	eax, ExcEflags
	call	PmHex32ToA

	add	dl, 15
	mov	esi, offset Field
	call	PmWriteStr32

; Print halt message.
	mov	esi, offset HaltStr
	mov	dh, 7
	mov	dl, 2
	call	PmWriteStr32

; Dump 10 words from stack.
	mov	ecx, 10
	mov	dh, 8
	mov	dl, 2

stack_dump_loop:
	pop	eax
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	call	PmWriteStr32
	add	dl, 5
	dec	ecx
	jnz	stack_dump_loop

; Dump control registers.
	mov	esi, offset CrStr
	mov	dh, 9
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, cr0			; Print CR0
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 4
	call	PmWriteStr32

	mov	eax, cr2			; Print CR2
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, cr3			; Print CR3
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

; Dump general purpose registers.
	mov	esi, offset GpRegsStr
	mov	dh, 10
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, ExcEax			; Print EAX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 4
	call	PmWriteStr32

	mov	eax, ExcEbx			; Print EBX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEcx			; Print ECX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEdx			; Print EDX
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEsi			; Print ESI
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

	mov	eax, ExcEdi			; Print EDI
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

; Dump segment registers.
	mov	esi, offset SRegsStr
	mov	dh, 11
	mov	dl, 2
	call	PmWriteStr32

	mov	eax, ExcDs			; Print DS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 3
	call	PmWriteStr32

	mov	eax, ExcEs			; Print ES
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32

	mov	eax, ExcFs			; Print FS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32

	mov	eax, ExcGs			; Print GS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 8
	call	PmWriteStr32

; Dump stack (SS:ESP, EBP)
	mov	esi, offset StkStr
	mov	dh, 12
	mov	dl, 2
	call	PmWriteStr32
	
	mov	eax, ExcSs			; Print SS
	mov	edi, offset Field
	call	PmHex16ToA
	mov	esi, offset Field
	add	dl, 7
	call	PmWriteStr32

	mov	eax, ExcEsp			; Print ESP
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 5
	call	PmWriteStr32

	mov	eax, ExcEbp			; Print EBP
	mov	edi, offset Field
	call	PmHex32ToA
	mov	esi, offset Field
	add	dl, 13
	call	PmWriteStr32

; Dump faulting opcode (16 bytes)
	inc	dh
	mov	dl, 2
	mov	esi, offset OpcodeStr
	call	PmWriteStr32
	inc	dh
	mov	cx, FLAT_DS
	mov	fs, cx
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	mov	bl, 13h
	mov	ebp, eax		; fs: EBP+ECX point to fault. opcode
	sub	ecx, ecx

dump_opcode:
	push	ecx
	mov	edi, offset Field
	mov	eax, fs:[ebp+ecx]
	call	PmHexToA
	mov	si, offset Field
	call	PmWriteStr32
	add	dl, 3
	pop	ecx

	inc	ecx
	cmp	ecx, 16			; Dump 16 bytes.
	jb	dump_opcode

; Halt CPU.
	cli
	hlt

	mov	Idt.Limit, 0
	lidt	fword ptr Idt
	int 3		; Reboot

ExcHandler	ENDP
d1416 2
a1417 2
	mov	al, CMD_Eoi
	out	PIC_MASTER, al
a1421 2
	push	es

a1443 1
	pop	es
d1452 38
a1489 1
	iretd
d1499 6
d1507 7
a1513 1
	jz	eoi
d1515 8
d1524 8
d1536 1
a1536 1
	jmp	eoi
d1539 1
a1539 1
	jne	eoi
d1541 1
a1541 1
eoi:
d1545 14
a1558 1
	iretd
d1568 42
a1609 2
GlookeInt0	PROC
	push	ax
d1612 3
a1614 3
	pop	ax
	iretd
GlookeInt0	ENDP
d1622 53
a1674 2
GlookeInt1	PROC
	push	ax
d1678 4
a1681 3
	pop	ax
	iretd
GlookeInt1	ENDP
@


0.4.0.1
log
@Bug fix
@
text
@a91 1
	PUBVAR	KeyReady, DB, ?		; Key ready flag.
a927 1
	mov	KeyReady, 1
@


0.3
log
@Port of previous version for 32 bits.
@
text
@d11 2
d18 1
a18 1
;	Setup IDT.
d26 1
a26 1
	add	ax, IDT_START
d32 30
d67 3
d75 3
d80 8
a87 1
	EXTRN	FromV86Entry:near
d91 10
d105 25
a129 6
	Field		DB	16 DUP (?)
	ExcCode		DD	?
	ExcOffs		DD	?
	ExcSeg		DW	?
	ExcEflags	DD	?

d187 34
d222 5
d237 3
a239 1
	mov	ax, 0
d243 19
a261 1
	mov	ax, 1
d265 3
a267 1
	mov	ax, 2
d271 3
a273 1
	mov	ax, 3
d277 3
a279 1
	mov	ax, 4
d283 3
a285 1
	mov	ax, 5
d316 3
a318 1
	mov	ax, 6
d322 3
a324 1
	mov	ax, 7
d328 3
a330 1
	mov	ax, 8
d334 3
a336 1
	mov	ax, 9
d340 3
a342 1
	mov	ax, 0Ah
d346 3
a348 1
	mov	ax, 0Bh
d352 3
a354 1
	mov	ax, 0Ch
d357 5
d363 4
a366 1
	mov	ax, 0Dh
d370 3
a372 1
	mov	ax, 0Eh
d376 3
a378 1
	mov	ax, 0Fh
d382 3
a384 1
	mov	ax, 10h
d388 3
a390 1
	mov	ax, 11h
d394 3
a396 1
	mov	ax, 12h
d400 3
a402 1
	mov	ax, 13h
d406 3
a408 1
	mov	ax, 14h
d412 3
a414 1
	mov	ax, 15h
d418 3
a420 1
	mov	ax, 16h
d424 3
a426 1
	mov	ax, 17h
d430 3
a432 1
	mov	ax, 18h
d436 3
a438 1
	mov	ax, 19h
d442 3
a444 1
	mov	ax, 1Ah
d448 3
a450 1
	mov	ax, 1Bh
d454 3
a456 1
	mov	ax, 1Ch
d460 3
a462 1
	mov	ax, 1Dh
d466 3
a468 1
	mov	ax, 1Eh
d472 3
a474 1
	mov	ax, 1Fh
d482 15
a496 3
; Output exception message.
	mov	si, INIT_DS
	mov	ds, si			; Recover possible DS corruption.
d503 2
a504 1
	pop	ExcSeg
d506 101
d617 1
d639 1
d646 1
d675 1
d680 1
d691 167
d926 1
d928 1
@


0.2
log
@Support for BIOS calls in V86 mode
@
text
@d11 21
a34 1
			INCLUDE	PHLIB.INC
d36 4
a39 1
	EXTRN	PmWriteStr: near
d54 1
a54 1
	ExcEflags	DW	?
d60 32
a91 32
	Gate386	< DivisionBy0, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< DebugExc, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Nmi, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Int3Exc, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Overflow, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< BoundExc, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< InvOpcode, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< X87NotAvl, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< DoubleFault, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception09, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< InvTSS, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< SegNotPresent, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< StackFault, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< GPExc, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< PageFault, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception0F, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< FPError, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< AlignCheckExc, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception12, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception13, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception14, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception15, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception16, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception17, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception18, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception19, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1A, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1B, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1C, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1D, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1E, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< Exception1F, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
d93 3
a95 3
	Gate386	< TimerInt, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	< KbdInt, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
	Gate386	6 DUP ( < GlookeInt0, INIT_CS, 0, INT_386_ACCESS or 60h, 0 > )
d97 1
a97 1
	Gate386	8 DUP ( < GlookeInt1, INIT_CS, 0, INT_386_ACCESS or 60h , 0 > )
d99 1
a99 1
;			Gate386	< Int30Entry, INIT_CS, 0, INT_386_ACCESS or 60h , 0 >
d101 1
a101 1
;			Gate386 < Int31Entry, INIT_CS, 0, INT_386_ACCESS or 60h, 0 >
d110 2
a111 18
CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA
.486p
;-----------------------------------------------------------------------------
;
;	Setup IDT.
;
;-----------------------------------------------------------------------------
PUBLIC	SetupIdt
SetupIdt	PROC	near
	sub	eax, eax
	mov	ax, ds
	shl	eax, 4
	add	ax, IDT_START
	mov	Idt.Base, eax
	lidt	fword ptr Idt
	ret
SetupIdt	ENDP
d156 3
a158 3
	push	FLAT_DS
	pop	ds
	movzx	eax, (INT386_VM_STACK PTR [esp+6]).wCs
d160 1
a160 1
	add	eax, (INT386_VM_STACK PTR [esp+6]).dwEip
d170 1
d279 1
d281 1
d295 1
a295 1
	mov	si, offset ExcStr
d301 3
a303 3
	push	ax
	call	PmWriteStr
	pop	ax
d307 2
a308 2
	mov	di, offset Field
	call	Hex16ToA
d310 2
a311 2
	mov	si, offset Field
	call	PmWriteStr
d315 1
a315 1
	test	cx, cx
d318 3
a320 6
	push	dx
	mov	ax, word ptr ExcCode
	mov	dx, word ptr ExcCode[2]
	mov	di, offset Field
	call	Hex32ToA
	pop	dx
d323 2
a324 2
	mov	si, offset Field
	call	PmWriteStr
d327 1
a327 1
	mov	si, offset AddrStr
d330 1
a330 1
	call	PmWriteStr
d332 1
a332 1
	mov	di, offset Field
d334 8
a341 9
	call	Hex16ToA
	add	di, 4
	push	dx
	mov	byte ptr [di], ':'
	inc	di
	mov	ax, word ptr ExcOffs
	mov	dx, word ptr ExcOffs[2]
	call	Hex32ToA
	pop	dx
d343 7
a349 8
	mov	si, offset Field
	call	PmWriteStr
	push	dx
	mov	di, offset Field
	mov	ax, word ptr ExcEflags
	mov	dx, word ptr ExcEflags[2]
	call	Hex32ToA
	pop	dx
d351 3
a353 2
	mov	si, offset Field
	call	PmWriteStr
d355 1
a355 1
	mov	si, offset HaltStr
d358 1
a358 1
	call	PmWriteStr
d360 1
a360 1
	mov	cx, 10
d364 5
a368 5
	pop	ax
	mov	di, offset Field
	call	Hex16ToA
	mov	si, offset Field
	call	PmWriteStr
d370 1
a370 1
	dec	cx
a388 21
;	mov	bp, sp
;	test	dword ptr [bp+8], VIRTUAL_MODE
;	jz	@@F
;	mov	NextTask[2], MAIN_DESCRIPTOR
;	jmp	dword ptr NextTask

;@@@@:
;	push	ds
;	mov	ax, DS_DESCRIPTOR
;	mov	ds, ax
;	cli
;	push	ax
; Increment time counter.
;	inc	TimerCounter
; Aproximately once in second BEEPs on speaker.
;	test	TimerCounter, 0Fh
;	jnz	@@F

;	call	Beep
;@@@@:

d403 2
a404 2
	mov	di, offset TimeStr
	call	HexToA
d410 2
a411 2
	add	di, 3
	call	HexToA
d417 2
a418 2
	add	di, 3
	call	HexToA
d420 1
d422 1
a422 1
	mov	si, offset TimeStr
d426 1
a426 1
	call	PmWriteStr
d488 1
a488 1
CODE	ENDS
@


0.1
log
@16/05/98	Initial check-in
@
text
@d3 2
a4 2
;				INIT.ASM
;				--------
d11 1
d18 2
d21 1
d141 26
d200 1
a200 1
	sub	ecx, ecx
d289 1
d303 1
d307 1
d314 1
d318 1
d366 1
d369 1
a369 1
code_printed:
d457 5
d463 1
a463 1
	mov	QuitPm, 1
@
