head	0.53;
access;
symbols;
locks
	BlackPhantom:0.53
	BlackPhantom:0.7.0.1; strict;
comment	@;; @;


0.53
date	2002.05.13.03.00.48;	author BlackPhantom;	state Exp;
branches;
next	0.52;

0.52
date	2001.02.13.04.09.54;	author BlackPhantom;	state Exp;
branches;
next	0.51;

0.51
date	2001.02.12.02.23.02;	author BlackPhantom;	state Exp;
branches;
next	0.50;

0.50
date	2001.02.02.23.44.36;	author BlackPhantom;	state Exp;
branches;
next	0.49;

0.49
date	2001.01.19.19.22.34;	author BlackPhantom;	state Exp;
branches;
next	0.48;

0.48
date	2000.12.27.05.36.43;	author BlackPhantom;	state Exp;
branches;
next	0.47;

0.47
date	2000.11.19.00.48.14;	author BlackPhantom;	state Exp;
branches;
next	0.46;

0.46
date	2000.08.31.02.13.37;	author BlackPhantom;	state Exp;
branches;
next	0.45;

0.45
date	2000.08.15.23.51.37;	author BlackPhantom;	state Exp;
branches;
next	0.44;

0.44
date	2000.03.23.14.09.09;	author BlackPhantom;	state Exp;
branches;
next	0.43;

0.43
date	99.08.10.02.48.18;	author BlackPhantom;	state Exp;
branches;
next	0.42;

0.42
date	99.08.06.16.39.08;	author BlackPhantom;	state Exp;
branches;
next	0.41;

0.41
date	99.07.16.03.18.20;	author BlackPhantom;	state Exp;
branches;
next	0.40;

0.40
date	99.06.05.20.07.01;	author BlackPhantom;	state Exp;
branches;
next	0.39;

0.39
date	99.05.28.22.41.24;	author BlackPhantom;	state Exp;
branches;
next	0.38;

0.38
date	99.05.28.18.27.56;	author BlackPhantom;	state Exp;
branches;
next	0.37;

0.37
date	99.05.28.04.20.40;	author BlackPhantom;	state Exp;
branches;
next	0.36;

0.36
date	99.05.27.22.20.30;	author BlackPhantom;	state Exp;
branches;
next	0.35;

0.35
date	99.05.23.19.52.27;	author BlackPhantom;	state Exp;
branches;
next	0.34;

0.34
date	99.05.23.15.13.32;	author BlackPhantom;	state Exp;
branches;
next	0.33;

0.33
date	99.05.21.02.27.28;	author BlackPhantom;	state Exp;
branches;
next	0.32;

0.32
date	99.05.19.01.13.28;	author BlackPhantom;	state Exp;
branches;
next	0.31;

0.31
date	99.05.17.18.49.52;	author BlackPhantom;	state Exp;
branches;
next	0.30;

0.30
date	99.05.11.17.10.49;	author BlackPhantom;	state Exp;
branches;
next	0.29;

0.29
date	99.05.06.22.37.51;	author BlackPhantom;	state Exp;
branches;
next	0.28;

0.28
date	99.05.05.16.38.55;	author BlackPhantom;	state Exp;
branches;
next	0.27;

0.27
date	99.04.19.21.02.51;	author BlackPhantom;	state Exp;
branches;
next	0.26;

0.26
date	99.04.18.12.54.59;	author BlackPhantom;	state Exp;
branches;
next	0.25;

0.25
date	99.04.17.03.11.27;	author BlackPhantom;	state Exp;
branches;
next	0.24;

0.24
date	99.04.14.18.28.12;	author BlackPhantom;	state Exp;
branches;
next	0.23;

0.23
date	99.04.14.16.43.57;	author BlackPhantom;	state Exp;
branches;
next	0.22;

0.22
date	99.04.12.18.51.50;	author BlackPhantom;	state Exp;
branches;
next	0.21;

0.21
date	99.04.11.12.50.45;	author BlackPhantom;	state Exp;
branches;
next	0.20;

0.20
date	99.04.05.03.15.12;	author BlackPhantom;	state Exp;
branches;
next	0.19;

0.19
date	99.03.30.23.45.44;	author BlackPhantom;	state Exp;
branches;
next	0.18;

0.18
date	99.03.29.18.33.30;	author BlackPhantom;	state Exp;
branches;
next	0.17;

0.17
date	99.03.22.22.40.13;	author BlackPhantom;	state Exp;
branches;
next	0.16;

0.16
date	99.03.18.04.09.05;	author BlackPhantom;	state Exp;
branches;
next	0.15;

0.15
date	99.03.16.02.16.25;	author BlackPhantom;	state Exp;
branches;
next	0.14;

0.14
date	99.03.16.00.23.39;	author BlackPhantom;	state Exp;
branches;
next	0.13;

0.13
date	99.03.13.23.36.05;	author BlackPhantom;	state Exp;
branches;
next	0.12;

0.12
date	99.03.12.22.09.18;	author BlackPhantom;	state Exp;
branches;
next	0.11;

0.11
date	99.03.09.04.23.38;	author BlackPhantom;	state Exp;
branches;
next	0.10;

0.10
date	99.03.01.23.10.12;	author BlackPhantom;	state Exp;
branches;
next	0.9;

0.9
date	99.02.25.21.57.36;	author BlackPhantom;	state Exp;
branches;
next	0.8;

0.8
date	99.02.24.02.20.20;	author BlackPhantom;	state Exp;
branches;
next	0.7;

0.7
date	99.02.18.00.06.09;	author BlackPhantom;	state Exp;
branches
	0.7.0.1;
next	0.6;

0.6
date	99.02.17.17.01.48;	author BlackPhantom;	state Exp;
branches;
next	0.5;

0.5
date	99.02.10.04.40.20;	author BlackPhantom;	state Exp;
branches;
next	0.4;

0.4
date	98.12.22.03.04.23;	author BlackPhantom;	state Exp;
branches;
next	0.3;

0.3
date	98.06.05.12.46.26;	author BlackPhantom;	state Exp;
branches;
next	0.2;

0.2
date	98.05.28.02.50.23;	author BlackPhantom;	state Exp;
branches;
next	;

0.7.0.1
date	99.02.21.04.01.14;	author BlackPhantom;	state Exp;
branches;
next	;


desc
@MULTIX32 core kernel source file
@


0.53
log
@Last developed version
@
text
@;=============================================================================
;
;	This source code file is copyright (c) Vadim Drubetsky AKA the 
; Black Phantom. All rights reserved.
;
;	This source code file is a part of the Tripple-DOS project. Your use 
; of this source code must fully comply with the accompanying license file, 
; LICENSE.TXT. You must have this file enclosed with your Tripple-DOS copy in
; order for it to be legal.
;
;	In no event, except for when it is explicitly stated by the applicable 
; law, shall Vadim Drubetsky aka the Black Phantom be liable for any special,
; incidental, indirect, or consequential damages (including but not limited to
; profit loss, business interruption, loss of business information, or any 
; other pecuniary loss) arising out of the use of or inability to use 
; Tripple-DOS, even if he has been advised of the possibility of such damages.
;
;=============================================================================

;=============================================================================
;
;				CORE.ASM
;				--------
;
;	Tripple-DOS system core.
;
;=============================================================================

.486p
	INCLUDE	CORE.INC
	INCLUDE	X86.INC
	INCLUDE	DEVICES.INC
	INCLUDE	PHLIB32.MCR
	INCLUDE	DEF.INC
	INCLUDE	TASKMAN.INC
	INCLUDE	DEBUG.INC
	INCLUDE	DPMI.INC

	EXTRN	InitStkSel: word
	EXTRN	QuitPm: byte
	EXTRN	KeyReady: byte
	EXTRN	KeyPressed: byte
	EXTRN	KeyExtCode: byte
	EXTRN	ShiftKeys: byte
	EXTRN	Start32Esp: dword
	EXTRN	FirstTask: dword
	EXTRN	CurrentTask: dword
	EXTRN	CurrTaskPtr: dword
	EXTRN	ForegroundTask: dword
	EXTRN	NumOfTasks: dword
	EXTRN	IrqReported: dword
	EXTRN	TicksReport: dword
	EXTRN	TickToSec: dword

	EXTRN	ExcSeg: word
	EXTRN	ExcOffs: dword
	EXTRN	ExcEflags: dword
	EXTRN	ExcDs: word
	EXTRN	ExcEs: word
	EXTRN	ExcSs: word
	EXTRN	ExcFs: word
	EXTRN	ExcGs: word
	EXTRN	ExcEax: dword
	EXTRN	ExcEbx: dword
	EXTRN	ExcEcx: dword
	EXTRN	ExcEdx: dword
	EXTRN	ExcEsp: dword
	EXTRN	ExcEbp: dword
	EXTRN	ExcEsi: dword
	EXTRN	ExcEdi: dword

	EXTRN	SysPdb: dword
	EXTRN	Pdb: dword
	EXTRN	SysPdbLin: dword
	EXTRN	PdbLin: dword
	EXTRN	SysPagesCtl: dword
	EXTRN	PagesCtl: dword
	EXTRN	TssBase: dword
	EXTRN	OsHeapEnd: dword

	EXTRN	Field: byte

	EXTRN	AddExcTrap: near32
	EXTRN	StartTask: near32
	EXTRN	StopTask: near32
	EXTRN	HeapAllocMem: near32
	EXTRN	HeapAllocPage: near32
	EXTRN	LinearToPhysical: near32
	EXTRN	PointerToLinear: near32
	EXTRN	LeftFreePages: near32
	EXTRN	FocusToNextTask: near32
	EXTRN	SwitchFocusTo: near32
	EXTRN	NextTask: near32
	EXTRN	EmulateIret: near32
	EXTRN	Int13RetTrap: near32
	EXTRN	Int21RetTrap: near32
	EXTRN	DpmiSwitch: near32
	EXTRN	DpmiCallbackRet: near32
	EXTRN	TrapVideoPorts: near32
	EXTRN	RelGenDevPorts: near32
	EXTRN	TrapIo: near32
	EXTRN	DmaTimer: near32

	EXTRN	handled_exc: near32
	EXTRN	unhandled_exc: near32
	EXTRN	SimulateV86Int: near32
	EXTRN	RestoreVmState: near32
	EXTRN	XlatRet: near32
	EXTRN	CallRmCallback: near32
	EXTRN	RmCallbackRet: near32
	EXTRN	AltSaveState: near32
	EXTRN	AltRestoreState: near32

	EXTRN	GetScanCode: near32

IFDEF	FAKE_WINDOWS
	EXTRN	WinVendorEntry: near32
ENDIF

	EXTRN	XmsEntry: near32

DATA	SEGMENT	PARA	PUBLIC	USE16	'DATA'
; Call V86 data.
	SaveRegs	REG_PACK	<>
	CallPack	CALL_V86_INT	<>
	pV86Int		DD		?
	TempSi		DW		?
	RetAddr		DD		?

; Messages and other data.
	FreeMemMsg	DB	"Left free memory: ", 0

; Task switching data.
	PUBVAR		SliceTicks, DD, SLICE_TICKS
	SliceCount	DD	?
	PUBVAR		SystemTask, DD, 1

; Title data.
      	M32Title	DB	"Tripple-DOS - Black Phantom's DOS multitasker v0.50", 0
	M32Prompt	DB	"~Enter New Shell ~End Stop Task ~Tab Switch Foreground Task ~ESC - Quit", 0

; Task structure alloc error message.
	TaskStrucErrStr	DB	"Error allocating task structure!", 0
	StartTaskErrStr	DB	"Task could not be started!", 0

; Log file.
PUBLIC	M32LogName
	M32LogName	DB	"MULTIX32.LOG", 0
	PUBVAR	M32LogHandle, DD, ?
	PUBVAR	M32LogAddr, DD, ?
	PUBVAR	M32LogHead, DD, 0		; Log is a cyclic buffer.
	PUBVAR	M32LogTail, DD, 0

; If non 0, return to real mode will flush log.
	SystemTraps	DD	offset V86IntRet, offset SystemTaskRet
			DD	offset DpmiSwitches, offset DpmiV86CallbackRet
			DD	offset DpmiExcHandlerRet, offset DpmiDefExcHandler
			DD	offset DpmiDefIntHandler, offset DpmiPmCallbackRet
			DD	offset DpmiXlatRet, offset DpmiCallRmCallback
			DD	offset DpmiRmCallbackRet, offset DpmiWinVendorAPI
			DD	offset CallXmsEntry
			DD	offset DpmiRmSaveRestState, offset DpmiPmSaveRestState
SYSTEM_TRAPS	=	($ - offset SystemTraps) / 4

; Log messages.
	RmStateStr	DB	"Real mode "
	PmStateStr	DB	"Protected mode "
	SaveStateStr	DB	"save state: "
	RestoreStateStr	DB	"restore state: "

DATA	ENDS


STK	SEGMENT	PARA STACK	USE16	'STACK'
STK	ENDS


CODE	SEGMENT	PARA PUBLIC	USE16	'CODE'
ASSUME	CS:CODE, DS:DATA
;
; VM entry point for calling interrupt.
;
V86Entry::
; Get far pointer to interrupt. (FS=0)
	movzx	eax, al
	shl	eax, 2
	mov	eax, fs:[eax]
	mov	pV86Int, eax
; Save SI.
	push	si
; Set registers from DS:SI
	mov	eax, (CALL_V86_INT PTR [si]).stRegs.dwEax
	mov	ebx, (CALL_V86_INT PTR [si]).stRegs.dwEbx
	mov	ecx, (CALL_V86_INT PTR [si]).stRegs.dwEcx
	mov	edx, (CALL_V86_INT PTR [si]).stRegs.dwEdx
	mov	esi, (CALL_V86_INT PTR [si]).stRegs.dwEsi
	mov	edi, (CALL_V86_INT PTR [si]).stRegs.dwEdi
	mov	ebp, (CALL_V86_INT PTR [si]).stRegs.dwEbp
; Call V86 interrupt
	pushf
	call	pV86Int
; Restore SI.
	mov	TempSi, si
	pop	si
; Record registers - exception result.
	pushf
	pop	word ptr (CALL_V86_INT PTR [si]).stRegs.dwEflags
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEax, eax
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEbx, ebx
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEcx, ecx
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEdx, edx
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEdi, edi
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEbp, ebp
	mov	eax, esi
	mov	ax, TempSi
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEsi, eax

; Invalid opcode exception to return to protmode.
	DB	0FEh, 0FFh, 0, 0, 0, 0, 0, 1
CODE	ENDS


CODE32	SEGMENT	PARA	PUBLIC	USE32	'CODE'
ASSUME	CS:CODE32, DS:FLAT


;-----------------------------------------------------------------------------
;
;	I: INIT_DS:ESI -> interrupt calling structure
;	O: structure filled.
;
;	Remarks:
; * Swtiches to VM in the same environment as it started in RM. Mapping = 
; 1-to-1
; * Interrupt calling structure must be filled with appropriate to VM values.
; * Called V86 interrupt executes with I/O privileges (via TSS) and INT pri-
; vileges (to call another INT nn). Therefore, only trusted services should
; be called this way.
; * It will be called in the context of the current 16-bit segmented model.
; * Return to protmode will be via invalid opcode FE FF 00 00 00 00
;
;-----------------------------------------------------------------------------
InvokeV86Int	PROC
; Save registers.
	mov	SaveRegs.dwEax, eax
	mov	SaveRegs.dwEbx, ebx
	mov	SaveRegs.dwEcx, ecx
	mov	SaveRegs.dwEdx, edx
	mov	SaveRegs.dwEsi, esi
	mov	SaveRegs.dwEdi, edi
	mov	SaveRegs.dwEsp, esp
	mov	SaveRegs.dwEbp, ebp
; Switch to virtual mode.
	sub	eax, eax
	push	eax		; GS
	push	eax		; FS
	mov	ax, DATA
	push	eax		; DS
	push	eax		; ES
	mov	ax, STK
	push	eax		; SS
	push	VM_STK		; ESP
; Eflags reg., IOPL=0
	push	FL_VM		; IOPL = 0
	mov	ax, CODE
	push	eax		; CS
	mov	eax, offset V86Entry
	push	eax		; IP
	mov	al, (CALL_V86_INT PTR [esi]).bInt	; Int number
; Set registers from DS:ESI structure.
	iretd			; Switch to VM


; Entry point from invalid opcode handler.
PUBLIC	FromV86Entry
FromV86Entry::
; Restore segment registers.
	mov	ax, INIT_DS
	mov	ds, ax
	mov	es, ax
	mov	ax, FLAT_DS
	mov	fs, ax
	mov	gs, ax

; Restore other registers.
	mov	eax, SaveRegs.dwEax
	mov	ebx, SaveRegs.dwEbx
	mov	ecx, SaveRegs.dwEcx
	mov	edx, SaveRegs.dwEdx
	mov	esi, SaveRegs.dwEsi
	mov	edi, SaveRegs.dwEdi
	mov	esp, SaveRegs.dwEsp
	mov	ebp, SaveRegs.dwEbp

	ret	
InvokeV86Int	ENDP


;-----------------------------------------------------------------------------
;
;	I: AL = mode.
;
;	Sets video mode specified in AL using BIOS (InvokeV86Int).
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmSetVideoMode
PmSetVideoMode	PROC	USES	eax esi
	push	es
	push	edi
	push	ecx

	push	FLAT_DS
	pop	es

	mov	edi, 0B8000h
	mov	ecx, 2048
	mov	ax, 0720h
	cld
		rep	stos word ptr es:[edi]

	pop	ecx
	pop	edi
	pop	es
	ret

	mov	CallPack.bInt, 10h
	movzx	eax, al
	mov	CallPack.stRegs.dwEax, eax	; Bios function 0.
	mov	esi, offset CallPack
	call	InvokeV86Int
	ret
PmSetVideoMode	ENDP


;-----------------------------------------------------------------------------
;
;	I: DS:EAX -> file name.
;	   ECX = attributes.
;	O: CF = 0 - OK, EAX = file handle
;	      = 1 - error.
;
;	Creates a new file.
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmCreateFile
PmCreateFile	PROC	USES	ecx esi
	mov	CallPack.bInt, 21h
	mov	ch, 3Ch
	mov	CallPack.stRegs.dwEax, ecx	; Function #.
	mov	CallPack.stRegs.dwEdx, eax	; File name.
	mov	esi, offset CallPack
	call	InvokeV86Int
	test	CallPack.stRegs.dwEflags, FL_CF
	jz	@@F

	stc
	ret
@@@@:
	mov	eax, CallPack.stRegs.dwEax
	clc
	ret
PmCreateFile	ENDP


;-----------------------------------------------------------------------------
;
;	I: DS:EAX -> file name.
;	   ECX = attributes.
;	O: CF = 0 - OK, EAX = file handle
;	      = 1 - error.
;
;	Opens an existent file.
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmOpenFile
PmOpenFile	PROC	USES	ecx esi
	mov	CallPack.bInt, 21h
	mov	ch, 3Dh
	mov	CallPack.stRegs.dwEax, ecx	; Function #.
	mov	CallPack.stRegs.dwEdx, eax	; File name.
	mov	esi, offset CallPack
	call	InvokeV86Int
	test	CallPack.stRegs.dwEflags, FL_CF
	jz	@@F

	stc
	ret
@@@@:
	mov	eax, CallPack.stRegs.dwEax
	clc
	ret
PmOpenFile	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = handle
;	   ECX = position
;	   EDX = where (start/end/current).
;	O: CF = 0 - OK, EAX = new position.
;	      = 1 - error.
;
;	Seeks file for position.
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmSeekFile
PmSeekFile	PROC	USES	ecx edx esi
	mov	CallPack.bInt, 21h
	mov	dh, 42h
	mov	CallPack.stRegs.dwEax, edx	; Function #.
	mov	CallPack.stRegs.dwEbx, eax	; File handle.
	mov	CallPack.stRegs.dwEdx, ecx	; position low word.
	shr	ecx, 16
	mov	CallPack.stRegs.dwEcx, ecx	; position high word.
	mov	esi, offset CallPack
	call	InvokeV86Int
	test	CallPack.stRegs.dwEflags, FL_CF
	jz	@@F

	stc
	ret
@@@@:
	mov	eax, CallPack.stRegs.dwEcx
	shl	eax, 16
	mov	ax, word ptr CallPack.stRegs.dwEdx
	clc
	ret
PmSeekFile	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = handle
;	   DS:EDX -> data
;	   ECX = byte count
;	O: CF = 0 - OK,
;	      = 1 - error.
;
;	Writes file.
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmWriteFile
PmWriteFile	PROC	USES	eax esi
	mov	CallPack.bInt, 21h
	mov	CallPack.stRegs.dwEax, 4000h	; Function #.
	mov	CallPack.stRegs.dwEbx, eax	; File handle.
	mov	CallPack.stRegs.dwEdx, edx	; Pointer to data.
	mov	CallPack.stRegs.dwEcx, ecx	; Bytes count.

	mov	esi, offset CallPack
	call	InvokeV86Int

	test	CallPack.stRegs.dwEflags, FL_CF
	jz	@@F

	stc
	ret
@@@@:
	clc
	ret
PmWriteFile	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = handle
;	   DS:EDX -> data
;	   ECX = byte count
;	O: CF = 0 - OK,
;	      = 1 - error.
;
;	Writes file.
;
;	(!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmReadFile
PmReadFile	PROC	USES	eax esi
	mov	CallPack.bInt, 21h
	mov	CallPack.stRegs.dwEax, 3F00h	; Function #.
	mov	CallPack.stRegs.dwEbx, eax	; File handle.
	mov	CallPack.stRegs.dwEdx, edx	; Pointer to data.
	mov	CallPack.stRegs.dwEcx, ecx	; Bytes count.

	mov	esi, offset CallPack
	call	InvokeV86Int

	test	CallPack.stRegs.dwEflags, FL_CF
	jz	@@F

	stc
	ret
@@@@:
	clc
	ret
PmReadFile	ENDP


;-----------------------------------------------------------------------------
;
;	I: EAX = file handle.
;	O:
;
;	Closes file.
;
;-----------------------------------------------------------------------------
PUBLIC	PmCloseFile
PmCloseFile	PROC	USES	eax esi
	mov	CallPack.bInt, 21h
	mov	CallPack.stRegs.dwEax, 3E00h	; Function #.
	mov	CallPack.stRegs.dwEbx, eax	; File handle.

	mov	esi, offset CallPack
	call	InvokeV86Int

	ret
PmCloseFile	ENDP


;-----------------------------------------------------------------------------
;
;	Initializes core task (UI).
;
;-----------------------------------------------------------------------------
PUBLIC	InitCore
InitCore	PROC
; Set callback of INT 21h (keyboard interrupt).
	mov	eax, 21h
	mov	ecx, offset KbdCallback
	call	AddExcTrap

; Set callback of INT 20h (timer interrupt).
	mov	eax, 20h
	mov	ecx, offset TimerCallback
	call	AddExcTrap

; Set invalid opcode callback.
	mov	eax, 6
	mov	ecx, offset InvOpCallback
	call	AddExcTrap

; Set timer handler for DMA services.
;	mov	eax, 20h
;	mov	ecx, offset DmaTimer
;	call	AddExcTrap

; Trap keyboard ports in TSS.
	mov	eax, TssBase
	movzx	ecx, (Tss386 PTR fs:[eax]).IoTableBase
	or	byte ptr fs:[eax+ecx+60h/8], 00010001b

; Trap DMA ports in TSS.
	or	word ptr fs:[eax+ecx], 0FFFFh
;	or	dword ptr fs:[eax+ecx+0C0h/8], 0FFFFFFFFh
	or	word ptr fs:[eax+ecx+80h/8], 0FFFFh

; Trap PIC ports in TSS.
	or	byte ptr fs:[eax+ecx+20h/8], 00000011b
	or	byte ptr fs:[eax+ecx+0A0h/8], 00000011b

; Trap PIT ports in TSS.
	or	byte ptr fs:[eax+ecx+40h/8], 00001111b

; Trap FDC ports in TSS.
	or	word ptr fs:[eax+ecx+3F0h/8], 11111111b

; Install generic I/O emulator as GPF handler.
	mov	eax, 0Dh
	mov	ecx, offset TrapIo
	call	AddExcTrap

; Init basic ticks count.
	push	eax
	push	edx
	sub	edx, edx
	mov	eax, PIT_FREQUENCY
	div	TickToSec
	mov	ecx, eax
	pop	edx
	pop	eax

	sub	edx, edx
	mov	eax, 10000h
	div	ecx

	mov	TicksReport, eax ; Set number of ticks to report interrupt.

; Init slice counter.
	mov	SliceCount, 0

; Allocate task structure.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	mov	ecx, MAX_TASKS * SIZEOF DosTask
	call	HeapAllocMem
	jnc	@@F

; If can't allocate task structure, diagnose and quit.
	PM_PRINT_MSG	(offset TaskStrucErrStr)
	call	GetScanCode
	mov	QuitPm, 1
	jmp	core_entry

@@@@:
	mov	FirstTask, eax

	ret
InitCore	ENDP


;-----------------------------------------------------------------------------
;
;	Keyboard callback.
;
;-----------------------------------------------------------------------------
KbdCallback	PROC
	cmp	KeyReady, 0
	je	end_callback

	test	ShiftKeys, Kbd_LAlt OR Kbd_RAlt
	jz	end_callback

	mov	KeyReady, 0			; Key is read.
	mov	KeyExtCode, 0

	mov	al, KeyPressed
	cmp	al, 1
	jne	Enter?

; ESC pressed - quit.

exit:
	mov	QuitPm, 1
	mov	esp, Start32Esp
	jmp	core_entry

Enter?:
	cmp	al, 1Ch		; Enter?
	jne	F2?

; F1 pressed - start a new DOS task.
	call	StartTask
	jnc	no_report

; If returns, an error occured.
	PM_PRINT_MSG	(offset StartTaskErrStr)

	mov	SystemTask, 0
	jmp	no_report

F2?:
IFDEF	DEBUG_BUILD
	cmp	al, 3Ch		; F2?
	jne	F3?

; F2 pressed - test heap allocation.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE
	call	HeapAllocPage
	push	eax
; Print allocated page lin. address
	PM_PRINT_HEX32	, 40, 16, 13h

	call	LinearToPhysical

; Print allocated page lin. address
	PM_PRINT_HEX32	, 50, 16, 13h
	pop	eax

	mov	esi, 12345678h
	mov	fs:[eax], esi			; test write
	mov	esi, fs:[eax]			; Test read

	jmp	no_report

F3?:
	cmp	al, 3Dh
	jne	End?

; F3 pressed - report free memory.
	PM_PRINT_MSG	(offset FreeMemMsg)

	call	LeftFreePages

	shl	eax, 12
	PM_PRINT_HEX32	, (SIZEOF FreeMemMsg - 1)

	PM_PRINT_HEX32	ForegroundTask, (SIZEOF FreeMemMsg - 1) + 10
	PM_PRINT_HEX32	CurrentTask, (SIZEOF FreeMemMsg - 1) + 20
	PM_PRINT_HEX32	NumOfTasks, (SIZEOF FreeMemMsg - 1) + 30

; Check if any physical page is double mapped.
	pushad

	mov	ecx, OS_HEAP

set_page:
	mov	eax, ecx
	call	LinearToPhysical
	mov	esi, eax
	lea	edx, [ecx+1000h]
compare_page:
	mov	eax, edx
	call	LinearToPhysical
	mov	edi, eax

	add	edx, 1000h
	cmp	edx, OsHeapEnd
	jb	compare_page

	add	ecx, 1000h
	lea	ebx, [ecx+1000h]
	cmp	ebx, OsHeapEnd
	jb	set_page

	popad

	jmp	no_report

ENDIF	;DEBUG_BUILD
End?:
;	cmp	al, 3Eh		; F4?
	cmp	al, 4Fh		; End?
	jne	Tab?

; F4 pressed: stop current foreground task.
	mov	eax, ForegroundTask
	call	StopTask

	cmp	NumOfTasks, 0
	jne	no_report

; Jump to system task.
	mov	esp, Start32Esp
	jmp	core_start

Tab?:
;	cmp	al, 3Fh		; F5?
	cmp	al, 0Fh		; Tab?
	jne	end_callback
	
; F5 is pressed: switch focus and context to next task.
	cmp	NumOfTasks, 0
	je	no_report

	call	FocusToNextTask
	mov	SystemTask, 0

no_report:
	and	IrqReported, NOT 2		; Clear IRQ 1 reported bit.

end_callback:
	ret

KbdCallback	ENDP


;-----------------------------------------------------------------------------
;
;	Timer callback.
;
;-----------------------------------------------------------------------------
TimerCallback	PROC
	inc	SliceCount
	push	eax
	mov	eax, SliceTicks
	cmp	SliceCount, eax
	pop	eax
	jb	@@F

; If system task is running, no switch on timer.
	cmp	SystemTask, 0
	jne	@@F

	mov	SliceCount, 0
	call	NextTask
@@@@:
	stc
	ret
TimerCallback	ENDP


;-----------------------------------------------------------------------------
;
;	Invalid opcode callback.
;
;-----------------------------------------------------------------------------
PUBLIC	InvOpCallback
InvOpCallback	PROC
	test	ExcEflags, FL_VM
	jnz	@@F
	test	ExcSeg, 3
	jz	err_ret
@@@@:
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear

	cmp	dword ptr fs:[eax], 0000FFFEh
	jne	err_ret

	cmp	word ptr fs:[eax][4], 0
	jne	err_ret

	movzx	ebx, byte ptr fs:[eax][7]
	cmp	ebx, SYSTEM_TRAPS
	jnb	err_ret
	jmp	SystemTraps[ebx*4]

V86IntRet::
	cmp	byte ptr fs:[eax][6], 13h
	jne	@@F
	call	Int13RetTrap
	clc
	ret
@@@@:
	cmp	byte ptr fs:[eax][6], 21h
	jne	@@F
	call	Int21RetTrap
	clc
	ret
@@@@:
	jmp	err_ret

; Return from system service.
SystemTaskRet::
	jmp	FromV86Entry

; Dpmi switches.
DpmiSwitches::
	call	DpmiSwitch
	clc
	ret

; Trap return from interrupt redirected to V86 mode.
DpmiV86CallbackRet::
	call	DpmiCallbackRet
	clc
	ret

; Trap return from "exception handler".
DpmiExcHandlerRet::
	jmp	handled_exc

; Trap "default exception handler".
DpmiDefExcHandler::
	jmp	unhandled_exc

; Trap "default interrupt handler".
DpmiDefIntHandler::

; Get interrupt number.
	mov	si, ExcSeg
	mov	edi, ExcOffs
	mov	ebx, ExcEflags
	call	PointerToLinear
	movzx	ecx, byte ptr fs:[eax][6]

; Emulate IRET(d).
	mov	eax, CurrTaskPtr
	mov	eax, (DosTask PTR fs:[eax]).TaskFlags
	call	EmulateIret
    
; Simulate V86 interrupt.
	call	SimulateV86Int
	clc
	ret

; Trap return from PM int handler to VM.
DpmiPmCallbackRet::
	call	RestoreVmState
	clc
	ret

; Trap return from translation services call.
DpmiXlatRet::
	call	XlatRet
	clc
	ret

; Trap real mode callback breakpoint.
DpmiCallRmCallback::
	call	CallRmCallback
	clc
	ret

; Trap return from real mode callback handler.
DpmiRmCallbackRet::
	call	RmCallbackRet
	clc
	ret

; Simulate Windows 3.x vendor API entry point.
DpmiWinVendorAPI::
IFDEF	FAKE_WINDOWS
;	call	WinVendorEntry
	clc
	ret
ELSE
	jmp	err_ret
ENDIF

; Trap XMS server entry point.
CallXmsEntry::
	call	XmsEntry
	clc
	ret

; Trap real mode save / restore entry point.
DpmiRmSaveRestState::
; If called from protected mode, return error.
	test	ExcEflags, FL_VM
	jz	err_ret

IFDEF	LOG_DPMI
	pushad
	PRINT_LOG	RmStateStr
	popad
	LOG_STATE
ENDIF

; Set EBP point to protected mode save buffer.
	mov	ebp, CurrTaskPtr
	mov	ebp, (DosTask PTR fs:[ebp]).DpmiRmStack
	sub	ebp, SIZEOF DpmiState + 4
	jmp	common_save_rest

; Trap protected mode save / restore entry point.
DpmiPmSaveRestState::
; If called from V86 mode, return error.
	test	ExcEflags, FL_VM
	jnz	err_ret

IFDEF	LOG_DPMI
	pushad
	PRINT_LOG	PmStateStr
	popad
	LOG_STATE
ENDIF

; Set EBP point to real mode save buffer.
	mov	ebp, CurrTaskPtr
	mov	ebp, (DosTask PTR fs:[ebp]).DpmiPmStack
	sub	ebp, SIZEOF DpmiState + 4

common_save_rest:
	cmp	byte ptr ExcEax, 0	; AL = 0 means save state.
	jne	restore_state?

IFDEF	LOG_DPMI
	pushad
	PRINT_LOG	SaveStateStr
	popad
ENDIF
	call	AltSaveState
	clc
	ret

restore_state?:
	cmp	byte ptr ExcEax, 1	; AL = 1 means restore state.
	jne	err_ret			; AL not equal 0 or 1 is an error.

IFDEF	LOG_DPMI
	pushad
	PRINT_LOG	RestoreStateStr
	popad
ENDIF
	call	AltRestoreState
	clc
	ret

err_ret:
	stc
	ret
InvOpCallback	ENDP


;-----------------------------------------------------------------------------
;
;	Writes to log.
;
;	I:	DS:ESI -> log buffer
;		ECX = length.
;
;-----------------------------------------------------------------------------
PUBLIC	WriteLog
WriteLog	PROC	USES es eax ecx esi edi
IFDEF	DEBUG_BUILD
	call	TransmitLog
ENDIF
	ret

IF 0
	cld
	push	FLAT_DS
	pop	es
	mov	edi, M32LogTail

; Check if need to wrap log.
	add	edi, ecx
	cmp	edi, LOG_SIZE
	jnb	wrap_log

; Just copy log buffer.
	mov	M32LogTail, edi
	sub	edi, ecx
	add	edi, M32LogAddr
		rep	movsb
	ret

wrap_log:
; Copy wrapped log.
	mov	eax, ecx		; Keep number of bytes to copy.
	mov	edi, M32LogTail
	mov	ecx, LOG_SIZE
	sub	ecx, edi
	sub	eax, ecx		; Remained number of bytes.
	add	edi, M32LogAddr
		rep	movsb

; Copy second part of log.
	sub	edi, edi
	mov	ecx, eax
	add	edi, M32LogAddr
		rep	movsb

	sub	edi, M32LogAddr
	mov	M32LogTail, edi
	inc	edi
	mov	M32LogHead, edi

	ret
ENDIF

WriteLog	ENDP


IF 0
;-----------------------------------------------------------------------------
;
;	Writes log from memory to a log file.
;
;	(!) Must be executed in system context.
;
;-----------------------------------------------------------------------------
PUBLIC	FlushLog
FlushLog	PROC	USES eax ebx ecx edx esi edi
	mov	eax, offset M32LogName
	sub	ecx, ecx
	call	PmCreateFile
	mov	M32LogHandle, eax

	cld
; Check if log wrapped.
	mov	eax, M32LogTail
	cmp	eax, M32LogHead
	jb	log_wrapped

;
; Just write log.
;

; Copy <= 64 bytes to low memory.
write_more:
	mov	ecx, M32LogTail
	sub	ecx, M32LogHead
	cmp	ecx, 64
	jna	@@F
	mov	ecx, 64
@@@@:
	mov	esi, M32LogHead
	add	M32LogHead, ecx

	mov	ebx, ecx			; Keep number of bytes.

	mov	edi, offset Field
	add	esi, M32LogAddr
		rep	movs byte ptr es:[edi], fs:[esi]

	mov	eax, M32LogHandle
	mov	edx, offset Field
	mov	ecx, ebx
	call	PmWriteFile

	cmp	ebx, 64
	jnb	write_more

	mov	M32LogHead, 0
	mov	M32LogTail, 0

	mov	eax, M32LogHandle
	call	PmCloseFile

	ret

;
; Write log in two stages.
;
log_wrapped:
write_more_wrapped:
	mov	ecx, LOG_SIZE
	sub	ecx, M32LogHead
	cmp	ecx, 64
	jna	@@F
	mov	ecx, 64
@@@@:
	mov	esi, M32LogHead
	add	M32LogHead, ecx

	mov	ebx, ecx			; Keep number of bytes.

	mov	edi, offset Field
	add	esi, M32LogAddr
		rep	movs byte ptr es:[edi], fs:[esi]

	mov	eax, M32LogHandle
	mov	edx, offset Field
	mov	ecx, ebx
	call	PmWriteFile

	cmp	ebx, 64
	jnb	write_more_wrapped

	mov	M32LogHead, 0
	jmp	write_more			; Write not wrapped part.

FlushLog	ENDP
ENDIF	; 0


;-----------------------------------------------------------------------------
;
;	Initializes COM 1 port.
;
;-----------------------------------------------------------------------------
PUBLIC	InitCom1
InitCom1	PROC

; Initialize LCR.
	mov	edx, fs:[400h + (LOG_COM - 1) * 2 ]		; Get base port for COM1 set by BIOS.
	add	edx, 3
	mov	al, 10000011b		; no parity, 1 stop bit, 8 bits/char, 
					; select divisor LSB/MSB.
	out	dx, al
	sub	edx, 3

; Initialize divisor for 9600 bits/sec.
	mov	eax, 12			; Divisor = 12.
	out	dx, ax

; Set LCR to transmit/receive.
	add	edx, 3
	mov	al, 00000011b		; Set mode to transmit and disable ints.
	out	dx, al
	sub	edx, 3

	ret
InitCom1	ENDP


;-----------------------------------------------------------------------------
;
;	Transmits log to remote terminal.
;
;	I: DS:ESI -> buffer
;	   ECX = length.
;
;	(!) All regs but EDX saved by caller.
;
;-----------------------------------------------------------------------------
TransmitLog	PROC	USES edx

; Wait for line ready.
@@@@:
	mov	edx, fs:[400h + (LOG_COM - 1) * 2]
	add	edx, 5
	in	al, dx
	test	al, 00100000b			; Transmit holder empty?
	jz	@@B				; No, wait.

	lodsb
	mov	edx, fs:[400h + (LOG_COM - 1) * 2]
	out	dx, al				; Send

	dec	ecx
	jnz	@@B				; Next

	ret
TransmitLog	ENDP


;-----------------------------------------------------------------------------
;
;	System loop (when there are no running tasks).
;
;-----------------------------------------------------------------------------
PUBLIC	core_start
core_start	PROC
	mov	SystemTask, 1
	sub	eax, eax
	call	TrapVideoPorts	; Enable access to video ports.
	call	RelGenDevPorts	; Enable access to general devices ports.

; Set video mode.
	mov	al, VIDEO_MODE
	call	PmSetVideoMode

	PM_PRINT_CENTERED_STR	(offset M32Title), 0, COLS_PER_ROW - 1, TITLE_ROW, TITLE_ATTR
	PM_PRINT_CENTERED_STR	(offset M32Prompt), 0, COLS_PER_ROW - 1, PROMPT_ROW, TITLE_ATTR

PUBLIC	core_entry
core_entry::
	mov	eax, SysPdbLin
	mov	PdbLin, eax
	mov	eax, SysPagesCtl
	mov	PagesCtl, eax
	mov	eax, SysPdb
	mov	Pdb, eax
	mov	cr3, eax
core_loop:
	sti
; If Mode0 is non-0 (1), set mode 0 via InvokeV86Int
	cmp	QuitPm, 0
	je	core_loop
EXTRN	end_pmode: near32
	jmp	end_pmode
core_start	ENDP


CODE32	ENDS
END
@


0.52
log
@Stack segment for Tripple-DOS changed to 32-bit default. 16-bit stack didn't work with DPMI clients that set up stack to 32 bits and ESP > 64K! Now DJGPP stubbed programs work, but there is some problem when they return.
@
text
@d12 1
a12 1
; law, shall Vadim Drubetsky aka the Black Phantoms be liable for any special,
d53 1
d134 1
d583 9
a591 1
	mov	ecx, (PIT_FREQUENCY / PIT_TICK_TO_SEC)	; ECX = ticks count.
d773 4
a776 1
	cmp	SliceCount, SLICE_TICKS
@


0.51
log
@Added general devices synchronization mechanism.
It's implemented for COM1 and COM2.
It causes problems with a keyboard.
@
text
@@


0.50
log
@Fixed HDD/FDD synchronization problem (trapped opcodes were overwriting each other).
@
text
@d99 1
d727 1
d984 1
d986 1
d1198 2
@


0.49
log
@Fixes version includes:
1) variable mapping of DPMI service pages at C0000, D0000, E0000 instead of a hardcoded address.
2) added 2 32-bit XMS functions and XMS service table is fixed.
3) detection and diagnostic is improved.
@
text
@d136 1
a136 1
      	M32Title	DB	"Tripple-DOS - Black Phantom's DOS multitasker v0.49", 0
@


0.48
log
@Enabled XMS 3.0 inteface
@
text
@d112 2
d136 1
a136 1
      	M32Title	DB	"Tripple-DOS - Black Phantom's DOS multitasker v0.48", 0
d596 1
d598 3
a600 1
	ret
@


0.47
log
@DMA partial virtualization is made - Tripple DOS now works with floppy!
@
text
@d134 1
a134 1
      	M32Title	DB	"Tripple-DOS - Black Phantom's DOS multitasker v 0.45", 0
@


0.46
log
@Fixed a bug that didn't allow Tripple DOS work with DOS loaded HIGH
@
text
@d100 1
d135 1
a135 1
	M32Prompt	DB	"^F1 New Shell ^F4 Stop Task ^F5 Switch Foreground Task ^ESC - Quit", 0
d547 5
d558 3
a560 1
;	or	word ptr fs:[eax+ecx], 0FFFFh
d569 3
d613 1
a613 1
	test	ShiftKeys, Kbd_LCtrl OR Kbd_RCtrl
d621 1
a621 1
	jne	F1?
d630 2
a631 2
F1?:
	cmp	al, 3Bh		; F1?
d645 1
d670 1
a670 1
	jne	F4?
d712 5
a716 3
F4?:
	cmp	al, 3Eh
	jne	F5?
d728 3
a730 2
F5?:
	cmp	al, 3Fh
d766 1
@


0.45
log
@The shareware beta release
@
text
@d154 1
a154 1
			DD	offset DpmiRmCallbackRet, DpmiWinVendorAPI
d304 18
d552 1
a552 1
	or	word ptr fs:[eax+ecx], 0FFFFh
@


0.44
log
@Bug fixes:
1) Checks for open file name (EDX to DX) problem
2) Reporting of the protected mode exception reboot
@
text
@d3 19
d25 1
a25 1
;	MULTIX32 system core.
d133 2
a134 2
	M32Title	DB	"Black Phantom's MULTIX32 DOS multitasker", 0
	M32Prompt	DB	"^F1 New Shell ^F3 Report Free Mem ^F4 Stop Task ^F5 Switch Foreground Task", 0
d533 1
a533 1
; Trap DMA port in TSS.
d536 4
d543 1
a543 1
; Install keyboard I/O emulator as GPF handler.
d607 1
@


0.43
log
@Bug fixes:
1) Lower word in translation structure on real mode stack was being destroyed - very annoying.
2) Saved exception number was moved to task structure to allow multiple DPMI tasks work.
3 copies of WCC386 worked!
@
text
@d18 1
a32 1
	EXTRN	TickCount: dword
d34 1
a34 1
	EXTRN	ExcEflags: dword
d37 14
d80 1
a80 2
	EXTRN	EmulateKbdIo: near32
	EXTRN	EmulateVideoIo: near32
d89 2
d137 1
d140 6
d517 3
d522 1
a522 1
	mov	ecx, offset EmulateKbdIo
d525 1
a525 1
; Init ticks count.
a531 1
	mov	TickCount, 0
a547 5
; Task array created. Add GPF trap.
	mov	eax, 0Dh
	mov	ecx, offset EmulateVideoIo
	call	AddExcTrap

d766 1
a766 1
; Trap return from callback.
d783 7
d791 2
a792 2
	mov	ecx, CurrTaskPtr
	mov	eax, (DosTask PTR fs:[ecx]).TaskFlags
d806 1
d809 1
a809 4

EXTRN	CheckPt:byte
inc CheckPt

d812 1
d818 1
d824 1
d827 1
a827 1
	call	WinVendorEntry
d834 1
d840 63
d1069 1
a1069 1
	mov	edx, fs:[400h]		; Get base port for COM1 set by BIOS.
d1076 2
a1077 2
; Initialize divisor for 115200 bits/sec.
	mov	eax, 1			; Divisor = 1.
d1104 1
a1104 1
	mov	edx, fs:[400h]
d1111 1
a1111 1
	mov	edx, fs:[400h]
@


0.42
log
@1) Added XMS server
2) XMS server is on top DPMI memory manager, so DPMI memory handln are moved
@
text
@d121 1
a121 1
			DD	offset XmsEntry
d807 5
d978 2
a979 1
	mov	edx, 3FBh
d983 1
a985 1
	mov	edx, 3F8h
d990 4
a993 3
	mov	edx, 3FBh
	mov	eax, 00000011b		; Set mode to transmit and disable ints.
	out	dx, ax
d1013 2
a1014 1
	mov	edx, 3FDh
a1018 1
; Send character.
d1020 1
a1020 1
	mov	edx, 3F8h
@


0.41
log
@Bug fixes:
1) Virtual I/O jump table (very annoying!)
2) IsFileOpen() bug if file name is 0.
@
text
@d17 1
d26 1
d47 2
d52 1
a53 1
	EXTRN	HeapAllocMem: near32
d67 1
d77 3
a79 3
	INCLUDE	DEBUG.INC

	EXTRN	PmClearRow: near32
d81 1
d102 4
d107 1
d109 4
a112 1
	M32LogHandle	DW	?
d114 1
d120 2
a121 1
			DD	offset DpmiRmCallbackRet
d512 17
d565 4
d656 1
a656 1

d666 1
d668 1
a669 1
	ret
d774 1
a774 1
; Trap return from PM to VM.
d782 4
d790 1
d795 1
d798 9
d811 210
@


0.40
log
@DPMI server fixes:
1) Locker real mode and protected mode stacks usage fixed: reentrancy allowed.
2) Modes switches fixed.
@
text
@d476 3
d661 1
@


0.39
log
@Bug fixed: raw mode switches.
@
text
@@


0.38
log
@Bugs fixed:
1) PointerToLinear() check
2) Default interrupt redirection to V86 mode
@
text
@@


0.37
log
@Bug fixed: reflecting PM to VM interrupt.
@
text
@d11 6
a16 5
			INCLUDE	CORE.INC
			INCLUDE	X86.INC
			INCLUDE	DEVICES.INC
			INCLUDE	PHLIB32.MCR
			INCLUDE	DEF.INC
d26 1
d56 1
d717 1
a717 1
	je	unhandled_exc
d721 7
@


0.36
log
@Bug fixes:
1) CreatePageTable() called from HeapAllocMem()
2) Zero allocated PDB for new task
@
text
@@


0.35
log
@HeapAllocMem() bug fixed; free DPMI memory allocated fixed.
@
text
@d160 1
@


0.34
log
@Bug fixes:
1) Initial pages map allocation
2) Translation services params
3) DPMI clean up memory release -- almost
4) INT 21h AH=4Ch in protected mode.
@
text
@d41 1
d566 27
@


0.33
log
@Initial full release - all DPMI functions are written! Half are not tet.
@
text
@@


0.32
log
@Translation services work.
@
text
@d64 4
a67 2
	EXTRN	XlatRet: near
	
d100 3
a102 2
			DD	offset DpmiXlatRet
SYSTEM_TRAPS	=	9
d701 8
a708 1
	clc
@


0.31
log
@1) Interrupt redirection works
2) HeapAllocMem() bug fixes
DPMI traps fixed
@
text
@d64 1
d97 3
a99 2
			DD	offset DpmiDefIntHandler, offset DpmPmCallbackRet
SYSTEM_TRAPS	=	8
d691 1
a691 1
DpmPmCallbackRet::
d693 5
@


0.30
log
@DOS block functions are written and work. Callback to real mode mechanism established. Tests are still brief.
@
text
@d48 1
d60 5
d67 1
a67 1
EXTRN	PmClearRow: near32
d93 6
d623 2
d626 5
a631 3
	movzx	eax, ExcSeg
	shl	eax, 4
	add	eax, ExcOffs
d638 4
a641 3
; Check for return from system service.
	cmp	word ptr fs:[eax][6], 100h
	je	FromV86Entry
d643 2
a644 2
; Check for returning INT 13h semaphore.
	cmp	word ptr fs:[eax][6], 0013h
d650 1
a650 1
	cmp	word ptr fs:[eax][6], 0021h
d656 6
a661 2
	cmp	byte ptr fs:[eax][7], 02h
	jne	@@F
d663 1
d667 1
a667 3
@@@@:
	cmp	byte ptr fs:[eax][7], 03h
	jne	@@F
d669 1
d674 19
a692 1
@@@@:
@


0.29
log
@First DPMI selector functions work (Hello, world).
@
text
@d55 1
d645 8
@


0.28
log
@Initial DPMI switch works.
@
text
@@


0.27
log
@Solves INT 28 block problems (doesn't lock).
@
text
@d6 1
a6 4
;	Core MULTIX32 management servers.
;	1) Memory manager
;	2) Task manager
;	3) System calls manager
d54 1
d635 7
@


0.26
log
@Bugs fixed:
1) Store open file name
2) Store DOS function per process
3) Imperfect INT 13 semaphore handling.
@
text
@@


0.25
log
@Fixed bug in IsFileOpen proc.
@
text
@d55 1
a55 1
	EXTRN	Int13Sema4s: near32
d630 1
a630 6

	sub	eax, eax
	movzx	ecx, ExcSeg
	shl	ecx, 4
	add	ecx, ExcOffs
	call	Int13Sema4s
@


0.24
log
@Removed unnecessary dynamic allocations.
@
text
@a556 4
	cmp	NumOfTasks, 1
	je	@@F

	call	FocusToNextTask
d558 2
a559 10
	jmp	no_report
@@@@:
	mov	ecx, SysPdbLin
	mov	PdbLin, ecx
	mov	ecx, SysPagesCtl
	mov	PagesCtl, ecx
	mov	ecx, SysPdb
	mov	Pdb, ecx
	mov	cr3, ecx
	call	StopTask
@


0.23
log
@1) File sharing handled.
@
text
@@


0.22
log
@1) Fully split task blocking and waiting for event.
2) Annoying bug fixed (TASK_PTR).
@
text
@@


0.21
log
@1) Inproved task state handling (nesting allowed due to bit mask).
2) TASK_PTR macro used.
3) Bugs fixed.
4) X86.MCR is out of project.
@
text
@@


0.20
log
@Task locks on wait for events are added.
@
text
@d56 1
d648 6
@


0.19
log
@Trap wait on keyboard (INT 16h / 0, 10h).
Bug fixes in memory allocation.
@
text
@@


0.18
log
@Keyboard virtualized.
File I/O interface for kernel is added.
@
text
@a470 16
; Create log file.
	mov	eax, offset M32LogName
	sub	ecx, ecx
	call	PmCreateFile
	mov	M32LogHandle, ax

; Write something.
	mov	ax, M32LogHandle
	mov	edx, offset M32Title
	mov	ecx, SIZEOF M32Title
	call	PmWriteFile

; Close log file.
	mov	ax, M32LogHandle
	call	PmCloseFile

@


0.17
log
@Int 13h locking improvements, bug fixes (NC running)
@
text
@d43 1
d57 1
d77 1
a77 1
	PUBVAR		SystemTask, DD, 0
d83 4
d122 2
a123 2
	pushfd
	pop	(CALL_V86_INT PTR [si]).stRegs.dwEflags
d178 2
a179 2
; Eflags reg., IOPL=3
	push	FL_VM OR 3000h	; IOPL = 3
d220 1
a220 1
; (!) System context.
d236 193
d449 10
d470 16
@


0.16
log
@Debug improvements (commands); VGA ports partial virtualizing
@
text
@a338 1

d372 3
d396 4
d464 1
@


0.15
log
@Debug improvements: hardware breakpoint
@
text
@a59 2
EXTRN	GetDbgCmd: near32
EXTRN	DbgCommand: Dbg_COMMAND
d124 3
a126 2
	mov	si, TempSi
	mov	(CALL_V86_INT PTR [si]).stRegs.dwEsi, esi
@


0.14
log
@Bug fixes; debug improvements
@
text
@@


0.13
log
@Proper CPL 0 stack management; foreground task boost on event
@
text
@d57 7
d452 1
a452 1
	call	TrapVideoPorts		; Enable access to video ports.
@


0.12
log
@Bug fixes: 5th task, VGA co40/co80 restore
@
text
@@


0.11
log
@Memory allocation enhance; bug fixes
@
text
@d301 2
a302 8
	mov	ecx, 25000h

	call	HeapAllocMem
	mov	dh, 16
	mov	dl, 0
@@@@:
	pushad
	lea	eax, [eax+ecx-1000h]
d304 1
a304 1
	PM_PRINT_HEX32	, , , 13h
d309 2
a310 3
	PM_PRINT_HEX32	, , , 13h

	popad
d313 2
a314 2
	mov	fs:[eax+ecx-1000h], esi			; test write
	mov	esi, fs:[eax+ecx-1000h]			; Test read
a315 3
	sub	ecx, 1000h
	jnz	@@B

d333 1
@


0.10
log
@VGA save/restore state fixed; bug fixes
@
text
@d22 4
a25 3
	EXTRN	KeyReady:byte
	EXTRN	KeyPressed:byte
	EXTRN	KeyExtCode:byte
a29 1
	EXTRN	Pdb: dword
d37 7
d48 1
d55 1
d73 2
a74 5
	M32Title	DB	(80 - SIZEOF M32Title) / 2 DUP (" ")
	M32Title1	DB	"Black Phantom's MULTIX32 DOS multitasker"
			DB	80 - (80 - SIZEOF M32Title) / 2 DUP (" "), 0

	M32Prompt	DB	" F1 - New Shell F3 - Report Free Mem F4 - Stop Task F5 - Switch Foreground Task "
d269 3
a281 2
	mov	eax, Pdb
	mov	cr3, eax
d284 1
a284 1
	jmp	core_loop
d301 1
a301 1
	call	HeapAllocPage
d303 6
a308 2
	push	eax

d310 1
a310 1
	PM_PRINT_HEX32	, 40, 16, 13h
d315 1
a315 1
	PM_PRINT_HEX32	, 50, 16, 13h
d317 1
a317 1
	pop	eax
d319 7
a325 2
	mov	ecx, fs:[eax]			; Test read
	mov	fs:[eax], ecx			; test write
a342 1

a353 1
	push	eax
a354 2
	pop	eax
	mov	ecx, cr3
a355 1
	mov	cr3, ecx
d358 7
a367 2
	mov	eax, Pdb
	mov	cr3, eax
d369 1
a369 1
	jmp	pmode_loop
d450 2
a451 2
PUBLIC	pmode_loop
pmode_loop	PROC
d453 2
d459 12
a470 2
	PM_PRINT_STR	(offset M32Title), 0, TITLE_ROW, TITLE_ATTR
	PM_PRINT_STR	(offset M32Prompt), 0, PROMPT_ROW, TITLE_ATTR
a471 1
core_loop::
d477 1
a477 1
pmode_loop	ENDP
@


0.9
log
@VGA state save/restore
@
text
@d18 1
d61 1
d272 3
d277 1
a277 1
	jmp	pmode_loop
d285 1
d350 2
d361 1
d436 1
d444 1
a444 1
core_loop:
@


0.8
log
@Synchronization of system services; bug fixes
@
text
@a46 1

a67 9
; Video save/restore state buffer.
PUBLIC	VSaveHw
	VSaveHw		DB	100h DUP (?)
PUBLIC	VSaveBIOSMem
	VSaveBIOSMem	DB	96 DUP (?)
PUBLIC	VSaveClr
	VSaveClr	DB	400h DUP (?)
	
	TempEsp		DD	?
a215 75
;	I:
;	O:
;
; (!) System context.
;
;-----------------------------------------------------------------------------
PUBLIC	PmSaveVideoState
PmSaveVideoState	PROC	USES es esi
; Save H/W state.
	mov	CallPack.bInt, 10h
	mov	CallPack.stRegs.dwEax, 1C01h
	mov	CallPack.stRegs.dwEcx, 1
	mov	CallPack.stRegs.dwEbx, offset VSaveHw
	mov	CallPack.stSregs.wEs, DATA
	mov	esi, offset CallPack
	call	InvokeV86Int
; Save video BIOS memory.
;	mov	CallPack.bInt, 10h
;	mov	CallPack.stRegs.dwEax, 1C01h
;	mov	CallPack.stRegs.dwEcx, 2
;	mov	CallPack.stRegs.dwEbx, offset VSaveBIOSMem
;	mov	CallPack.stSregs.wEs, DATA
;	call	InvokeV86Int
; Save color state.
	mov	CallPack.bInt, 10h
	mov	CallPack.stRegs.dwEax, 1C01h
	mov	CallPack.stRegs.dwEcx, 4
	mov	CallPack.stRegs.dwEbx, offset VSaveClr
	mov	CallPack.stSregs.wEs, DATA
	mov	esi, offset CallPack
	call	InvokeV86Int
	call	PmRestoreVideoState
	ret
PmSaveVideoState	ENDP


;-----------------------------------------------------------------------------
;
;	I:
;	O:
;
;-----------------------------------------------------------------------------
PUBLIC	PmRestoreVideoState
PmRestoreVideoState	PROC	USES es esi
; Restore H/W state.
	mov	CallPack.bInt, 10h
	mov	CallPack.stRegs.dwEax, 1C02h
	mov	CallPack.stRegs.dwEcx, 1
	mov	CallPack.stRegs.dwEbx, offset VSaveHw
	mov	CallPack.stSregs.wEs, DATA
	mov	esi, offset CallPack
	call	InvokeV86Int

; Restore video BIOS memory.
;	mov	CallPack.bInt, 10h
;	mov	CallPack.stRegs.dwEax, 1C02h
;	mov	CallPack.stRegs.dwEcx, 2
;	mov	CallPack.stRegs.dwEbx, offset VSaveBIOSMem
;	mov	CallPack.stSregs.wEs, DATA
;	call	InvokeV86Int
; Restore color state.
	mov	CallPack.bInt, 10h
	mov	CallPack.stRegs.dwEax, 1C02h
	mov	CallPack.stRegs.dwEcx, 4
	mov	CallPack.stRegs.dwEbx, offset VSaveClr
	mov	CallPack.stSregs.wEs, DATA
	mov	esi, offset CallPack
	call	InvokeV86Int

	ret
PmRestoreVideoState	ENDP


;-----------------------------------------------------------------------------
;
d261 3
d269 1
a269 2
	mov	eax, Pdb
	mov	cr3, eax
a356 1
	mov	KeyReady, 0			; Key is read.
@


0.7
log
@Working preemptive multitasking. Interrupts are reported to ALL tasks. Different tasks cannot work with the same device
@
text
@d32 3
d40 1
d45 1
d61 17
d125 1
a125 3
	DB	0FEh, 0FFh, 0, 0, 0, 0
	DD	offset	FromV86Entry
	DW	CODE_32
a148 1
	pop	RetAddr
d199 1
a199 1
	sti
d210 2
d214 1
a214 1
PmSetVideoMode	PROC
d226 75
d316 4
a319 3
; Set video mode.
	mov	al, VIDEO_MODE
	call	PmSetVideoMode
d351 2
a354 1
EXTRN	pmode_loop: near32
a377 1
EXTRN	LinearToPhysical: near32
d411 9
a419 2
; F4 pressed: stop current task.
	mov	eax, CurrentTask
d421 1
a421 4
	cmp	NumOfTasks, 0
	je	jump_to_system
	mov	eax, NumOfTasks
	call	SwitchFocusTo
d423 2
a425 1
jump_to_system:
a427 1
	sti
a431 20
	jne	F6?

; F5 pressed: test HeapAllocPage.
	mov	eax, PAGE_PRESENT OR PAGE_WRITABLE OR PAGE_USER
	call	HeapAllocPage
	pushad
	PM_PRINT_HEX32	, 0, 0, 7
	popad
	pushad
	call	LinearToPhysical
	PM_PRINT_HEX32	, 10, 0, 7
	popad
; Test read.
	mov	cl, fs:[eax]
; Test write.
	mov	fs:[eax], cl
	jmp	no_report

F6?:
	cmp	al, 40h
d434 1
a434 1
; F6 is pressed: switch focus and context to next task.
d441 1
d461 64
@


0.7.0.1
log
@Attempt to synchronize disks with semaphores
@
text
@a31 3
	EXTRN	ExcEflags: dword
	EXTRN	ExcSeg: word
	EXTRN	ExcOffs: dword
a40 1
	EXTRN	Int13Sema4s: near32
a55 8

; Title data.
	M32Title	DB	(80 - SIZEOF M32Title) / 2 DUP (" ")
	M32Title1	DB	"Black Phantom's MULTIX32 DOS multitasker"
			DB	80 - (80 - SIZEOF M32Title) / 2 DUP (" "), 0

	M32Prompt	DB	" F1 - New Shell F3 - Report Free Mem F4 - Stop Task F5 - Switch Foreground Task "
	
d103 3
a105 1
	DB	0FEh, 0FFh, 0, 0, 0, 0, 0, 1
d220 3
a222 4
; Set invalid opcode callback.
	mov	eax, 6
	mov	ecx, offset InvOpCallback
	call	AddExcTrap
d256 1
d314 2
a315 9
; F4 pressed: stop current foreground task.
	mov	eax, ForegroundTask
	cmp	NumOfTasks, 1
	je	@@F

	push	eax
	call	FocusToNextTask
	pop	eax
	mov	ecx, cr3
d317 4
a320 1
	mov	cr3, ecx
a321 2
@@@@:
	call	StopTask
d323 1
d331 20
d353 1
a353 1
; F5 is pressed: switch focus and context to next task.
a378 63


;-----------------------------------------------------------------------------
;
;	Invalid opcode callback.
;
;-----------------------------------------------------------------------------
InvOpCallback	PROC
	test	ExcEflags, FL_VM
	jz	err_ret

	movzx	eax, ExcSeg
	shl	eax, 4
	add	eax, ExcOffs
	cmp	dword ptr fs:[eax], 0000FFFEh
	jne	err_ret

	cmp	word ptr fs:[eax][4], 0
	jne	err_ret

; Check for return from system service.
	cmp	word ptr fs:[eax][6], 100h
	ja	err_ret
	je	FromV86Entry

; Check for return from interrupt with semaphore.
	cmp	byte ptr fs:[eax][6], 13h
	jne	@@F
	sub	eax, eax
	movzx	ecx, ExcSeg
	shl	ecx, 4
	add	ecx, ExcOffs
	call	Int13Sema4s
	clc
	ret
@@@@:

err_ret:
	stc
	ret
InvOpCallback	ENDP


;-----------------------------------------------------------------------------
;
;	System loop (when there are no running tasks).
;
;-----------------------------------------------------------------------------
PUBLIC	pmode_loop
pmode_loop	PROC
; Set video mode.
	mov	al, VIDEO_MODE
	call	PmSetVideoMode

	PM_PRINT_STR	(offset M32Title), 0, TITLE_ROW, TITLE_ATTR
	PM_PRINT_STR	(offset M32Prompt), 0, PROMPT_ROW, TITLE_ATTR
core_loop:
; If Mode0 is non-0 (1), set mode 0 via InvokeV86Int
	cmp	QuitPm, 0
	je	core_loop
EXTRN	end_pmode: near32
	jmp	end_pmode
pmode_loop	ENDP
@


0.6
log
@Working non-preemptive multitasking
@
text
@d16 1
d19 1
a19 1
	EXTRN	InitStkSel: WORD
d24 8
a31 6
	EXTRN	Start32Esp: DWORD
	EXTRN	CurrentTask: DWORD
	EXTRN	ForegroundTask: DWORD
	EXTRN	NumOfTasks: DWORD
	EXTRN	Pdb: DWORD
	EXTRN	IrqReported: DWORD
d39 1
d53 3
d215 5
d224 12
d317 7
d363 16
@


0.5
log
@Working V86 emulation version!
@
text
@d13 1
d16 21
a37 1
EXTRN	InitStkSel:	WORD
d40 1
d44 5
d51 1
d55 1
a57 1
.486p
d67 2
a69 2
	push	(CALL_V86_INT PTR [si]).stRegs.dwEflags
	popfd
d80 16
a95 1
; Invalid exception to return to protmode.
d97 2
d103 1
a103 1
ASSUME	CS:CODE32, DS:DATA
d122 1
a122 1
	push	es
a131 2
	pushfd
	pop	SaveRegs.dwEflags
a141 1
	pushfd
d143 1
a143 2
	or	dword ptr [esp], FL_VM OR 3000h OR FL_IF ; IOPL = 3
	and	dword ptr [esp], NOT FL_IF		; CLI
d148 1
a148 1
	mov	al, (CALL_V86_INT PTR [si]).bInt	; Int number
d160 5
a164 4
	mov	ss, InitStkSel
; Restore registers.
	push	SaveRegs.dwEflags
	popfd
d173 1
a173 1
	pop	es
d194 138
@


0.4
log
@First V86 emulation version
@
text
@@


0.3
log
@Port of previous version for 32 bits.
@
text
@d56 2
a57 1
CODE32	SEGMENT	BYTE PUBLIC	USE32	'CODE'
d101 2
a102 1
	or	dword ptr [esp], FL_VM OR 3000h OR FL_IF
@


0.2
log
@Initial check-in; support for BIOS calls in V86 mode
@
text
@d27 1
a27 1
CODE	SEGMENT	PARA	PUBLIC	USE16	'CODE'
d30 28
d61 1
a61 1
;	I: INIT_DS:SI -> interrupt calling structure
d75 1
a75 1
InvokeV86Int	PROC	near
d97 1
a97 1
	push	SaveRegs.dwEsp	; ESP
d108 1
a108 21
V86Entry::
; Get far pointer to interrupt. (FS=0)
	movzx	eax, al
	shl	eax, 2
	mov	eax, fs:[eax]
	mov	pV86Int, eax
; Set registers from DS:SI
	push	(CALL_V86_INT PTR [si]).stRegs.dwEflags
	popfd
	mov	eax, (CALL_V86_INT PTR [si]).stRegs.dwEax
	mov	ebx, (CALL_V86_INT PTR [si]).stRegs.dwEbx
	mov	ecx, (CALL_V86_INT PTR [si]).stRegs.dwEcx
	mov	edx, (CALL_V86_INT PTR [si]).stRegs.dwEdx
	mov	esi, (CALL_V86_INT PTR [si]).stRegs.dwEsi
	mov	edi, (CALL_V86_INT PTR [si]).stRegs.dwEdi
	mov	ebp, (CALL_V86_INT PTR [si]).stRegs.dwEbp
; Call V86 interrupt
	pushf
	call	pV86Int
; Invalid exception to return to protmode.
	DB	0FEh, 0FFh, 0, 0, 0, 0
a128 1

d142 1
a142 1
PmSetVideoMode	PROC	near
d152 1
a152 1
CODE	ENDS
@
