; utility for manipulating speedstep setting on Intel CPUs under DOS

        BITS 16
        ORG 0x100

        push cs
        pop ds

        cld

        mov dx,msg
        mov ah,9
        int 0x21

        mov ecx,0x000001A0      ; misc enable
        rdmsr
        or eax,0x00010000
        wrmsr

        mov ecx,0x00000198      ; status
        rdmsr
        mov [temp1],eax
        mov [temp3],edx

        ; check for valid command line arg
        mov bl,[0x80]
        cmp bl,0
        jz showstatus
        mov si,0x81
        xor dx,dx
        mov cl,4
a103:
        lodsb
        cmp al,32
        jz a104
        cmp al,48
        jb showstatus
        cmp al,57
        jb a105
        and al,0xDF
        sub al,7
        cmp al,63
        ja showstatus
a105:
        ; got a hex digit
        and al,15
        add dl,al
        dec cl
        jz a106
        sal dx,4
        jmp a103
a106:
        ; parsed the whole value, now set registers
        push dx
        mov ecx,0x00000199      ; perf control
        rdmsr
        pop ax
        wrmsr
        jmp exit

a104:
        dec bl
        jnz a103

showstatus:
        ; temp1=current, temp3=max, temp4=startup
        mov ax,[temp1]
        mov bx,current
        call writehex
        mov ax,[temp3]
        mov bx,max
        call writehex
        mov ax,[temp4]
        mov bx,startup
        call writehex

        mov dx,msg2
        mov ah,9
        int 0x21

exit:
        mov ax,0x4c00
        int 0x21

writehex:
        mov ch,4
a102:
        mov cl,ah
        sar cl,4
        and cl,15
        add cl,48
        cmp cl,58
        jb a100
        add cl,7
a100:
        mov [bx],cl
        dec ch
        jz a101
        inc bx
        sal ax,4
        jmp a102
a101:
        ret

temp1:
        db 0,0
temp2:
        db 0,0
temp3:
        db 0,0
temp4:
        db 0,0
msg:
        db 'speedstep utility',13,10,13,10,'$'
msg2:
        db 'USAGE:',13,10
        db 'SPEEDSTP mmvv',13,10
        db ' (mm=multiplier, vv=voltage) EXAMPLE: 0607',13,10,13,10          
        db 'startup: '
startup:
        db '    ',13,10
        db 'current: '
current:
        db '    ',13,10
        db 'max: '
max:
        db '    ',13,10,'$'

