;
; CPIFNT aims to work with 16x8x256 code page fonts for DOS.
;   Copyright (C) 2007  BAHCL  bahcl@hotmail.com
;
;   This program is free software; you can redistribute it and/or modify
;   it under the terms of the GNU General Public License as published by
;   the Free Software Foundation; either version 2 of the License, or
;   (at your option) any later version.
;
;   This program is distributed in the hope that it will be useful,
;   but WITHOUT ANY WARRANTY; without even the implied warranty of
;   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;   GNU General Public License for more details.
;
;   You should have received a copy of the GNU General Public License
;   along with this program; if not, write to the Free Software
;   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;
;
; Please read CPIFNT.MAN to learn how to use this program.
;
;
segment  .text
org   100h
         call  HW_Info
         call  Parse_Parm
         jnc   @0001
         call  Help
         jmp   @0009
@0001:
         dec   bx
         sub   bx,cx
         shl   bx,1
         add   bx,procaddr
         call  [bx]
         xor   ax,ax
@0009:
         mov   ah,4Ch
         int   21h
;
;
Parse_Parm
         xor   ax,ax
         mov   si,80h
         lodsb
         mov   di,si
         add   di,ax
         mov   [di],ah
@0010:
         lodsb
         cmp   al,0h
         jz    @0017
         cmp   al,20h
         jz    @0010
         cmp   al,'/'
         jnz   @0017
         lodsb
         mov   [parm],al
         mov   cx,6
         mov   bx,cx
         mov   di,parmchar
         repne scasb
         jz    @0018
;        jcxz  @0017
@0017:
         stc
         jmp   @0019
@0018:
         clc
@0019:
         ret
;
; Restore BIOS default 8x16 font
proc_0
         call  Clear_IACA
         mov   ax,1104h
         mov   bl,0
         int   10h
         mov   ah,40h
         mov   bx,0
         mov   dx,message0
         mov   cx,helpmsg-message0
         int   21h
         ret
;
;
; load .FNT font
proc_1
         call  Clear_IACA
         lodsb
         call  Open_FNT
         jc    @0110
         mov   ax,buffer
         push  ax
         call  Loadfont
         jmp   @0119
@0110:
         call  User_Interface
         cmp   ah,1Ch
         je    @0118
         call  Clear_IACA
         mov   ax,1104h
         mov   bl,0
         int   10h
         jmp   @0119
@0118:
         call  Load_Font
@0119:
         ret
;
;
; load .FNT font
proc_2
         call  Clear_IACA
         call  User_Interface
         cmp   ah,1Ch
         je    @0128
         call  Clear_IACA
         jmp   @0129
@0128:
         call  Load_Font
@0129:
         ret
;
;
; Show codepages info from EGA?.CPI
proc_3
         call  Check_EGA
         jc    @0139
         call  Find_Copyright
         call  Scroll_Up
@0130:
         cmp   word[num_of_cp],0
         jz    @0138
         call  Parse_EGA
         call  Next_CP
         dec   word[num_of_cp]
         jmp   @0130
@0138:
         mov   ax,200h
         mov   bh,0
         mov   dx,0800h
         int   10h
         mov   ax,4200h
         mov   bx,[fhandle]
         sub   cx,cx
         mov   dx,[copyingaddr]
         int   21h
         mov   ah,3Fh
         mov   bx,[fhandle]
         mov   cx,0FFF0h
         mov   dx,buffer
         int   21h
         mov   cx,ax
         mov   ax,4000h
         sub   bx,bx
         mov   dx,buffer
         int   21h
@0139:
         ret
;
;
; get font from EGA?.CPI
proc_4
         call  Check_EGA
         jc    @0149
         call  Find_Copyright
         mov   ax,4200h
         xor   cx,cx
         mov   dx,[copyingaddr]
         int   21h
         mov   ah,3Fh
         mov   dx,buffer+4096
         mov   cx,0FFF0h
         int   21h
         mov   [copyright_size],ax
         mov   ax,4200h
         xor   cx,cx
         mov   dx,[cp_hdr_off]
         add   dx,28h
         int   21h
@0140:
         jc    @0149
         cmp   word[num_of_cp],0
         jz    @0149
         call  Get_Font
         call  Next_CP
         dec   word[num_of_cp]
         jmp   @0140
@0149:
         ret
;
; Show fonts bit pattern from codepage.fnt
proc_5
         lodsb
         call  Open_FNT
         jc    @0159
         call  Init_Screen
         push  es
         mov   ax,[vid_seg]
         mov   es,ax
         sub   di,di
         mov   si,[index]
         mov   cl,4
         shl   si,cl
         add   si,buffer
         mov   cx,256
@0150:
         push  cx
         call  Clear_Show_Area
         mov   cx,16
@0151:
         push  cx
         call  Parse_FNT
         pop   cx
         add   di,144
         loop  @0151
         mov   ax,[index]
         stosb
         inc   word [index]
         xor   ax,ax
         int   16h
         pop   cx
         cmp   ah,01h
         jz    @0158
         cmp   ah,51h
         jne   @0157
         add   si,160
         add   word [index],10
         sub   cx,10
         js    @0158
@0157:
         loop  @0150
@0158:
         mov   ah,3Eh                     ; close .FNT file
         mov   bx,[fhandle]
         int   21h
         pop   es
@0159:
         ret
;
;
Help
         mov   ah,40h
         mov   dx,helpmsg
         mov   cx,helpmsgend-helpmsg
         mov   bx,0
         int   21h
         ret
;
; get .FNT from current directory or from C:\CPI
Get_Font_Name
         cmp   word [count],0
         ja    @0202
         mov   ah,1Ah
         mov   dx,80h
         int   21h
         mov   dx,fnt+7
         mov   [pathaddr],dx
         mov   ah,4Eh
         int   21h
         jnc   @0200
         mov   dx,fnt+2
         mov   [pathaddr],dx
         mov   ah,4Eh
         int   21h
         jnc   @0200
         mov   dx,fnt
         mov   [pathaddr],dx
         mov   ah,4Eh
         int   21h
         jc    @0209
@0200:
         inc   word [count]
         mov   si,9Eh
         mov   di,[vid_addr]
@0201:
         lodsb
         or    al,al
         jz    @0209
         stosb
         inc   di
         jmp   @0201
@0202:
         mov   dx,[pathaddr]
         mov   ah,4Fh
         int   21h
         jc    @0209
         jmp   @0200
@0209:
         ret
;
;
; for option /1
User_Interface
         push  es
         mov   ax,[vid_seg]
         mov   es,ax
         mov   word [count],0
@0210:
         call  Clear_MsgLine
         call  Get_Font_Name
         jc    @0219
         cmp   byte [parm],'2'
         je    @0211
         call  Load_Font
@0211:
         xor   ax,ax
         int   16h
         cmp   ah,1
         jz    @0219
         cmp   ah,1Ch
         jz    @0219
         jmp   @0210
@0219:
         call  Clear_MsgLine
         pop   es
         ret
;
;
Load_Font
         push  es
         push  ds
         pop   es
         mov   cx,12
         mov   si,9Eh
         mov   dx,fnt+7
         mov   di,dx
         rep   movsb
         xor   al,al
         stosb
         mov   dx,[pathaddr]
         mov   ax,3D00h
         int   21h
         mov   bx,ax
         mov   [fhandle],ax
         mov   ah,3Fh
         mov   cx,4096
         mov   dx,buffer
         int   21h
         mov   ah,3Eh
         int   21h
         mov   si,fnt+7
         mov   di,0F0h
         mov   ax,40h
         mov   es,ax
.loop:
         lodsb
         cmp   al,'.'
         je    @0220
         stosb
         jmp   .loop
@0220:
         mov   byte [es:di],ah
         mov   ax,buffer
         push  ax
         call  Loadfont
         pop   es
         ret
;
;
Loadfont
         push  bp
         mov   bp,sp
         mov   ax,1110h
         mov   bx,1000h
         mov   cx,256
         xor   dx,dx
         mov   bp,[bp+4]   ; font data
         push  ds
         pop   es
         int   10h
         pop   bp
         ret   2
;
;
Init_Screen
         call  Scroll_Up
         mov   ah,40h
         mov   bx,0
         mov   dx,buffer+4096
         mov   cx,[chars]
         int   21h
         mov   ah,3
         mov   bh,0
         int   10h
         mov   al,dh
         xor   ah,ah
         mov   bx,[vid_col]
         mul   bx
         shl   ax,1
         mov   [lastpost],ax
         mov   ah,2
         mov   bh,0
         mov   dh,[vid_row]
         mov   dl,[vid_col]
         inc   dl
         int   10h
         ret
;
;
Scroll_Up
         mov   ah,6
         mov   al,[vid_row]
         mov   bh,7
         xor   cx,cx
         mov   dx,[vid_col]
         dec   dx
         mov   dh,al
         int   10h
         mov   ah,2                       ; set cursor home
         mov   bh,0
         xor   dx,dx
         int   10h
         ret
;
;
Open_FNT
         mov   dx,si
         mov   ax,3D00h
         int   21h
         jc    @0230
         mov   [fhandle],ax
         mov   bx,ax
         mov   ah,3Fh
         mov   cx,4096
         mov   dx,buffer
         int   21h
         mov   ah,3Fh
         mov   cx,0FFF0h
         mov   dx,buffer+4096
         int   21h
         mov   [chars],ax
@0230:
         ret
;
;
Clear_Show_Area
         mov   di,[lastpost]
         mov   ax,[vid_col]
         sub   ax,8
         shl   ax,1
         mov   dx,ax
         mov   ax,1320h
         mov   cx,16

.loop:
         push  cx
         mov   cx,8
         rep   stosw
         add   di,dx
         pop   cx
         loop  .loop
         mov   di,[lastpost]
         ret
;
;
Parse_FNT
         mov      cx,8
         lodsb
         mov      dl,80h
@0240:
         test     al,dl
         jz       @0241
         call     Show_Dot
         jmp      @0242
@0241:
         call     Show_Blank
@0242:
         shr      dl,1
         loop     @0240
         ret
;
;
; check if EGA.CPI signature valid
Check_EGA
         inc   si
         mov   dx,si
         mov   ax,3D00h
         int   21h
         jc    @0250
         mov   [fhandle],ax
         mov   bx,ax
         mov   cx,19h
         mov   dx,buffer
         mov   ah,3Fh
         int   21h

         mov   di,egafontsig           ; verify EGA.CPI signature
         mov   si,buffer
         mov   cx,8
         repe  cmpsb
         jnz   @0250

         mov   si,buffer+17h
         lodsw
         mov   [num_of_cp],ax
         mov   cx,28h
         mov   dx,buffer
         mov   ah,3Fh
         int   21h
         mov   si,buffer
         call  Check_CP_Hdr
         ret
@0250:
         stc
         ret
;
;
Parse_EGA
         mov   word[fontsize],0
         mov   di,buffer+32h
         mov   al,20h
         mov   cx,[vid_col]
         rep   stosb
         mov   di,buffer+32h
         mov   ax,[cp_id]
         call  Hex_2_Ascii
         add   di,3
@0260:
         cmp   word [num_of_sfnt],0
         jz    @0269
         mov   si,[fnt_hdr_off]
         lodsb
         mov   [font_x],al
         call  Hex_2_Ascii
         mov   al,'x'
         stosb
         lodsb
         mov   [font_y],al
         call  Hex_2_Ascii
         mov   al,'x'
         stosb
         lodsw
         lodsw
         mov   [chars],ax
         call  Hex_2_Ascii
         add   di,2
         call  Next_Subfont
         dec   word [num_of_sfnt]
         jmp   @0260
@0269:
         call  Print_Line
         ret
;
;
Get_Font
         mov   ah,3Fh
         mov   cx,1000h
         mov   dx,buffer
         int   21h

         xor   cx,cx
         mov   ax,[cp_id]
         mov   bx,10
@0270:
         xor   dx,dx
         div   bx
         push  dx
         inc   cx
         cmp   ax,0
         jnz   @0270
         mov   di,fnt+7
@0271:
         pop   ax
         add   al,'0'
         stosb
         loop  @0271
         mov   si,ext
@0272:
         lodsb
         stosb
         or    al,al
         jnz   @0272

         mov   ah,3Ch
         xor   cx,cx
         mov   dx,fnt+7
         int   21h
         mov   bx,ax
         mov   ax,4000h
         mov   cx,1000h
         mov   dx,buffer
         int   21h
         mov   ax,4000h
         mov   cx,[copyright_size]
         mov   dx,buffer+4096
         int   21h
         mov   ah,3Eh
         int   21h
         ret
;
;
;
Next_CP
         mov   ax,[next_cp_hdr]
         mov   [cp_hdr_off],ax
         mov   dx,ax
         mov   ax,4200h
         mov   bx,[fhandle]
         xor   cx,cx
         int   21h
         mov   ah,3Fh
         mov   cx,28h
         mov   dx,buffer
         int   21h
         mov   si,buffer
         call  Check_CP_Hdr
         ret
;
;
Next_Subfont
         cmp   word[num_of_sfnt],1
         jna   @0609
         xor   ax,ax
         mov   al,[font_x]
         mov   bx,ax
         mov   cx,8
         mov   al,[font_y]
         xor   dx,dx
         div   cx
         mul   bx
         mul   word [chars]
         add   [fontsize],ax
         mov   ax,[cp_hdr_off]
         add   ax,CPHDRLEN
         add   ax,FONTHDRLEN
         add   ax,[fontsize]
         add   word [fontsize],FONTHDRLEN
         mov   dx,ax
         mov   ax,4200h
         mov   bx,[fhandle]
         mov   cx,0
         int   21h
         mov   ah,3Fh
         mov   dx,buffer+22h
         mov   cx,16
         int   21h
@0609:
         ret
;
;
Check_CP_Hdr
         lodsw
         cmp   al,1Ch                  ; cp header signature
         jnz   @0619
         lodsw
         mov   [next_cp_hdr],ax
         mov   [copyingaddr],ax
         add   si,12
         lodsw
         mov   [cp_id],ax
         add   si,12
         lodsw
         mov   [num_of_sfnt],ax
         add   si,2
         mov   [fnt_hdr_off],si
         lodsb
         mov   [font_y],al
         lodsb
         mov   [font_x],al
         add   si,2
         lodsw
         mov   [chars],ax
         clc
         ret
@0619:
         stc
         ret
;
;
Hex_2_Ascii
         xor   cx,cx
         mov   bx,10
@0620:
         xor   dx,dx
         div   bx
         inc   cx
         push  dx
         or    ax,ax
         jnz   @0620
.loop:
         pop   ax
         add   al,'0'
         stosb
         loop  .loop
         ret
;
;
Print_Line
         push  es
         mov   ax,[vid_seg]
         mov   es,ax
         mov   si,buffer+32h
         mov   di,[lastpost]
         mov   cx,[vid_col]
         mov   ax,cx
         add   ax,cx
         add   [lastpost],ax
.loop:
         movsb
         inc   di
         loop  .loop
         pop   es
         ret
;
;
HW_Info
         push  es
         mov   ax,40h
         mov   es,ax
         mov   al,[es:49h]
         cmp   al,7
         jne   @0630
         mov   ax,0B000h
         mov   [vid_seg],ax
@0630:
         mov   al,[es:84h]
         mov   [vid_row],al
         xor   cx,cx
         mov   cl,al
         mov   ax,[es:4Ah]
         mov   [vid_col],ax
         mul   cx
         shl   ax,1
         mov   [vid_addr],ax
         pop   es
         ret
;
Find_Copyright
         mov   dx,[copyingaddr]
         mov   bx,[fhandle]
         sub   cx,cx
         mov   ax,4200h
         int   21h
         mov   ah,3Fh
         mov   cx,20h
         mov   dx,buffer
         int   21h
         mov   si,buffer
         lodsw
         cmp   al,1Ch
         jne   @0640
         lodsw
         mov   [copyingaddr],ax
         jmp   Find_Copyright
@0640:
         ret
;
Clear_MsgLine
         mov   di,[vid_addr]
         mov   cx,[vid_col]
         mov   al,20h
.loop:
         stosb
         inc   di
         loop  .loop
         ret
;
;
Show_Dot
         push  ax
         mov   al,249
         mov   ah,41h
         stosb
         inc   di
         pop   ax
         ret
;
;
Show_Blank
         push  ax
         mov   ax,1320h
         stosw
         pop   ax
         ret
;
;
Clear_IACA
         push  es                         ; caller gets what code page selected
         mov   di,0F0h                    ; through Intra Application program
         mov   ax,40h                     ; Communication Area
         mov   es,ax
         mov   cx,16
         xchg  ah,al
         rep   stosb
         pop   es
         ret
;
;
;
;
EGAHDRLEN   EQU 19h
CPHDRLEN    EQU 22h
FONTHDRLEN  EQU 6h
segment     .data
cp_hdr_off  dd 19h
next_cp_hdr dd 0
num_of_cp   dw 0
cp_id       dw 0
num_of_sfnt dw 0
fnt_hdr_off dd 0
copyingaddr dw 0
;
lastpost    dw 0
fontsize    dw 0
font_x      db 0
font_y      db 0
chars       dw 0
copyright_size dw 0
fhandle     dw 0
count       dw 0
index       dw 0
vid_row     db 24
vid_col     dw 80
vid_seg     dw 0B800h
vid_addr    dw 0
buf_addr    dw 0
pathaddr    dw 0
procaddr    dw proc_0,proc_1,proc_2,proc_3,proc_4,proc_5,Help
parmchar    db "012345?",0
fnt         db "C:\CPI\????????.FNT",0
ext         db ".FNT",0
egafontsig  db 0FFh,"FONT",20h,20h,20h
;cpi_names   db "437",0,"English US",0
;            db "850",0,"Latin-1",0
;            db "854",0,"Spanish",0
;            db "857",0,"Turkish",0
;            db "860",0,"Portugese",0
;            db "862",0,"Hebrew",0
;            db "866",0,"Russian",0
;            db "867",0,"Czech",0
;            db "868",0,"Arabic",0
;            db "874",0,"Thailand",0
;            db "897",0,"Japanese",0
;            db "938",0,"Chinese DBCS",0
;            db "949",0,"Korean",0
;            db "950",0,"Big-5",0
parm        db 0
message0    db "BIOS 16x8 default font restored."
buffer
helpmsg     db 0Dh,0Ah
            db "CPIFNT version 0.1, Copyright (C) 2007  BAHCL",0Dh,0Ah
            db "Designed and programmed by BAHCL, all rights reserved.",0Dh,0Ah
            db "CPIFNT is a Code Page Font utility for DOS.",0Dh,0Ah
            db "CPIFNT comes with ABSOLUTELY NO WARRANTY, use it at your own risk!",0Dh,0Ah
            db "This is free software, you are welcome to redistribute it under",0Dh,0Ah
            db "the terms of the GNU General Public License version 2.",0Dh,0Ah,0Ah
            db "Syntax:",0Dh,0Ah
            db 09h, "CPIFNT [ /switch  [EGA?.CPI | CODEPAGE.FNT] ]",0Dh,0Dh,0Ah
            db "Where switch may be any of { 0..5,? }",0Dh,0Ah
            db "Read manual CPIFNT.MAN for details.",0Dh,0Ah
            db 0Dh,0Ah

helpmsgend
