;
;  Stream viewer (text) SVTXT.COM
;    syntax: type filename | svtxt
;
;    Designed and programmed by Lo Hung Che
;    Copyright (C) BAHCL 2004
;
;  Dedicated to FreeDOS www.freedos.org
;    under the terms and license of GNU GPL version 2
;
org 100h
segment .text
            mov     sp,stackbot+512         ; stack size = 512 bytes
            mov     bx,sp
            mov     cx,4
            shr     bx,cl
            inc     bx
            mov     ax,ds
            add     ax,bx
            mov     [stream],ax           ; seg. address for data
            mov     [itable],ax           ; line index table

            call    FileType
            mov     ax,[fhandle]
            push    ax
            call    Get_Data
            call    HW_Setting
            call    Parse_Data
            call    Clear_Screen

            call    Get_Scancode

            mov     bx,[fhandle]
            or      bx,bx
            jz      @9999
            mov     ax,3E00h              ; close file
            int     21h
@9999:
            mov     ax,4C00h
            int     21h
;
; Determine input file be stream/regular
FileType
            xor     ax,ax
            mov     si,80h                ; check command tail
            lodsb
            or      al,al
            jz      @0010                 ; stream
            mov     di,si
            add     di,ax
            xchg    ah,al
            stosb
@0011:
            lodsb
            cmp     al,20h
            jz      @0011
            dec     si
            mov     ax,3D00h              ; open file
            mov     dx,si
            int     21h
            jc      @0010
            mov     [fhandle],ax

            push    es
            mov     ax,40h
            mov     es,ax
            mov     dx,[es:0F0h]          ; iaca intra application comm. area
            mov     cx,[es:0F2h]
            xor     ax,ax
            mov     [es:0F0h],ax          ; clear iaca
            mov     [es:0F2h],ax
            pop     es
            mov     ax,4200h
            mov     bx,[fhandle]
            int     21h
@0010:
            ret
;
;
; Display data to screen
Show_Data
            push    bp
            mov     bp,sp
            mov     cx,[bp+6]               ; lines to print
            xor     di,di
@nextline:
            push    cx
            mov     ax,[bp+4]               ; line# to print
            call    Make_String
            inc     word [bp+4]
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            mov     cx,[linewidth]           ; line size
            mov     si,buffer
            mov     ah,07
@nextbyte:
            lodsb
            stosw
            loop    @nextbyte
            pop     es
            pop     cx
            loop    @nextline

            mov     ax,[bp+4]
            pop     bp
            ret     4
;
;
; format a string for display
Make_String
            push    di
            mov     si,ax
            shl     si,1
            mov     di,buffer
            mov     cx,[linewidth]           ; clear the line
            mov     al,20h
            rep     stosb
            mov     di,buffer
            xor     dx,dx
            push    ds
            mov     ax,[itable]
            mov     ds,ax
            lodsw
            pop     ds
            mov     si,ax
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
@nextchar:
            lodsb
            cmp     al,LF
            jz      @nextchar
            cmp     al,CR
            jz      @eoline                  ; End of line

            cmp     al,TAB
            jnz     @0041
            call    Do_TAB
            add     di,ax
            cmp     bx,[cs:linewidth]
            jae     @eoline
            jmp     @nextchar
@0041:
            cmp     al,20h
            jb      @nextchar
            stosb
            inc     bx
            jmp     @nextchar
@eoline
            pop     ds
            pop     di
            ret
;
; user interface
; get keyboard scancode
Get_Scancode
            mov     ax,[lineperpage]
            push    ax
            mov     ax,[linenum]
            push    ax
            call    Show_Data

            xor     ax,ax
            int     16h

            mov     cx,[keys]
            inc     cx
            mov     di,scancode
            mov     si,di
            repne   scasw
            jcxz    Get_Scancode
            mov     ax,di
            sub     ax,si
            dec     ax
            dec     ax

            mov     bx,procnames
            add     bx,ax
            call    [bx]

            push    ax
            call    Clear_Screen
            pop     ax

            cmp     ax,1
            jnz     Get_Scancode
            ret
;
; key = escape
K_Esc
            mov     ax,1
            ret
; key = up
K_Up
            mov     ax,[linenum]
            cmp     ax,0
            ja      @0020
            mov     ax,1
@0020:
            dec     ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = down
K_Dn
            mov     ax,[linenum]
            add     ax,[lineperpage]
            jc      @0030
            inc     ax
            jc      @0030
            cmp     ax,[totlines]
            jb      @0031
@0030:
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            dec     ax
            mov     [linenum],ax
            jmp     @0031
@0031:
            mov     ax,[linenum]
            inc     ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page up
K_P_Up
            mov     ax,[linenum]
            cmp     ax,[lineperpage]
            jae     @0040
            mov     ax,[lineperpage]
@0040:
            sub     ax,[lineperpage]
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = page down
K_P_Dn
            mov     ax,[linenum]
            add     ax,[lineperpage]
            jc      @0051
            add     ax,[lineperpage]
            jc      @0051
            cmp     ax,[totlines]
            jb      @0050
@0051:
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            sub     ax,[lineperpage]
            mov     [linenum],ax
            jmp     @0050
@0050:
            mov     ax,[linenum]
            add     ax,[lineperpage]
            mov     [linenum],ax

            xor     ax,ax
            ret
; key = home
K_Home
            xor     ax,ax
            mov     [linenum],ax
            xor     ax,ax
            ret
; key = end
K_End
            mov     ax,[totlines]
            sub     ax,[lineperpage]
            jnc     @0070
            xor     ax,ax
@0070:
            mov     [linenum],ax
            xor     ax,ax
            ret
;
;
; clear the screen, send cursor home
Clear_Screen
            push    es
            mov     ax,[vid_seg]
            mov     es,ax
            xor     di,di
            mov     ax,0720h
            mov     cx,[lineperpage]
.loop       push    cx
            mov     cx,[linewidth]
            rep     stosw
            pop     cx
            loop    .loop
            pop     es
            mov     ah,2
            xor     bx,bx
            xor     dx,dx
            int     10h
            ret
;
;
; handle TAB
Do_TAB
            push    bx
            mov     al,bl
            xor     ah,ah
            mov     bl,TABSTOP
            div     bl
            mov     al,TABSTOP
            sub     al,ah
            xor     ah,ah
            pop     bx
            add     bx,ax
            ret
;
;
; handle CR LF
DO_CRLF
            mov     bx,[cs:linewidth]
            ret
;
; Parse data from stream
Parse_Data
            push    es
            push    ds
            mov     ax,[itable]
            mov     es,ax
            mov     cx,[ssize]
            mov     ax,[stream]
            mov     ds,ax
            xor     bx,bx
            xor     di,di
            xor     si,si
            xor     ax,ax
            stosw
@0090:
            lodsb
            cmp     si,cx
            jae     @eof
            cmp     al,LF
            jz      @0090
            cmp     al,TAB
            jnz     @0091
            call    Do_TAB
            jmp     @0093
@0091:
            cmp     al,CR
            jnz     @0092
            call    DO_CRLF
            jmp     @0093
@0092:
            inc     bx
@0093:
            mov     ax,[cs:linewidth]
            sub     ax,bx
            jnz     @0094
            mov     ax,si
            stosw
            xor     bx,bx
@0094:
            jmp     @0090
@eof:
            pop     ds
            pop     es
            mov     ax,di
            shr     ax,1
            dec     ax
            mov     [totlines],ax
            cmp     ax,[lineperpage]
            jae     @0095
            mov     [lineperpage],ax
@0095:
            ret
;
; get data from stream
Get_Data
            push    bp
            mov     bp,sp
            push    ds
            mov     ax,[stream]
            mov     ds,ax
            mov     ax,3F00h                 ; read file
            xor     dx,dx
            mov     cx,0FFF0h
            mov     bx,[bp+4]                ; file handle
            int     21h
            pop     ds
            mov     [ssize],ax
            mov     cl,4
            shr     ax,cl
            inc     ax
            add     [itable],ax
            pop     bp
            ret     2
;
;
; hardware setting
HW_Setting
            mov     ah,0Fh             ; set up display mode seg. address
            int     10h
            cmp     al,7               ; mono
            jnz     @0100
            mov     ax,0B000h
            mov     [vid_seg],ax
@0100:
            push    es
            mov     ax,40h
            mov     es,ax
            mov     ax,[es:4Ah]
            mov     [linewidth],ax
            xor     ax,ax
            mov     al,[es:84h]
            inc     ax
            mov     [lineperpage],ax
            pop     es
            ret
;
;
segment .data
TABSTOP         EQU     8
TAB             EQU     9
CR              EQU     0Dh
LF              EQU     0Ah
fhandle         dw      0
vid_seg         dw      0B800h          ; color
lineperpage     dw      0
linewidth       dw      0
stream          dw      0               ; stream segment address
ssize           dw      0               ; stream size
itable          dw      0               ; line index segment address
linenum         dw      0               ; line number
totlines        dw      0
keys            dw      7
scancode        dw      011Bh,4800h,5000h,4900h,5100h,4700h,4F00h
procnames       dw      K_Esc,K_Up,K_Dn,K_P_Up,K_P_Dn,K_Home,K_End
buffer    times 80  db  20h
stackbot
;               db      'Designed and programmed by Lo Hung Che',0
;               db      'Copyright (C) BAHCL 2004',0
;
;
