/*
 * Package database manipulation routines.
 * This file is part of the FDNPKG project.
 *
 * Copyright (C) Mateusz Viste 2012-2015
 */

#ifndef pkgdb_sentinel
#define pkgdb_sentinel

struct pkgrepo {
  unsigned char repo;
  char version[16];
  unsigned long crc32;
  struct pkgrepo *nextrepo;
};

struct pkgdb {
  char name[9];
  char *desc;  /* the description of the package - will be strdup()ed when time will come */
  struct pkgrepo *repolist;
  struct pkgdb *nextpkg;
};


struct pkgdb *createdb(void);
void freedb(struct pkgdb **db);
struct pkgdb *findpkg(struct pkgdb *db, char *pkgname, struct pkgdb **lastmatch);
int loaddb(struct pkgdb *db, char *datafile, unsigned char repo);
int loaddb_fromcache(struct pkgdb *db, char *datafile, unsigned long crc32val, int maxcachetime);
void dumpdb(struct pkgdb *db, char *datafile, unsigned long crc32val);

#endif
