'
' FDNPKG idx builder
' Copyright (C) Mateusz Viste 2012, 2013
'
' buildidx computes idx files for FDNPKG-compatible repositories.
' it must be executed pointing to a directory that stores FreeDOS
' packages (zip) files. buildidx will generate the index file and
' save it into the package repository.
'
' 11 jul 2013: added a switch to 7za to make it case insensitive when extracting lsm files
' 10 jul 2013: changed unzip calls to 7za (to handle cases when appinfo is compressed with lzma)
' 04 feb 2013: added CRC32 support
' 22 sep 2012: forked 1st version from FDUPDATE builder
'

#INCLUDE ONCE "vbcompat.bi"     ' Required for time-related stuff (DAY, MONTH...)
#INCLUDE ONCE "getlsm.bi"       ' GetLSM function
#INCLUDE ONCE "sortstr.bi"      ' String sorting functions

CONST pVer AS STRING = "10jul2013"


DECLARE SUB GenIndexes(repodir AS STRING)
DECLARE FUNCTION GetCSV(RawCSV AS STRING, n AS INTEGER) AS STRING


REM *** START OF THE MAIN PROGRAM ***

DIM AS STRING repodir

PRINT "FDNPKG server repository generator version "; pVer
SLEEP 250
PRINT

IF COMMAND(1) = "" OR COMMAND(1) = "/?" OR LCASE(COMMAND(1)) = "/help" OR LCASE(COMMAND(1)) = "--help" OR LCASE(COMMAND(1)) = "-h" THEN
  PRINT "Usage: buildidx repodir"
  END
END IF

repodir = COMMAND(1)
PRINT "Will build index for "; repodir; " directory."

PRINT "Recreating the appinfo directory..."
SHELL "rm -rf appinfo"
SHELL "mkdir appinfo"

PRINT "Populating appinfo with LSM files from archives..."
SHELL "7za e -ssc- -oappinfo/ '" + repodir + "/*.zip' 'appinfo/*'"

PRINT "Generating the index file... ";
GenIndexes(repodir)

END


REM *** END OF THE MAIN PROGRAM ***


FUNCTION GetCSV(RawCSV AS STRING,n AS INTEGER) AS STRING
    ' GetCSV analizes a string in CSV format (comma or tab delimited), and
    ' returns the value of the n-th field. If the field doesn't exist, it
    ' returns a null string.
    DIM AS STRING FieldValue
    DIM AS INTEGER Counter, CommaPos, ValueLen
    CommaPos = 0
    FOR Counter = 1 TO n - 1
      DO
        CommaPos += 1
      LOOP UNTIL MID(RawCSV, CommaPos, 1) = CHR(9) OR CommaPos = LEN(RawCSV)
    NEXT Counter
    ValueLen = -1
    DO
        ValueLen += 1
    LOOP UNTIL MID(RawCSV, CommaPos + ValueLen + 1, 1) = CHR(9) OR CommaPos + ValueLen = LEN(RawCSV)
    FieldValue = MID(RawCSV, CommaPos + 1, ValueLen)
    RETURN FieldValue
END FUNCTION


SUB GenIndexes(repodir AS STRING)
  DIM ShortMonth(1 TO 12) AS STRING = {"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"}
  REDIM LsmFileList(1 TO 2) AS STRING
  DIM AS STRING LsmFile, LSMpackage, LSMtitle, LSMversion, LSMdescription, crc32
  DIM AS INTEGER LsmCount = 0, x

  LsmFile = DIR("appinfo/*.lsm")
  WHILE LEN(LsmFile) > 0
    IF LsmCount = UBOUND(LsmFileList) THEN REDIM PRESERVE LsmFileList(1 TO LsmCount * 2) AS STRING
    LsmCount += 1
    LsmFileList(LsmCount) = LsmFile
    LsmFile = DIR()
  WEND
  strQsort(LsmFileList(), LsmCount)    ' Sorting the packages list
  OPEN repodir + "/index.lst" FOR OUTPUT AS #39
  'OPEN repodir + "/index.txt" FOR OUTPUT AS #40
  ' Write out the index header
  PRINT #39, "FD-REPOv1" + CHR(9) + "Build time: " & DAY(NOW) & " " & ShortMonth(MONTH(NOW)) + " " & YEAR(NOW) & CHR(9) + repodir + CHR(9) + "FFFFFFFF"
  'PRINT #40, "Repository """ + repodir + """ built the " & DAY(NOW) & " " & ShortMonth(MONTH(NOW)) + " " & YEAR(NOW)
  'PRINT #40, ""
  FOR x = 1 TO LsmCount
    LsmFile = LsmFileList(x)
    LSMpackage = MID(LsmFile, 1, LEN(LsmFile) - 4)
    
    OPEN PIPE "./crc32 < " & repodir & "/" & LSMpackage & ".zip" FOR INPUT AS #59
    LINE INPUT #59, crc32
    CLOSE #59

    IF LEN(LSMpackage) > 8 THEN PRINT "Warning: "; LSMpackage; ".zip is not in 8.3 format!"
    LSMtitle = GetLSM("appinfo/" + LsmFile, "Title")
    IF LEN(LSMtitle) = 0 THEN PRINT "Warning: no LSM title for "; LSMpackage; ".zip!"
    LSMversion = GetLSM("appinfo/" + LsmFile, "Version")
    IF LEN(LSMversion) = 0 THEN PRINT "Warning: no LSM version for "; LSMpackage; ".zip!"
    LSMdescription = GetLSM("appinfo/" + LsmFile, "Description")
    IF LEN(LSMdescription) = 0 THEN PRINT "Warning: no LSM description for "; LSMpackage; ".zip!"
    PRINT #39, LSMpackage + CHR(9) + LSMversion + CHR(9) + LSMdescription + CHR(9) + crc32
    'PRINT #40, LEFT(LSMpackage & " " & LSMversion & SPACE(32), 32) & CHR(9) & """" & LSMtitle & """"
  NEXT x
  CLOSE #39
  'CLOSE #40
  PRINT "" & LsmCount & " packages found."
END SUB
