Program LinuxExt2FS;

{
  little Linux shell for DOS to read Ext2 Linux partition

  Copyright (C) 1998  Paul Toth

  tothpaul@mygale.org
  http://www.mygale.org/~tothpaul

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
{
 Know bugs & limitations :

 - support only first hard drive ($80) cauz my Linux Partition is there :)
 - TIMEZONE is constant
 - File names are limited to SizeOf(String)

 I've used LDIR/LREAD C sources found on Linux CD :

 - Werner.Zimmermann@fht-esslingen.de (Werner Zimmermann)


}

{$R-,S-,I-,Q-}
{$D-,L-,Y-}
{$G+}

Const
 TIMEZONE=7200;

Procedure DecodeDateTime(DateTime:longint; Var Y,Mt,D,DOW,H,Mn,S:word);
 Const
  Days:array[2..12] of byte=(
   {31,}28,31,30,31,30,31,31,30,31,30,31
  );
 Var
  YD:word;
  MD:word;
 begin
  Inc(DateTime,TIMEZONE);

  S :=DateTime mod 60; DateTime:=DateTime div 60;
  Mn:=DateTime mod 60; DateTime:=DateTime div 60;
  H :=DateTime mod 24; DateTime:=DateTime div 24;

  Y  :=1970;
  Mt :=1;
  D  :=1;
  DOW:=4;

  YD :=365;
  While DateTime>YD do begin
   Dec(DateTime,YD);
   DOW:=(DOW+YD) mod 6;
   Inc(Y);
   if ((Y mod 4=0)and(Y mod 100<>0))or(Y mod 400=0) then YD:=366 else YD:=365;
  end;

  if YD=366 then Days[2]:=29;
  MD :=31;
  While DateTime>MD do begin
   Dec(DateTime,MD);
   DOW:=(DOW+MD) mod 6;
   Inc(Mt);
   MD:=Days[Mt];
  end;

  Inc(D,DateTime);
  DOW:=(DOW+DateTime) mod 6;
 end;

Function ctime(Date:longint):string;
 const
  Days  :pchar='SunMinTueWedThuFriSat';
  Months:pchar='JanFebMarAprMayJunJulAugSepOctNovDec';
 var
  Y,Mt,D,DOW,H,Mn,S:word;
  temp  :string[24];
 begin
  DecodeDateTime(Date,Y,Mt,D,DOW,H,Mn,S);
  Str(Y,Temp);
  Temp:='ddd mmm 00 00:00:00 '+Temp;
   Move(Days[3*DOW],Temp[1],3);
   Move(Months[3*Mt],Temp[5],3);
   Inc(Temp[09],D  div 10);
   Inc(Temp[10],D  mod 10);
   Inc(Temp[12],H  div 10);
   Inc(Temp[13],H  mod 10);
   Inc(Temp[15],Mn div 10);
   Inc(Temp[16],Mn mod 10);
   Inc(Temp[18],S  div 10);
   Inc(Temp[19],S  mod 10);
  ctime:=Temp;
 end;

Type

{ for debug only : Watch TChars(pointer^) }
  TChars=array[0..1000] of char;

{ Hard drive Sector }
 TSector=array[1..512] of byte;

{ Partition info }
 TPart=record
  Status     :byte;
  StartHead  :byte;
  StartSector:byte;  { 76543210-76543210 }
  StartTrack :byte;  { <  Track  ><Sect> : see DX for Int 13h }
  OS         :byte;
  LastHead   :byte;
  LastSector :byte;
  LastTrack  :byte;
  Distance   :LongInt;
  Size       :LongInt;
 end;

{ Master boot record }
 TMBR=record
  Code:Array[0..$1BD] of byte;
  Part:Array[1..4] of TPart;
  Sign:word;
 end;

(*
 * Super Block Structure
 *)
 TSuperBlock=record
  INodeCount        :longint;
  BlockCount        :longint;
  ReservedBlockCount:longint;
  FreeBlockCount    :longint;
  FreeINodeCount    :longint;
  FirstDataBlock    :longint;
  LogBlockSize      :longint;
  LogFragmentSize   :longint;
  BlocksPerGroup    :longint;
  FragmentsPerGroup :longint;
  INodesPerGroup    :longint;
  MountTime         :longint;
  WriteTime         :longint;
  MountCount        :word;
  MaximalMountCount :integer;
  Magic             :word;
  FileSystemState   :word;
  Errors            :word;
  Pad               :word;
  LastCheckTime     :longint;
  CheckInterval     :longint;
  CreatorOS         :longint;
  RevisionLevel     :longint;
  DefaultUID        :word;
  DefaultGID        :word;
  Reserdev          :array[0..234] of byte;
 end;

(*
 * Group Descriptor Structure
 *)
 TGroup=record
  BlockBitmap:longint;
  INodeBitmap:longint;
  INodeTable :longint;
  FreeBlockCount:word;
  FreeINodeCount:word;
  UsedDirCount  :word;
  pad           :word;
  Reserved:array[0..2] of longint;
 end;
 TGroups=array[0..100] of TGroup;

{ Linux Partition info }

 TExt2=record
 { Drive info }
  Drive:record
   Number :byte;
   Heads  :byte;
   Sectors:byte;
   Tracks :word;
  end;
 { Partition info }
  Size  :longint;
 { Start info }
  Head  :byte;
  Sector:byte;
  Track :word;
  Start :longint;
 { extra data }
  dev   :string;
  Super :TSuperBlock;
  BlockSize:longint;
  GroupCount:word;
  Groups:^TGroups;
 end;

(*
 * Inode Structure
 *)
 TINode=record
  Mode       :word;
  OwnerID    :word;
  Size       :longint;
  AccessTime :longint;
  CreateTime :longint;
  ChangeTime :longint;
  DeleteTime :longint;
  GroupID    :word;
  LinkCount  :word;
  BlockCount :longint;
  FileFlags  :longint;
  Reserved1  :longint;
  Blocks     :array[0..14] of longint;
  FileVersion:longint;
  FileACL    :longint;
  DirACL     :longint;
  FragAddr   :longint;
  FragNumber :byte;
  FragSize   :byte;
  Reserved2  :array[0..1] of longint;
 end;

Procedure Error(Msg:string);
 begin
  Writeln(#254' ',Msg);
  Halt;
 end;

Function ReadSector(Drive,Head:byte; Track:word; Sector,Count:byte; Var Buffer):word; assembler;
 asm
  mov ah,2   { read sector }
  mov al,Count
  mov dl,Drive
  mov dh,Head
  mov cx,Track
 xchg ch,cl
  shl cl,6
  or  cl,Sector
  les bx,Buffer
  int 13h
 end;

Function GetDiskInfo(Drive:byte;Var Heads,Sectors; Var Tracks:word):boolean; assembler;
 asm
  mov ah,08h
  mov dl,Drive
  int 13h
  mov al,FALSE
  jc  @error
   les di,Heads
   inc dh           { !! }
   mov es:[di],dh
   mov al,cl
   and al,$3f
   les di,Sectors
   mov es:[di],al
   mov al,ch
   mov ah,cl
   shr ah,6
   les di,Tracks
   inc ax           { !! }
   mov es:[di],ax
   mov al,TRUE
  @error:
 end;

Procedure ReadAbsolute(Var Ext2:TExt2; Offset:longint; Var Data; DataSize:word);
 var
  distance:longint; { absolute location }
  Head    :byte;
  Track   :word;
  Sector  :byte;

  index:word;    { Sector Index }
  count:byte;    { Sector Count }
  temp :pchar;

 begin
  distance:=(Offset div 512)+Ext2.Start;

  Head  :=(Distance div  Ext2.Drive.Sectors) mod Ext2.Drive.Heads;
  Track :=(Distance div (Ext2.Drive.Sectors * Ext2.Drive.Heads));
  Sector:=(Distance mod  Ext2.Drive.Sectors)+1;

  Index :=Offset mod 512;
  Count :=(DataSize+511) div 512;

  getmem(temp,Count*512);
   if ReadSector(Ext2.Drive.Number,Head,Track,Sector,Count,Temp^)>255 then Error('Read error');
   move(Temp[Index],Data,DataSize);
  freemem(temp,Count*512);
 end;

Procedure SearchLinux(Var Ext2:TExt2);
 var
  MBR  :TMBR; { Master Boot Record }
  Drive:byte; { Drive }
  Linux:byte; { Linux Partition }
 begin
 { First Hard Drive }
  Drive:=$80;

 { Read Head 0, Track 0, Sector 1 }
  if ReadSector(Drive,0,0,1,1,MBR)>255 then Error('Error while reading MBR');

 { Check Signature }
  if MBR.Sign<>$AA55 then Error('Invalide MBR or Read Error');

 { Search Linux Partition }
  Linux:=1;   { First Partition }
  while (Linux<=4)and(MBR.Part[Linux].OS<>$83) do inc(Linux);

 { Linux not found }
  if Linux=5 then Error('No Linux partition on first Hard drive');

 { Get Partition info }
  with Ext2.Drive do begin
   Number:=Drive;
   if not GetDiskInfo(Number,Heads,Sectors,Tracks) then
    Error('Error while reading Disk info');
  end;

 { Set Ext2 info }
  With MBR.Part[Linux] do begin
   Ext2.Size  :=Size;
   Ext2.Head  :=StartHead;
   Ext2.Sector:=StartSector and $3F;
   Ext2.Track :=StartTrack+256*(StartSector shr 6);
   Ext2.Start :=Distance;
  end;
  Ext2.Dev:='/dev/hd'+chr(Drive-$80+ord('a')) + chr(ord('0')+Linux);

  WriteLn(#254' Linux partition found ',Ext2.dev,' - ',Ext2.Size*512/1024/1024:2:2,' Mo');

 { Get Superblock }
  ReadAbsolute(Ext2,1024,Ext2.Super,SizeOf(TSuperBlock));
  if Ext2.Super.Magic<>$EF53 then Error('Invalide Linux partition '+Ext2.dev);

 { Get Groups }
  With Ext2 do begin
   BlockSize:=1024 shl Super.LogBlockSize;
   GroupCount:=( Super.BlockCount - Super.FirstDatablock
               + Super.BlocksPerGroup - 1 ) div Super.BlocksPerGroup;
   GetMem(Groups,GroupCount*SizeOf(TGroup));
   ReadAbsolute(Ext2,2*BlockSize,Groups^,GroupCount*SizeOf(TGroup));
  end;
 end;

Procedure GetINode(Var Ext2:TExt2; Number:longint; Var INode:TINode);
 var
  grp:longint;
  ofs:longint;
  loc:longint;
 begin
  if (Number=0)or(Number>Ext2.Super.INodeCount) then begin
   writeln('Invalide INode number');
   halt;
  end;

  dec(Number);

  with Ext2 do begin
   grp:=Number div Super.INodesPerGroup;
   ofs:=Number mod Super.INodesPerGroup;
   Loc:=Groups^[grp].INodeTable * BlockSize + ofs*(SizeOf(TINode)+2);
   ReadAbsolute(Ext2,Loc,INode,SizeOf(TINode));
  end;

 end;

Type
 PDirList=^TDirList;
 TDirList=record
  Name :String;
  INode:longint;
  Next :PDirList;
 end;

Var
 Ext2:TExt2;

 PROMPT  :String;
 PATH    :String;
 DirINode:longint;

 cmd,parms:string;

 DirList :PDirList;
 DirCount:word;
 DirLast :PDirList;

Procedure DirEntry(EntryINode:longint;Name:string);
 Var
  INode:TINode;
  Mode :string;
  m,b  :word;
 begin
  GetINode(Ext2,EntryINode,INode);

  Mode:='?rwxrwxrwx';

  b:=1 shl 8;
  for m:=2 to 10 do begin
   if (INode.Mode and b)=0 then Mode[m]:='-';
   b:=b shr 1;
  end;

  case (INode.Mode shr 12) and $F of
   $1:Mode[1]:='p'; { FIFO  }
   $2:Mode[1]:='c'; { CHAR  }
   $4:Mode[1]:='d'; { DIR   }
   $6:Mode[1]:='b'; { BLOCK }
   $8:Mode[1]:='-'; { FILE  }
   $A:Mode[1]:='l'; { LINK  }
   $C:Mode[1]:='s'; { SOCK  }
  end;

  writeln(Mode,INode.OwnerID:5,INode.GroupID:5,INode.Size:10,' ',ctime(INode.CreateTime),' ',Name);

 end;

Procedure KillDir;
 Var
  List:PDirList;
 begin
  While DirCount>0 do begin
   List:=DirList;
   DirList:=List^.Next;
   Dispose(List);
   Dec(DirCount);
  end;
 end;

Procedure MakeDir;
 Type
  TEntry=record
   INode :longint;
   Size  :word;
   Length:word;
  end;
 Var
  INode:TINode;
  Size :longint;

  Block    :PChar;
  BlockLeft:longint;
  BlockPtr :PChar;

  xBlock    :pointer;
  xBlockPtr :^longint;
  xBlockLeft:longint;

  Idx:byte;
  Loc:longint;

  Entry:TEntry;

  List :PDirList;

  procedure NextBlock;
   begin
    if Idx<12 then begin
     Loc:=INode.Blocks[Idx]*Ext2.BlockSize;
     inc(idx);
    end else begin
     if Idx=12 then begin { Init XBlock }
      GetMem(xBlock,Ext2.BlockSize);
      xBlockLeft:=0;
     end;
     if xBlockLeft=0 then begin
      Loc:=INode.Blocks[Idx]*Ext2.BlockSize;
      Inc(Idx);
      ReadAbsolute(Ext2,Loc,xBlock^,Ext2.BlockSize);
      xBlockPtr :=xBlock;
      xBlockLeft:=Ext2.BlockSize div SizeOf(LongInt);
     end;
     Loc:=xBlockPtr^;
     Inc(xBlockPtr);
     Dec(XBlockLeft);
    end;
    ReadAbsolute(Ext2,Loc,Block^,Ext2.BlockSize);
    BlockLeft:=Ext2.BlockSize;
    BlockPtr :=Block;
   end;

  procedure CopyBlock(Var Data; DataSize:word);
   Var
    DataPtr:PChar;
   begin
    if BlockLeft>=DataSize then begin
     Move(BlockPtr^,Data,DataSize);
     BlockPtr:=@BlockPtr[DataSize];
     Dec(BlockLeft,DataSize);
    end else begin
     DataPtr:=@Data;
     if BlockLeft>0 then begin
      Move(BlockPtr^,Data,BlockLeft);
      DataPtr:=@DataPtr[BlockLeft];
      Dec(DataSize,BlockLeft);
     end;
     NextBlock;
     CopyBlock(DataPtr^,DataSize);
    end;
   end;

  procedure MoveBlock(Size:word);
   begin
    if BlockLeft>=Size then begin
     BlockPtr:=@BlockPtr[Size];
     Dec(BlockLeft,Size);
    end else begin
     Dec(Size,BlockLeft);
     NextBlock;
     MoveBlock(Size);
    end;
   end;

 begin
  KillDir;

  GetINode(Ext2,DirINode,INode);
  Size:=INode.BlockCount*512;
  GetMem(Block,Ext2.BlockSize);

  Idx:=0;
  NextBlock;

  Repeat
   CopyBlock(Entry,SizeOf(Entry));
   if Entry.INode>Ext2.Super.INodeCount then Entry.INode:=0;

   If Entry.INode=0 then
    break { MoveBlock(Entry.Size-SizeOf(TEntry)) }
   else begin
    if Entry.Length>255 then Error('Entry Name too long');
    New(List);
    List^.Name[0]:=Chr(Entry.Length);
    CopyBlock(List^.Name[1],Entry.Length);
    List^.INode:=Entry.INode;

    if DirCount=0 then DirList:=List else DirLast^.Next:=List;
    DirLast:=List;
    Inc(DirCount);

    MoveBlock(Entry.Size-SizeOf(TEntry)-Entry.Length);
   end;

   Dec(Size,Entry.Size);
  until Size=0;

  FreeMem(Block,Ext2.BlockSize);
  if Idx>12 then FreeMem(xBlock,Ext2.BlockSize);
 end;

Procedure Dir;
 Var
  List:PDirList;
  i:integer;
 begin
  if DirCount=0 then MakeDir;
  List:=DirList;
  For i:=1 to DirCount do begin
   With List^ do DirEntry(INode,Name);
   List:=List^.Next;
  end;
 end;

Procedure Split(Var s1:string; sep:char; var s2:string);
 var
  p:byte;
 begin
  p:=pos(sep,s1);
  if p=0 then
   s2:=''
  else begin
   s2:=copy(s1,p+1,length(s1));
   s1[0]:=chr(p-1);
  end;
 end;

procedure cd(dir:string); forward;

Function chdir(step:string):boolean;
 var
  List:PDirList;
  i:integer;
  INode:TINode;
  p:PChar;
  s:string;
 begin
  if step='.'  then begin chdir:=true; exit; end;
  if (step='..')and(path='/') then begin chdir:=false; exit; end;

  if DirCount=0 then MakeDir;

  List:=DirList;
  for i:=1 to DirCount do begin
   if List^.Name=step then begin

    GetINode(Ext2,List^.INode,INode);

   { Directory }
    If (INode.Mode and $4000)=$4000 then begin
     DirINode:=List^.INode;
     chdir:=true;
     exit;
    end;

   { Link }
    If (INode.Mode and $A000)=$A000 then begin
     if INode.Size>SizeOf(TINode) then Error('Link to long');
     p:=@INode.Blocks;
     writeln('->',p);
     s:='';
     while (p^<>#0) do begin
      if (length(s)=255) then Error('Link to long');
      s:=s+p^; inc(p);
     end;
     KillDir;
     cd(s);
     chdir:=false; { do not add step to path ! }
     exit;
    end;

   end;

   List:=List^.Next;
  end;
  chdir:=false;
  writeln('path not found');

 end;

procedure cd(dir:string);
 var
  sub:string;
 begin
  if dir='' then begin
   writeln(path);
   exit;
  end;
  if dir='.' then exit;
  if (dir='..')and(Path='/') then exit;

  repeat
   split(dir,'/',sub);
   if dir='' then begin
    path:='/';
    DirINode:=2;
    KillDir;
   end else
    if chdir(dir) then begin
     if dir='..' then
      repeat dec(path[0]) until Path[length(path)]='/'
     else
      Path:=Path+dir+'/';
     killdir;
    end else begin
     exit;
    end;
   dir:=sub;
  until dir='';

 end;

begin
 WriteLn(#16' Linux Ext2-FS for DOS <tothpaul@mygale.org>');

 SearchLinux(Ext2);

 PROMPT  :=Ext2.Dev;
 PATH    :='/';
 DirINode:=2; { root }
 DirList :=nil;
 DirCount:=0;

 repeat
 { writeln(memavail); }
  write(PROMPT,PATH,'>');
  readln(cmd);
  split(cmd,' ',parms);
  if cmd='help' then writeln(' help,dir/ls,cd,exit') else
  if cmd='cd' then cd(parms) else
  if cmd='cd..' then cd('..') else
  if cmd='cd/'  then cd('/') else
  if (cmd='dir')or(cmd='ls') then dir else
  writeln('Invalide command');
 until (cmd='exit');

 WriteLn(#254' Back to DOS.');

end.