WScript.StdOut.WriteLine "Doszip Build Configurator"
Set FSO = CreateObject("Scripting.FileSystemObject")
Set WshShell = CreateObject("WScript.Shell")
RootDir = WshShell.CurrentDirectory
WScript.StdOut.Write "Root directory: "
WScript.StdOut.WriteLine RootDir

WScript.StdOut.Write "Checking for ASM... "
    If FSO.FileExists(RootDir + "\src\tools\asm.exe") Then
    	JWasmPath = RootDir + "\src\tools"
    Else
    	JWasmPath = FindFile("asm.exe")
    End If
    If Len(JWasmPath) = 0 Then
	WScript.StdOut.WriteLine "** Error ** Not found: asm.exe"
	WScript.Quit 1
    End If
    WScript.StdOut.Write "Ok: "
    WScript.StdOut.WriteLine JWasmPath

WScript.StdOut.Write "Checking for WLib...  "
    WatcomPath = FindFile("wlib.exe")
    If Len(WatcomPath) = 0 Then
	WScript.StdOut.WriteLine "** Warnig ** Not found: wlib.exe"
    Else
	WScript.StdOut.Write "Ok: "
	WScript.StdOut.WriteLine WatcomPath
    End If

WScript.StdOut.Write "Checking for WLink... "
    WatcomPath = FindFile("wlink.exe")
    If Len(WatcomPath) = 0 Then
	WScript.StdOut.WriteLine "** Warnig ** Not found: wlink.exe"
    Else
	WScript.StdOut.Write "Ok: "
	WScript.StdOut.WriteLine WatcomPath
    End If

WScript.StdOut.Write "Checking for WMake... "
    WatcomPath = FindFile("wmake.exe")
    If Len(WatcomPath) = 0 Then
	WScript.StdOut.WriteLine "** Warnig ** Not found: wmake.exe"
    Else
	WScript.StdOut.Write "Ok: "
	WScript.StdOut.WriteLine WatcomPath
    End If

WScript.StdOut.WriteLine "Create src\debug\tasm\tasm.inc"
    Set OutFile = FSO.CreateTextFile(RootDir + "\src\debug\tasm\tasm.inc")
    OutFile.WriteLine "JWasm equ <" & Chr(34) & JWasmPath & "\asm.exe" & Chr(34) & ">"
    OutFile.WriteLine
    OutFile.Close

WScript.StdOut.WriteLine "Create makefile"
    Set OutFile = FSO.CreateTextFile(RootDir + "\src\makefile")
    OutFile.WriteLine "# MAKEFILE--"
    OutFile.WriteLine "# Makefile for Doszip"
    OutFile.WriteLine "#"
    OutFile.WriteLine "cln=dz"
    OutFile.WriteLine "af1=/D__DZ__"
    OutFile.WriteLine "bin=" + RootDir
    OutFile.WriteLine "!include " + RootDir + "\src\srcpath"
    OutFile.WriteLine
    OutFile.WriteLine "all: $(C0).obj $(CX).lib $(bin)\dz.dll $(bin)\dz.exe"
    OutFile.WriteLine
    OutFile.WriteLine "$(C0).obj:"
    OutFile.WriteLine " $(asm) -D__$(mdl)__ -Fo$(C0).obj $(lib)\c0.asm"
    OutFile.WriteLine
    OutFile.WriteLine "$(CX).lib:"
    OutFile.WriteLine " cd clib"
    OutFile.WriteLine " wmake -a af1=/D__DZ__ cln=dz"
    OutFile.WriteLine " cd .."
    OutFile.WriteLine
    OutFile.WriteLine "$(bin)\dz.exe:"
    OutFile.WriteLine " $(asm) -mz -I$(inc) -Fo$(bin)\dz.exe dz\dz.asm"
    OutFile.WriteLine
    OutFile.WriteLine "{$(src)\dzmain}.asm.obj:"
    OutFile.WriteLine " $(asm) $(aflag) $<"
    OutFile.WriteLine "!include $(mif)\doszip.mif"
    OutFile.WriteLine
    OutFile.WriteLine "$(bin)\dz.dll: $(OBJS)"
    OutFile.WriteLine " wlink @<<"
    OutFile.WriteLine "Name $@"
    OutFile.WriteLine "File { $(C0) $(OBJS) }"
    OutFile.WriteLine "Library $(CX).lib"
    OutFile.WriteLine "OPtion NODefaultlibs"
    OutFile.WriteLine "OPtion NOCaseexact"
    OutFile.WriteLine "OPtion Map"
    OutFile.WriteLine "System DOS"
    OutFile.WriteLine "<<"
    OutFile.WriteLine " @del *.obj"
    OutFile.WriteLine
    OutFile.Close

WScript.StdOut.WriteLine "Create srcpath"
    Set OutFile = FSO.CreateTextFile(RootDir + "\src\srcpath")
    OutFile.WriteLine "# SRCPATH--"
    OutFile.WriteLine "# Doszip root directory"
    OutFile.WriteLine "#"
    OutFile.WriteLine "rot=" + RootDir
    OutFile.WriteLine "inc=$(rot)\inc"
    OutFile.WriteLine "src=$(rot)\src"
    OutFile.WriteLine "!ifndef mdl"
    OutFile.WriteLine "mdl=l"
    OutFile.WriteLine "!endif"
    OutFile.WriteLine "!ifndef bin"
    OutFile.WriteLine "bin=."
    OutFile.WriteLine "!endif"
    OutFile.WriteLine "mif=$(src)\mif"
    OutFile.WriteLine "!ifndef debug"
    If DebugBuild Then
	OutFile.WriteLine "debug=1"
    Else
	OutFile.WriteLine "debug=0"
    End If
    OutFile.WriteLine "!endif"
    OutFile.WriteLine "!if $(debug)"
    OutFile.WriteLine "lib=$(rot)\lib\debug"
    OutFile.WriteLine "dflag=-DDEBUG"
    OutFile.WriteLine "af3=-Zd"
    OutFile.WriteLine "lf2=Debug watcom all"
    OutFile.WriteLine "!else"
    OutFile.WriteLine "lib=$(rot)\lib"
    OutFile.WriteLine "!endif"
    OutFile.WriteLine "sys=dos"
    OutFile.WriteLine "asm=" + JWasmPath + "\asm.exe -q"
    OutFile.WriteLine "link=wlink"
    OutFile.WriteLine "!ifdef cln"
    OutFile.WriteLine "CX=$(lib)\$(cln)"
    OutFile.WriteLine "!else"
    OutFile.WriteLine "CX=$(lib)\c$(mdl)"
    OutFile.WriteLine "!endif"
    OutFile.WriteLine "lf3=op q op map"
    OutFile.WriteLine "libc=wlib -q -c $(CX).lib"
    OutFile.WriteLine "C0=$(lib)\c0$(mdl)"
    OutFile.WriteLine
    OutFile.WriteLine "aflag=-D__$(mdl)__ -I$(inc) $(af3) $(af2) $(af1) $(dflag)"
    OutFile.WriteLine "cflag=-I$(inc)\h $(cf3) $(cf2) $(cf1) $(dflag)"
    OutFile.WriteLine "lflag=$(lf3) $(lf2) $(lf1)"
    OutFile.WriteLine
    OutFile.WriteLine "!ifdef name"
    OutFile.WriteLine ".asm.obj:"
    OutFile.WriteLine " $(asm) $(aflag) $*.asm"
    OutFile.WriteLine ".c.obj:"
    OutFile.WriteLine " $(cc) $(cflag) $*.c"
    OutFile.WriteLine
    OutFile.WriteLine "! ifndef objs"
    OutFile.WriteLine "objs=$(name).obj"
    OutFile.WriteLine "! endif"
    OutFile.WriteLine
    OutFile.WriteLine "$(bin)\$(name).exe: $(objs)"
    OutFile.WriteLine " $(link) $(lflag) @<<"
    OutFile.WriteLine "Name $@"
    OutFile.WriteLine "System $(sys)"
    OutFile.WriteLine "OPtion NOCASE"
    OutFile.WriteLine "File { $(C0).obj $(objs) }"
    OutFile.WriteLine "LIBPath $(lib)"
    OutFile.WriteLine "Library $(CX).lib"
    OutFile.WriteLine "<<"
    OutFile.WriteLine " del *.obj"
    OutFile.WriteLine "!endif"
    OutFile.Close

WScript.StdOut.WriteLine "Create clib\makefile"
    Set OutFile = FSO.CreateTextFile(RootDir + "\src\clib\makefile")
    OutFile.WriteLine "!include ..\srcpath"
    OutFile.WriteLine "!include $(mif)\clib.mif"
    OutFile.WriteLine
    OutFile.WriteLine "$(CX).lib: $(OBJS)"
    OutFile.WriteLine " $(libc) @<<"
    OutFile.WriteLine "$(OBJS)"
    OutFile.WriteLine "<<"
    OutFile.WriteLine " del *.obj"
    OutFile.WriteLine
    OutFile.WriteLine "!include $(mif)\clibo.mif"
    OutFile.Close


mif_directory = RootDir + "\src\mif"
mif_list1 = mif_directory + "\list1.cfg"
mif_list2 = mif_directory + "\list2.cfg"
mif_list3 = mif_directory + "\list3.cfg"
mif_list4 = mif_directory + "\list4.cfg"
mif_list5 = mif_directory + "\list5.cfg"

WScript.StdOut.WriteLine "Create list1.cfg -- dzmain object list using &"
    Set OutFile = FSO.CreateTextFile(mif_list1)
    OutFile.WriteLine "-q"
    OutFile.WriteLine "-y"
    OutFile.WriteLine "-hOBJS=&"
    OutFile.WriteLine mif_directory + "\doszip.mif"
    OutFile.WriteLine RootDir + "\src\dzmain\*.asm"
    OutFile.WriteLine " %n.obj &\n"
    OutFile.Close

WScript.StdOut.WriteLine "Create list2.cfg -- clib object list using &"
    Set OutFile = FSO.CreateTextFile(mif_list2)
    OutFile.WriteLine "-q"
    OutFile.WriteLine "-r"
    OutFile.WriteLine "-y"
    OutFile.WriteLine "-hOBJS=&"
    OutFile.WriteLine mif_directory + "\clib.mif"
    OutFile.WriteLine RootDir + "\src\clib\*.asm"
    OutFile.WriteLine " %n.obj &\n"
    OutFile.Close

WScript.StdOut.WriteLine "Create list3.cfg -- clib obj &"
    Set OutFile = FSO.CreateTextFile(mif_list3)
    OutFile.WriteLine "-q"
    OutFile.WriteLine "-r"
    OutFile.WriteLine "-y"
    OutFile.WriteLine "-xd"
    OutFile.WriteLine mif_directory + "\clibo.mif"
    OutFile.WriteLine RootDir + "\src\clib\*.asm"
    OutFile.WriteLine "%n.obj:\n $(asm) $(aflag) %f\n"
    OutFile.Close

WScript.StdOut.WriteLine "Create list4.cfg -- Resource obj:"
    Set OutFile = FSO.CreateTextFile(mif_list4)
    OutFile.WriteLine "-q"
    OutFile.WriteLine "-a"
    OutFile.WriteLine "-r"
    OutFile.WriteLine "-y"
    OutFile.WriteLine "-xd"
    OutFile.WriteLine mif_directory + "\clibo.mif"
    OutFile.WriteLine RootDir + "\src\clib\*.idd"
    OutFile.WriteLine "%n.obj:\n $(src)\\tools\\iddc -m$(mdl) %f\n"
    OutFile.Close

WScript.StdOut.WriteLine "Create list5.cfg -- Resource obj &"
    Set OutFile = FSO.CreateTextFile(mif_list5)
    OutFile.WriteLine "-q"
    OutFile.WriteLine "-a"
    OutFile.WriteLine "-r"
    OutFile.WriteLine "-y"
    OutFile.WriteLine mif_directory + "\clib.mif"
    OutFile.WriteLine RootDir + "\src\clib\*.idd"
    OutFile.WriteLine " %n.obj &\n"
    OutFile.Close

WScript.StdOut.WriteLine "Create clib\update.bat"
    Set OutFile = FSO.CreateTextFile(RootDir + "\src\clib\update.bat")
    OutFile.WriteLine "@echo off"
    OutFile.WriteLine RootDir + "\src\tools\list @" + mif_list1
    OutFile.WriteLine RootDir + "\src\tools\list @" + mif_list2
    OutFile.WriteLine RootDir + "\src\tools\list @" + mif_list3
    OutFile.WriteLine RootDir + "\src\tools\list @" + mif_list4
    OutFile.WriteLine RootDir + "\src\tools\list @" + mif_list5
    OutFile.Close

WScript.StdOut.WriteLine "Execute clib\update.bat..."
WScript.StdOut.WriteLine
Dim OSshell
Set OSshell = CreateObject("Shell.Application")
    OSshell.ShellExecute RootDir + "\src\clib\update.bat",,,,0

Function FindFile(FileName)
    Set FSO = CreateObject("Scripting.FileSystemObject")
    Set WshShell = CreateObject("WScript.Shell")
    PathDirs = Split(WshShell.ExpandEnvironmentStrings("%PATH%"), ";")
    For Each Dir In PathDirs
	If Right(Dir, 1) = "\" Then
	    Dir = Left(Dir, Len(Dir) - 1)
	End If
	If FSO.FileExists(Dir + "\" + FileName) Then
	    FindFile = Dir
	    Exit Function
	End If
    Next
    FindFile = ""
End Function
