include ..\..\inc\version.inc
include ..\..\inc\plugins.inc

__LFN__		EQU 	1	; use long file names
__MOUSE__ 	EQU 	1	; use mouse

lodm	MACRO	p
	mov	dx,word ptr p+2
	mov	ax,word ptr p
	ENDM

stom	MACRO	p
	mov	word ptr p+2,dx
	mov	word ptr p,ax
	ENDM

movm	MACRO	des,src
	lodm	src
	stom	des
	ENDM

movw	macro	des, src
	mov	ax,word ptr src
	mov	word ptr des,ax
	endm

movmx	macro	des, src
	mov	ax,word ptr src+2
	mov	word ptr des+2,ax
	mov	ax,word ptr src
	mov	word ptr des,ax
	endm

pushm   MACRO	p
	push    word ptr p+2
	push    word ptr p
	ENDM

cmprm	macro	src
local	@@
	cmp	dx,word ptr src+2
	jne	@@
	cmp	ax,word ptr src
	@@:
	endm

cmpmr	macro	src
local	@@
	cmp	word ptr src+2,dx
	jne	@@
	cmp	word ptr src,ax
	@@:
	endm

cmpmm	macro	des,src
	lodm	des
	cmprm	src
	endm

cmpmi	macro	src,val
local	@@
	cmp	word ptr src+2,0
	jne	@@
	cmp	word ptr src,val
	@@:
	endm

CStr	MACRO text
	local xxx
	.data
	xxx db text,0
	.code
	exitm <offset xxx>
	ENDM

CString MACRO text
	local xxx
	.data
	xxx db text,0
	.code
	exitm <cs:xxx>
	ENDM

; dir.inc

WMAXPATH  	= 260
WMAXDRIVE 	= 3
WMAXDIR   	= 256
WMAXFILE  	= 256
WMAXEXT   	= 256
MAXPATH	  	= 80
MAXDRIVE  	= 3
MAXDIR    	= 66
MAXFILE   	= 9
MAXEXT    	= 5
SIZEWFBLK 	= 318

getdrv		PROTO
chdrv		PROTO PASCAL :WORD
chdir		PROTO PASCAL :DWORD
mkdir		PROTO PASCAL :DWORD
rmdir		PROTO PASCAL :DWORD
getcwdd		PROTO PASCAL :DWORD, :WORD
fullpath	PROTO PASCAL :DWORD, :WORD

; dos.inc

SEEK_SET = 0
SEEK_CUR = 1
SEEK_END = 2

_A_NORMAL EQU	00h
_A_RDONLY EQU	01h
_A_HIDDEN EQU	02h
_A_SYSTEM EQU	04h
_A_VOLID  EQU	08h
_A_SUBDIR EQU	10h
_A_ARCH	  EQU	20h

_A_STDFILES = _A_ARCH or _A_RDONLY or _A_SYSTEM or _A_SUBDIR
_A_ALLFILES = _A_STDFILES or _A_HIDDEN

S_FFBLK		STRUC
ff_reserved	DB 21 dup(?)
ff_attrib	DB ?
ff_ftime	DW ?
ff_fdate	DW ?
ff_fsize	DD ?
ff_name		DB 13 dup(?)
S_FFBLK		ENDS

S_WFBLK		STRUC
wf_attrib	DW ?	; DWORD File attributes
wf_attribdx	DW ?
wf_timecreate	DW ?	; QWORD	File creation time
wf_datecreate	DW ?
wf_createdate	DD ?
wf_timeaccess	DW ?	; QWORD	Last access time
wf_dateaccess	DW ?
wf_accessdate	DD ?
wf_timemodified DW ?	; QWORD	Last modification time
wf_datemodified DW ?
wf_modified	DD ?
wf_sizedx	DD ?	; QWORD	File size
wf_sizeax	DD ?	; - low DWORD
wf_reserved	DB 8 dup(?)
wf_name		DB 260 dup(?)
wf_shortname	DB  14 dup(?)
S_WFBLK		ENDS	;  318 byte

S_DISKFREE	STRUC
df_size		DW ?
df_version	DW ?
df_sclus	DD ?
df_bsec		DD ?
df_avail	DD ?
df_total	DD ?
df_phavail	DD ?
df_phtotal	DD ?
df_alavail	DD ?
df_altotal	DD ?
df_reserved	DB 8 dup(?)
S_DISKFREE 	ENDS

DT_BASEYEAR	= 1980

getday		proto
getsec		proto
getmin		proto
gethour		proto
getmnd		proto
getyear		proto
getdatew	proto
dwdosdate	proto
twdostime	proto

getfattr	proto pascal filename:dword
filexist	proto pascal filename:dword
remove		proto pascal filename:dword
rename		proto pascal oldname:dword, newname:dword
wlongname 	proto pascal path:dword, filename:dword
wlongpath 	proto pascal path:dword, filename:dword
wfindfirst 	proto pascal filemask:dword, wfblk:dword, attrib:word
wfindnext 	proto pascal wfblk:dword, handle:word
wcloseff 	proto pascal handle:word
wshortname 	proto pascal path:dword
getftime	proto pascal handle:word
findfirst	proto pascal :DWORD, :DWORD, :WORD
findnext	proto pascal :DWORD
setfdate	proto pascal :WORD, :WORD, :WORD
setfattr	proto pascal :DWORD, :WORD
wsetaccessdate	proto pascal :WORD, :WORD, :WORD
wsetcreatedate	proto pascal :WORD, :WORD, :WORD
wsetfattr	proto pascal :DWORD, :WORD
wgetfattr	proto pascal :DWORD
wsetacdate	proto pascal :DWORD, :WORD
wsetwrdate	proto pascal :DWORD, :WORD, :WORD
wsetcrdate	proto pascal :DWORD, :WORD, :WORD
wgetacdate	proto pascal :DWORD
wgetwrdate	proto pascal :DWORD
wgetcrdate	proto pascal :DWORD
wfullpath	proto pascal :DWORD, :WORD
wvolinfo	proto pascal :DWORD, :DWORD
wgetcwd		proto pascal :DWORD, :WORD
removefile	proto pascal filename:dword

; stdio.inc

_STDIN		= 0
_STDOUT		= 1
_STDERR		= 2

S_FILE		STRUC
iob_bp		DD ?
iob_cnt		DW ?
iob_base	DD ?
iob_flag	DW ?
iob_file	DW ?
iob_bufsize	DW ?
iob_charbuf	DW ?
S_FILE		ENDS

csprintf 	proto fastcall, buffer:word, format:word
ssprintf 	proto fastcall, buffer:word, format:word

; wsub.inc

MAXFBLOCK	= 3000
WMAXFBLOCK	= 3FFFh

_A_FATTRIB	= 003Fh
_A_SELECTED	= 0040h
_A_UPDIR	= 0080h
_A_CDROOM	= 0100h
_A_ENCRYPTED	= 0200h
_A_EXTLOCHD	= 0400h
_A_ARCHEXT	= 4000h
_A_ARCHZIP	= 8000h
_A_ARCHIVE	= 0C000h

_W_PANELID	= 0001h
_W_VISIBLE	= 0002h
_W_MINISTATUS	= 0004h
_W_WIDEVIEW	= 0008h
_W_LONGNAME	= 0010h
_W_DETAIL	= 0020h
_W_HIDDEN	= 0040h
_W_FLOPPY	= 0080h
_W_CDROOM	= 0100h
_W_NETWORK	= 0180h
_W_SORTNAME	= 0000h
_W_SORTTYPE     = 0200h
_W_SORTDATE     = 0400h
_W_SORTSIZE	= 0600h
_W_NOSORT	= 0800h
_W_SORTSUB	= 1000h
_W_DRVINFO	= 2000h
_W_ARCHEXT	= 4000h
_W_ARCHZIP	= 8000h
_W_ARCHIVE	= _W_ARCHZIP or _W_ARCHEXT

S_FBLK		STRUC
fb_flag		DW ?
fb_time		DW ?
fb_date		DW ?
fb_size		DD ?
fb_name		DB 2 dup(?)
S_FBLK		ENDS

S_PATH		STRUC
wp_flag		DW ?
wp_mask		DB  32 dup(?)
wp_file		DB 260 dup(?)
wp_arch		DB 260 dup(?)
wp_path		DB 260 dup(?)
S_PATH		ENDS	;  816 byte

S_WSUB		STRUC
ws_count	DW ?
ws_maxfb	DW ?
ws_flag		DD ?
ws_mask		DD ?
ws_file		DD ?
ws_arch		DD ?
ws_path		DD ?
ws_fcb		DD ?
S_WSUB		ENDS	; 28 byte

fbcolor		PROTO
fbputsl		PROTO
fbputsd		PROTO
fbputll		PROTO
fbputld		PROTO
fbputdate	PROTO
fbputtime	PROTO
fbputfile	PROTO
fbupdir     	PROTO PASCAL :WORD
fbinvert    	PROTO PASCAL :DWORD
fbselect    	PROTO PASCAL :DWORD
fballocff   	PROTO PASCAL :DWORD, :WORD
fballocwf   	PROTO PASCAL :DWORD, :WORD
fbstaticff  	PROTO PASCAL :DWORD

wsopen	    	PROTO PASCAL :DWORD
wsclose    	PROTO PASCAL :DWORD
wsinit     	PROTO PASCAL :DWORD
wsfree     	PROTO PASCAL :DWORD
wsread     	PROTO PASCAL :DWORD
wssort     	PROTO PASCAL :DWORD
wssetflag  	PROTO PASCAL :DWORD
wslocal    	PROTO PASCAL :DWORD
wschdrv    	PROTO PASCAL :DWORD, :WORD
wsearch    	PROTO PASCAL :DWORD, :DWORD
wsfblk     	PROTO PASCAL :DWORD, :WORD
wsffirst   	PROTO PASCAL :DWORD
wsmkdir    	PROTO PASCAL :DWORD, :DWORD

wsetprogress	PROTO
wdlgopen 	PROTO PASCAL :DWORD, :DWORD, :WORD
wgetfile	PROTO
wscopy_open	PROTO
wscopy_remove   PROTO
wsopenarch 	PROTO PASCAL :DWORD
wzipread   	PROTO PASCAL :DWORD
wzipopen	PROTO
wzipclose       PROTO
wsdecomp 	PROTO PASCAL :DWORD, :DWORD, :DWORD
wzipadd		PROTO PASCAL :DWORD, :WORD, :WORD, :WORD
wzipdel 	PROTO PASCAL :DWORD, :DWORD, :WORD
wzipcopy	PROTO PASCAL :DWORD, :DWORD, :DWORD
wzipcopypath 	PROTO PASCAL :DWORD, :DWORD, :DWORD
wzipcopyfile 	PROTO PASCAL :DWORD, :DWORD, :DWORD
wzipfindentry	PROTO PASCAL :DWORD, :WORD
fbupdir 	PROTO PASCAL :WORD
testentryname 	PROTO PASCAL :DWORD, :DWORD
wsclrsel 	PROTO PASCAL :DWORD

; iost.inc

IO_STRINGB	EQU	0080h	; String buffer
IO_ERROR	EQU	8000h	; Write fault

S_IOST		STRUC
ios_bp		DW ?
ios_i		DW ?
ios_c		DW ?
ios_size	DW ?
ios_flag	DW ?
ios_file	DW ?
S_IOST		ENDS

ogetc		proto
ogets		proto

; doszip.inc

_C_ZINCSUBDIR	= 01h	; config.c_compress

_COPY_SELECTED	= 01h	; copy selected files
_COPY_IARCHIVE	= 02h	; source is archive
_COPY_OARCHIVE	= 04h	; target is archive
_COPY_IEXTFILE	= 08h	; source is .DLL archive - %doszip%/dll/.dll
_COPY_IZIPFILE	= 10h	; source is .ZIP archive
_COPY_OZIPFILE	= 20h	; target is .ZIP archive
_COPY_OEXTFILE	= 40h	; target is .DLL archive
_COPY_RECURSIV	= 80h	; recursive error

S_XCELL		STRUC
xl_flag		DW ?	; DOBJ.dl_flag
xl_cols		DB ?	; number of files in one line
xl_rows		DB ?	; number of lines in panel
xl_rect		DD ?	; the current position of cell
xl_bp		DD ?	; DOBJ.dl_wp
xl_cpos		DD ?	; position of first cell in panel
S_XCELL		ENDS

S_PANEL		STRUC
pn_path		DW ?	; -- offset S_PATH
pn_flag		DW ?
pn_fcb_count	DW ?
pn_cel_count	DW ?
pn_fcb_index	DW ?
pn_cel_index	DW ?
pn_xl		DD ?
pn_dialog	DD ?
pn_wsub		DD ?
pn_putfcb	DW ?
S_PANEL		ENDS

S_DZDS		STRUC	; DS:[0000]
C0_NULL		dd ?	; Module: C0.ASM
C0_abortmsg	db 30 dup(?)
C0_argc		dw ?
C0_argv		dd ?
C0_psp		dw ?
C0_envlen	dw ?
C0_envseg	dw ?
C0_envsize	dw ?
C0_osversion	dw ?
C0_errno	dw ?
C0_doserrno	dw ?
C0_sys_erproc	dd ?
C0_sys_erdevice dd ?
C0_sys_ercode	dw ?
C0_sys_erflag	db ?
C0_sys_erdrive	db ?
C0_oldint_24	dd ?
C0_oldint_23	dd ?
C0_heaptop	dw ?
C0_heapbase	dw ?
C0_heapfree	dw ?
C0_brklvl	dw ?
DZ_stklen	dw ?	; Module: dzmain.asm
DZ_ifsmgr	db ?	; init value of _ifsmgr
DZ_envconf	dd ?
DZ_envtemp	dd ?
DZ_envpath	dd ?
DZ_comspec	dd ?
DZ_dzexe	dd ?
DZ_dzerrno	dw ?
DZ_dzerflag 	dw ?
DZ_dzcount	dw ?
DZ_mainswitch 	dw ?
DZ_dzexitcode	dw ?
DZ_numfblock 	dw ?
DZ_argvfile	dw ?
DZ_programpath	db MAXPATH dup(?)
DZ_configpath	db MAXPATH dup(?)
DZ_c_version	dw ?
DZ_c_lflag	dw ?
DZ_c_confirm	db ?
DZ_c_console	db ?
DZ_c_exconsole	db ?
DZ_c_fsflag	db ?
DZ_c_tvflag	db ?	; -- tview.asm
DZ_c_teflag	dw ?	; -- tedit.asm
DZ_c_tepages	dw ?	; -- tedit.asm Max EMS pages to alloc
DZ_c_telsize	db ?	; -- tedit.asm Max line length
DZ_c_tetabsize	db ?	; -- tedit.asm Tab Size
DZ_c_compress	db ?	; -- packer.asm (deleted)
DZ_c_ffflag	db ?	; -- packer.asm (deleted)
DZ_c_comprlevel	db ?
DZ_c_panelsize	db ?
DZ_c_flaga	dw ?
DZ_c_fcb_indexa	dw ?
DZ_c_cel_indexa	dw ?
DZ_c_flagb	dw ?
DZ_c_fcb_indexb	dw ?
DZ_c_cel_indexb	dw ?
DZ_c_apath	db size S_PATH dup(?)
DZ_c_bpath	db size S_PATH dup(?)
DZ_c_filter	db 270 dup(?)	; S_FILT
DZ_c_color	db  40 dup(?)
DZ_c_deleteme	db WMAXPATH dup(?)
DZ_cpanel	dw ?
DZ_panela	dw ?
DZ_panelb	dw ?
DZ_Menusline	dd ?
DZ_Commandline	dd ?
DZ_Statusline	dd ?
DZ_copy_flag	db ?
DZ_copy_fast	db ?
DZ_copy_filecount dw ?
DZ_copy_subdcount dw ?
DZ_srcfile	db 384 dup(?)
DZ_srcpath	db WMAXPATH dup(?)
DZ_outfile	db 384 dup(?)
DZ_outpath	db WMAXPATH dup(?)
DZ_entryname	db 512 dup(?)
DZ_bufin	db 4096 dup(?)
S_DZDS		ENDS

; globals (DS==SS)

_ifsmgr		equ	ds:[DZ_ifsmgr]
_psp		equ	ds:[C0_psp]
envseg		equ	ds:[C0_envseg]
envlen		equ	ds:[C0_envlen]
envsize		equ	ds:[C0_envsize]
_osminor	equ	byte ptr ds:[C0_osversion]
_osmajor	equ	byte ptr ds:[C0_osversion+1]
_osversion	equ	ds:[C0_osversion]
errno		equ	ds:[C0_errno]
doserrno	equ	ds:[C0_doserrno]
sys_erdevice	equ	ds:[C0_sys_erdevice]
sys_ercode	equ	ds:[C0_sys_ercode]
sys_erflag	equ	ds:[C0_sys_erflag]
sys_erdrive	equ	ds:[C0_sys_erdrive]
sys_erproc	equ	ds:[C0_sys_erproc]

envconf		equ	ds:[DZ_envconf]
envtemp		equ	ds:[DZ_envtemp]
envpath		equ	ds:[DZ_envpath]
comspec		equ	ds:[DZ_comspec]
srcpath		equ	ds:[DZ_srcpath]
outpath		equ	ds:[DZ_outpath]
srcfile		equ	ds:[DZ_srcfile]
outfile		equ	ds:[DZ_outfile]
entryname	equ	ds:[DZ_entryname]
_bufin		equ	ds:[DZ_bufin]
panela		equ	ds:[DZ_panela]
panelb		equ	ds:[DZ_panelb]
cpanel		equ	ds:[DZ_cpanel]
compresslevel	equ	ds:[DZ_c_comprlevel]
compressflag	equ	ds:[DZ_c_compress]

dosmaper 	proto
malloc		proto pascal :word
free		proto pascal :dword
rsmodal		proto pascal res:dword
dzexec		proto pascal command:dword, exe_type:byte
dzview		proto pascal fname:dword, offs:dword
dzedit		proto pascal fname:dword, line:word
tgetline 	proto pascal dtitle:dword, buffer:word, bsize:word, lsize:word
dzmklist 	proto pascal o_name:word

; dll.inc

MAXENTRYNAME	= 512

ENOENT		= 2

ER_EXEC		= 2
ER_ZIP		= 2
ER_BADERR	= 3
ER_MEM		= 4
ER_CRCERR	= 5
ER_NOZIP	= 9
ER_FIND		= 11
ER_OPEN		= 12
ER_DISK		= 50
ER_USERABORT	= 66
ER_READARCH	= -2
ER_DISK_FULL	= 112
ER_NEGATIVE_SEEK = 131

; DLL functions

dll_read	PROTO PASCAL wsub:dword
dll_copy	PROTO PASCAL wsub:dword, fblk:dword, outp:dword
dll_add		PROTO PASCAL wsub:dword, wsub:dword, fblk:dword
dll_move	PROTO PASCAL wsub:dword, fblk:dword, wsub:dword
dll_mkdir	PROTO PASCAL wsub:dword, directory:dword
dll_delete	PROTO PASCAL wsub:dword, fblk:dword
dll_rename	PROTO PASCAL wsub:dword, fblk:dword
dll_edit	PROTO PASCAL wsub:dword, fblk:dword
dll_view	PROTO PASCAL wsub:dword, fblk:dword
dll_property	PROTO PASCAL wsub:dword, fblk:dword
dll_enter	PROTO PASCAL wsub:dword, fblk:dword

DLL_Header	MACRO ?PROC, ?FLAG, DLLVERS
	db	'DZ'		; signature
	dw	VERSION		; doszip version
	dw	DLLVERS		; plugin version
$FLAG	dw	?PROC		; functions supported
	dw	?FLAG		; functions that need $PROG
$SIG0	dw	?		; magic signature of archive
$SIG2	dw	?		; set by dll_init(console, stack, magic)
$STACK	dw	?		; stack offset
__mouse	db	1		; installed
__mbool	db	1		; visible
__mflag	db	0		; mouse state
_scrseg	dw	0B800h		; screen segment
_scrcol	db	80		; screen size
_scrrow	db	25
	ENDM

DLL_Startup	MACRO ?PROC, ?FLAG
	org	100h
start:	push	bp		; clear carry flag - assuming success
	mov	bp,sp
	and	byte ptr [bp+6],not 1
	pop	bp
	or	ah,ah
	jnz	DLL_01
    DLL_00:		; 00 dll_init(console, stack, magic)
	mov	cs:__mouse,dh	; console values from dzmain.exe
	mov	cs:__mbool,al
	mov	cs:__mflag,dl
	mov	cs:_scrseg,cx
	mov	cs:_scrcol,bl
	mov	cs:_scrrow,bh
	mov	cs:$SIG0,di	; signature for this archive
	mov	cs:$SIG2,si
	mov	cs:$STACK,es	; stack top -- size(SP-$STACK)
  ifdef DEBUG
	mov	cs:reg_st,es	; ST: <value>
  endif
	jmp	dll_init	; Direct jump to install proc
    DLL_01:		; 01 dll_read(wsub:dword)
	dec	ah
	jnz	DLL_02
	invoke	dll_read, ss::bx
	iret
   DLL_02:		; 02 dll_copy(wsub:dword, fblk:dword, outpath:dword)
	dec	ah
	jnz	DLL_03
  if (?PROC and __DLL_02)	; only implement functions defined
   if (?FLAG and __DLL_02)	; include test if function need $PROG
	test	cs:$FLAG,__DLL_02
	jz	DLL_NOTSUP
   endif
	invoke	dll_copy, ss::bx, es::cx, ss::dx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_03:		; 03 dll_add(wsub:dword, wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_04
  if (?PROC and __DLL_03)
   if (?FLAG and __DLL_03)
	test	cs:$FLAG,__DLL_03
	jz	DLL_NOTSUP
   endif
	invoke	dll_add, ss::bx, ss::dx, es::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_04:		; 04 dll_move(wsub:dword, fblk:dword, wsub:dword)
	dec	ah
	jnz	DLL_05
  if (?PROC and __DLL_04)
   if (?FLAG and __DLL_04)
	test	cs:$FLAG,__DLL_04
	jz	DLL_NOTSUP
   endif
	invoke	dll_move, ss::bx, ss::dx, es::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_05:		; 05 dll_mkdir(wsub:dword)
	dec	ah
	jnz	DLL_06
  if (?PROC and __DLL_05)
   if (?FLAG and __DLL_05)
	test	cs:$FLAG,__DLL_05
	jz	DLL_NOTSUP
   endif
	invoke	dll_mkdir, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_06:		; 06 dll_delete(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_07
  if (?PROC and __DLL_06)
   if (?FLAG and __DLL_06)
	test	cs:$FLAG,__DLL_06
	jz	DLL_NOTSUP
   endif
	invoke	dll_delete, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_07:		; 07 dll_rename(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_08
  if (?PROC and __DLL_07)
   if (?FLAG and __DLL_07)
	test	cs:$FLAG,__DLL_07
	jz	DLL_NOTSUP
   endif
	invoke	dll_rename, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_08:		; 08 dll_edit(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_09
  if (?PROC and __DLL_08)
   if (?FLAG and __DLL_08)
	test	cs:$FLAG,__DLL_08
	jz	DLL_NOTSUP
   endif
	invoke	dll_edit, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_09:		; 09 dll_view(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_0A
  if (?PROC and __DLL_09)
   if (?FLAG and __DLL_09)
	test	cs:$FLAG,__DLL_09
	jz	DLL_NOTSUP
   endif
	invoke	dll_view, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_0A:		; 0A dll_property(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_0B
  if (?PROC and __DLL_0A)
   if (?FLAG and __DLL_0A)
	test	cs:$FLAG,__DLL_0A
	jz	DLL_NOTSUP
   endif
	invoke	dll_property, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_0B:		; 0B dll_enter(wsub:dword, fblk:dword)
	dec	ah
	jnz	DLL_0C
  if (?PROC and __DLL_0B)
   if (?FLAG and __DLL_0B)
	test	cs:$FLAG,__DLL_0B
	jz	DLL_NOTSUP
   endif
	invoke	dll_enter, ss::bx, dx::cx
	iret
  else
	jmp	DLL_NOTSUP
  endif
   DLL_0C:
	dec	ah
   DLL_0D:
	dec	ah
   DLL_0E:
	dec	ah
   DLL_0F:
	dec	ah
   DLL_10:
	dec	ah
   DLL_11:
	dec	ah
	jnz	DLL_NOTSUP
	jmp	dll_exit		; direct jump to exit proc
DLL_NOTSUP:
	mov	ah,0
	push	si
	mov	si,sp
	or	byte ptr [si+6],1	; set carry flag
	pop	si
	iret
	ENDM

DLL_Header	PROC?, FLAG?, DLLVER
DLL_Startup	PROC?, FLAG?

; io.inc

_NFILE_  	EQU	20

_A_NORMAL	EQU	00h
_A_RDONLY	EQU	01h
_A_HIDDEN	EQU	02h
_A_SYSTEM	EQU	04h
_A_SUBDIR	EQU	10h
_A_ARCH		EQU	20h

_A_TEMPORARY    EQU	0100h
_A_DELETE       EQU	0400h
_A_SEQSCAN      EQU	0800h
_A_RANDOM	EQU	1000h

FH_OPEN		EQU	01h
FH_EOF		EQU	02h
FH_CRLF		EQU	04h
FH_PIPE		EQU	08h
FH_APPEND	EQU	20h
FH_DEVICE	EQU	40h
FH_TEXT		EQU	80h

A_OPEN	 	EQU	0001h
A_TRUNC	 	EQU	0002h
A_CREATE	EQU	0010h

M_RDONLY	EQU	0000h
M_WRONLY	EQU	0001h
M_RDWR		EQU	0002h

SEEK_SET    	EQU	0
SEEK_CUR    	EQU	1
SEEK_END    	EQU	2

DEV_UNKNOWN   	EQU	0000h
DEV_DISK      	EQU	0001h
DEV_CHAR      	EQU	0002h
DEV_PIPE      	EQU	0003h
DEV_REMOTE    	EQU	8000h

close		PROTO PASCAL :WORD
read		PROTO PASCAL :WORD, :DWORD, :WORD
write		PROTO PASCAL :WORD, :DWORD, :WORD
lseek		PROTO PASCAL :WORD, :DWORD, :WORD
access		PROTO PASCAL :DWORD, :WORD
remove		PROTO PASCAL :DWORD
rename		PROTO PASCAL :DWORD, :DWORD
chsize		PROTO PASCAL :WORD, :DWORD
setmode		PROTO PASCAL :WORD, :WORD
filelength	PROTO PASCAL :WORD
tell		PROTO PASCAL :WORD
setfdate	PROTO PASCAL :WORD, :WORD, :WORD
setfattr	PROTO PASCAL :DWORD, :WORD
readword	PROTO PASCAL :DWORD
osftype		PROTO PASCAL :WORD
osfiletype	PROTO PASCAL :WORD
osisatty	PROTO PASCAL :WORD
osopen		PROTO PASCAL :DWORD, :WORD, :WORD, :WORD
osread		PROTO PASCAL :WORD, :DWORD, :WORD
oswrite		PROTO PASCAL :WORD, :DWORD, :WORD
oschsize	PROTO PASCAL :WORD, :DWORD
removefile	PROTO PASCAL :DWORD
isatty		PROTO PASCAL :WORD
_dup		PROTO PASCAL :WORD
dup2		PROTO PASCAL :WORD, :WORD

; string.inc

cmpaxi	macro
	mov dx,ax
	sub al,'A'
	sub ah,'A'
	cmp al,'Z' - 'A' + 1
	sbb al,al
	cmp ah,'Z' - 'A' + 1
	sbb ah,ah
	and ax,2020h
	xor ax,dx
	cmp ah,al
	endm

ssistart	proto
ssitoend	proto
ftolower	proto
strcmpi		proto

memcpy		proto pascal :dword, :dword, :word
memmove		proto pascal :dword, :dword, :word
memset		proto pascal :dword, :word, :word
memzero		proto pascal :dword, :word
memxchg		proto pascal :dword, :dword, :word
strlen		proto pascal :dword
strcpy		proto pascal :dword, :dword
strncpy		proto pascal :dword, :dword, :word
strcat		proto pascal :dword, :dword
strncat		proto pascal :dword, :dword, :word
strcmp		proto pascal :dword, :dword
strncmp		proto pascal :dword, :dword, :word
stricmp		proto pascal :dword, :dword
strnicmp	proto pascal :dword, :dword, :word
strchr		proto pascal :dword, :word
strrchr		proto pascal :dword, :word
strstr		proto pascal :dword, :dword
strlwr		proto pascal :dword
strrev		proto pascal :dword
strupr		proto pascal :dword
strstart	proto pascal :dword
strtrim		proto pascal :dword
strfn		proto pascal :dword
strfcat		proto pascal :dword, :dword, :dword
argvext		proto pascal :dword, :dword
strtol		proto pascal :dword
cmpwarg		proto pascal :dword, :dword
cmpwargs	proto pascal :dword, :dword
strxchg		proto pascal :dword, :dword, :dword, :word
dostounix	proto pascal :dword
unixtodos	proto pascal :dword
atohex		proto pascal :dword
hextoa		proto pascal :dword
setfext		proto pascal :dword, :dword
strext		proto pascal :dword

; stdlib.inc

atol	  	PROTO PASCAL :DWORD
xtol	  	PROTO PASCAL :DWORD
qwtostr  	PROTO PASCAL :DWORD, :DWORD
qwtobstr 	PROTO PASCAL :DWORD, :DWORD
mkbstring 	PROTO PASCAL :DWORD, :DWORD, :DWORD
searchp  	PROTO PASCAL :DWORD
getenvp		PROTO PASCAL :DWORD
getenval	PROTO PASCAL :DWORD, :DWORD
expenviron	PROTO PASCAL :DWORD
isexec		PROTO

; assert.inc

ifdef DEBUG
DCALL	equ	<call>
DADD	equ	<add>
DSUB	equ	<sub>
DMOV	equ	<mov>
DPUSH	equ	<push>
DPOP	equ	<pop>

@vsbufin	PROTO

_printf	proc
	call	@vsbufin
	mov	dx,offset _bufin
	mov	bx,_STDOUT
	mov	cx,ax
	mov	ax,4000h
	int	21h
	ret	; Return number of chars written
_printf	endp

reg_ax	dw ?
reg_dx	dw ?
reg_bx	dw ?
reg_cx	dw ?
reg_cs	dw ?
reg_ip	dw ?
reg_ds	dw ?
reg_si	dw ?
reg_es	dw ?
reg_di	dw ?
reg_ss	dw ?
reg_sp	dw ?
reg_bp	dw ?
reg_st	dw ?
?flags	dw ?

?fbuf	db 256 dup(?)

?failed	db 13,10,"assert failed:",9,0
?regs	db 13,10,13,10
	db '         regs:  AX: %04X DX: %04X',13,10
	db 9,9,	'BX: %04X CX: %04X',13,10
	db 9,9,	'CS: %04X IP: %04X',13,10
	db 9,9,	'DS: %04X SI: %04X',13,10
	db 9,9,	'ES: %04X DI: %04X',13,10
	db 9,9,	'SS: %04X SP: %04X',13,10
	db 9,9,	'BP: %04X ST: %04X',13,10
	db 13,10
	db 9,'flags:  %016lb',13,10
	db 9,'        r n oditsz a p c',13,10,0

assert_out proc
	mov	cs:[reg_ax],ax
	mov	cs:[reg_dx],dx
	mov	cs:[reg_bx],bx
	mov	cs:[reg_cx],cx
	mov	cs:[reg_es],es
	pop	ax
	pop	dx
	mov	cs:[reg_ip],dx
	push	cs
	push	offset ?fbuf
	push	cs
	push	ax
	call	strcpy
	mov	ax,offset ?fbuf
	call	_printf
	mov	ax,cs:[reg_ax]
	mov	dx,cs:[reg_dx]
	mov	bx,cs:[reg_bx]
	mov	cx,cs:[reg_cx]
	mov	es,cs:[reg_es]
	push	cs:[reg_ip]
	ret
assert_out endp

assert_exit proc
	mov	cs:[reg_ds],ds
	push	cs
	pop	ds
	ASSUME	ds:_TEXT
	mov	[reg_ax],ax
	pushf
	pop	ax
	mov	[?flags],ax
	mov	[reg_dx],dx
	mov	[reg_bx],bx
	mov	[reg_cx],cx
	mov	[reg_si],si
	mov	[reg_es],es
	mov	[reg_di],di
	mov	[reg_ss],ss
	mov	[reg_bp],bp
	pop	ax
	mov	[reg_ip],ax
	mov	dx,cs
	mov	[reg_cs],dx
	mov	[reg_sp],sp
	push	ds
	push	offset ?fbuf
	push	dx
	push	ax
	call	strcpy
	cld
	mov	ax,0B800h
	mov	es,ax
	mov     bh,0
	mov     ah,3
	mov     ah,3
	int     10h
	mov	al,80*2
	mul	dh
	mov	di,ax
	mov	ax,0720h
	mov	cx,2*80
	rep	stosw
	push	ss
	pop	ds
	ASSUME	ds:nothing
	mov	ax,offset ?failed
	call	_printf
	mov	ax,offset ?fbuf
	call	_printf
	push    cs:[?flags]
	push	cs:[reg_st]
	push	cs:[reg_bp]
	push	cs:[reg_sp]
	push	cs:[reg_ss]
	push	cs:[reg_di]
	push	cs:[reg_es]
	push	cs:[reg_si]
	push	cs:[reg_ds]
	push	cs:[reg_ip]
	push	cs:[reg_cs]
	push	cs:[reg_cx]
	push	cs:[reg_bx]
	push	cs:[reg_dx]
	push	cs:[reg_ax]
	mov	ax,offset ?regs
	call	_printf
	mov	dx,cs
	mov	bx,CStr(<"echo assert_exit(23)">)
	mov	ah,_DZ_COMMAND
	int	DZ
	mov	ah,4Ch
	mov	al,23
	int	21h
	ret
assert_exit endp
else
DCALL	MACRO	a,b,c,d,e,f
	ENDM
DADD	MACRO	a,b,c,d,e,f
	ENDM
DSUB	MACRO	a,b,c,d,e,f
	ENDM
DMOV	MACRO	a,b,c,d,e,f
	ENDM
DPUSH	MACRO	a,b,c
	ENDM
DPOP	MACRO	a,b,c
	ENDM
endif ;	DEBUG

tracev	MACRO message,len
	local @@
  ifdef DEBUG
	push offset @@
	call assert_out
	DB message,0
	@@:
	add sp,len
  endif
	ENDM

assert	MACRO A,B,J,message
	local @@
  ifdef DEBUG
	pushf
	cmp A,B
	&J @@
	popf
	call assert_exit
	DB "cmp &A&,&B& (&J&) - ",message,0
	@@:
	popf
  endif
	ENDM

assertf	MACRO J,message
	local @@
  ifdef DEBUG
	&J @@
	call assert_exit
	DB "flag (&J&) - ",message,0
	@@:
  endif
	ENDM

assertt	MACRO A,B,J,message
	local @@
  ifdef DEBUG
	pushf
	test A,B
	&J @@
	popf
	call assert_exit
	DB "test &A&,&B& (&J&) - ",message,0
	@@:
	popf
  endif
	ENDM

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

wsopenarch proc pascal wsub:dword
local	arcname[WMAXPATH]:byte
	les	bx,wsub
	invoke	strfcat, addr arcname, es:[bx].ws_path, es:[bx].ws_file
	invoke	osopen, dx::ax, _A_NORMAL, M_RDONLY, A_OPEN
	ret
wsopenarch endp

wsfblk	proc pascal wsub:dword, index:word
	mov	ax,index
	les	bx,wsub
	cmp	es:[bx],ax
	jle	wsfblk_err
	les	bx,es:[bx].ws_fcb
	add	ax,ax
	add	ax,ax
	add	bx,ax
	mov	dx,es:[bx+2]
	mov	bx,es:[bx]	; return DX:BX, ES:BX - fblk
	mov	es,dx		;        DX:AX - fblk.name
	mov	ax,bx		;        CX - fblk.flag
	add	ax,fb_name	;        ZF - clear
	mov	cx,es:[bx]
    wsfblk_end:
	ret
    wsfblk_err:
	xor	ax,ax
	mov	dx,ax
	jmp	wsfblk_end
wsfblk	endp

panel_curobj proc
	mov	bx,ax
	mov	ax,word ptr [bx].pn_wsub
	test	ax,ax
	jnz	@F
	cwd
	ret
      @@:
	mov	ax,[bx].pn_fcb_index
	add	ax,[bx].pn_cel_index
	invoke	wsfblk, [bx].pn_wsub, ax
	ret
panel_curobj endp

wsfree	proc pascal wsub:dword
	push	si
	push	di
	mov	di,word ptr wsub
	xor	ax,ax
	mov	si,ax
	cmp	word ptr [di].ws_fcb,ax
	jz	wsfree_end
	cmp	[di].ws_count,ax
	jz	wsfree_end
    wsfree_loop:
	les	bx,[di].ws_fcb
	mov	ax,si
	shl	ax,2
	add	bx,ax
	xor	ax,ax
	cmp	ax,es:[bx]	; assume offset == 4
	je	@F
	pushm	es:[bx]
	mov	es:[bx],ax
	mov	es:[bx+2],ax
	call	free
      @@:
	inc	si
	dec	[di].ws_count
	jnz	wsfree_loop
    wsfree_end:
	mov	ax,si
	pop	di
	pop	si
	ret
wsfree	endp
;
; Clear selection set from panel
;
wsclrsel proc pascal wsub:dword
	push	si
	push	di
	mov	si,1
	mov	di,word ptr wsub
	cmp	[di].ws_count,si
	jbe	wsclrsel_end
    wsclrsel_loop:
	cmp	[di].ws_count,si
	jbe	wsclrsel_end
	les	bx,[di].ws_fcb
	mov	ax,si
	shl	ax,2
	add	bx,ax
	les	bx,es:[bx]
	and	es:[bx].fb_flag,not _A_SELECTED
	inc	si
	jmp	wsclrsel_loop
    wsclrsel_end:
	pop	di
	pop	si
	ret
wsclrsel endp
;
; Returns 0 if entry not part of basepath,
; else _A_ARCH or _A_SUBDIR.
;
testentryname proc pascal wsub:dword, ename:dword
	push	si
	push	di
	mov	bx,word ptr wsub
	invoke	strlen, [bx].ws_arch
	assert	ax,256,jb,"arch >= 256"
	mov	di,ax
	mov	si,word ptr ename
	invoke	strlen, ename
	assert	ax,256,jb,"entry >= 256"
	cmp	di,ax
	jae	testentryname_fail
	cmp	di,0
	jle	testentryname_flag
	invoke	strnicmp, ename, [bx].ws_arch, di
	or	ax,ax
	jnz	testentryname_fail
	mov	bx,di
	mov	al,[si+bx]
	cmp	al,'\'
	jne	testentryname_fail
    testentryname_copy:
	mov	ax,si
	add	ax,di
	inc	ax
	invoke	strcpy, ss::si, ss::ax
    testentryname_comma:
	cmp	byte ptr [si],','
	jne	testentryname_flag
	mov	ax,si
	inc	ax
	invoke	strcpy, ss::si, ss::ax
	jmp	testentryname_comma
    testentryname_flag:
	mov	di,_A_ARCH
	cld
    testentryname_loop:
	lodsb
	test	al,al
	jz	testentryname_find
	cmp	al,'\'
	jne	testentryname_loop
	xor	ax,ax
	mov	[si-1],al
	mov	di,_A_SUBDIR
    testentryname_find:
	mov	si,1
	mov	bx,word ptr wsub
	cmp	[bx.ws_count],si
	jbe	testentryname_ok
    testentryname_cmp:
	mov	bx,word ptr wsub
	cmp	[bx.ws_count],si
	jbe	testentryname_ok
	les	bx,[bx.ws_fcb]
	mov	ax,si
	shl	ax,2
	add	bx,ax
	push	es:[bx+2]
	mov	ax,es:[bx]
	add	ax,fb_name
	push	ax
	pushm	ename
	call	stricmp
	test	ax,ax
	jz	testentryname_fail
	inc	si
	jmp	testentryname_cmp
    testentryname_ok:
	mov	ax,di
	test	ax,ax
    testentryname_end:
	pop	di
	pop	si
	ret
    testentryname_fail:
	xor	ax,ax
	jmp	testentryname_end
testentryname endp

fbupdir proc pascal flag:word
	invoke	malloc, SIZE S_FBLK+1
	jz	fbupdir_end
	push	dx
	push	ax
	call	twdostime
	push	ax
	call	dwdosdate
	pop	dx
	pop	bx
	pop	es
	mov	es:[bx.fb_time],dx
	mov	es:[bx.fb_date],ax
	mov	ax,flag
	or	ax,_A_UPDIR or _A_SUBDIR
	mov	es:[bx.fb_flag],ax
	mov	ax,bx
	add	bx,fb_name
	mov	word ptr es:[bx],'..'
	mov	byte ptr es:[bx+2],0
	mov	dx,es
    fbupdir_end:
	ret
fbupdir endp

MUL32	proc
	push	si
	push	di
	push	bp
	push	ax
	push	dx
	push	dx
	mul	bx	; 1L * 2L
	mov	si,dx
	mov	di,ax
	pop	ax
	mul	cx	; 1H * 2H
	mov	bp,dx
	xchg	bx,ax
	pop	dx
	mul	dx	; 1H * 2L
	add	si,ax
	adc	bx,dx
	pop	ax
	mul	cx	; 1L * 2H
	add	si,ax
	adc	bx,dx
	adc	bp,0
	mov	cx,bp
	mov	dx,si
	mov	ax,di
	pop	bp
	pop	di
	pop	si
	ret	; CX:BX:DX:AX
MUL32	endp

atol	proc pascal string:dword
	push	ds
	push	si
	push	di
	lds	si,string
	cld
    atol_start:
	lodsb
	cmp	al,' '
	je	atol_start
	mov	bh,al
	cmp	al,'-'
	je	atol_inc
	cmp	al,'+'
	jne	atol_set
    atol_inc:
	lodsb
    atol_set:
	xor	cx,cx
	mov	di,cx
    atol_loop:
	cmp	al,'0'
	jb	atol_break
	cmp	al,'9'
	ja	atol_break
	mov	bl,al
	xchg	bx,di
	xor	dx,dx
	mov	ax,10
	call	MUL32
	mov	bx,di
	mov	bh,0
	sub	bl,'0'
	add	ax,bx
	adc	dx,0
	mov	cx,dx
	mov	di,ax
	lodsb
	jmp     atol_loop
    atol_break:
	cmp	bh,'-'
	je	atol_neg
    atol_end:
	mov	ax,di
	mov	dx,cx
	pop	di
	pop	si
	pop	ds
	ret
    atol_neg:
	neg	cx
	neg	di
	sbb	cx,0
	jmp	atol_end
atol	endp

isexec	proc
	invoke	strrchr, dx::ax, '.'
	jz	isexec_NOT
	mov	es,dx
	inc	ax
	mov	bx,ax
	mov	dx,'  '
	mov	ax,es:[bx]
	mov	bx,es:[bx+2]
	or	ax,dx
	or	bx,dx
	cmp	ax,'ab'
	je	isexec_BAT
	cmp	ax,'oc'
	je	isexec_COM
	cmp	ax,'xe'
	je	isexec_EXE
    isexec_NOT:
	xor	ax,ax
    isexec_END:
	ret
    isexec_EXE:
	cmp	bx,' e'
	jne	isexec_NOT
	mov	ax,3	; 3 = EXE
	jmp	isexec_END
    isexec_COM:
	cmp	bx,' m'
	jne	isexec_NOT
	mov	ax,2	; 2 = COM
	jmp	isexec_END
    isexec_BAT:
	cmp	bx,' t'
	jne	isexec_NOT
	mov	ax,1	; 1 = BAT
	jmp	isexec_END
isexec	endp

sp_file_exist proc
	push	bx
	invoke	filexist, addr [bp-128]
	cmp	ax,1
	pop	bx
	ret
sp_file_exist endp

sp_init_file proc
	push	es
	push	ss
	lea	ax,[bp-256]
	push	ax
	push	0
	push	0
	push	ss
	add	ax,128
	push	ax
	call	strfcat
	pop	es
	ret
sp_init_file endp

search_path proc
	push	bx
	invoke	fullpath, addr [bp-256], 0
	call	sp_init_file
	les	di,envpath
    search_path_test:
	invoke	filexist, addr [bp-256]
	cmp	ax,1
	je	search_path_found
	cmp	byte ptr es:[di],';'
	jne	search_path_nul?
	inc	di
    search_path_nul?:
	cmp	ah,es:[di]
	je	search_path_nul
	xor	bx,bx
	lea	si,[bp-256]
    search_path_cpy:
	mov	al,es:[bx+di]
	or	al,al
	jz	search_path_eof
	cmp	al,';'
	je	search_path_eof
	mov	[bx+si],al
	inc	bx
	jmp	search_path_cpy
    search_path_found:
	mov	ax,bp
	sub	ax,256
	mov	dx,ss
	jmp	search_path_end
    search_path_nul:
	xor	ax,ax
	mov	dx,ax
    search_path_end:
	or	ax,ax
	pop	bx
	ret
    search_path_eof:
	add	di,bx
	mov	[bx+si],ah
	call	sp_init_file
	jmp	search_path_test
search_path endp

searchp proc pascal, fname:dword
local	path[256]:byte
	push	si
	push	di
	lodm	envpath
	test	dx,dx
	jz	searchp_nul
	les	bx,fname
	test	bx,bx
	jz	searchp_nul
	mov	al,es:[bx]
	test	al,al
	jz	searchp_nul
	cmp	al,'.'
	jz	searchp_nul
	cmp	al,'\'
	jne	searchp_do
    searchp_nul:
	xor	ax,ax
	cwd
	jmp	searchp_end
    searchp_do:
	invoke	strcpy, addr [bp-128], es::bx
	mov	si,ax
	invoke	strlen, dx::ax
	mov	di,si
	add	di,ax
	cmp	ax,5
	jb	searchp_02
	mov	al,'.'
	cmp	al,[di-4]
	jne	searchp_02
	mov	ax,si
	mov	dx,ss
	call	isexec
	cmp	ax,2
	jae	searchp_03
    searchp_02:
	mov	byte ptr [di],'.'
	inc	di
	mov	bx,di
	mov	word ptr [di],'OC'
	mov	word ptr [di+2],'M'
	call	sp_file_exist
	je	searchp_05
	mov	word ptr [di],'XE'
	mov	word ptr [di+2],'E'
	call	sp_file_exist
	je	searchp_05
	call	search_path
	jnz	searchp_end
	mov	word ptr [bx],'OC'
	mov	word ptr [bx+2],'M'
	jmp	searchp_04
    searchp_03:
	call	sp_file_exist
	je	searchp_05
    searchp_04:
	call	search_path
	jmp	searchp_end
    searchp_05:
	mov	ax,bp
	sub	ax,128
	mov	dx,ss
    searchp_end:
	pop	di
	pop	si
	ret
searchp endp

strlen proc pascal string:dword
	push	di
	push	cx
	xor	ax,ax
	cmp	ax,word ptr string+2
	je	strlen_00
	les	di,string
	cld
	mov	cx,-1
	repnz	scasb
	mov	ax,cx
	not	ax
	dec	ax
    strlen_00:
	pop	cx
	pop	di
	ret
strlen	endp

strcpy proc pascal des:dword, src:dword
	assert	<word ptr src+2>,0,jne,"strcpy(src=0)"
	assert	<word ptr des+2>,0,jne,"strcpy(des=0)"
	push	ds
	push	si
	push	di
	lds	si,src
	les	di,des
	mov	dx,es
	cld
      @@:
	lodsb
	stosb
	test	al,al
	jnz	@B
	mov	ax,word ptr des
	pop	di
	pop	si
	pop	ds
	ret
strcpy	endp

strrchr proc pascal string:dword, char:word
	push	di
	mov	di,word ptr string
	mov	dx,word ptr string+2
	xor	ax,ax
	cmp	di,ax
	je	@F
	mov	es,dx
	cld
	mov	cx,ax
	dec	cx
	repne	scasb
	jne	@F
	not	cx
	dec	di
	std
	mov	al,byte ptr char
	repne	scasb
	mov	al,ah
	jne	@F
	mov	ax,di
	inc	ax
      @@:
	test	ax,ax
	pop	di
	ret
strrchr endp

strcat proc pascal dest:dword, src:dword
	push	ds
	push	si
	push	di
	cld
	les	di,dest
	mov	dx,di
	xor	al,al
	mov	cx,-1
	repne	scasb
	dec	di
	lds	si,src
      @@:
	mov	al,[si]
	mov	es:[di],al
	inc	di
	inc	si
	or	al,al
	jnz	@B
	mov	ax,dx
	mov	dx,es
	pop	di
	pop	si
	pop	ds
	ret
strcat	endp

stricmp proc pascal dst:dword, src:dword
	push	si
	push	di
	push	ds
	lds	si,src
	les	di,dst
	mov	al,-1
    stricmp_continue:
	test	al,al
	jz	stricmp_toend
	mov	al,[si]
	inc	si
	mov	ah,es:[di]
	inc	di
	cmp	ah,al
	je	stricmp_continue
	sub	al,'A'
	cmp	al,'Z'-'A'+1
	sbb	cl,cl
	and	cl,'a'-'A'
	add	al,cl
	add	al,'A'
	xchg	ah,al
	sub	al,'A'
	cmp	al,'Z'-'A'+1
	sbb	cl,cl
	and	cl,'a'-'A'
	add	al,cl
	add	al,'A'
	cmp	al,ah
	je	stricmp_continue
	sbb	al,al
	sbb	al,-1
    stricmp_toend:
	cbw
	pop	ds
	pop	di
	pop	si
	ret
stricmp endp

strncmp	proc pascal S1:dword, S2:dword, cnt:word
	push	ds
	push	si
	push	di
	mov     cx,cnt
	or	cx,cx
	jz	strncmp_01
	mov     dx,cx
	les	di,S1
	mov     si,di
	xor     ax,ax
	repne   scasb
	neg     cx
	add     cx,dx
	mov     di,si
	lds	si,S2
	repe    cmpsb
	mov     al,[si-1]
	xor     cx,cx
	cmp     al,es:[di-1]
	ja      @F
	je      strncmp_01
	dec     cx
	dec     cx
      @@:
	not     cx
    strncmp_01:
	mov     ax,cx
	pop	di
	pop	si
	pop	ds
	ret
strncmp	endp

strnicmp proc pascal S1:dword, S2:dword, count:word
	push	ds
	push	si
	push	di
	mov	cx,count
	test	cx,cx
	jz	strnicmp_05
	lds	si,S1
	les	di,S2
	mov	bh,'A'
	mov	bl,'Z'
	mov	dh,'a'-'A'
    strnicmp_00:
	mov	ah,[si]
	test	ah,ah
	mov	al,es:[di]
	jz	strnicmp_03
	test	al,al
	jz	strnicmp_03
	inc	si
	inc	di
	cmp	ah,bh
	jb	strnicmp_01
	cmp	ah,bl
	ja	strnicmp_01
	add	ah,dh
    strnicmp_01:
	cmp	al,bh
	jb	strnicmp_02
	cmp	al,bl
	ja	strnicmp_02
	add	al,dh
    strnicmp_02:
	cmp	ah,al
	jne	strnicmp_04
	dec	cx
	jnz	strnicmp_00
    strnicmp_03:
	xor	cx,cx
	cmp	ah,al
	je	strnicmp_05
    strnicmp_04:
	mov	cx,-1
	jb	strnicmp_05
	neg	cx
    strnicmp_05:
	mov	ax,cx
	pop	di
	pop	si
	pop	ds
	ret
strnicmp endp

strfcat proc pascal dest:dword, path:dword, adds:dword
	push	di
	mov	di,word ptr dest
	mov	ax,word ptr path
	test	ax,ax
	jz	@F
	invoke	strcpy, dest, path
      @@:
    	invoke	strlen, dest
	test	ax,ax
	jz	@F
	dec	ax
	add	di,ax
	mov	ax,'\'
	cmp	al,es:[di]
	je	@F
	inc	di
	mov	es:[di],ax
      @@:
    	invoke	strcat, dest, adds
	pop	di
	ret
strfcat endp

unixconvert proc
	les	bx,[bp+4]
	jmp	unixconvert_01
    unixconvert_00:
	cmp	al,ah
	jne	unixconvert_01
	mov	es:[bx-1],dl
    unixconvert_01:
	mov	al,es:[bx]
	inc	bx
	test	al,al
	jnz	unixconvert_00
	mov	dx,es
	mov	ax,[bp+4]
	ret
unixconvert endp

unixtodos proc pascal string:dword
	mov	ah,'/'
	mov	dl,'\'
	call	unixconvert
	ret
unixtodos endp

dostounix proc pascal string:dword
	mov	ah,'\'
	mov	dl,'/'
	call	unixconvert
	ret
dostounix endp

cmpwarg	proc pascal filep:dword, maskp:dword
	push	ds
	push	si
	push	di
	lds	si,filep
	les	di,maskp
    cmpwarg_next:
	mov	al,[si]
	mov	ah,es:[di]
	inc	si
	inc	di
	cmp	ah,'*'
	je	cmpwarg_star
	or	al,al
	jz	cmpwarg_zero
	or	ah,ah
	jz	cmpwarg_zero
	cmp	ah,'?'
	je	cmpwarg_next
	cmp	ah,'.'
	je	cmpwarg_04
	cmp	al,'.'
	je	cmpwarg_fail
	or	ax,2020h
	cmp	ah,al
	je	cmpwarg_next
	jmp	cmpwarg_fail
    cmpwarg_zero:
	or	ax,ax
	jnz	cmpwarg_fail
    cmpwarg_ok:
	mov	ax,1
    cmpwarg_end:
	or	ax,ax
	pop	di
	pop	si
	pop	ds
	ret
    cmpwarg_04:
	cmp	al,'.'
	je	cmpwarg_next
    cmpwarg_fail:
	xor	ax,ax
	jmp	cmpwarg_end
    cmpwarg_star:
	mov	ah,es:[di]
	or	ah,ah
	jz	cmpwarg_ok	; find '.' --> '*' | '*abc' | '*.txt'
	inc	di
	cmp	ah,'.'
	jne	cmpwarg_star
	xor	dx,dx		; found
    cmpwarg_type:
	or	al,al
	jz	cmpwarg_test
	cmp	al,ah
	je	cmpwarg_dxsi
    cmpwarg_lods:
	mov	al,[si]
	inc	si
	jmp	cmpwarg_type
    cmpwarg_dxsi:
	mov	dx,si
	jmp	cmpwarg_lods
    cmpwarg_test:
	or	dx,dx
	mov	si,dx
	jnz	cmpwarg_next
	mov	ah,es:[di]
	inc	di
	cmp	ah,'*'
	je	cmpwarg_star
	jmp	cmpwarg_zero
cmpwarg	endp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

malloc	proc pascal msize:word
	mov	cx,msize
	mov	ah,_DZ_malloc
	int	DZ
	test	ax,ax
	ret
malloc	endp

free	proc pascal mseg:dword
	mov	dx,word ptr mseg+2
	mov	ah,_DZ_free
	int	DZ
	ret
free	endp

osopen	proc pascal fname:dword, attrib:word, mode:word, action:word
	mov	ah,_DZ_open
	mov	al,byte ptr attrib
	mov	dx,word ptr fname+2
	mov	bx,word ptr fname
	mov	ch,byte ptr mode
	mov	cl,byte ptr action
	int	DZ
	ret
osopen	endp

close	proc pascal osfhnd:word
	mov	ah,_DZ_close
	mov	bx,osfhnd
	int	DZ
	ret
close	endp

dosmaper proc
	mov	ah,_DZ_dosmaperr
	int	DZ	; Carry flag set if function not supported
	ret
dosmaper endp

ermsg	proc fastcall xtitle:word, format:word
	mov ax,format
	mov bx,xtitle
	.if !bx
	    mov bx,CStr(<"Error">)
	.endif
	call @vsbufin
	mov al,1	; _D_STERR
ermsg	endp

ermsgint proc
	mov	dx,cs
	mov	ah,_DZ_tmsgbox
	int	DZ
	xor	ax,ax
	ret
ermsgint endp

stdmsg	proc fastcall xtitle:word, format:word
	mov	bx,xtitle
	mov	ax,format
	call	@vsbufin
	mov	al,0
	jmp	ermsgint
stdmsg	endp

dzedit	proc pascal fname:dword, line:word
	mov	dx,word ptr fname+2
	mov	bx,word ptr fname
	mov	cx,line
	mov	ah,_DZ_edit
	int	DZ
	ret
dzedit	endp

rsmodal	proc pascal res:dword
	mov	dx,word ptr res+2
	mov	bx,word ptr res
	mov	ah,_DZ_rsmodal
	int	DZ
	test	ax,ax
	ret
rsmodal	endp

dzexec	proc pascal command:dword, exe_type:byte
local	mouse:word
local	temp[WMAXPATH]:byte
	push	si
	push	di
  ifdef __MOUSE__
	call	mousey		; save mouse location
	mov	bx,ax
	call	mousex
	mov	ah,bl
	mov	mouse,ax
  endif
	test	exe_type,4
	jz	dzexec_int
	mov	dx,cs
	mov	ax,CStr("NUL")
	test	exe_type,8
	jnz	@F
	invoke	strfcat, addr temp, envtemp, addr CString("ziplst.tmp")
      @@:
    	invoke	osopen, dx::ax, _A_NORMAL, M_RDWR, A_TRUNC or A_CREATE
	mov	si,ax
	inc	ax
	jz	dzexec_end
	mov	bx,_STDOUT
	mov	ah,45h		; duplicate stdout
	int	21h		; AX new file handle if successful
	assertf	jnc,"_dup()"
	mov	di,ax
	mov	ah,46h		; set stdout to pipe handle
	mov	bx,si
	mov	cx,_STDOUT
	int	21h
	assertf	jnc,"dup2()"
	invoke	close, si	; close the pipe handle
    dzexec_int:
	mov	dx,word ptr command+2
	mov	bx,word ptr command
	mov	ah,_DZ_command
	mov	al,exe_type
	int	DZ
	jc	dzexec_fail
	test	ax,ax
	jnz	dzexec_fail
	inc	ax
	test	exe_type,4
	jz	dzexec_end
	mov	ah,46h		; restore original standard output
	mov	bx,di
	mov	cx,_STDOUT
	int	21h
	invoke	close, di	; close duplicate handle
	invoke	osopen, addr temp, _A_NORMAL, M_RDONLY, A_OPEN
    dzexec_end:
  ifdef __MOUSE__
	mov	si,ax
	mov	ax,mouse		; restore mouse x,y
	call	mousexy
	mov	ax,si
  endif
	test	ax,ax
	pop	di
	pop	si
	ret
    dzexec_fail:
	xor	ax,ax
	jmp	dzexec_end
dzexec	endp

dzmklist proc pascal o_name:word
	mov	ah,_DZ_mklist
	int	DZ
	test	ax,ax
	jz	dzmklist_count
	mov	ah,_DZ_getsyserr
	int	DZ
	push	dx
	push	ax
	invoke	ermsg, o_name, "Error create listfile\n\n%s"
	add	sp,4
	dec	ax
	jmp	dzmklist_end
    dzmklist_count:
	or	cx,dx
	jnz	dzmklist_end
	invoke	ermsg, o_name, "Nothing to do.."
	dec	ax
    dzmklist_end:
	test	ax,ax
	ret
dzmklist endp

dzview	proc pascal fname:dword, offs:dword
	les	bx,fname
	mov	dx,word ptr offs+2
	mov	cx,word ptr offs
	mov	ah,_DZ_view
	int	DZ
	ret
dzview	endp

; int sprintf(char *dest, char *format, ...)
;
; Entry:	AX	format string (CS:AX)
;		DX:BX	string buffer
; Uses:		AX
; Return:	Number of bytes output

@vsbufin proc
	xor	dx,dx
@vsbufin endp

@sprintf02 proc
	push	bp
	sub	sp,18
	mov	bp,sp
	push	es
	push	cx
	push	bx
	or	dx,dx
	jnz	@sprintf02_00
	mov	dx,ss
	mov	bx,DZ_bufin
    @sprintf02_00:
	push	dx
	mov	word ptr [bp.iob_bp],bx
	mov	word ptr [bp.iob_bp+2],dx
	mov	word ptr [bp.iob_base],bx
	mov	word ptr [bp.iob_base+2],dx
	mov	[bp.iob_cnt],7FFFh
	mov	[bp.iob_flag],0042h
	mov	cx,bp	; FILE
	push	cs	; format string in CS:AX
	pop	es
	mov	bx,ax	; SS:CX, ES:BX, SS:DX
	mov	dx,sp
	add	dx,32
	mov	ah,_DZ_OUTPUT
	int	DZ
	les	bx,[bp]
	mov	byte ptr es:[bx],0
	pop	dx
	pop	bx
	pop	cx
	pop	es
	add	sp,18
	pop	bp
	ret
@sprintf02 endp

csprintf proc fastcall buffer:word, format:word
	push	cs
	jmp	xprintf
csprintf endp

ssprintf proc fastcall buffer:word, format:word
	push	ss
ssprintf endp

xprintf proc fastcall buffer:word, format:word
	push	format
	mov	bx,buffer
	pop	ax
	pop	dx
xprintf endp

_sprintf proc
	call	@sprintf02
	ret
_sprintf endp

getdrv  proc
	mov	ah,19h
	int	21h
	mov	ah,0
	ret
getdrv  endp

getfattr proc pascal filen:dword
  ifdef __LFN__
	mov	al,_ifsmgr
	or	al,al
  endif
	push	ds
	lds	dx,filen
	mov	ax,4300h
  ifdef __LFN__
	jz	getfattr_21
	stc
	mov	ax,7143h
	mov	bl,0
    getfattr_21:
  endif
	int	21h
	pop	ds
	jc	getfattr_err
	mov	ax,cx
    getfattr_end:
	ret
    getfattr_err:
	call    dosmaper
	mov	ax,-1
	jmp	getfattr_end
getfattr endp

filexist proc pascal filename:dword
	invoke	getfattr,filename
	inc	ax
	jz	@F
	dec	ax      	; 1 = file
	and	ax,_A_SUBDIR    ; 2 = subdir
	shr	ax,4
	inc	ax
      @@:
	ret
filexist endp

lseek	proc pascal handle:word, offs:dword, pos:word
	mov	ah,42h
	mov	al,byte ptr pos
	mov	bx,handle
	mov	cx,word ptr offs+2	; CX:DX offset
	mov	dx,word ptr offs
	int	21h
	jc	lseek_error
	cmp	dx,-1
	jne	lseek_end
	cmp	ax,-1
	je	lseek_negseek
    lseek_end:
	ret
    lseek_negseek:
	xor	cx,cx
	mov	dx,cx
	mov	ax,4200h
	int	21h
	mov	ax,ER_NEGATIVE_SEEK
    lseek_error:
	call    dosmaper
	mov	ax,-1
	cwd
	jmp	lseek_end
lseek	endp

remove	proc pascal filename:dword
  ifdef __LFN__
	push	si
	mov	al,_ifsmgr
	or	al,al
  endif
	push	ds
	lds	dx,filename
	mov	ah,41h
  ifdef __LFN__
	jz	remove_int
	xor	si,si
	stc
	xchg	al,ah
    remove_int:
  endif
	int	21h
	pop	ds
	jc	remove_err
	xor     ax,ax
    remove_end:
  ifdef __LFN__
	pop	si
  endif
	ret
    remove_err:
	call    dosmaper
	mov	ax,-1
	jmp	remove_end
remove	endp

dwdosdate proc
	mov     ah,2Ah
	int     21h
	mov     ax,cx
	sub	ax,DT_BASEYEAR
	shl	ax,9
	xchg	ax,dx
	mov	cl,al
	mov	al,ah
	xor	ah,ah
	shl	ax,5
	xchg	ax,dx
	or	ax,dx
	or	al,cl
	ret
dwdosdate endp

twdostime proc
	mov     ah,2Ch	; CH = hour
	int     21h	; CL = minute
	xor	ax,ax	; DH = second
	mov	al,dh
	shr	ax,1
	mov	dx,ax	; second/2
	mov	al,ch
	mov	ch,ah
	shl	cx,5
	shl	ax,11
	or	ax,cx
	or	ax,dx	; hhhhhmmmmmmsssss
	ret
twdostime endp

osread	proc pascal handle:word, buffer:dword, bsize:word
	push	ds
	mov	ah,3Fh
	mov	bx,handle
	mov	cx,bsize
	lds	dx,buffer
	int	21h
	pop	ds
	jc      osread_error
    osread_end:
	ret
    osread_error:
	call	dosmaper
	xor     ax,ax
	jmp     osread_end
osread	endp

fullpath proc pascal buf:dword, drv:word
	push	word ptr buf+2
	mov	ax,word ptr buf
	add	ax,3
	push	ax
	push	drv
	call	getcwdd
	or	ax,dx
	jz	fullpath_end
	mov	ax,drv
	or	ax,ax
	jz	fullpath_get
	add	al,'@'
	jmp	fullpath_drv
    fullpath_get:
	call	getdrv
	add	al,'A'
    fullpath_drv:
	les	bx,buf
	mov	ah,':'
	mov	es:[bx],ax
	mov	al,'\'
	mov	es:[bx+2],al
	mov	dx,es
	mov	ax,bx
    fullpath_end:
	ret
fullpath endp

getcwdd proc pascal path:dword, disk:word
	push	si
	push	ds
	lds	si,path
	mov	dx,disk	; drive number (DL, 0 = default)
	mov	ah,47h
	int	21h
	pop	ds
	jc	getcwdd_err
	mov	ax,word ptr path
	mov	dx,word ptr path+2
    getcwdd_end:
	pop	si
	ret
    getcwdd_err:
	xor	ax,ax
	cwd
	jmp	getcwdd_end
getcwdd endp

mousep	proc
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	cmp	cs:[__mouse],al
	je	@F
	mov	ax,6
	int	33h
	test	al,al
      @@:
	pop	dx
	pop	cx
	pop	bx
	ret
mousep	endp

mouseon	proc
	mov	ax,1
	cmp	al,cs:[__mbool]
	je	@F
	cmp	ah,cs:[__mouse]
	je	@F
	mov	cs:[__mbool],al
	int	33h
      @@:
	ret
mouseon	endp

mouseoff proc
	xor	ax,ax
	cmp	al,cs:[__mbool]
	jz	@F
	mov	cs:[__mbool],al
	mov	ax,2
	int	33h
      @@:
	ret
mouseoff endp

mousex	proc
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	cmp	al,cs:[__mouse]
	je	@F
	mov	al,3
	int	33h
	mov	ax,cx
	shr	ax,3
      @@:
	pop	dx
	pop	cx
	pop	bx
	ret
mousex	endp

mousey	proc
	push	bx
	push	cx
	push	dx
	xor	ax,ax
	cmp	al,cs:[__mouse]
	je	@F
	mov	ax,3
	int	33h
	mov	ax,dx
	shr	ax,3
      @@:
	pop	dx
	pop	cx
	pop	bx
	ret
mousey	endp

mousexy proc
	push	dx
	push	cx
	push	ax
	xor	dx,dx
	mov	cx,dx
	cmp	cl,cs:[__mouse]
	je	@F
	mov	dl,ah
	mov	cl,al
	shl	cx,3
	shl	dx,3
	mov	ax,4
	int	33h
      @@:
	pop	ax
	pop	cx
	pop	dx
	ret
mousexy endp

mousehide proc
	push	ax
	call	mouseoff
	shr	al,1
	mov	ah,cs:[__mflag]
	shl	ah,1
	or	al,ah
	mov	cs:[__mflag],al
	pop	ax
	ret
mousehide endp

mouseshow proc
	push	ax
	mov	al,cs:[__mflag]
	shr	al,1
	mov	cs:[__mflag],al
	jnc	@F
	call	mouseon
      @@:
	pop	ax
	ret
mouseshow endp

ogetc	proc
	push	si
	mov	si,ax
	mov	ax,[si].ios_i
	cmp	ax,[si].ios_c
	je	ogetc_read
    ogetc_do:
	inc	[si].ios_i
	mov	si,[si].ios_bp
	add	si,ax		; [0] == zero flag set!
	inc	ax
	mov	ah,0
	mov	al,[si]
    ogetc_end:
	pop	si
	ret
    ogetc_read:
	xor	ax,ax
	mov	[si].ios_i,ax
	mov	[si].ios_c,ax
	push	bx
	push	cx
	push	dx
	mov	cx,[si].ios_size
	mov	bx,[si].ios_file
	mov	dx,[si].ios_bp
	mov	ah,3Fh
	int	21h
	pop	dx
	pop	cx
	pop	bx
	jc	ogetc_error
	mov	[si].ios_c,ax
	or	ax,ax
	mov	ax,[si].ios_i
	jnz	ogetc_do
    ogetc_error:
	xor	ax,ax
	jmp	ogetc_end
ogetc	endp

ogets	proc
	push	si	; AX stream
	push	di	; DX line buffer
	push	cx	; CX buffer size
	mov	si,ax
	sub	cx,2
	mov	di,dx
    ogets_get:
	mov	ax,si
	call	ogetc
	jz	ogets_end
	cmp	al,0Dh
	je	ogets_set
	cmp	al,0Ah
	je	ogets_eol
	assert	al,0,jne,"gets:0"
	mov	[di],al
	inc	di
	dec	cx
	jnz	ogets_get
    ogets_set:
	mov	ax,si
	call	ogetc
    ogets_end:
	mov	byte ptr [di],0
	pop	cx
	pop	di
	pop	si
	ret
    ogets_eol:
	inc	al
	jmp	ogets_end
ogets	endp


