/*
 * FBLK.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <dos.h>
#include <time.h>
#include <string.h>
#include <alloc.h>
#include <dzmain.h>

const char cp_initype[] = "Filetype";

static int parsecmd(char *b, char *line, const char *file, char *ext)
{
	strcpy(b, line);
	if (strchr(line, '!') == NULL) {
		strcat(b, " ");
		strcat(b, file);
	} else {
		ex_addmacro(b, "!!", "", 2);
		if (ext) {
			ex_addmacro(b, ".!", ext, 2);
			*ext = 0;
			ex_addmacro(b, "!", file, 1);
			*ext = '.';
		} else {
			ex_addmacro(b, ".!", "", 2);
			ex_addmacro(b, "!", file, 1);
		}
		ex_addmacro(b, "", "!", 2);
	}
	ex_addmacro(b, ", ", "\r\n", 2);
	return ex_command(b);
}

static int fblk_getinitype(const FBLK *b, char *bp)
{
	char *p, *ext;
	int result = 0;

	if ((ext = strrchr(b->name, '.')) != NULL) {
		if ((p = inientry(cp_initype, ext+1)) != NULL) {
			parsecmd(bp, p, b->name, ext);
			result = 1;
		}
	}
	if (result == 0) {
		if ((p = inientry(cp_initype, b->name)) != NULL) {
			parsecmd(bp, p, b->name, NULL);
			result = 1;
		}
	}
	return result;
}

int fbftype(const FBLK *b)
{
	char *	ext;
	char	buf[WMAXPATH];

	_ASSERTE(b == NULL);
	if (ISSUBDIR(b->flag)) {
		if (ISUPDIR(b->flag))
			return FTYPE_UPDIR;
		return FTYPE_SUBDIR;
	}
	if (ISARCHIVE(b->flag))
		return FTYPE_ARCHIVE;
	if (fblk_getinitype(b, buf))
		return FTYPE_USER;
	if ((ext = strrchr(b->name, '.')) != NULL) {
		ext++;
		if (0 == stricmp(ext,"BAT"))
			return FTYPE_BAT;
		if (0 == stricmp(ext,"COM"))
			return FTYPE_COM;
		if (0 == stricmp(ext,"EXE"))
			return FTYPE_EXE;
	}
	strfcat(buf, cpanel->ide->path, b->name);
	switch ((WORD)readword(buf)) {
		case FWID_ZIP:  return FTYPE_ZIP;
		case FWID_ARJ:  return FTYPE_ARJ;
		case FWID_GZ:   return FTYPE_GZ;
	}
	return 0;
}