/*
 * DWTOLSTR.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <time.h>

char *dwtolstr(char *p, WORD dt)
{
	WORD d,m,y;

	d = dwtoday(dt);
	m = dwtomnd(dt);
	y = dwtoyear(dt);
	p[0] = (d / 10 + '0');
	p[1] = (d % 10 + '0');
	p[2] = '.';
	p[3] = (m / 10 + '0');
	p[4] = (m % 10 + '0');
	p[5] = '.';
	if (y < 2000) {
		p[6] = '1';
		p[7] = '9';
		y -= 1900;
	} else if (y < 2100) {
		p[6] = '2';
		p[7] = '0';
		y -= 2000;
	} else {
		p[6] = '2';
		p[7] = '1';
		y -= 2100;
	}
	p[8] = (y / 10 + '0');
	p[9] = (y % 10 + '0');
	p[10] = '\0';
	return p;
}

