/*
 * _FILEBUF.C
 *
 *  This file is part of DOSZIP
 *  Copyright (c) 1996 Hjort Nidudsson.
 */

#include <io.h>
#include <stdio.h>

#define FH_EOFTEXT	(FH_TEXT | FH_EOF)

int _filebuf(FILE *fp)
{
	if (!inuse(fp) || fp->flag & _IOSTRG)
		return EOF;
	if (fp->flag & _IOWRT) {
		fp->flag |= _IOERR;
		return EOF;
	}
	fp->flag |= _IOREAD;
	if (!anybuf(fp))
		_getbuf(fp);
	else
		fp->bp = fp->base;
	fp->cnt = read(fp->file, fp->base, fp->bufsize);
	if ((fp->cnt == 0) || (fp->cnt == 1) ||	(fp->cnt == -1)) {
		fp->flag |= fp->cnt ? _IOERR : _IOEOF;
		fp->cnt = 0;
		return EOF;
	}
	if (!(fp->flag & (_IOWRT|_IORW)) &&
		((_osfile[_fileno(fp)] & FH_EOFTEXT) == FH_EOFTEXT)) {
		fp->flag |= _IOCTRLZ;
	}
	if ((fp->bufsize == _MINIOBUF) &&
		(fp->flag & _IOMYBUF) && !(fp->flag & _IOSETVBUF)) {
		fp->bufsize = _INTIOBUF;
	}
	fp->cnt--;
	return (0xFF & *fp->bp++);
}
