;
; IOSEARCH.ASM
;
; This file is part of DOSZIP
; Copyright (c) 1996 Hjort Nidudsson.
;

INCLUDE		ios.inc

EXTRN 		searchstring: BYTE:[128]

		LOCALS

_TEXT		SEGMENT

SEEKSTART:	mov	al,lflag
		and	lflag,(not IOS_SEEKCFG)
		test	al,IOS_SEEKSET
		jz	SHORT @@CUR
		xor	EDI,EDI
		jmp	SHORT @@END
@@CUR:		test	al,IOS_SEEKCUR
		jnz	SHORT @@END
		inc	EDI
@@END:          call	seekedi
		ret

COMPARE:        test	xflag,IOS_USECASE
		jnz	SHORT @@CASE
		or	ax,2020H
@@CASE:		cmp	al,ah
		ret

CMPSTRING:     	mov	bx,OFFSET searchstring
@@loop:		inc	bx
		call	iosgetc
		jz	SHORT @@NULL
		mov	ah,ES:[bx]
		or	ah,ah
		jz	SHORT @@FOUND
		call	COMPARE
		jnz	SHORT @@NULL
		jmp	SHORT @@loop
@@NULL:		xor	ah,ah
		ret
@@FOUND:	or	ah,1
		ret

GETSTRB:	mov	al,ES:[bx]
		or	al,al
		jz	SHORT @@END
		inc	bx
		cmp	al,'0'
		jb	SHORT GETSTRB
		cmp	al,'9'
		jbe	SHORT @@set
		or	al,20H
		cmp	al,'f'
		ja	SHORT GETSTRB
		sub	al,27H
@@set:		sub	al,'0'
		or	bx,bx
@@END:          ret

GETSTRW:	call	GETSTRB
		jz	SHORT @@END
		mov	ah,al
		call	GETSTRB
		jnz	SHORT @@set
		xchg	al,ah
@@set:		shl	ah,4
		or	al,ah
		inc	dx
@@END:		ret

iossearchhex:	push	DS
		pop	ES
		call	iospush
		call	SEEKSTART
		jz	SHORT @@END
@@loop:		mov	bx,OFFSET searchstring
		mov	dx,0
@@STRL:		call	GETSTRW
		jz	SHORT @@FOUND
		push	dx
		mov	dl,al
		call	iosgetc
		mov	ah,dl
		pop	dx
		jz	SHORT @@END
		cmp	al,ah
		je      SHORT @@STRL
		jmp	SHORT @@loop
@@FOUND:        or	dx,dx
		jz	SHORT @@END
		movzx	EAX,dx
		sub	EDI,EAX
		mov	foffs,EDI
		or	ah,1
		ret
@@END:          xor	ax,ax
		ret

iossearchtxt:	push	DS
		pop	ES
		call	iospush
		call	SEEKSTART
		jz	SHORT @@END
@@loop:		mov	al,ES:[searchstring]
		mov	ah,al
		test	xflag,IOS_USECASE
		jnz	SHORT @@case
		or	al,20H
		and	ah,0DFH
@@case:		call	iosscan
		jz	SHORT @@END
		mov	bx,OFFSET searchstring
@@cmp:		call	iosgetc
		jz	SHORT @@END
		inc	bx
		mov	ah,ES:[bx]
		or	ah,ah
		jz	SHORT @@found
		call	COMPARE
		jz	SHORT @@cmp
		sub	bx,OFFSET searchstring
		call	iosback
		jmp	SHORT @@loop
@@found:	movzx	EAX,bx
		sub	ax,OFFSET searchstring
		inc	ax
		sub	EDI,EAX
		mov	foffs,EDI
		or	ax,1
		ret
@@END:		xor	ax,ax
		ret

_TEXT		ENDS

		END
