# GNUmakefile

.PHONY: all clean cleanall
.RECIPEPREFIX := _

# --- variables ---

PROG     = 7zdec.exe
STUB     = 7zdecode.exe

CC       = gcc
CFLAGS   = $(DEBUG) $(WARN) $(OPTIMIZE)
DEBUG    = -s
MAP      = -Wl,-Map,$(PROG:.exe=.map)
MARCH    = -march=pentium
MTUNE    = -mtune=generic
OPTIMIZE = $(OPTLEVEL) $(MARCH) $(MTUNE)
OPTLEVEL = -Os
PPMD     = -D_7ZIP_PPMD_SUPPPORT
RM       = rm -f
UPX      = upx
UPXFLAGS = -qq --best --lzma --all-filters
WARN     = -Wall -Wextra

ifneq ($(SMARTLINK),)
  SEC1   = -ffunction-sections -fdata-sections
  SEC2   = -Wl,--gc-sections
endif

ALLUSE   = $(addsuffix .h,precomp compiler 7ztypes)
OBJS     = $(addsuffix .o,7zalloc 7zarcin 7zbuf 7zbuf2 7zcrc \
             7zcrcopt 7zdec 7zfile 7zmain 7zstream bcj2 bra bra86 \
             braia64 cpuarch delta lzma2dec lzmadec ppmd7 ppmd7dec)

# --- rules ---

all: $(PROG) $(STUB)

$(PROG): $(OBJS)
_$(CC) $(SEC2) $(MAP) -o $@ $(OBJS)
_-$(UPX) $(UPXFLAGS) $@

$(STUB):
_stubify -g $@
_stubedit $@ runfile=$(PROG:.exe=)

.c.o:
_$(CC) $(CFLAGS) $(SEC1) -c $<

clean:
_-@$(RM) $(OBJS)

cleanall: clean
_-@$(RM) $(PROG) $(STUB) $(PROG:.exe=.map)

# --- dependencies ---

7zalloc.o:  7zalloc.c 7zalloc.h $(ALLUSE)
7zarcin.o:  7zarcin.c 7z.h 7zbuf.h 7zcrc.h cpuarch.h $(ALLUSE)
7zbuf.o:    7zbuf.c 7zbuf.h $(ALLUSE)
7zbuf2.o:   7zbuf2.c 7zbuf.h $(ALLUSE)
7zcrc.o:    7zcrc.c 7zcrc.h cpuarch.h $(ALLUSE)
7zcrcopt.o: 7zcrcopt.c cpuarch.h $(ALLUSE)

7zdec.o:    7zdec.c 7z.h 7zcrc.h bcj2.h bra.h cpuarch.h \
            delta.h lzmadec.h lzma2dec.h ppmd7.h ppmd.h $(ALLUSE)
_$(CC) $(CFLAGS) $(SEC1) $(PPMD) -c $<

7zfile.o:   7zfile.c 7zfile.h $(ALLUSE)
7zmain.o:   7zmain.c cpuarch.h 7z.h 7zalloc.h 7zbuf.h \
            7zcrc.h 7zfile.h 7zversio.h $(ALLUSE)
7zstream.o: 7zstream.c $(ALLUSE)

bcj2.o:     bcj2.c bcj2.h cpuarch.h $(ALLUSE)
_$(CC) $(CFLAGS) $(SEC1) -fno-strict-aliasing -c $<

bra.o:      bra.c cpuarch.h bra.h $(ALLUSE)
bra86.o:    bra86.c bra.h $(ALLUSE)
braia64.o:  braia64.c cpuarch.h bra.h $(ALLUSE)
cpuarch.o:  cpuarch.c cpuarch.h $(ALLUSE)
delta.o:    delta.c delta.h $(ALLUSE)
lzma2dec.o: lzma2dec.c lzma2dec.h lzmadec.h $(ALLUSE)
lzmadec.o:  lzmadec.c lzmadec.h $(ALLUSE)
ppmd7.o:    ppmd7.c ppmd7.h ppmd.h cpuarch.h $(ALLUSE)
ppmd7dec.o: ppmd7dec.c ppmd7.h ppmd.h cpuarch.h $(ALLUSE)

# EOF
