////////////////////////////////////////////////////////////////////////////////
//
//  Metics - Header File
//
//	(c) Copyright 2003,2004 Point Mad, Lukas Lipka. All rights reserved.
//
////////////////////////////////////////////////////////////////////////////////
#ifndef _METRICS_H_INCLUDED_
#define _METRICS_H_INCLUDED_

/*
*	 This is the typedef structure to set the x and y coordinates
*/
typedef struct TPoint *PPoint;
typedef struct TPoint
{
	l_int x;
	l_int y;

} TPoint;

typedef struct TSPoint *PSPoint;
typedef struct TSPoint
{
	l_int x;
	l_int y;
	l_int z;

} TSPoint;

/**
*	This is the typedef structure to assign points to a rectagular object
*/
typedef struct TRect *PRect;
typedef struct TRect
{
	TPoint a;
  	TPoint b;

} TRect;

/**
*	This is the typedef structure to assign max/min size
*/
typedef struct TSize *PSize;
typedef struct TSize
{
	l_int	w;
	l_int	h;

} TSize;

/**
*	These are the functions for the rectangular objects
*/
l_bool PointInRect	( TPoint p, TRect r );
l_bool  RectOverlay ( TRect r, TRect d );

void RectIntersept( TRect *i , TRect r, TRect d );
void RectMove ( TRect *d, TRect r, TPoint p);
void RectUnMove ( TRect *d, TRect r, TPoint p);
void RectAssign( TRect *r,l_int ax, l_int ay, l_int bx, l_int by );
void PointAssign( TPoint *p, l_int x, l_int y );

l_int GetXDelta		( TRect r );
l_int GetYDelta		( TRect r );
l_int GetWidth		( TRect r );
l_int GetHeight		( TRect r );
TSize MakeSize(l_int w, l_int h);

PList NewListFromRect ( TRect r );
void AddRectInList ( PList List, l_int ax, l_int ay, l_int bx, l_int by );
void RemoveZoneInListItem ( PList List, PListItem A, TRect b );
void RemoveZoneInList ( PList l, TRect r );

#define SizeAssign(s,w,h) PointAssign((TPoint*)s,w,h)


/**
 * Inline version of functions (faster) - not always better
 */
#define _PointInRect(p,r) (p.x >= r.a.x && p.y >= r.a.y && p.x <= r.b.x && p.y <= r.b.y)
#define _RectOverlay(r,d) !( (r).a.x > (d).b.x || (r).a.y > (d).b.y || (r).b.x < (d).a.x || (r).b.y < (d).a.y )


#endif /* _METRICS_H_INCLUDED_ */
