/*
    Help screen displayed on console while invoking zBoy from console mode with --help.
    This file is part of the zBoy project.
    Copyright (C) Mateusz Viste 2010,2011,2012,2013,2014,2015
*/

#include <stdio.h>

void printhelp(void) {
  printf("\n"
         "      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
         "      *                                                                 *\n"
         "      *  zBoy - a full-featured, multiplatform GameBoy emulator         *\n"
         "      *  Copyright (C) Mateusz Viste 2010, 2011, 2012, 2013, 2014, 2015 *\n"
         "      *                                                                 *\n"
         "      * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\n"
         "\n");
  printf("+----------------------------------------------------------------------------+\n"
         "| Available keys:                                                            |\n"
         "|                                                                            |\n"
         "| Joypad actions | Keys mapping (on default keyboard mapping)                |\n"
         "|  UP            | Up arrow                                                  |\n"
         "|  DOWN          | Down arrow                                                |\n");
  printf("|  LEFT          | Left arrow                                                |\n"
         "|  RIGHT         | Right arrow                                               |\n"
         "|  START         | Enter (return)                                            |\n"
         "|  SELECT        | TAB                                                       |\n"
         "|  Button A      | CTRL                                                      |\n"
         "|  Button B      | ALT                                                       |\n");
  printf("|                                                                            |\n"
         "| Emulator's functions (using default keys assignements):                    |\n"
         "|  F1  - enables/disables game's background                                  |\n"
         "|  F2  - enables/disables game's sprites                                     |\n"
         "|  F3  - enables/disables game's window                                      |\n");
  printf("|  F5  - saves the current state of the game on disk (a.k.a. \"QuickSave\")    |\n"
         "|  F7  - loads the saved state of the game from disk (a.k.a. \"QuickLoad\")    |\n"
         "|  F8  - enables/disables autoscreenshot (does a screenshot every 10 seconds)|\n"
         "|  F9  - performs a PCX screenshot (saved to current directory)              |\n"
         "|  F10 - resets the CPU (restarts the game)                                  |\n"
         "|  ESC - quits the emulator                                                  |\n");
  printf("+----------------------------------------------------------------------------+\n"
         "\n");
  printf("+----------------------------------------------------------------------------+\n"
         "| Command-line usage:                                                        |\n"
         "|  zboy [--option1 --option2 ...] file.gb                                    |\n"
         "|                                                                            |\n"
         "| Available options:                                                         |\n"
         "|  --[no]colorize  Activates or disables colorization. When enabled, zBoy    |\n");
  printf("|                  will colorize some games using special palettes.          |\n"
         "|  --custcolor pal Use a custom palette from file 'pal'. The palette file is |\n"
         "|                  a text file containing RGB triplets. See colorize.txt.    |\n"
         "|  --eaglescale x  Scales the video screen x times using the EAGLE scaling   |\n"
         "|                  algorithm. Possible values are 2, 4, 6 or 8.              |\n"
         "|  --fpslimit x    Limit the FPS rendering to x frames per second. x must be |\n");
  printf("|                  in the range 1..60 (defaults to 60 FPS). This option will |\n"
         "|                  give odd results if combined with --fullspeed.            |\n"
         "|  --scale x       Scales the video screen x times. Possible values are      |\n"
         "|                  1..8 (defaults to 4 = 640x576).                           |\n"
         "|  --scale2x x     Scales the video screen x times using the Scale2x         |\n"
         "|                  algorithm. Possible values are 2, 4, 6 or 8.              |\n");
  printf("|  --scale3x x     Scales the video screen x times using the Scale3x         |\n"
         "|                  algorithm. Possible values are 3 or 6.                    |\n"
         "|  --palette name  Use an alternative palette of colors. Possible palettes   |\n"
         "|                  are: gbmicro or peasoup. The default one is gbmicro.      |\n"
         "|  --input keys    Redefine keys used to emulate the GameBoy's joypad. Need  |\n"
         "|                  to be followed by the list of scancodes in this exact     |\n");
  printf("|                  order: Up Down Left Right Select Start A B TurboA TurboB  |\n"
         "|                  See the list of available scancodes below.                |\n"
         "|  --fnkeys keys   Redefine keys used for calling functions of the emulator. |\n"
         "|                  Need to be followed by the list of scancodes in this exact|\n"
         "|                  order: bgCtrl spriteCtrl windowCtrl Save Load Autoshot    |\n"
         "|                  Screenshot Reset Quit                                     |\n");
  printf("|                  See the list of available scancodes below.                |\n"
         "|  --[no]cpuburn   Do not try to idle the CPU when the emulator have some    |\n"
         "|                  spare time. This might give better results on hi-latency  |\n"
         "|                  systems, at the cost of using the CPU at full speed.      |\n"
         "|  --[no]fullspeed Runs zBoy at full (unlimited) speed. This is not a good   |\n"
         "|                  idea if you want to play games, but might be useful for   |\n");
  printf("|                  some benchmarking needs.                                  |\n"
         "|  --[no]showfps   Shows the FPS counter (frames per second) in the title    |\n"
         "|                  bar of zBoy's window.                                     |\n"
         "|  --[no]hiscores  This option will tell zBoy to memorize HiScores in games  |\n"
         "|                  that aren't able to do so by themselves (eg. Pipe Dream). |\n"
         "|  --[no]rominfo   Displays various informations about the ROM before start. |\n");
  printf("|  --resetcfg      Resets zBoy's configuration to default values.            |\n"
         "|  --netplay x     Establish a 2 player session mode with the IP 'x'.        |\n"
         "|  --bindaddr x    In case of using --netplay, the --bindaddr parameter      |\n"
         "|                  allows to force the local IP (automatic by default).      |\n"
         "+----------------------------------------------------------------------------+\n"
         "\n");
  printf("+----------------------------------------------------------------------------+\n"
         "| List of available scancodes (useable with --input or --fnkeys)             |\n"
         "|                                                                            |\n"
         "| zBoy's key name | Description                                              |\n"
         "| ----------------+------------------------------                            |\n"
         "|    kb.f1        | F1 key                                                   |\n");
  printf("|    kb.f2        | F2 key                                                   |\n"
         "|    kb.f3        | F3 key                                                   |\n"
         "|    kb.f4        | F4 key                                                   |\n"
         "|    kb.f5        | F5 key                                                   |\n"
         "|    kb.f6        | F6 key                                                   |\n"
         "|    kb.f7        | F7 key                                                   |\n");
  printf("|    kb.f8        | F8 key                                                   |\n"
         "|    kb.f9        | F9 key                                                   |\n"
         "|    kb.f10       | F10 key                                                  |\n"
         "|    kb.f11       | F11 key                                                  |\n"
         "|    kb.f12       | F12 key                                                  |\n"
         "|    kb.esc       | Escape key                                               |\n");
  printf("|    kb.tab       | TAB                                                      |\n"
         "|    kb.lctrl     | Left control key                                         |\n"
         "|    kb.lalt      | Left ALT key                                             |\n"
         "|    kb.rctrl     | Right control key                                        |\n"
         "|    kb.ralt      | Right ALT key                                            |\n"
         "|    kb.spc       | Space                                                    |\n");
  printf("|    kb.ret       | Return (enter)                                           |\n"
         "|    kb.bks       | Backspace                                                |\n"
         "|    kb.left      | Left arrow                                               |\n"
         "|    kb.right     | Right arrow                                              |\n"
         "|    kb.up        | Up arrow                                                 |\n"
         "|    kb.down      | Down arrow                                               |\n");
  printf("|    kb.rshift    | Right shift key                                          |\n"
         "|    kb.lshift    | Left shift key                                           |\n"
         "|    kb.lwin      | Left \"Windows\" key                                       |\n"
         "|    kb.rwin      | Right \"Windows\" key                                      |\n"
         "|    kb.menu      | \"Menu\" key                                               |\n"
         "|    kb.pgup      | Page up                                                  |\n");
  printf("|    kb.pgdw      | Page down                                                |\n"
         "|    kb.home      | Home key                                                 |\n"
         "|    kb.end       | End key                                                  |\n"
         "|    kb.ins       | Insert key                                               |\n"
         "|    kb.del       | Delete key                                               |\n"
         "|    kb.a         | Key \"a\"                                                  |\n");
  printf("|    kb.b         | Key \"b\"                                                  |\n"
         "|    kb.c         | Key \"c\"                                                  |\n"
         "|    kb.d         | Key \"d\"                                                  |\n"
         "|    kb.e         | Key \"e\"                                                  |\n"
         "|    kb.f         | Key \"f\"                                                  |\n"
         "|    kb.g         | Key \"g\"                                                  |\n");
  printf("|    kb.h         | Key \"h\"                                                  |\n"
         "|    kb.i         | Key \"i\"                                                  |\n"
         "|    kb.j         | Key \"j\"                                                  |\n"
         "|    kb.k         | Key \"k\"                                                  |\n"
         "|    kb.l         | Key \"l\"                                                  |\n"
         "|    kb.m         | Key \"m\"                                                  |\n");
  printf("|    kb.n         | Key \"n\"                                                  |\n"
         "|    kb.o         | Key \"o\"                                                  |\n"
         "|    kb.p         | Key \"p\"                                                  |\n"
         "|    kb.q         | Key \"q\"                                                  |\n"
         "|    kb.r         | Key \"r\"                                                  |\n"
         "|    kb.s         | Key \"s\"                                                  |\n");
  printf("|    kb.t         | Key \"t\"                                                  |\n"
         "|    kb.u         | Key \"u\"                                                  |\n"
         "|    kb.v         | Key \"v\"                                                  |\n"
         "|    kb.w         | Key \"w\"                                                  |\n"
         "|    kb.x         | Key \"x\"                                                  |\n"
         "|    kb.y         | Key \"y\"                                                  |\n");
  printf("|    kb.z         | Key \"z\"                                                  |\n"
         "|    kb.0         | Key \"0\"                                                  |\n"
         "|    kb.1         | Key \"1\"                                                  |\n"
         "|    kb.2         | Key \"2\"                                                  |\n"
         "|    kb.3         | Key \"3\"                                                  |\n"
         "|    kb.4         | Key \"4\"                                                  |\n");
  printf("|    kb.5         | Key \"5\"                                                  |\n"
         "|    kb.6         | Key \"6\"                                                  |\n"
         "|    kb.7         | Key \"7\"                                                  |\n"
         "|    kb.8         | Key \"8\"                                                  |\n"
         "|    kb.9         | Key \"9\"                                                  |\n"
         "|    joy.a1pos    | Axis #1 on joypad #1 (positive value of the axis)        |\n");
  printf("|    joy.a1neg    | Axis #1 on joypad #1 (negative value of the axis)        |\n"
         "|    joy.a2pos    | Axis #2 on joypad #1 (positive value of the axis)        |\n"
         "|    joy.a2neg    | Axis #2 on joypad #1 (negative value of the axis)        |\n"
         "|    joy.a3pos    | Axis #3 on joypad #1 (positive value of the axis)        |\n"
         "|    joy.a3neg    | Axis #3 on joypad #1 (negative value of the axis)        |\n"
         "|    joy.a4pos    | Axis #4 on joypad #1 (positive value of the axis)        |\n");
  printf("|    joy.a4neg    | Axis #4 on joypad #1 (negative value of the axis)        |\n"
         "|    joy.b1       | Button #1 on joypad #1                                   |\n"
         "|    joy.b2       | Button #2 on joypad #1                                   |\n"
         "|    joy.b3       | Button #3 on joypad #1                                   |\n"
         "|    joy.b4       | Button #4 on joypad #1                                   |\n"
         "|    joy.b5       | Button #5 on joypad #1                                   |\n");
  printf("|    joy.b6       | Button #6 on joypad #1                                   |\n"
         "|    joy.b7       | Button #7 on joypad #1                                   |\n"
         "|    joy.b8       | Button #8 on joypad #1                                   |\n"
         "|    joy.b9       | Button #9 on joypad #1                                   |\n"
         "|    joy.b10      | Button #10 on joypad #1                                  |\n"
         "|    joy.b11      | Button #11 on joypad #1                                  |\n");
  printf("|    joy.b12      | Button #12 on joypad #1                                  |\n"
         "|    joy.b13      | Button #13 on joypad #1                                  |\n"
         "|    joy.b14      | Button #14 on joypad #1                                  |\n"
         "|    joy.b15      | Button #15 on joypad #1                                  |\n"
         "|    joy.b16      | Button #16 on joypad #1                                  |\n"
         "|    none         | No key assigned (useful if we don't need some keys)      |\n");
  printf("|                                                                            |\n"
         "+----------------------------------------------------------------------------+\n"
         "                    homepage: http://zboy.sourceforge.net/\n"
         "\n");
}
