/*
    Part of the zBoy project
    Copyright (C) Mateusz Viste 2010, 2011, 2012
*/

#include <stdint.h>
#include <string.h>
#include "binary.h"

void LoadRomInfos(struct RomInformations *RomInfos) {
  char TempString[1024];
  int x, y, z;
  uint8_t NewLicenseeCode;
  uint8_t *MemoryROM = RomInfos->MemoryROM_PTR;

  for (x = 0; x < 16; x++) TempString[x] = MemoryROM[0x134 + x];

  x = 0;
  while ((TempString[x] > 31) && (TempString[x] < 127) && (x < 16)) x++;
  TempString[x] = 0;   /* Trim all zeroed bytes at the end, as well as high bytes (occuring on new-style licenses) */
  /*TempString = TRIM(TempString) */       /* Trim any spaces on both ends of the string */
  sprintf(RomInfos->Title, TempString);

  /* Now let's see if we can fix the title in any possible way... */

  switch (RomInfos->CrcSum) {  /* Look for well known CRC32 to provide a good title */
    case 0x00CD1876:  /* Bram's Stoker Dracula */
      sprintf(RomInfos->NiceTitle, "Bram Stoker's Dracula");
      break;
    case 0x1D0F279C:  /* 2nd Space (Sachen) */
      sprintf(RomInfos->NiceTitle, "2nd Space");
      break;
    case 0x3D4E1779:  /* Black Forest Tale (Sachen) */
      sprintf(RomInfos->NiceTitle, "Black Forest Tale");
      break;
    case 0x3F47ED05:  /* Dan Laser */
      sprintf(RomInfos->NiceTitle, "Dan Laser");
      break;
    case 0x66130A7A:  /* Worm Visitor (Sachen) */
      sprintf(RomInfos->NiceTitle, "Worm Visitor");
      break;
    case 0x6B4FEFB0:  /* Captain Knick-Knack (Sachen) */
      sprintf(RomInfos->NiceTitle, "Captain Knick-Knack");
      break;
    case 0x776D03DC:  /* A-Force (Sachen) */
      sprintf(RomInfos->NiceTitle, "A-Force");
      break;
    case 0xB1ACBD28:  /* Magic Maze (Sachen) */
      sprintf(RomInfos->NiceTitle, "Magic Maze");
      break;
    case 0xB3A86164:  /* Hyper Lode Runner */
      sprintf(RomInfos->NiceTitle, "Hyper Lode Runner");
      break;
    case 0xB4A5936E:  /* Ant Soldiers (Sachen) */
      sprintf(RomInfos->NiceTitle, "Ant Soldiers");
      break;
    case 0xB5B38860:  /* Attack of the Killer Tomatoes */
      sprintf(RomInfos->NiceTitle, "Attack of the Killer Tomatoes");
      break;
    case 0xC0EF39F0:  /* Track & Field */
      sprintf(RomInfos->NiceTitle, "Track & Field");
      break;
    case 0xCD6E3136:  /* Crazy Burger (Sachen) */
      sprintf(RomInfos->NiceTitle, "Crazy Burger");
      break;
    case 0xD25F3B3C:  /* Duck Adventures (Sachen) */
      sprintf(RomInfos->NiceTitle, "Duck Adventures");
      break;
    case 0xF157AE9E:  /* Magical Tower (Sachen) */
      sprintf(RomInfos->NiceTitle, "Magical Tower");
      break;
    default:  /* Look for mistyped titles... */
      if (strcmp(RomInfos->Title, "") == 0) {
          sprintf(RomInfos->NiceTitle, "Unknown game");
      } else if (strcmp(RomInfos->Title, "ADVENTUREISLAND2") == 0) {
          sprintf(RomInfos->NiceTitle, "Adventure Island II");
      } else if (strcmp(RomInfos->Title, "ARTHUR AFD") == 0) {
          sprintf(RomInfos->NiceTitle, "Arthur's Absolutely Fun Day!");
      } else if (strcmp(RomInfos->Title, "ASTEROIDS/MISCMD") == 0) {
          sprintf(RomInfos->NiceTitle, "Asteroids & Missile Command");
      } else if (strcmp(RomInfos->Title, "BEAVIS & BUTTHE") == 0) {
          sprintf(RomInfos->NiceTitle, "Beavis & Butt-Head");
      } else if (strcmp(RomInfos->Title, "BATMAN ROJ") == 0) {
          sprintf(RomInfos->NiceTitle, "Batman - Return of the Joker");
      } else if (strcmp(RomInfos->Title, "BONKSREVENGE") == 0) {
          sprintf(RomInfos->NiceTitle, "Bonk's Revenge");
      } else if (strcmp(RomInfos->Title, "BUBBLEBOBBLE2") == 0) {
          sprintf(RomInfos->NiceTitle, "Bubble Bobble 2");
      } else if (strcmp(RomInfos->Title, "CASTLEVANIA ADVE") == 0) {
          sprintf(RomInfos->NiceTitle, "The Castlevania Adventure");
      } else if (strcmp(RomInfos->Title, "CONTRA ALIEN WAR") == 0) {
          sprintf(RomInfos->NiceTitle, "Contra - The Alien Wars");
      } else if (strcmp(RomInfos->Title, "DARK WING DUCK") == 0) {
          sprintf(RomInfos->NiceTitle, "Darkwing Duck");
      } else if (strcmp(RomInfos->Title, "ELMO IN GROAELE") == 0) {
          sprintf(RomInfos->NiceTitle, "Elmo in Grouchland");
      } else if (strcmp(RomInfos->Title, "EVEL KNIEVLAEVE") == 0) {
          sprintf(RomInfos->NiceTitle, "Evel Knievel");
      } else if (strcmp(RomInfos->Title, "FIFA 2000") == 0) {
          sprintf(RomInfos->NiceTitle, "FIFA 2000");
      } else if (strcmp(RomInfos->Title, "GALAGA&GALAXIAN") == 0) {
          sprintf(RomInfos->NiceTitle, "Galaga & Galaxian");
      } else if (strcmp(RomInfos->Title, "GBWARS2") == 0) {
          sprintf(RomInfos->NiceTitle, "Gameboy Wars 2");
      } else if (strcmp(RomInfos->Title, "GHOSTSNGOBLAG9E") == 0) {
          sprintf(RomInfos->NiceTitle, "Ghosts'N Goblins");
      } else if (strcmp(RomInfos->Title, "HELLO KITTYAF4E") == 0) {
          sprintf(RomInfos->NiceTitle, "Hello Kitty Cube Frenzy");
      } else if (strcmp(RomInfos->Title, "JURASSIC PARK II") == 0) {
          sprintf(RomInfos->NiceTitle, "Jurassic Park II");
      } else if (strcmp(RomInfos->Title, "LAZLOS LEAP") == 0) {
          sprintf(RomInfos->NiceTitle, "Lazlo's Leap");
      } else if (strcmp(RomInfos->Title, "MAGICMUSEUMAHKJ") == 0) {
          sprintf(RomInfos->NiceTitle, "Hello Kitty Magical Museum");
      } else if (strcmp(RomInfos->Title, "NASCARFASTTRACKS") == 0) {
          sprintf(RomInfos->NiceTitle, "Nascar Fast Tracks");
      } else if (strcmp(RomInfos->Title, "PA BINGO") == 0) {
          sprintf(RomInfos->NiceTitle, "Panel Action Bingo");
      } else if (strcmp(RomInfos->Title, "PAC-MAN SCEAACE") == 0) {
          sprintf(RomInfos->NiceTitle, "Pac-Man Special Color Edition");
      } else if (strcmp(RomInfos->Title, "PAINTERMOMOPIE") == 0) {
          sprintf(RomInfos->NiceTitle, "Painter Momo Pie");
      } else if (strcmp(RomInfos->Title, "PERSONAL ORGANIZ") == 0) {
          sprintf(RomInfos->NiceTitle, "Personal Organizer");
      } else if (strcmp(RomInfos->Title, "PINBALL FANTASIE") == 0) {
          sprintf(RomInfos->NiceTitle, "Pinball Fantasies");
      } else if (strcmp(RomInfos->Title, "POKE MISSION97") == 0) {
          sprintf(RomInfos->NiceTitle, "Poke Mission 97");
      } else if (strcmp(RomInfos->Title, "POKEBOM") == 0) {
          sprintf(RomInfos->NiceTitle, "Pocket Bomberman");
      } else if (strcmp(RomInfos->Title, "PUZZLEX") == 0) {
          sprintf(RomInfos->NiceTitle, "Puzzle X");
      } else if (strcmp(RomInfos->Title, "SPY VS SPY") == 0) {
          sprintf(RomInfos->NiceTitle, "Spy vs Spy");
      } else if (strcmp(RomInfos->Title, "SUPERMARIOLAND3") == 0) {
          sprintf(RomInfos->NiceTitle, "Warioland - Super Mario Land 3");
      } else if (strcmp(RomInfos->Title, "TETRIS DX") == 0) {
          sprintf(RomInfos->NiceTitle, "Tetris DX");
      } else if (strcmp(RomInfos->Title, "TIGER_A_DRAGON") == 0) {
          sprintf(RomInfos->NiceTitle, "Tiger A Dragon");
      } else if (strcmp(RomInfos->Title, "TINY BUSTERBUSE") == 0) {
          sprintf(RomInfos->NiceTitle, "Tiny Toons - Buster Saves the Day");
      } else if (strcmp(RomInfos->Title, "TINY TOON 2 MMM") == 0) {
          sprintf(RomInfos->NiceTitle, "Tiny Toon Adventures 2 - Montana's Movie Madness");
      } else if (strcmp(RomInfos->Title, "TINY TOON ADVENT") == 0) {
          sprintf(RomInfos->NiceTitle, "Tiny Toon Adventures");
      } else if (strcmp(RomInfos->Title, "TINY TOON WACKY") == 0) {
          sprintf(RomInfos->NiceTitle, "Tiny Toon Adventures - Wacky Sports");
      } else if (strcmp(RomInfos->Title, "WEREBACK BC") == 0) {
          sprintf(RomInfos->NiceTitle, "We're Back!");
      } else {   /* Do whatever you can to make the title a bit nicer to look at... */
          y = 0;
          z = 0;
          TempString[0] = 0;
          TempString[1] = 'A';   /* Small caps / big caps flag */
          while (RomInfos->Title[y] != 0) y++;   /* y is the length of the string */
          for (x = 0; x < y; x++) {
            /* Add a space after every dot which is not followed by a space (but not if the dot is the last char of the string) */
            if (x < (y - 1)) {
              if ((RomInfos->Title[x] == '.') || (RomInfos->Title[x] == ',')) {
                if (RomInfos->Title[x+1] != ' ') TempString[0] = ' ';
              }
            }
            /* Use upper case chars only for first char or chars following a space or dash */
            if (z > 0) {
              switch (RomInfos->NiceTitle[z - 1]) {
                case ' ':
                case '-':
                  TempString[1] = 'A';
                  break;
                default:
                  TempString[1] = 'a';
                  break;
              }
            }
            RomInfos->NiceTitle[z] = RomInfos->Title[x];
            if (TempString[1] == 'A') { /* Big caps */
                if ((RomInfos->Title[x] >= 97) && (RomInfos->Title[x] <= 122)) RomInfos->NiceTitle[z] -= 32;
              } else {  /* Small caps */
                if ((RomInfos->Title[x] >= 65) && (RomInfos->Title[x] <= 90)) RomInfos->NiceTitle[z] += 32;
            }
            z++;
            if (TempString[0] == ' ') {
              TempString[0] = 0;
              RomInfos->NiceTitle[z] = ' ';
              z++;
            }
          }
          RomInfos->NiceTitle[z] = 0; /* terminate the string */
          break;
      }
  }

  if (MemoryROM[0x14B] == 0x33) {    /* New-style license */
      NewLicenseeCode = ((MemoryROM[0x144] & bx11110000) | (MemoryROM[0x145] & bx00001111));
      switch (NewLicenseeCode) {
        default:
          sprintf(RomInfos->Licensee, "unknown [%02Xh/%02Xh -> %02Xh]", MemoryROM[0x144], MemoryROM[0x145], NewLicenseeCode);
      }
    } else {   /* Old style license */
      switch (MemoryROM[0x14B]) {  /* Get licensee code from 014Bh */
        case 0x00:
          sprintf(RomInfos->Licensee, "none");
          break;
        case 0x01:
          sprintf(RomInfos->Licensee, "Nintendo");
          break;
        case 0x08:
          sprintf(RomInfos->Licensee, "Capcom");
          break;
        case 0x09:
          sprintf(RomInfos->Licensee, "HOT-B");
          break;
        case 0x0A:
          sprintf(RomInfos->Licensee, "Jaleco");
          break;
        case 0x0B:
          sprintf(RomInfos->Licensee, "Coconuts");
          break;
        case 0x0C:
          sprintf(RomInfos->Licensee, "Elite Systems");
          break;
        case 0x13:
          sprintf(RomInfos->Licensee, "Electronic Arts");
          break;
        case 0x18:
          sprintf(RomInfos->Licensee, "Hudson Soft");
          break;
        case 0x19:
          sprintf(RomInfos->Licensee, "ITC Entertainment");
          break;
        case 0x1A:
          sprintf(RomInfos->Licensee, "Yanoman");
          break;
        case 0x1D:
          sprintf(RomInfos->Licensee, "Clary");
          break;
        case 0x1F:
          sprintf(RomInfos->Licensee, "Virgin");
          break;
        case 0x24:
          sprintf(RomInfos->Licensee, "PCM Complete");
          break;
        case 0x25:
          sprintf(RomInfos->Licensee, "San-X");
          break;
        case 0x28:
          sprintf(RomInfos->Licensee, "Kotobuki Systems");
          break;
        case 0x29:
          sprintf(RomInfos->Licensee, "Seta");
          break;
        case 0x30:
          sprintf(RomInfos->Licensee, "Infogrames");
          break;
        case 0x31:
          sprintf(RomInfos->Licensee, "Nintendo");
          break;
        case 0x32:
          sprintf(RomInfos->Licensee, "Bandai");
          break;
        case 0x34:
          sprintf(RomInfos->Licensee, "Konami");
          break;
        case 0x35:
          sprintf(RomInfos->Licensee, "Hector");
          break;
        case 0x38:
          sprintf(RomInfos->Licensee, "Capcom");
          break;
        case 0x39:
          sprintf(RomInfos->Licensee, "Banpresto");
          break;
        case 0x3C:
          sprintf(RomInfos->Licensee, "Entertainment I (?)");
          break;
        case 0x3E:
          sprintf(RomInfos->Licensee, "Gremlin");
          break;
        case 0x41:
          sprintf(RomInfos->Licensee, "Ubi Soft");
          break;
        case 0x42:
          sprintf(RomInfos->Licensee, "Atlus");
          break;
        case 0x44:
          sprintf(RomInfos->Licensee, "Malibu");
          break;
        case 0x46:
          sprintf(RomInfos->Licensee, "Angel");
          break;
        case 0x47:
          sprintf(RomInfos->Licensee, "Spectrum Holoby");
          break;
        case 0x49:
          sprintf(RomInfos->Licensee, "Irem");
          break;
        case 0x4A:
          sprintf(RomInfos->Licensee, "Virgin");
          break;
        case 0x4D:
          sprintf(RomInfos->Licensee, "Malibu");
          break;
        case 0x4F:
          sprintf(RomInfos->Licensee, "U.S. Gold");
          break;
        case 0x50:
          sprintf(RomInfos->Licensee, "Absolute");
          break;
        case 0x51:
          sprintf(RomInfos->Licensee, "Acclaim");
          break;
        case 0x52:
          sprintf(RomInfos->Licensee, "Activision");
          break;
        case 0x53:
          sprintf(RomInfos->Licensee, "American Sammy");
          break;
        case 0x54:
          sprintf(RomInfos->Licensee, "Gametek");
          break;
        case 0x55:
          sprintf(RomInfos->Licensee, "Park Place");
          break;
        case 0x56:
          sprintf(RomInfos->Licensee, "LJN");
          break;
        case 0x57:
          sprintf(RomInfos->Licensee, "Matchbox");
          break;
        case 0x59:
          sprintf(RomInfos->Licensee, "Milton Bradley");
          break;
        case 0x5A:
          sprintf(RomInfos->Licensee, "Mindscape");
          break;
        case 0x5B:
          sprintf(RomInfos->Licensee, "Romstar");
          break;
        case 0x5C:
          sprintf(RomInfos->Licensee, "Naxat Soft");
          break;
        case 0x5D:
          sprintf(RomInfos->Licensee, "Tradewest");
          break;
        case 0x60:
          sprintf(RomInfos->Licensee, "Titus");
          break;
        case 0x61:
          sprintf(RomInfos->Licensee, "Virgin");
          break;
        case 0x67:
          sprintf(RomInfos->Licensee, "Ocean");
          break;
        case 0x69:
          sprintf(RomInfos->Licensee, "Electronic Arts");
          break;
        case 0x6E:
          sprintf(RomInfos->Licensee, "Elite Systems");
          break;
        case 0x6F:
          sprintf(RomInfos->Licensee, "Electro Brain");
          break;
        case 0x70:
          sprintf(RomInfos->Licensee, "Infogrames");
          break;
        case 0x71:
          sprintf(RomInfos->Licensee, "Interplay");
          break;
        case 0x72:
          sprintf(RomInfos->Licensee, "Broderbund");
          break;
        case 0x73:
          sprintf(RomInfos->Licensee, "Sculptered Soft");
          break;
        case 0x75:
          sprintf(RomInfos->Licensee, "The Sales Curve");
          break;
        case 0x78:
          sprintf(RomInfos->Licensee, "T*HQ");
          break;
        case 0x79:
          sprintf(RomInfos->Licensee, "Accolade");
          break;
        case 0x7A:
          sprintf(RomInfos->Licensee, "Triffix Entertainment");
          break;
        case 0x7C:
          sprintf(RomInfos->Licensee, "Microprose");
          break;
        case 0x7F:
          sprintf(RomInfos->Licensee, "Kemco");
          break;
        case 0x80:
          sprintf(RomInfos->Licensee, "Misawa Entertainment");
          break;
        case 0x83:
          sprintf(RomInfos->Licensee, "Lozc");
          break;
        case 0x86:
          sprintf(RomInfos->Licensee, "Tokuma Shoten I (?)");
          break;
        case 0x8B:
          sprintf(RomInfos->Licensee, "Bullet-Proof Software");
          break;
        case 0x8C:
          sprintf(RomInfos->Licensee, "Vic Tokai");
          break;
        case 0x8E:
          sprintf(RomInfos->Licensee, "Ape");
          break;
        case 0x8F:
          sprintf(RomInfos->Licensee, "I'Max");
          break;
        case 0x91:
          sprintf(RomInfos->Licensee, "Chun Soft");
          break;
        case 0x92:
          sprintf(RomInfos->Licensee, "Video System");
          break;
        case 0x93:
          sprintf(RomInfos->Licensee, "Tsuburava");
          break;
        case 0x95:
          sprintf(RomInfos->Licensee, "Varie");
          break;
        case 0x96:
          sprintf(RomInfos->Licensee, "Yonezawa/s'pal");
          break;
        case 0x97:
          sprintf(RomInfos->Licensee, "Kaneko");
          break;
        case 0x99:
          sprintf(RomInfos->Licensee, "Arc");
          break;
        case 0x9A:
          sprintf(RomInfos->Licensee, "Nihon Bussan");
          break;
        case 0x9B:
          sprintf(RomInfos->Licensee, "Tecmo");
          break;
        case 0x9C:
          sprintf(RomInfos->Licensee, "Imagineer");
          break;
        case 0x9D:
          sprintf(RomInfos->Licensee, "Banpresto");
          break;
        case 0x9F:
          sprintf(RomInfos->Licensee, "Nova");
          break;
        case 0xA1:
          sprintf(RomInfos->Licensee, "Hori Electric");
          break;
        case 0xA2:
          sprintf(RomInfos->Licensee, "Bandai");
          break;
        case 0xA4:
          sprintf(RomInfos->Licensee, "Konami");
          break;
        case 0xA6:
          sprintf(RomInfos->Licensee, "Kawada");
          break;
        case 0xA7:
          sprintf(RomInfos->Licensee, "Takara");
          break;
        case 0xA9:
          sprintf(RomInfos->Licensee, "Technos Japan");
          break;
        case 0xAA:
          sprintf(RomInfos->Licensee, "Broderbund");
          break;
        case 0xAC:
          sprintf(RomInfos->Licensee, "Toei Animation");
          break;
        case 0xAD:
          sprintf(RomInfos->Licensee, "Toho");
          break;
        case 0xAF:
          sprintf(RomInfos->Licensee, "Namco");
          break;
        case 0xB0:
          sprintf(RomInfos->Licensee, "Acclaim");
          break;
        case 0xB1:
          sprintf(RomInfos->Licensee, "Ascii / Nexoft");
          break;
        case 0xB2:
          sprintf(RomInfos->Licensee, "Bandai");
          break;
        case 0xB4:
          sprintf(RomInfos->Licensee, "Enix");
          break;
        case 0xB6:
          sprintf(RomInfos->Licensee, "Hal");
          break;
        case 0xB7:
          sprintf(RomInfos->Licensee, "SNK");
          break;
        case 0xB9:
          sprintf(RomInfos->Licensee, "Pony Canyon");
          break;
        case 0xBA:
          sprintf(RomInfos->Licensee, "Culture Brain O (?)");
          break;
        case 0xBB:
          sprintf(RomInfos->Licensee, "Sunsoft");
          break;
        case 0xBD:
          sprintf(RomInfos->Licensee, "Sony Imagesoft");
          break;
        case 0xBF:
          sprintf(RomInfos->Licensee, "Sammy");
          break;
        case 0xC0:
          sprintf(RomInfos->Licensee, "Taito");
          break;
        case 0xC2:
          sprintf(RomInfos->Licensee, "Kemco");
          break;
        case 0xC3:
          sprintf(RomInfos->Licensee, "Squaresoft");
          break;
        case 0xC4:
          sprintf(RomInfos->Licensee, "Tokuma Shoten I (?)");
          break;
        case 0xC5:
          sprintf(RomInfos->Licensee, "Data East");
          break;
        case 0xC6:
          sprintf(RomInfos->Licensee, "Tonkin House");
          break;
        case 0xC8:
          sprintf(RomInfos->Licensee, "Koei");
          break;
        case 0xC9:
          sprintf(RomInfos->Licensee, "UFL");
          break;
        case 0xCA:
          sprintf(RomInfos->Licensee, "Ultra");
          break;
        case 0xCB:
          sprintf(RomInfos->Licensee, "Vap");
          break;
        case 0xCC:
          sprintf(RomInfos->Licensee, "Use");
          break;
        case 0xCD:
          sprintf(RomInfos->Licensee, "Meldac");
          break;
        case 0xCE:
          sprintf(RomInfos->Licensee, "Pony Canyon Or (?)");
          break;
        case 0xCF:
          sprintf(RomInfos->Licensee, "Angel");
          break;
        case 0xD0:
          sprintf(RomInfos->Licensee, "Taito");
          break;
        case 0xD1:
          sprintf(RomInfos->Licensee, "Sofel");
          break;
        case 0xD2:
          sprintf(RomInfos->Licensee, "Quest");
          break;
        case 0xD3:
          sprintf(RomInfos->Licensee, "Sigma Enterprises");
          break;
        case 0xD4:
          sprintf(RomInfos->Licensee, "Ask Kodansha");
          break;
        case 0xD6:
          sprintf(RomInfos->Licensee, "Naxat Soft");
          break;
        case 0xD7:
          sprintf(RomInfos->Licensee, "Copya Systems");
          break;
        case 0xD9:
          sprintf(RomInfos->Licensee, "Banpresto");
          break;
        case 0xDA:
          sprintf(RomInfos->Licensee, "Tomy");
          break;
        case 0xDB:
          sprintf(RomInfos->Licensee, "LJN");
          break;
        case 0xDD:
          sprintf(RomInfos->Licensee, "NCS");
          break;
        case 0xDE:
          sprintf(RomInfos->Licensee, "Human");
          break;
        case 0xDF:
          sprintf(RomInfos->Licensee, "Altron");
          break;
        case 0xE0:
          sprintf(RomInfos->Licensee, "Jaleco");
          break;
        case 0xE1:
          sprintf(RomInfos->Licensee, "Towachiki");
          break;
        case 0xE2:
          sprintf(RomInfos->Licensee, "Uutaka");
          break;
        case 0xE3:
          sprintf(RomInfos->Licensee, "Varie");
          break;
        case 0xE5:
          sprintf(RomInfos->Licensee, "Epoch");
          break;
        case 0xE7:
          sprintf(RomInfos->Licensee, "Athena");
          break;
        case 0xE8:
          sprintf(RomInfos->Licensee, "Asmik");
          break;
        case 0xE9:
          sprintf(RomInfos->Licensee, "Natsume");
          break;
        case 0xEA:
          sprintf(RomInfos->Licensee, "King Records");
          break;
        case 0xEB:
          sprintf(RomInfos->Licensee, "Atlus");
          break;
        case 0xEC:
          sprintf(RomInfos->Licensee, "Epic / Sony Records");
          break;
        case 0xEE:
          sprintf(RomInfos->Licensee, "IGS");
          break;
        case 0xF0:
          sprintf(RomInfos->Licensee, "A Wave");
          break;
        case 0xF3:
          sprintf(RomInfos->Licensee, "Extreme Entertainment");
          break;
        case 0xFF:
          sprintf(RomInfos->Licensee, "LJN");
          break;
        default:
          sprintf(RomInfos->Licensee, "unknown [%02Xh]", MemoryROM[0x14B]);
          break;
      }
  }

  /* Check bit 7 of the CGB flag (&80 usually means that the game is GB compatible) */
  if ((MemoryROM[0x143] & 128) > 0) RomInfos->ColorGB = 1;
  if (MemoryROM[0x143] == 0xC0) RomInfos->ColorGB = 2;  /* GBC flag + not compatible with older GB */
  if (MemoryROM[0x146] == 0x03) RomInfos->SuperGB = 1;

  switch (MemoryROM[0x147]) {   /* Get the cartridge type */
    case 0x00:
      sprintf(RomInfos->CartTypeString, "ROM ONLY");
      RomInfos->MbcModel = 0;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x01:
      sprintf(RomInfos->CartTypeString, "ROM+MBC1");
      RomInfos->MbcModel = 1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x02:
      sprintf(RomInfos->CartTypeString, "ROM+MBC1+RAM");
      RomInfos->MbcModel = 1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x03:
      sprintf(RomInfos->CartTypeString, "ROM+MBC1+RAM+BATT");
      RomInfos->MbcModel = 1;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x05:
      sprintf(RomInfos->CartTypeString, "ROM+MBC2");
      RomInfos->MbcModel = 2;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x06:
      sprintf(RomInfos->CartTypeString, "ROM+MBC2+BATT");
      RomInfos->MbcModel = 2;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x08:
      sprintf(RomInfos->CartTypeString, "ROM+RAM");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x09:
      sprintf(RomInfos->CartTypeString, "ROM+RAM+BATT");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x0B:
      sprintf(RomInfos->CartTypeString, "ROM+MMMO1");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x0C:
      sprintf(RomInfos->CartTypeString, "ROM+MMMO1+SRAM");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x0D:
      sprintf(RomInfos->CartTypeString, "ROM+MMMO1+SRAM+BATT");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x0F:
      sprintf(RomInfos->CartTypeString, "ROM+MBC3+TIMER+BATT");
      RomInfos->MbcModel = 3;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 1;
      break;
    case 0x10:
      sprintf(RomInfos->CartTypeString, "ROM+MBC3+TIMER+RAM+BATT");
      RomInfos->MbcModel = 3;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 1;
      break;
    case 0x11:
      sprintf(RomInfos->CartTypeString, "ROM+MBC3");
      RomInfos->MbcModel = 3;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x12:
      sprintf(RomInfos->CartTypeString, "ROM+MBC3+RAM");
      RomInfos->MbcModel = 3;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x13:
      sprintf(RomInfos->CartTypeString, "ROM+MBC3+RAM+BATT");
      RomInfos->MbcModel = 3;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x19:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1A:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5+RAM");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1B:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5+RAM+BATT");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1C:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5+RUMBLE");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 1;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1D:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5+RUMBLE+SRAM");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 1;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1E:
      sprintf(RomInfos->CartTypeString, "ROM+MBC5+RUMBLE+SRAM+BATT");
      RomInfos->MbcModel = 5;
      RomInfos->Battery = 1;
      RomInfos->Rumble = 1;
      RomInfos->TimerRTC = 0;
      break;
    case 0x1F:
      sprintf(RomInfos->CartTypeString, "Pocket Camera");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0xFD:
      sprintf(RomInfos->CartTypeString, "Bandai TAMA5");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0xFE:
      sprintf(RomInfos->CartTypeString, "Hudson HuC-3");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    case 0xFF:
      sprintf(RomInfos->CartTypeString, "Hudson HuC-1");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
    default:
      sprintf(RomInfos->CartTypeString, "Unknown cartridge type");
      RomInfos->MbcModel = -1;
      RomInfos->Battery = 0;
      RomInfos->Rumble = 0;
      RomInfos->TimerRTC = 0;
      break;
  }

  switch (MemoryROM[0x148]) {
    case 0x00: /* 256 Kbit */
      RomInfos->RomSize = 32768;
      break;
    case 0x01: /* 512 Kbit */
      RomInfos->RomSize = 65536;
      break;
    case 0x02: /* 1 Mbit */
      RomInfos->RomSize = 131072;
      break;
    case 0x03: /* 2 Mbit */
      RomInfos->RomSize = 262144;
      break;
    case 0x04: /* 4 Mbit */
      RomInfos->RomSize = 524288;
      break;
    case 0x05: /* 8 Mbit */
      RomInfos->RomSize = 1048576;
      break;
    case 0x06: /* 16 Mbit */
      RomInfos->RomSize = 2097152;
      break;
    case 0x52: /* 9 Mbit */
      RomInfos->RomSize = 1179648;
      break;
    case 0x53: /* 10 Mbit */
      RomInfos->RomSize = 1310720;
      break;
    case 0x54: /* 12 Mbit */
      RomInfos->RomSize = 1572864;
      break;
  }

  switch (MemoryROM[0x149]) {
    case 0: /* no RAM */
      RomInfos->RamSize = 0;
      break;
    case 1: /* 16 kBit */
      RomInfos->RamSize = 2048;
      break;
    case 2: /* 64 kBit */
      RomInfos->RamSize = 8192;
      break;
    case 3: /* 256 kBit */
      RomInfos->RamSize = 32768;
      break;
    case 4: /* 1 MBit */
      RomInfos->RamSize = 131072;
      break;
  }

  /* All MBC2 chips contain a 512x4 bits internal RAM, although the byte at 149h always indicates 0 bytes of RAM. */
  if (RomInfos->MbcModel == 2) RomInfos->RamSize = 512;

  if (MemoryROM[0x14A] == 0) {
      RomInfos->Destination = 0;
    } else {
      RomInfos->Destination = 1;
  }

}
