/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_FV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_findVal(inifstru * const f, const char * const name);

	Seek to the first value of the given name within the section
	within the given INI file.

	If name == NULL, the current name of the value is searched

ob: cfgi_findVal
ty: L
su: inifile/2
sh: Search for a value
lo: Searches for a value within the current section within the spepcified
	file only.\par
	If \para{name} == NULL, the current value is searched for.
re: 
fi: cfgi_fv.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <stdlib.h>
#endif
#include "inifile.loc"
#include "supplio.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_FV.C 1.5 2001/02/27 01:27:49 ska Exp ska $";
#endif

int cfgi_findVal(inifstru * const f, const char * const name)
{	const char *val;
	int rv;

	DBG_ENTER("cfgi_findVal", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\"", name) )

	assert(f);

	chkHeap
	if(!f->cfgi_avail)			/* no section in user INI file */
		DBG_RETURN_I( 	CFG_ERR_END)		/* fail */

		/* Seek to start of section */
	if(FFsetpos(f->cfgi_fp, f->cfgi_pos))
		DBG_RETURN_I( CFG_ERR_ACCESS)

	if(name)		val = name;		/* name of value specified */
	else if(!I(value))				/* no known name */
		DBG_RETURN_I( CFG_ERR_ARG)
	else if((val = strdup(I(value))) == 0)
		DBG_RETURN_I( CFG_ERR_MEM)

	chkHeap
	while((rv = cfgi_nxtVal(f->cfgi_fp)) == CFG_ERR_NONE
	 && !cfgEqName(I(value), val))
	 	chkHeap

	if(!name)	free(val);
	chkHeap

	DBG_RETURN_I( rv)
}
