'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   This Software is provided under the Zope Public License (ZPL) Version 2.1.
''
''   Copyright (c) 2009, 2010 by the mingw-w64 project
''
''   See the AUTHORS file for the list of contributors to the mingw-w64 project.
''
''   This license has been certified as open source. It has also been designated
''   as GPL compatible by the Free Software Foundation (FSF).
''
''   Redistribution and use in source and binary forms, with or without
''   modification, are permitted provided that the following conditions are met:
''
''     1. Redistributions in source code must retain the accompanying copyright
''        notice, this list of conditions, and the following disclaimer.
''     2. Redistributions in binary form must reproduce the accompanying
''        copyright notice, this list of conditions, and the following disclaimer
''        in the documentation and/or other materials provided with the
''        distribution.
''     3. Names of the copyright holders must not be used to endorse or promote
''        products derived from this software without prior written permission
''        from the copyright holders.
''     4. The right to distribute this software or to use it for any purpose does
''        not give you the right to use Servicemarks (sm) or Trademarks (tm) of
''        the copyright holders.  Use of them is covered by separate agreement
''        with the copyright holders.
''     5. If any files are modified, you must cause the modified files to carry
''        prominent notices stating that you changed the files and the date of
''        any change.
''
''   Disclaimer
''
''   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS ``AS IS'' AND ANY EXPRESSED
''   OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
''   OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
''   EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY DIRECT, INDIRECT,
''   INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
''   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, 
''   OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
''   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
''   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
''   EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
''
'' translated to FreeBASIC by:
''   Copyright © 2015 FreeBASIC development team

#pragma once

#include once "winapifamily.bi"

#if _WIN32_WINNT >= &h0600
	#include once "ifdef.bi"
	#include once "devpkey.bi"
	#include once "pciprop.bi"
#endif

#define _NTDDNDIS_
const NDIS_SUPPORT_NDIS6 = 0
const NDIS_SUPPORT_NDIS61 = 0
const NDIS_SUPPORT_NDIS620 = 0
const NDIS_SUPPORT_NDIS630 = 0
#define DD_NDIS_DEVICE_NAME !"\\Device\\UNKNOWN"
#define _NDIS_CONTROL_CODE(request, method) CTL_CODE(FILE_DEVICE_PHYSICAL_NETCARD, request, method, FILE_ANY_ACCESS)
#define IOCTL_NDIS_QUERY_GLOBAL_STATS _NDIS_CONTROL_CODE(0, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_QUERY_ALL_STATS _NDIS_CONTROL_CODE(1, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_DO_PNP_OPERATION _NDIS_CONTROL_CODE(2, METHOD_BUFFERED)
#define IOCTL_NDIS_QUERY_SELECTED_STATS _NDIS_CONTROL_CODE(3, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_ENUMERATE_INTERFACES _NDIS_CONTROL_CODE(4, METHOD_BUFFERED)
#define IOCTL_NDIS_ADD_TDI_DEVICE _NDIS_CONTROL_CODE(5, METHOD_BUFFERED)
#define IOCTL_NDIS_GET_LOG_DATA _NDIS_CONTROL_CODE(7, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_GET_VERSION _NDIS_CONTROL_CODE(8, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED1 _NDIS_CONTROL_CODE(9, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED2 _NDIS_CONTROL_CODE(&ha, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED3 _NDIS_CONTROL_CODE(&hb, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED4 _NDIS_CONTROL_CODE(&hc, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED5 CTL_CODE(FILE_DEVICE_PHYSICAL_NETCARD, &hd, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_NDIS_RESERVED6 CTL_CODE(FILE_DEVICE_PHYSICAL_NETCARD, &he, METHOD_BUFFERED, FILE_WRITE_ACCESS)
#define IOCTL_NDIS_RESERVED7 _NDIS_CONTROL_CODE(&hf, METHOD_OUT_DIRECT)
#define IOCTL_NDIS_RESERVED8 _NDIS_CONTROL_CODE(&h10, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED9 _NDIS_CONTROL_CODE(&h11, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED10 _NDIS_CONTROL_CODE(&h12, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED11 _NDIS_CONTROL_CODE(&h13, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED12 _NDIS_CONTROL_CODE(&h14, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED13 _NDIS_CONTROL_CODE(&h15, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED14 _NDIS_CONTROL_CODE(&h16, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED15 _NDIS_CONTROL_CODE(&h17, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED16 _NDIS_CONTROL_CODE(&h18, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED17 _NDIS_CONTROL_CODE(&h19, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED18 _NDIS_CONTROL_CODE(&h1a, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED19 _NDIS_CONTROL_CODE(&h1b, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED20 _NDIS_CONTROL_CODE(&h1c, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED21 _NDIS_CONTROL_CODE(&h1d, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED22 _NDIS_CONTROL_CODE(&h1e, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED23 _NDIS_CONTROL_CODE(&h1f, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED24 _NDIS_CONTROL_CODE(&h20, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED25 _NDIS_CONTROL_CODE(&h21, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED26 _NDIS_CONTROL_CODE(&h22, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED27 _NDIS_CONTROL_CODE(&h23, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED28 _NDIS_CONTROL_CODE(&h24, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED29 _NDIS_CONTROL_CODE(&h25, METHOD_BUFFERED)
#define IOCTL_NDIS_RESERVED30 _NDIS_CONTROL_CODE(&h26, METHOD_BUFFERED)
type NDIS_OID as ULONG
type PNDIS_OID as ULONG ptr

type _NDIS_STATISTICS_VALUE
	Oid as NDIS_OID
	DataLength as ULONG
	Data(0 to 0) as UCHAR
end type

type NDIS_STATISTICS_VALUE as _NDIS_STATISTICS_VALUE
type PNDIS_STATISTICS_VALUE as NDIS_STATISTICS_VALUE ptr

#if _WIN32_WINNT >= &h0600
	type _NDIS_STATISTICS_VALUE_EX
		Oid as NDIS_OID
		DataLength as ULONG
		Length as ULONG
		Data(0 to 0) as UCHAR
	end type

	type NDIS_STATISTICS_VALUE_EX as _NDIS_STATISTICS_VALUE_EX
	type PNDIS_STATISTICS_VALUE_EX as NDIS_STATISTICS_VALUE_EX ptr
#endif

type _NDIS_VAR_DATA_DESC
	Length as USHORT
	MaximumLength as USHORT
	Offset as ULONG_PTR
end type

type NDIS_VAR_DATA_DESC as _NDIS_VAR_DATA_DESC
type PNDIS_VAR_DATA_DESC as _NDIS_VAR_DATA_DESC ptr
const NDIS_OBJECT_TYPE_DEFAULT = &h80
const NDIS_OBJECT_TYPE_MINIPORT_INIT_PARAMETERS = &h81
const NDIS_OBJECT_TYPE_SG_DMA_DESCRIPTION = &h83
const NDIS_OBJECT_TYPE_MINIPORT_INTERRUPT = &h84
const NDIS_OBJECT_TYPE_DEVICE_OBJECT_ATTRIBUTES = &h85
const NDIS_OBJECT_TYPE_BIND_PARAMETERS = &h86
const NDIS_OBJECT_TYPE_OPEN_PARAMETERS = &h87
const NDIS_OBJECT_TYPE_RSS_CAPABILITIES = &h88
const NDIS_OBJECT_TYPE_RSS_PARAMETERS = &h89
const NDIS_OBJECT_TYPE_MINIPORT_DRIVER_CHARACTERISTICS = &h8a
const NDIS_OBJECT_TYPE_FILTER_DRIVER_CHARACTERISTICS = &h8b
const NDIS_OBJECT_TYPE_FILTER_PARTIAL_CHARACTERISTICS = &h8c
const NDIS_OBJECT_TYPE_FILTER_ATTRIBUTES = &h8d
const NDIS_OBJECT_TYPE_CLIENT_CHIMNEY_OFFLOAD_GENERIC_CHARACTERISTICS = &h8e
const NDIS_OBJECT_TYPE_PROVIDER_CHIMNEY_OFFLOAD_GENERIC_CHARACTERISTICS = &h8f
const NDIS_OBJECT_TYPE_CO_PROTOCOL_CHARACTERISTICS = &h90
const NDIS_OBJECT_TYPE_CO_MINIPORT_CHARACTERISTICS = &h91
const NDIS_OBJECT_TYPE_MINIPORT_PNP_CHARACTERISTICS = &h92
const NDIS_OBJECT_TYPE_CLIENT_CHIMNEY_OFFLOAD_CHARACTERISTICS = &h93
const NDIS_OBJECT_TYPE_PROVIDER_CHIMNEY_OFFLOAD_CHARACTERISTICS = &h94
const NDIS_OBJECT_TYPE_PROTOCOL_DRIVER_CHARACTERISTICS = &h95
const NDIS_OBJECT_TYPE_REQUEST_EX = &h96
const NDIS_OBJECT_TYPE_OID_REQUEST = &h96
const NDIS_OBJECT_TYPE_TIMER_CHARACTERISTICS = &h97
const NDIS_OBJECT_TYPE_STATUS_INDICATION = &h98
const NDIS_OBJECT_TYPE_FILTER_ATTACH_PARAMETERS = &h99
const NDIS_OBJECT_TYPE_FILTER_PAUSE_PARAMETERS = &h9a
const NDIS_OBJECT_TYPE_FILTER_RESTART_PARAMETERS = &h9b
const NDIS_OBJECT_TYPE_PORT_CHARACTERISTICS = &h9c
const NDIS_OBJECT_TYPE_PORT_STATE = &h9d
const NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_REGISTRATION_ATTRIBUTES = &h9e
const NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_GENERAL_ATTRIBUTES = &h9f
const NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_OFFLOAD_ATTRIBUTES = &ha0
const NDIS_OBJECT_TYPE_MINIPORT_ADAPTER_NATIVE_802_11_ATTRIBUTES = &ha1
const NDIS_OBJECT_TYPE_RESTART_GENERAL_ATTRIBUTES = &ha2
const NDIS_OBJECT_TYPE_PROTOCOL_RESTART_PARAMETERS = &ha3
const NDIS_OBJECT_TYPE_MINIPORT_ADD_DEVICE_REGISTRATION_ATTRIBUTES = &ha4
const NDIS_OBJECT_TYPE_CO_CALL_MANAGER_OPTIONAL_HANDLERS = &ha5
const NDIS_OBJECT_TYPE_CO_CLIENT_OPTIONAL_HANDLERS = &ha6
const NDIS_OBJECT_TYPE_OFFLOAD = &ha7
const NDIS_OBJECT_TYPE_OFFLOAD_ENCAPSULATION = &ha8
const NDIS_OBJECT_TYPE_CONFIGURATION_OBJECT = &ha9
const NDIS_OBJECT_TYPE_DRIVER_WRAPPER_OBJECT = &haa
const NDIS_OBJECT_TYPE_NSI_NETWORK_RW_STRUCT = &hac
const NDIS_OBJECT_TYPE_NSI_COMPARTMENT_RW_STRUCT = &had
const NDIS_OBJECT_TYPE_NSI_INTERFACE_PERSIST_RW_STRUCT = &hae

type _NDIS_OBJECT_HEADER
	as UCHAR Type
	Revision as UCHAR
	Size as USHORT
end type

type NDIS_OBJECT_HEADER as _NDIS_OBJECT_HEADER
type PNDIS_OBJECT_HEADER as _NDIS_OBJECT_HEADER ptr

type _NDIS_REQUEST_TYPE as long
enum
	NdisRequestQueryInformation
	NdisRequestSetInformation
	NdisRequestQueryStatistics
	NdisRequestOpen
	NdisRequestClose
	NdisRequestSend
	NdisRequestTransferData
	NdisRequestReset
	NdisRequestGeneric1
	NdisRequestGeneric2
	NdisRequestGeneric3
	NdisRequestGeneric4
end enum

type NDIS_REQUEST_TYPE as _NDIS_REQUEST_TYPE
type PNDIS_REQUEST_TYPE as _NDIS_REQUEST_TYPE ptr
const NDIS_OBJECT_REVISION_1 = 1

#if _WIN32_WINNT >= &h0600
	const NDIS_STATISTICS_FLAGS_VALID_DIRECTED_FRAMES_RCV = &h00000001
	const NDIS_STATISTICS_FLAGS_VALID_MULTICAST_FRAMES_RCV = &h00000002
	const NDIS_STATISTICS_FLAGS_VALID_BROADCAST_FRAMES_RCV = &h00000004
	const NDIS_STATISTICS_FLAGS_VALID_BYTES_RCV = &h00000008
	const NDIS_STATISTICS_FLAGS_VALID_RCV_DISCARDS = &h00000010
	const NDIS_STATISTICS_FLAGS_VALID_RCV_ERROR = &h00000020
	const NDIS_STATISTICS_FLAGS_VALID_DIRECTED_FRAMES_XMIT = &h00000040
	const NDIS_STATISTICS_FLAGS_VALID_MULTICAST_FRAMES_XMIT = &h00000080
	const NDIS_STATISTICS_FLAGS_VALID_BROADCAST_FRAMES_XMIT = &h00000100
	const NDIS_STATISTICS_FLAGS_VALID_BYTES_XMIT = &h00000200
	const NDIS_STATISTICS_FLAGS_VALID_XMIT_ERROR = &h00000400
	const NDIS_STATISTICS_FLAGS_VALID_XMIT_DISCARDS = &h00008000
	const NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_RCV = &h00010000
	const NDIS_STATISTICS_FLAGS_VALID_MULTICAST_BYTES_RCV = &h00020000
	const NDIS_STATISTICS_FLAGS_VALID_BROADCAST_BYTES_RCV = &h00040000
	const NDIS_STATISTICS_FLAGS_VALID_DIRECTED_BYTES_XMIT = &h00080000
	const NDIS_STATISTICS_FLAGS_VALID_MULTICAST_BYTES_XMIT = &h00100000
	const NDIS_STATISTICS_FLAGS_VALID_BROADCAST_BYTES_XMIT = &h00200000
	const NDIS_INTERRUPT_MODERATION_CHANGE_NEEDS_RESET = &h00000001
	const NDIS_INTERRUPT_MODERATION_CHANGE_NEEDS_REINITIALIZE = &h00000002
	const NDIS_STATISTICS_INFO_REVISION_1 = 1
	const NDIS_INTERRUPT_MODERATION_PARAMETERS_REVISION_1 = 1
	const NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES_REVISION_1 = 1
	const NDIS_OBJECT_TYPE_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_1 = 1
#endif

#if _WIN32_WINNT >= &h0601
	const NDIS_OBJECT_TYPE_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_2 = 2
#endif

#if _WIN32_WINNT >= &h0600
	#define NDIS_SIZEOF_STATISTICS_INFO_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_STATISTICS_INFO, ifHCOutBroadcastOctets)
	#define NDIS_SIZEOF_INTERRUPT_MODERATION_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_INTERRUPT_MODERATION_PARAMETERS, InterruptModeration)
	#define NDIS_SIZEOF_TIMEOUT_DPC_REQUEST_CAPABILITIES_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES, TimeoutArray)
	#define NDIS_SIZEOF_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_PCI_DEVICE_CUSTOM_PROPERTIES, MaxLinkWidth)
#endif

#if _WIN32_WINNT >= &h0601
	#define NDIS_SIZEOF_PCI_DEVICE_CUSTOM_PROPERTIES_REVISION_2 RTL_SIZEOF_THROUGH_FIELD(NDIS_PCI_DEVICE_CUSTOM_PROPERTIES, MaxInterruptMessages)
#endif

#if _WIN32_WINNT >= &h0600
	type _NDIS_STATISTICS_INFO
		Header as NDIS_OBJECT_HEADER
		SupportedStatistics as ULONG
		ifInDiscards as ULONG64
		ifInErrors as ULONG64
		ifHCInOctets as ULONG64
		ifHCInUcastPkts as ULONG64
		ifHCInMulticastPkts as ULONG64
		ifHCInBroadcastPkts as ULONG64
		ifHCOutOctets as ULONG64
		ifHCOutUcastPkts as ULONG64
		ifHCOutMulticastPkts as ULONG64
		ifHCOutBroadcastPkts as ULONG64
		ifOutErrors as ULONG64
		ifOutDiscards as ULONG64
		ifHCInUcastOctets as ULONG64
		ifHCInMulticastOctets as ULONG64
		ifHCInBroadcastOctets as ULONG64
		ifHCOutUcastOctets as ULONG64
		ifHCOutMulticastOctets as ULONG64
		ifHCOutBroadcastOctets as ULONG64
	end type

	type NDIS_STATISTICS_INFO as _NDIS_STATISTICS_INFO
	type PNDIS_STATISTICS_INFO as _NDIS_STATISTICS_INFO ptr

	type _NDIS_INTERRUPT_MODERATION as long
	enum
		NdisInterruptModerationUnknown
		NdisInterruptModerationNotSupported
		NdisInterruptModerationEnabled
		NdisInterruptModerationDisabled
	end enum

	type NDIS_INTERRUPT_MODERATION as _NDIS_INTERRUPT_MODERATION
	type PNDIS_INTERRUPT_MODERATION as _NDIS_INTERRUPT_MODERATION ptr

	type _NDIS_INTERRUPT_MODERATION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		InterruptModeration as NDIS_INTERRUPT_MODERATION
	end type

	type NDIS_INTERRUPT_MODERATION_PARAMETERS as _NDIS_INTERRUPT_MODERATION_PARAMETERS
	type PNDIS_INTERRUPT_MODERATION_PARAMETERS as _NDIS_INTERRUPT_MODERATION_PARAMETERS ptr

	type _NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		TimeoutArrayLength as ULONG
		TimeoutArray(0 to 0) as ULONG
	end type

	type NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES as _NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES
	type PNDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES as _NDIS_TIMEOUT_DPC_REQUEST_CAPABILITIES ptr

	type _NDIS_PCI_DEVICE_CUSTOM_PROPERTIES
		Header as NDIS_OBJECT_HEADER
		DeviceType as UINT32
		CurrentSpeedAndMode as UINT32
		CurrentPayloadSize as UINT32
		MaxPayloadSize as UINT32
		MaxReadRequestSize as UINT32
		CurrentLinkSpeed as UINT32
		CurrentLinkWidth as UINT32
		MaxLinkSpeed as UINT32
		MaxLinkWidth as UINT32

		#if _WIN32_WINNT >= &h0601
			PciExpressVersion as UINT32
			InterruptType as UINT32
			MaxInterruptMessages as UINT32
		#endif
	end type

	type NDIS_PCI_DEVICE_CUSTOM_PROPERTIES as _NDIS_PCI_DEVICE_CUSTOM_PROPERTIES
	type PNDIS_PCI_DEVICE_CUSTOM_PROPERTIES as _NDIS_PCI_DEVICE_CUSTOM_PROPERTIES ptr
#endif

const OID_GEN_SUPPORTED_LIST = &h00010101
const OID_GEN_HARDWARE_STATUS = &h00010102
const OID_GEN_MEDIA_SUPPORTED = &h00010103
const OID_GEN_MEDIA_IN_USE = &h00010104
const OID_GEN_MAXIMUM_LOOKAHEAD = &h00010105
const OID_GEN_MAXIMUM_FRAME_SIZE = &h00010106
const OID_GEN_LINK_SPEED = &h00010107
const OID_GEN_TRANSMIT_BUFFER_SPACE = &h00010108
const OID_GEN_RECEIVE_BUFFER_SPACE = &h00010109
const OID_GEN_TRANSMIT_BLOCK_SIZE = &h0001010a
const OID_GEN_RECEIVE_BLOCK_SIZE = &h0001010b
const OID_GEN_VENDOR_ID = &h0001010c
const OID_GEN_VENDOR_DESCRIPTION = &h0001010d
const OID_GEN_CURRENT_PACKET_FILTER = &h0001010e
const OID_GEN_CURRENT_LOOKAHEAD = &h0001010f
const OID_GEN_DRIVER_VERSION = &h00010110
const OID_GEN_MAXIMUM_TOTAL_SIZE = &h00010111
const OID_GEN_PROTOCOL_OPTIONS = &h00010112
const OID_GEN_MAC_OPTIONS = &h00010113
const OID_GEN_MEDIA_CONNECT_STATUS = &h00010114
const OID_GEN_MAXIMUM_SEND_PACKETS = &h00010115
const OID_GEN_VENDOR_DRIVER_VERSION = &h00010116
const OID_GEN_SUPPORTED_GUIDS = &h00010117
const OID_GEN_NETWORK_LAYER_ADDRESSES = &h00010118
const OID_GEN_TRANSPORT_HEADER_OFFSET = &h00010119
const OID_GEN_MEDIA_CAPABILITIES = &h00010201
const OID_GEN_PHYSICAL_MEDIUM = &h00010202

#if _WIN32_WINNT >= &h0600
	const OID_GEN_RECEIVE_SCALE_CAPABILITIES = &h00010203
	const OID_GEN_RECEIVE_SCALE_PARAMETERS = &h00010204
	const OID_GEN_MAC_ADDRESS = &h00010205
	const OID_GEN_MAX_LINK_SPEED = &h00010206
	const OID_GEN_LINK_STATE = &h00010207
	const OID_GEN_LINK_PARAMETERS = &h00010208
	const OID_GEN_INTERRUPT_MODERATION = &h00010209
	const OID_GEN_NDIS_RESERVED_3 = &h0001020a
	const OID_GEN_NDIS_RESERVED_4 = &h0001020b
	const OID_GEN_NDIS_RESERVED_5 = &h0001020c
	const OID_GEN_ENUMERATE_PORTS = &h0001020d
	const OID_GEN_PORT_STATE = &h0001020e
	const OID_GEN_PORT_AUTHENTICATION_PARAMETERS = &h0001020f
	const OID_GEN_TIMEOUT_DPC_REQUEST_CAPABILITIES = &h00010210
	const OID_GEN_PCI_DEVICE_CUSTOM_PROPERTIES = &h00010211
	const OID_GEN_NDIS_RESERVED_6 = &h00010212
	const OID_GEN_PHYSICAL_MEDIUM_EX = &h00010213
#endif

const OID_GEN_MACHINE_NAME = &h0001021a
const OID_GEN_RNDIS_CONFIG_PARAMETER = &h0001021b
const OID_GEN_VLAN_ID = &h0001021c

#if _WIN32_WINNT >= &h0600
	const OID_GEN_RECEIVE_HASH = &h0001021f
	const OID_GEN_MINIPORT_RESTART_ATTRIBUTES = &h0001021d
	const OID_GEN_PROMISCUOUS_MODE = &h00010280
	const OID_GEN_LAST_CHANGE = &h00010281
	const OID_GEN_DISCONTINUITY_TIME = &h00010282
	const OID_GEN_OPERATIONAL_STATUS = &h00010283
	const OID_GEN_XMIT_LINK_SPEED = &h00010284
	const OID_GEN_RCV_LINK_SPEED = &h00010285
	const OID_GEN_UNKNOWN_PROTOS = &h00010286
	const OID_GEN_INTERFACE_INFO = &h00010287
	const OID_GEN_ADMIN_STATUS = &h00010288
	const OID_GEN_ALIAS = &h00010289
	const OID_GEN_MEDIA_CONNECT_STATUS_EX = &h0001028a
	const OID_GEN_LINK_SPEED_EX = &h0001028b
	const OID_GEN_MEDIA_DUPLEX_STATE = &h0001028c
	const OID_GEN_IP_OPER_STATUS = &h0001028d
	const OID_WWAN_DRIVER_CAPS = &h0e010100
	const OID_WWAN_DEVICE_CAPS = &h0e010101
	const OID_WWAN_READY_INFO = &h0e010102
	const OID_WWAN_RADIO_STATE = &h0e010103
	const OID_WWAN_PIN = &h0e010104
	const OID_WWAN_PIN_LIST = &h0e010105
	const OID_WWAN_HOME_PROVIDER = &h0e010106
	const OID_WWAN_PREFERRED_PROVIDERS = &h0e010107
	const OID_WWAN_VISIBLE_PROVIDERS = &h0e010108
	const OID_WWAN_REGISTER_STATE = &h0e010109
	const OID_WWAN_PACKET_SERVICE = &h0e01010a
	const OID_WWAN_SIGNAL_STATE = &h0e01010b
	const OID_WWAN_CONNECT = &h0e01010c
	const OID_WWAN_PROVISIONED_CONTEXTS = &h0e01010d
	const OID_WWAN_SERVICE_ACTIVATION = &h0e01010e
	const OID_WWAN_SMS_CONFIGURATION = &h0e01010f
	const OID_WWAN_SMS_READ = &h0e010110
	const OID_WWAN_SMS_SEND = &h0e010111
	const OID_WWAN_SMS_DELETE = &h0e010112
	const OID_WWAN_SMS_STATUS = &h0e010113
	const OID_WWAN_VENDOR_SPECIFIC = &h0e010114
#endif

#if _WIN32_WINNT = &h0602
	const OID_WWAN_AUTH_CHALLENGE = &h0e010115
	const OID_WWAN_ENUMERATE_DEVICE_SERVICES = &h0e010116
	const OID_WWAN_SUBSCRIBE_DEVICE_SERVICE_EVENTS = &h0e010117
	const OID_WWAN_DEVICE_SERVICE_COMMAND = &h0e010118
	const OID_WWAN_USSD = &h0e010119
	const OID_WWAN_PIN_EX = &h0e010121
	const OID_WWAN_ENUMERATE_DEVICE_SERVICE_COMMANDS = &h0e010122
	const OID_WWAN_DEVICE_SERVICE_SESSION = &h0e010123
	const OID_WWAN_DEVICE_SERVICE_SESSION_WRITE = &h0e010124
	const OID_WWAN_PREFERRED_MULTICARRIER_PROVIDERS = &h0e010125
#endif

const OID_GEN_XMIT_OK = &h00020101
const OID_GEN_RCV_OK = &h00020102
const OID_GEN_XMIT_ERROR = &h00020103
const OID_GEN_RCV_ERROR = &h00020104
const OID_GEN_RCV_NO_BUFFER = &h00020105

#if _WIN32_WINNT >= &h0600
	const OID_GEN_STATISTICS = &h00020106
#endif

const OID_GEN_DIRECTED_BYTES_XMIT = &h00020201
const OID_GEN_DIRECTED_FRAMES_XMIT = &h00020202
const OID_GEN_MULTICAST_BYTES_XMIT = &h00020203
const OID_GEN_MULTICAST_FRAMES_XMIT = &h00020204
const OID_GEN_BROADCAST_BYTES_XMIT = &h00020205
const OID_GEN_BROADCAST_FRAMES_XMIT = &h00020206
const OID_GEN_DIRECTED_BYTES_RCV = &h00020207
const OID_GEN_DIRECTED_FRAMES_RCV = &h00020208
const OID_GEN_MULTICAST_BYTES_RCV = &h00020209
const OID_GEN_MULTICAST_FRAMES_RCV = &h0002020a
const OID_GEN_BROADCAST_BYTES_RCV = &h0002020b
const OID_GEN_BROADCAST_FRAMES_RCV = &h0002020c
const OID_GEN_RCV_CRC_ERROR = &h0002020d
const OID_GEN_TRANSMIT_QUEUE_LENGTH = &h0002020e
const OID_GEN_GET_TIME_CAPS = &h0002020f
const OID_GEN_GET_NETCARD_TIME = &h00020210
const OID_GEN_NETCARD_LOAD = &h00020211
const OID_GEN_DEVICE_PROFILE = &h00020212
const OID_GEN_INIT_TIME_MS = &h00020213
const OID_GEN_RESET_COUNTS = &h00020214
const OID_GEN_MEDIA_SENSE_COUNTS = &h00020215
const OID_GEN_FRIENDLY_NAME = &h00020216
const OID_GEN_NDIS_RESERVED_1 = &h00020217
const OID_GEN_NDIS_RESERVED_2 = &h00020218
const OID_GEN_NDIS_RESERVED_5 = &h0001020c

#if _WIN32_WINNT >= &h0600
	const OID_GEN_BYTES_RCV = &h00020219
	const OID_GEN_BYTES_XMIT = &h0002021a
	const OID_GEN_RCV_DISCARDS = &h0002021b
	const OID_GEN_XMIT_DISCARDS = &h0002021c
#endif

#if _WIN32_WINNT = &h0602
	const OID_TCP_RSC_STATISTICS = &h0002021d
	const OID_GEN_NDIS_RESERVED_7 = &h0002021e
#endif

const OID_GEN_CO_SUPPORTED_LIST = OID_GEN_SUPPORTED_LIST
const OID_GEN_CO_HARDWARE_STATUS = OID_GEN_HARDWARE_STATUS
const OID_GEN_CO_MEDIA_SUPPORTED = OID_GEN_MEDIA_SUPPORTED
const OID_GEN_CO_MEDIA_IN_USE = OID_GEN_MEDIA_IN_USE
const OID_GEN_CO_LINK_SPEED = OID_GEN_LINK_SPEED
const OID_GEN_CO_VENDOR_ID = OID_GEN_VENDOR_ID
const OID_GEN_CO_VENDOR_DESCRIPTION = OID_GEN_VENDOR_DESCRIPTION
const OID_GEN_CO_DRIVER_VERSION = OID_GEN_DRIVER_VERSION
const OID_GEN_CO_PROTOCOL_OPTIONS = OID_GEN_PROTOCOL_OPTIONS
const OID_GEN_CO_MAC_OPTIONS = OID_GEN_MAC_OPTIONS
const OID_GEN_CO_MEDIA_CONNECT_STATUS = OID_GEN_MEDIA_CONNECT_STATUS
const OID_GEN_CO_VENDOR_DRIVER_VERSION = OID_GEN_VENDOR_DRIVER_VERSION
const OID_GEN_CO_SUPPORTED_GUIDS = OID_GEN_SUPPORTED_GUIDS
const OID_GEN_CO_GET_TIME_CAPS = OID_GEN_GET_TIME_CAPS
const OID_GEN_CO_GET_NETCARD_TIME = OID_GEN_GET_NETCARD_TIME
const OID_GEN_CO_MINIMUM_LINK_SPEED = &h00020120
const OID_GEN_CO_XMIT_PDUS_OK = OID_GEN_XMIT_OK
const OID_GEN_CO_RCV_PDUS_OK = OID_GEN_RCV_OK
const OID_GEN_CO_XMIT_PDUS_ERROR = OID_GEN_XMIT_ERROR
const OID_GEN_CO_RCV_PDUS_ERROR = OID_GEN_RCV_ERROR
const OID_GEN_CO_RCV_PDUS_NO_BUFFER = OID_GEN_RCV_NO_BUFFER
const OID_GEN_CO_RCV_CRC_ERROR = OID_GEN_RCV_CRC_ERROR
const OID_GEN_CO_TRANSMIT_QUEUE_LENGTH = OID_GEN_TRANSMIT_QUEUE_LENGTH
const OID_GEN_CO_BYTES_XMIT = OID_GEN_DIRECTED_BYTES_XMIT
const OID_GEN_CO_BYTES_RCV = OID_GEN_DIRECTED_BYTES_RCV
const OID_GEN_CO_NETCARD_LOAD = OID_GEN_NETCARD_LOAD
const OID_GEN_CO_DEVICE_PROFILE = OID_GEN_DEVICE_PROFILE
const OID_GEN_CO_BYTES_XMIT_OUTSTANDING = &h00020221
const OID_802_3_PERMANENT_ADDRESS = &h01010101
const OID_802_3_CURRENT_ADDRESS = &h01010102
const OID_802_3_MULTICAST_LIST = &h01010103
const OID_802_3_MAXIMUM_LIST_SIZE = &h01010104
const OID_802_3_MAC_OPTIONS = &h01010105
const NDIS_802_3_MAC_OPTION_PRIORITY = &h00000001
const OID_802_3_RCV_ERROR_ALIGNMENT = &h01020101
const OID_802_3_XMIT_ONE_COLLISION = &h01020102
const OID_802_3_XMIT_MORE_COLLISIONS = &h01020103
const OID_802_3_XMIT_DEFERRED = &h01020201
const OID_802_3_XMIT_MAX_COLLISIONS = &h01020202
const OID_802_3_RCV_OVERRUN = &h01020203
const OID_802_3_XMIT_UNDERRUN = &h01020204
const OID_802_3_XMIT_HEARTBEAT_FAILURE = &h01020205
const OID_802_3_XMIT_TIMES_CRS_LOST = &h01020206
const OID_802_3_XMIT_LATE_COLLISIONS = &h01020207

#if _WIN32_WINNT >= &h0600
	const OID_802_3_ADD_MULTICAST_ADDRESS = &h01010208
	const OID_802_3_DELETE_MULTICAST_ADDRESS = &h01010209
#endif

const OID_802_5_PERMANENT_ADDRESS = &h02010101
const OID_802_5_CURRENT_ADDRESS = &h02010102
const OID_802_5_CURRENT_FUNCTIONAL = &h02010103
const OID_802_5_CURRENT_GROUP = &h02010104
const OID_802_5_LAST_OPEN_STATUS = &h02010105
const OID_802_5_CURRENT_RING_STATUS = &h02010106
const OID_802_5_CURRENT_RING_STATE = &h02010107
const OID_802_5_LINE_ERRORS = &h02020101
const OID_802_5_LOST_FRAMES = &h02020102
const OID_802_5_BURST_ERRORS = &h02020201
const OID_802_5_AC_ERRORS = &h02020202
const OID_802_5_ABORT_DELIMETERS = &h02020203
const OID_802_5_FRAME_COPIED_ERRORS = &h02020204
const OID_802_5_FREQUENCY_ERRORS = &h02020205
const OID_802_5_TOKEN_ERRORS = &h02020206
const OID_802_5_INTERNAL_ERRORS = &h02020207
const OID_FDDI_LONG_PERMANENT_ADDR = &h03010101
const OID_FDDI_LONG_CURRENT_ADDR = &h03010102
const OID_FDDI_LONG_MULTICAST_LIST = &h03010103
const OID_FDDI_LONG_MAX_LIST_SIZE = &h03010104
const OID_FDDI_SHORT_PERMANENT_ADDR = &h03010105
const OID_FDDI_SHORT_CURRENT_ADDR = &h03010106
const OID_FDDI_SHORT_MULTICAST_LIST = &h03010107
const OID_FDDI_SHORT_MAX_LIST_SIZE = &h03010108
const OID_FDDI_ATTACHMENT_TYPE = &h03020101
const OID_FDDI_UPSTREAM_NODE_LONG = &h03020102
const OID_FDDI_DOWNSTREAM_NODE_LONG = &h03020103
const OID_FDDI_FRAME_ERRORS = &h03020104
const OID_FDDI_FRAMES_LOST = &h03020105
const OID_FDDI_RING_MGT_STATE = &h03020106
const OID_FDDI_LCT_FAILURES = &h03020107
const OID_FDDI_LEM_REJECTS = &h03020108
const OID_FDDI_LCONNECTION_STATE = &h03020109
const OID_FDDI_SMT_STATION_ID = &h03030201
const OID_FDDI_SMT_OP_VERSION_ID = &h03030202
const OID_FDDI_SMT_HI_VERSION_ID = &h03030203
const OID_FDDI_SMT_LO_VERSION_ID = &h03030204
const OID_FDDI_SMT_MANUFACTURER_DATA = &h03030205
const OID_FDDI_SMT_USER_DATA = &h03030206
const OID_FDDI_SMT_MIB_VERSION_ID = &h03030207
const OID_FDDI_SMT_MAC_CT = &h03030208
const OID_FDDI_SMT_NON_MASTER_CT = &h03030209
const OID_FDDI_SMT_MASTER_CT = &h0303020a
const OID_FDDI_SMT_AVAILABLE_PATHS = &h0303020b
const OID_FDDI_SMT_CONFIG_CAPABILITIES = &h0303020c
const OID_FDDI_SMT_CONFIG_POLICY = &h0303020d
const OID_FDDI_SMT_CONNECTION_POLICY = &h0303020e
const OID_FDDI_SMT_T_NOTIFY = &h0303020f
const OID_FDDI_SMT_STAT_RPT_POLICY = &h03030210
const OID_FDDI_SMT_TRACE_MAX_EXPIRATION = &h03030211
const OID_FDDI_SMT_PORT_INDEXES = &h03030212
const OID_FDDI_SMT_MAC_INDEXES = &h03030213
const OID_FDDI_SMT_BYPASS_PRESENT = &h03030214
const OID_FDDI_SMT_ECM_STATE = &h03030215
const OID_FDDI_SMT_CF_STATE = &h03030216
const OID_FDDI_SMT_HOLD_STATE = &h03030217
const OID_FDDI_SMT_REMOTE_DISCONNECT_FLAG = &h03030218
const OID_FDDI_SMT_STATION_STATUS = &h03030219
const OID_FDDI_SMT_PEER_WRAP_FLAG = &h0303021a
const OID_FDDI_SMT_MSG_TIME_STAMP = &h0303021b
const OID_FDDI_SMT_TRANSITION_TIME_STAMP = &h0303021c
const OID_FDDI_SMT_SET_COUNT = &h0303021d
const OID_FDDI_SMT_LAST_SET_STATION_ID = &h0303021e
const OID_FDDI_MAC_FRAME_STATUS_FUNCTIONS = &h0303021f
const OID_FDDI_MAC_BRIDGE_FUNCTIONS = &h03030220
const OID_FDDI_MAC_T_MAX_CAPABILITY = &h03030221
const OID_FDDI_MAC_TVX_CAPABILITY = &h03030222
const OID_FDDI_MAC_AVAILABLE_PATHS = &h03030223
const OID_FDDI_MAC_CURRENT_PATH = &h03030224
const OID_FDDI_MAC_UPSTREAM_NBR = &h03030225
const OID_FDDI_MAC_DOWNSTREAM_NBR = &h03030226
const OID_FDDI_MAC_OLD_UPSTREAM_NBR = &h03030227
const OID_FDDI_MAC_OLD_DOWNSTREAM_NBR = &h03030228
const OID_FDDI_MAC_DUP_ADDRESS_TEST = &h03030229
const OID_FDDI_MAC_REQUESTED_PATHS = &h0303022a
const OID_FDDI_MAC_DOWNSTREAM_PORT_TYPE = &h0303022b
const OID_FDDI_MAC_INDEX = &h0303022c
const OID_FDDI_MAC_SMT_ADDRESS = &h0303022d
const OID_FDDI_MAC_LONG_GRP_ADDRESS = &h0303022e
const OID_FDDI_MAC_SHORT_GRP_ADDRESS = &h0303022f
const OID_FDDI_MAC_T_REQ = &h03030230
const OID_FDDI_MAC_T_NEG = &h03030231
const OID_FDDI_MAC_T_MAX = &h03030232
const OID_FDDI_MAC_TVX_VALUE = &h03030233
const OID_FDDI_MAC_T_PRI0 = &h03030234
const OID_FDDI_MAC_T_PRI1 = &h03030235
const OID_FDDI_MAC_T_PRI2 = &h03030236
const OID_FDDI_MAC_T_PRI3 = &h03030237
const OID_FDDI_MAC_T_PRI4 = &h03030238
const OID_FDDI_MAC_T_PRI5 = &h03030239
const OID_FDDI_MAC_T_PRI6 = &h0303023a
const OID_FDDI_MAC_FRAME_CT = &h0303023b
const OID_FDDI_MAC_COPIED_CT = &h0303023c
const OID_FDDI_MAC_TRANSMIT_CT = &h0303023d
const OID_FDDI_MAC_TOKEN_CT = &h0303023e
const OID_FDDI_MAC_ERROR_CT = &h0303023f
const OID_FDDI_MAC_LOST_CT = &h03030240
const OID_FDDI_MAC_TVX_EXPIRED_CT = &h03030241
const OID_FDDI_MAC_NOT_COPIED_CT = &h03030242
const OID_FDDI_MAC_LATE_CT = &h03030243
const OID_FDDI_MAC_RING_OP_CT = &h03030244
const OID_FDDI_MAC_FRAME_ERROR_THRESHOLD = &h03030245
const OID_FDDI_MAC_FRAME_ERROR_RATIO = &h03030246
const OID_FDDI_MAC_NOT_COPIED_THRESHOLD = &h03030247
const OID_FDDI_MAC_NOT_COPIED_RATIO = &h03030248
const OID_FDDI_MAC_RMT_STATE = &h03030249
const OID_FDDI_MAC_DA_FLAG = &h0303024a
const OID_FDDI_MAC_UNDA_FLAG = &h0303024b
const OID_FDDI_MAC_FRAME_ERROR_FLAG = &h0303024c
const OID_FDDI_MAC_NOT_COPIED_FLAG = &h0303024d
const OID_FDDI_MAC_MA_UNITDATA_AVAILABLE = &h0303024e
const OID_FDDI_MAC_HARDWARE_PRESENT = &h0303024f
const OID_FDDI_MAC_MA_UNITDATA_ENABLE = &h03030250
const OID_FDDI_PATH_INDEX = &h03030251
const OID_FDDI_PATH_RING_LATENCY = &h03030252
const OID_FDDI_PATH_TRACE_STATUS = &h03030253
const OID_FDDI_PATH_SBA_PAYLOAD = &h03030254
const OID_FDDI_PATH_SBA_OVERHEAD = &h03030255
const OID_FDDI_PATH_CONFIGURATION = &h03030256
const OID_FDDI_PATH_T_R_MODE = &h03030257
const OID_FDDI_PATH_SBA_AVAILABLE = &h03030258
const OID_FDDI_PATH_TVX_LOWER_BOUND = &h03030259
const OID_FDDI_PATH_T_MAX_LOWER_BOUND = &h0303025a
const OID_FDDI_PATH_MAX_T_REQ = &h0303025b
const OID_FDDI_PORT_MY_TYPE = &h0303025c
const OID_FDDI_PORT_NEIGHBOR_TYPE = &h0303025d
const OID_FDDI_PORT_CONNECTION_POLICIES = &h0303025e
const OID_FDDI_PORT_MAC_INDICATED = &h0303025f
const OID_FDDI_PORT_CURRENT_PATH = &h03030260
const OID_FDDI_PORT_REQUESTED_PATHS = &h03030261
const OID_FDDI_PORT_MAC_PLACEMENT = &h03030262
const OID_FDDI_PORT_AVAILABLE_PATHS = &h03030263
const OID_FDDI_PORT_MAC_LOOP_TIME = &h03030264
const OID_FDDI_PORT_PMD_CLASS = &h03030265
const OID_FDDI_PORT_CONNECTION_CAPABILITIES = &h03030266
const OID_FDDI_PORT_INDEX = &h03030267
const OID_FDDI_PORT_MAINT_LS = &h03030268
const OID_FDDI_PORT_BS_FLAG = &h03030269
const OID_FDDI_PORT_PC_LS = &h0303026a
const OID_FDDI_PORT_EB_ERROR_CT = &h0303026b
const OID_FDDI_PORT_LCT_FAIL_CT = &h0303026c
const OID_FDDI_PORT_LER_ESTIMATE = &h0303026d
const OID_FDDI_PORT_LEM_REJECT_CT = &h0303026e
const OID_FDDI_PORT_LEM_CT = &h0303026f
const OID_FDDI_PORT_LER_CUTOFF = &h03030270
const OID_FDDI_PORT_LER_ALARM = &h03030271
const OID_FDDI_PORT_CONNNECT_STATE = &h03030272
const OID_FDDI_PORT_PCM_STATE = &h03030273
const OID_FDDI_PORT_PC_WITHHOLD = &h03030274
const OID_FDDI_PORT_LER_FLAG = &h03030275
const OID_FDDI_PORT_HARDWARE_PRESENT = &h03030276
const OID_FDDI_SMT_STATION_ACTION = &h03030277
const OID_FDDI_PORT_ACTION = &h03030278
const OID_FDDI_IF_DESCR = &h03030279
const OID_FDDI_IF_TYPE = &h0303027a
const OID_FDDI_IF_MTU = &h0303027b
const OID_FDDI_IF_SPEED = &h0303027c
const OID_FDDI_IF_PHYS_ADDRESS = &h0303027d
const OID_FDDI_IF_ADMIN_STATUS = &h0303027e
const OID_FDDI_IF_OPER_STATUS = &h0303027f
const OID_FDDI_IF_LAST_CHANGE = &h03030280
const OID_FDDI_IF_IN_OCTETS = &h03030281
const OID_FDDI_IF_IN_UCAST_PKTS = &h03030282
const OID_FDDI_IF_IN_NUCAST_PKTS = &h03030283
const OID_FDDI_IF_IN_DISCARDS = &h03030284
const OID_FDDI_IF_IN_ERRORS = &h03030285
const OID_FDDI_IF_IN_UNKNOWN_PROTOS = &h03030286
const OID_FDDI_IF_OUT_OCTETS = &h03030287
const OID_FDDI_IF_OUT_UCAST_PKTS = &h03030288
const OID_FDDI_IF_OUT_NUCAST_PKTS = &h03030289
const OID_FDDI_IF_OUT_DISCARDS = &h0303028a
const OID_FDDI_IF_OUT_ERRORS = &h0303028b
const OID_FDDI_IF_OUT_QLEN = &h0303028c
const OID_FDDI_IF_SPECIFIC = &h0303028d
const OID_WAN_PERMANENT_ADDRESS = &h04010101
const OID_WAN_CURRENT_ADDRESS = &h04010102
const OID_WAN_QUALITY_OF_SERVICE = &h04010103
const OID_WAN_PROTOCOL_TYPE = &h04010104
const OID_WAN_MEDIUM_SUBTYPE = &h04010105
const OID_WAN_HEADER_FORMAT = &h04010106
const OID_WAN_GET_INFO = &h04010107
const OID_WAN_SET_LINK_INFO = &h04010108
const OID_WAN_GET_LINK_INFO = &h04010109
const OID_WAN_LINE_COUNT = &h0401010a
const OID_WAN_PROTOCOL_CAPS = &h0401010b
const OID_WAN_GET_BRIDGE_INFO = &h0401020a
const OID_WAN_SET_BRIDGE_INFO = &h0401020b
const OID_WAN_GET_COMP_INFO = &h0401020c
const OID_WAN_SET_COMP_INFO = &h0401020d
const OID_WAN_GET_STATS_INFO = &h0401020e
const OID_WAN_CO_GET_INFO = &h04010180
const OID_WAN_CO_SET_LINK_INFO = &h04010181
const OID_WAN_CO_GET_LINK_INFO = &h04010182
const OID_WAN_CO_GET_COMP_INFO = &h04010280
const OID_WAN_CO_SET_COMP_INFO = &h04010281
const OID_WAN_CO_GET_STATS_INFO = &h04010282
const OID_LTALK_CURRENT_NODE_ID = &h05010102
const OID_LTALK_IN_BROADCASTS = &h05020101
const OID_LTALK_IN_LENGTH_ERRORS = &h05020102
const OID_LTALK_OUT_NO_HANDLERS = &h05020201
const OID_LTALK_COLLISIONS = &h05020202
const OID_LTALK_DEFERS = &h05020203
const OID_LTALK_NO_DATA_ERRORS = &h05020204
const OID_LTALK_RANDOM_CTS_ERRORS = &h05020205
const OID_LTALK_FCS_ERRORS = &h05020206
const OID_ARCNET_PERMANENT_ADDRESS = &h06010101
const OID_ARCNET_CURRENT_ADDRESS = &h06010102
const OID_ARCNET_RECONFIGURATIONS = &h06020201
const OID_TAPI_ACCEPT = &h07030101
const OID_TAPI_ANSWER = &h07030102
const OID_TAPI_CLOSE = &h07030103
const OID_TAPI_CLOSE_CALL = &h07030104
const OID_TAPI_CONDITIONAL_MEDIA_DETECTION = &h07030105
const OID_TAPI_CONFIG_DIALOG = &h07030106
const OID_TAPI_DEV_SPECIFIC = &h07030107
const OID_TAPI_DIAL = &h07030108
const OID_TAPI_DROP = &h07030109
const OID_TAPI_GET_ADDRESS_CAPS = &h0703010a
const OID_TAPI_GET_ADDRESS_ID = &h0703010b
const OID_TAPI_GET_ADDRESS_STATUS = &h0703010c
const OID_TAPI_GET_CALL_ADDRESS_ID = &h0703010d
const OID_TAPI_GET_CALL_INFO = &h0703010e
const OID_TAPI_GET_CALL_STATUS = &h0703010f
const OID_TAPI_GET_DEV_CAPS = &h07030110
const OID_TAPI_GET_DEV_CONFIG = &h07030111
const OID_TAPI_GET_EXTENSION_ID = &h07030112
const OID_TAPI_GET_ID = &h07030113
const OID_TAPI_GET_LINE_DEV_STATUS = &h07030114
const OID_TAPI_MAKE_CALL = &h07030115
const OID_TAPI_NEGOTIATE_EXT_VERSION = &h07030116
const OID_TAPI_OPEN = &h07030117
const OID_TAPI_PROVIDER_INITIALIZE = &h07030118
const OID_TAPI_PROVIDER_SHUTDOWN = &h07030119
const OID_TAPI_SECURE_CALL = &h0703011a
const OID_TAPI_SELECT_EXT_VERSION = &h0703011b
const OID_TAPI_SEND_USER_USER_INFO = &h0703011c
const OID_TAPI_SET_APP_SPECIFIC = &h0703011d
const OID_TAPI_SET_CALL_PARAMS = &h0703011e
const OID_TAPI_SET_DEFAULT_MEDIA_DETECTION = &h0703011f
const OID_TAPI_SET_DEV_CONFIG = &h07030120
const OID_TAPI_SET_MEDIA_MODE = &h07030121
const OID_TAPI_SET_STATUS_MESSAGES = &h07030122
const OID_TAPI_GATHER_DIGITS = &h07030123
const OID_TAPI_MONITOR_DIGITS = &h07030124
const OID_ATM_SUPPORTED_VC_RATES = &h08010101
const OID_ATM_SUPPORTED_SERVICE_CATEGORY = &h08010102
const OID_ATM_SUPPORTED_AAL_TYPES = &h08010103
const OID_ATM_HW_CURRENT_ADDRESS = &h08010104
const OID_ATM_MAX_ACTIVE_VCS = &h08010105
const OID_ATM_MAX_ACTIVE_VCI_BITS = &h08010106
const OID_ATM_MAX_ACTIVE_VPI_BITS = &h08010107
const OID_ATM_MAX_AAL0_PACKET_SIZE = &h08010108
const OID_ATM_MAX_AAL1_PACKET_SIZE = &h08010109
const OID_ATM_MAX_AAL34_PACKET_SIZE = &h0801010a
const OID_ATM_MAX_AAL5_PACKET_SIZE = &h0801010b
const OID_ATM_SIGNALING_VPIVCI = &h08010201
const OID_ATM_ASSIGNED_VPI = &h08010202
const OID_ATM_ACQUIRE_ACCESS_NET_RESOURCES = &h08010203
const OID_ATM_RELEASE_ACCESS_NET_RESOURCES = &h08010204
const OID_ATM_ILMI_VPIVCI = &h08010205
const OID_ATM_DIGITAL_BROADCAST_VPIVCI = &h08010206
const OID_ATM_GET_NEAREST_FLOW = &h08010207
const OID_ATM_ALIGNMENT_REQUIRED = &h08010208
const OID_ATM_LECS_ADDRESS = &h08010209
const OID_ATM_SERVICE_ADDRESS = &h0801020a
const OID_ATM_CALL_PROCEEDING = &h0801020b
const OID_ATM_CALL_ALERTING = &h0801020c
const OID_ATM_PARTY_ALERTING = &h0801020d
const OID_ATM_CALL_NOTIFY = &h0801020e
const OID_ATM_MY_IP_NM_ADDRESS = &h0801020f
const OID_ATM_RCV_CELLS_OK = &h08020101
const OID_ATM_XMIT_CELLS_OK = &h08020102
const OID_ATM_RCV_CELLS_DROPPED = &h08020103
const OID_ATM_RCV_INVALID_VPI_VCI = &h08020201
const OID_ATM_CELLS_HEC_ERROR = &h08020202
const OID_ATM_RCV_REASSEMBLY_ERROR = &h08020203
const OID_802_11_BSSID = &h0d010101
const OID_802_11_SSID = &h0d010102
const OID_802_11_NETWORK_TYPES_SUPPORTED = &h0d010203
const OID_802_11_NETWORK_TYPE_IN_USE = &h0d010204
const OID_802_11_TX_POWER_LEVEL = &h0d010205
const OID_802_11_RSSI = &h0d010206
const OID_802_11_RSSI_TRIGGER = &h0d010207
const OID_802_11_INFRASTRUCTURE_MODE = &h0d010108
const OID_802_11_FRAGMENTATION_THRESHOLD = &h0d010209
const OID_802_11_RTS_THRESHOLD = &h0d01020a
const OID_802_11_NUMBER_OF_ANTENNAS = &h0d01020b
const OID_802_11_RX_ANTENNA_SELECTED = &h0d01020c
const OID_802_11_TX_ANTENNA_SELECTED = &h0d01020d
const OID_802_11_SUPPORTED_RATES = &h0d01020e
const OID_802_11_DESIRED_RATES = &h0d010210
const OID_802_11_CONFIGURATION = &h0d010211
const OID_802_11_STATISTICS = &h0d020212
const OID_802_11_ADD_WEP = &h0d010113
const OID_802_11_REMOVE_WEP = &h0d010114
const OID_802_11_DISASSOCIATE = &h0d010115
const OID_802_11_POWER_MODE = &h0d010216
const OID_802_11_BSSID_LIST = &h0d010217
const OID_802_11_AUTHENTICATION_MODE = &h0d010118
const OID_802_11_PRIVACY_FILTER = &h0d010119
const OID_802_11_BSSID_LIST_SCAN = &h0d01011a
const OID_802_11_WEP_STATUS = &h0d01011b
const OID_802_11_ENCRYPTION_STATUS = OID_802_11_WEP_STATUS
const OID_802_11_RELOAD_DEFAULTS = &h0d01011c
const OID_802_11_ADD_KEY = &h0d01011d
const OID_802_11_REMOVE_KEY = &h0d01011e
const OID_802_11_ASSOCIATION_INFORMATION = &h0d01011f
const OID_802_11_TEST = &h0d010120
const OID_802_11_MEDIA_STREAM_MODE = &h0d010121
const OID_802_11_CAPABILITY = &h0d010122
const OID_802_11_PMKID = &h0d010123
const OID_802_11_NON_BCAST_SSID_LIST = &h0d010124
const OID_802_11_RADIO_STATUS = &h0d010125
const NDIS_ETH_TYPE_IPV4 = &h0800
const NDIS_ETH_TYPE_ARP = &h0806
const NDIS_ETH_TYPE_IPV6 = &h86dd
const NDIS_ETH_TYPE_802_1X = &h888e
const NDIS_ETH_TYPE_802_1Q = &h8100
const NDIS_ETH_TYPE_SLOW_PROTOCOL = &h8809
const NDIS_802_11_LENGTH_SSID = 32
const NDIS_802_11_LENGTH_RATES = 8
const NDIS_802_11_LENGTH_RATES_EX = 16
const NDIS_802_11_AUTH_REQUEST_REAUTH = &h01
const NDIS_802_11_AUTH_REQUEST_KEYUPDATE = &h02
const NDIS_802_11_AUTH_REQUEST_PAIRWISE_ERROR = &h06
const NDIS_802_11_AUTH_REQUEST_GROUP_ERROR = &h0e
const NDIS_802_11_AUTH_REQUEST_AUTH_FIELDS = &h0f
const NDIS_802_11_PMKID_CANDIDATE_PREAUTH_ENABLED = &h01
const NDIS_802_11_AI_REQFI_CAPABILITIES = 1
const NDIS_802_11_AI_REQFI_LISTENINTERVAL = 2
const NDIS_802_11_AI_REQFI_CURRENTAPADDRESS = 4
const NDIS_802_11_AI_RESFI_CAPABILITIES = 1
const NDIS_802_11_AI_RESFI_STATUSCODE = 2
const NDIS_802_11_AI_RESFI_ASSOCIATIONID = 4

type _NDIS_802_11_STATUS_TYPE as long
enum
	Ndis802_11StatusType_Authentication
	Ndis802_11StatusType_MediaStreamMode
	Ndis802_11StatusType_PMKID_CandidateList
	Ndis802_11StatusTypeMax
end enum

type NDIS_802_11_STATUS_TYPE as _NDIS_802_11_STATUS_TYPE
type PNDIS_802_11_STATUS_TYPE as _NDIS_802_11_STATUS_TYPE ptr

type _NDIS_802_11_STATUS_INDICATION
	StatusType as NDIS_802_11_STATUS_TYPE
end type

type NDIS_802_11_STATUS_INDICATION as _NDIS_802_11_STATUS_INDICATION
type PNDIS_802_11_STATUS_INDICATION as _NDIS_802_11_STATUS_INDICATION ptr

type _NDIS_802_11_AUTHENTICATION_REQUEST
	Length as ULONG
	Bssid(0 to 5) as UCHAR
	Flags as ULONG
end type

type NDIS_802_11_AUTHENTICATION_REQUEST as _NDIS_802_11_AUTHENTICATION_REQUEST
type PNDIS_802_11_AUTHENTICATION_REQUEST as _NDIS_802_11_AUTHENTICATION_REQUEST ptr

type _PMKID_CANDIDATE
	BSSID(0 to 5) as UCHAR
	Flags as ULONG
end type

type PMKID_CANDIDATE as _PMKID_CANDIDATE
type PPMKID_CANDIDATE as _PMKID_CANDIDATE ptr

type _NDIS_802_11_PMKID_CANDIDATE_LIST
	Version as ULONG
	NumCandidates as ULONG
	CandidateList(0 to 0) as PMKID_CANDIDATE
end type

type NDIS_802_11_PMKID_CANDIDATE_LIST as _NDIS_802_11_PMKID_CANDIDATE_LIST
type PNDIS_802_11_PMKID_CANDIDATE_LIST as _NDIS_802_11_PMKID_CANDIDATE_LIST ptr

type _NDIS_802_11_NETWORK_TYPE as long
enum
	Ndis802_11FH
	Ndis802_11DS
	Ndis802_11OFDM5
	Ndis802_11OFDM24
	Ndis802_11Automode
	Ndis802_11NetworkTypeMax
end enum

type NDIS_802_11_NETWORK_TYPE as _NDIS_802_11_NETWORK_TYPE
type PNDIS_802_11_NETWORK_TYPE as _NDIS_802_11_NETWORK_TYPE ptr

type _NDIS_802_11_NETWORK_TYPE_LIST
	NumberOfItems as ULONG
	NetworkType(0 to 0) as NDIS_802_11_NETWORK_TYPE
end type

type NDIS_802_11_NETWORK_TYPE_LIST as _NDIS_802_11_NETWORK_TYPE_LIST
type PNDIS_802_11_NETWORK_TYPE_LIST as _NDIS_802_11_NETWORK_TYPE_LIST ptr

type _NDIS_802_11_POWER_MODE as long
enum
	Ndis802_11PowerModeCAM
	Ndis802_11PowerModeMAX_PSP
	Ndis802_11PowerModeFast_PSP
	Ndis802_11PowerModeMax
end enum

type NDIS_802_11_POWER_MODE as _NDIS_802_11_POWER_MODE
type PNDIS_802_11_POWER_MODE as _NDIS_802_11_POWER_MODE ptr
type NDIS_802_11_TX_POWER_LEVEL as ULONG
type NDIS_802_11_RSSI as LONG

type _NDIS_802_11_CONFIGURATION_FH
	Length as ULONG
	HopPattern as ULONG
	HopSet as ULONG
	DwellTime as ULONG
end type

type NDIS_802_11_CONFIGURATION_FH as _NDIS_802_11_CONFIGURATION_FH
type PNDIS_802_11_CONFIGURATION_FH as _NDIS_802_11_CONFIGURATION_FH ptr

type _NDIS_802_11_CONFIGURATION
	Length as ULONG
	BeaconPeriod as ULONG
	ATIMWindow as ULONG
	DSConfig as ULONG
	FHConfig as NDIS_802_11_CONFIGURATION_FH
end type

type NDIS_802_11_CONFIGURATION as _NDIS_802_11_CONFIGURATION
type PNDIS_802_11_CONFIGURATION as _NDIS_802_11_CONFIGURATION ptr

type _NDIS_802_11_STATISTICS
	Length as ULONG
	TransmittedFragmentCount as LARGE_INTEGER
	MulticastTransmittedFrameCount as LARGE_INTEGER
	FailedCount as LARGE_INTEGER
	RetryCount as LARGE_INTEGER
	MultipleRetryCount as LARGE_INTEGER
	RTSSuccessCount as LARGE_INTEGER
	RTSFailureCount as LARGE_INTEGER
	ACKFailureCount as LARGE_INTEGER
	FrameDuplicateCount as LARGE_INTEGER
	ReceivedFragmentCount as LARGE_INTEGER
	MulticastReceivedFrameCount as LARGE_INTEGER
	FCSErrorCount as LARGE_INTEGER
	TKIPLocalMICFailures as LARGE_INTEGER
	TKIPICVErrorCount as LARGE_INTEGER
	TKIPCounterMeasuresInvoked as LARGE_INTEGER
	TKIPReplays as LARGE_INTEGER
	CCMPFormatErrors as LARGE_INTEGER
	CCMPReplays as LARGE_INTEGER
	CCMPDecryptErrors as LARGE_INTEGER
	FourWayHandshakeFailures as LARGE_INTEGER
	WEPUndecryptableCount as LARGE_INTEGER
	WEPICVErrorCount as LARGE_INTEGER
	DecryptSuccessCount as LARGE_INTEGER
	DecryptFailureCount as LARGE_INTEGER
end type

type NDIS_802_11_STATISTICS as _NDIS_802_11_STATISTICS
type PNDIS_802_11_STATISTICS as _NDIS_802_11_STATISTICS ptr
type NDIS_802_11_KEY_INDEX as ULONG
type NDIS_802_11_KEY_RSC as ULONGLONG

type _NDIS_802_11_KEY
	Length as ULONG
	KeyIndex as ULONG
	KeyLength as ULONG
	BSSID(0 to 5) as UCHAR
	KeyRSC as NDIS_802_11_KEY_RSC
	KeyMaterial(0 to 0) as UCHAR
end type

type NDIS_802_11_KEY as _NDIS_802_11_KEY
type PNDIS_802_11_KEY as _NDIS_802_11_KEY ptr

type _NDIS_802_11_REMOVE_KEY
	Length as ULONG
	KeyIndex as ULONG
	BSSID(0 to 5) as UCHAR
end type

type NDIS_802_11_REMOVE_KEY as _NDIS_802_11_REMOVE_KEY
type PNDIS_802_11_REMOVE_KEY as _NDIS_802_11_REMOVE_KEY ptr

type _NDIS_802_11_WEP
	Length as ULONG
	KeyIndex as ULONG
	KeyLength as ULONG
	KeyMaterial(0 to 0) as UCHAR
end type

type NDIS_802_11_WEP as _NDIS_802_11_WEP
type PNDIS_802_11_WEP as _NDIS_802_11_WEP ptr

type _NDIS_802_11_NETWORK_INFRASTRUCTURE as long
enum
	Ndis802_11IBSS
	Ndis802_11Infrastructure
	Ndis802_11AutoUnknown
	Ndis802_11InfrastructureMax
end enum

type NDIS_802_11_NETWORK_INFRASTRUCTURE as _NDIS_802_11_NETWORK_INFRASTRUCTURE
type PNDIS_802_11_NETWORK_INFRASTRUCTURE as _NDIS_802_11_NETWORK_INFRASTRUCTURE ptr

type _NDIS_802_11_AUTHENTICATION_MODE as long
enum
	Ndis802_11AuthModeOpen
	Ndis802_11AuthModeShared
	Ndis802_11AuthModeAutoSwitch
	Ndis802_11AuthModeWPA
	Ndis802_11AuthModeWPAPSK
	Ndis802_11AuthModeWPANone
	Ndis802_11AuthModeWPA2
	Ndis802_11AuthModeWPA2PSK
	Ndis802_11AuthModeMax
end enum

type NDIS_802_11_AUTHENTICATION_MODE as _NDIS_802_11_AUTHENTICATION_MODE
type PNDIS_802_11_AUTHENTICATION_MODE as _NDIS_802_11_AUTHENTICATION_MODE ptr

type _NDIS_802_11_SSID
	SsidLength as ULONG
	Ssid(0 to 31) as UCHAR
end type

type NDIS_802_11_SSID as _NDIS_802_11_SSID
type PNDIS_802_11_SSID as _NDIS_802_11_SSID ptr

type _NDIS_WLAN_BSSID
	Length as ULONG
	MacAddress(0 to 5) as UCHAR
	Reserved(0 to 1) as UCHAR
	Ssid as NDIS_802_11_SSID
	Privacy as ULONG
	Rssi as NDIS_802_11_RSSI
	NetworkTypeInUse as NDIS_802_11_NETWORK_TYPE
	Configuration as NDIS_802_11_CONFIGURATION
	InfrastructureMode as NDIS_802_11_NETWORK_INFRASTRUCTURE
	SupportedRates(0 to 7) as UCHAR
end type

type NDIS_WLAN_BSSID as _NDIS_WLAN_BSSID
type PNDIS_WLAN_BSSID as _NDIS_WLAN_BSSID ptr

type _NDIS_802_11_BSSID_LIST
	NumberOfItems as ULONG
	Bssid(0 to 0) as NDIS_WLAN_BSSID
end type

type NDIS_802_11_BSSID_LIST as _NDIS_802_11_BSSID_LIST
type PNDIS_802_11_BSSID_LIST as _NDIS_802_11_BSSID_LIST ptr

type _NDIS_WLAN_BSSID_EX
	Length as ULONG
	MacAddress(0 to 5) as UCHAR
	Reserved(0 to 1) as UCHAR
	Ssid as NDIS_802_11_SSID
	Privacy as ULONG
	Rssi as NDIS_802_11_RSSI
	NetworkTypeInUse as NDIS_802_11_NETWORK_TYPE
	Configuration as NDIS_802_11_CONFIGURATION
	InfrastructureMode as NDIS_802_11_NETWORK_INFRASTRUCTURE
	SupportedRates(0 to 15) as UCHAR
	IELength as ULONG
	IEs(0 to 0) as UCHAR
end type

type NDIS_WLAN_BSSID_EX as _NDIS_WLAN_BSSID_EX
type PNDIS_WLAN_BSSID_EX as _NDIS_WLAN_BSSID_EX ptr

type _NDIS_802_11_BSSID_LIST_EX
	NumberOfItems as ULONG
	Bssid(0 to 0) as NDIS_WLAN_BSSID_EX
end type

type NDIS_802_11_BSSID_LIST_EX as _NDIS_802_11_BSSID_LIST_EX
type PNDIS_802_11_BSSID_LIST_EX as _NDIS_802_11_BSSID_LIST_EX ptr

type _NDIS_802_11_FIXED_IEs
	Timestamp(0 to 7) as UCHAR
	BeaconInterval as USHORT
	Capabilities as USHORT
end type

type NDIS_802_11_FIXED_IEs as _NDIS_802_11_FIXED_IEs
type PNDIS_802_11_FIXED_IEs as _NDIS_802_11_FIXED_IEs ptr

type _NDIS_802_11_VARIABLE_IEs
	ElementID as UCHAR
	Length as UCHAR
	data(0 to 0) as UCHAR
end type

type NDIS_802_11_VARIABLE_IEs as _NDIS_802_11_VARIABLE_IEs
type PNDIS_802_11_VARIABLE_IEs as _NDIS_802_11_VARIABLE_IEs ptr
type NDIS_802_11_FRAGMENTATION_THRESHOLD as ULONG
type NDIS_802_11_RTS_THRESHOLD as ULONG
type NDIS_802_11_ANTENNA as ULONG

type _NDIS_802_11_PRIVACY_FILTER as long
enum
	Ndis802_11PrivFilterAcceptAll
	Ndis802_11PrivFilter8021xWEP
end enum

type NDIS_802_11_PRIVACY_FILTER as _NDIS_802_11_PRIVACY_FILTER
type PNDIS_802_11_PRIVACY_FILTER as _NDIS_802_11_PRIVACY_FILTER ptr

type _NDIS_802_11_WEP_STATUS as long
enum
	Ndis802_11WEPEnabled
	Ndis802_11Encryption1Enabled = Ndis802_11WEPEnabled
	Ndis802_11WEPDisabled
	Ndis802_11EncryptionDisabled = Ndis802_11WEPDisabled
	Ndis802_11WEPKeyAbsent
	Ndis802_11Encryption1KeyAbsent = Ndis802_11WEPKeyAbsent
	Ndis802_11WEPNotSupported
	Ndis802_11EncryptionNotSupported = Ndis802_11WEPNotSupported
	Ndis802_11Encryption2Enabled
	Ndis802_11Encryption2KeyAbsent
	Ndis802_11Encryption3Enabled
	Ndis802_11Encryption3KeyAbsent
end enum

type NDIS_802_11_WEP_STATUS as _NDIS_802_11_WEP_STATUS
type PNDIS_802_11_WEP_STATUS as _NDIS_802_11_WEP_STATUS ptr
type NDIS_802_11_ENCRYPTION_STATUS as _NDIS_802_11_WEP_STATUS
type PNDIS_802_11_ENCRYPTION_STATUS as _NDIS_802_11_WEP_STATUS ptr

type _NDIS_802_11_RELOAD_DEFAULTS as long
enum
	Ndis802_11ReloadWEPKeys
end enum

type NDIS_802_11_RELOAD_DEFAULTS as _NDIS_802_11_RELOAD_DEFAULTS
type PNDIS_802_11_RELOAD_DEFAULTS as _NDIS_802_11_RELOAD_DEFAULTS ptr

type _NDIS_802_11_AI_REQFI
	Capabilities as USHORT
	ListenInterval as USHORT
	CurrentAPAddress(0 to 5) as UCHAR
end type

type NDIS_802_11_AI_REQFI as _NDIS_802_11_AI_REQFI
type PNDIS_802_11_AI_REQFI as _NDIS_802_11_AI_REQFI ptr

type _NDIS_802_11_AI_RESFI
	Capabilities as USHORT
	StatusCode as USHORT
	AssociationId as USHORT
end type

type NDIS_802_11_AI_RESFI as _NDIS_802_11_AI_RESFI
type PNDIS_802_11_AI_RESFI as _NDIS_802_11_AI_RESFI ptr

type _NDIS_802_11_ASSOCIATION_INFORMATION
	Length as ULONG
	AvailableRequestFixedIEs as USHORT
	RequestFixedIEs as NDIS_802_11_AI_REQFI
	RequestIELength as ULONG
	OffsetRequestIEs as ULONG
	AvailableResponseFixedIEs as USHORT
	ResponseFixedIEs as NDIS_802_11_AI_RESFI
	ResponseIELength as ULONG
	OffsetResponseIEs as ULONG
end type

type NDIS_802_11_ASSOCIATION_INFORMATION as _NDIS_802_11_ASSOCIATION_INFORMATION
type PNDIS_802_11_ASSOCIATION_INFORMATION as _NDIS_802_11_ASSOCIATION_INFORMATION ptr

type _NDIS_802_11_AUTHENTICATION_EVENT
	Status as NDIS_802_11_STATUS_INDICATION
	Request(0 to 0) as NDIS_802_11_AUTHENTICATION_REQUEST
end type

type NDIS_802_11_AUTHENTICATION_EVENT as _NDIS_802_11_AUTHENTICATION_EVENT
type PNDIS_802_11_AUTHENTICATION_EVENT as _NDIS_802_11_AUTHENTICATION_EVENT ptr

type _NDIS_802_11_TEST
	Length as ULONG
	as ULONG Type

	union
		AuthenticationEvent as NDIS_802_11_AUTHENTICATION_EVENT
		RssiTrigger as NDIS_802_11_RSSI
	end union
end type

type NDIS_802_11_TEST as _NDIS_802_11_TEST
type PNDIS_802_11_TEST as _NDIS_802_11_TEST ptr

type _NDIS_802_11_MEDIA_STREAM_MODE as long
enum
	Ndis802_11MediaStreamOff
	Ndis802_11MediaStreamOn
end enum

type NDIS_802_11_MEDIA_STREAM_MODE as _NDIS_802_11_MEDIA_STREAM_MODE
type PNDIS_802_11_MEDIA_STREAM_MODE as _NDIS_802_11_MEDIA_STREAM_MODE ptr

type _BSSID_INFO
	BSSID(0 to 5) as UCHAR
	PMKID(0 to 15) as UCHAR
end type

type BSSID_INFO as _BSSID_INFO
type PBSSID_INFO as _BSSID_INFO ptr

type _NDIS_802_11_PMKID
	Length as ULONG
	BSSIDInfoCount as ULONG
	BSSIDInfo(0 to 0) as BSSID_INFO
end type

type NDIS_802_11_PMKID as _NDIS_802_11_PMKID
type PNDIS_802_11_PMKID as _NDIS_802_11_PMKID ptr

type _NDIS_802_11_AUTHENTICATION_ENCRYPTION
	AuthModeSupported as NDIS_802_11_AUTHENTICATION_MODE
	EncryptStatusSupported as NDIS_802_11_ENCRYPTION_STATUS
end type

type NDIS_802_11_AUTHENTICATION_ENCRYPTION as _NDIS_802_11_AUTHENTICATION_ENCRYPTION
type PNDIS_802_11_AUTHENTICATION_ENCRYPTION as _NDIS_802_11_AUTHENTICATION_ENCRYPTION ptr

type _NDIS_802_11_CAPABILITY
	Length as ULONG
	Version as ULONG
	NoOfPMKIDs as ULONG
	NoOfAuthEncryptPairsSupported as ULONG
	AuthenticationEncryptionSupported(0 to 0) as NDIS_802_11_AUTHENTICATION_ENCRYPTION
end type

type NDIS_802_11_CAPABILITY as _NDIS_802_11_CAPABILITY
type PNDIS_802_11_CAPABILITY as _NDIS_802_11_CAPABILITY ptr

type _NDIS_802_11_NON_BCAST_SSID_LIST
	NumberOfItems as ULONG
	Non_Bcast_Ssid(0 to 0) as NDIS_802_11_SSID
end type

type NDIS_802_11_NON_BCAST_SSID_LIST as _NDIS_802_11_NON_BCAST_SSID_LIST
type PNDIS_802_11_NON_BCAST_SSID_LIST as _NDIS_802_11_NON_BCAST_SSID_LIST ptr

type _NDIS_802_11_RADIO_STATUS as long
enum
	Ndis802_11RadioStatusOn
	Ndis802_11RadioStatusHardwareOff
	Ndis802_11RadioStatusSoftwareOff
	Ndis802_11RadioStatusHardwareSoftwareOff
	Ndis802_11RadioStatusMax
end enum

type NDIS_802_11_RADIO_STATUS as _NDIS_802_11_RADIO_STATUS
type PNDIS_802_11_RADIO_STATUS as _NDIS_802_11_RADIO_STATUS ptr
const OID_IRDA_RECEIVING = &h0a010100
const OID_IRDA_TURNAROUND_TIME = &h0a010101
const OID_IRDA_SUPPORTED_SPEEDS = &h0a010102
const OID_IRDA_LINK_SPEED = &h0a010103
const OID_IRDA_MEDIA_BUSY = &h0a010104
const OID_IRDA_EXTRA_RCV_BOFS = &h0a010200
const OID_IRDA_RATE_SNIFF = &h0a010201
const OID_IRDA_UNICAST_LIST = &h0a010202
const OID_IRDA_MAX_UNICAST_LIST_SIZE = &h0a010203
const OID_IRDA_MAX_RECEIVE_WINDOW_SIZE = &h0a010204
const OID_IRDA_MAX_SEND_WINDOW_SIZE = &h0a010205
const OID_IRDA_RESERVED1 = &h0a01020a
const OID_IRDA_RESERVED2 = &h0a01020f
const OID_1394_LOCAL_NODE_INFO = &h0c010101
const OID_1394_VC_INFO = &h0c010102
const OID_CO_ADD_PVC = &hfe000001
const OID_CO_DELETE_PVC = &hfe000002
const OID_CO_GET_CALL_INFORMATION = &hfe000003
const OID_CO_ADD_ADDRESS = &hfe000004
const OID_CO_DELETE_ADDRESS = &hfe000005
const OID_CO_GET_ADDRESSES = &hfe000006
const OID_CO_ADDRESS_CHANGE = &hfe000007
const OID_CO_SIGNALING_ENABLED = &hfe000008
const OID_CO_SIGNALING_DISABLED = &hfe000009
const OID_CO_AF_CLOSE = &hfe00000a
const OID_CO_TAPI_CM_CAPS = &hfe001001
const OID_CO_TAPI_LINE_CAPS = &hfe001002
const OID_CO_TAPI_ADDRESS_CAPS = &hfe001003
const OID_CO_TAPI_TRANSLATE_TAPI_CALLPARAMS = &hfe001004
const OID_CO_TAPI_TRANSLATE_NDIS_CALLPARAMS = &hfe001005
const OID_CO_TAPI_TRANSLATE_TAPI_SAP = &hfe001006
const OID_CO_TAPI_GET_CALL_DIAGNOSTICS = &hfe001007
const OID_CO_TAPI_REPORT_DIGITS = &hfe001008
const OID_CO_TAPI_DONT_REPORT_DIGITS = &hfe001009
const OID_PNP_CAPABILITIES = &hfd010100
const OID_PNP_SET_POWER = &hfd010101
const OID_PNP_QUERY_POWER = &hfd010102
const OID_PNP_ADD_WAKE_UP_PATTERN = &hfd010103
const OID_PNP_REMOVE_WAKE_UP_PATTERN = &hfd010104
const OID_PNP_WAKE_UP_PATTERN_LIST = &hfd010105
const OID_PNP_ENABLE_WAKE_UP = &hfd010106
const OID_PNP_WAKE_UP_OK = &hfd020200
const OID_PNP_WAKE_UP_ERROR = &hfd020201

#if _WIN32_WINNT >= &h0601
	const OID_PM_CURRENT_CAPABILITIES = &hfd010107
	const OID_PM_HARDWARE_CAPABILITIES = &hfd010108
	const OID_PM_PARAMETERS = &hfd010109
	const OID_PM_ADD_WOL_PATTERN = &hfd01010a
	const OID_PM_REMOVE_WOL_PATTERN = &hfd01010b
	const OID_PM_WOL_PATTERN_LIST = &hfd01010c
	const OID_PM_ADD_PROTOCOL_OFFLOAD = &hfd01010d
	const OID_PM_GET_PROTOCOL_OFFLOAD = &hfd01010e
	const OID_PM_REMOVE_PROTOCOL_OFFLOAD = &hfd01010f
	const OID_PM_PROTOCOL_OFFLOAD_LIST = &hfd010110
	const OID_PM_RESERVED_1 = &hfd010111
	const OID_RECEIVE_FILTER_HARDWARE_CAPABILITIES = &h00010221
	const OID_RECEIVE_FILTER_GLOBAL_PARAMETERS = &h00010222
	const OID_RECEIVE_FILTER_ALLOCATE_QUEUE = &h00010223
	const OID_RECEIVE_FILTER_FREE_QUEUE = &h00010224
	const OID_RECEIVE_FILTER_ENUM_QUEUES = &h00010225
	const OID_RECEIVE_FILTER_QUEUE_PARAMETERS = &h00010226
	const OID_RECEIVE_FILTER_SET_FILTER = &h00010227
	const OID_RECEIVE_FILTER_CLEAR_FILTER = &h00010228
	const OID_RECEIVE_FILTER_ENUM_FILTERS = &h00010229
	const OID_RECEIVE_FILTER_PARAMETERS = &h0001022a
	const OID_RECEIVE_FILTER_QUEUE_ALLOCATION_COMPLETE = &h0001022b
	const OID_RECEIVE_FILTER_CURRENT_CAPABILITIES = &h0001022d
	const OID_NIC_SWITCH_HARDWARE_CAPABILITIES = &h0001022e
	const OID_NIC_SWITCH_CURRENT_CAPABILITIES = &h0001022f
	const OID_VLAN_RESERVED1 = &h00010231
	const OID_VLAN_RESERVED2 = &h00010232
	const OID_VLAN_RESERVED3 = &h00010233
	const OID_VLAN_RESERVED4 = &h00010234
#endif

#if _WIN32_WINNT = &h0602
	const OID_NIC_SWITCH_CREATE_SWITCH = &h00010237
	const OID_NIC_SWITCH_PARAMETERS = &h00010238
	const OID_NIC_SWITCH_DELETE_SWITCH = &h00010239
	const OID_NIC_SWITCH_ENUM_SWITCHES = &h00010240
	const OID_NIC_SWITCH_CREATE_VPORT = &h00010241
	const OID_NIC_SWITCH_VPORT_PARAMETERS = &h00010242
	const OID_NIC_SWITCH_ENUM_VPORTS = &h00010243
	const OID_NIC_SWITCH_DELETE_VPORT = &h00010244
	const OID_NIC_SWITCH_ALLOCATE_VF = &h00010245
	const OID_NIC_SWITCH_FREE_VF = &h00010246
	const OID_NIC_SWITCH_VF_PARAMETERS = &h00010247
	const OID_NIC_SWITCH_ENUM_VFS = &h00010248
	const OID_SRIOV_HARDWARE_CAPABILITIES = &h00010249
	const OID_SRIOV_CURRENT_CAPABILITIES = &h00010250
	const OID_SRIOV_READ_VF_CONFIG_SPACE = &h00010251
	const OID_SRIOV_WRITE_VF_CONFIG_SPACE = &h00010252
	const OID_SRIOV_READ_VF_CONFIG_BLOCK = &h00010253
	const OID_SRIOV_WRITE_VF_CONFIG_BLOCK = &h00010254
	const OID_SRIOV_RESET_VF = &h00010255
	const OID_SRIOV_SET_VF_POWER_STATE = &h00010256
	const OID_SRIOV_VF_VENDOR_DEVICE_ID = &h00010257
	const OID_SRIOV_PROBED_BARS = &h00010258
	const OID_SRIOV_BAR_RESOURCES = &h00010259
	const OID_SRIOV_PF_LUID = &h00010260
	const OID_SRIOV_CONFIG_STATE = &h00010261
	const OID_SRIOV_VF_SERIAL_NUMBER = &h00010262
	const OID_SRIOV_VF_INVALIDATE_CONFIG_BLOCK = &h00010269
	const OID_SWITCH_PROPERTY_ADD = &h00010263
	const OID_SWITCH_PROPERTY_UPDATE = &h00010264
	const OID_SWITCH_PROPERTY_DELETE = &h00010265
	const OID_SWITCH_PROPERTY_ENUM = &h00010266
	const OID_SWITCH_FEATURE_STATUS_QUERY = &h00010267
	const OID_SWITCH_NIC_REQUEST = &h00010270
	const OID_SWITCH_PORT_PROPERTY_ADD = &h00010271
	const OID_SWITCH_PORT_PROPERTY_UPDATE = &h00010272
	const OID_SWITCH_PORT_PROPERTY_DELETE = &h00010273
	const OID_SWITCH_PORT_PROPERTY_ENUM = &h00010274
	const OID_SWITCH_PARAMETERS = &h00010275
	const OID_SWITCH_PORT_ARRAY = &h00010276
	const OID_SWITCH_NIC_ARRAY = &h00010277
	const OID_SWITCH_PORT_CREATE = &h00010278
	const OID_SWITCH_PORT_DELETE = &h00010279
	const OID_SWITCH_NIC_CREATE = &h0001027a
	const OID_SWITCH_NIC_CONNECT = &h0001027b
	const OID_SWITCH_NIC_DISCONNECT = &h0001027c
	const OID_SWITCH_NIC_DELETE = &h0001027d
	const OID_SWITCH_PORT_FEATURE_STATUS_QUERY = &h0001027e
	const OID_SWITCH_PORT_TEARDOWN = &h0001027f
	const OID_SWITCH_NIC_SAVE = &h00010290
	const OID_SWITCH_NIC_SAVE_COMPLETE = &h00010291
	const OID_SWITCH_NIC_RESTORE = &h00010292
	const OID_SWITCH_NIC_RESTORE_COMPLETE = &h00010293
	const OID_SWITCH_NIC_UPDATED = &h00010294
	const OID_SWITCH_PORT_UPDATED = &h00010295
#endif

const NDIS_PNP_WAKE_UP_MAGIC_PACKET = &h00000001
const NDIS_PNP_WAKE_UP_PATTERN_MATCH = &h00000002
const NDIS_PNP_WAKE_UP_LINK_CHANGE = &h00000004
const OID_TCP_TASK_OFFLOAD = &hfc010201
const OID_TCP_TASK_IPSEC_ADD_SA = &hfc010202
const OID_TCP_TASK_IPSEC_DELETE_SA = &hfc010203
const OID_TCP_SAN_SUPPORT = &hfc010204
const OID_TCP_TASK_IPSEC_ADD_UDPESP_SA = &hfc010205
const OID_TCP_TASK_IPSEC_DELETE_UDPESP_SA = &hfc010206
const OID_TCP4_OFFLOAD_STATS = &hfc010207
const OID_TCP6_OFFLOAD_STATS = &hfc010208
const OID_IP4_OFFLOAD_STATS = &hfc010209
const OID_IP6_OFFLOAD_STATS = &hfc01020a
const OID_TCP_OFFLOAD_CURRENT_CONFIG = &hfc01020b
const OID_TCP_OFFLOAD_PARAMETERS = &hfc01020c
const OID_TCP_OFFLOAD_HARDWARE_CAPABILITIES = &hfc01020d
const OID_TCP_CONNECTION_OFFLOAD_CURRENT_CONFIG = &hfc01020e
const OID_TCP_CONNECTION_OFFLOAD_HARDWARE_CAPABILITIES = &hfc01020f
const OID_OFFLOAD_ENCAPSULATION = &h0101010a
const OID_FFP_SUPPORT = &hfc010210
const OID_FFP_FLUSH = &hfc010211
const OID_FFP_CONTROL = &hfc010212
const OID_FFP_PARAMS = &hfc010213
const OID_FFP_DATA = &hfc010214
const OID_FFP_DRIVER_STATS = &hfc020210
const OID_FFP_ADAPTER_STATS = &hfc020211
const OID_TCP_CONNECTION_OFFLOAD_PARAMETERS = &hfc030201

#if _WIN32_WINNT >= &h0601
	const OID_TUNNEL_INTERFACE_SET_OID = &h0f010106
	const OID_TUNNEL_INTERFACE_RELEASE_OID = &h0f010107
#endif

const OID_QOS_RESERVED1 = &hfb010100
const OID_QOS_RESERVED2 = &hfb010101
const OID_QOS_RESERVED3 = &hfb010102
const OID_QOS_RESERVED4 = &hfb010103
const OID_QOS_RESERVED5 = &hfb010104
const OID_QOS_RESERVED6 = &hfb010105
const OID_QOS_RESERVED7 = &hfb010106
const OID_QOS_RESERVED8 = &hfb010107
const OID_QOS_RESERVED9 = &hfb010108
const OID_QOS_RESERVED10 = &hfb010109
const OID_QOS_RESERVED11 = &hfb01010a
const OID_QOS_RESERVED12 = &hfb01010b
const OID_QOS_RESERVED13 = &hfb01010c
const OID_QOS_RESERVED14 = &hfb01010d
const OID_QOS_RESERVED15 = &hfb01010e
const OID_QOS_RESERVED16 = &hfb01010f
const OID_QOS_RESERVED17 = &hfb010110
const OID_QOS_RESERVED18 = &hfb010111
const OID_QOS_RESERVED19 = &hfb010112
const OID_QOS_RESERVED20 = &hfb010113
const OFFLOAD_MAX_SAS = 3
const OFFLOAD_INBOUND_SA = &h0001
const OFFLOAD_OUTBOUND_SA = &h0002

type NDIS_CO_DEVICE_PROFILE
	DeviceDescription as NDIS_VAR_DATA_DESC
	DevSpecificInfo as NDIS_VAR_DATA_DESC
	ulTAPISupplementaryPassThru as ULONG
	ulAddressModes as ULONG
	ulNumAddresses as ULONG
	ulBearerModes as ULONG
	ulMaxTxRate as ULONG
	ulMinTxRate as ULONG
	ulMaxRxRate as ULONG
	ulMinRxRate as ULONG
	ulMediaModes as ULONG
	ulGenerateToneModes as ULONG
	ulGenerateToneMaxNumFreq as ULONG
	ulGenerateDigitModes as ULONG
	ulMonitorToneMaxNumFreq as ULONG
	ulMonitorToneMaxNumEntries as ULONG
	ulMonitorDigitModes as ULONG
	ulGatherDigitsMinTimeout as ULONG
	ulGatherDigitsMaxTimeout as ULONG
	ulDevCapFlags as ULONG
	ulMaxNumActiveCalls as ULONG
	ulAnswerMode as ULONG
	ulUUIAcceptSize as ULONG
	ulUUIAnswerSize as ULONG
	ulUUIMakeCallSize as ULONG
	ulUUIDropSize as ULONG
	ulUUISendUserUserInfoSize as ULONG
	ulUUICallInfoSize as ULONG
end type

type PNDIS_CO_DEVICE_PROFILE as NDIS_CO_DEVICE_PROFILE ptr
type SPI_TYPE as ULONG

type _OFFLOAD_OPERATION_E as long
enum
	AUTHENTICATE = 1
	ENCRYPT
end enum

type OFFLOAD_OPERATION_E as _OFFLOAD_OPERATION_E

type _OFFLOAD_ALGO_INFO
	algoIdentifier as ULONG
	algoKeylen as ULONG
	algoRounds as ULONG
end type

type OFFLOAD_ALGO_INFO as _OFFLOAD_ALGO_INFO
type POFFLOAD_ALGO_INFO as _OFFLOAD_ALGO_INFO ptr

type _OFFLOAD_CONF_ALGO as long
enum
	OFFLOAD_IPSEC_CONF_NONE
	OFFLOAD_IPSEC_CONF_DES
	OFFLOAD_IPSEC_CONF_RESERVED
	OFFLOAD_IPSEC_CONF_3_DES
	OFFLOAD_IPSEC_CONF_MAX
end enum

type OFFLOAD_CONF_ALGO as _OFFLOAD_CONF_ALGO

type _OFFLOAD_INTEGRITY_ALGO as long
enum
	OFFLOAD_IPSEC_INTEGRITY_NONE
	OFFLOAD_IPSEC_INTEGRITY_MD5
	OFFLOAD_IPSEC_INTEGRITY_SHA
	OFFLOAD_IPSEC_INTEGRITY_MAX
end enum

type OFFLOAD_INTEGRITY_ALGO as _OFFLOAD_INTEGRITY_ALGO

type _OFFLOAD_SECURITY_ASSOCIATION
	Operation as OFFLOAD_OPERATION_E
	SPI as SPI_TYPE
	IntegrityAlgo as OFFLOAD_ALGO_INFO
	ConfAlgo as OFFLOAD_ALGO_INFO
	Reserved as OFFLOAD_ALGO_INFO
end type

type OFFLOAD_SECURITY_ASSOCIATION as _OFFLOAD_SECURITY_ASSOCIATION
type POFFLOAD_SECURITY_ASSOCIATION as _OFFLOAD_SECURITY_ASSOCIATION ptr

type _OFFLOAD_IPSEC_ADD_SA
	SrcAddr as IPAddr
	SrcMask as IPMask
	DestAddr as IPAddr
	DestMask as IPMask
	Protocol as ULONG
	SrcPort as USHORT
	DestPort as USHORT
	SrcTunnelAddr as IPAddr
	DestTunnelAddr as IPAddr
	Flags as USHORT
	NumSAs as SHORT
	SecAssoc(0 to 2) as OFFLOAD_SECURITY_ASSOCIATION
	OffloadHandle as HANDLE
	KeyLen as ULONG
	KeyMat(0 to 0) as UCHAR
end type

type OFFLOAD_IPSEC_ADD_SA as _OFFLOAD_IPSEC_ADD_SA
type POFFLOAD_IPSEC_ADD_SA as _OFFLOAD_IPSEC_ADD_SA ptr

type _OFFLOAD_IPSEC_DELETE_SA
	OffloadHandle as HANDLE
end type

type OFFLOAD_IPSEC_DELETE_SA as _OFFLOAD_IPSEC_DELETE_SA
type POFFLOAD_IPSEC_DELETE_SA as _OFFLOAD_IPSEC_DELETE_SA ptr

type _UDP_ENCAP_TYPE as long
enum
	OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_IKE
	OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_OTHER
end enum

type UDP_ENCAP_TYPE as _UDP_ENCAP_TYPE
type PUDP_ENCAP_TYPE as _UDP_ENCAP_TYPE ptr

type _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
	UdpEncapType as UDP_ENCAP_TYPE
	DstEncapPort as USHORT
end type

type OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY as _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
type POFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY as _OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY ptr

type _OFFLOAD_IPSEC_ADD_UDPESP_SA
	SrcAddr as IPAddr
	SrcMask as IPMask
	DstAddr as IPAddr
	DstMask as IPMask
	Protocol as ULONG
	SrcPort as USHORT
	DstPort as USHORT
	SrcTunnelAddr as IPAddr
	DstTunnelAddr as IPAddr
	Flags as USHORT
	NumSAs as SHORT
	SecAssoc(0 to 2) as OFFLOAD_SECURITY_ASSOCIATION
	OffloadHandle as HANDLE
	EncapTypeEntry as OFFLOAD_IPSEC_UDPESP_ENCAPTYPE_ENTRY
	EncapTypeEntryOffldHandle as HANDLE
	KeyLen as ULONG
	KeyMat(0 to 0) as UCHAR
end type

type OFFLOAD_IPSEC_ADD_UDPESP_SA as _OFFLOAD_IPSEC_ADD_UDPESP_SA
type POFFLOAD_IPSEC_ADD_UDPESP_SA as _OFFLOAD_IPSEC_ADD_UDPESP_SA ptr

type _OFFLOAD_IPSEC_DELETE_UDPESP_SA
	OffloadHandle as HANDLE
	EncapTypeEntryOffldHandle as HANDLE
end type

type OFFLOAD_IPSEC_DELETE_UDPESP_SA as _OFFLOAD_IPSEC_DELETE_UDPESP_SA
type POFFLOAD_IPSEC_DELETE_UDPESP_SA as _OFFLOAD_IPSEC_DELETE_UDPESP_SA ptr
type NDIS_VLAN_ID as ULONG

type _NDIS_MEDIUM as long
enum
	NdisMedium802_3
	NdisMedium802_5
	NdisMediumFddi
	NdisMediumWan
	NdisMediumLocalTalk
	NdisMediumDix
	NdisMediumArcnetRaw
	NdisMediumArcnet878_2
	NdisMediumAtm
	NdisMediumWirelessWan
	NdisMediumIrda
	NdisMediumBpc
	NdisMediumCoWan
	NdisMedium1394
	NdisMediumInfiniBand

	#if _WIN32_WINNT >= &h0600
		NdisMediumTunnel
		NdisMediumNative802_11
		NdisMediumLoopback
	#endif

	#if _WIN32_WINNT >= &h0601
		NdisMediumWiMAX
		NdisMediumIP
	#endif

	NdisMediumMax
end enum

type NDIS_MEDIUM as _NDIS_MEDIUM
type PNDIS_MEDIUM as _NDIS_MEDIUM ptr

type _NDIS_PHYSICAL_MEDIUM as long
enum
	NdisPhysicalMediumUnspecified
	NdisPhysicalMediumWirelessLan
	NdisPhysicalMediumCableModem
	NdisPhysicalMediumPhoneLine
	NdisPhysicalMediumPowerLine
	NdisPhysicalMediumDSL
	NdisPhysicalMediumFibreChannel
	NdisPhysicalMedium1394
	NdisPhysicalMediumWirelessWan
	NdisPhysicalMediumNative802_11
	NdisPhysicalMediumBluetooth
	NdisPhysicalMediumInfiniband
	NdisPhysicalMediumWiMax
	NdisPhysicalMediumUWB
	NdisPhysicalMedium802_3
	NdisPhysicalMedium802_5
	NdisPhysicalMediumIrda
	NdisPhysicalMediumWiredWAN
	NdisPhysicalMediumWiredCoWan
	NdisPhysicalMediumOther
	NdisPhysicalMediumMax
end enum

type NDIS_PHYSICAL_MEDIUM as _NDIS_PHYSICAL_MEDIUM
type PNDIS_PHYSICAL_MEDIUM as _NDIS_PHYSICAL_MEDIUM ptr

type _TRANSPORT_HEADER_OFFSET
	ProtocolType as USHORT
	HeaderOffset as USHORT
end type

type TRANSPORT_HEADER_OFFSET as _TRANSPORT_HEADER_OFFSET
type PTRANSPORT_HEADER_OFFSET as _TRANSPORT_HEADER_OFFSET ptr

type _NETWORK_ADDRESS
	AddressLength as USHORT
	AddressType as USHORT
	Address(0 to 0) as UCHAR
end type

type NETWORK_ADDRESS as _NETWORK_ADDRESS
type PNETWORK_ADDRESS as _NETWORK_ADDRESS ptr

type _NETWORK_ADDRESS_LIST
	AddressCount as LONG
	AddressType as USHORT
	Address(0 to 0) as NETWORK_ADDRESS
end type

type NETWORK_ADDRESS_LIST as _NETWORK_ADDRESS_LIST
type PNETWORK_ADDRESS_LIST as _NETWORK_ADDRESS_LIST ptr

type _NETWORK_ADDRESS_IP
	sin_port as USHORT
	in_addr as ULONG
	sin_zero(0 to 7) as UCHAR
end type

type NETWORK_ADDRESS_IP as _NETWORK_ADDRESS_IP
type PNETWORK_ADDRESS_IP as _NETWORK_ADDRESS_IP ptr
const NDIS_PROTOCOL_ID_DEFAULT = &h00
const NDIS_PROTOCOL_ID_TCP_IP = &h02
const NDIS_PROTOCOL_ID_IPX = &h06
const NDIS_PROTOCOL_ID_NBF = &h07
const NDIS_PROTOCOL_ID_MAX = &h0f
const NDIS_PROTOCOL_ID_MASK = &h0f
const READABLE_LOCAL_CLOCK = &h00000001
const CLOCK_NETWORK_DERIVED = &h00000002
const CLOCK_PRECISION = &h00000004
const RECEIVE_TIME_INDICATION_CAPABLE = &h00000008
const TIMED_SEND_CAPABLE = &h00000010
const TIME_STAMP_CAPABLE = &h00000020
const NDIS_DEVICE_WAKE_UP_ENABLE = &h00000001
const NDIS_DEVICE_WAKE_ON_PATTERN_MATCH_ENABLE = &h00000002
const NDIS_DEVICE_WAKE_ON_MAGIC_PACKET_ENABLE = &h00000004
const WAN_PROTOCOL_KEEPS_STATS = &h00000001
#define NETWORK_ADDRESS_LENGTH_IP sizeof(NETWORK_ADDRESS_IP)
#define NETWORK_ADDRESS_LENGTH_IPX sizeof(NETWORK_ADDRESS_IPX)

type _NETWORK_ADDRESS_IPX
	NetworkAddress as ULONG
	NodeAddress(0 to 5) as UCHAR
	Socket as USHORT
end type

type NETWORK_ADDRESS_IPX as _NETWORK_ADDRESS_IPX
type PNETWORK_ADDRESS_IPX as _NETWORK_ADDRESS_IPX ptr

type _NDIS_HARDWARE_STATUS as long
enum
	NdisHardwareStatusReady
	NdisHardwareStatusInitializing
	NdisHardwareStatusReset
	NdisHardwareStatusClosing
	NdisHardwareStatusNotReady
end enum

type NDIS_HARDWARE_STATUS as _NDIS_HARDWARE_STATUS
type PNDIS_HARDWARE_STATUS as _NDIS_HARDWARE_STATUS ptr

type _GEN_GET_TIME_CAPS
	Flags as ULONG
	ClockPrecision as ULONG
end type

type GEN_GET_TIME_CAPS as _GEN_GET_TIME_CAPS
type PGEN_GET_TIME_CAPS as _GEN_GET_TIME_CAPS ptr

type _GEN_GET_NETCARD_TIME
	ReadTime as ULONGLONG
end type

type GEN_GET_NETCARD_TIME as _GEN_GET_NETCARD_TIME
type PGEN_GET_NETCARD_TIME as _GEN_GET_NETCARD_TIME ptr

type _NDIS_PM_PACKET_PATTERN
	Priority as ULONG
	Reserved as ULONG
	MaskSize as ULONG
	PatternOffset as ULONG
	PatternSize as ULONG
	PatternFlags as ULONG
end type

type NDIS_PM_PACKET_PATTERN as _NDIS_PM_PACKET_PATTERN
type PNDIS_PM_PACKET_PATTERN as _NDIS_PM_PACKET_PATTERN ptr

type _NDIS_DEVICE_POWER_STATE as long
enum
	NdisDeviceStateUnspecified = 0
	NdisDeviceStateD0
	NdisDeviceStateD1
	NdisDeviceStateD2
	NdisDeviceStateD3
	NdisDeviceStateMaximum
end enum

type NDIS_DEVICE_POWER_STATE as _NDIS_DEVICE_POWER_STATE
type PNDIS_DEVICE_POWER_STATE as _NDIS_DEVICE_POWER_STATE ptr

type _NDIS_PM_WAKE_UP_CAPABILITIES
	MinMagicPacketWakeUp as NDIS_DEVICE_POWER_STATE
	MinPatternWakeUp as NDIS_DEVICE_POWER_STATE
	MinLinkChangeWakeUp as NDIS_DEVICE_POWER_STATE
end type

type NDIS_PM_WAKE_UP_CAPABILITIES as _NDIS_PM_WAKE_UP_CAPABILITIES
type PNDIS_PM_WAKE_UP_CAPABILITIES as _NDIS_PM_WAKE_UP_CAPABILITIES ptr

type _NDIS_PNP_CAPABILITIES
	Flags as ULONG
	WakeUpCapabilities as NDIS_PM_WAKE_UP_CAPABILITIES
end type

type NDIS_PNP_CAPABILITIES as _NDIS_PNP_CAPABILITIES
type PNDIS_PNP_CAPABILITIES as _NDIS_PNP_CAPABILITIES ptr

type _NDIS_FDDI_ATTACHMENT_TYPE as long
enum
	NdisFddiTypeIsolated = 1
	NdisFddiTypeLocalA
	NdisFddiTypeLocalB
	NdisFddiTypeLocalAB
	NdisFddiTypeLocalS
	NdisFddiTypeWrapA
	NdisFddiTypeWrapB
	NdisFddiTypeWrapAB
	NdisFddiTypeWrapS
	NdisFddiTypeCWrapA
	NdisFddiTypeCWrapB
	NdisFddiTypeCWrapS
	NdisFddiTypeThrough
end enum

type NDIS_FDDI_ATTACHMENT_TYPE as _NDIS_FDDI_ATTACHMENT_TYPE
type PNDIS_FDDI_ATTACHMENT_TYPE as _NDIS_FDDI_ATTACHMENT_TYPE ptr

type _NDIS_FDDI_RING_MGT_STATE as long
enum
	NdisFddiRingIsolated = 1
	NdisFddiRingNonOperational
	NdisFddiRingOperational
	NdisFddiRingDetect
	NdisFddiRingNonOperationalDup
	NdisFddiRingOperationalDup
	NdisFddiRingDirected
	NdisFddiRingTrace
end enum

type NDIS_FDDI_RING_MGT_STATE as _NDIS_FDDI_RING_MGT_STATE
type PNDIS_FDDI_RING_MGT_STATE as _NDIS_FDDI_RING_MGT_STATE ptr

type _NDIS_FDDI_LCONNECTION_STATE as long
enum
	NdisFddiStateOff = 1
	NdisFddiStateBreak
	NdisFddiStateTrace
	NdisFddiStateConnect
	NdisFddiStateNext
	NdisFddiStateSignal
	NdisFddiStateJoin
	NdisFddiStateVerify
	NdisFddiStateActive
	NdisFddiStateMaintenance
end enum

type NDIS_FDDI_LCONNECTION_STATE as _NDIS_FDDI_LCONNECTION_STATE
type PNDIS_FDDI_LCONNECTION_STATE as _NDIS_FDDI_LCONNECTION_STATE ptr

type _NDIS_WAN_MEDIUM_SUBTYPE as long
enum
	NdisWanMediumHub
	NdisWanMediumX_25
	NdisWanMediumIsdn
	NdisWanMediumSerial
	NdisWanMediumFrameRelay
	NdisWanMediumAtm
	NdisWanMediumSonet
	NdisWanMediumSW56K
	NdisWanMediumPPTP
	NdisWanMediumL2TP
	NdisWanMediumIrda
	NdisWanMediumParallel
	NdisWanMediumPppoe

	#if _WIN32_WINNT >= &h0600
		NdisWanMediumSSTP
		NdisWanMediumAgileVPN
	#endif
end enum

type NDIS_WAN_MEDIUM_SUBTYPE as _NDIS_WAN_MEDIUM_SUBTYPE
type PNDIS_WAN_MEDIUM_SUBTYPE as _NDIS_WAN_MEDIUM_SUBTYPE ptr

type _NDIS_WAN_HEADER_FORMAT as long
enum
	NdisWanHeaderNative
	NdisWanHeaderEthernet
end enum

type NDIS_WAN_HEADER_FORMAT as _NDIS_WAN_HEADER_FORMAT
type PNDIS_WAN_HEADER_FORMAT as _NDIS_WAN_HEADER_FORMAT ptr

type _NDIS_WAN_QUALITY as long
enum
	NdisWanRaw
	NdisWanErrorControl
	NdisWanReliable
end enum

type NDIS_WAN_QUALITY as _NDIS_WAN_QUALITY
type PNDIS_WAN_QUALITY as _NDIS_WAN_QUALITY ptr

type _NDIS_WAN_PROTOCOL_CAPS
	Flags as ULONG
	Reserved as ULONG
end type

type NDIS_WAN_PROTOCOL_CAPS as _NDIS_WAN_PROTOCOL_CAPS
type PNDIS_WAN_PROTOCOL_CAPS as _NDIS_WAN_PROTOCOL_CAPS ptr

type _NDIS_802_5_RING_STATE as long
enum
	NdisRingStateOpened = 1
	NdisRingStateClosed
	NdisRingStateOpening
	NdisRingStateClosing
	NdisRingStateOpenFailure
	NdisRingStateRingFailure
end enum

type NDIS_802_5_RING_STATE as _NDIS_802_5_RING_STATE
type PNDIS_802_5_RING_STATE as _NDIS_802_5_RING_STATE ptr

type _NDIS_MEDIA_STATE as long
enum
	NdisMediaStateConnected
	NdisMediaStateDisconnected
end enum

type NDIS_MEDIA_STATE as _NDIS_MEDIA_STATE
type PNDIS_MEDIA_STATE as _NDIS_MEDIA_STATE ptr
type Priority_802_3 as ULONG

type _NDIS_CO_LINK_SPEED
	Outbound as ULONG
	Inbound as ULONG
end type

type NDIS_CO_LINK_SPEED as _NDIS_CO_LINK_SPEED
type PNDIS_CO_LINK_SPEED as _NDIS_CO_LINK_SPEED ptr

#if _WIN32_WINNT >= &h0600
	#define NDIS_LINK_SPEED_UNKNOWN NET_IF_LINK_SPEED_UNKNOWN

	type _NDIS_LINK_SPEED
		XmitLinkSpeed as ULONG64
		RcvLinkSpeed as ULONG64
	end type

	type NDIS_LINK_SPEED as _NDIS_LINK_SPEED
	type PNDIS_LINK_SPEED as _NDIS_LINK_SPEED ptr
#endif

type NDIS_STATUS as long
type PNDIS_STATUS as long ptr

#include once "windot11.bi"

const fNDIS_GUID_TO_OID = &h00000001
const fNDIS_GUID_TO_STATUS = &h00000002
const fNDIS_GUID_ANSI_STRING = &h00000004
const fNDIS_GUID_UNICODE_STRING = &h00000008
const fNDIS_GUID_ARRAY = &h00000010
const fNDIS_GUID_ALLOW_READ = &h00000020
const fNDIS_GUID_ALLOW_WRITE = &h00000040
const fNDIS_GUID_METHOD = &h00000080
const fNDIS_GUID_NDIS_RESERVED = &h00000100
const fNDIS_GUID_SUPPORT_COMMON_HEADER = &h00000200
const NDIS_PACKET_TYPE_DIRECTED = &h00000001

#if _WIN32_WINNT >= &h0600
	const NDIS_PACKET_TYPE_802_11_DIRECTED_DATA = NDIS_PACKET_TYPE_DIRECTED
#endif

const NDIS_PACKET_TYPE_MULTICAST = &h00000002

#if _WIN32_WINNT >= &h0600
	const NDIS_PACKET_TYPE_802_11_MULTICAST_DATA = NDIS_PACKET_TYPE_MULTICAST
#endif

const NDIS_PACKET_TYPE_ALL_MULTICAST = &h00000004

#if _WIN32_WINNT >= &h0600
	const NDIS_PACKET_TYPE_802_11_ALL_MULTICAST_DATA = NDIS_PACKET_TYPE_ALL_MULTICAST
#endif

const NDIS_PACKET_TYPE_BROADCAST = &h00000008

#if _WIN32_WINNT >= &h0600
	const NDIS_PACKET_TYPE_802_11_BROADCAST_DATA = NDIS_PACKET_TYPE_BROADCAST
#endif

const NDIS_PACKET_TYPE_SOURCE_ROUTING = &h00000010
const NDIS_PACKET_TYPE_PROMISCUOUS = &h00000020

#if _WIN32_WINNT >= &h0600
	const NDIS_PACKET_TYPE_802_11_PROMISCUOUS_DATA = NDIS_PACKET_TYPE_PROMISCUOUS
#endif

const NDIS_PACKET_TYPE_SMT = &h00000040
const NDIS_PACKET_TYPE_ALL_LOCAL = &h00000080
const NDIS_PACKET_TYPE_GROUP = &h00001000
const NDIS_PACKET_TYPE_ALL_FUNCTIONAL = &h00002000
const NDIS_PACKET_TYPE_FUNCTIONAL = &h00004000
const NDIS_PACKET_TYPE_MAC_FRAME = &h00008000
const NDIS_PACKET_TYPE_NO_LOCAL = &h00010000
const NDIS_RING_SIGNAL_LOSS = &h00008000
const NDIS_RING_HARD_ERROR = &h00004000
const NDIS_RING_SOFT_ERROR = &h00002000
const NDIS_RING_TRANSMIT_BEACON = &h00001000
const NDIS_RING_LOBE_WIRE_FAULT = &h00000800
const NDIS_RING_AUTO_REMOVAL_ERROR = &h00000400
const NDIS_RING_REMOVE_RECEIVED = &h00000200
const NDIS_RING_COUNTER_OVERFLOW = &h00000100
const NDIS_RING_SINGLE_STATION = &h00000080
const NDIS_RING_RING_RECOVERY = &h00000040
const NDIS_PROT_OPTION_ESTIMATED_LENGTH = &h00000001
const NDIS_PROT_OPTION_NO_LOOPBACK = &h00000002
const NDIS_PROT_OPTION_NO_RSVD_ON_RCVPKT = &h00000004
const NDIS_PROT_OPTION_SEND_RESTRICTED = &h00000008
const NDIS_MAC_OPTION_COPY_LOOKAHEAD_DATA = &h00000001
const NDIS_MAC_OPTION_RECEIVE_SERIALIZED = &h00000002
const NDIS_MAC_OPTION_TRANSFERS_NOT_PEND = &h00000004
const NDIS_MAC_OPTION_NO_LOOPBACK = &h00000008
const NDIS_MAC_OPTION_FULL_DUPLEX = &h00000010
const NDIS_MAC_OPTION_EOTX_INDICATION = &h00000020
const NDIS_MAC_OPTION_8021P_PRIORITY = &h00000040
const NDIS_MAC_OPTION_SUPPORTS_MAC_ADDRESS_OVERWRITE = &h00000080
const NDIS_MAC_OPTION_RECEIVE_AT_DPC = &h00000100
const NDIS_MAC_OPTION_8021Q_VLAN = &h00000200
const NDIS_MAC_OPTION_RESERVED = &h80000000
const NDIS_MEDIA_CAP_TRANSMIT = &h00000001
const NDIS_MEDIA_CAP_RECEIVE = &h00000002
const NDIS_CO_MAC_OPTION_DYNAMIC_LINK_SPEED = &h00000001

type _NDIS_GUID
	Guid as GUID

	union
		Oid as NDIS_OID
		Status as NDIS_STATUS
	end union

	Size as ULONG
	Flags as ULONG
end type

type NDIS_GUID as _NDIS_GUID
type PNDIS_GUID as _NDIS_GUID ptr

type _NDIS_IRDA_PACKET_INFO
	ExtraBOFs as ULONG
	MinTurnAroundTime as ULONG
end type

type NDIS_IRDA_PACKET_INFO as _NDIS_IRDA_PACKET_INFO
type PNDIS_IRDA_PACKET_INFO as _NDIS_IRDA_PACKET_INFO ptr

#if _WIN32_WINNT >= &h0600
	#macro NDIS_MAKE_NET_LUID(PNLUID, IFTYPE, NLUIDIDX)
		scope
			(PNLUID)->Info.IfType = IFTYPE
			(PNLUID)->Info.NetLuidIndex = NLUIDIDX
			(PNLUID)->Info.Reserved = 0
		end scope
	#endmacro
	const MAXIMUM_IP_OPER_STATUS_ADDRESS_FAMILIES_SUPPORTED = 32
	const NDIS_IF_MAX_STRING_SIZE = IF_MAX_STRING_SIZE
	const IF_NAMESIZE = NDIS_IF_MAX_STRING_SIZE
	const NDIS_MAX_PHYS_ADDRESS_LENGTH = IF_MAX_PHYS_ADDRESS_LENGTH
	const NDIS_LINK_STATE_XMIT_LINK_SPEED_AUTO_NEGOTIATED = &h00000001
	const NDIS_LINK_STATE_RCV_LINK_SPEED_AUTO_NEGOTIATED = &h00000002
	const NDIS_LINK_STATE_DUPLEX_AUTO_NEGOTIATED = &h00000004
	const NDIS_LINK_STATE_PAUSE_FUNCTIONS_AUTO_NEGOTIATED = &h00000008
	const NDIS_LINK_STATE_REVISION_1 = 1
	const NDIS_LINK_PARAMETERS_REVISION_1 = 1
	const NDIS_OPER_STATE_REVISION_1 = 1
	const NDIS_IP_OPER_STATUS_INFO_REVISION_1 = 1
	const NDIS_IP_OPER_STATE_REVISION_1 = 1
	#define NDIS_SIZEOF_LINK_STATE_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_LINK_STATE, AutoNegotiationFlags)
	#define NDIS_SIZEOF_LINK_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_LINK_PARAMETERS, AutoNegotiationFlags)
	#define NDIS_SIZEOF_OPER_STATE_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_OPER_STATE, OperationalStatusFlags)
	#define NDIS_SIZEOF_IP_OPER_STATUS_INFO_REVISION_1 (FIELD_OFFSET(NDIS_IP_OPER_STATUS_INFO, IpOperationalStatus) + (MAXIMUM_IP_OPER_STATUS_ADDRESS_FAMILIES_SUPPORTED * sizeof(NDIS_IP_OPER_STATUS)))
	#define NDIS_SIZEOF_IP_OPER_STATE_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_IP_OPER_STATE, IpOperationalStatus)

	type NDIS_IF_COUNTED_STRING as IF_COUNTED_STRING
	type PNDIS_IF_COUNTED_STRING as IF_COUNTED_STRING ptr
	type NDIS_IF_PHYSICAL_ADDRESS as IF_PHYSICAL_ADDRESS
	type PNDIS_IF_PHYSICAL_ADDRESS as IF_PHYSICAL_ADDRESS ptr
	type NDIS_MEDIA_CONNECT_STATE as NET_IF_MEDIA_CONNECT_STATE
	type PNDIS_MEDIA_CONNECT_STATE as NET_IF_MEDIA_CONNECT_STATE ptr
	type NDIS_MEDIA_DUPLEX_STATE as NET_IF_MEDIA_DUPLEX_STATE
	type PNDIS_MEDIA_DUPLEX_STATE as NET_IF_MEDIA_DUPLEX_STATE ptr

	type _NDIS_SUPPORTED_PAUSE_FUNCTIONS as long
	enum
		NdisPauseFunctionsUnsupported
		NdisPauseFunctionsSendOnly
		NdisPauseFunctionsReceiveOnly
		NdisPauseFunctionsSendAndReceive
		NdisPauseFunctionsUnknown
	end enum

	type NDIS_SUPPORTED_PAUSE_FUNCTIONS as _NDIS_SUPPORTED_PAUSE_FUNCTIONS
	type PNDIS_SUPPORTED_PAUSE_FUNCTIONS as _NDIS_SUPPORTED_PAUSE_FUNCTIONS ptr

	type _NDIS_LINK_STATE
		Header as NDIS_OBJECT_HEADER
		MediaConnectState as NDIS_MEDIA_CONNECT_STATE
		MediaDuplexState as NDIS_MEDIA_DUPLEX_STATE
		XmitLinkSpeed as ULONG64
		RcvLinkSpeed as ULONG64
		PauseFunctions as NDIS_SUPPORTED_PAUSE_FUNCTIONS
		AutoNegotiationFlags as ULONG
	end type

	type NDIS_LINK_STATE as _NDIS_LINK_STATE
	type PNDIS_LINK_STATE as _NDIS_LINK_STATE ptr

	type _NDIS_LINK_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		MediaDuplexState as NDIS_MEDIA_DUPLEX_STATE
		XmitLinkSpeed as ULONG64
		RcvLinkSpeed as ULONG64
		PauseFunctions as NDIS_SUPPORTED_PAUSE_FUNCTIONS
		AutoNegotiationFlags as ULONG
	end type

	type NDIS_LINK_PARAMETERS as _NDIS_LINK_PARAMETERS
	type PNDIS_LINK_PARAMETERS as _NDIS_LINK_PARAMETERS ptr

	type _NDIS_OPER_STATE
		Header as NDIS_OBJECT_HEADER
		OperationalStatus as NET_IF_OPER_STATUS
		OperationalStatusFlags as ULONG
	end type

	type NDIS_OPER_STATE as _NDIS_OPER_STATE
	type PNDIS_OPER_STATE as _NDIS_OPER_STATE ptr

	type _NDIS_IP_OPER_STATUS
		AddressFamily as ULONG
		OperationalStatus as NET_IF_OPER_STATUS
		OperationalStatusFlags as ULONG
	end type

	type NDIS_IP_OPER_STATUS as _NDIS_IP_OPER_STATUS
	type PNDIS_IP_OPER_STATUS as _NDIS_IP_OPER_STATUS ptr

	type _NDIS_IP_OPER_STATUS_INFO
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		NumberofAddressFamiliesReturned as ULONG
		IpOperationalStatus(0 to 31) as NDIS_IP_OPER_STATUS
	end type

	type NDIS_IP_OPER_STATUS_INFO as _NDIS_IP_OPER_STATUS_INFO
	type PNDIS_IP_OPER_STATUS_INFO as _NDIS_IP_OPER_STATUS_INFO ptr

	type _NDIS_IP_OPER_STATE
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		IpOperationalStatus as NDIS_IP_OPER_STATUS
	end type

	type NDIS_IP_OPER_STATE as _NDIS_IP_OPER_STATE
	type PNDIS_IP_OPER_STATE as _NDIS_IP_OPER_STATE ptr
	const NDIS_OFFLOAD_PARAMETERS_NO_CHANGE = 0
	const NDIS_OFFLOAD_PARAMETERS_TX_RX_DISABLED = 1
	const NDIS_OFFLOAD_PARAMETERS_TX_ENABLED_RX_DISABLED = 2
	const NDIS_OFFLOAD_PARAMETERS_RX_ENABLED_TX_DISABLED = 3
	const NDIS_OFFLOAD_PARAMETERS_TX_RX_ENABLED = 4
	const NDIS_OFFLOAD_PARAMETERS_LSOV1_DISABLED = 1
	const NDIS_OFFLOAD_PARAMETERS_LSOV1_ENABLED = 2
	const NDIS_OFFLOAD_PARAMETERS_IPSECV1_DISABLED = 1
	const NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_ENABLED = 2
	const NDIS_OFFLOAD_PARAMETERS_IPSECV1_ESP_ENABLED = 3
	const NDIS_OFFLOAD_PARAMETERS_IPSECV1_AH_AND_ESP_ENABLED = 4
	const NDIS_OFFLOAD_PARAMETERS_LSOV2_DISABLED = 1
	const NDIS_OFFLOAD_PARAMETERS_LSOV2_ENABLED = 2
	const NDIS_OFFLOAD_PARAMETERS_CONNECTION_OFFLOAD_DISABLED = 1
	const NDIS_OFFLOAD_PARAMETERS_CONNECTION_OFFLOAD_ENABLED = 2
	const NDIS_OFFLOAD_PARAMETERS_REVISION_1 = 1

	type _NDIS_OFFLOAD_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		IPv4Checksum as UCHAR
		TCPIPv4Checksum as UCHAR
		UDPIPv4Checksum as UCHAR
		TCPIPv6Checksum as UCHAR
		UDPIPv6Checksum as UCHAR
		LsoV1 as UCHAR
		IPsecV1 as UCHAR
		LsoV2IPv4 as UCHAR
		LsoV2IPv6 as UCHAR
		TcpConnectionIPv4 as UCHAR
		TcpConnectionIPv6 as UCHAR
		Flags as ULONG
	end type

	type NDIS_OFFLOAD_PARAMETERS as _NDIS_OFFLOAD_PARAMETERS
	type PNDIS_OFFLOAD_PARAMETERS as _NDIS_OFFLOAD_PARAMETERS ptr
	#define NDIS_SIZEOF_OFFLOAD_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_OFFLOAD_PARAMETERS, Flags)
	const NDIS_OFFLOAD_NOT_SUPPORTED = 0
	const NDIS_OFFLOAD_SUPPORTED = 1
	const NDIS_OFFLOAD_SET_NO_CHANGE = 0
	const NDIS_OFFLOAD_SET_ON = 1
	const NDIS_OFFLOAD_SET_OFF = 2
	const NDIS_ENCAPSULATION_NOT_SUPPORTED = &h00000000
	const NDIS_ENCAPSULATION_NULL = &h00000001
	const NDIS_ENCAPSULATION_IEEE_802_3 = &h00000002
	const NDIS_ENCAPSULATION_IEEE_802_3_P_AND_Q = &h00000004
	const NDIS_ENCAPSULATION_IEEE_802_3_P_AND_Q_IN_OOB = &h00000008
	const NDIS_ENCAPSULATION_IEEE_LLC_SNAP_ROUTED = &h00000010

	type _NDIS_TCP_LARGE_SEND_OFFLOAD_V1_IPv4
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
		TcpOptions : 2 as ULONG
		IpOptions : 2 as ULONG
	end type

	type _NDIS_TCP_LARGE_SEND_OFFLOAD_V1
		IPv4 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V1_IPv4
	end type

	type NDIS_TCP_LARGE_SEND_OFFLOAD_V1 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V1
	type PNDIS_TCP_LARGE_SEND_OFFLOAD_V1 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V1 ptr

	type _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv4Transmit
		Encapsulation as ULONG
		IpOptionsSupported : 2 as ULONG
		TcpOptionsSupported : 2 as ULONG
		TcpChecksum : 2 as ULONG
		UdpChecksum : 2 as ULONG
		IpChecksum : 2 as ULONG
	end type

	type _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv4Receive
		Encapsulation as ULONG
		IpOptionsSupported : 2 as ULONG
		TcpOptionsSupported : 2 as ULONG
		TcpChecksum : 2 as ULONG
		UdpChecksum : 2 as ULONG
		IpChecksum : 2 as ULONG
	end type

	type _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv6Transmit
		Encapsulation as ULONG
		IpExtensionHeadersSupported : 2 as ULONG
		TcpOptionsSupported : 2 as ULONG
		TcpChecksum : 2 as ULONG
		UdpChecksum : 2 as ULONG
	end type

	type _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv6Receive
		Encapsulation as ULONG
		IpExtensionHeadersSupported : 2 as ULONG
		TcpOptionsSupported : 2 as ULONG
		TcpChecksum : 2 as ULONG
		UdpChecksum : 2 as ULONG
	end type

	type _NDIS_TCP_IP_CHECKSUM_OFFLOAD
		IPv4Transmit as _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv4Transmit
		IPv4Receive as _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv4Receive
		IPv6Transmit as _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv6Transmit
		IPv6Receive as _NDIS_TCP_IP_CHECKSUM_OFFLOAD_IPv6Receive
	end type

	type NDIS_TCP_IP_CHECKSUM_OFFLOAD as _NDIS_TCP_IP_CHECKSUM_OFFLOAD
	type PNDIS_TCP_IP_CHECKSUM_OFFLOAD as _NDIS_TCP_IP_CHECKSUM_OFFLOAD ptr

	type _NDIS_IPSEC_OFFLOAD_V1_Supported
		Encapsulation as ULONG
		AhEspCombined as ULONG
		TransportTunnelCombined as ULONG
		IPv4Options as ULONG
		Flags as ULONG
	end type

	type _NDIS_IPSEC_OFFLOAD_V1_IPv4AH
		Md5 : 2 as ULONG
		Sha_1 : 2 as ULONG
		Transport : 2 as ULONG
		Tunnel : 2 as ULONG
		Send : 2 as ULONG
		Receive : 2 as ULONG
	end type

	type _NDIS_IPSEC_OFFLOAD_V1_IPv4ESP
		Des : 2 as ULONG
		Reserved : 2 as ULONG
		TripleDes : 2 as ULONG
		NullEsp : 2 as ULONG
		Transport : 2 as ULONG
		Tunnel : 2 as ULONG
		Send : 2 as ULONG
		Receive : 2 as ULONG
	end type

	type _NDIS_IPSEC_OFFLOAD_V1
		Supported as _NDIS_IPSEC_OFFLOAD_V1_Supported
		IPv4AH as _NDIS_IPSEC_OFFLOAD_V1_IPv4AH
		IPv4ESP as _NDIS_IPSEC_OFFLOAD_V1_IPv4ESP
	end type

	type NDIS_IPSEC_OFFLOAD_V1 as _NDIS_IPSEC_OFFLOAD_V1
	type PNDIS_IPSEC_OFFLOAD_V1 as _NDIS_IPSEC_OFFLOAD_V1 ptr

	type _NDIS_TCP_LARGE_SEND_OFFLOAD_V2_IPv4
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
	end type

	type _NDIS_TCP_LARGE_SEND_OFFLOAD_V2_IPv6
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
		IpExtensionHeadersSupported : 2 as ULONG
		TcpOptionsSupported : 2 as ULONG
	end type

	type _NDIS_TCP_LARGE_SEND_OFFLOAD_V2
		IPv4 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V2_IPv4
		IPv6 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V2_IPv6
	end type

	type NDIS_TCP_LARGE_SEND_OFFLOAD_V2 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V2
	type PNDIS_TCP_LARGE_SEND_OFFLOAD_V2 as _NDIS_TCP_LARGE_SEND_OFFLOAD_V2 ptr
	const NDIS_OFFLOAD_FLAGS_GROUP_CHECKSUM_CAPABILITIES = &h1
	const NDIS_MAXIMUM_PORTS = &h1000000
	#define NDIS_DEFAULT_PORT_NUMBER cast(NDIS_PORT_NUMBER, 0)
	const NDIS_WMI_DEFAULT_METHOD_ID = 1
	const NDIS_WMI_OBJECT_TYPE_SET = &h01
	const NDIS_WMI_OBJECT_TYPE_METHOD = &h02
	const NDIS_WMI_OBJECT_TYPE_EVENT = &h03
	const NDIS_WMI_OBJECT_TYPE_ENUM_ADAPTER = &h04
	const NDIS_WMI_OBJECT_TYPE_OUTPUT_INFO = &h05
	const NDIS_DEVICE_TYPE_ENDPOINT = &h00000001
	const NDIS_OFFLOAD_REVISION_1 = 1
	const NDIS_TCP_CONNECTION_OFFLOAD_REVISION_1 = 1
	const NDIS_PORT_AUTHENTICATION_PARAMETERS_REVISION_1 = 1
	const NDIS_WMI_METHOD_HEADER_REVISION_1 = 1
	const NDIS_WMI_SET_HEADER_REVISION_1 = 1
	const NDIS_WMI_EVENT_HEADER_REVISION_1 = 1
	const NDIS_WMI_ENUM_ADAPTER_REVISION_1 = 1
	#define NDIS_SIZEOF_NDIS_OFFLOAD_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_OFFLOAD, Flags)
	#define NDIS_SIZEOF_NDIS_WMI_OFFLOAD_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_OFFLOAD, Flags)
	#define NDIS_SIZEOF_TCP_CONNECTION_OFFLOAD_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_TCP_CONNECTION_OFFLOAD, Flags)
	#define NDIS_SIZEOF_WMI_TCP_CONNECTION_OFFLOAD_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_TCP_CONNECTION_OFFLOAD, Flags)
	#define NDIS_SIZEOF_PORT_AUTHENTICATION_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_PORT_AUTHENTICATION_PARAMETERS, RcvAuthorizationState)
	#define NDIS_SIZEOF_WMI_METHOD_HEADER_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_METHOD_HEADER, Padding)
	#define NDIS_SIZEOF_WMI_SET_HEADER_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_SET_HEADER, Padding)
	#define NDIS_SIZEOF_WMI_EVENT_HEADER_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_EVENT_HEADER, Padding)
	#define NDIS_SIZEOF_WMI_ENUM_ADAPTER_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_WMI_ENUM_ADAPTER, DeviceName)

	type _NDIS_OFFLOAD
		Header as NDIS_OBJECT_HEADER
		Checksum as NDIS_TCP_IP_CHECKSUM_OFFLOAD
		LsoV1 as NDIS_TCP_LARGE_SEND_OFFLOAD_V1
		IPsecV1 as NDIS_IPSEC_OFFLOAD_V1
		LsoV2 as NDIS_TCP_LARGE_SEND_OFFLOAD_V2
		Flags as ULONG
	end type

	type NDIS_OFFLOAD as _NDIS_OFFLOAD
	type PNDIS_OFFLOAD as _NDIS_OFFLOAD ptr

	type _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1_IPv4
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
		TcpOptions as ULONG
		IpOptions as ULONG
	end type

	type _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1
		IPv4 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1_IPv4
	end type

	type NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1
	type PNDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1 ptr

	type _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv4Transmit
		Encapsulation as ULONG
		IpOptionsSupported as ULONG
		TcpOptionsSupported as ULONG
		TcpChecksum as ULONG
		UdpChecksum as ULONG
		IpChecksum as ULONG
	end type

	type _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv4Receive
		Encapsulation as ULONG
		IpOptionsSupported as ULONG
		TcpOptionsSupported as ULONG
		TcpChecksum as ULONG
		UdpChecksum as ULONG
		IpChecksum as ULONG
	end type

	type _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv6Transmit
		Encapsulation as ULONG
		IpExtensionHeadersSupported as ULONG
		TcpOptionsSupported as ULONG
		TcpChecksum as ULONG
		UdpChecksum as ULONG
	end type

	type _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv6Receive
		Encapsulation as ULONG
		IpExtensionHeadersSupported as ULONG
		TcpOptionsSupported as ULONG
		TcpChecksum as ULONG
		UdpChecksum as ULONG
	end type

	type _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD
		IPv4Transmit as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv4Transmit
		IPv4Receive as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv4Receive
		IPv6Transmit as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv6Transmit
		IPv6Receive as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD_IPv6Receive
	end type

	type NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD
	type PNDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD as _NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD ptr

	type _NDIS_WMI_IPSEC_OFFLOAD_V1_Supported
		Encapsulation as ULONG
		AhEspCombined as ULONG
		TransportTunnelCombined as ULONG
		IPv4Options as ULONG
		Flags as ULONG
	end type

	type _NDIS_WMI_IPSEC_OFFLOAD_V1_IPv4AH
		Md5 as ULONG
		Sha_1 as ULONG
		Transport as ULONG
		Tunnel as ULONG
		Send as ULONG
		Receive as ULONG
	end type

	type _NDIS_WMI_IPSEC_OFFLOAD_V1_IPv4ESP
		Des as ULONG
		Reserved as ULONG
		TripleDes as ULONG
		NullEsp as ULONG
		Transport as ULONG
		Tunnel as ULONG
		Send as ULONG
		Receive as ULONG
	end type

	type _NDIS_WMI_IPSEC_OFFLOAD_V1
		Supported as _NDIS_WMI_IPSEC_OFFLOAD_V1_Supported
		IPv4AH as _NDIS_WMI_IPSEC_OFFLOAD_V1_IPv4AH
		IPv4ESP as _NDIS_WMI_IPSEC_OFFLOAD_V1_IPv4ESP
	end type

	type NDIS_WMI_IPSEC_OFFLOAD_V1 as _NDIS_WMI_IPSEC_OFFLOAD_V1
	type PNDIS_WMI_IPSEC_OFFLOAD_V1 as _NDIS_WMI_IPSEC_OFFLOAD_V1 ptr

	type _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2_IPv4
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
	end type

	type _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2_IPv6
		Encapsulation as ULONG
		MaxOffLoadSize as ULONG
		MinSegmentCount as ULONG
		IpExtensionHeadersSupported as ULONG
		TcpOptionsSupported as ULONG
	end type

	type _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2
		IPv4 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2_IPv4
		IPv6 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2_IPv6
	end type

	type NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2
	type PNDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2 as _NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2 ptr

	type _NDIS_WMI_OFFLOAD
		Header as NDIS_OBJECT_HEADER
		Checksum as NDIS_WMI_TCP_IP_CHECKSUM_OFFLOAD
		LsoV1 as NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V1
		IPsecV1 as NDIS_WMI_IPSEC_OFFLOAD_V1
		LsoV2 as NDIS_WMI_TCP_LARGE_SEND_OFFLOAD_V2
		Flags as ULONG
	end type

	type NDIS_WMI_OFFLOAD as _NDIS_WMI_OFFLOAD
	type PNDIS_WMI_OFFLOAD as _NDIS_WMI_OFFLOAD ptr

	type _NDIS_TCP_CONNECTION_OFFLOAD
		Header as NDIS_OBJECT_HEADER
		Encapsulation as ULONG
		SupportIPv4 : 2 as ULONG
		SupportIPv6 : 2 as ULONG
		SupportIPv6ExtensionHeaders : 2 as ULONG
		SupportSack : 2 as ULONG
		TcpConnectionOffloadCapacity as ULONG
		Flags as ULONG
	end type

	type NDIS_TCP_CONNECTION_OFFLOAD as _NDIS_TCP_CONNECTION_OFFLOAD
	type PNDIS_TCP_CONNECTION_OFFLOAD as _NDIS_TCP_CONNECTION_OFFLOAD ptr

	type _NDIS_WMI_TCP_CONNECTION_OFFLOAD
		Header as NDIS_OBJECT_HEADER
		Encapsulation as ULONG
		SupportIPv4 as ULONG
		SupportIPv6 as ULONG
		SupportIPv6ExtensionHeaders as ULONG
		SupportSack as ULONG
		TcpConnectionOffloadCapacity as ULONG
		Flags as ULONG
	end type

	type NDIS_WMI_TCP_CONNECTION_OFFLOAD as _NDIS_WMI_TCP_CONNECTION_OFFLOAD
	type PNDIS_WMI_TCP_CONNECTION_OFFLOAD as _NDIS_WMI_TCP_CONNECTION_OFFLOAD ptr
	type NDIS_PORT_NUMBER as ULONG
	type PNDIS_PORT_NUMBER as ULONG ptr

	type _NDIS_PORT_TYPE as long
	enum
		NdisPortTypeUndefined
		NdisPortTypeBridge
		NdisPortTypeRasConnection
		NdisPortType8021xSupplicant
		NdisPortTypeMax
	end enum

	type NDIS_PORT_TYPE as _NDIS_PORT_TYPE
	type PNDIS_PORT_TYPE as _NDIS_PORT_TYPE ptr

	type _NDIS_PORT_AUTHORIZATION_STATE as long
	enum
		NdisPortAuthorizationUnknown
		NdisPortAuthorized
		NdisPortUnauthorized
		NdisPortReauthorizing
	end enum

	type NDIS_PORT_AUTHORIZATION_STATE as _NDIS_PORT_AUTHORIZATION_STATE
	type PNDIS_PORT_AUTHORIZATION_STATE as _NDIS_PORT_AUTHORIZATION_STATE ptr

	type _NDIS_PORT_CONTROL_STATE as long
	enum
		NdisPortControlStateUnknown
		NdisPortControlStateControlled
		NdisPortControlStateUncontrolled
	end enum

	type NDIS_PORT_CONTROL_STATE as _NDIS_PORT_CONTROL_STATE
	type PNDIS_PORT_CONTROL_STATE as _NDIS_PORT_CONTROL_STATE ptr
	type NDIS_PORT_CONTROLL_STATE as NDIS_PORT_CONTROL_STATE
	type PNDIS_PORT_CONTROLL_STATE as PNDIS_PORT_CONTROL_STATE

	type _NDIS_PORT_AUTHENTICATION_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		SendControlState as NDIS_PORT_CONTROL_STATE
		RcvControlState as NDIS_PORT_CONTROL_STATE
		SendAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
		RcvAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
	end type

	type NDIS_PORT_AUTHENTICATION_PARAMETERS as _NDIS_PORT_AUTHENTICATION_PARAMETERS
	type PNDIS_PORT_AUTHENTICATION_PARAMETERS as _NDIS_PORT_AUTHENTICATION_PARAMETERS ptr

	type _NDIS_NETWORK_CHANGE_TYPE as long
	enum
		NdisPossibleNetworkChange = 1
		NdisDefinitelyNetworkChange
		NdisNetworkChangeFromMediaConnect
		NdisNetworkChangeMax
	end enum

	type NDIS_NETWORK_CHANGE_TYPE as _NDIS_NETWORK_CHANGE_TYPE
	type PNDIS_NETWORK_CHANGE_TYPE as _NDIS_NETWORK_CHANGE_TYPE ptr

	type _NDIS_WMI_METHOD_HEADER
		Header as NDIS_OBJECT_HEADER
		PortNumber as NDIS_PORT_NUMBER
		NetLuid as NET_LUID
		RequestId as ULONG64
		Timeout as ULONG
		Padding(0 to 3) as UCHAR
	end type

	type NDIS_WMI_METHOD_HEADER as _NDIS_WMI_METHOD_HEADER
	type PNDIS_WMI_METHOD_HEADER as _NDIS_WMI_METHOD_HEADER ptr

	type _NDIS_WMI_SET_HEADER
		Header as NDIS_OBJECT_HEADER
		PortNumber as NDIS_PORT_NUMBER
		NetLuid as NET_LUID
		RequestId as ULONG64
		Timeout as ULONG
		Padding(0 to 3) as UCHAR
	end type

	type NDIS_WMI_SET_HEADER as _NDIS_WMI_SET_HEADER
	type PNDIS_WMI_SET_HEADER as _NDIS_WMI_SET_HEADER ptr

	type _NDIS_WMI_EVENT_HEADER
		Header as NDIS_OBJECT_HEADER
		IfIndex as NET_IFINDEX
		NetLuid as NET_LUID
		RequestId as ULONG64
		PortNumber as NDIS_PORT_NUMBER
		DeviceNameLength as ULONG
		DeviceNameOffset as ULONG
		Padding(0 to 3) as UCHAR
	end type

	type NDIS_WMI_EVENT_HEADER as _NDIS_WMI_EVENT_HEADER
	type PNDIS_WMI_EVENT_HEADER as _NDIS_WMI_EVENT_HEADER ptr

	type _NDIS_WMI_ENUM_ADAPTER
		Header as NDIS_OBJECT_HEADER
		IfIndex as NET_IFINDEX
		NetLuid as NET_LUID
		DeviceNameLength as USHORT
		DeviceName as zstring * 1
	end type

	type NDIS_WMI_ENUM_ADAPTER as _NDIS_WMI_ENUM_ADAPTER
	type PNDIS_WMI_ENUM_ADAPTER as _NDIS_WMI_ENUM_ADAPTER ptr
	const NDIS_WMI_OUTPUT_INFO_REVISION_1 = 1

	type NDIS_WMI_OUTPUT_INFO
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		SupportedRevision as UCHAR
		DataOffset as ULONG
	end type

	type PNDIS_WMI_OUTPUT_INFO as NDIS_WMI_OUTPUT_INFO ptr
	const NDIS_RSS_CAPS_MESSAGE_SIGNALED_INTERRUPTS = &h01000000
	const NDIS_RSS_CAPS_CLASSIFICATION_AT_ISR = &h02000000
	const NDIS_RSS_CAPS_CLASSIFICATION_AT_DPC = &h04000000
	const NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV4 = &h00000100
	const NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV6 = &h00000200
	const NDIS_RSS_CAPS_HASH_TYPE_TCP_IPV6_EX = &h00000400
	const NdisHashFunctionToeplitz = &h00000001
	const NdisHashFunctionReserved1 = &h00000002
	const NdisHashFunctionReserved2 = &h00000004
	const NdisHashFunctionReserved3 = &h00000008
	const NDIS_HASH_FUNCTION_MASK = &h000000ff
	const NDIS_HASH_TYPE_MASK = &h00ffff00
	#define NDIS_RSS_HASH_FUNC_FROM_HASH_INFO(HINFO) ((HINFO) and NDIS_HASH_FUNCTION_MASK)
	#define NDIS_RSS_HASH_TYPE_FROM_HASH_INFO(HINFO) ((HINFO) and NDIS_HASH_TYPE_MASK)
	#define NDIS_RSS_HASH_INFO_FROM_TYPE_AND_FUNC(HTYPE, HFCT) ((HTYPE) or (HFCT))
	const NDIS_HASH_IPV4 = &h00000100
	const NDIS_HASH_TCP_IPV4 = &h00000200
	const NDIS_HASH_IPV6 = &h00000400
	const NDIS_HASH_IPV6_EX = &h00000800
	const NDIS_HASH_TCP_IPV6 = &h00001000
	const NDIS_HASH_TCP_IPV6_EX = &h00002000
	const NDIS_RSS_PARAM_FLAG_BASE_CPU_UNCHANGED = &h0001
	const NDIS_RSS_PARAM_FLAG_HASH_INFO_UNCHANGED = &h0002
	const NDIS_RSS_PARAM_FLAG_ITABLE_UNCHANGED = &h0004
	const NDIS_RSS_PARAM_FLAG_HASH_KEY_UNCHANGED = &h0008
	const NDIS_RSS_PARAM_FLAG_DISABLE_RSS = &h0010
	const NDIS_RSS_INDIRECTION_TABLE_SIZE_REVISION_1 = 128
	const NDIS_RSS_HASH_SECRET_KEY_SIZE_REVISION_1 = 40
	const NDIS_RSS_INDIRECTION_TABLE_MAX_SIZE_REVISION_1 = 128
	const NDIS_RSS_HASH_SECRET_KEY_MAX_SIZE_REVISION_1 = 40
	const NDIS_RECEIVE_HASH_FLAG_ENABLE_HASH = &h00000001
	const NDIS_RECEIVE_HASH_FLAG_HASH_INFO_UNCHANGED = &h00000002
	const NDIS_RECEIVE_HASH_FLAG_HASH_KEY_UNCHANGED = &h00000004
	const NDIS_PORT_CHAR_USE_DEFAULT_AUTH_SETTINGS = &h00000001
	const NDIS_RECEIVE_SCALE_CAPABILITIES_REVISION_1 = 1
	const NDIS_RECEIVE_HASH_PARAMETERS_REVISION_1 = 1
	const NDIS_PORT_STATE_REVISION_1 = 1
	const NDIS_PORT_CHARACTERISTICS_REVISION_1 = 1
	const NDIS_PORT_ARRAY_REVISION_1 = 1
	const NDIS_RECEIVE_SCALE_PARAMETERS_REVISION_1 = 1
	#define NDIS_SIZEOF_RECEIVE_SCALE_CAPABILITIES_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_RECEIVE_SCALE_CAPABILITIES, NumberOfReceiveQueues)
	#define NDIS_SIZEOF_RECEIVE_SCALE_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_RECEIVE_SCALE_PARAMETERS, HashSecretKeyOffset)
	#define NDIS_SIZEOF_RECEIVE_HASH_PARAMETERS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_RECEIVE_HASH_PARAMETERS, HashSecretKeyOffset)
	#define NDIS_SIZEOF_PORT_STATE_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_PORT_STATE, Flags)
	#define NDIS_SIZEOF_PORT_CHARACTERISTICS_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_PORT_CHARACTERISTICS, RcvAuthorizationState)
	#define NDIS_SIZEOF_PORT_ARRAY_REVISION_1 RTL_SIZEOF_THROUGH_FIELD(NDIS_PORT_ARRAY, Ports)

	type _NDIS_RECEIVE_SCALE_CAPABILITIES
		Header as NDIS_OBJECT_HEADER
		CapabilitiesFlags as ULONG
		NumberOfInterruptMessages as ULONG
		NumberOfReceiveQueues as ULONG
	end type

	type NDIS_RECEIVE_SCALE_CAPABILITIES as _NDIS_RECEIVE_SCALE_CAPABILITIES
	type PNDIS_RECEIVE_SCALE_CAPABILITIES as _NDIS_RECEIVE_SCALE_CAPABILITIES ptr

	type _NDIS_RECEIVE_SCALE_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		Flags as USHORT
		BaseCpuNumber as USHORT
		HashInformation as ULONG
		IndirectionTableSize as USHORT
		IndirectionTableOffset as ULONG
		HashSecretKeySize as USHORT
		HashSecretKeyOffset as ULONG
	end type

	type NDIS_RECEIVE_SCALE_PARAMETERS as _NDIS_RECEIVE_SCALE_PARAMETERS
	type PNDIS_RECEIVE_SCALE_PARAMETERS as _NDIS_RECEIVE_SCALE_PARAMETERS ptr

	type _NDIS_RECEIVE_HASH_PARAMETERS
		Header as NDIS_OBJECT_HEADER
		Flags as ULONG
		HashInformation as ULONG
		HashSecretKeySize as USHORT
		HashSecretKeyOffset as ULONG
	end type

	type NDIS_RECEIVE_HASH_PARAMETERS as _NDIS_RECEIVE_HASH_PARAMETERS
	type PNDIS_RECEIVE_HASH_PARAMETERS as _NDIS_RECEIVE_HASH_PARAMETERS ptr

	type _NDIS_PROCESSOR_VENDOR as long
	enum
		NdisProcessorVendorUnknown
		NdisProcessorVendorGenuinIntel
		NdisProcessorVendorGenuineIntel = NdisProcessorVendorGenuinIntel
		NdisProcessorVendorAuthenticAMD
	end enum

	type NDIS_PROCESSOR_VENDOR as _NDIS_PROCESSOR_VENDOR
	type PNDIS_PROCESSOR_VENDOR as _NDIS_PROCESSOR_VENDOR ptr

	type _NDIS_PORT_STATE
		Header as NDIS_OBJECT_HEADER
		MediaConnectState as NDIS_MEDIA_CONNECT_STATE
		XmitLinkSpeed as ULONG64
		RcvLinkSpeed as ULONG64
		Direction as NET_IF_DIRECTION_TYPE
		SendControlState as NDIS_PORT_CONTROL_STATE
		RcvControlState as NDIS_PORT_CONTROL_STATE
		SendAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
		RcvAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
		Flags as ULONG
	end type

	type NDIS_PORT_STATE as _NDIS_PORT_STATE
	type PNDIS_PORT_STATE as _NDIS_PORT_STATE ptr

	type _NDIS_PORT_CHARACTERISTICS
		Header as NDIS_OBJECT_HEADER
		PortNumber as NDIS_PORT_NUMBER
		Flags as ULONG
		as NDIS_PORT_TYPE Type
		MediaConnectState as NDIS_MEDIA_CONNECT_STATE
		XmitLinkSpeed as ULONG64
		RcvLinkSpeed as ULONG64
		Direction as NET_IF_DIRECTION_TYPE
		SendControlState as NDIS_PORT_CONTROL_STATE
		RcvControlState as NDIS_PORT_CONTROL_STATE
		SendAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
		RcvAuthorizationState as NDIS_PORT_AUTHORIZATION_STATE
	end type

	type NDIS_PORT_CHARACTERISTICS as _NDIS_PORT_CHARACTERISTICS
	type PNDIS_PORT_CHARACTERISTICS as _NDIS_PORT_CHARACTERISTICS ptr
	type NDIS_PORT as _NDIS_PORT
	type PNDIS_PORT as _NDIS_PORT ptr

	type _NDIS_PORT
		Next as PNDIS_PORT
		NdisReserved as PVOID
		MiniportReserved as PVOID
		ProtocolReserved as PVOID
		PortCharacteristics as NDIS_PORT_CHARACTERISTICS
	end type

	type _NDIS_PORT_ARRAY
		Header as NDIS_OBJECT_HEADER
		NumberOfPorts as ULONG
		OffsetFirstPort as ULONG
		ElementSize as ULONG
		Ports(0 to 0) as NDIS_PORT_CHARACTERISTICS
	end type

	type NDIS_PORT_ARRAY as _NDIS_PORT_ARRAY
	type PNDIS_PORT_ARRAY as _NDIS_PORT_ARRAY ptr
#endif
