; GETPARM and PROMPTPARM: initialize by using values from
; command line or keyboard (the latter is for ROM mode)
; includes biostty, bios_xkey and bios_string :-)

GETPARM:		; get command line arguments: pretty simple,
        mov si,81h	; just grabs the first 1..8 digit it can find
        mov cx,word [ds:80h]
        xor ch,ch
        or cx,cx
        jz noparm
	xor ax,ax
	mov al,4	; default 9600 baud
	mov [linespeed],ax
parm:   lodsb
	cmp al,'?'
	jz wrongparm	; treat ? as wrong to trigger help message
        cmp al,'1'
        jb xparm
        cmp al,'8'
        jna selspeed
	and al,0xdf	; and not 0x20 -> upcase
	cmp al,'A'
	jb xparm
	cmp al,'D'
	ja xparm
selport:		; A..D selects port com1 .. com4
	push es
	mov bx,0x40
	mov es,bx
	sub al,'A'
	mov [comnum],ax	; 0..3, automatic fallback: while...(comnum--)
	mov bx,ax
	add bx,bx
	mov ax,[es:bx]	; i/o address of that port
	pop es
	or ax,ax	; not existing?
	jz wrongport	; no automatic fallback if a port was selected
			; by user (else, this is in term-irq.asm)
	jmp short xparm
selspeed:		; 1..8 selects speed
	sub al,'1'
	mov [linespeed],ax

xparm:
	; could handle ' ' and tab and / and - as legal and
	; the rest as wrong here...
	loop parm
noparm:	clc		; parameters were acceptable
        RET

wrongport:
	mov si, msg_wrongcom	; *offset*
	call bios_string	; illegal com port was selected
wrongparm:		; give help about use and command line
	mov si, msg_cmdline	; *offset*
	call bios_string	; show help
	stc		; parameters were problematic
	RET


; ######################################

PROMPTPARM:		; if started from ROM, get setup by
			; asking the user for it
	mov si, msg_askport
	call bios_string	; prompt for port
pp_rej1:
	call bios_xkey		; get key after flushing buffer
	cmp al,'1'
	jb pp_rej1
	cmp al,'4'
	ja pp_rej1
	call biostty		; echo
	sub al,'1'
	mov ah,0
	mov [comnum],ax
	mov si, msg_askspeed
	call bios_string	; prompt for speed
pp_rej2:
	call bios_xkey		; get key after flushing buffer
	cmp al,'1'
	jb pp_rej2
	cmp al,'8'
	ja pp_rej2
	call biostty		; echo
	sub al,'1'
	mov ah,0
	mov [linespeed],ax
	ret	

; ######################################

bios_string:
	cld
st_lp:	lodsb
	cmp al,1
	jz st_crlf	; 1 encodes CRLF
	jb st_done
st_lp2:	call biostty	; use bios to print text
	jmp short st_lp
st_crlf:
	mov al,13
	call biostty
	mov al,10
	jmp short st_lp2
st_done:
	ret

biostty:
	push ax
	push bx
	mov bx,7
	mov ah,0x0e	; TTY
	int 0x10	; BIOS - Video
	pop bx
	pop ax
	ret

bios_xkey:
	mov ah,1
	int 0x16		; key waiting ?
	jz xk_flushed
	mov ah,0
	int 0x16
	jmp short bios_xkey	; eat up keys until flushed
xk_flushed:
	mov ah,0
	int 0x16		; get a key
	ret
