;    LSPPP - DOS PPP Packet Driver
;    Copyright (C) 1997-2003  David Lindauer
;
;    This program is free software; you can redistribute it and/or modify
;    it under the terms of the GNU General Public License as published by
;    the Free Software Foundation; either version 2 of the License, or
;    (at your option) any later version.
;
;    This program is distributed in the hope that it will be useful,
;    but WITHOUT ANY WARRANTY; without even the implied warranty of
;    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;    GNU General Public License for more details.
;
;    You should have received a copy of the GNU General Public License
;    along with this program; if not, write to the Free Software
;    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
;
;    (for GNU General public license see file COPYING)
;
;    you may contact the author at:  mailto::camille@bluegrass.net
; 
;    or by snail mail at:
;
;    David Lindauer
;    850 Washburn Ave.  Apt #99
;    Louisville, KY 40222
;
include ppp.asi
include internet.asi

;
; BOOTP commands
;
BOOTREQ = 1
BOOTREP = 2
;
; UDP ports for BOOTP
;
BOOTP_SERVER = 67
BOOTP_CLIENT = 68
VM_RFC1048_low = 08263h
VM_RFC1048_HIGH = 06353h 
	public bootp_handler, GetNameServAddress
	public numservers, baseservers
	extrn listedprothandler : PROC, ipaddr : word, hisipaddr : word
	extrn netmask : dword, confbuf : byte, dns1 : dword, dns2 : dword
 
cgroup group tsr,config
assume	cs:cgroup
assume	ds:cgroup

TSR segment word public 'CODE'
bootresp label byte
theip	ip	<(IPVERSION shl 4) + 5,0,308,4,0,10,IPP_UDP,0,0,0>
theudp	udp	<BOOTP_SERVER,BOOTP_CLIENT,280,0>
thebootp bootp	<BOOTREP,HNT,6>
baseservers db 0
numservers db 0
servers	dd	10 DUP (?) ; safety margin, just in case...
;
; enter a name server into the list
;
GetNameservAddress proc
	mov	al,cs:[numservers]
	inc	cs:[numservers]
	sub	ah,ah
	mov	di,ax
	shl	di,1
	shl	di,1
	lea	di,[di+servers]
	ret
GetNameServAddress endp
;
;
; do a one's complement of the one's complement sum of the data
;
checksum PROC
	push	si
	sub	dx,dx		; result in bx
	shr	cx,1		; summing over words not bytes
csl:
	lodsw			; get a word
	xchg	al,ah		; correct for intel endianness
	add	dx,ax		; add it in
	adc	dx,0		; make it one's complement
	loop	csl		; and continue till done
	mov	ax,dx		; now get result to ax
	not	ax
	xchg	al,ah		; in network byte order
	pop	si
	ret
checksum ENDP
;
; send a bootp packet back so they know their IP address
;
bootp_handler PROC
	cmp	dx,IP_PROTOCOL		; see if is an IP packet
	jnz	bootpn			; exit if not
	cmp	[si].ip_prot,IPP_UDP	; is this a udp packet?
	jz	bootpc1			; continue checking for BOOTP if so
bootpn:
	clc
	ret
bootpc1:
	mov	bl,[si].ip_version	; skim past the header
	and	bx,0fh			;
	add	bx,bx
	add	bx,bx
	add	bx,si			
	lea	di,[bx+size udp]
	cmp	[bx].udp_source,BOOTP_CLIENT SHL 8; check for the BOOTP ports we need
	jnz	bootpn				; not valid BOOTP
	cmp	[bx].udp_dest,BOOTP_SERVER SHL 8
	jnz	bootpn				; not valid BOOTP
	cmp	[di].bp_op,BOOTREQ	; see if is bootreq
	jnz	bootpn
	push	cx
	push	si
	mov	[di].bp_op,BOOTREP; change it to a reply
	mov	ax,word ptr [di].bp_ciaddr
	mov	dx,word ptr [di].bp_ciaddr+2
	mov	word ptr [si].ip_dest , ax
	mov	word ptr [si].ip_dest +2, dx
	or	ax,dx
	jnz	knownaddress
	mov	ax,word ptr [ipaddr]		; else fill in their address
	mov	dx,word ptr [ipaddr+2]
	mov	word ptr [di].bp_yiaddr,ax	; now put it in
	mov	word ptr [di+2].bp_yiaddr,dx
	mov	word ptr [si].ip_dest , ax
	mov	word ptr [si+2].ip_dest, dx
knownaddress:
	mov	[bx].udp_source,BOOTP_SERVER SHL 8
	mov	[bx].udp_dest,BOOTP_CLIENT SHL 8

;
; fill in the remote address fields
;
	mov	ax,word ptr [hisipaddr]
	mov	dx,word ptr [hisipaddr+2]
	mov	word ptr [si].ip_source,ax
	mov	word ptr [si+2].ip_source,dx
	mov	word ptr [di].bp_siaddr,ax
	mov	word ptr [di+2].bp_siaddr,dx
	mov	word ptr [di].bp_giaddr,ax
	mov	word ptr [di+2].bp_giaddr,dx

	mov	[si].ip_chksum,0	; calculate IP checksum field
	mov	[bx].udp_checksum,0

	mov	cx,bx
	sub	cx,si
	call	checksum
	mov	word ptr [si].ip_chksum,ax
	; Put the net mask & DNS entries in the vendor field
	lea	di,[di].bp_vend		; get vendor field
	mov	ax,VM_RFC1048_LOW		; mark info there
	stosw
	mov	ax,VM_RFC1048_HIGH
	stosw

	mov	al,1				; type 1 - netmask
	stosb
	mov	al,4				; length 4
	stosb
	mov	si,offset cgroup:netmask
	movsw
	movsw

	mov	al,3				; gateway
	stosb
	mov	al,4
	stosb
	mov	si,offset cgroup:hisipaddr
	movsw
	movsw

	mov	cl,[numservers]
	or	cl,cl
	jz	nodns
	shl	cl,1
	shl	cl,1
	mov	si,offset cgroup:servers
	sub	ch,ch
	mov	al,6				; type 6 - DNS
	stosb
	mov	al,cl
	stosb
	rep	movsb
nodns:
	mov	al,0ffh				; end of parms
	stosb

	pop	si
	pop	cx
	mov	ax,IP_PROTOCOL
	call	listedprothandler
	stc
	ret

bootp_handler ENDP
TSR	ENDS
CONFIG	segment word public 'CODE'
CONFIG	ENDS
	end