DECLARE SUB SaveServers ()
DECLARE FUNCTION dlgAddServ$ (Question AS STRING)
DECLARE SUB ServerListBG ()
DECLARE SUB dlgServer ()
DECLARE SUB LoadServers ()
DECLARE FUNCTION dlgYesNo% (Question AS STRING, WinTitle AS STRING)
DECLARE FUNCTION MenuDCC% ()
DECLARE SUB UpdateStatusOnly ()
DECLARE SUB DoDCC ()
DECLARE SUB ResetDCC ()
DECLARE SUB AcceptDCC ()
DECLARE SUB OpenLogFile ()
DECLARE SUB CloseLogFile ()
DECLARE SUB SaveConfig ()
DECLARE SUB LogLine (logtext AS STRING)
DECLARE SUB DoBeep ()
DECLARE FUNCTION MenuFile% ()
DECLARE FUNCTION MenuOptions% ()
DECLARE SUB GetNewData (candraw AS INTEGER)
DECLARE SUB HelpDisplay (argument AS STRING)
DECLARE SUB ClearArgs ()
DECLARE SUB CloseConn (QuitMsg AS STRING)
DECLARE SUB SendLine (SendDat AS STRING)
DECLARE SUB ProcessIncoming (indata AS STRING)
DECLARE SUB DoQueue ()
DECLARE SUB Connect ()
DECLARE SUB CheckStatus ()
DECLARE SUB ProcessCommand ()
DECLARE SUB LoadConfig ()
DECLARE SUB Initialize ()
DECLARE SUB DoConfig ()
DECLARE FUNCTION GetInputLine$ ()
DECLARE SUB Terminate ()
DECLARE SUB ProcessLocal ()
DECLARE SUB UpdateLocal ()
DECLARE SUB ScrollBuffer ()
DECLARE SUB UpdateBar ()
DECLARE SUB DrawGUI ()
DECLARE SUB DrawScr (drawtype AS INTEGER)
TYPE Registers
     ax AS INTEGER
     bx AS INTEGER
     cx AS INTEGER
     dx AS INTEGER
     bp AS INTEGER
     si AS INTEGER
     di AS INTEGER
     flags AS INTEGER
     ds AS INTEGER
     es AS INTEGER
END TYPE

'Define custom data type for nTCP-related data.
TYPE nTCP
	Enabled AS INTEGER
	IntVector AS INTEGER
	ErrorCode AS INTEGER
	LocalIP AS LONG
	LocalNetmask AS LONG
	LocalGateway AS LONG
	LocalDNS AS LONG
	LocalDomain AS STRING * 256
	DomainLen AS INTEGER
	Timeserver AS LONG
	MTU AS INTEGER
	TTL AS INTEGER
	TOS AS INTEGER
	MSS AS INTEGER
	RWIN AS INTEGER
	FreeInputPkts AS INTEGER
	FreeOutputPkts AS INTEGER
	Timeout AS INTEGER
END TYPE

'Define custom type for DCC file offer data.
TYPE DCC
	FileName AS STRING * 128
	FileNameLen AS INTEGER
	FileSize AS LONG
	HostIP AS LONG
	HostPort AS INTEGER
	FromNick AS STRING * 128
	NickLen AS INTEGER
	CanAccept AS INTEGER
	Handle AS INTEGER
END TYPE

'Define custom error type constants and other frequently used values.
CONST errBadCall = 1
CONST errCritical = 2
CONST errNoHandles = 3
CONST errBadHandle = 4
CONST errTimeout = 5
CONST errBadSession = 6

CONST sckListening = 1
CONST sckOpen = 4
CONST sckClosed = 7

DECLARE FUNCTION Conv2IP$ (DWord AS LONG)
DECLARE FUNCTION Conv2DWord$ (inString AS STRING)
DECLARE FUNCTION HighByte% (Word AS INTEGER)
DECLARE FUNCTION LowByte% (Word AS INTEGER)

DECLARE FUNCTION tcpInit% (Vector AS INTEGER)
DECLARE FUNCTION tcpConnect% (RemoteIP AS STRING, RemotePort AS INTEGER)
DECLARE FUNCTION tcpStatus% (tcpHandle AS INTEGER)
DECLARE FUNCTION MakeReg% (h AS INTEGER, l AS INTEGER)
DECLARE FUNCTION tcpListen% (ListenPort AS INTEGER)
DECLARE SUB AddBuffer (textadd AS STRING)
DECLARE SUB DrawScreen ()
DECLARE SUB tcpUnload ()
DECLARE SUB tcpSetTimeout (TimeoutSeconds AS INTEGER)
DECLARE SUB RegBlank ()
DECLARE FUNCTION tcpGetData$ (tcpHandle AS INTEGER)
DECLARE SUB tcpClose (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpInBuffer% (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpInputQueue% (tcpHandle AS INTEGER)
DECLARE FUNCTION tcpRemoteIP$ (tcpHandle AS INTEGER)
DECLARE SUB tcpSendData (tcpHandle AS INTEGER, Data2Send AS STRING)
DECLARE SUB tcpDoIO ()
DECLARE SUB showErrorMsg ()

DECLARE SUB interruptx (intnum AS INTEGER, inreg AS Registers, outreg AS Registers)

'The debugShowReturn subroutine simply prints all the register values
'stored in tcpReturn to the screen. You really shouldn't have any reason
'to use it unless you are curious about the specifics behind NTCPDRV.
'It is mainly here for my own purposes.
DECLARE SUB debugShowReturn ()

DEFINT A-Z

'Dimension variables that are shared between all subroutines and functions.
DIM SHARED tcpCall AS Registers
DIM SHARED tcpReturn AS Registers
DIM SHARED tcpDriver AS nTCP
DIM SHARED isActive AS INTEGER
DIM SHARED strGetData AS STRING * 1024
DIM SHARED strSendData AS STRING * 300

DIM SHARED TitleBar AS STRING
DIM SHARED Buffer(1 TO 250) AS STRING * 160
DIM SHARED bufstart AS INTEGER
DIM SHARED MyNick AS STRING
DIM SHARED UserLine AS STRING
DIM SHARED ServerIP AS STRING
DIM SHARED ServerPort AS INTEGER
DIM SHARED lasttime AS STRING
DIM SHARED LocalIn AS STRING
DIM SHARED LogFile AS STRING
DIM SHARED hand%
DIM SHARED Query AS STRING
DIM SHARED qlen AS INTEGER
DIM SHARED newdata$
DIM SHARED Args(1 TO 128) AS STRING
DIM SHARED ScrChanged AS INTEGER
DIM SHARED Opt(1 TO 6) AS INTEGER
DIM SHARED DCCoffer AS DCC
DIM SHARED DCCsize AS LONG
DIM SHARED DCCbuff$
DIM SHARED Servers(1 TO 50, 1 TO 2) AS STRING
DIM SHARED ServTotal AS INTEGER
Opt(2) = 1
Opt(3) = 1
Opt(6) = 1

'This makes all CPU-blocking calls timeout after 5 seconds.
tcpSetTimeout 5

SCREEN 0: WIDTH 80, 25: COLOR 7, 0: CLS
ResetDCC
bufstart = 230
TitleBar = "Initializing leetIRC..."
DrawScr 1

AddBuffer "- Welcome to 0leetIRC v1.1 final"
AddBuffer "- Freeware by Mike Chambers, 2006"
AddBuffer "- Visit 9http://www.rubbermallet.org"
AddBuffer "-"

IF LEFT$(COMMAND$, 7) = "/CONFIG" THEN DoConfig

AddBuffer "- Reading 4LEETIRC.INI for configuration..."
DrawScr 0
OPEN "LEETIRC.INI" FOR BINARY AS #1: cfgsize = LOF(1): CLOSE #1
IF cfgsize = 0 THEN DoConfig
OPEN "LEETIRC.INI" FOR BINARY AS #1: cfgsize = LOF(1): CLOSE #1
IF cfgsize = 0 THEN
	AddBuffer "-"
	AddBuffer "- 0leetIRC cannot continue with a valid configuration!"
	Terminate
END IF

LoadConfig
AddBuffer "- Loading server list from 4SERVERS.INI"
LoadServers
Initialize
TitleBar = "leetIRC is ready for use"
UpdateBar

DO
	FOR process = 1 TO 2
	key$ = INKEY$
	SELECT CASE key$
		CASE "", CHR$(9), CHR$(10)
	       
		CASE CHR$(8)
			IF LEN(LocalIn) > 0 THEN LocalIn = LEFT$(LocalIn, LEN(LocalIn) - 1) ELSE DoBeep
		
		CASE CHR$(13)
			ProcessLocal
			LocalIn = ""

		CASE CHR$(27)
			LocalIn = ""

		CASE CHR$(0) + CHR$(46) 'Alt+C = Color
			IF LEN(LocalIn) < 256 THEN LocalIn = LocalIn + CHR$(3) ELSE DoBeep

		CASE CHR$(0) + CHR$(48) 'Alt+B = Bold
			IF LEN(LocalIn) < 256 THEN LocalIn = LocalIn + CHR$(2) ELSE DoBeep
	       
		CASE CHR$(0) + CHR$(33) 'Alt+F = File menu
			result% = MenuFile
			DrawScr 1

		CASE CHR$(0) + CHR$(24) 'Alt+O = Options menu
			result% = MenuOptions
			DrawScr 1

		CASE CHR$(0) + CHR$(32) 'Alt+D = DCC menu
			result% = MenuDCC
			DrawScr 1
	       
		CASE CHR$(0) + CHR$(81) 'PgDown
			oldstart = bufstart
			IF bufstart >= 230 THEN DoBeep
			bufstart = bufstart + 10
			IF bufstart > 230 THEN bufstart = 230
			IF bufstart <> oldstart THEN DrawScr 0

		CASE CHR$(0) + CHR$(73) 'PgUp
			oldstart = bufstart
			IF bufstart <= 1 THEN DoBeep
			bufstart = bufstart - 10
			IF bufstart < 1 THEN bufstart = 1
			IF bufstart <> oldstart THEN DrawScr 0

		CASE ELSE
			IF LEN(key$) = 1 AND LEN(LocalIn) < 256 THEN LocalIn = LocalIn + key$ ELSE DoBeep
	END SELECT

	UpdateBar
	IF key$ <> "" THEN UpdateLocal
	NEXT process
	CheckStatus

	IF DCCoffer.Handle <> -1 THEN
		DoDCC
		IF ScrChanged = 1 THEN DrawScr 0
	END IF

	'tcps% = tcpStatus(hand%)
	GetNewData 1
	'IF qlen > 0 THEN GOSUB DoQueue
       
LOOP

END

SUB AcceptDCC
tmpnick$ = LEFT$(DCCoffer.FromNick, DCCoffer.NickLen)
tmpfn$ = UCASE$(LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen))

origfn$ = tmpfn$
xp = INSTR(1, tmpfn$, "."): IF xp < 1 THEN xp = LEN(tmpfn$) + 1
len1 = xp - 1: IF len1 > 8 THEN len1 = 8
len2 = LEN(tmpfn$) - xp: IF len2 > 3 THEN len2 = 3
tmpext$ = MID$(tmpfn$, xp + 1, len2)
tmpfn$ = LEFT$(tmpfn$, len1)
IF tmpext$ <> "" THEN tmpfn$ = tmpfn$ + "." + tmpext$
DCCoffer.FileName = tmpfn$
DCCoffer.FileNameLen = LEN(tmpfn$)

AddBuffer "- 3Accepting 0DCC SEND3 offer of4 " + origfn$ + "3 from11 " + tmpnick$
IF tmpfn$ <> origfn$ THEN AddBuffer "- 3NOTE0:3 Filename has been truncated to4 " + tmpfn$
AddBuffer "- 3Attempting to connect to " + Conv2IP(DCCoffer.HostIP) + "0 :" + STR$(DCCoffer.HostPort) + " 3for DCC transfer."

DCCoffer.Handle = tcpConnect(Conv2IP(DCCoffer.HostIP), DCCoffer.HostPort)
IF tcpStatus(DCCoffer.Handle) = sckOpen THEN
	AddBuffer "- 3DCC transfer session successfully opened with0 " + Conv2IP(DCCoffer.HostIP)
	'Add file exist check here later!!!!!
	OPEN tmpfn$ FOR OUTPUT AS #50
	DCCoffer.CanAccept = 0
ELSE
	AddBuffer "- 4ERROR!3 Unable to connect to host for DCC transfer."
	ResetDCC
END IF
END SUB

SUB AddBuffer (Text AS STRING)
IF LEN(Text) > 256 THEN Text = LEFT$(Text, 256)

tmptext$ = ""
IF Opt(5) = 1 THEN
	tmphdr$ = "[" + TIME$ + "] "
	FOR nu = 1 TO LEN(tmphdr$)
		tmptext$ = tmptext$ + MID$(tmphdr$, nu, 1) + CHR$(7)
	NEXT nu
END IF
curcolor = 7
bold = 0
'IF Opt(3) = 1 THEN
	FOR tmpval = 1 TO LEN(Text)
		cc$ = MID$(Text, tmpval, 1)
		SELECT CASE cc$
			CASE CHR$(3)
				tmpclr$ = MID$(Text, tmpval + 1)
				IF LEN(tmpclr$) > 6 THEN last = 6 ELSE last = LEN(tmpclr$)
				FOR nu = 1 TO last
					ccval = ASC(MID$(tmpclr$, nu, 1))
					IF NOT (ccval = 44 OR (ccval >= 48 AND ccval <= 57)) THEN EXIT FOR
				NEXT nu
				tmpclr$ = LEFT$(tmpclr$, nu - 1)
				Text = LEFT$(Text, tmpval - 1) + MID$(Text, tmpval + nu - 1)
				xp = INSTR(1, tmpclr$, ","): IF xp < 1 THEN xp = LEN(tmpclr$) + 1
				IF tmpclr$ <> "" THEN
					IF Opt(3) = 1 THEN
						SELECT CASE VAL(LEFT$(tmpclr$, xp - 1))
							CASE 0: curcolor = 15
							CASE 1: curcolor = 0
							CASE 2: curcolor = 1
							CASE 3: curcolor = 2
							CASE 4: curcolor = 12
							CASE 5: curcolor = 4
							CASE 6: curcolor = 5
							CASE 7: curcolor = 6
							CASE 8: curcolor = 14
							CASE 9: curcolor = 10
							CASE 10: curcolor = 3
							CASE 11: curcolor = 11
							CASE 12: curcolor = 9
							CASE 13: curcolor = 13
							CASE 14: curcolor = 8
							CASE 15: curcolor = 7
						END SELECT
					ELSE
						curcolor = 7
					END IF
				ELSE
					curcolor = 7
				END IF

			CASE CHR$(2)
				IF bold = 1 THEN bold = 0 ELSE bold = 1
				IF bold = 1 THEN curcolor = 15 ELSE curcolor = 7
				IF Opt(3) = 0 THEN curcolor = 7

			CASE ELSE
				tmptext$ = tmptext$ + cc$ + CHR$(curcolor)
		END SELECT
		IF tmpval = LEN(Text) THEN EXIT FOR
	NEXT tmpval
'ELSE
'        FOR tmpval = 1 TO LEN(Text)
'                tmptext$ = tmptext$ + MID$(Text, tmpval, 1) + CHR$(7)
'        NEXT tmpval
'END IF

IF Opt(4) = 1 THEN LogLine "[" + TIME$ + " " + DATE$ + "] " + Text

DO UNTIL tmptext$ = ""
	ScrChanged = 1
	ScrollBuffer
	Buffer(250) = LEFT$(tmptext$ + STRING$(158, CHR$(0)), 158)
	tmptext$ = MID$(tmptext$, 159)
LOOP

IF bufstart < 230 THEN DoBeep
END SUB

SUB CheckStatus
IF tcps% = sckClosed THEN
	IF ServerIP <> "" THEN
		AddBuffer "- Server connection not established."
		DrawScr 0
		Query = ""
	END IF
	ServerIP = ""
END IF
END SUB

SUB ClearArgs
FOR tmp = 1 TO 128
	Args(tmp) = ""
NEXT tmp
END SUB

SUB CloseConn (QuitMsg AS STRING)
IF QuitMsg = "" THEN
	RANDOMIZE TIMER
	SELECT CASE INT(RND * 6)
		CASE 0: QuitMsg = "leetIRC v1.1 final - All the great taste, with half the carbs! http://www.rubbermallet.org"
		CASE 1: QuitMsg = "I'm too lazy to give a quit message."
		CASE 2: QuitMsg = "leetIRC v1.1 for DOS... putting the 1337 in obsolete!"
		CASE 3: QuitMsg = "leetIRC v1.1 for DOS... proving QuickBASIC is not useless. :)"
		CASE 4: QuitMsg = "Connection reset by head injury."
		CASE 5: QuitMsg = "leetIRC: It's better than getting hit with a sledgehammer!"
	END SELECT
END IF
SendLine "QUIT :" + QuitMsg
tcpClose hand%
AddBuffer "- 2You are now disconnected from0 " + ServerIP
ServerIP = ""
Query = ""
TitleBar = "leetIRC is ready for use"
END SUB

SUB CloseLogFile
CLOSE #10
END SUB

SUB Connect
tcpClose hand%
Query = ""
newdata$ = ""
AddBuffer "- Attempting to connect to0 " + ServerIP + STR$(ServerPort) + "..."
DrawScr 0
orig$ = ServerIP
hand% = tcpConnect(ServerIP, ServerPort)
ServerIP = orig$
tcps% = tcpStatus(hand%)
IF tcps% = sckOpen THEN
	AddBuffer "- Connection established!"
	AddBuffer "-"
	DrawScr 0
ELSE
	AddBuffer "- Unable to connect."
	ServerIP = ""
	EXIT SUB
END IF

SendLine "NICK :" + MyNick
SendLine "USER " + MyNick + " 0 0 :" + UserLine
END SUB

DEFSNG A-Z
FUNCTION Conv2DWord$ (inString AS STRING)
'The inString variable should be an IPv4 address in the standard
'format of x.x.x.x

DIM tempArray(3) AS STRING * 1
DIM tempVal AS INTEGER

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
	tempArray(0) = CHR$(VAL(LEFT$(inString, tempVal)))
	inString = MID$(inString, tempVal + 1)
ELSE
	EXIT FUNCTION
END IF

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
	tempArray(1) = CHR$(VAL(LEFT$(inString, tempVal)))
	inString = MID$(inString, tempVal + 1)
ELSE
	EXIT FUNCTION
END IF

tempVal = INSTR(1, inString, ".")
IF tempVal THEN
	tempArray(2) = CHR$(VAL(LEFT$(inString, tempVal)))
	inString = MID$(inString, tempVal + 1)
ELSE
	EXIT FUNCTION
END IF

tempArray(3) = CHR$(VAL(inString))
Conv2DWord$ = tempArray(0) + tempArray(1) + tempArray(2) + tempArray(3)
END FUNCTION

FUNCTION Conv2IP$ (DWord AS LONG)
DIM tempStr AS STRING * 4

tempStr = MKL$(DWord)
Conv2IP$ = MID$(STR$(ASC(LEFT$(tempStr, 1))), 2) + "." + MID$(STR$(ASC(MID$(tempStr, 2, 1))), 2) + "." + MID$(STR$(ASC(MID$(tempStr, 3, 1))), 2) + "." + MID$(STR$(ASC(RIGHT$(tempStr, 1))), 2)
END FUNCTION

SUB debugShowReturn
PRINT "   ax:" + STR$(tcpReturn.ax) + " (" + HEX$(tcpReturn.ax) + "h)"
PRINT "   bx:" + STR$(tcpReturn.bx) + " (" + HEX$(tcpReturn.bx) + "h)"
PRINT "   cx:" + STR$(tcpReturn.cx) + " (" + HEX$(tcpReturn.cx) + "h)"
PRINT "   dx:" + STR$(tcpReturn.dx) + " (" + HEX$(tcpReturn.dx) + "h)"
PRINT "   bp:" + STR$(tcpReturn.bp) + " (" + HEX$(tcpReturn.bp) + "h)"
PRINT "   si:" + STR$(tcpReturn.si) + " (" + HEX$(tcpReturn.si) + "h)"
PRINT "   di:" + STR$(tcpReturn.di) + " (" + HEX$(tcpReturn.di) + "h)"
PRINT "flags:" + STR$(tcpReturn.flags) + " (" + HEX$(tcpReturn.flags) + "h)"
PRINT "   ds:" + STR$(tcpReturn.ds) + " (" + HEX$(tcpReturn.ds) + "h)"
PRINT "   es:" + STR$(tcpReturn.es) + " (" + HEX$(tcpReturn.es) + "h)"
END SUB

DEFINT A-Z
FUNCTION dlgAddServ$ (Question AS STRING)
LOCATE 12, 5, 0: COLOR 15, 1
PRINT "͹ Add server " + STRING$(53, "") + "";
LOCATE 13, 5, 0: COLOR 15, 1
PRINT " " + LEFT$(Question + SPACE$(66), 66) + " ";
LOCATE 14, 5, 0
PRINT " "; : COLOR 7, 0: PRINT SPACE$(66); : COLOR 15, 1: PRINT " ";
LOCATE 15, 5, 0
PRINT "" + STRING$(68, "") + "";

COLOR 7, 0: LOCATE 14, 7, 1
indata$ = ""
lasttime$ = TIME$
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE "", CHR$(0), CHR$(9), CHR$(10)

		CASE CHR$(8)
			IF LEN(indata$) > 0 THEN indata$ = LEFT$(indata$, LEN(indata$) - 1)

		CASE CHR$(13)
			dlgAddServ$ = indata$
			EXIT FUNCTION

		CASE CHR$(27)
			EXIT FUNCTION

		CASE ELSE
			IF LEN(indata$) < 65 THEN indata$ = indata$ + key$
	END SELECT

	IF lasttime$ <> TIME$ THEN
		UpdateStatusOnly
		lasttime$ = TIME$
		IF key$ <> "" THEN key$ = CHR$(0)
	END IF
       
	IF key$ <> "" THEN
		LOCATE 14, 7, 0
		COLOR 7, 0
		PRINT LEFT$(indata$ + SPACE$(66), 66);
		LOCATE 14, 7 + LEN(indata$), 1
	END IF
	ServerListBG
LOOP
END FUNCTION

SUB dlgServer
DrawGUI
COLOR 15, 1: LOCATE 5, 1, 0
PRINT "͹ Server list " + STRING$(62, "") + "";
PRINT " Server description                                  IP address and port      ";
FOR tmpn = 1 TO 10
	PRINT " "; : COLOR 15, 0: PRINT SPACE$(76); : COLOR 15, 1: PRINT " ";
NEXT tmpn
PRINT "" + SPACE$(78) + "";
PRINT "" + SPACE$(78) + "";
PRINT "" + STRING$(78, "") + "";
LOCATE 18, 50, 0
COLOR 15, 4
PRINT " C"; : COLOR 7, 4: PRINT "onnect ";
LOCATE 18, 61: COLOR 15, 4
PRINT " A"; : COLOR 7, 4: PRINT "dd ";
LOCATE 18, 68: COLOR 15, 4
PRINT " D"; : COLOR 7, 4: PRINT "elete ";

cursel = 1
stlist = 1
firstrt = 1
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE CHR$(0) + CHR$(72) 'Up arrow
			cursel = cursel - 1
			IF cursel < 1 THEN cursel = 1
			IF cursel < stlist THEN stlist = cursel
	       
		CASE CHR$(0) + CHR$(80) 'Down arrow
			cursel = cursel + 1
			IF cursel > ServTotal THEN cursel = ServTotal
			IF cursel > stlist + 9 THEN stlist = stlist + 1

		CASE CHR$(0) + CHR$(30), "a", "A" 'Add
			newserv$ = dlgAddServ("Please enter the new server's IP followed by a space and the port:")
			newname$ = dlgAddServ("Please enter a description for the server entry:")
			IF newserv$ <> "" THEN
				FOR tmpv = ServTotal TO 1 STEP -1
					Servers(tmpv + 1, 1) = Servers(tmpv, 1)
					Servers(tmpv + 1, 2) = Servers(tmpv, 2)
				NEXT tmpv
				Servers(1, 1) = newname$
				Servers(1, 2) = newserv$
				ServTotal = ServTotal + 1
				SaveServers
				cursel = 1
				stlist = 1
			END IF

		CASE CHR$(0) + CHR$(32), "d", "D" 'Delete
			IF ServTotal > 0 THEN
				IF dlgYesNo("Are you sure you want to delete this entry?", "Confirm") = 1 THEN
					FOR tmpv = 1 TO ServTotal
						Servers(tmpv, 1) = Servers(tmpv + 1, 1)
						Servers(tmpv, 2) = Servers(tmpv + 1, 2)
					NEXT tmpv
					Servers(ServTotal, 1) = ""
					Servers(ServTotal, 2) = ""
					ServTotal = ServTotal - 1
					SaveServers
				END IF
			END IF

		CASE CHR$(13), CHR$(0) + CHR$(46), "c", "C" 'Connect
			IF ServTotal > 0 THEN
				orig$ = LocalIn
				LocalIn = "/SERVER " + Servers(cursel, 2)
				ProcessCommand
				LocalIn = orig$
				EXIT SUB
			END IF

		CASE CHR$(27) 'Escape
			EXIT SUB
	END SELECT
       
	IF firstrt = 1 THEN key$ = CHR$(0): firstrt = 0
	IF key$ <> "" THEN
		locpos = 7
		FOR tmpn = stlist TO stlist + 9
			LOCATE locpos, 3, 0
			IF tmpn = cursel THEN COLOR 15, 4 ELSE COLOR 7, 0
			tmpline$ = LEFT$(Servers(tmpn, 1) + SPACE$(52), 52) + LEFT$(Servers(tmpn, 2) + SPACE$(24), 24)
			PRINT tmpline$;
			locpos = locpos + 1
		NEXT tmpn
	END IF

	ServerListBG
	IF lasttime$ <> TIME$ THEN
		UpdateStatusOnly
		lasttime$ = TIME$
	END IF
LOOP
END SUB

FUNCTION dlgYesNo% (Question AS STRING, WinTitle AS STRING)
startloc = 38 - (LEN(Question) / 2)
IF WinTitle = "" THEN WinTitle = "leetIRC"
tbar$ = "͹ " + WinTitle + " " + STRING$((LEN(Question) + 4) - (7 + LEN(WinTitle)), "") + ""
LOCATE 11, startloc, 0: COLOR 15, 1: PRINT tbar$;
LOCATE 12, startloc: PRINT "" + SPACE$(LEN(Question) + 2) + "";
LOCATE 12, 40 - (LEN(Question) / 2)
PRINT Question;
LOCATE 13, startloc: PRINT "" + SPACE$(LEN(Question) + 2) + "";
LOCATE 14, startloc: PRINT "" + STRING$(LEN(Question) + 2, "") + "";
LOCATE 13, 34: COLOR 15, 4
PRINT " Y"; : COLOR 7, 4: PRINT "es ";
LOCATE 13, 41: COLOR 15, 4
PRINT " N"; : COLOR 7, 4: PRINT "o ";

DO
	SELECT CASE LCASE$(INKEY$)
		CASE ""

		CASE "y"
			LOCATE 13, 34: COLOR 15, 0
			PRINT " Y"; : COLOR 7, 0: PRINT "es ";
			dlgYesNo% = 1
			EXIT DO

		CASE "n"
			LOCATE 13, 41: COLOR 15, 0
			PRINT " N"; : COLOR 7, 0: PRINT "o ";
			dlgYesNo% = 0
			EXIT DO
	       
		CASE ELSE
			DoBeep
	END SELECT

	GetNewData 0
	IF ScrChanged = 1 THEN
		drawloc = 22
		DEF SEG = &HB800
		ScrChanged = 0
		FOR y = bufstart + 20 TO bufstart STEP -1
			tmpline$ = LEFT$(Buffer(y), 158)
			curpos = (drawloc * 160)
			IF drawloc < 10 OR drawloc > 13 THEN
				FOR tmpval = 1 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			ELSE
				endleft = (39 - ((LEN(Question) / 2) - 2)) * 2 - 8
				startright = (41 + (((LEN(Question) / 2) + 2))) * 2 - 2
				FOR tmpval = 1 TO 158
					IF tmpval <= endleft OR tmpval >= startright THEN
						POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
					END IF
				NEXT tmpval
			END IF
			drawloc = drawloc - 1
		NEXT y

		COLOR 0, 7
		curblock = ((bufstart / 230) * 20) + 1
		FOR y = 1 TO 21
			IF y < 9 OR y > 13 THEN
				LOCATE y + 2, 80, 0
				IF FIX(curblock) = y THEN PRINT "";  ELSE PRINT "";
			END IF
		NEXT y
	END IF

	IF DCCoffer.Handle <> -1 THEN DoDCC
	IF lasttime$ <> TIME$ THEN
		UpdateStatusOnly
		lasttime$ = TIME$
	END IF
LOOP
END FUNCTION

SUB DoBeep
IF Opt(2) = 1 THEN BEEP
END SUB

SUB DoConfig
AddBuffer "- This appears to be the first time you've run 0leetIRC."
AddBuffer "- You must answer some basic configuration questions before use!"
AddBuffer "-"
AddBuffer "- What would you like to use as your 0default nickname?"
DrawScr 0
MyNick = GetInputLine$
AddBuffer "- Using9 " + MyNick + " as your default nickname."
DrawScr 0

AddBuffer "-"
AddBuffer "- What would you like to use as your 0user info line?"
DrawScr 0
UserLine = GetInputLine$
AddBuffer "- Using9 " + UserLine + " as your user info line."
DrawScr 0

AddBuffer "-"
AddBuffer "- Please enter the hexadecimal value of the TCPDRV interrupt vector."
AddBuffer "- (If you are not sure, try11 61. This is usually correct.)"
DrawScr 0
tcpDriver.IntVector = VAL("&H" + GetInputLine$)
AddBuffer "- Using9 " + HEX$(tcpDriver.IntVector) + "h for the TCPDRV interrupt vector."

AddBuffer "-"
AddBuffer "- What file name would you like to save IRC logs to?"
AddBuffer "- NOTE: Logging can be toggled from the 0Options menu."
DrawScr 0
LogFile = GetInputLine$
IF LogFile = "" THEN LogFile = "IRCLOG.TXT"
AddBuffer "- Using4 " + LogFile + " as the log output file."

AddBuffer "-"
AddBuffer "- Please review the information you supplied."
DO
	IF dlgYesNo("Would you like to save the current configuration?", "") = 1 THEN
		DrawScr 0
		EXIT DO
	ELSE
		AddBuffer "-"
		AddBuffer "- Discarding new configuration data. It will not be saved."
		DrawScr 0
		EXIT SUB
	END IF
LOOP

AddBuffer "-"
AddBuffer "- Writing configuration data to 4LEETIRC.INI..."
DrawScr 0
SaveConfig
AddBuffer "- Configuration saved! You can now use 0leetIRC normally."
AddBuffer "-"
AddBuffer "- You can reconfigure the settings by starting 0leetIRC by using the"
AddBuffer "- command line option 0/CONFIG when starting this application."
AddBuffer "-"
DrawScr 0
END SUB

SUB DoDCC
SELECT CASE tcpStatus(DCCoffer.Handle)
	CASE 0, sckClosed
		AddBuffer "- 3DCC file transfer closed.0" + STR$(LOF(50)) + "3 bytes saved to4 " + LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen)
		CLOSE #50
		tcpClose DCCoffer.Handle
		ResetDCC
		ScrChanged = 1
		EXIT SUB
END SELECT

FOR iteration = 1 TO 3
	tcps% = tcpStatus(DCCoffer.Handle)
	waiting = tcpReturn.ax
	IF waiting > 0 THEN
		DCCbuff$ = DCCbuff$ + tcpGetData(DCCoffer.Handle)
		PRINT #50, DCCbuff$;
		DCCbuff$ = ""
		tmpreturn$ = MKL$(LOF(50))
		tmpreturn$ = RIGHT$(tmpreturn$, 1) + MID$(tmpreturn$, 3, 1) + MID$(tmpreturn$, 2, 1) + LEFT$(tmpreturn$, 1)
		tcpSendData DCCoffer.Handle, tmpreturn$
	END IF
NEXT iteration
END SUB

SUB DrawGUI
LOCATE 1, 1: COLOR 7, 1
tmpline$ = "   ile   ptions   CC"
tmpline$ = tmpline$ + SPACE$(66 - LEN(tmpline$)) + "leetIRC v1.1  "
PRINT tmpline$;

COLOR 15, 1
LOCATE 1, 3: PRINT "F";
LOCATE 1, 9: PRINT "O";
LOCATE 1, 18: PRINT "D";
UpdateBar
END SUB

SUB DrawScr (drawtype AS INTEGER)
IF drawtype = 1 THEN DrawGUI

COLOR 7, 0
drawloc = 22
DEF SEG = &HB800
ScrChanged = 0
FOR y = bufstart + 20 TO bufstart STEP -1
	tmpline$ = LEFT$(Buffer(y), 158)
	curpos = (drawloc * 160)
	FOR tmpval = 1 TO 158
		POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
	NEXT tmpval
	drawloc = drawloc - 1
NEXT y

COLOR 0, 7
curblock = ((bufstart / 230) * 20) + 1
FOR y = 1 TO 21
	LOCATE y + 2, 80, 0
	IF FIX(curblock) = y THEN PRINT "";  ELSE PRINT "";
NEXT y
END SUB

FUNCTION GetInputLine$
LocalIn = ""
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE "", CHR$(9), CHR$(10)
	      
		CASE CHR$(8)
			IF LEN(LocalIn) > 0 THEN LocalIn = LEFT$(LocalIn, LEN(LocalIn) - 1) ELSE DoBeep
	       
		CASE CHR$(13)
			IF LocalIn <> "" THEN
				GetInputLine$ = LocalIn
				LocalIn = ""
				UpdateLocal
				EXIT FUNCTION
			ELSE
				DoBeep
			END IF

		CASE CHR$(27)
			LocalIn = ""

		CASE ELSE
			IF LEN(key$) = 1 AND LEN(LocalIn) < 256 THEN LocalIn = LocalIn + key$ ELSE DoBeep
	END SELECT

	UpdateBar
	IF key$ <> "" THEN UpdateLocal

LOOP

END FUNCTION

SUB GetNewData (candraw AS INTEGER)
IF tcpStatus(hand%) <> sckOpen THEN EXIT SUB

newdata$ = newdata$ + tcpGetData(hand%)

dodraw = 0
DO UNTIL newdata$ = ""
	IF candraw = 1 THEN dodraw = 1
	xpos = INSTR(1, newdata$, CHR$(13))
	IF MID$(newdata$, xpos + 1, 1) = CHR$(10) THEN newdata$ = LEFT$(newdata$, xpos) + MID$(newdata$, xpos + 2)

	IF xpos < 1 THEN EXIT DO
	ProcessIncoming LEFT$(newdata$, xpos - 1)
	newdata$ = MID$(newdata$, xpos + 1)
LOOP
IF dodraw = 1 THEN DrawScr 0
END SUB

SUB HelpDisplay (argument AS STRING)
AddBuffer "-"
IF argument = "" THEN
	AddBuffer "- This is the 0leetIRC help display."
	AddBuffer "- 4Command list0: (Type 0/HELP <command> for extended help on something)"
	AddBuffer "- 0/HELP /SERVER /DISCONNECT /CLEAR /JOIN /PART /QUERY /MSG /ME /NICK"
	AddBuffer "  0/MODE /TOPIC /RAW /ACCEPT /STOPDCC /WHOIS /NAMES /LIST /QUIT"
	AddBuffer "-"
	AddBuffer "- Also, the 0Page Up and 0Page Down buttons will scroll through the buffered log."
	AddBuffer "- 0Alt+B inserts a BOLD marker. 0Alt+C inserts a COLOR marker. You need to type a"
	AddBuffer "- valid number from the mIRC color set after the color marker for it to work."
	AddBuffer "- 0Alt+F opens the file menu, 0Alt+O opens the options menu, and 0Alt+D"
	AddBuffer "- opens the DCC menu. The 0Escape button exits any drop down menu."
	AddBuffer "-"
	AddBuffer "- For 0leetIRC updates, visit 9http://www.rubbermallet.org"
	EXIT SUB
END IF

argument = UCASE$(argument)
IF LEFT$(argument, 1) = "/" THEN argument = MID$(argument, 2)
SELECT CASE argument
	CASE "HELP"
		AddBuffer "- Command help for 0/HELP"
		AddBuffer "  5Description0: Invokes internal help system. You can specify a command"
		AddBuffer "  after 0/HELP to see a more detailed description of it."
		AddBuffer "  5Syntax0: /HELP <command>"
       
	CASE "ACCEPT"
		AddBuffer "- Command help for 0/ACCEPT"
		AddBuffer "  5Description0: Accepts the most recently offered DCC file transfer."
		AddBuffer "  5Syntax0: /ACCEPT"

	CASE "STOP", "STOPDCC"
		AddBuffer "- Command help for 0/STOP and 0/STOPDCC"
		AddBuffer "  5Description0: Cancels any currently active DCC file transfer."
		AddBuffer "  5Syntax0: /STOP"

	CASE "SERVER"
		AddBuffer "- Command help for 0/SERVER"
		AddBuffer "  5Description0: Connect to a new server. You must specify the IP and"
		AddBuffer "  optionally, the port."
		AddBuffer "  5Syntax0: /SERVER [IP address] [Port]"

	CASE "MSG"
		AddBuffer "- Command help for 0/MSG"
		AddBuffer "  5Description0: Sends a message to a recipient other than the current query."
		AddBuffer "  5Syntax0: /MSG [Recipient] [Message]"
      
	CASE "ME"
		AddBuffer "- Command help for 0/ME"
		AddBuffer "  5Description0: Sends an action message to the current query focus."
		AddBuffer "  5Syntax0: /ME [Your action]"

	CASE "WHOIS"
		AddBuffer "- Command help for 0/WHOIS"
		AddBuffer "  5Description0: Requests information about a user from the server."
		AddBuffer "  5Syntax0: /WHOIS [User]"

	CASE "NAMES"
		AddBuffer "- Command help for 0/NAMES"
		AddBuffer "  5Description0: Lists all of the users in the specified channel."
		AddBuffer "  5Syntax0: /NAMES [Channel]"

	CASE "LIST"
		AddBuffer "- Command help for 0/LIST"
		AddBuffer "  5Description0: Get a channel list from the server. You can specify an"
		AddBuffer "  optional search string to see only channels containg it in their names."
		AddBuffer "  5Syntax0: /LIST [Search string]"

	CASE "TOPIC"
		AddBuffer "- Command help for 0/TOPIC"
		AddBuffer "  5Description0: Reads the topic from the channel you specify. You may also"
		AddBuffer "  follow the channel name with a new topic line to change it if you have"
		AddBuffer "  the permission to do so."
		AddBuffer "  5Syntax0: /TOPIC [Channel] [New topic line]"

	CASE "MODE"
		AddBuffer "- Command help for 0/MODE"
		AddBuffer "  5Description0: Allows you to set channel modes if you have permission."
		AddBuffer "  5Syntax0: /MODE [Channel] [Modes]"
      
	CASE "NICK"
		AddBuffer "- Command help for 0/NICK"
		AddBuffer "  5Description0: This will change your current nickname on a server."
		AddBuffer "  5Syntax0: /NICK [New nickname]"

	CASE "JOIN"
		AddBuffer "- Command help for 0/JOIN"
		AddBuffer "  5Description0: Attempts to join the specified channel on a server."
		AddBuffer "  5Syntax0: /JOIN [Channel]"

	CASE "PART"
		AddBuffer "- Command help for 0/PART"
		AddBuffer "  5Description0: Leave a channel you specify. If none, then leaves the"
		AddBuffer "  channel that currently has query focus."
		AddBuffer "  5Syntax0: /PART [Channel]"

	CASE "QUERY"
		AddBuffer "- Command help for 0/QUERY"
		AddBuffer "  5Description0: Change the query focus to a new user or channel. A query"
		AddBuffer "  focus determines what channel or user receives the messages you type."
		AddBuffer "  5Syntax0: /QUERY [Channel or user]"

	CASE "RAW"
		AddBuffer "- Command help for 0/RAW"
		AddBuffer "  5Description0: Sends a line you type to the server verbatim. This is"
		AddBuffer "  really just for debugging. Only use it if you have knowledge of the IRC"
		AddBuffer "  protocol."
		AddBuffer "  5Syntax0: /RAW [Line to send]"

	CASE "CLEAR"
		AddBuffer "- Command help for 0/CLEAR"
		AddBuffer "  5Description0: Completely clears the display memory and gives a fresh screen."
		AddBuffer "  5Syntax0: /CLEAR"

	CASE "DISCONNECT", "DISCON", "DIS"
		AddBuffer "- Command help for 0/DISCONNECT /DISCON and 0/DIS"
		AddBuffer "  5Description0: Disconnects from any currently connected server."
		AddBuffer "  5Syntax0: /DISCONNECT"

	CASE "QUIT"
		AddBuffer "- Command help for 0/QUIT"
		AddBuffer "  5Description0: Closes any current server connection and exits leetIRC."
		AddBuffer "  5Syntax0: /QUIT"

	CASE ELSE
		AddBuffer "- 4No extended help available for0 " + argument + "4."
END SELECT
END SUB

DEFSNG A-Z
FUNCTION HighByte% (Word AS INTEGER)
HighByte% = ASC(RIGHT$(MKI$(Word), 1))
END FUNCTION

DEFINT A-Z
SUB Initialize
AddBuffer "- Initializing TCPDRV at interrupt " + HEX$(tcpDriver.IntVector) + "h"
DrawScr 0
dummy% = tcpInit(tcpDriver.IntVector)

AddBuffer "- Using default nickname9 " + MyNick
AddBuffer "- Using default user line9 " + UserLine
AddBuffer "- Using log file4 " + LogFile
DrawScr 0
LogLine ""
LogLine "===[ LOG BEGINS AT " + TIME$ + " ON " + DATE$ + " ]=="

AddBuffer "- 0leetIRC is ready to use!"
AddBuffer "-"
AddBuffer "- Type 0/SERVER followed by the IP address of the server you want to use."
AddBuffer "- For an extended help screen with a full command list, just type 0/HELP"
DrawScr 0
END SUB

SUB LoadConfig
OPEN "LEETIRC.INI" FOR INPUT AS #1
LINE INPUT #1, MyNick
IF MyNick = "" THEN MyNick = "leetIRC_User"
LINE INPUT #1, UserLine
INPUT #1, tcpDriver.IntVector
LINE INPUT #1, LogFile
FOR tmpopt = 1 TO 6
	INPUT #1, Opt(tmpopt)
NEXT tmpopt
CLOSE #1
IF Opt(4) = 1 THEN OpenLogFile
AddBuffer "- 4LEETIRC.INI was successfully loaded."
END SUB

SUB LoadServers
OPEN "SERVERS.INI" FOR BINARY AS #2: tmpsz = LOF(2): CLOSE #2
IF tmpsz = 0 THEN
	AddBuffer "- 4SERVERS.INI does not exist!"
	KILL "SERVERS.INI"
	ServTotal = 0
	EXIT SUB
END IF
OPEN "SERVERS.INI" FOR INPUT AS #2
ServTotal = 0
DO UNTIL EOF(2)
	INPUT #2, Servers(ServTotal + 1, 2)
	IF EOF(2) THEN EXIT DO
	LINE INPUT #2, Servers(ServTotal + 1, 1)
	ServTotal = ServTotal + 1
LOOP
AddBuffer "- Loaded0" + STR$(ServTotal) + " server entries."
CLOSE #2
END SUB

SUB LogLine (logtext AS STRING)
IF Opt(4) = 1 THEN PRINT #10, logtext
END SUB

DEFSNG A-Z
FUNCTION LowByte% (Word AS INTEGER)
LowByte% = ASC(LEFT$(MKI$(Word), 1))
END FUNCTION

FUNCTION MakeReg% (h AS INTEGER, l AS INTEGER)
MakeReg% = CVI(CHR$(l) + CHR$(h))
END FUNCTION

DEFINT A-Z
FUNCTION MenuDCC%
IF DCCoffer.CanAccept = 1 THEN
	details$ = LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen) + " from " + LEFT$(DCCoffer.FromNick, DCCoffer.NickLen)
	IF LEN(details$) > 39 THEN details$ = LEFT$(details$, 36) + "..."
ELSE
	details$ = "<no current offer available>"
END IF

COLOR 15, 4: LOCATE 2, 17, 0: PRINT " Accept current offer                                   ";
COLOR 15, 1: LOCATE 3, 17, 0: PRINT " Abort current transfer                                 ";
COLOR 7, 1: LOCATE 4, 17, 0: PRINT "";
LOCATE 5, 17, 0: PRINT " Offer details: " + LEFT$(details$ + SPACE$(40), 40);
cursel = 1
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE CHR$(0) + CHR$(72) 'Up arrow
			cursel = cursel - 1
			IF cursel < 1 THEN cursel = 2
		       
		CASE CHR$(0) + CHR$(80) 'Down arrow
			cursel = cursel + 1
			IF cursel = 3 THEN cursel = 1
		       
		CASE CHR$(13)
			EXIT DO

		CASE CHR$(27)
		MenuDCC% = 0
		EXIT FUNCTION

	END SELECT

	IF DCCoffer.Handle <> -1 THEN DoDCC
	UpdateStatusOnly

	lastoffer$ = LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen) + LEFT$(DCCoffer.FromNick, DCCoffer.NickLen)
	GetNewData 0
	IF ScrChanged = 1 THEN
		drawloc = 22
		DEF SEG = &HB800
		ScrChanged = 0
		FOR y = bufstart + 20 TO bufstart STEP -1
			tmpline$ = LEFT$(Buffer(y), 158)
			curpos = (drawloc * 160)
			IF drawloc > 4 THEN
				FOR tmpval = 1 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			ELSE
				POKE curpos, ASC(MID$(tmpline$, 1, 1))
				POKE curpos + 1, ASC(MID$(tmpline$, 2, 1))
				FOR tmpval = 1 TO 34
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
				FOR tmpval = 145 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			END IF
			drawloc = drawloc - 1
		NEXT y

		COLOR 0, 7
		curblock = ((bufstart / 230) * 20) + 1
		FOR y = 1 TO 21
			LOCATE y + 2, 80, 0
			IF FIX(curblock) = y THEN PRINT "";  ELSE PRINT "";
		NEXT y
		key$ = CHR$(0)
	END IF
      
	newoffer$ = LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen) + LEFT$(DCCoffer.FromNick, DCCoffer.NickLen)
	IF lastoffer$ <> newoffer$ THEN key$ = CHR$(0)
	IF key$ <> "" THEN
		IF DCCoffer.CanAccept = 1 THEN
			details$ = LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen) + " from " + LEFT$(DCCoffer.FromNick, DCCoffer.NickLen)
			IF LEN(details$) > 39 THEN details$ = LEFT$(details$, 36) + "..."
		ELSE
			details$ = "<no current offer available>"
		END IF
	       
		IF cursel = 1 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 2, 17: PRINT " Accept current offer                                   ";
		IF cursel = 2 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 3, 17: PRINT " Abort current transfer                                 ";
		COLOR 15, 1: LOCATE 4, 17: PRINT "";
		COLOR 7, 1: LOCATE 5, 17: PRINT " Offer details: " + LEFT$(details$ + SPACE$(40), 40);

	END IF
LOOP

SELECT CASE cursel
	CASE 1
		orig$ = LocalIn
		LocalIn = "/ACCEPT"
		ProcessLocal
		LocalIn = orig$

	CASE 2
		orig$ = LocalIn
		LocalIn = "/STOP"
		ProcessLocal
		LocalIn = orig$
END SELECT
END FUNCTION

FUNCTION MenuFile%
COLOR 15, 4: LOCATE 2, 2, 0: PRINT " Server list... ";
COLOR 15, 1: LOCATE 3, 2, 0: PRINT " Manual connect ";
LOCATE 4, 2, 0: PRINT " Disconnect     ";
COLOR 7, 1: LOCATE 5, 2, 0: PRINT "";
COLOR 15, 1: LOCATE 6, 2, 0: PRINT " Exit to DOS    ";
cursel = 1
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE CHR$(0) + CHR$(72) 'Up arrow
			cursel = cursel - 1
			IF cursel < 1 THEN cursel = 5
			IF cursel = 4 THEN cursel = 3

		CASE CHR$(0) + CHR$(80) 'Down arrow
			cursel = cursel + 1
			IF cursel = 6 THEN cursel = 1
			IF cursel = 4 THEN cursel = 5

		CASE CHR$(13)
			EXIT DO

		CASE CHR$(27)
		MenuFile% = 0
		EXIT FUNCTION

	END SELECT

	IF DCCoffer.Handle <> -1 THEN DoDCC
	UpdateStatusOnly

	GetNewData 0
	IF ScrChanged = 1 THEN
		drawloc = 22
		DEF SEG = &HB800
		ScrChanged = 0
		FOR y = bufstart + 20 TO bufstart STEP -1
			tmpline$ = LEFT$(Buffer(y), 158)
			curpos = (drawloc * 160)
			IF drawloc > 5 THEN
				FOR tmpval = 1 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			ELSE
				POKE curpos, ASC(MID$(tmpline$, 1, 1))
				POKE curpos + 1, ASC(MID$(tmpline$, 2, 1))
				FOR tmpval = 35 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			END IF
			drawloc = drawloc - 1
		NEXT y

		COLOR 0, 7
		curblock = ((bufstart / 230) * 20) + 1
		FOR y = 1 TO 21
			LOCATE y + 2, 80, 0
			IF FIX(curblock) = y THEN PRINT "";  ELSE PRINT "";
		NEXT y
		key$ = CHR$(0)
	END IF
       
	IF key$ <> "" THEN
		IF cursel = 1 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 2, 2: PRINT " Server list... ";
		IF cursel = 2 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 3, 2: PRINT " Manual connect ";
		IF cursel = 3 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 4, 2: PRINT " Disconnect     ";
		COLOR 7, 1: LOCATE 5, 2: PRINT "";
		IF cursel = 5 THEN COLOR 15, 4 ELSE COLOR 15, 1
		LOCATE 6, 2: PRINT " Exit to DOS    ";

	END IF
LOOP

SELECT CASE cursel
	CASE 1
		DrawScr 1
		dlgServer

	CASE 2
		LocalIn = "/SERVER "

	CASE 3
		orig$ = LocalIn
		LocalIn = "/DISCONNECT"
		ProcessLocal
		LocalIn = orig$

	CASE 5
		DrawScr 1
		IF tcpStatus(hand%) = sckOpen THEN CloseConn ""
		Terminate
END SELECT
END FUNCTION

FUNCTION MenuOptions%
IF Opt(1) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
COLOR 15, 4: LOCATE 2, 8, 0: PRINT chk$ + " Auto-rejoin channel when kicked  ";
IF Opt(2) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
COLOR 15, 1: LOCATE 3, 8, 0: PRINT chk$ + " Allow PC speaker beeps           ";
IF Opt(3) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
LOCATE 4, 8, 0:              PRINT chk$ + " Decode mIRC color and bold codes ";
IF Opt(4) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
LOCATE 5, 8, 0:              PRINT chk$ + " Log to file                      ";
IF Opt(5) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
LOCATE 6, 8, 0:              PRINT chk$ + " Timestamp all events             ";
IF Opt(6) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
LOCATE 7, 8, 0:              PRINT chk$ + " Notify on server PING            ";

cursel = 1
DO
	key$ = INKEY$
	SELECT CASE key$
		CASE CHR$(0) + CHR$(72) 'Up arrow
			cursel = cursel - 1
			IF cursel < 1 THEN cursel = 6

		CASE CHR$(0) + CHR$(80) 'Down arrow
			cursel = cursel + 1
			IF cursel = 7 THEN cursel = 1

		CASE CHR$(13)
			EXIT DO

		CASE CHR$(27)
		MenuOptions% = 0
		EXIT FUNCTION

	END SELECT

	IF DCCoffer.Handle <> -1 THEN DoDCC
	UpdateStatusOnly

	GetNewData 0
	IF ScrChanged = 1 THEN
		drawloc = 22
		DEF SEG = &HB800
		ScrChanged = 0
		FOR y = bufstart + 20 TO bufstart STEP -1
			tmpline$ = LEFT$(Buffer(y), 158)
			curpos = (drawloc * 160)
			IF drawloc > 6 THEN
				FOR tmpval = 1 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			ELSE
				FOR tmpval = 1 TO 15
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			       
				FOR tmpval = 85 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			END IF
			drawloc = drawloc - 1
		NEXT y

		COLOR 0, 7
		curblock = ((bufstart / 230) * 20) + 1
		FOR y = 1 TO 21
			LOCATE y + 2, 80, 0
			IF FIX(curblock) = y THEN PRINT "";  ELSE PRINT "";
		NEXT y
		key$ = CHR$(0)
	END IF
      
	IF key$ <> "" THEN
		IF cursel = 1 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(1) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 2, 8: PRINT chk$ + " Auto-rejoin channel when kicked  ";
	       
		IF cursel = 2 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(2) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 3, 8: PRINT chk$ + " Allow PC speaker beeps           ";
	       
		IF cursel = 3 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(3) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 4, 8: PRINT chk$ + " Decode mIRC color and bold codes ";
	       
		IF cursel = 4 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(4) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 5, 8: PRINT chk$ + " Log to file                      ";

		IF cursel = 5 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(5) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 6, 8: PRINT chk$ + " Timestamp all events             ";
      
		IF cursel = 6 THEN COLOR 15, 4 ELSE COLOR 15, 1
		IF Opt(6) = 1 THEN chk$ = CHR$(251) ELSE chk$ = " "
		LOCATE 7, 8: PRINT chk$ + " Notify on server PING            ";
	END IF
LOOP

IF Opt(cursel) = 0 THEN Opt(cursel) = 1 ELSE Opt(cursel) = 0
IF cursel = 4 THEN
	IF Opt(4) = 1 THEN OpenLogFile ELSE CloseLogFile
END IF
END FUNCTION

SUB OpenLogFile
OPEN LogFile FOR APPEND AS #10
END SUB

SUB ProcessCommand
xp = INSTR(1, LocalIn, " "): IF xp < 1 THEN xp = LEN(LocalIn) + 1
cmd$ = UCASE$(LEFT$(LocalIn, xp - 1))
LocalIn = MID$(LocalIn, xp + 1)

fullarg$ = LocalIn

curarg = 0
DO UNTIL LocalIn = ""
	curarg = curarg + 1
	xp = INSTR(1, LocalIn, " "): IF xp < 1 THEN xp = LEN(LocalIn) + 1
	Args(curarg) = LEFT$(LocalIn, xp - 1)
	LocalIn = MID$(LocalIn, xp + 1)
LOOP

SELECT CASE cmd$
	CASE "/HELP", "/H", "/?"
		HelpDisplay Args(1)

	CASE "/ACCEPT"
		IF DCCoffer.CanAccept = 1 THEN
			AcceptDCC
		ELSE
			AddBuffer "- 3There is no current waiting 0DCC SEND3 offer."
		END IF

	CASE "/STOP", "/STOPDCC"
		IF DCCoffer.Handle <> -1 THEN
			tcpClose DCCoffer.Handle
			CLOSE #50
			AddBuffer "- 3You have aborted the DCC transfer of4 " + LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen)
			ResetDCC
		ELSE
			AddBuffer "- 3There is no active DCC session to stop."
		END IF

	CASE "/SERVER"
		IF curarg > 0 THEN
			ServerIP = Args(1)
			ServerPort = VAL(Args(2))
			IF ServerPort = 0 THEN ServerPort = 6667
			Connect
		ELSE
			AddBuffer "-"
			AddBuffer "- You must specify the server's IP. Optionally, also a space and the port."
		END IF

	CASE "/MSG"
		IF curarg > 0 THEN
			SendLine "PRIVMSG " + Args(1) + " :" + MID$(fullarg$, LEN(Args(1)) + 2)
			fullarg$ = MID$(fullarg$, LEN(Args(1)) + 2)
			AddBuffer "0<4" + Args(1) + "0:11" + MyNick + "0> " + fullarg$
		ELSE
			AddBuffer "- Unsufficient arguments for /MSG command."
		END IF

	CASE "/ME"
	       IF Query <> "" THEN
			SendLine "PRIVMSG " + Query + " :" + CHR$(1) + "ACTION " + fullarg$ + CHR$(1)
			AddBuffer "4" + Query + "0:11" + MyNick + "0 " + fullarg$
		ELSE
			AddBuffer "- Cannot send message. There is no query focus."
		END IF
       
	CASE "/WHOIS"
		IF curarg > 0 THEN
			SendLine "WHOIS " + fullarg$
		ELSE
			AddBuffer "- Insufficient arguments for /WHOIS command."
		END IF

	CASE "/NAMES"
		SendLine "NAMES " + fullarg$

	CASE "/LIST"
		IF fullarg$ = "" OR fullarg$ = "*" THEN
			IF dlgYesNo("A full channel list can take a while to receive. Are you sure?", "Channel list confirmation") = 1 THEN
				SendLine "LIST *"
			END IF
			DrawScr 0
		ELSE
			SendLine "LIST " + fullarg$
		END IF
		EXIT SUB

	CASE "/TOPIC"
		IF curarg > 0 THEN
			IF curarg < 2 THEN
				SendLine "TOPIC " + fullarg$
			ELSE
				tmparg$ = MID$(fullarg$, LEN(Args(1)) + 2)
				SendLine "TOPIC " + Args(1) + " :" + tmparg$
			END IF
		ELSE
			AddBuffer "- Unsufficient arguments for /TOPIC command."
		END IF

	CASE "/MODE"
		IF curarg > 0 THEN
			SendLine "MODE " + fullarg$
			AddBuffer "- 3You have set mode0:15 " + fullarg$
		ELSE
			AddBuffer "- Unsufficient arguments for /MODE command."
		END IF

	CASE "/NICK"
		IF MyNick = "" AND curarg > 0 THEN MyNick = Args(1)
		IF ServerIP <> "" THEN
			IF curarg > 0 THEN
				SendLine "NICK " + Args(1)
			ELSE
				AddBuffer "- 3You must specify a new nickname."
			END IF
		ELSE
			IF curarg > 0 THEN
				MyNick = Args(1)
				AddBuffer "- 3You are now known as11 " + MyNick
			ELSE
				AddBuffer "- 3You must specify a new nickname."
			END IF
		END IF

	CASE "/JOIN"
		IF curarg > 0 THEN
			SendLine "JOIN " + Args(1)
			AddBuffer "- 3Attempting to join channel4 " + Args(1)
		ELSE
			AddBuffer "- 3You must specify a channel to join."
		END IF
      
	CASE "/PART"
		IF curarg > 0 THEN
			SendLine "PART " + Args(1)
			AddBuffer "- 3Attempting to leave channel4 " + Args(1)
		ELSE
			IF Query <> "" THEN
				SendLine "PART " + Query
				AddBuffer "- 3Attempting to leave channel4 " + Query
			ELSE
				AddBuffer "- 3You must specify a channel to leave, or have a channel query focus."
			END IF
		END IF

	CASE "/QUERY"
		IF curarg > 0 THEN
			Query = Args(1)
			AddBuffer "- 3Changed query focus to4 " + Args(1)
		ELSE
			AddBuffer "- 3Changed query focus to4 <none>"
			Query = ""
		END IF

	CASE "/RAW"
		SendLine fullarg$

	CASE "/CLEAR"
		FOR tmpclr = 1 TO 250
			Buffer(tmpclr) = STRING$(160, CHR$(0))
		NEXT tmpclr

	CASE "/DIS", "/DISCON", "/DISCONNECT"
		CloseConn LocalIn

	CASE "/QUIT"
		IF tcpStatus(hand%) = sckOpen THEN CloseConn ""
		Terminate

	CASE ELSE
		AddBuffer "- Unrecognized command: 15" + CHR$(34) + cmd$ + CHR$(34) + ""
END SELECT
DrawScr 0
END SUB

SUB ProcessIncoming (indata AS STRING)
IF LEFT$(indata, 1) = ":" THEN indata = MID$(indata, 2)

fullarg$ = indata
curarg = 0
ClearArgs
DO UNTIL indata = ""
	curarg = curarg + 1
	xp = INSTR(1, indata, " "): IF xp < 1 THEN xp = LEN(indata) + 1
	Args(curarg) = LEFT$(indata, xp - 1)
	indata = MID$(indata, xp + 1)
LOOP

SELECT CASE UCASE$(Args(1))
	CASE "PING"
		SendLine fullarg$
		IF Opt(6) = 1 THEN AddBuffer "- 3Replied to server 11PING 3request."
		EXIT SUB
END SELECT

SELECT CASE UCASE$(Args(2))
	CASE "001"
		AddBuffer "0010 " + fullarg$
		DO UNTIL INSTR(1, fullarg$, " ") < 1
			xp = INSTR(1, fullarg$, " ")
			fullarg$ = MID$(fullarg$, xp + 1)
		LOOP
		xp = INSTR(1, fullarg$, "!")
		IF xp > 0 THEN fullarg$ = LEFT$(fullarg$, xp - 1)
		MyNick = fullarg$
		EXIT SUB

	CASE "332" 'TOPIC reply
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		AddBuffer "- 3The current topic in4 " + Args(4) + "3 is0:15 " + fullmsg$
		EXIT SUB
       
	CASE "333" 'TOPIC SET BY reply
		AddBuffer "- 3The topic in4 " + Args(4) + "3 was set by11 " + Args(5)
		EXIT SUB

	CASE "353" 'NAMES reply
		IF Args(4) = "=" THEN whichchan$ = Args(5) ELSE whichchan$ = Args(4)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		AddBuffer "- 3The following users are in4 " + whichchan$ + "0:11 " + fullmsg$
		EXIT SUB
       
	CASE "366" 'End of NAMES reply
		IF Args(4) = "=" THEN whichchan$ = Args(5) ELSE whichchan$ = Args(4)
		AddBuffer "- 3End of4 " + whichchan$ + "3 user list."
		EXIT SUB
	      
	CASE "433" 'Nickname in use
		AddBuffer "- 3Nickname already in use! You must supply a new one with the 0/NICK3 command."
		MyNick = ""
		EXIT SUB
       
	CASE "TOPIC"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		AddBuffer "-11 " + srcnick$ + " 3changes the topic in4 " + Args(3) + "3 to0:15 " + fullmsg$
		EXIT SUB

	CASE "QUIT"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LCASE$(srcnick$) = LCASE$(MyNick) THEN
			AddBuffer "- 3You have quit IRC. (Reason0:15 " + fullmsg$ + "3)"
			ServerIP = ""
			Query = ""
			tcpClose hand%
		ELSE
			AddBuffer "-11 " + srcnick$ + " 3has quit IRC. (Reason0:15 " + fullmsg$ + "3)"
		END IF
		EXIT SUB
       
	CASE "MODE"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		tmpline$ = "-11 " + srcnick$ + " 3has set mode:15"
		FOR tmpval = 3 TO curarg
			tmpline$ = tmpline$ + " " + Args(tmpval)
		NEXT tmpval
		AddBuffer tmpline$
		EXIT SUB

	CASE "NOTICE"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LCASE$(Args(3)) = LCASE$(MyNick) THEN
			AddBuffer "13PRIVATE NOTICE from11 " + srcnick$ + "0:15 " + fullmsg$
		ELSE
			AddBuffer "13NOTICE from11 " + srcnick$ + "13 to4 " + Args(3) + "0:15 " + fullmsg$
		END IF
		EXIT SUB

	CASE "PRIVMSG"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF UCASE$(LEFT$(fullmsg$, 7)) = CHR$(1) + "ACTION" THEN
			fullmsg$ = MID$(fullmsg$, 8)
			IF RIGHT$(fullmsg$, 1) = CHR$(1) THEN fullmsg$ = LEFT$(fullmsg$, LEN(fullmsg$) - 1)
			IF LCASE$(Args(3)) = LCASE$(MyNick) THEN
				AddBuffer "PM <- 11" + srcnick$ + "" + fullmsg$: EXIT SUB
			ELSE
				AddBuffer "4" + Args(3) + "0:11" + srcnick$ + "" + fullmsg$
			END IF
		ELSE
			IF LCASE$(Args(3)) = LCASE$(MyNick) THEN
				IF LEFT$(fullmsg$, 9) = CHR$(1) + "DCC SEND" THEN isdcc = 1 ELSE isdcc = 0
				IF isdcc = 0 THEN
					AddBuffer "PM <- 0<11" + srcnick$ + "0> " + fullmsg$
					EXIT SUB
				END IF
			      
				DCCreq$ = MID$(fullmsg$, 11)
				IF RIGHT$(DCCreq$, 1) = CHR$(1) THEN DCCreq$ = LEFT$(DCCreq$, LEN(DCCreq$) - 1)

				xp = INSTR(1, DCCreq$, " "): IF xp < 1 THEN dccerr = 1 ELSE dccerr = 0
				IF dccerr = 0 THEN DCCfn$ = LEFT$(DCCreq$, xp - 1): DCCreq$ = MID$(DCCreq$, xp + 1)
			     
				xp = INSTR(1, DCCreq$, " "): IF xp < 1 THEN dccerr = 1 ELSE dccerr = 0
				IF dccerr = 0 THEN
					first = FIX(VAL(LEFT$(DCCreq$, xp - 1)) / 16777215#)
					DCCip$ = MKL$(VAL(LEFT$(DCCreq$, xp - 1)) - 2147483648#)
					tmpip$ = CHR$(first) + MID$(DCCip$, 3, 1) + MID$(DCCip$, 2, 1) + LEFT$(DCCip$, 1)
					DCCip$ = Conv2IP(CVL(tmpip$))
					DCCreq$ = MID$(DCCreq$, xp + 1)
				END IF

				xp = INSTR(1, DCCreq$, " "): IF xp < 1 THEN dccerr = 1 ELSE dccerr = 0
				IF dccerr = 0 THEN DCCport% = VAL(LEFT$(DCCreq$, xp - 1)): DCCreq$ = MID$(DCCreq$, xp + 1)

				IF LEN(DCCreq$) > 0 THEN DCCsize = VAL(DCCreq$)

				IF dccerr = 0 AND DCCoffer.Handle = -1 THEN
					AddBuffer "- 0DCC SEND3 file transfer offered from 11" + srcnick$ + " (" + DCCip$ + ")"
					AddBuffer "- 0DCC SEND3 details0:4 " + UCASE$(DCCfn$) + " (" + MID$(STR$(DCCsize), 2) + " bytes)"
					AddBuffer "- 3To accept the file, type the command 0/ACCEPT"
				       
					DCCoffer.FileName = DCCfn$
					DCCoffer.FileNameLen = LEN(DCCfn$)
					DCCoffer.FileSize = DCCsize
					DCCoffer.HostIP = CVL(tmpip$)
					DCCoffer.HostPort = DCCport%
					DCCoffer.FromNick = srcnick$
					DCCoffer.NickLen = LEN(srcnick$)
					DCCoffer.CanAccept = 1
					DCCoffer.Handle = -1
				ELSE
					AddBuffer "- 4ERROR!3 Received a malformed 0DCC SEND3 offer from11 " + srcnick$
				END IF

				IF dccerr = 0 AND DCCoffer.Handle <> -1 THEN
					AddBuffer "- 0DCC SEND3 file transfer offered from 11" + srcnick$ + " (" + DCCip$ + ")"
					AddBuffer "- 0DCC SEND3 details0:4 " + UCASE$(DCCfn$) + " (" + MID$(STR$(DCCsize), 2) + " bytes)"
					AddBuffer "- 4ERROR!3 Unable to accept DCC offer, because a transfer is already open."
				END IF
			ELSE
				AddBuffer "0<4" + Args(3) + "0:11" + srcnick$ + "0> " + fullmsg$
			END IF
		END IF
		EXIT SUB

	CASE "JOIN"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LEFT$(fullmsg$, 1) = ":" THEN fullmsg$ = MID$(fullmsg$, 2)
		IF LCASE$(srcnick$) = LCASE$(MyNick) THEN
			AddBuffer "- 3You have joined channel4 " + fullmsg$
			AddBuffer "- 3Changing query focus to4 " + fullmsg$
			Query = fullmsg$
		ELSE
			AddBuffer "-11 " + srcnick$ + " 3has joined channel4 " + fullmsg$
		END IF
		EXIT SUB
      
	CASE "PONG"
		EXIT SUB

	CASE "PART"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LEFT$(fullmsg$, 1) = ":" THEN fullmsg$ = MID$(fullmsg$, 2)
		IF LCASE$(srcnick$) = LCASE$(MyNick) THEN
			AddBuffer "- 3You have left channel4 " + Args(3)
			AddBuffer "- 3Changing query focus to4 <none>"
			Query = ""
		ELSE
			AddBuffer "-11 " + srcnick$ + " 3has left channel4 " + Args(3)
		END IF
		EXIT SUB

	CASE "KICK"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LEFT$(fullmsg$, 1) = ":" THEN fullmsg$ = MID$(fullmsg$, 2)
		IF LCASE$(Args(4)) = LCASE$(MyNick) THEN
			AddBuffer "- 3You have been kicked from4 " + Args(3) + " 3by11 " + srcnick$ + " 3(Reason0:15 " + fullmsg$ + "3)"
			AddBuffer "- 3Changing query focus to4 <none>"
			Query = ""
			IF Opt(1) = 1 THEN
				AddBuffer "- 3Attempting to re-join4 " + Args(3)
				SendLine "JOIN " + Args(3)
			END IF
		ELSE
			AddBuffer "-11 " + Args(4) + " 3has been kicked from4 " + Args(3) + " 3by11 " + srcnick$ + " 3(Reason0:15 " + fullmsg$ + "3)"
		END IF
		EXIT SUB

	CASE "NICK"
		fullsrc$ = Args(1)
		xp = INSTR(1, fullsrc$, "!"): IF xp < 1 THEN xp = LEN(fullsrc$) + 1
		srcnick$ = LEFT$(fullsrc$, xp - 1)
		xp = INSTR(1, fullarg$, ":")
		fullmsg$ = MID$(fullarg$, xp + 1)
		IF LEFT$(fullmsg$, 1) = ":" THEN fullmsg$ = MID$(fullmsg$, 2)
		IF LCASE$(srcnick$) = LCASE$(MyNick) THEN
			AddBuffer "- 3You are now known as11 " + fullmsg$
			MyNick = fullmsg$
		ELSE
			AddBuffer "-11 " + srcnick$ + " 3is now known as11 " + fullmsg$
		END IF
		EXIT SUB
END SELECT

IF Args(2) = "" THEN AddBuffer fullarg$: EXIT SUB

IF VAL(Args(2)) >= 200 AND VAL(Args(2)) < 300 THEN
	xp = INSTR(1, fullarg$, ":")
	fullmsg$ = MID$(fullarg$, xp + 1)
	AddBuffer Args(2) + " 0" + fullmsg$
	EXIT SUB
END IF

IF VAL(Args(2)) < 200 OR VAL(Args(2)) >= 300 THEN
	cutlen = LEN(Args(1)) + LEN(Args(2)) + LEN(Args(3)) + 4
	fullmsg$ = MID$(fullarg$, cutlen)
	xp = INSTR(1, fullmsg$, ":")
	IF xp > 0 THEN fullmsg$ = LEFT$(fullmsg$, xp - 1) + MID$(fullmsg$, xp + 1)
	AddBuffer Args(2) + " 0" + fullmsg$
	EXIT SUB
END IF

AddBuffer fullarg$
END SUB

SUB ProcessLocal
IF LocalIn = "" THEN EXIT SUB
IF LEFT$(LocalIn, 1) = "/" THEN ClearArgs: ProcessCommand: EXIT SUB

IF ServerIP = "" THEN
	AddBuffer "- You are not connected to a server!"
ELSE
	IF Query <> "" THEN
		SendLine "PRIVMSG " + Query + " :" + LocalIn
		AddBuffer "0<4" + Query + "0:11" + MyNick + "0> " + LocalIn
	ELSE
		AddBuffer "- Cannot send message. There is no query focus."
	END IF
END IF

DrawScr 0
END SUB

DEFSNG A-Z
SUB RegBlank
tcpCall.ax = 0
tcpCall.bx = 0
tcpCall.cx = 0
tcpCall.dx = 0
tcpCall.bp = 0
tcpCall.si = 0
tcpCall.di = 0
tcpCall.flags = 0
tcpCall.ds = 0
tcpCall.es = 0
END SUB

DEFINT A-Z
SUB ResetDCC
DCCoffer.FileName = ""
DCCoffer.FileNameLen = 0
DCCoffer.FileSize = 0
DCCoffer.FromNick = ""
DCCoffer.NickLen = 0
DCCoffer.HostIP = 0
DCCoffer.HostPort = 0
DCCoffer.CanAccept = 0
DCCoffer.Handle = -1
END SUB

SUB SaveConfig
OPEN "LEETIRC.INI" FOR OUTPUT AS #1
PRINT #1, MyNick
PRINT #1, UserLine
PRINT #1, "&H" + HEX$(tcpDriver.IntVector)
PRINT #1, LogFile
FOR tmpopt = 1 TO 6
	PRINT #1, STR$(Opt(tmpopt))
NEXT tmpopt
CLOSE #1
END SUB

SUB SaveServers
OPEN "SERVERS.INI" FOR OUTPUT AS #2
FOR tmpn = 1 TO ServTotal
	PRINT #2, Servers(tmpn, 2) + "," + Servers(tmpn, 1)
NEXT tmpn
CLOSE #2
END SUB

SUB ScrollBuffer
FOR tmpval = 2 TO 250
	Buffer(tmpval - 1) = Buffer(tmpval)
NEXT tmpval
END SUB

SUB SendLine (SendDat AS STRING)
IF tcpStatus(hand%) <> sckOpen THEN ServerIP = "": Query = "": AddBuffer "- You are not connected to a server.": EXIT SUB
tcpSendData hand%, SendDat + CHR$(13) + CHR$(10)
END SUB

SUB ServerListBG
	IF DCCoffer.Handle <> -1 THEN DoDCC

	GetNewData 0
	IF ScrChanged = 1 THEN
		drawloc = 22
		DEF SEG = &HB800
		ScrChanged = 0
		FOR y = bufstart + 20 TO bufstart STEP -1
			tmpline$ = LEFT$(Buffer(y), 158)
			curpos = (drawloc * 160)
			IF drawloc < 4 OR drawloc > 18 THEN
				FOR tmpval = 1 TO 158
					POKE curpos + tmpval - 1, ASC(MID$(tmpline$, tmpval, 1))
				NEXT tmpval
			END IF
			drawloc = drawloc - 1
		NEXT y
	END IF
END SUB

DEFSNG A-Z
SUB showErrorMsg
PRINT "ERROR CODE" + STR$(tcpDriver.ErrorCode) + "!!! ";
SELECT CASE tcpDriver.ErrorCode
	CASE errBadCall
		PRINT "err_badcall"
	CASE errCritical
		PRINT "err_critical"
	CASE errNoHandles
		PRINT "err_nohandles"
	CASE errBadHandle
		PRINT "err_badhandle"
	CASE errTimeout
		PRINT "err_timeout"
	CASE errBadSession
		PRINT "err_badsession"
END SELECT
END SUB

SUB tcpClose (tcpHandle AS INTEGER)
tcpCall.ax = MakeReg(&H11, 1)
tcpCall.bx = tcpHandle
tcpCall.dx = 0

CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
tcpDoIO
END SUB

FUNCTION tcpConnect% (RemoteIP AS STRING, RemotePort AS INTEGER)
DIM tempRemoteIP AS STRING
tempRemoteIP = Conv2DWord(RemoteIP)

tcpCall.ax = MakeReg(&H10, 0)
tcpCall.bx = 0
tcpCall.cx = RemotePort
tcpCall.dx = tcpDriver.Timeout
tcpCall.di = CVI(LEFT$(tempRemoteIP, 2))
tcpCall.si = CVI(RIGHT$(tempRemoteIP, 2))
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

dummyLocalPortNr% = tcpReturn.ax
'PRINT "Local port:"; dummyLocalPortNr%

tcpConnect% = tcpReturn.bx 'Makes this function return the TCPDRV handle number.
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

SUB tcpDoIO
'Allows TCPDRV to perform processing of data. THIS MUST BE CALLED REGULARLY
'for packets to be processed! If you don't do this, TCPDRV will eventually
'crash when it runs out of storage space for input and output queues.

'RegBlank

tcpCall.ax = MakeReg(&H2, 0)
tcpCall.dx = 0 'tcpDriver.Timeout
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END SUB

FUNCTION tcpGetData$ (tcpHandle AS INTEGER)
tcpCall.ax = MakeReg(&H12, 1)
tcpCall.bx = tcpHandle
tcpCall.es = VARSEG(strGetData)
tcpCall.di = VARPTR(strGetData)
tcpCall.cx = 1024
tcpCall.dx = 0
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)
tcpGetData$ = LEFT$(strGetData, tcpReturn.ax)

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

FUNCTION tcpInBuffer% (tcpHandle AS INTEGER)
dummy1% = tcpStatus%(tcpHandle)
IF isActive > 0 THEN
	tcpInBuffer% = tcpReturn.ax
END IF
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

FUNCTION tcpInit% (Vector AS INTEGER)
'If given vector value is zero, assume the usual vector 61h.
IF Vector = 0 THEN Vector = &H61

tcpCall.ax = MakeReg(&H0, &HFF)
CALL interruptx(Vector, tcpCall, tcpReturn)

'This next line sets tcpDriver.Enabled to zero, sets the tcpInit function
'return value to zero, and exits the function immediately if the interrupt
'call did not return the expected value of zero for a functional TCPDRV
'vector at the specified segment.
IF tcpReturn.ax <> 0 THEN tcpDriver.Enabled = 0: tcpInit% = 0: EXIT FUNCTION

tcpInit% = 1
tcpDriver.Enabled = 1
tcpDriver.IntVector = Vector
DEF SEG = tcpReturn.es
offset = tcpReturn.di

'The following lines of code parse all of the network-related data
'from the pointer value returned by TCPDRV.
tcpDriver.LocalIP = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalNetmask = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalGateway = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.LocalDNS = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.Timeserver = CVL(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)) + CHR$(PEEK(offset + 2)) + CHR$(PEEK(offset + 3)))
offset = offset + 4

tcpDriver.MTU = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 2

tcpDriver.TTL = PEEK(offset)
tcpDriver.TOS = PEEK(offset + 1)
offset = offset + 4 'Skip two unused bytes after TTL and TOS data.

tcpDriver.MSS = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 2

tcpDriver.RWIN = CVI(CHR$(PEEK(offset)) + CHR$(PEEK(offset + 1)))
offset = offset + 4 'Skip two unused bytes after RWIN data.

'The following code segment gets the local domain string.
'TCPDRV allocates 256 bytes for this string, because that is the maximum
'allowed length of a domain name. If the string is shorter than 256 bytes,
'then TCPDRV fills the remainder of the string with ASCII code 255. The
'following code stops reading from the domain string as soon is it sees
'the first byte with a value of 255 for performance reasons.
DIM tempNum AS INTEGER
DIM tempCurByte AS STRING * 1
DIM tempStr AS STRING
FOR tempNum = offset TO offset + 255
	tempCurByte = CHR$(PEEK(tempNum))
	IF tempCurByte = CHR$(255) THEN
		tcpDriver.DomainLen = tempNum - offset
		tcpDriver.LocalDomain = tempStr
	ELSE
		tempStr = tempStr + tempCurByte
	END IF
NEXT tempNum

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

FUNCTION tcpListen% (ListenPort AS INTEGER)
tcpCall.ax = MakeReg(&H10, 1)
tcpCall.bx = ListenPort
tcpCall.cx = 0
tcpCall.dx = tcpDriver.Timeout
tcpCall.si = 0
tcpCall.di = 0
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpListen% = tcpReturn.bx
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END FUNCTION

DEFINT A-Z
FUNCTION tcpRemoteIP$ (tcpHandle AS INTEGER)
checkstat% = tcpStatus(tcpHandle)
IF checkstat% <> sckOpen THEN tcpRemoteIP$ = "0.0.0.0": EXIT FUNCTION

DEF SEG = tcpReturn.es
stateoffset = tcpReturn.di
ipdest$ = Conv2IP(CVL(CHR$(PEEK(stateoffset + 6)) + CHR$(PEEK(stateoffset + 7)) + CHR$(PEEK(stateoffset + 8)) + CHR$(PEEK(stateoffset + 9))))
'ipsrce$ = Conv2IP(CVL(CHR$(PEEK(stateoffset)) + CHR$(PEEK(stateoffset + 1)) + CHR$(PEEK(stateoffset + 2)) + CHR$(PEEK(stateoffset + 3))))

tcpRemoteIP$ = ipdest$
END FUNCTION

DEFSNG A-Z
SUB tcpSendData (tcpHandle AS INTEGER, Data2Send AS STRING)
strSendData = LEFT$(Data2Send, 300)

tcpCall.ax = MakeReg(&H13, 4)
tcpCall.bx = tcpHandle
tcpCall.es = INT(VARSEG(strSendData))
tcpCall.di = INT(VARPTR(strSendData))
tcpCall.cx = INT(LEN(Data2Send))
tcpCall.dx = tcpDriver.Timeout
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpDriver.ErrorCode = LowByte(tcpReturn.dx)

tcpDoIO
END SUB

SUB tcpSetTimeout (TimeoutSeconds AS INTEGER)
tcpDriver.Timeout = INT(TimeoutSeconds * 18.2)
END SUB

FUNCTION tcpStatus% (tcpHandle AS INTEGER)
tcpCall.ax = MakeReg(&H14, 0)
tcpCall.bx = tcpHandle
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

DEF SEG = tcpReturn.es
stateoffset = tcpReturn.di
ipsrce$ = Conv2IP(CVL(CHR$(PEEK(stateoffset)) + CHR$(PEEK(stateoffset + 1)) + CHR$(PEEK(stateoffset + 2)) + CHR$(PEEK(stateoffset + 3))))
ipdest$ = Conv2IP(CVL(CHR$(PEEK(stateoffset + 4)) + CHR$(PEEK(stateoffset + 5)) + CHR$(PEEK(stateoffset + 6)) + CHR$(PEEK(stateoffset + 7))))
ipprot% = PEEK(stateoffset + 8)
active% = PEEK(stateoffset + 9)
ifActive = active%
'PRINT "======================"
'PRINT "Debug: Status data return values for TCP handle"; tcpHandle
'PRINT
'PRINT "Error code:"; LowByte(tcpReturn.dx)
'PRINT "TCP state:"; HighByte(tcpReturn.dx)
'PRINT
'PRINT "Bytes available for reading:"; tcpReturn.ax
'PRINT "Bytes still being transmitted:"; tcpReturn.cx
'PRINT
'PRINT "Session info gathered from pointer" + STR$(tcpReturn.es) + ":" + MID$(STR$(tcpReturn.di), 2)
'PRINT "IP source: " + ipsrce$
'PRINT "IP dest: " + ipsrce$
'PRINT "IP prot:"; ipprot%
'PRINT "Active:"; active%
'PRINT "======================"
tcpStatus% = HighByte(tcpReturn.dx)
tcpDriver.ErrorCode = LowByte(tcpReturn.dx)
END FUNCTION

SUB tcpUnload
tcpCall.ax = MakeReg(&H1, 0)
CALL interruptx(tcpDriver.IntVector, tcpCall, tcpReturn)

tcpDriver.Enabled = 0
END SUB

DEFINT A-Z
SUB Terminate
IF ServerIP <> "" AND tcpStatus(hand%) = sckOpen THEN tcpClose hand%
IF DCCoffer.Handle <> -1 THEN tcpClose DCCoffer.Handle

LogLine "===[ LOG ENDING AT " + TIME$ + " ON " + DATE$ + " ]=="

IF dlgYesNo("Would you like to save the current configuration?", "") = 1 THEN
	DrawScr 0
	SaveConfig
	IF Opt(4) = 1 THEN CloseLogFile: Opt(4) = 0
	AddBuffer "- Configuration has been saved to 4LEETIRC.INI"
END IF

AddBuffer "- Dropping to DOS!"
DrawScr 0
COLOR 7, 0
LOCATE 25, 1: PRINT SPACE$(79);
LOCATE 24, 1
END
END SUB

SUB UpdateBar
IF TIME$ = lasttime THEN EXIT SUB
lasttime = TIME$

IF ServerIP <> "" THEN
	IF Query <> "" THEN tmpquery$ = Query ELSE tmpquery$ = "<none>"
	TitleBar = "Query focus: " + tmpquery$
END IF

IF LEN(TitleBar) > 78 THEN TitleBar = LEFT$(TitleBar, 75) + "..."
LOCATE 2, 1: COLOR 0, 7
PRINT " " + TitleBar + SPACE$(78 - LEN(TitleBar)) + CHR$(24);

UpdateStatusOnly
UpdateLocal
END SUB

SUB UpdateLocal
COLOR 7, 0
LOCATE 25, 1, 0
curpos = LEN(LocalIn) + 1
IF curpos > 80 THEN curpos = 80
PRINT LEFT$(RIGHT$(LocalIn, 79) + SPACE$(79), 79);
LOCATE 25, curpos, 1
END SUB

SUB UpdateStatusOnly
IF MyNick <> "" THEN tmpnick$ = MyNick ELSE tmpnick$ = "<no nick>"
IF ServerIP <> "" THEN tmpserv$ = ServerIP ELSE tmpserv$ = "<not connected>"

LOCATE 24, 1: COLOR 0, 7
tmpline$ = " " + tmpnick$ + " @ " + tmpserv$
PRINT LEFT$(tmpline$ + SPACE$(40), 40);

IF DCCoffer.Handle = -1 THEN
	tmpline$ = TIME$ + " on " + DATE$ + " " + CHR$(25)
ELSE
	IF DCCoffer.FileSize = 0 THEN totsize$ = " unknown" ELSE totsize$ = STR$(DCCoffer.FileSize)
	tmpline$ = "DCC: " + LEFT$(DCCoffer.FileName, DCCoffer.FileNameLen)
	tmpline$ = tmpline$ + " [" + MID$(STR$(LOF(50)), 2) + " /" + totsize$ + "]"
END IF

PRINT RIGHT$(SPACE$(40) + tmpline$, 40);
END SUB

