{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2000-2001 OpenXP-Team & Claus Faerber                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp_ntvdm.pas,v 1.9 2005/01/01 11:16:31 mw Exp $            }

Library xp_ntvdm;

uses windows,dos,strings;

const xp_ntvdm_version=$2;
      xp_simdisk=1234567890;

{ --- Imports from ntvdm.exe ------------------------------------ }

  procedure setEAX(para:ULONG);  external 'ntvdm.exe';   { function getEAX:ULONG; external 'ntvdm.exe'; }
{ procedure setAX(para:USHORT);  external 'ntvdm.exe'; } { function getAX:USHORT; external 'ntvdm.exe'; }
{ procedure setAL(para:UCHAR);   external 'ntvdm.exe'; } { function getAL:UCHAR;  external 'ntvdm.exe'; }
{ procedure setAH(para:UCHAR);   external 'ntvdm.exe'; } { function getAH:UCHAR;  external 'ntvdm.exe'; }

{ procedure setEBX(para:ULONG);  external 'ntvdm.exe'; } { function getEBX:ULONG; external 'ntvdm.exe'; }
{ procedure setBX(para:USHORT);  external 'ntvdm.exe'; } { function getBX:USHORT; external 'ntvdm.exe'; }
{ procedure setBL(para:UCHAR);   external 'ntvdm.exe'; } { function getBL:UCHAR;  external 'ntvdm.exe'; }
{ procedure setBH(para:UCHAR);   external 'ntvdm.exe'; } { function getBH:UCHAR;  external 'ntvdm.exe'; }

{ procedure setECX(para:ULONG);  external 'ntvdm.exe'; }   function getECX:ULONG; external 'ntvdm.exe';  
{ procedure setCX(para:USHORT);  external 'ntvdm.exe'; } { function getCX:USHORT; external 'ntvdm.exe'; }
{ procedure setCL(para:UCHAR);   external 'ntvdm.exe'; }   function getCL:UCHAR;  external 'ntvdm.exe';  
{ procedure setCH(para:UCHAR);   external 'ntvdm.exe'; }   function getCH:UCHAR;  external 'ntvdm.exe';  

{ procedure setEDX(para:ULONG);  external 'ntvdm.exe'; } { function getEDX:ULONG; external 'ntvdm.exe'; }
{ procedure setDX(para:USHORT);  external 'ntvdm.exe'; }   function getDX:USHORT; external 'ntvdm.exe';  
{ procedure setDH(para:UCHAR);   external 'ntvdm.exe'; } { function getDH:UCHAR;  external 'ntvdm.exe'; }
{ procedure setDL(para:UCHAR);   external 'ntvdm.exe'; } { function getDL:UCHAR;  external 'ntvdm.exe'; }

{ procedure setESP(para:ULONG);  external 'ntvdm.exe'; } { function getESP:ULONG; external 'ntvdm.exe'; }
{ procedure setSP(para:USHORT);  external 'ntvdm.exe'; } { function getSP:USHORT; external 'ntvdm.exe'; }

{ procedure setEBP(para:ULONG);  external 'ntvdm.exe'; } { function getEBP:ULONG; external 'ntvdm.exe'; }
{ procedure setBP(para:USHORT);  external 'ntvdm.exe'; } { function getBP:USHORT; external 'ntvdm.exe'; }

{ procedure setESI(para:ULONG);  external 'ntvdm.exe'; }   function getESI:ULONG; external 'ntvdm.exe';  
{ procedure setSI(para:USHORT);  external 'ntvdm.exe'; } { function getSI:USHORT; external 'ntvdm.exe'; }

{ procedure setEDI(para:ULONG);  external 'ntvdm.exe'; }   function getEDI:ULONG; external 'ntvdm.exe';  
{ procedure setDI(para:USHORT);  external 'ntvdm.exe'; } { function getDI:USHORT; external 'ntvdm.exe'; }

{ procedure setEIP(para:ULONG);  external 'ntvdm.exe'; } { function getEIP:ULONG; external 'ntvdm.exe'; }
{ procedure setIP(para:USHORT);  external 'ntvdm.exe'; } { function getIP:USHORT; external 'ntvdm.exe'; }

{ procedure setCS(para:USHORT);  external 'ntvdm.exe'; } { function getCS:USHORT; external 'ntvdm.exe'; }
{ procedure setSS(para:USHORT);  external 'ntvdm.exe'; } { function getSS:USHORT; external 'ntvdm.exe'; }
{ procedure setDS(para:USHORT);  external 'ntvdm.exe'; } { function getDS:USHORT; external 'ntvdm.exe'; }
{ procedure setES(para:USHORT);  external 'ntvdm.exe'; } { function getES:USHORT; external 'ntvdm.exe'; }
{ procedure setFS(para:USHORT);  external 'ntvdm.exe'; } { function getFS:USHORT; external 'ntvdm.exe'; }
{ procedure setGS(para:USHORT);  external 'ntvdm.exe'; } { function getGS:USHORT; external 'ntvdm.exe'; }

  procedure setCF(para:ULONG);   external 'ntvdm.exe';   { function getCF:ULONG;  external 'ntvdm.exe'; }
{ procedure setPF(para:ULONG);   external 'ntvdm.exe'; } { function getPF:ULONG;  external 'ntvdm.exe'; }
{ procedure setAF(para:ULONG);   external 'ntvdm.exe'; } { function getAF:ULONG;  external 'ntvdm.exe'; }
{ procedure setZF(para:ULONG);   external 'ntvdm.exe'; } { function getZF:ULONG;  external 'ntvdm.exe'; }
{ procedure setSF(para:ULONG);   external 'ntvdm.exe'; } { function getSF:ULONG;  external 'ntvdm.exe'; }
{ procedure setIF(para:ULONG);   external 'ntvdm.exe'; } { function getIF:ULONG;  external 'ntvdm.exe'; }

{ procedure setDF(para:ULONG);   external 'ntvdm.exe';  }
{ procedure setOF(para:ULONG);   external 'ntvdm.exe';  }
{ procedure setMSW(para:USHORT); external 'ntvdm.exe';  }

function  GetVDMAddress(Address,Size:ULONG; ProtectedMode:BOOL):Pointer; external 'ntvdm.exe' name 'MGetVdmPointer';
function  FreeVDMPointer(Address:ULONG; Size:USHORT; Buffer:Pointer; ProtectedMode:BOOL):BOOL; begin FreeVDMPointer := true; end;

{ --- Exact Windows Version ------------------------------------- }

procedure get_windows_version;
begin
  setEAX(GetVersion);
end;

{ --- Clipboard functions --------------------------------------- }

procedure clip_to_string;
var maxlen:  integer;
    len:     integer;
    i:	     integer;
    oneline: boolean;
    sp:      ^shortstring;
    ch:	     HANDLE;
    cp:	     PChar;
begin
  maxlen := getCL;
  oneline:= getCH<>0;
  sp := GetVDMAddress(GetEDI,maxlen,false);
  setCF(1);

  OpenClipboard(0);
  ch := GetClipboardData(CF_OEMTEXT); 
  if ch<> 0 then
  begin
    cp := GlobalLock(ch); 
    if cp <> nil then
    begin
      len := StrLen(cp);
      if len>255    then len:=255; 
      if len>maxlen then len:=maxlen;
      MoveMemory(PChar(Pointer(sp))+1,cp,len);
      sp^[0]:=Char(Byte(len));
    end;
    if oneline then 
      for i:=1 to len do
        if sp^[i]<#32 then
          sp^[i]:=#32;
    setCF(0);	  
    
    GlobalUnlock(ch);
  end;
  CloseClipboard;

  FreeVDMPointer(GetEDI,maxlen,sp,false);
end;

procedure mem_to_clip;
var 	cp: PChar;
	cl: ULONG;
	hm: HANDLE;
	pm: PChar;
begin
  cl := GetECX;
  cp := GetVDMAddress(GetESI,cl,false);

  SetCF(1);

  if OpenClipboard(0) then 
  begin
    hm := GlobalAlloc(GMEM_MOVEABLE,cl+1);
    if hm <> 0 then
    begin
      pm := GlobalLock(hm);
      if pm <> nil then
      begin
        MoveMemory(pm,cp,cl);
        (PChar(pm)+cl)^ := #0;
	GlobalUnLock(hm);

	EmptyClipboard;
        SetClipboardData(CF_OEMTEXT,hm);
	SetCF(0);
      end;
    end;
    CloseClipboard;
  end;
  
  FreeVDMPointer(GetESI,cl,cp,false);
end;

procedure clip_to_file;
var	fn: PChar;
	fh: Handle;
	ch: Handle;
	cp: LPTSTR;
	wr: DWORD;
begin
  fn:=GetVDMAddress(GetESI,$10000,false);
  setCF(1);

  OpenClipboard(0);
  ch := GetClipboardData(CF_OEMTEXT); 
  if ch<> 0 then
  begin
    cp := GlobalLock(ch); 
    if cp <> nil then
    begin
      fh:=CreateFile(fn,GENERIC_WRITE,0,0,CREATE_ALWAYS,
        FILE_FLAG_SEQUENTIAL_SCAN,0);
      if fh<>INVALID_HANDLE_VALUE then 
      begin
        WriteFile(fh,cp^,StrLen(cp),wr,0);
	CloseHandle(fh);
	setCF(0);
      end;
      GlobalUnlock(ch); 
    end;
  end;
  CloseClipboard;

  FreeVDMPointer(GetESI,0,fn,false);
end;

procedure file_to_clip;
var	fn: PChar;
	fh: Handle;
	ln: DWORD;
	mh: HANDLE;
	mp: PChar;
begin
  fn:=GetVDMAddress(GetESI,$10000,false);
  setCF(1);

  fh:=CreateFile(fn,GENERIC_READ,0,0,OPEN_EXISTING,
    FILE_FLAG_SEQUENTIAL_SCAN,0);
  if fh<>INVALID_HANDLE_VALUE then 
  begin
    ln := GetFileSize(fh,nil);
    mh := GlobalAlloc(GMEM_MOVEABLE,ln+1);
    if mh <> 0 then 
    begin
      mp := GlobalLock(mh);
      if mp <> nil then
      begin
        ReadFile(fh,mp^,ln,ln,nil);
        (PChar(mp)+ln)^ := #0;
	GlobalUnlock(mh);
        
	if OpenClipboard(0) then 
	begin
	  EmptyClipboard;
  	  SetClipboardData(CF_OEMTEXT,mh);
          CloseClipboard;
	end;
        setCF(0);
      end else
        GlobalFree(mh);
    CloseHandle(fh);
    end;
  end;

  FreeVDMPointer(GetESI,0,fn,false);
end;

{ --- Calls for DiskFree/DiskSize ------------------------------- }
procedure NTDiskFree;
var a:longint;
    b:integer; 
begin
  b:=GetCL;
  a:=(DiskFree(b) DIV 1048576);
  SetEAX(a); 
end;

procedure NTDiskSize;
var a:longint;
    b:integer;
begin
  b:=GetCL;
  a:=(DiskSize(b) DIV 1048576);
  SetEAX(a);
end;

procedure SimDisk;
begin
  SetEAX(xp_simdisk);
end;

{ --- NTDiskType ------------------------------------------------ }
procedure NTDiskType;
var p :pchar;
begin
  p:=Stralloc(4);
  StrPCopy(p,chr(GetCL+64)+':\');
  SetEAX(GetDriveTypeA(p));
end;

{ --- XP_NTVDM_VER ---------------------------------------------- }
procedure XP_NTVDM_VER;
begin
  SetEAX(xp_ntvdm_version);
end;

{ --- VDD calls ------------------------------------------------- }

procedure FREEXP_CALL; stdcall; export;
begin
  case getDX of
    {Versionsinfos}
    $0000: get_windows_version;
    $0001: XP_NTVDM_VER;
    {Clipboardfunktionen}
    $0101: clip_to_string;
    $0102: mem_to_clip;
    $0103: clip_to_file;
    $0104: file_to_clip;
    {Datentraegerfunktionen}
    $0200: NTDiskFree;
    $0201: NTDiskSize;
    $0202: SimDisk;
    $0203: NTDiskType;
  end;
end;  

procedure FREEXP_INIT; stdcall; export;
begin
end;

{ --- DLL exports ----------------------------------------------- }

exports FREEXP_INIT;
exports FREEXP_CALL;

end.

{
  $Log: xp_ntvdm.pas,v $
  Revision 1.9  2005/01/01 11:16:31  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.8  2004/01/09 16:18:59  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.7  2003/08/30 08:56:39  mw
  MW: - Fehler im letzten Commit korregiert.

  Revision 1.6  2003/08/30 08:42:49  mw
  MW: - Neue RAM-Disk-Erkennung fr WinNT eingebaut.
        Via XP_NTVDM.DLL (also Win32-API) wird jetzt festgestellt,
        ob es eine RAM-Disk ist.

  Revision 1.5  2003/08/18 07:30:57  mw
  MW: - Vervollstndigung von NTDiskFree/NTDiskSize
      - XP_NTVDM hat jetzt eine Revisionsnummer
      - Simdisk erlaubt Tests der Rechnereien zur schnen Anzeige
        der ermittelten Werte bei beliebig groen Platten
      - OPENXP_CALL/OPENXP_INIT heit jetzt FREEXP_CALL/FREEXP_INIT

  Revision 1.4  2003/08/17 22:19:18  mw
  MW: - neue Funktionen NTDiskFree/NTDiskSize (zeigen korrekte Diskettengre
        unter WinNT an).
        Achtung: Derzeit nur bis 64 GB und noch nich unbedingt korrekt
                 formatiert.

  Revision 1.3  2003/07/30 23:09:50  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.2  2003/06/25 17:29:56  tw
  auto-de-branching

  Revision 1.1.2.8  2003/03/01 16:55:59  cl
  - fixed last commit

  Revision 1.1.2.7  2003/03/01 16:28:46  cl
  - next try for xp_ntvdm.dll

  Revision 1.1.2.6  2002/04/12 14:52:07  cl
  - removed sysutils unit

  Revision 1.1.2.5  2002/04/12 14:50:11  cl
  - fixed GetVDMAddress
  - fixed mem_to_clip (called by String2Clip)

  Revision 1.1.2.4  2001/07/18 20:13:19  cl
  - removed unnecessary imports from NTVDM.EXE

  Revision 1.1.2.3  2001/07/04 01:33:12  my
  - changed ANSI-Umlaut to ASCII-Umlaut (please no ANSI, guys :-))

  Revision 1.1.2.2  2001/07/02 21:11:09  mk
  - removed unused units

  Revision 1.1.2.1  2001/07/02 20:43:04  mk
  - NTVDM Interface
}  
