{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 1991-1999 Peter Mandrella                                   }
{ (c) 2000-2001 OpenXP-Team                                       }
{ (c) 2002-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: xp5.pas,v 1.59 2005/01/01 11:16:30 mw Exp $ }

{ CrossPoint - Utilities }

{$I XPDEFINE.INC }
{$O+,F+,E+,N+}

unit xp5;

interface

uses
  crt, dos,xpglobal,typeform,fileio,inout,keys,winxp,montage,feiertag,
  video,datadef,database,maus2,maske,clip,resource,
  ems,xms,overxms, xp0,xp1,xp1input,xp1o,xp1o2, lfn;

procedure kalender;
procedure memstat;
procedure fragstat;
procedure scsaver;
procedure scsescape;
procedure TimedScsaver(endtime:datetimest);
procedure DatabaseStat;
procedure ScreenShot;
procedure xp32welcome;

function  TestPassword(main,edit:boolean):boolean;
procedure EditPassword;
function  Password:boolean;
procedure InitPWsystem;

function reorgdate:datetimest;
function timingdate(s1:string):datetimest;

implementation  {-----------------------------------------------------}

uses xpovl;

function timingdate(s1:string):datetimest;
var t   : text;
    s   : string;
    fnd : boolean;
begin
  timingdate:='';
  fnd:=false;
  assign(t,timingdat);
  reset(t);
  if ioresult<>0 then exit;
  repeat 
    readln(t,s);
    if pos(s1,s)>0 then fnd:=true;
  until eof(t) or fnd;
  close(t); 
  if fnd then
  asm 
    xor si,si
@1: inc si
    cmp byte ptr s[si],'='
    jne @1
    les di,@result
    mov al,10
    stosb 
    mov ax,word ptr s[si+7]
    stosw
    mov ax,word ptr s[si+4]
    stosw
    mov ax,word ptr s[si+1]
    stosw
    mov ax,word ptr s[si+10]
    stosw
    mov ax,word ptr s[si+13]
    stosw
    end;  
end; 


function reorgdate:datetimest;
begin
  reorgdate:=timingdate('REORG=');
end;

procedure kalender;

const rx = 42;
      ry = 8;


      cal_active : boolean = false;
      maxfeier   = 50;
      maxcalendar = 4781;
      { Erweiterung durch MW 02/2004:}
      { Der Gregorianische Kalender  }
      { mu erst im Jahr 4782        }
      { korrigiert werden.           } 

var   nt,n,mnt,
      xjj,xmm,xtt : integer;
      z           : taste;
      y,m,d,w     : rtlword;
      lm,lj       : word;
      jj,mm,tt    : word;
      di          : string[6];
      code        : integer;

      cal         : string[15];
      feier       : array[1..maxfeier] of fdate;
      feieranz    : integer;


  procedure ReadFeier;
  var t : text;
      s : string;
      j : word;
  begin
    assign(t,feierDat);
    feieranz:=0;
    if existf(t) then begin
      reset(t);
      while not eof(t) and (feieranz<maxfeier) do begin
        readln(t,s);
        if (s<>'') and (firstchar(s)<>'#') then begin
          inc(feieranz);
          feier[feieranz].t:=ival(left(s,2));
          feier[feieranz].m:=ival(copy(s,4,2));
          j:=ival(copy(s,7,4));
          if j<80 then feier[feieranz].j:=j+2000
          else feier[feieranz].j:=j+1900;
          end;
        end;
      close(t);
      end;
  end;

  function IsFeierdattag(fd:fdate):boolean;
  var i : integer;
  begin
    i:=1;
    while (i<=feieranz) and (longint(fd)<>longint(feier[i])) do
      inc(i);
    IsFeierdattag:=(i<=feieranz);
  end;

  procedure disp_kal;
  var i,j, le: integer;
      fd : fdate;
  begin
    j:=0; le:=ry+4;
    clwin(rx+3,rx+30,ry+5,ry+10);
    nt:=mnt;
    attrtxt(col.colutility);
    moff;
    wrt(rx+2,ry+11,dup(10,''));
    while j<n do begin
      le:=le+1;
      for i:=nt to 7 do begin
        j:=succ(j);
        normtxt;
        fd.t:=j; fd.m:=mm; fd.j:=jj;
        if (j<=n) and
           ((i=7) or ((jj>1990) and ((autofeier and IsFeiertag(fd)) or
                                     IsFeierdattag(fd)))) then
          attrtxt(col.colutihigh)
        else
          attrtxt(col.colutility);
        if (jj=y) and (mm=m) and (j=d) then attrtxt(col.colutiinv);
        gotoxy(pred(rx)+i shl 2,le);
        {Erweiterung des Xp-Kalenders auf die Jahre}
        {vor 1583 also auf die Verwendung des}
        {Julianischen Kalenders}
        {Erweiterung durch MW 01/2000}
        if (fd.t>4) and (fd.t<15) and (fd.m=10) and (fd.j=1582) then
           begin
             j:=j+10;        
             write(j:2);
           end
        else
          begin
             if j>n then write('  ') else write(j:2);
          end;               { }
        end;
      nt:=1;
      end;
    mon;
  end;

  procedure maus_bearbeiten(var t:taste);
  var xx,yy  : integer;
      inside : boolean;
      d      : array[0..3] of integer;
      i,p,dd : integer;

    function dist(x,y:integer):integer;
    begin
      dist:=system.round(sqrt(sqr(x-xx)+sqr(y-yy)));
    end;

  begin
    maus_gettext(xx,yy);
    inside:=(xx>=rx) and (xx<=rx+31) and (yy>=ry) and (yy<=ry+11);
    if t=mausunright then
      t:=keyesc
    else if (t=mausunleft) and not inside then
      t:=keyesc
    else if inside and ((t=mausleft) or (t=mausldouble)) then begin
      d[0]:=dist(rx+16,ry);
      d[1]:=dist(rx+16,ry+11);
      d[2]:=dist(rx,ry+6);
      d[3]:=dist(rx+31,ry+11);
      p:=0; dd:=d[0];
      for i:=1 to 3 do
        if d[i]<dd then begin
          p:=i; dd:=d[i];
          end;
      case p of
        0 : t:=keyup;
        1 : t:=keydown;
        2 : t:=keyleft;
        3 : t:=keyrght;
      end;
      end;
  end;

function key2str(h:taste):string;
  begin
   key2str:='';
   if h=key0 then key2str:='0';     {Codewandlungen von Keystring nach String}
   if h=key1 then key2str:='1';
   if h=key2 then key2str:='2';
   if h=key3 then key2str:='3';
   if h=key4 then key2str:='4';
   if h=key5 then key2str:='5';
   if h=key6 then key2str:='6';
   if h=key7 then key2str:='7';
   if h=key8 then key2str:='8';
   if h=key9 then key2str:='9';
  end;

begin
  if cal_active then exit;
  cal_active:=true;
  pushhp(65);
  getdate(y,m,d,w);
  jj:=y; mm:=m; tt:=1;
  utilbox(rx,rx+31,ry,ry+11,'');
  ReadFeier;

  attrtxt(col.colutility);
  moff;
  wrt(rx,ry+2,''+dup(30,'')+'');
  gotoxy(rx+3,ry+3); write(getres2(501,1));   { 'Mo  Di  Mi  Do  Fr  Sa  ' }
  attrtxt(col.colutihigh); write(getres2(501,2));  { 'So' }
  attrtxt(col.colutility);
  mon;
  cal:=getres2(501,3);     { '    Kalender' }
  freeres;
  lm:=0; lj:=0;
  repeat
    if (lm<>mm) or (lj<>jj) then begin
      attrtxt(col.colutihigh);
      moff;
      gotoxy(rx+4,ry+1); write(cal,' ',mm:2,'/',jj:4);
      {Erweitert fr Jahre kleiner 1000 durch MW 01/2000}
      mon;
      attrtxt(col.colutility);

{   Algorithmus zur Wochentagberechnung nach DOS 11/87, S. 86   }

      xmm:=mm; xtt:=tt; xjj:=jj;
      if xmm<3 then begin
        xmm:=xmm+12;
        xjj:=pred(xjj);
        end;
      nt:=(((xtt+(13*xmm+3)div 5+(5*xjj)shr 2-
          (xjj div 100)+xjj div 400)+1)mod 7);
      {MW 01/2000 Begin Korrekturcode fr Julianischen Kalender}
      if ((jj<1582) or ((jj=1582) and (mm<11))) then begin
       nt:=(nt+5) mod 7;
       nt:=(nt+((jj div 100)-(jj div 400))) mod 7;
       if (jj mod 100=0) and not (jj mod 400=0) and ((mm=1) or (mm=2)) then nt:=(nt+6) mod 7;
      end;
      {MW 01/2000 Ende Korrekturcode}

      if nt=0 then nt:=7;

      n:=monat[mm].zahl;
      if (mm=2) then
        if ((jj and 3=0) and ((jj mod 100>0) or (jj mod 400=0))) and (jj>1583) then
          n:=29
        else n:=28;
        if ((jj and 3=0) and (jj<=1582)) and (mm=2) then n:=29; {Ergnzung durch MW 01/2000}
      mnt:=nt;
      disp_kal;                         { Kalender anzeigen }
      lm:=mm; lj:=jj;
      end;

    get(z,curoff);
    if (z>=mausfirstkey) and (z<=mauslastkey) then
      maus_bearbeiten(z);
    if z=keyup then
      jj:=min(maxcalendar,succ(jj))  {Erweiterung von 2999 auf 3000 von MW 01/2000}
    else if z=keydown then
      jj:=max(1,jj-1)         {Erweiterung von 1583 auf 1 von MW 01/2000}
    else if z=keypgup then    {Sprung um 10 Jahre mittels Bild hoch}
      jj:=min(maxcalendar,jj+10)     {von MW 01/2000}
    else if z=keypgdn then    {Sprung um 10 Jahre mittels Bild runter}
      begin
      if jj<11 then jj:= 1
      else jj:=max(1,jj-10);       {von MW 01/2000}
      end
    else if z=keyhome then    {Sprung um 100 Jahre mittels Pos1}
      jj:=min(maxcalendar,jj+100)    {von MW 01/2000}
    else if z=keyend then    {Sprung um 100 Jahre mittels Ende}
      begin
      if jj<101 then jj:= 1
      else jj:=max(1,jj-100);      {von MW 01/2000}
      end
    else if z=keyins then     {Sprung um 1000 Jahre mittels Einfg}
      jj:=min(maxcalendar,jj+1000)   {von MW 01/2000}
    else if z=keydel then     {Sprung um 1000 Jahre mittels Entf}
      begin
      if jj<1001 then jj:= 1
      else jj:=max(1,jj-1000);     {von MW 01/2000}
      end
    else if z=keyleft then begin
      mm:=pred(mm);
      if mm=0 then begin
        mm:=12; jj:=max(1,pred(jj));   {Erweiterung von 1583 auf 1 von MW 01/2000}
        end;
      end
    else if z=keyrght then begin
      mm:=succ(mm);
      if mm=13 then begin
        mm:=1; jj:=min(maxcalendar,succ(jj));  {Erweiterung von 2999 auf 3000 von MW 01/2000}
        end;
      end
    else if (z=key0) or (z=key1) then begin
        attrtxt(col.colutihigh);
        moff;
        gotoxy(rx+4,ry+1);
        di:=key2str(z);               {Jetzt kann der Kalender auch durch }
        write(cal,' ',di,'      ');
        repeat                        {freies Eingeben des Monats + Jahres }
          get(z,curoff);              {bedient werden}
          di:=di+key2str(z);
          gotoxy(rx+4,ry+1);
          write(cal,' ',di,'     ');
        until Length(di)=2;           {Erweiterung von MW 04/2000}
        val(di,mm,code);
        di:='';
        gotoxy(rx+4,ry+1);
        write(cal,' ',mm:2,'/',di,'   ');
        repeat
          get(z,curoff);
          di:=di+key2str(z);
          gotoxy(rx+4,ry+1);
          write(cal,' ',mm:2,'/',di,'   ');
        until Length(di)=4;
        val(di,jj,code);
        di:='';
        if mm>12 then mm:=12;
        if mm=0 then mm:=1;
        if jj>maxcalendar then jj:=maxcalendar;
        if jj=0 then jj:=1;
        mon;
        attrtxt(col.colutility);     { }
       end;
  until (z=keyesc) or (z=keycr)or (z=keyaltk);
  closebox;
  pophp;
  cal_active:=false;
end;

function xpspace1(dir:dirstr):longint;
var sr  : searchrec;
    sum : longint;
begin
  mon;
  sum:=0;
  findfirst(dir+WildCard,ffAnyFile,sr);
  while doserror=0 do begin
    inc(sum,sr.size);
    if sum<0 then sum:=maxlongint;
    findnext(sr);
  end;
  FindClose(sr);
  xpspace1:=sum;
  moff;
end;

function xpspace2(dir:dirstr):integer64;
var sr  : searchrec;
    sum : integer64;
begin
  mon;
  sum:=0;
  findfirst(dir+WildCard,ffAnyFile,sr);
  while doserror=0 do begin
    sum:=sum+sr.size;    
    findnext(sr);
  end;
  FindClose(sr);
  xpspace2:=sum;
  moff;
end;

procedure xpspace(big,nt:boolean);
const rnr = 500;
var space:longint;
begin
  if (big=false) then write((xpspace1('')+xpspace1(FidoDir)+xpspace1(InfileDir)+
              xpspace1(XferDir)) / $100000:9:1,' MB')
  else if (nt=false) then 
    write((xpspace2('')+xpspace2(FidoDir)+xpspace2(InfileDir)+
              xpspace2(XferDir)) / $100000:9:1,' MB')
  else  
    write((xpspace2('')+xpspace2(FidoDir)+xpspace2(InfileDir)+
              xpspace2(XferDir)) / $100000:9:0,' MB');
end;

procedure writever(os2,win,lnx:boolean; x,y:byte);
begin
  gotoxy(x,y);
   if os2 then begin
     case (lo(dosversion)div 10) of
       1: write(lo(dosversion)div 10:2,'.',hi(dosversion));
       2: write('OS/2 Warp ',hi(dosversion)/10:3:1)
     end;
   end  
  else if lnx then write(DOSEmuVersion)  
  else begin
    if not DOSBOX then write(lo(dosversion):2,'.',formi(hi(dosversion),2));
    if win then begin
      gotoxy(x+1,y+1);
      case WinVersion of        
        2: write(hi(TrueWinVersion),'.',formi(lo(TrueWinVersion),2));
        3:   if (lo(TrueWinVersion)<5) then Write(GetRes2(20000,3)) else
             begin
               case lo(dosversion) of
                  7: Write(GetRes2(20000,4));
                  8: Write(GetRes2(20000,5))
               end; 
             end;
        4:   if Lo(WinNTVersion) = 0 then
   	       begin
                 Write(GetRes2(20201,WinNTVersion shr 16));
                 attrtxt(col.colmboxhigh);
                 gotoxy(x+24,y+1);
                 Write('XP_NTVDM.DLL');
                 attrtxt(col.colmbox);
                 Write(' not found.');
               end
	     else
             begin
	       if lo(WinNTVersion) in [5,6] then
               begin
                 if Hi(WinNTVersion) = 0 then
	           Write(GetRes2(20200,5))	{ 'Windows 2000' }
                 else
	           Write(GetRes2(20200,6))	{ 'Windows XP' }
	       end else
	         Write(GetRes2(20200,1));	{ 'Windows NT' }
	       Write(' [',lo(WinNTversion),'.',
                 hi(WinNTversion),'.',Winntversion shr 16,']');
               attrtxt(col.colmboxhigh);
               gotoxy(x+24,y+1);
               Write('XP_NTVDM.DLL Rev. ');
               attrtxt(col.colmbox);
               Write(xp_ntvdm_ver:2) 
	     end;
      end;
    end;
  end;
end;

procedure memstat;

const rnr = 500;
      bighd = $7FF00000;
type so = record
            o,s : word;
          end;
var regs : registers;
    x,y  : byte;
    ems  : longint;
    xms  : word;
    os2  : boolean;
    win  : boolean;
    lnx  : boolean;    
    ntdk : longint;
begin
  win:=(WinVersion>0);
  msgbox(70,iif(win,17,16),getres2(rnr,1),x,y);
  attrtxt(col.colmboxhigh);
  moff;
  wrt(x+4,y+2,xp_xp+' '+verstr+betastr);
  {$IFDEF Snapshot}
    wrt(x+44,y+2,'Snapshot: '+compiletime);
  {$ENDIF}
  wrt(x+22,y+4,'DOS-RAM      EMS         XMS        '+
               right('     '+getres2(rnr,8)+' '+left(ownpath,2),8));
  wrt(x+4,y+6,getres2(rnr,2));   { gesamt }
  wrt(x+4,y+7,xp_display);       { FreeXP }
  wrt(x+4,y+8,getres2(rnr,4));   { frei }
  wrt(x+4,y+9,getres2(rnr,6));   { verfgbar }
  os2:=lo(dosversion)>=10;
  lnx:=DOSEmuVersion <> '';
  if NOT DOSBOX then  
  wrt(x+4,y+11,iifs(os2,'OS/2',iifs(lnx,'Dosemu','DOS'))+getres2(rnr,7)) else   { -Version }
  wrt(x+4,y+11,'DOSBOX');
  if win then
    wrt(x+4,y+12,'Windows'+getres2(rnr,7));
  attrtxt(col.colmbox);
  intr($12,regs);
  gotoxy(x+22,y+6); write(regs.ax:4,' KB');
  gotoxy(x+22,y+7); write((so(heapptr).s-prefixseg) div 64:4,' KB');
  gotoxy(x+22,y+8); write(memavail div 1024:4,' KB');
  gotoxy(x+22,y+9); write(regs.ax - prefixseg div 64 - 42:4,' KB');
  if emstest then
  begin
    gotoxy(x+32,y+6);
    write(longint(emstotal)*16:5,' KB');
    ems:=0;
    if (OvrEmshandle<>0) and (OvrEmsHandle<>$ffff) then
      inc(ems,EmsHandlePages(OvrEmshandle)*16);
    if dbEMShandle<>0 then inc(ems,EmsHandlePages(dbEMShandle)*16);
    inc(ems,resemspages*16);
    gotoxy(x+32,y+7); write(ems:5,' KB');
    gotoxy(x+32,y+8); write(emsavail*16:5,' KB');
  end;
  if xmstest then begin
    gotoxy(x+44,y+6); write(xmstotal:5,' KB');     
    xms:=ovrmemsize;
    gotoxy(x+44,y+7); write(xms:5,' KB');
    gotoxy(x+44,y+8); write(xmsavail:5,' KB');
    end;
  gotoxy(x+57,y+6);
  if xp_ntvdm_ok then
  begin
    ntdk:=NTDiskSize(0);
    if ntdk>0 then
    begin
      if ntdk<99999 then
        write(ntdk:6,' MB')
      else begin
        ntdk:=ntdk DIV $400;
        if ntdk<99999 then
          write(ntdk:6,' GB')
        else begin
           ntdk:=ntdk DIV $400;
           write(ntdk:6,' TB');
        end;
      end;
    end
    else write(getres2(rnr,16));    { 'ber 2 PB' }
    gotoxy(x+54,y+7);
    xpspace(true,true);
  end
  else begin
    if (fileio.disksize(0))<bighd then
      write((fileio.disksize(0)) / $100000:6:1,' MB')
    else
      write(getres2(rnr,11));     { 'ber 2 GB' }
    gotoxy(x+54,y+7); 
    xpspace(fileio.disksize(0)>bighd,false);
  end;
  gotoxy(x+57,y+8);
  write(diskfree_string(0));
  WriteVer(os2,win,lnx,x+22,y+11);
  attrtxt(col.colmboxhigh);
  wrt(x+4,y+iif(win,14,13),'Overlay');
  attrtxt(col.colmbox);
  gotoxy(x+23,y+iif(win,14,13));
  if ((xmsovrbuf=true) and (emsovrbuf=false)) then write('XMS') else
  if ((xmsovrbuf=false) and (emsovrbuf=true)) then write('EMS') else
  if ((xmsovrbuf=false) and (emsovrbuf=false)) then write('Disk') else
  if ((xmsovrbuf=true) and (emsovrbuf=true)) then write('ERROR');
  wrt(x+62-length(getres2(rnr,9)),y+iif(win,14,13),getres2(rnr,9)+'...');
  mon;
  freeres;
  wait(curon);
  closebox;
end;


{ USER.EB1 - Fragmentstatistik, nur deutsche Version }

procedure fragstat;
var x,y         : byte;
    i           : integer;
    fsize,anz,
    gsize,n,sum : longint;
begin
  msgbox(60,12,'Fragmentierung der User-Zusatzdatei',x,y);
  mwrt(x+5,y+2,'Gre   Anzahl   Bytes        Gre   Anzahl   Bytes');
  n:=0; sum:=0;
  for i:=0 to 9 do begin
    dbGetFrag(ubase,i,fsize,anz,gsize);
    gotoxy(x+2+(i div 5)*30,y+4+ i mod 5);
    moff;
    write(fsize:7,anz:8,gsize:9);
    mon;
    inc(n,anz); inc(sum,gsize);
    end;
  mwrt(x+4,y+10,'gesamt:  '+strs(sum)+' Bytes in '+strs(n)+' Fragmenten');
  wait(curoff);
  closebox;
end;


procedure ScsEscape;
begin
  pushkey(keyesc);
end;


{ Screen Saver }

procedure TimedScsaver(endtime:datetimest);

const maxstars = 40;
      scactive : boolean = false;

var c       : char;
{$IFDEF BP }
    kstat   : word;
    p       : pointer;
{$ELSE }
    p       : scrptr;
{$ENDIF }
    mattr   : byte;
    star    : array[1..maxstars] of record
                  x,y,state,xs : byte;
                end;
    et      : boolean;
    endflag : boolean;
    mborder : byte;

  function scpassword:boolean;
  var mt : boolean;
  begin
    mon;
    mt:=m2t; m2t:=false;
    zaehler[5]:=30;
    zaehlproc[5]:=ScsEscape;
    scpassword:=password;
    zaehlproc[5]:=nil;
    zaehler[5]:=0;
    m2t:=mt; attrtxt(7);
    moff;
  end;

  function endss:boolean;
  begin
    if ((keypressed
{$IFDEF BP }
    or (kstat<memw[$40:$17])
{$ENDIF }
    ) and (et or not ss_passwort or scpassword))
       or (time>=endtime) then begin
      endflag:=true;
      endss:=true;
      end
    else
      endss:=false;
  end;

  procedure sdelay(n:word);
  var t:longint;
  begin
    n:=n div (screenlines*2);
    { weil das innere delay wg. ticker von 10 ms auf 50 ms gendert wurde }

    t:=ticker;
    while (n>0) and not endss do begin
      if ParWintime=1 then begin
        while t=ticker do mdelay(0); { mdelay(50) geht nicht wg. multi2 }
        if t<ticker then inc(t) else t:=ticker;
      end
      else delay(50);
      dec(n);
    end;
  end;

{$IFDEF BP }
  procedure scrollout;
  var i : integer;
  begin
    if softsaver then
      for i:=1 to vlines do begin
        Move(mem[base:0],mem[base:160],(vlines-1)*160);
        if i=1 then wrt(1,1,sp(80));
          delay(10);
        end
    else
      clrscr;
  end;

  procedure scrollin;
  var i : integer;
  begin
    if SoftSaver then
      for i:=vlines-1 downto 0 do begin
        Move(p^,mem[base:i*160],(vlines-i)*160);
          delay(5);
        end
    else
      Move(p^,mem[base:0],vlines*160);
  end;
{$ENDIF }

  procedure showstars;
  const xx : boolean = true;
  var ss : boolean;
      i  : integer;
  begin
    if BlackSaver then exit;
    ss:=false;
    if color then textcolor(3);
    for i:=1 to maxstars do
      with star[i] do
        if state>0 then begin
          if (state<>6) or (random<0.1) then begin
            dec(state);
            if state=xs then state:=1;
            if (state<6) and (state>0) then textcolor(15);
            case state of
              5 : wrt(x,y,'');
              4 : wrt(x,y,'');
              3 : wrt(x,y,^H);
              2 : wrt(x,y,^O);
              1 : wrt(x,y,' ');
            end;
            if random>0.3 then
              if color then textcolor(3)
              else textcolor(7);
            if state=0 then xx:=true;
            end;
        end
        else if not ss then begin
          ss:=true;
          x:=random(78)+2;
          y:=random(vlines)+1;
          wrt(x,y,'');
          state:=random(40)+8;
          if random>=0.2 then xs:=3
          else xs:=random(5)+1;
          end;
    textcolor(7);
  end;

  function topen:boolean;
  begin
    tempopen;
    topen:=true;
  end;

  procedure ShowResttime;
  var t : longint;
  begin
    if BlackSaver then exit;
    t:=timediff(endtime,time)+1;
    if color then attrtxt(8)
    else attrtxt(7);
    wrt(zpz-8,1,' '+formi(t div 3600,2)+':'+formi((t div 60)mod 60,2)+':'+formi(t mod 60,2));
  end;

begin
  if scactive then begin
    initscs;
    exit;
    end;
  mborder:=col.colborder;
  col.colborder:=0;
{$IFDEF BP }
  SetXPborder;
{$ENDIF }
  scactive:=true;
{$IFDEF BP }
  if vesa_dpms and SetVesaDPMS(DPMS_Suspend) then;
{$ENDIF }
  et:=(endtime<'24');
  repeat
    tempclose;
    savecursor;
    moff;
    cursor(curoff);
    textbackground(black);
    textcolor(lightgray);
{$IFDEF BP }
    getmem(p,vrows2*vlines);
    Move(mem[base:0],p^,vrows2*vlines);
    mattr:=textattr;
    scrollout;
{$ELSE }
    Sichern(p);
    ClrScr;
{$ENDIF}

    fillchar(star,sizeof(star),0);
    endflag:=false;
    repeat
{$IFDEF BP }
      kstat:=memw[$40:$17];
{$ENDIF}
      showstars;
      if et then ShowResttime;
      sdelay(200);
    until endflag;

    if keypressed then begin
      c:=readkey;
      if c=#0 then c:=readkey;
      end;
    initscs;
{$IFDEF BP }
    scrollin;
    freemem(p,vrows2*vlines);
    mon;
{$ELSE }
    Holen(p);
{$ENDIF }
    textattr:=mattr;
    restcursor;
  until topen;
  col.colborder:=mborder;
{$IFDEF BP }
  SetXPborder;
  if vesa_dpms and SetVesaDpms(DPMS_On) then;
{$ENDIF }
  scactive:=false;
end;


procedure Scsaver;
begin
  TimedScsaver('99:99:99');
end;


procedure DatabaseStat;
var x,y : byte;

  procedure wrd(yy:byte; datei:pathstr; d:DB);
  var n : boolean;

    function prozent:real;
    begin
      if dbPhysRecs(d)=0 then
        prozent:=100
      else
        prozent:=dbRecCount(d) * 100.0 / dbPhysRecs(d);
    end;

  begin
    n:=(d=nil);
    if n then
      dbOpen(d,datei,0);
    moff;
    wrt(x+3,y+yy,forms(ustr(datei),12));
    write(dbRecCount(d):8,prozent:12:1,'%',
          strsrnp(_filesize(datei+dbExt),13,0));
    mon;
    if n then dbClose(d);
  end;

begin
  msgbox(54,18,getres2(502,1),x,y);    { 'Datenbank' }
  attrtxt(col.colmboxhigh);
  mwrt(x+3,y+2,getres2(502,2));   { 'Datei       Datenstze   Ausnutzung      Bytes' }
  attrtxt(col.colmbox);
  wrd(4,MsgFile,mbase);
  wrd(5,BrettFile,bbase);
  wrd(6,UserFile,ubase);
  wrd(7,BoxenFile,nil);
  wrd(8,GruppenFile,nil);
  wrd(9,SystemFile,nil);
  wrd(10,AutoFile,auto);
  wrd(11,PseudoFile,nil);
  wrd(12,BezugFile,bezbase);
  wrd(13,MimetFile,mimebase);
  mwrt(x+3,y+15,getres(12));    { 'Taste drcken...' }
  wait(curon);
  closebox;
  freeres;
end;


procedure ScreenShot;
const ss_active : boolean = false;
var fn,ffn : pathstr;
    app    : boolean;
    x,y  : integer;
    brk    : boolean;
    t      : text;
    useclip: boolean;
label ende;
begin
  if ss_active then exit
  else ss_active:=true;
  fn:='';
  pushhp(13604);
  useclip:=true;
  if ReadFilename(getres(503),fn,true,useclip) then begin   { 'Bildschirm-Auszug' }
    if not useclip and not multipos(':\',fn) then
      fn:=ExtractPath+fn;
    if not exist(fn) or useclip then app:=false
    else begin
      ffn:=ustr(fitpath(fn,50));
      app:=not overwrite(ffn,false,brk);
      if brk then goto ende;
      end;
    assign(t,fn);
    if app then append(t)
    else rewrite(t);
    for y:=1 to screenlines do begin
      for x:=1 to 80 do
        { Test auf unsichtbare Zeichen (wenn Vorder- und Hintergrund
          gleich sind) }
        if (mem[base:(2*x-1) + 2*zpz*(y-1)] and $0f) <>
          ((mem[base:(2*x-1) + 2*zpz*(y-1)] and $70) shr 4) then
          write(t,copychr(x,y))
        else
          write(t, ' ');
      writeln(t);
      end;
    message('OK.');
    close(t);
    if UseClip then WriteClipfile(fn)
    else mdelay(500);
    closebox;
  end;
ende:
  pophp;
  ss_active:=false;
end;


{ --- Pawortschutz ------------------------------------------------- }

{ 0 = kein Pawort }

function U8:word;
begin
  u8:=(dbReadUserflag(mbase,8) shr 3) xor
      ((dbReadUserflag(mbase,8) shl 2) and $ffff);
end;

procedure InitPWsystem;
var w : word;
begin
  w:=random($ffff)+1;
  dbWriteUserflag(mbase,8,w);
  dbWriteUserflag(mbase,1,U8);
  dbWriteUserflag(mbase,2,U8);
end;

function ReadPassword(main:boolean):word;
begin
  ReadPassword:=dbReadUserflag(mbase,iif(main,1,2)) xor U8;
end;

procedure WritePassword(main:boolean; p:word);
begin
  dbWriteUserflag(mbase,iif(main,1,2),p xor U8);
  if p<>0 then
    rmessage(504)    { 'Pawort wird gespeichert.' }
  else
    rmessage(505);   { ' Pawort wurde gelscht. ' }
  dbFlushClose(mbase);
  wkey(1,false);
  closebox;
end;

function csum(s:string):word;
var i   : integer;
    sum : longint;
begin
  sum:=0;
  for i:=1 to length(s) do
    inc(sum,i*succ(ord(s[i]))*(ord(s[i])shr 2));
  csum:=sum and $ffff;
end;

function EnterPassword(txt:atext; var brk:boolean):longint;
var x,y : byte;
    s   : string[16];
    t   : taste;

  procedure maus_bearbeiten;
  var xx,yy  : integer;
  begin
    maus_gettext(xx,yy);
    if (xx<x) or (xx>x+26+length(txt)) or (yy<y) or (yy>y+4) then
      if t=mausunleft then
        t:=keycr
      else if t=mausunright then
        t:=keyesc;
  end;

begin
  diabox(27+length(txt),5,'',x,y);
  mwrt(x+3,y+2,txt+':');
  attrtxt(col.coldiainp);
  mwrt(x+6+length(txt),y+2,sp(18));
  s:='';
  brk:=false;
  repeat
    attrtxt(col.coldiainp);
    mwrt(x+7+length(txt),y+2,dup(length(s),'*')+sp(16-length(s)));
    gotoxy(x+7+length(txt+s),y+2);
    get(t,curon);
    if (t>=mausfirstkey) and (t<=mauslastkey) then
      maus_bearbeiten;
    if t=keyesc then brk:=true
    else if (t=keybs) or (t=keyleft) then
      if s='' then errsound
      else dellast(s)
    else if (t=^Y) or (t=keyhome) then
      s:=''
    else if t>=' ' then
      if length(s)<16 then
        s:=s+t
      else
        errsound;
  until (t=keycr) or brk;
  closebox;
  EnterPassword:=iif(brk or (s=''),0,csum(s));
end;

function TestPassword(main,edit:boolean):boolean;
var p   : longint;
    brk : boolean;
begin
  p:=ReadPassword(main);
  if p=0 then
    TestPassword:=true
  else
    TestPassword:=(p=EnterPassword(iifs(edit,getres(506),'')+  { 'Altes ' }
        getres(iif(main,507,iif(edit,508,509))),brk));
                    { 'Hauptpawort' / 'Startpawort' / 'Pawort' }
end;

procedure EditPassword;
var x,y  : byte;
var brk  : boolean;
    p    : word;
    main : boolean;
    typ  : string[15];
    i    : integer;
begin
  msgbox(ival(getres2(510,19)),ival(getres2(510,21))+6,'',x,y);
  moff;
  attrtxt(col.colmboxhigh);
  wrt(x+3,y+1,getres2(510,20));   { 'WARNUNG!' }
  attrtxt(col.colmbox);
  for i:=1 to ival(getres2(510,21)) do
    wrt(x+3,y+2+i,getres2(510,21+i));
  wrt(x+3,wherey+2,getres(12));   { 'Taste drcken... ' }
  mon;
  wait(curon);
  closebox;

  main:=(ReadIt(42,getres2(510,1),            { 'Welches Pawort soll gendert werden?' }
                   getres2(510,2),1,brk)=1);  { ' ^Hauptpawort , ^Startpawort ' }
  if not brk then begin
    typ:=getres(iif(main,507,508));
    if TestPassword(true,main) and
       (main or TestPassword(false,true)) then begin
      p:=EnterPassword(getres2(510,3)+typ,brk);   { 'neues ' }
      if brk then exit;
      if ((p=0) and ((ReadPassword(main)=0) or ReadJN(reps(getres2(510,4),typ),true))) or   { '%s lschen' }
         ((p<>0) and (p=EnterPassword(reps(getres2(510,5),typ),brk)) and not brk)  { '%s wiederholen' }
      then
        WritePassword(main,p)
      else
        if (p<>0) and not brk then
          fehler(getres2(510,6));   { 'abweichende Eingabe' }
      end;
    end
  else
    menurestart:=true;
  freeres;
end;

function Password:boolean;
const pw_active : boolean = false;
var   p,p2      : longint;
begin
  password := false; { zur Sicherheit !! MK 12/99 }
  if pw_active then
    password:=true
  else begin
    pw_active:=true;
    DisableDOS:=true;
    p:=ReadPassword(true);
    if p=0 then p:=ReadPassword(false);
    if p=0 then
      Password:=true
    else if ParPass='*' then begin
      exitscreen(0);
      writeln(hex(p,0));
      runerror:=false;
      halt(0);
      end
    else begin
      p2:=hexval(ParPass);
      if (p2=0) or (p2 <> ((p shl 1) xor p xor (p shr 2) + 20*ival(left(date,2)))
                           xor $ba3e) then
        if ParPasswd='' then
          Password:=TestPassword(false,false)
        else begin
          p:=ReadPassword(false);
          Password:=(p=0) or (p=csum(ParPasswd));
          end
      else begin
        p:=0;
        WritePassword(true,p);
        WritePassword(false,p);
        Password:=true;
        end;
      end;
    DisableDOS:=false;
    pw_active:=false;
    end;
end;


procedure xp32welcome;
var x,y,anz,i : byte;
begin
  anz:=res2anz(511);
  msgbox(62,anz+6,'',x,y);
  moff;
  attrtxt(col.colmboxhigh);
  wrt(x+3,y+2,reps(getreps2(511,1,xp_xp),Verstr+BetaStr));  { 'Willkommen bei %s Version %s!' }
  attrtxt(col.colmbox);
  for i:=2 to anz do
    wrt(x+3,y+2+i,getres2(511,i));
  wrt(x+3,y+anz+4,getres(12));   { 'Taste drcken ...' }
  mon;
  wait(curon);
  closebox;
end;

end.

{
  $Log: xp5.pas,v $
  Revision 1.59  2005/01/01 11:16:30  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.58  2004/05/03 06:18:20  mw
  MW: - Bei DOSBOX keine Versionnummer von DOS zurckgeben.

  Revision 1.57  2004/05/03 06:09:47  mw
  MW: - Korrektur des letzten Commits

  Revision 1.56  2004/05/02 23:41:22  mw
  MW: - Anpassungen an DOSBOX

  Revision 1.55  2004/02/29 05:02:19  mw
  MW: - ISO-Umlaut + Typo korrigiert.

  Revision 1.54  2004/02/28 17:02:54  mw
  MW: - Korrektur letzter Commit.

  Revision 1.53  2004/02/28 12:24:31  mw
  MW: - Kalender geht jetzt bis 4781 (da 4782 neue Korrektur ntig).

  Revision 1.52  2004/01/09 16:18:58  mw
  MW: - Wir haben jetzt 2004!!

  Revision 1.51  2003/09/24 05:58:56  mw
  MW: - Benutze CoPro/CoPro-Emu nur noch wenn bentigt und nicht mehr immer.

  Revision 1.50  2003/09/10 15:21:40  mw
  MW: - Schnheitsfehler beseitigt:
        ("Taste drcken ..." in X/S/S war eine Zeile zu tief, wenn die
        XP_NTVDM.DLL fehlte).

  Revision 1.49  2003/09/04 15:34:03  mw
  MW:
  - Ausbau von X/S/S zur allgemeinen Supporthilfe:
    - X/S/S zeigt jetzt auch die genaue Version
      von FreeXP. Bei der Verwendung von
      Snapshots auch das Snapdatum/Uhrzeit.

  Revision 1.48  2003/08/29 16:54:56  mw
  MW: - OS/2 Versionsverschnerung

  Revision 1.47  2003/08/28 21:41:28  my
  MY:- Die Dateiauswahlbox verwendet fr die Anzeige der freien Restkapa-
       zitt auf dem jeweiligen Laufwerk jetzt dieselbe Routine wie die
       Anzeige unter XPoint/Statistik/Speicher (neue gemeinsam genutzte
       Funktion 'diskfree_string'), statt eigene Brtchen zu backen und
       dadurch zu anderen (und falschen) Ergebnissen zu kommen.

  Revision 1.46  2003/08/24 06:02:29  mw
  MW: - berflssiges dfree entfernt.
        (Durch fileio.diskfree ersetzt)

  Revision 1.45  2003/08/23 17:28:08  my
  MY:- NTDiskFree-Routinen kompakter geschrieben und Redundanzen
       eliminiert, Typos gefixt, Source formatiert

  Revision 1.44  2003/08/20 09:06:03  mw
  MW: - Windows 95/98-Erkennung gefixt.
        Windows 95 wurde manchmal als Windows 98 erkannt.

        Betrifft nur X/S/S.

  Revision 1.43  2003/08/20 07:15:25  mw
  MW: - Benutze jetzt notfalls CoPro-Emu, wenn kein CoPro
        vorhanden ist. Alternativversion von xpspace ist nun
        nicht mehr ntig.

  Revision 1.42  2003/08/20 07:05:41  mw
  MW: - Kopro nur noch dann aktiv, wenn bentigt.

  Revision 1.41  2003/08/20 06:56:57  mw
  MW: - Arg, 386er haben noch nicht zwangslufig einen Numerischen Copro
        Daher jetzt auch alternative xpspace mit Anzeige ber 2 GB.

      - Copro-Routinen berall gekapselt um Non8087-Version zu erlauben.

  Revision 1.40  2003/08/20 06:14:57  mw
  MW: - Kleine Detailarbeit:
        Bei WinNT wird jetzt die Anzeige von Xpspace auf 9:0 getrimmt.
        Sonst immer auf 9:1 .

  Revision 1.39  2003/08/20 05:49:58  mw
  MW: - Anzeigeverschnerung in X/S/S die Zweite:
        Verbraucht FreeXP mehr als 2 GB Plattenplatz so kommt es
        jetzt nicht mehr zu negativen Anzeigewerten, sondern es
        wird dennoch korrekt angezeigt.

      - FreeXP braucht jetzt den 8087 CoPro:
        Die Anzeigeverbesserung machte es notwendig den Datentyp
        Comp (der nur mit CoPro zur Verfgung steht) einzusetzen.

  Revision 1.38  2003/08/20 04:59:11  mw
  MW: - Anzeigeverschnerung in X/S/S die Erste:
        Ist mehr als 2047 MB frei bzw. als gesamten Plattenplatz vorhanden
        so wird jetzt "ber 2 GB" angezeigt.
        (fileio.diskfree und fileio.disksize liefern bei groen Festplatten
        keine negativen Werte!!!)

        Betrifft nicht WinNT,da dort eine andere Routine verwendet wird
        die auch ber 2 GB aufs MegaByte exakt arbeitet.

  Revision 1.37  2003/08/19 10:54:47  mw
  MW: - Wiedereinbau von fileio.disksize

  Revision 1.36  2003/08/18 13:06:52  mw
  MW: - Konsequenter Umbau auf fileio.diskfree (Vorbereitung auf Umstellung
        auf NTDiskFree/NTDiskSize.

  Revision 1.35  2003/08/18 07:30:57  mw
  MW: - Vervollstndigung von NTDiskFree/NTDiskSize
      - XP_NTVDM hat jetzt eine Revisionsnummer
      - Simdisk erlaubt Tests der Rechnereien zur schnen Anzeige
        der ermittelten Werte bei beliebig groen Platten
      - OPENXP_CALL/OPENXP_INIT heit jetzt FREEXP_CALL/FREEXP_INIT

  Revision 1.34  2003/08/17 22:19:18  mw
  MW: - neue Funktionen NTDiskFree/NTDiskSize (zeigen korrekte Diskettengre
        unter WinNT an).
        Achtung: Derzeit nur bis 64 GB und noch nich unbedingt korrekt
                 formatiert.

  Revision 1.33  2003/08/12 07:50:06  mw
  MW: - Korrektur der Erkennung von Win95 gegenber seinen Nachfolgern.
        (Falsche Komponente der Versionnummer wurde getestet).

  Revision 1.32  2003/08/11 14:29:26  mw
  MW: - Erkennungsgrenze Win95 nach Win98 repariert.
      - Windows-Versionsausgabe bei Win3.* repariert.

  Revision 1.31  2003/08/03 23:08:33  my
  MW:- Windows-Versionserkennung verbessert:
       1. Windows 9x-Versionen werden jetzt unter X/S/S mit ihrer
          richtigen Version statt pauschal als "Windows 95/98/Me" erkannt.
       2. Wenn die XP_NTVDM.DLL fehlt und somit unter Windows NT/2000/XP
          keine korrekte Versionserkennung vorgenommen werden kann, dann
          wird unter X/S/S statt der Fehlermeldung "XP_NTVDM.DLL nicht
          gefunden" jetzt pauschal als Version "Windows NT/2000/XP"
          ausgegeben.

  Revision 1.30  2003/08/01 23:18:21  my
  MY:- About-, Beta-, und alle sonstigen Dialoge, Ausgaben und
       Versionsmeldungen auf "FreeXP" umgestellt.

  Revision 1.29  2003/07/30 23:09:50  my
  MY:- Source-Header auf "FreeXP" aktualisiert, einige Detailkorrekturen
       an CVS-Logs vorgenommen und hier und da CVS-Loginfos implementiert.

  Revision 1.28  2003/06/25 17:29:10  tw
  auto-de-branching

  Revision 1.27.2.26  2003/04/26 06:14:11  mw
  MW: - Kalender kann jetzt bis zum Jahr 4000 arbeiten.

      - maximales Jahr ist jetzt ber die Konstante maxcalender festgelegt.

  Revision 1.27.2.25  2003/04/20 12:23:08  mw
  MW: - Rcknahme der nderungen zu XMS-Gesamt (zeigt jetzt wieder den gesamten
        freien XMS)

  Revision 1.27.2.24  2003/04/18 10:48:40  mw
  MW: - Neue Berechnung des XMS-Gesamtspeichers (wir fragen jetzt das CMOS)

  Revision 1.27.2.23  2003/04/16 22:27:23  my
  MY:- "Taste drcken..." bei X/S/S war unter DOS noch eine Zeile zu tief

  Revision 1.27.2.22  2003/04/16 13:48:20  mw
  MW: - Neue Berechnungsmethode fr XMS-Belegung durch Openxp/16
        (In overxms.asm wird die Gre des XMS-Blocks gesichert).

  Revision 1.27.2.21  2003/04/15 14:07:00  mw
  MW: - Korrektur der Hhenberechnung der Ausgabe von X/S/S

  Revision 1.27.2.20  2003/04/13 21:05:31  my
  MY:- Display-Kosmetik und Code-Optimierung (else...).

  Revision 1.27.2.19  2003/04/13 16:06:39  mw
  MW: - Neue Variable emsovrbuf zeigt true, wenn das Overlay im EMS steckt

      - Speicherstatistik zeigt jetzt neuen Punkt Overlay an, der anzeigt
        wo das Overlay residiert.

      Wichtiger Hinweis: Bei Problemen mit XP immer einen kompletten Auszug
                         aus X/S/S mitsenden.

  Revision 1.27.2.18  2003/01/19 08:29:09  mw
  MW: - nderungen bezglich Wiedercompilierbarkeit einer XT-Version entfernt.
        Eine XT-Version von Openxp/16 V3.40 ist nicht mehr mglich !!!

  Revision 1.27.2.17  2003/01/17 18:41:00  mw
  MW: - Make XT-Version compile again (Part 2)

  Revision 1.27.2.16  2003/01/10 22:02:32  my
  MY:- Log-Kosmetik

  Revision 1.27.2.15  2003/01/10 18:11:50  mw
  MW: - Overlaycache im XMS (Default: per Compilerschalter ausgeschaltet).
      - Speicherstatistik zeigt jetzt auch XMS-Belegung an.
      Achtung: Diese Features laufen noch nicht auf jedem Betriebssystem
               stabil!

  Revision 1.27.2.14  2002/03/08 23:40:11  my
  MY:- Registrierungs-, Beta-, "ber OpenXP"- und sonstige Dialoge auf
       OpenXP/16 umgestellt und Copyright-Hinweise sowie Kontakte
       aktualisiert.

  Revision 1.27.2.13  2002/01/04 01:15:45  mk
  - Windows XP wurde unter CrossPoint/Statistik als Windows 2000 angezeigt

  Revision 1.27.2.12  2001/09/16 20:31:21  my
  JG+MY:- Neuer Lesemodus "Reorg." (Lesen ab letzter Reorganisation)

  MY:- Copyright-/Lizenz-Header aktualisiert

  Revision 1.27.2.11  2001/08/05 11:45:35  my
  - added new unit XPOVL.PAS ('uses')

  Revision 1.27.2.10  2001/07/02 18:40:31  cl
  - Better Windows NT/2k/XP detection (needs XP_NTVDM.DLL)
  - Clipboard support under NT/2k/XP (needs XP_NTVDM.DLL)

  Revision 1.27.2.9  2001/06/23 19:14:29  mk
  - erkannte Windows-Version wird als allgemeiner String angezeigt

  Revision 1.27.2.8  2000/12/29 21:58:55  mk
  - Datenbankstatistik ist jetzt genauer

  Revision 1.27.2.7  2000/12/18 09:19:57  mk
  - fehlendes pophp ergaenzt

  Revision 1.27.2.6  2000/12/17 00:14:46  mk
  - optische Korrekturen an der Speicherstatistik

  Revision 1.27.2.5  2000/12/12 11:30:29  mk
  - FindClose hinzugefuegt

  Revision 1.27.2.4  2000/10/20 11:25:06  mk
  - Fix for Bug #116155, Bildschirmauszug fehlerhaft

  Revision 1.27.2.3  2000/08/28 23:35:55  mk
  - LFN in uses hinzugefuegt

  Revision 1.27.2.2  2000/07/24 16:08:10  mk
  - konstanten Versionsstring ausgebaut

  Revision 1.27.2.1  2000/07/01 09:22:57  mk
  - Mailerstringanpassungen

  Revision 1.27  2000/05/29 20:21:41  oh
  -findclose: ifdef virtualpascal nach ifdef ver32 geaendert

  Revision 1.26  2000/05/20 02:07:39  mk
  - 32 Bit/VP: FindFirst/FindNext aus Dos-Unit statta us SysTools verwendet

  Revision 1.25  2000/05/14 15:04:51  hd
  - Anpassungen Linux

  Revision 1.24  2000/05/13 13:31:51  hd
  - XPoint/Statistik/Speicher angepasst (Linux)

  Revision 1.23  2000/05/02 19:14:01  hd
  xpcurses statt crt in den Units

  Revision 1.22  2000/04/21 16:36:30  mk
  - Screensaver funktioniert jetzt auch in den 32 Versionen

  Revision 1.21  2000/04/18 11:23:50  mk
  - AnyFile in ffAnyFile ($3F->$20) ersetzt

  Revision 1.20  2000/04/13 12:48:38  mk
  - Anpassungen an Virtual Pascal
  - Fehler bei FindFirst behoben
  - Bugfixes bei 32 Bit Assembler-Routinen
  - Einige unkritische Memory Leaks beseitigt
  - Einge Write-Routinen durch Wrt/Wrt2 ersetzt
  - fehlende CVS Keywords in einigen Units hinzugefuegt
  - ZPR auf VP portiert
  - Winxp.ConsoleWrite provisorisch auf DOS/Linux portiert
  - Automatische Anpassung der Zeilenzahl an Consolengroesse in Win32

  Revision 1.19  2000/04/06 09:12:46  mk
  MW: - weiteres Update Datumseingabe in Kalender

  Revision 1.18  2000/04/06 09:04:17  mk
  MW: - Datumseingabe in Kalender

  Revision 1.17  2000/04/04 10:33:57  mk
  - Compilierbar mit Virtual Pascal 2.0

  Revision 1.16  2000/03/25 09:03:56  mk
  - xdelay jetzt komplett entfernt

  Revision 1.15  2000/03/16 19:37:07  rb
  Sternhimmel-Screensaver-Delay etwas umgestellt

  Revision 1.14  2000/03/14 22:33:36  rb
  Sternhimmel-Screensaver mit Zeitscheibenfreigabe arbeitet jetzt korrekt

  Revision 1.13  2000/03/14 15:15:40  mk
  - Aufraeumen des Codes abgeschlossen (unbenoetigte Variablen usw.)
  - Alle 16 Bit ASM-Routinen in 32 Bit umgeschrieben
  - TPZCRC.PAS ist nicht mehr noetig, Routinen befinden sich in CRC16.PAS
  - XP_DES.ASM in XP_DES integriert
  - 32 Bit Windows Portierung (misc)
  - lauffaehig jetzt unter FPC sowohl als DOS/32 und Win/32

  Revision 1.12  2000/03/08 22:36:33  mk
  - Bugfixes fr die 32 Bit-Version und neue ASM-Routinen

  Revision 1.11  2000/03/06 08:51:04  mk
  - OpenXP/32 ist jetzt Realitaet

  Revision 1.10  2000/03/04 15:54:43  mk
  Funktion zur DOSEmu-Erkennung gefixt

  Revision 1.9  2000/03/02 18:32:24  mk
  - Code ein wenig aufgeraeumt

  Revision 1.8  2000/03/01 23:49:03  rb
  Rechenzeitfreigabe komplett berarbeitet

  Revision 1.7  2000/03/01 22:30:21  rb
  Dosemu-Erkennung eingebaut

  Revision 1.6  2000/02/21 22:48:01  mk
  MK: * Code weiter gesaeubert

  Revision 1.5  2000/02/15 20:43:36  mk
  MK: Aktualisierung auf Stand 15.02.2000

}
