{ --------------------------------------------------------------- }
{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }
{ (c) 2004-2005 FreeXP, http://www.freexp.de                      }
{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }
{                                                                 }
{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }
{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }
{ --------------------------------------------------------------- }
{ $Id: gendate.pas,v 1.6 2005/01/01 11:16:27 mw Exp $ }
program gendate;

uses dos,crt,typeform;

var t:datetime;
    hund,dow:Word;
    f:text;
    tp:longint;

begin
  Gettime(t.Hour,t.Min,t.Sec,hund);
  Getdate(t.Year,t.Month,t.Day,dow);
  Assign(f,'compdate.pas');
  Rewrite(f);
  writeln(f,'{ --------------------------------------------------------------- }');
  writeln(f,'{ Dieser Quelltext ist urheberrechtlich geschuetzt.               }');
  writeln(f,'{ (c) 2004-2005 FreeXP, http://www.freexp.de                      }');
  writeln(f,'{ CrossPoint ist eine eingetragene Marke von Peter Mandrella.     }');
  writeln(f,'{                                                                 }');
  writeln(f,'{ Die Nutzungsbedingungen fuer diesen Quelltext finden Sie in der }');
  writeln(f,'{ Datei SLIZENZ.TXT oder auf www.crosspoint.de/oldlicense.html.   }');
  writeln(f,'{ --------------------------------------------------------------- }');
  writeln(f,'{ '+#36+'Id: '+#36+' }');
  writeln(f,'unit compdate;');
  writeln(f,'');
  writeln(f,'interface');
  writeln(f,'');
  writeln(f,'const');
  writeln(f,'  comp_YY : string[4] = '''+strs(t.Year)+''';');
  writeln(f,'  comp_MO : string[2] = '''+formi(t.Month,2)+''';');
  writeln(f,'  comp_DD : string[2] = '''+formi(t.Day,2)+''';');
  writeln(f,'  comp_HH : string[2] = '''+formi(t.Hour,2)+''';');
  writeln(f,'  comp_MI : string[2] = '''+formi(t.Min,2)+''';');
  writeln(f,'  comp_SS : string[2] = '''+formi(t.Sec,2)+''';');
  writeln(f,'');
  writeln(f,'implementation');
  writeln(f,'');
  writeln(f,'end.');
  writeln(f,'{');
  writeln(f,'  '+#36+'Log: '+#36);
  writeln(f,'}');
  Packtime(t,tp);  {Zur Sicherheit nochmal ein Touch}
  SetFTime(f,tp);  {auf compdate.pas}
  close(f);
end.
{
  $Log: gendate.pas,v $
  Revision 1.6  2005/01/01 11:16:27  mw
  MW: - Willkommen im Jahr 2005

  Revision 1.5  2004/05/11 13:22:17  mw
  MW: - Vor dem Close noch ein Touch um sicherzustellen, das die gesetzten
        Konstanten mit dem Filedatum bereinstimmen.

  Revision 1.4  2004/05/11 08:39:38  my
  MY:- Umstellung von Konstanten auf initialisierte Konstanten (die kann
       man in den Routinen dann ggf. ndern und bentigt weniger
       redundanten Code, wenn man bei IDE-Compilaten das Dateidatum statt
       des echten Compile-Timestamps verwenden mu).

  Revision 1.3  2004/05/10 22:17:59  my
  MY:- const-Syntax korrigiert ('comp_XX:=<string>' kann doch gar nicht
       funktioniert haben??) ;-)

  Revision 1.2  2004/05/10 20:43:46  my
  MY:- Konstanten comp_MO, comp_DD, comp_HH, comp_MI und comp_SS via
       typeform.strs() ggf. mit Nullen zu zweistelligen Zahlen auffllen
       und allen Konstanten in der erzeugten Unit 'compdate.pas' als
       String zuweisen (damit in den Units, die danach compdate.pas
       verwenden, keine Typumwandlung mehr erforderlich ist).
     - Dateiname 'compdate.pas' jetzt klein schreiben.

  MY:- Hinweise zur Verwendung von gendate.pas/compdate.pas:
       -----------------------------------------------------
       1. gendate.pas wird bei jedem via BUILD.BAT ausgelsten
          Compiliervorgang compiliert, anschlieend im Source-Root
          ausgefhrt und erzeugt eine Unit compdate.pas, die in diversen
          Konstanten, die beliebig zusammengesetzt werden knnen,
          lediglich den Timestamp des aktuell zu erstellenden Compilats
          enthlt.
       2. Da compdate.pas in die jeweiligen Programme (XP, UUZ usw.)
          eingebunden wird, lt sich so der echte Compile-Timestamp
          fest in diese Programme eincompilieren (statt wie bisher den
          Timestamp der erzeugten EXE als Referenz nehmen zu mssen).
          Damit ist gewhrleistet, da auch bei Vernderungen des
          Timestamps der EXE (z.B. beim Entpacken oder Kopieren) das
          Programm in den diversen Ausgaben, Versionsmeldungen usw. immer
          den tatschlichen Compile-Timestamp ausgibt.
       3. Anschlieend werden alle zu einer Distribution gehrenden
          Dateien auf den in compdate.pas enthaltenen Timestamp via
          TOUCH.EXE auf denselben korrekten Compile-Timestamp gesetzt.
       4. Das Ganze funktioniert *nicht* bei (z.B. zu Testzwecken) ber
          die IDE erzeugten Compilaten. Damit diese berhaupt erstellt
          werden knnen, befindet sich im CVS-Repository eine Dummy-Unit
          compdate.pas, die ausschlielich Strings aus Nullen enthlt. Die
          Programme, die compdate.pas benutzen, mssen darauf prfen (z.B.
          "if comp_YY='0000'") und sollten dann wie frher ersatzweise den
          Timestamp der EXE fr die Ausgabe heranziehen.
          GENDATE.EXE sollte daher nie hndisch im Source-Root ausgefhrt
          werden, weil es die bestehende Dummy-Unit berschreiben und die
          oben beschriebene Logik bei IDE-Compilaten dann nicht mehr
          funktionieren wrde. Ggf. sollte nach einem versehentlichen
          Ausfhren von GENDATE.EXE der aktuelle Stand der compdate.pas
          neu vom CVS-Repository bezogen werden.
       5. BUILD.BAT hingegen sichert bei jedem Lauf den Dummy der
          compdate.pas, um ihn am Ende des Compiliervorgangs wieder zu
          restaurieren.

  Revision 1.1  2004/05/03 18:34:04  mw
  MW: - Neue Unit COMPDATE implementiert. Sie erlaubt in Verbindung
        mit Gendate einen 100% zuverlssigen Timestamp beim Compilieren.

}
