/*
 * tscope - thermometer scopt demonstrates a simple web page with real-time graphs
 */
#include <dos.h>
#include <stdio.h>
#include <rtos.h>
#include <sio.h>
#include <string.h>
#include <mem.h>
#include <telnetd.h>
#include <ftpd.h>
#include <httpd.h>
#include <smtpcli.h>
#include <process.h>
#include "webpart.h"

#define EMAILNOTIFY "email.notify"

static void (*old_init)(char *name, char *value);
char emailuserid[255] = "";

/********************************************************************/
/* our_init - used to read TCP.CFG file
 */
static void our_init( char *name, char *value )
{
    int found = 0;

    if ( !stricmp( name, EMAILNOTIFY )) {
        strncpy( emailuserid, value, sizeof( emailuserid));
        emailuserid[ sizeof( emailuserid ) - 1 ] = 0;
        cprintf("Configured email userid to %s\r\n", emailuserid );
        found = 1;
    }

    if ( !found )
        if ( old_init ) (*old_init)( name, value );
}


/********************************************************************/
/* main - setup everything then wait for a keystroke
 */

main()
{
    int temp;
    DWORD dummy;

    rt_init( 100 );
    kdebug = 1 ;
    old_init = usr_init;
    usr_init = our_init;


    sock_init();

    cputs("TSCOPE 1.0\r\n");
    cputs("Copyright (c) 1990, 1999 Erick Engelke\r\n");
    cputs("Press any key to exit\r\n");

    rt_newthread( ftpdthread, 1,4096, 0, "ftpd" );

#define MAXHTTPD 5
    rt_newthread( collector, 1,4096, 0, "collector" );
    for ( temp = 0 ; temp < MAXHTTPD; ++temp )
        rt_newthread( httpdthread, (DWORD)&user_proc, 4096, 0, "httpd worker" );

    while ( 1 ) {
        if ( kbhit() ) break;
        rt_sleep( 250 );
    }
}


