/*
 * Serial I/O Library
 *
 * Copyright (c) 1999, Erick Engelke
 */

#define SIO_PARITY_NONE 0
#define SIO_PARITY_ODD  1
#define SIO_PARITY_EVEN 2

#define SIO_DATABITS7   7
#define SIO_DATABITS8   8

#define SIO_STOPBITS1   1
#define SIO_STOPBITS2   2

/* to define more serial ports, increase this next number *AND* recompile
 * the SIO.C library under ./src
 */
#define MAXSIO 4

extern void sio_init( int com, int port, int irq, int rbufsize, int tbufsize, thread_x *notify, int message );
extern void sio_close( int com );
extern void sio_setup( int com, DWORD baud, int bits, int parity, int stop, BYTE hwflow );
extern void sio_exit (void);

extern int sio_recv_waiting( int com );
extern int sio_tran_waiting( int com );
extern BYTE sio_readbyte( int com );
extern void sio_writebyte( int com, BYTE b );
void sio_msg( int com, int xmit, int recv );
BYTE sio_getmcr (int com);
void sio_setmcr (int com, BYTE mcr);
void sio_setbreak (int com, BYTE brk);
